/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_burst_tagger = R"doc(Sets a burst on/off tag based on the value of the trigger input.

This block takes two inputs, a signal stream on the input stream 0 and a trigger stream of shorts on input stream 1. If the trigger stream goes above 0, a tag with the key \"burst\" will be transmitted as a pmt::PMT_T. When the trigger signal falls below 0, the \"burst\" tag will be transmitted as pmt::PMT_F.


The signal on stream 0 is retransmitted to output stream 0.

Constructor Specific Documentation:

Build a burst tagger gnuradio/blocks.

Args:
    itemsize : itemsize of the signal stream on input 0.)doc";


static const char* __doc_gr_blocks_burst_tagger_burst_tagger_0 = R"doc()doc";


static const char* __doc_gr_blocks_burst_tagger_burst_tagger_1 = R"doc()doc";


static const char* __doc_gr_blocks_burst_tagger_make = R"doc(Sets a burst on/off tag based on the value of the trigger input.

This block takes two inputs, a signal stream on the input stream 0 and a trigger stream of shorts on input stream 1. If the trigger stream goes above 0, a tag with the key \"burst\" will be transmitted as a pmt::PMT_T. When the trigger signal falls below 0, the \"burst\" tag will be transmitted as pmt::PMT_F.


The signal on stream 0 is retransmitted to output stream 0.

Constructor Specific Documentation:

Build a burst tagger gnuradio/blocks.

Args:
    itemsize : itemsize of the signal stream on input 0.)doc";


static const char* __doc_gr_blocks_burst_tagger_set_true_tag = R"doc(For the true burst tag, change the key name to  and a new value of .)doc";


static const char* __doc_gr_blocks_burst_tagger_set_false_tag = R"doc(For the false burst tag, change the key name to  and a new value of .)doc";
