/*
 * Copyright 2024 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_uhd_rfnoc_replay = R"doc(RFNoC Replay Block


This wraps a replay block into GNU Radio.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";

static const char* __doc_gr_uhd_rfnoc_replay_rfnoc_replay_0 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_replay_rfnoc_replay_1 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_replay_make = R"doc(RFNoC Replay Block


This wraps a replay block into GNU Radio.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";

static const char* __doc_gr_uhd_rfnoc_replay_record = R"doc(Record


Begin recording. The offset sets the starting location in memory and the size limits the length of the recording. The flow of data is controlled by upstream RFNoC blocks.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_record_restart = R"doc(Restarts recording from the record offset


This is a shortcut for calling record() again with the same arguments.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_play = R"doc(Play back data.


The offset and size define what data is played back on an output port. It will stream out  bytes of data, starting at memory offset .


The data can be played once or repeated continuously until a stop command is issued. If a time_spec is supplied, it will be placed in the header of the first packet. Typically, this is used to tell a downstream Radio block when to start transmitting the data.


If the data type on the output port is not defined, this function will throw an error.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_stop_playback = R"doc(Stops playback


Halts any currently executing play commands and cancels any other play commands that are waiting to be executed for that output port.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_set_record_type = R"doc(Sets the data type for items in the current record buffer for the given input port.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_set_play_type = R"doc(Sets the data type for items in the current play buffer for the given output port.)doc";

static const char* __doc_gr_uhd_rfnoc_replay_issue_stream_cmd = R"doc(Issue a stream command to the replay block


Issue stream commands to start or stop playback from the configured playback buffer. Supports STREAM_MODE_START_CONTINUOUS to start continuous repeating playback, STREAM_MODE_NUM_SAMPS_AND_DONE to play the given number of samples once, and STREAM_MODE_STOP_CONTINUOUS to stop all playback immediately. If a time_spec is supplied, it is placed in the header of the first packet produced for that command. Commands are queued and executed in order. A STREAM_MODE_STOP_CONTINUOUS command will halt all playback and purge all commands in the queue for a given output port.)doc";

static const char* __doc_gr_uhd_replay_cmd_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_cmd_port_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_cmd_offset_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_cmd_size_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_cmd_time_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_cmd_repeat_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_debug_port_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_mem_fullness_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_mem_size_key = R"doc()doc";

static const char* __doc_gr_uhd_replay_word_size_key = R"doc()doc";
