//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/router/cluster_specifiers/matcher/v3/matcher.proto

package matcherv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ClusterAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ClusterAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ClusterAction with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ClusterActionMultiError, or
// nil if none found.
func (m *ClusterAction) ValidateAll() error {
	return m.validate(true)
}

func (m *ClusterAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetCluster()) < 1 {
		err := ClusterActionValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ClusterActionMultiError(errors)
	}

	return nil
}

// ClusterActionMultiError is an error wrapping multiple validation errors
// returned by ClusterAction.ValidateAll() if the designated constraints
// aren't met.
type ClusterActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterActionMultiError) AllErrors() []error { return m }

// ClusterActionValidationError is the validation error returned by
// ClusterAction.Validate if the designated constraints aren't met.
type ClusterActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterActionValidationError) ErrorName() string { return "ClusterActionValidationError" }

// Error satisfies the builtin error interface
func (e ClusterActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClusterAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterActionValidationError{}

// Validate checks the field values on MatcherClusterSpecifier with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *MatcherClusterSpecifier) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on MatcherClusterSpecifier with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// MatcherClusterSpecifierMultiError, or nil if none found.
func (m *MatcherClusterSpecifier) ValidateAll() error {
	return m.validate(true)
}

func (m *MatcherClusterSpecifier) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetClusterMatcher() == nil {
		err := MatcherClusterSpecifierValidationError{
			field:  "ClusterMatcher",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetClusterMatcher()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, MatcherClusterSpecifierValidationError{
					field:  "ClusterMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, MatcherClusterSpecifierValidationError{
					field:  "ClusterMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClusterMatcher()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return MatcherClusterSpecifierValidationError{
				field:  "ClusterMatcher",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return MatcherClusterSpecifierMultiError(errors)
	}

	return nil
}

// MatcherClusterSpecifierMultiError is an error wrapping multiple validation
// errors returned by MatcherClusterSpecifier.ValidateAll() if the designated
// constraints aren't met.
type MatcherClusterSpecifierMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MatcherClusterSpecifierMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MatcherClusterSpecifierMultiError) AllErrors() []error { return m }

// MatcherClusterSpecifierValidationError is the validation error returned by
// MatcherClusterSpecifier.Validate if the designated constraints aren't met.
type MatcherClusterSpecifierValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MatcherClusterSpecifierValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MatcherClusterSpecifierValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MatcherClusterSpecifierValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MatcherClusterSpecifierValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MatcherClusterSpecifierValidationError) ErrorName() string {
	return "MatcherClusterSpecifierValidationError"
}

// Error satisfies the builtin error interface
func (e MatcherClusterSpecifierValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMatcherClusterSpecifier.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MatcherClusterSpecifierValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MatcherClusterSpecifierValidationError{}
