﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53-recovery-cluster/Route53RecoveryClusterRequest.h>
#include <aws/route53-recovery-cluster/Route53RecoveryCluster_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Route53RecoveryCluster {
namespace Model {

/**
 */
class GetRoutingControlStateRequest : public Route53RecoveryClusterRequest {
 public:
  AWS_ROUTE53RECOVERYCLUSTER_API GetRoutingControlStateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetRoutingControlState"; }

  AWS_ROUTE53RECOVERYCLUSTER_API Aws::String SerializePayload() const override;

  AWS_ROUTE53RECOVERYCLUSTER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the routing control that you want to get
   * the state for.</p>
   */
  inline const Aws::String& GetRoutingControlArn() const { return m_routingControlArn; }
  inline bool RoutingControlArnHasBeenSet() const { return m_routingControlArnHasBeenSet; }
  template <typename RoutingControlArnT = Aws::String>
  void SetRoutingControlArn(RoutingControlArnT&& value) {
    m_routingControlArnHasBeenSet = true;
    m_routingControlArn = std::forward<RoutingControlArnT>(value);
  }
  template <typename RoutingControlArnT = Aws::String>
  GetRoutingControlStateRequest& WithRoutingControlArn(RoutingControlArnT&& value) {
    SetRoutingControlArn(std::forward<RoutingControlArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_routingControlArn;
  bool m_routingControlArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryCluster
}  // namespace Aws
