/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.extract.ContentExtractor;
import tim.prune.function.filesleuth.extract.XmlFileExtractor;

public class GzipFileExtractor
implements ContentExtractor {
    private final File _file;

    public GzipFileExtractor(File file) {
        this._file = file;
    }

    @Override
    public TrackContents getContents(TimeZone timeZone) {
        if (this._file == null || !this._file.isFile() || !this._file.canRead()) {
            return new TrackContents(timeZone);
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(this._file));){
                return new XmlFileExtractor(gZIPInputStream).getContents(timeZone);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return new TrackContents(timeZone);
        }
    }

    @Override
    public boolean matchesFilter(LocationFilter locationFilter) {
        if (this._file == null || !this._file.isFile() || !this._file.canRead()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(this._file));){
                return new XmlFileExtractor(gZIPInputStream).matchesFilter(locationFilter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

