/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDBNodeList
implements NodeList {
    private long m_listcstate;
    private XDBDocument m_ownerdoc;

    private native long getNumListNative(long var1, long var3);

    private native long getListChildNative(long var1, long var3, long var5);

    private native long getChildTypeNative(long var1, long var3);

    XDBNodeList(long xob, XDBDocument doc) {
        this.m_listcstate = xob;
        this.m_ownerdoc = doc;
    }

    @Override
    public int getLength() {
        int len = (int)this.getNumListNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), this.m_listcstate);
        return len;
    }

    @Override
    public Node item(int index) {
        XDBNode retval;
        long cstate = this.getListChildNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), this.m_listcstate, index);
        if (cstate == 0L) {
            return null;
        }
        long type = this.getChildTypeNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), cstate);
        switch ((int)type) {
            case 1: {
                retval = new XDBElement(this.m_ownerdoc, cstate);
                break;
            }
            case 2: {
                retval = new XDBAttribute(this.m_ownerdoc, cstate);
                break;
            }
            case 3: {
                retval = new XDBText(this.m_ownerdoc, cstate);
                break;
            }
            case 7: {
                retval = new XDBProcInst(this.m_ownerdoc, cstate);
                break;
            }
            case 8: {
                retval = new XDBComment(this.m_ownerdoc, cstate);
                break;
            }
            default: {
                retval = null;
            }
        }
        return retval;
    }
}

