/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;

public class EntityImageDegenerated
implements IEntityImage {
    private final IEntityImage orig;
    private final double delta = 7.0;
    private final HColor backcolor;

    public EntityImageDegenerated(IEntityImage orig, HColor backcolor) {
        this.orig = orig;
        this.backcolor = backcolor;
    }

    @Override
    public boolean isHidden() {
        return this.orig.isHidden();
    }

    @Override
    public HColor getBackcolor() {
        return this.backcolor;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.orig.calculateDimension(stringBounder).delta(14.0, 14.0);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        return this.orig.getMinMax(stringBounder);
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        return this.orig.getInnerPosition(member, stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.orig.drawU(ug.apply(new UTranslate(7.0, 7.0)));
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug.apply(new UTranslate(dim.getWidth() - 7.0, dim.getHeight() - 7.0)).draw(new UEmpty(7.0, 7.0));
    }

    @Override
    public MagneticBorder getMagneticBorder() {
        return new MagneticBorder(){

            @Override
            public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                return EntityImageDegenerated.this.orig.getMagneticBorder().getForceAt(stringBounder, position.move(7.0, 7.0));
            }
        };
    }

    @Override
    public ShapeType getShapeType() {
        return this.orig.getShapeType();
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.orig.getShield(stringBounder);
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return this.orig.getOverscanX(stringBounder);
    }
}

