/* world-face.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from world-face.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgweather/gweather.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;
typedef struct _ClocksWorldFacePrivate ClocksWorldFacePrivate;

#define CLOCKS_TYPE_CONTENT_STORE (clocks_content_store_get_type ())
#define CLOCKS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStore))
#define CLOCKS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))
#define CLOCKS_IS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_IS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_CONTENT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))

typedef struct _ClocksContentStore ClocksContentStore;
typedef struct _ClocksContentStoreClass ClocksContentStoreClass;
enum  {
	CLOCKS_WORLD_FACE_0_PROPERTY,
	CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY,
	CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY,
	CLOCKS_WORLD_FACE_NEW_LABEL_PROPERTY,
	CLOCKS_WORLD_FACE_NUM_PROPERTIES
};
static GParamSpec* clocks_world_face_properties[CLOCKS_WORLD_FACE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_WORLD_TYPE_ROW (clocks_world_row_get_type ())
#define CLOCKS_WORLD_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ROW, ClocksWorldRow))
#define CLOCKS_WORLD_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ROW, ClocksWorldRowClass))
#define CLOCKS_WORLD_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ROW))
#define CLOCKS_WORLD_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ROW))
#define CLOCKS_WORLD_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ROW, ClocksWorldRowClass))

typedef struct _ClocksWorldRow ClocksWorldRow;
typedef struct _ClocksWorldRowClass ClocksWorldRowClass;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;
typedef ClocksContentItem* (*ClocksContentStoreDeserializeItemFunc) (GVariant* v, gpointer user_data);
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define CLOCKS_GEO_TYPE_INFO (clocks_geo_info_get_type ())
#define CLOCKS_GEO_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo))
#define CLOCKS_GEO_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))
#define CLOCKS_GEO_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))

typedef struct _ClocksGeoInfo ClocksGeoInfo;
typedef struct _ClocksGeoInfoClass ClocksGeoInfoClass;
typedef struct _Block12Data Block12Data;
typedef gboolean (*ClocksContentStoreFindFunc) (ClocksContentItem* item, gpointer user_data);
typedef struct _ClocksWorldFaceUseGeolocationData ClocksWorldFaceUseGeolocationData;

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG (clocks_world_location_dialog_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog))
#define CLOCKS_WORLD_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))

typedef struct _ClocksWorldLocationDialog ClocksWorldLocationDialog;
typedef struct _ClocksWorldLocationDialogClass ClocksWorldLocationDialogClass;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block15Data Block15Data;

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef void (*ClocksContentStoreForeachFunc) (ClocksContentItem* item, gpointer user_data);
enum  {
	CLOCKS_WORLD_FACE_SHOW_STANDALONE_SIGNAL,
	CLOCKS_WORLD_FACE_NUM_SIGNALS
};
static guint clocks_world_face_signals[CLOCKS_WORLD_FACE_NUM_SIGNALS] = {0};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

struct _ClocksWorldFace {
	AdwBin parent_instance;
	ClocksWorldFacePrivate * priv;
};

struct _ClocksWorldFaceClass {
	AdwBinClass parent_class;
};

struct _ClocksWorldFacePrivate {
	ClocksButtonMode _button_mode;
	gchar* _new_label;
	ClocksContentStore* locations;
	GtkSortListModel* sorted_locations;
	GSettings* settings;
	GtkWidget* empty_view;
	GtkScrolledWindow* list_view;
	GtkListBox* listbox;
	AdwViewStack* stack;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _Block12Data {
	int _ref_count_;
	ClocksWorldFace* self;
	ClocksGeoInfo* geo_info;
	gpointer _async_data_;
};

struct _ClocksWorldFaceUseGeolocationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksWorldFace* self;
	Block12Data* _data12_;
	ClocksGeoInfo* _tmp0_;
};

struct _Block13Data {
	int _ref_count_;
	ClocksWorldFace* self;
	ClocksWorldLocationDialog* dialog;
};

struct _Block14Data {
	int _ref_count_;
	ClocksWorldFace* self;
	gint64 unixtime;
};

struct _Block15Data {
	int _ref_count_;
	ClocksWorldFace* self;
	GObject* item;
};

static gint ClocksWorldFace_private_offset;
static gpointer clocks_world_face_parent_class = NULL;
static ClocksClockIface * clocks_world_face_clocks_clock_parent_iface = NULL;

VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN GType clocks_world_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldFace, g_object_unref)
VALA_EXTERN GType clocks_content_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentStore, g_object_unref)
static void clocks_world_face_item_activated (ClocksWorldFace* self,
                                       GtkListBox* list,
                                       GtkListBoxRow* row);
VALA_EXTERN GType clocks_world_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldRow, g_object_unref)
VALA_EXTERN GType clocks_world_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldItem, g_object_unref)
VALA_EXTERN ClocksWorldItem* clocks_world_row_get_location (ClocksWorldRow* self);
static void _clocks_world_face_item_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void clocks_world_face_load (ClocksWorldFace* self);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN void clocks_content_store_deserialize (ClocksContentStore* self,
                                       GVariant* variant,
                                       ClocksContentStoreDeserializeItemFunc deserialize_item,
                                       gpointer deserialize_item_target);
VALA_EXTERN ClocksContentItem* clocks_world_item_deserialize (GVariant* location_variant);
static ClocksContentItem* _clocks_world_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                                              gpointer self);
static void clocks_world_face_save (ClocksWorldFace* self);
VALA_EXTERN GVariant* clocks_content_store_serialize (ClocksContentStore* self);
static void clocks_world_face_use_geolocation_data_free (gpointer _data);
static void clocks_world_face_use_geolocation (ClocksWorldFace* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void clocks_world_face_use_geolocation_finish (ClocksWorldFace* self,
                                               GAsyncResult* _res_);
static gboolean clocks_world_face_use_geolocation_co (ClocksWorldFaceUseGeolocationData* _data_);
VALA_EXTERN GType clocks_geo_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksGeoInfo, g_object_unref)
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN ClocksGeoInfo* clocks_geo_info_new (void);
VALA_EXTERN ClocksGeoInfo* clocks_geo_info_construct (GType object_type);
static void __lambda18_ (Block12Data* _data12_,
                  GWeatherLocation* found_location);
VALA_EXTERN ClocksContentItem* clocks_content_store_find (ClocksContentStore* self,
                                              ClocksContentStoreFindFunc func,
                                              gpointer func_target);
static gboolean __lambda19_ (Block12Data* _data12_,
                      ClocksContentItem* l);
VALA_EXTERN gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self,
                                              GWeatherLocation* location);
VALA_EXTERN GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self);
static gboolean ___lambda19__clocks_content_store_find_func (ClocksContentItem* item,
                                                      gpointer self);
VALA_EXTERN ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
VALA_EXTERN ClocksWorldItem* clocks_world_item_construct (GType object_type,
                                              GWeatherLocation* location);
VALA_EXTERN void clocks_world_item_set_automatic (ClocksWorldItem* self,
                                      gboolean value);
VALA_EXTERN void clocks_content_store_add (ClocksContentStore* self,
                               ClocksContentItem* item);
static void ___lambda18__clocks_geo_info_location_changed (ClocksGeoInfo* _sender,
                                                    GWeatherLocation* location,
                                                    gpointer self);
VALA_EXTERN void clocks_geo_info_seek (ClocksGeoInfo* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN void clocks_geo_info_seek_finish (ClocksGeoInfo* self,
                                  GAsyncResult* _res_);
static void clocks_world_face_use_geolocation_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void clocks_world_face_add_location_item (ClocksWorldFace* self,
                                          ClocksWorldItem* item);
VALA_EXTERN gboolean clocks_world_face_location_exists (ClocksWorldFace* self,
                                            GWeatherLocation* location);
VALA_EXTERN void clocks_world_face_add_location (ClocksWorldFace* self,
                                     GWeatherLocation* location);
static void clocks_world_face_real_activate_new (ClocksClock* base);
VALA_EXTERN GType clocks_world_location_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldLocationDialog, g_object_unref)
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN ClocksWorldLocationDialog* clocks_world_location_dialog_new (ClocksWorldFace* world_face);
VALA_EXTERN ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type,
                                                                   ClocksWorldFace* world_face);
static void __lambda22_ (Block13Data* _data13_);
VALA_EXTERN GWeatherLocation* clocks_world_location_dialog_get_selected_location (ClocksWorldLocationDialog* self);
static void ___lambda22__clocks_world_location_dialog_location_added (ClocksWorldLocationDialog* _sender,
                                                               gpointer self);
static void clocks_world_face_reset_view (ClocksWorldFace* self);
VALA_EXTERN ClocksWorldFace* clocks_world_face_new (void);
VALA_EXTERN ClocksWorldFace* clocks_world_face_construct (GType object_type);
static GObject * clocks_world_face_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN ClocksContentStore* clocks_content_store_new (void);
VALA_EXTERN ClocksContentStore* clocks_content_store_construct (GType object_type);
static gint _clocks_world_face___lambda23_ (Block14Data* _data14_,
                                     gconstpointer item1,
                                     gconstpointer item2);
static gint __clocks_world_face___lambda23__gcompare_data_func (gconstpointer a,
                                                         gconstpointer b,
                                                         gpointer self);
static GtkWidget* _clocks_world_face___lambda24_ (ClocksWorldFace* self,
                                           GObject* item);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN ClocksWorldRow* clocks_world_row_new (ClocksWorldItem* location);
VALA_EXTERN ClocksWorldRow* clocks_world_row_construct (GType object_type,
                                            ClocksWorldItem* location);
static void __lambda25_ (Block15Data* _data15_);
VALA_EXTERN void clocks_content_store_remove (ClocksContentStore* self,
                                  ClocksContentItem* item);
static void ___lambda25__clocks_world_row_remove_clock (ClocksWorldRow* _sender,
                                                 gpointer self);
static GtkWidget* __clocks_world_face___lambda24__gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self);
static void _clocks_world_face____lambda26_ (ClocksWorldFace* self,
                                      GObject* obj,
                                      GAsyncResult* res);
static void __clocks_world_face____lambda26__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self);
static void _clocks_world_face___lambda27_ (ClocksWorldFace* self,
                                     guint position,
                                     guint removed,
                                     guint added);
static void __clocks_world_face___lambda27__g_list_model_items_changed (GListModel* _sender,
                                                                 guint position,
                                                                 guint removed,
                                                                 guint added,
                                                                 gpointer self);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
static void _clocks_world_face___lambda28_ (ClocksWorldFace* self);
VALA_EXTERN void clocks_content_store_foreach (ClocksContentStore* self,
                                   ClocksContentStoreForeachFunc func,
                                   gpointer func_target);
static void __lambda29_ (ClocksWorldFace* self,
                  ClocksContentItem* l);
static void ___lambda29__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                     gpointer self);
static void __clocks_world_face___lambda28__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender,
                                                                   gpointer self);
VALA_EXTERN void clocks_clock_activate_new (ClocksClock* self);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
VALA_EXTERN ClocksButtonMode clocks_clock_get_button_mode (ClocksClock* self);
VALA_EXTERN void clocks_clock_set_button_mode (ClocksClock* self,
                                   ClocksButtonMode value);
VALA_EXTERN const gchar* clocks_clock_get_new_label (ClocksClock* self);
static void clocks_world_face_finalize (GObject * obj);
static GType clocks_world_face_get_type_once (void);
static void _vala_clocks_world_face_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_world_face_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
clocks_world_face_get_instance_private (ClocksWorldFace* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWorldFace_private_offset);
}

static void
clocks_world_face_item_activated (ClocksWorldFace* self,
                                  GtkListBox* list,
                                  GtkListBoxRow* row)
{
	ClocksWorldItem* _tmp0_;
	ClocksWorldItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = clocks_world_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (row, CLOCKS_WORLD_TYPE_ROW, ClocksWorldRow));
	_tmp1_ = _tmp0_;
	g_signal_emit (self, clocks_world_face_signals[CLOCKS_WORLD_FACE_SHOW_STANDALONE_SIGNAL], 0, _tmp1_);
}

static void
_clocks_world_face_item_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	clocks_world_face_item_activated ((ClocksWorldFace*) self, _sender, row);
}

static ClocksContentItem*
_clocks_world_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                           gpointer self)
{
	ClocksContentItem* result;
	result = clocks_world_item_deserialize (v);
	return result;
}

static void
clocks_world_face_load (ClocksWorldFace* self)
{
	ClocksContentStore* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "world-clocks");
	_tmp3_ = _tmp2_;
	clocks_content_store_deserialize (_tmp0_, _tmp3_, _clocks_world_item_deserialize_clocks_content_store_deserialize_item_func, NULL);
	_g_variant_unref0 (_tmp3_);
}

static void
clocks_world_face_save (ClocksWorldFace* self)
{
	GSettings* _tmp0_;
	ClocksContentStore* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->locations;
	_tmp2_ = clocks_content_store_serialize (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_value (_tmp0_, "world-clocks", _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static void
clocks_world_face_use_geolocation_data_free (gpointer _data)
{
	ClocksWorldFaceUseGeolocationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksWorldFaceUseGeolocationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
clocks_world_face_use_geolocation (ClocksWorldFace* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ClocksWorldFaceUseGeolocationData* _data_;
	ClocksWorldFace* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksWorldFaceUseGeolocationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_world_face_use_geolocation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_world_face_use_geolocation_co (_data_);
}

static void
clocks_world_face_use_geolocation_finish (ClocksWorldFace* self,
                                          GAsyncResult* _res_)
{
	ClocksWorldFaceUseGeolocationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ClocksWorldFace* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->geo_info);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda19_ (Block12Data* _data12_,
             ClocksContentItem* l)
{
	ClocksWorldFace* self;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (l != NULL, FALSE);
	_tmp0_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (l, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp1_ = _tmp0_;
	result = clocks_geo_info_is_location_similar (_data12_->geo_info, _tmp1_);
	return result;
}

static gboolean
___lambda19__clocks_content_store_find_func (ClocksContentItem* item,
                                             gpointer self)
{
	gboolean result;
	result = __lambda19_ (self, item);
	return result;
}

static void
__lambda18_ (Block12Data* _data12_,
             GWeatherLocation* found_location)
{
	ClocksWorldFace* self;
	ClocksWorldItem* item = NULL;
	ClocksContentStore* _tmp0_;
	ClocksContentItem* _tmp1_;
	ClocksWorldItem* _tmp2_;
	ClocksWorldItem* auto_item = NULL;
	ClocksWorldItem* _tmp3_;
	ClocksWorldItem* _tmp4_;
	ClocksContentStore* _tmp5_;
	ClocksWorldItem* _tmp6_;
	self = _data12_->self;
	g_return_if_fail (found_location != NULL);
	_tmp0_ = self->priv->locations;
	_tmp1_ = clocks_content_store_find (_tmp0_, ___lambda19__clocks_content_store_find_func, _data12_);
	item = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		_g_object_unref0 (item);
		return;
	}
	_tmp3_ = clocks_world_item_new (found_location);
	auto_item = _tmp3_;
	_tmp4_ = auto_item;
	clocks_world_item_set_automatic (_tmp4_, TRUE);
	_tmp5_ = self->priv->locations;
	_tmp6_ = auto_item;
	clocks_content_store_add (_tmp5_, (ClocksContentItem*) _tmp6_);
	_g_object_unref0 (auto_item);
	_g_object_unref0 (item);
}

static void
___lambda18__clocks_geo_info_location_changed (ClocksGeoInfo* _sender,
                                               GWeatherLocation* location,
                                               gpointer self)
{
	__lambda18_ (self, location);
}

static void
clocks_world_face_use_geolocation_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ClocksWorldFaceUseGeolocationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_world_face_use_geolocation_co (_data_);
}

static gboolean
clocks_world_face_use_geolocation_co (ClocksWorldFaceUseGeolocationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data12_ = g_slice_new0 (Block12Data);
	_data_->_data12_->_ref_count_ = 1;
	_data_->_data12_->self = g_object_ref (_data_->self);
	_data_->_data12_->_async_data_ = _data_;
	_data_->_tmp0_ = clocks_geo_info_new ();
	_data_->_data12_->geo_info = _data_->_tmp0_;
	g_signal_connect_data (_data_->_data12_->geo_info, "location-changed", (GCallback) ___lambda18__clocks_geo_info_location_changed, block12_data_ref (_data_->_data12_), (GClosureNotify) block12_data_unref, 0);
	_data_->_state_ = 1;
	clocks_geo_info_seek (_data_->_data12_->geo_info, clocks_world_face_use_geolocation_ready, _data_);
	return FALSE;
	_state_1:
	clocks_geo_info_seek_finish (_data_->_data12_->geo_info, _data_->_res_);
	block12_data_unref (_data_->_data12_);
	_data_->_data12_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
clocks_world_face_add_location_item (ClocksWorldFace* self,
                                     ClocksWorldItem* item)
{
	ClocksContentStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->locations;
	clocks_content_store_add (_tmp0_, (ClocksContentItem*) item);
	clocks_world_face_save (self);
}

gboolean
clocks_world_face_location_exists (ClocksWorldFace* self,
                                   GWeatherLocation* location)
{
	gboolean exists = FALSE;
	guint n = 0U;
	ClocksContentStore* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	exists = FALSE;
	_tmp0_ = self->priv->locations;
	n = g_list_model_get_n_items ((GListModel*) _tmp0_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ClocksWorldItem* l = NULL;
				ClocksContentStore* _tmp3_;
				GObject* _tmp4_;
				ClocksWorldItem* _tmp5_;
				GWeatherLocation* _tmp6_;
				GWeatherLocation* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < n)) {
					break;
				}
				_tmp3_ = self->priv->locations;
				_tmp4_ = g_list_model_get_object ((GListModel*) _tmp3_, (guint) i);
				l = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
				_tmp5_ = l;
				_tmp6_ = clocks_world_item_get_location (_tmp5_);
				_tmp7_ = _tmp6_;
				if (gweather_location_equal (_tmp7_, location)) {
					exists = TRUE;
					_g_object_unref0 (l);
					break;
				}
				_g_object_unref0 (l);
			}
		}
	}
	result = exists;
	return result;
}

void
clocks_world_face_add_location (ClocksWorldFace* self,
                                GWeatherLocation* location)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	if (!clocks_world_face_location_exists (self, location)) {
		ClocksWorldItem* _tmp0_;
		ClocksWorldItem* _tmp1_;
		_tmp0_ = clocks_world_item_new (location);
		_tmp1_ = _tmp0_;
		clocks_world_face_add_location_item (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ClocksWorldFace* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda22_ (Block13Data* _data13_)
{
	ClocksWorldFace* self;
	GWeatherLocation* location = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	self = _data13_->self;
	_tmp0_ = clocks_world_location_dialog_get_selected_location (_data13_->dialog);
	location = _tmp0_;
	_tmp1_ = location;
	if (_tmp1_ != NULL) {
		GWeatherLocation* _tmp2_;
		_tmp2_ = location;
		clocks_world_face_add_location (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gweather_location_get_type (), GWeatherLocation));
	}
	adw_dialog_force_close ((AdwDialog*) _data13_->dialog);
	_g_object_unref0 (location);
}

static void
___lambda22__clocks_world_location_dialog_location_added (ClocksWorldLocationDialog* _sender,
                                                          gpointer self)
{
	__lambda22_ (self);
}

static void
clocks_world_face_real_activate_new (ClocksClock* base)
{
	ClocksWorldFace * self;
	Block13Data* _data13_;
	ClocksWorldLocationDialog* _tmp0_;
	self = (ClocksWorldFace*) base;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = clocks_world_location_dialog_new (self);
	g_object_ref_sink (_tmp0_);
	_data13_->dialog = _tmp0_;
	g_signal_connect_data (_data13_->dialog, "location-added", (GCallback) ___lambda22__clocks_world_location_dialog_location_added, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	adw_dialog_present ((AdwDialog*) _data13_->dialog, (GtkWidget*) self);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
clocks_world_face_reset_view (ClocksWorldFace* self)
{
	GtkWidget* _tmp0_ = NULL;
	ClocksContentStore* _tmp1_;
	AdwViewStack* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->locations;
	if (g_list_model_get_n_items ((GListModel*) _tmp1_) == ((guint) 0)) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->empty_view;
		_tmp0_ = _tmp2_;
	} else {
		GtkScrolledWindow* _tmp3_;
		_tmp3_ = self->priv->list_view;
		_tmp0_ = (GtkWidget*) _tmp3_;
	}
	_tmp4_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp4_, _tmp0_);
}

ClocksWorldFace*
clocks_world_face_construct (GType object_type)
{
	ClocksWorldFace * self = NULL;
	self = (ClocksWorldFace*) g_object_new (object_type, NULL);
	return self;
}

ClocksWorldFace*
clocks_world_face_new (void)
{
	return clocks_world_face_construct (CLOCKS_WORLD_TYPE_FACE);
}

static ClocksPanelId
clocks_world_face_real_get_panel_id (ClocksClock* base)
{
	ClocksPanelId result;
	ClocksWorldFace* self;
	self = (ClocksWorldFace*) base;
	result = CLOCKS_PANEL_ID_WORLD;
	return result;
}

static ClocksButtonMode
clocks_world_face_real_get_button_mode (ClocksClock* base)
{
	ClocksButtonMode result;
	ClocksWorldFace* self;
	self = (ClocksWorldFace*) base;
	result = self->priv->_button_mode;
	return result;
}

static void
clocks_world_face_real_set_button_mode (ClocksClock* base,
                                        ClocksButtonMode value)
{
	ClocksWorldFace* self;
	ClocksButtonMode old_value;
	self = (ClocksWorldFace*) base;
	old_value = clocks_world_face_real_get_button_mode (base);
	if (old_value != value) {
		self->priv->_button_mode = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_face_properties[CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY]);
	}
}

static const gchar*
clocks_world_face_real_get_new_label (ClocksClock* base)
{
	const gchar* result;
	ClocksWorldFace* self;
	const gchar* _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->_new_label;
	result = _tmp0_;
	return result;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ClocksWorldFace* self;
		self = _data14_->self;
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static gint
_clocks_world_face___lambda23_ (Block14Data* _data14_,
                                gconstpointer item1,
                                gconstpointer item2)
{
	ClocksWorldFace* self;
	gint interval1 = 0;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GTimeZone* _tmp2_;
	gint32 offset1 = 0;
	GWeatherLocation* _tmp3_;
	GWeatherLocation* _tmp4_;
	GTimeZone* _tmp5_;
	gint interval2 = 0;
	GWeatherLocation* _tmp6_;
	GWeatherLocation* _tmp7_;
	GTimeZone* _tmp8_;
	gint32 offset2 = 0;
	GWeatherLocation* _tmp9_;
	GWeatherLocation* _tmp10_;
	GTimeZone* _tmp11_;
	gint result;
	self = _data14_->self;
	_tmp0_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (item1, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = gweather_location_get_timezone (_tmp1_);
	interval1 = g_time_zone_find_interval (_tmp2_, G_TIME_TYPE_STANDARD, _data14_->unixtime);
	_tmp3_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (item1, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp4_ = _tmp3_;
	_tmp5_ = gweather_location_get_timezone (_tmp4_);
	offset1 = g_time_zone_get_offset (_tmp5_, interval1);
	_tmp6_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (item2, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp7_ = _tmp6_;
	_tmp8_ = gweather_location_get_timezone (_tmp7_);
	interval2 = g_time_zone_find_interval (_tmp8_, G_TIME_TYPE_STANDARD, _data14_->unixtime);
	_tmp9_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (item2, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp10_ = _tmp9_;
	_tmp11_ = gweather_location_get_timezone (_tmp10_);
	offset2 = g_time_zone_get_offset (_tmp11_, interval2);
	if (offset1 < offset2) {
		result = -1;
		return result;
	}
	if (offset1 > offset2) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
__clocks_world_face___lambda23__gcompare_data_func (gconstpointer a,
                                                    gconstpointer b,
                                                    gpointer self)
{
	gint result;
	result = _clocks_world_face___lambda23_ (self, a, b);
	return result;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ClocksWorldFace* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->item);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda25_ (Block15Data* _data15_)
{
	ClocksWorldFace* self;
	ClocksContentStore* _tmp0_;
	self = _data15_->self;
	_tmp0_ = self->priv->locations;
	clocks_content_store_remove (_tmp0_, (ClocksContentItem*) G_TYPE_CHECK_INSTANCE_CAST (_data15_->item, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
}

static void
___lambda25__clocks_world_row_remove_clock (ClocksWorldRow* _sender,
                                            gpointer self)
{
	__lambda25_ (self);
}

static GtkWidget*
_clocks_world_face___lambda24_ (ClocksWorldFace* self,
                                GObject* item)
{
	Block15Data* _data15_;
	GObject* _tmp0_;
	ClocksWorldRow* row = NULL;
	ClocksWorldRow* _tmp1_;
	ClocksWorldRow* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data15_->item);
	_data15_->item = _tmp0_;
	_tmp1_ = clocks_world_row_new (G_TYPE_CHECK_INSTANCE_CAST (_data15_->item, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	_tmp2_ = row;
	g_signal_connect_data (_tmp2_, "remove-clock", (GCallback) ___lambda25__clocks_world_row_remove_clock, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	result = (GtkWidget*) row;
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return result;
}

static GtkWidget*
__clocks_world_face___lambda24__gtk_list_box_create_widget_func (GObject* item,
                                                                 gpointer self)
{
	GtkWidget* result;
	result = _clocks_world_face___lambda24_ ((ClocksWorldFace*) self, item);
	return result;
}

static void
_clocks_world_face____lambda26_ (ClocksWorldFace* self,
                                 GObject* obj,
                                 GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	clocks_world_face_use_geolocation_finish (self, res);
}

static void
__clocks_world_face____lambda26__gasync_ready_callback (GObject* source_object,
                                                        GAsyncResult* res,
                                                        gpointer self)
{
	_clocks_world_face____lambda26_ ((ClocksWorldFace*) self, source_object, res);
	g_object_unref (self);
}

static void
_clocks_world_face___lambda27_ (ClocksWorldFace* self,
                                guint position,
                                guint removed,
                                guint added)
{
	clocks_world_face_save (self);
	clocks_world_face_reset_view (self);
}

static void
__clocks_world_face___lambda27__g_list_model_items_changed (GListModel* _sender,
                                                            guint position,
                                                            guint removed,
                                                            guint added,
                                                            gpointer self)
{
	_clocks_world_face___lambda27_ ((ClocksWorldFace*) self, position, removed, added);
}

static void
__lambda29_ (ClocksWorldFace* self,
             ClocksContentItem* l)
{
	g_return_if_fail (l != NULL);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (l, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem), "tick");
}

static void
___lambda29__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                gpointer self)
{
	__lambda29_ ((ClocksWorldFace*) self, item);
}

static void
_clocks_world_face___lambda28_ (ClocksWorldFace* self)
{
	ClocksContentStore* _tmp0_;
	GtkListBox* _tmp1_;
	_tmp0_ = self->priv->locations;
	clocks_content_store_foreach (_tmp0_, ___lambda29__clocks_content_store_foreach_func, self);
	_tmp1_ = self->priv->listbox;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}

static void
__clocks_world_face___lambda28__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender,
                                                              gpointer self)
{
	_clocks_world_face___lambda28_ ((ClocksWorldFace*) self);
}

static GObject *
clocks_world_face_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksWorldFace * self;
	Block14Data* _data14_;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	ClocksContentStore* _tmp3_;
	ClocksContentStore* _tmp4_;
	GListModel* _tmp5_;
	GtkCustomSorter* _tmp6_;
	GtkSortListModel* _tmp7_;
	GSettings* _tmp8_;
	GtkListBox* _tmp9_;
	GtkSortListModel* _tmp10_;
	GSettings* _tmp11_;
	ClocksContentStore* _tmp12_;
	ClocksUtilsWallClock* _tmp13_;
	ClocksUtilsWallClock* _tmp14_;
	parent_class = G_OBJECT_CLASS (clocks_world_face_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	_data14_->unixtime = _tmp2_;
	_tmp3_ = clocks_content_store_new ();
	_g_object_unref0 (self->priv->locations);
	self->priv->locations = _tmp3_;
	_tmp4_ = self->priv->locations;
	_tmp5_ = _g_object_ref0 ((GListModel*) _tmp4_);
	_tmp6_ = gtk_custom_sorter_new (__clocks_world_face___lambda23__gcompare_data_func, block14_data_ref (_data14_), block14_data_unref);
	_tmp7_ = gtk_sort_list_model_new (_tmp5_, (GtkSorter*) _tmp6_);
	_g_object_unref0 (self->priv->sorted_locations);
	self->priv->sorted_locations = _tmp7_;
	_tmp8_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp8_;
	_tmp9_ = self->priv->listbox;
	_tmp10_ = self->priv->sorted_locations;
	gtk_list_box_bind_model (_tmp9_, (GListModel*) _tmp10_, __clocks_world_face___lambda24__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	clocks_world_face_load (self);
	_tmp11_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp11_, "geolocation")) {
		clocks_world_face_use_geolocation (self, __clocks_world_face____lambda26__gasync_ready_callback, g_object_ref (self));
	}
	_tmp12_ = self->priv->locations;
	g_signal_connect_object ((GListModel*) _tmp12_, "items-changed", (GCallback) __clocks_world_face___lambda27__g_list_model_items_changed, self, 0);
	clocks_world_face_reset_view (self);
	_tmp13_ = clocks_utils_wall_clock_get_default ();
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "tick", (GCallback) __clocks_world_face___lambda28__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp14_);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return obj;
}

static void
clocks_world_face_class_init (ClocksWorldFaceClass * klass,
                              gpointer klass_data)
{
	clocks_world_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWorldFace_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_face_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_world_face_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY] = g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY] = g_param_spec_enum ("button-mode", "button-mode", "button-mode", CLOCKS_TYPE_BUTTON_MODE, CLOCKS_BUTTON_MODE_NEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_NEW_LABEL_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_NEW_LABEL_PROPERTY] = g_param_spec_string ("new-label", "new-label", "new-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/world-face.ui");
	clocks_world_face_signals[CLOCKS_WORLD_FACE_SHOW_STANDALONE_SIGNAL] = g_signal_new ("show-standalone", CLOCKS_WORLD_TYPE_FACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CLOCKS_WORLD_TYPE_ITEM);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_view", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, empty_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_view", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, list_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "item_activated", G_CALLBACK(_clocks_world_face_item_activated_gtk_list_box_row_activated));
}

static void
clocks_world_face_clocks_clock_interface_init (ClocksClockIface * iface,
                                               gpointer iface_data)
{
	clocks_world_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*) (ClocksClock*)) clocks_world_face_real_activate_new;
	iface->get_panel_id = clocks_world_face_real_get_panel_id;
	iface->get_button_mode = clocks_world_face_real_get_button_mode;
	iface->set_button_mode = clocks_world_face_real_set_button_mode;
	iface->get_new_label = clocks_world_face_real_get_new_label;
}

static void
clocks_world_face_instance_init (ClocksWorldFace * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = clocks_world_face_get_instance_private (self);
	self->priv->_button_mode = CLOCKS_BUTTON_MODE_NEW;
	_tmp0_ = g_strdup (_ ("Add Location"));
	self->priv->_new_label = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_world_face_finalize (GObject * obj)
{
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	_g_free0 (self->priv->_new_label);
	_g_object_unref0 (self->priv->locations);
	_g_object_unref0 (self->priv->sorted_locations);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (clocks_world_face_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_world_face_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldFace), 0, (GInstanceInitFunc) clocks_world_face_instance_init, NULL };
	static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_world_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_world_face_type_id;
	clocks_world_face_type_id = g_type_register_static (adw_bin_get_type (), "ClocksWorldFace", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_world_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
	ClocksWorldFace_private_offset = g_type_add_instance_private (clocks_world_face_type_id, sizeof (ClocksWorldFacePrivate));
	return clocks_world_face_type_id;
}

GType
clocks_world_face_get_type (void)
{
	static gsize clocks_world_face_type_id__once = 0;
	if (g_once_init_enter (&clocks_world_face_type_id__once)) {
		GType clocks_world_face_type_id;
		clocks_world_face_type_id = clocks_world_face_get_type_once ();
		g_once_init_leave (&clocks_world_face_type_id__once, clocks_world_face_type_id);
	}
	return clocks_world_face_type_id__once;
}

static void
_vala_clocks_world_face_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	switch (property_id) {
		case CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_button_mode ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_FACE_NEW_LABEL_PROPERTY:
		g_value_set_string (value, clocks_clock_get_new_label ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_world_face_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	switch (property_id) {
		case CLOCKS_WORLD_FACE_BUTTON_MODE_PROPERTY:
		clocks_clock_set_button_mode ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

