// media/mojo/mojom/capture_handle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CAPTURE_HANDLE_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_CAPTURE_HANDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/capture_handle.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/capture_handle.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/capture_handle.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {








class BLINK_PLATFORM_EXPORT CaptureHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CaptureHandle, T>::value>;
  using DataView = CaptureHandleDataView;
  using Data_ = internal::CaptureHandle_Data;

  template <typename... Args>
  static CaptureHandlePtr New(Args&&... args) {
    return CaptureHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CaptureHandlePtr From(const U& u) {
    return mojo::TypeConverter<CaptureHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CaptureHandle>::Convert(*this);
  }


  CaptureHandle();

  CaptureHandle(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin,
      const ::WTF::String& capture_handle);


  ~CaptureHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CaptureHandlePtr>
  CaptureHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CaptureHandle::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CaptureHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CaptureHandle_UnserializedMessageContext<
            UserType, CaptureHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CaptureHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CaptureHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CaptureHandle_UnserializedMessageContext<
            UserType, CaptureHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CaptureHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> origin;
  
  ::WTF::String capture_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CaptureHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CaptureHandlePtr CaptureHandle::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(capture_handle)
  );
}

template <typename T, CaptureHandle::EnableIfSame<T>*>
bool CaptureHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->capture_handle, other_struct.capture_handle))
    return false;
  return true;
}

template <typename T, CaptureHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.capture_handle < rhs.capture_handle)
    return true;
  if (rhs.capture_handle < lhs.capture_handle)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::CaptureHandle::DataView,
                                         ::media::mojom::blink::CaptureHandlePtr> {
  static bool IsNull(const ::media::mojom::blink::CaptureHandlePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::CaptureHandlePtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::CaptureHandle::origin)& origin(
      const ::media::mojom::blink::CaptureHandlePtr& input) {
    return input->origin;
  }

  static const decltype(::media::mojom::blink::CaptureHandle::capture_handle)& capture_handle(
      const ::media::mojom::blink::CaptureHandlePtr& input) {
    return input->capture_handle;
  }

  static bool Read(::media::mojom::blink::CaptureHandle::DataView input, ::media::mojom::blink::CaptureHandlePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_CAPTURE_HANDLE_MOJOM_BLINK_H_