// services/network/public/mojom/oblivious_http_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/oblivious_http_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-params-data.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-shared-message-ids.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-blink-import-headers.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ObliviousHttpRequestBody::ObliviousHttpRequestBody()
    : content(),
      content_type() {}

ObliviousHttpRequestBody::ObliviousHttpRequestBody(
    const std::string& content_in,
    const WTF::String& content_type_in)
    : content(std::move(content_in)),
      content_type(std::move(content_type_in)) {}

ObliviousHttpRequestBody::~ObliviousHttpRequestBody() = default;

void ObliviousHttpRequestBody::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_type"), this->content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ObliviousHttpRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ObliviousHttpResponse::ObliviousHttpResponse()
    : response_code(),
      headers(),
      response_body() {}

ObliviousHttpResponse::ObliviousHttpResponse(
    int32_t response_code_in,
    ::network::mojom::blink::HttpResponseHeadersPtr headers_in,
    const std::string& response_body_in)
    : response_code(std::move(response_code_in)),
      headers(std::move(headers_in)),
      response_body(std::move(response_body_in)) {}

ObliviousHttpResponse::~ObliviousHttpResponse() = default;

void ObliviousHttpResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_code"), this->response_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_body"), this->response_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ObliviousHttpResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ObliviousHttpPaddingParameters::ObliviousHttpPaddingParameters()
    : add_exponential_pad(),
      exponential_mean(),
      pad_to_next_power_of_two() {}

ObliviousHttpPaddingParameters::ObliviousHttpPaddingParameters(
    bool add_exponential_pad_in,
    uint16_t exponential_mean_in,
    bool pad_to_next_power_of_two_in)
    : add_exponential_pad(std::move(add_exponential_pad_in)),
      exponential_mean(std::move(exponential_mean_in)),
      pad_to_next_power_of_two(std::move(pad_to_next_power_of_two_in)) {}

ObliviousHttpPaddingParameters::~ObliviousHttpPaddingParameters() = default;
size_t ObliviousHttpPaddingParameters::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->add_exponential_pad);
  seed = mojo::internal::WTFHash(seed, this->exponential_mean);
  seed = mojo::internal::WTFHash(seed, this->pad_to_next_power_of_two);
  return seed;
}

void ObliviousHttpPaddingParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "add_exponential_pad"), this->add_exponential_pad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exponential_mean"), this->exponential_mean,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pad_to_next_power_of_two"), this->pad_to_next_power_of_two,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ObliviousHttpPaddingParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ObliviousHttpRequest::ObliviousHttpRequest()
    : relay_url(),
      traffic_annotation(),
      timeout_duration(),
      key_config(),
      resource_url(),
      method(),
      request_body(),
      trust_token_params(),
      padding_params() {}

ObliviousHttpRequest::ObliviousHttpRequest(
    const ::blink::KURL& relay_url_in,
    const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation_in,
    std::optional<::base::TimeDelta> timeout_duration_in,
    const WTF::String& key_config_in,
    const ::blink::KURL& resource_url_in,
    const WTF::String& method_in,
    ObliviousHttpRequestBodyPtr request_body_in,
    ::network::mojom::blink::TrustTokenParamsPtr trust_token_params_in,
    ObliviousHttpPaddingParametersPtr padding_params_in)
    : relay_url(std::move(relay_url_in)),
      traffic_annotation(std::move(traffic_annotation_in)),
      timeout_duration(std::move(timeout_duration_in)),
      key_config(std::move(key_config_in)),
      resource_url(std::move(resource_url_in)),
      method(std::move(method_in)),
      request_body(std::move(request_body_in)),
      trust_token_params(std::move(trust_token_params_in)),
      padding_params(std::move(padding_params_in)) {}

ObliviousHttpRequest::~ObliviousHttpRequest() = default;

void ObliviousHttpRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relay_url"), this->relay_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "traffic_annotation"), this->traffic_annotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout_duration"), this->timeout_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_config"), this->key_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_url"), this->resource_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_body"), this->request_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ObliviousHttpRequestBodyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "padding_params"), this->padding_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ObliviousHttpPaddingParametersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ObliviousHttpRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ObliviousHttpCompletionResult::ObliviousHttpCompletionResult() : tag_(Tag::kNetError) {
  data_.net_error = int32_t();
}

ObliviousHttpCompletionResult::~ObliviousHttpCompletionResult() {
  DestroyActive();
}


void ObliviousHttpCompletionResult::set_net_error(
    int32_t net_error) {
  if (tag_ != Tag::kNetError) {
    DestroyActive();
    tag_ = Tag::kNetError;
  }
  data_.net_error = net_error;
}
void ObliviousHttpCompletionResult::set_outer_response_error_code(
    int32_t outer_response_error_code) {
  if (tag_ != Tag::kOuterResponseErrorCode) {
    DestroyActive();
    tag_ = Tag::kOuterResponseErrorCode;
  }
  data_.outer_response_error_code = outer_response_error_code;
}
void ObliviousHttpCompletionResult::set_inner_response(
    ObliviousHttpResponsePtr inner_response) {
  if (tag_ == Tag::kInnerResponse) {
    *(data_.inner_response) = std::move(inner_response);
  } else {
    DestroyActive();
    tag_ = Tag::kInnerResponse;
    data_.inner_response = new ObliviousHttpResponsePtr(
        std::move(inner_response));
  }
}

void ObliviousHttpCompletionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kNetError:

      break;
    case Tag::kOuterResponseErrorCode:

      break;
    case Tag::kInnerResponse:

      delete data_.inner_response;
      break;
  }
}

bool ObliviousHttpCompletionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char ObliviousHttpClient::Name_[] = "network.mojom.ObliviousHttpClient";

ObliviousHttpClient::IPCStableHashFunction ObliviousHttpClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ObliviousHttpClient>(message.name())) {
    case messages::ObliviousHttpClient::kOnCompleted: {
      return &ObliviousHttpClient::OnCompleted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ObliviousHttpClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ObliviousHttpClient>(message.name())) {
      case messages::ObliviousHttpClient::kOnCompleted:
            return "Receive network::mojom::ObliviousHttpClient::OnCompleted";
    }
  } else {
    switch (static_cast<messages::ObliviousHttpClient>(message.name())) {
      case messages::ObliviousHttpClient::kOnCompleted:
            return "Receive reply network::mojom::ObliviousHttpClient::OnCompleted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ObliviousHttpClient::OnCompleted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ObliviousHttpClient::OnCompleted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ObliviousHttpClientProxy::ObliviousHttpClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ObliviousHttpClientProxy::OnCompleted(
    ObliviousHttpCompletionResultPtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ObliviousHttpClient::OnCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ObliviousHttpCompletionResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ObliviousHttpClient::kOnCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ObliviousHttpClient_OnCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->response)>
      response_fragment(params.message());
  response_fragment.Claim(&params->response);
  mojo::internal::Serialize<::network::mojom::ObliviousHttpCompletionResultDataView>(
      in_response, response_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ObliviousHttpClient.OnCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ObliviousHttpClient::Name_);
  message.set_method_name("OnCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ObliviousHttpClientStubDispatch::Accept(
    ObliviousHttpClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ObliviousHttpClient>(message->header()->name)) {
    case messages::ObliviousHttpClient::kOnCompleted: {
      DCHECK(message->is_serialized());
      internal::ObliviousHttpClient_OnCompleted_Params_Data* params =
          reinterpret_cast<internal::ObliviousHttpClient_OnCompleted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ObliviousHttpClient.0
      bool success = true;
      ObliviousHttpCompletionResultPtr p_response{};
      ObliviousHttpClient_OnCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ObliviousHttpClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompleted(        
        std::move(p_response));
      return true;
    }
  }
  return false;
}

// static
bool ObliviousHttpClientStubDispatch::AcceptWithResponder(
    ObliviousHttpClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ObliviousHttpClient>(message->header()->name)) {
    case messages::ObliviousHttpClient::kOnCompleted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kObliviousHttpClientValidationInfo[] = {
    {base::to_underlying(messages::ObliviousHttpClient::kOnCompleted),
     { &internal::ObliviousHttpClient_OnCompleted_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ObliviousHttpClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ObliviousHttpClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kObliviousHttpClientValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ObliviousHttpRequestBody::DataView, ::network::mojom::blink::ObliviousHttpRequestBodyPtr>::Read(
    ::network::mojom::blink::ObliviousHttpRequestBody::DataView input,
    ::network::mojom::blink::ObliviousHttpRequestBodyPtr* output) {
  bool success = true;
  ::network::mojom::blink::ObliviousHttpRequestBodyPtr result(::network::mojom::blink::ObliviousHttpRequestBody::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success && !input.ReadContentType(&result->content_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ObliviousHttpResponse::DataView, ::network::mojom::blink::ObliviousHttpResponsePtr>::Read(
    ::network::mojom::blink::ObliviousHttpResponse::DataView input,
    ::network::mojom::blink::ObliviousHttpResponsePtr* output) {
  bool success = true;
  ::network::mojom::blink::ObliviousHttpResponsePtr result(::network::mojom::blink::ObliviousHttpResponse::New());
  
      if (success)
        result->response_code = input.response_code();
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadResponseBody(&result->response_body))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ObliviousHttpPaddingParameters::DataView, ::network::mojom::blink::ObliviousHttpPaddingParametersPtr>::Read(
    ::network::mojom::blink::ObliviousHttpPaddingParameters::DataView input,
    ::network::mojom::blink::ObliviousHttpPaddingParametersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ObliviousHttpPaddingParametersPtr result(::network::mojom::blink::ObliviousHttpPaddingParameters::New());
  
      if (success)
        result->add_exponential_pad = input.add_exponential_pad();
      if (success)
        result->exponential_mean = input.exponential_mean();
      if (success)
        result->pad_to_next_power_of_two = input.pad_to_next_power_of_two();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ObliviousHttpRequest::DataView, ::network::mojom::blink::ObliviousHttpRequestPtr>::Read(
    ::network::mojom::blink::ObliviousHttpRequest::DataView input,
    ::network::mojom::blink::ObliviousHttpRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::ObliviousHttpRequestPtr result(::network::mojom::blink::ObliviousHttpRequest::New());
  
      if (success && !input.ReadRelayUrl(&result->relay_url))
        success = false;
      if (success && !input.ReadTrafficAnnotation(&result->traffic_annotation))
        success = false;
      if (success && !input.ReadTimeoutDuration(&result->timeout_duration))
        success = false;
      if (success && !input.ReadKeyConfig(&result->key_config))
        success = false;
      if (success && !input.ReadResourceUrl(&result->resource_url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadRequestBody(&result->request_body))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadPaddingParams(&result->padding_params))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::ObliviousHttpCompletionResult::DataView, ::network::mojom::blink::ObliviousHttpCompletionResultPtr>::Read(
    ::network::mojom::blink::ObliviousHttpCompletionResult::DataView input,
    ::network::mojom::blink::ObliviousHttpCompletionResultPtr* output) {
  using UnionType = ::network::mojom::blink::ObliviousHttpCompletionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNetError: {
      *output = UnionType::NewNetError(input.net_error());
      break;
    }
    case Tag::kOuterResponseErrorCode: {
      *output = UnionType::NewOuterResponseErrorCode(input.outer_response_error_code());
      break;
    }
    case Tag::kInnerResponse: {
      ::network::mojom::blink::ObliviousHttpResponsePtr result_inner_response;
      if (!input.ReadInnerResponse(&result_inner_response))
        return false;

      *output = UnionType::NewInnerResponse(
          std::move(result_inner_response));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void ObliviousHttpClientInterceptorForTesting::OnCompleted(ObliviousHttpCompletionResultPtr response) {
  GetForwardingInterface()->OnCompleted(
    std::move(response)
    );
}
ObliviousHttpClientAsyncWaiter::ObliviousHttpClientAsyncWaiter(
    ObliviousHttpClient* proxy) : proxy_(proxy) {}

ObliviousHttpClientAsyncWaiter::~ObliviousHttpClientAsyncWaiter() = default;






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif