// services/proxy_resolver/public/mojom/proxy_resolver.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_BLINK_H_
#define SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-features.h"  // IWYU pragma: export
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"  // IWYU pragma: export
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-blink-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/sandbox.mojom-blink-forward.h"
#include "services/network/public/mojom/ip_address.mojom-blink.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-blink-forward.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace proxy_resolver::mojom::blink {

class HostResolverRequestClientProxy;

template <typename ImplRefTraits>
class HostResolverRequestClientStub;

class HostResolverRequestClientRequestValidator;


class BLINK_PLATFORM_EXPORT HostResolverRequestClient
    : public HostResolverRequestClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HostResolverRequestClientInterfaceBase;
  using Proxy_ = HostResolverRequestClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HostResolverRequestClientStub<ImplRefTraits>;

  using RequestValidator_ = HostResolverRequestClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HostResolverRequestClient() = default;

  
  virtual void ReportResult(int32_t error, const WTF::Vector<::net::IPAddress>& result) = 0;
};

class ProxyResolverProxy;

template <typename ImplRefTraits>
class ProxyResolverStub;

class ProxyResolverRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyResolver
    : public ProxyResolverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolverInterfaceBase;
  using Proxy_ = ProxyResolverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolverStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetProxyForUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetProxyForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolver() = default;

  
  virtual void GetProxyForUrl(const ::blink::KURL& url, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<ProxyResolverRequestClient> client) = 0;
};

class ProxyResolverRequestClientProxy;

template <typename ImplRefTraits>
class ProxyResolverRequestClientStub;

class ProxyResolverRequestClientRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyResolverRequestClient
    : public ProxyResolverRequestClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolverRequestClientInterfaceBase;
  using Proxy_ = ProxyResolverRequestClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolverRequestClientStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolverRequestClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportResultMinVersion = 0,
    kAlertMinVersion = 0,
    kOnErrorMinVersion = 0,
    kResolveDnsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Alert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolveDns_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolverRequestClient() = default;

  
  virtual void ReportResult(int32_t error, ProxyInfoPtr proxy_info) = 0;

  
  virtual void Alert(const WTF::String& error) = 0;

  
  virtual void OnError(int32_t line_number, const WTF::String& error) = 0;

  
  virtual void ResolveDns(const WTF::String& host, HostResolveOperation operation, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) = 0;
};

class ProxyResolverFactoryProxy;

template <typename ImplRefTraits>
class ProxyResolverFactoryStub;

class ProxyResolverFactoryRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyResolverFactory
    : public ProxyResolverFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolverFactoryInterfaceBase;
  using Proxy_ = ProxyResolverFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolverFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolverFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateResolverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateResolver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolverFactory() = default;

  
  virtual void CreateResolver(const WTF::String& pac_script, ::mojo::PendingReceiver<ProxyResolver> receiver, ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> client) = 0;
};

class ProxyResolverFactoryRequestClientProxy;

template <typename ImplRefTraits>
class ProxyResolverFactoryRequestClientStub;

class ProxyResolverFactoryRequestClientRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyResolverFactoryRequestClient
    : public ProxyResolverFactoryRequestClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolverFactoryRequestClientInterfaceBase;
  using Proxy_ = ProxyResolverFactoryRequestClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolverFactoryRequestClientStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolverFactoryRequestClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportResultMinVersion = 0,
    kAlertMinVersion = 0,
    kOnErrorMinVersion = 0,
    kResolveDnsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Alert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolveDns_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolverFactoryRequestClient() = default;

  
  virtual void ReportResult(int32_t error) = 0;

  
  virtual void Alert(const WTF::String& error) = 0;

  
  virtual void OnError(int32_t line_number, const WTF::String& error) = 0;

  
  virtual void ResolveDns(const WTF::String& host, HostResolveOperation operation, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) = 0;
};



class BLINK_PLATFORM_EXPORT HostResolverRequestClientProxy
    : public HostResolverRequestClient {
 public:
  using InterfaceType = HostResolverRequestClient;

  explicit HostResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportResult(int32_t error, const WTF::Vector<::net::IPAddress>& result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyResolverProxy
    : public ProxyResolver {
 public:
  using InterfaceType = ProxyResolver;

  explicit ProxyResolverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetProxyForUrl(const ::blink::KURL& url, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<ProxyResolverRequestClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyResolverRequestClientProxy
    : public ProxyResolverRequestClient {
 public:
  using InterfaceType = ProxyResolverRequestClient;

  explicit ProxyResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportResult(int32_t error, ProxyInfoPtr proxy_info) final;
  
  void Alert(const WTF::String& error) final;
  
  void OnError(int32_t line_number, const WTF::String& error) final;
  
  void ResolveDns(const WTF::String& host, HostResolveOperation operation, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyResolverFactoryProxy
    : public ProxyResolverFactory {
 public:
  using InterfaceType = ProxyResolverFactory;

  explicit ProxyResolverFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateResolver(const WTF::String& pac_script, ::mojo::PendingReceiver<ProxyResolver> receiver, ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyResolverFactoryRequestClientProxy
    : public ProxyResolverFactoryRequestClient {
 public:
  using InterfaceType = ProxyResolverFactoryRequestClient;

  explicit ProxyResolverFactoryRequestClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportResult(int32_t error) final;
  
  void Alert(const WTF::String& error) final;
  
  void OnError(int32_t line_number, const WTF::String& error) final;
  
  void ResolveDns(const WTF::String& host, HostResolveOperation operation, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT HostResolverRequestClientStubDispatch {
 public:
  static bool Accept(HostResolverRequestClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HostResolverRequestClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HostResolverRequestClient>>
class HostResolverRequestClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HostResolverRequestClientStub() = default;
  ~HostResolverRequestClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverRequestClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverRequestClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyResolverStubDispatch {
 public:
  static bool Accept(ProxyResolver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolver>>
class ProxyResolverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolverStub() = default;
  ~ProxyResolverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyResolverRequestClientStubDispatch {
 public:
  static bool Accept(ProxyResolverRequestClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolverRequestClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolverRequestClient>>
class ProxyResolverRequestClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolverRequestClientStub() = default;
  ~ProxyResolverRequestClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverRequestClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverRequestClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyResolverFactoryStubDispatch {
 public:
  static bool Accept(ProxyResolverFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolverFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolverFactory>>
class ProxyResolverFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolverFactoryStub() = default;
  ~ProxyResolverFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyResolverFactoryRequestClientStubDispatch {
 public:
  static bool Accept(ProxyResolverFactoryRequestClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolverFactoryRequestClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolverFactoryRequestClient>>
class ProxyResolverFactoryRequestClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolverFactoryRequestClientStub() = default;
  ~ProxyResolverFactoryRequestClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverFactoryRequestClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolverFactoryRequestClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HostResolverRequestClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyResolverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyResolverRequestClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyResolverFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyResolverFactoryRequestClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT ProxyInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyInfo, T>::value>;
  using DataView = ProxyInfoDataView;
  using Data_ = internal::ProxyInfo_Data;

  template <typename... Args>
  static ProxyInfoPtr New(Args&&... args) {
    return ProxyInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyInfoPtr From(const U& u) {
    return mojo::TypeConverter<ProxyInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyInfo>::Convert(*this);
  }


  ProxyInfo();

  explicit ProxyInfo(
      WTF::Vector<::net::ProxyChain> proxy_chains);


  ~ProxyInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyInfoPtr>
  ProxyInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyInfo_UnserializedMessageContext<
            UserType, ProxyInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyInfo_UnserializedMessageContext<
            UserType, ProxyInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<::net::ProxyChain> proxy_chains;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProxyInfoPtr ProxyInfo::Clone() const {
  return New(
      mojo::Clone(proxy_chains)
  );
}

template <typename T, ProxyInfo::EnableIfSame<T>*>
bool ProxyInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proxy_chains, other_struct.proxy_chains))
    return false;
  return true;
}

template <typename T, ProxyInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proxy_chains < rhs.proxy_chains)
    return true;
  if (rhs.proxy_chains < lhs.proxy_chains)
    return false;
  return false;
}


}  // proxy_resolver::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::proxy_resolver::mojom::blink::ProxyInfo::DataView,
                                         ::proxy_resolver::mojom::blink::ProxyInfoPtr> {
  static bool IsNull(const ::proxy_resolver::mojom::blink::ProxyInfoPtr& input) { return !input; }
  static void SetToNull(::proxy_resolver::mojom::blink::ProxyInfoPtr* output) { output->reset(); }

  static const decltype(::proxy_resolver::mojom::blink::ProxyInfo::proxy_chains)& proxy_chains(
      const ::proxy_resolver::mojom::blink::ProxyInfoPtr& input) {
    return input->proxy_chains;
  }

  static bool Read(::proxy_resolver::mojom::blink::ProxyInfo::DataView input, ::proxy_resolver::mojom::blink::ProxyInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_BLINK_H_