// services/video_effects/public/mojom/video_effects_processor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_effects/public/mojom/video_effects_processor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_effects/public/mojom/video_effects_processor.mojom-params-data.h"
namespace video_effects {
namespace mojom {

NOINLINE static const char* PostProcessErrorToStringHelper(PostProcessError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PostProcessError::kUnknown:
      return "kUnknown";
    case PostProcessError::kUnusable:
      return "kUnusable";
    case PostProcessError::kNotReady:
      return "kNotReady";
    default:
      return nullptr;
  }
}

std::string PostProcessErrorToString(PostProcessError value) {
  const char *str = PostProcessErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PostProcessError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PostProcessError value) {
  return os << PostProcessErrorToString(value);
}

namespace internal {
// static
bool PostProcessResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PostProcessResult_Data* object = static_cast<const PostProcessResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PostProcessResult_Tag::kError: {


      if (!::video_effects::mojom::internal::PostProcessError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    case PostProcessResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PostProcessResult");
      return false;
    }
  }
}


// static
bool PostProcessSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PostProcessSuccess_Data* object =
      static_cast<const PostProcessSuccess_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_info, validation_context))
    return false;

  return true;
}

PostProcessSuccess_Data::PostProcessSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEffectsProcessor_PostProcess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEffectsProcessor_PostProcess_Params_Data* object =
      static_cast<const VideoEffectsProcessor_PostProcess_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->input_frame_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->input_frame_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_frame_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_frame_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result_frame_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result_frame_data, validation_context))
    return false;


  if (!::media::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->result_pixel_format, validation_context))
    return false;

  return true;
}

VideoEffectsProcessor_PostProcess_Params_Data::VideoEffectsProcessor_PostProcess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEffectsProcessor_PostProcess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEffectsProcessor_PostProcess_ResponseParams_Data* object =
      static_cast<const VideoEffectsProcessor_PostProcess_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

VideoEffectsProcessor_PostProcess_ResponseParams_Data::VideoEffectsProcessor_PostProcess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_effects

namespace perfetto {

// static
void TraceFormatTraits<::video_effects::mojom::PostProcessError>::WriteIntoTrace(
   perfetto::TracedValue context, ::video_effects::mojom::PostProcessError value) {
  return std::move(context).WriteString(::video_effects::mojom::PostProcessErrorToString(value));
}

} // namespace perfetto