// third_party/blink/public/mojom/input/input_handler.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SelectionGranularityToStringHelper(SelectionGranularity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectionGranularity::kWord:
      return "kWord";
    case SelectionGranularity::kSentence:
      return "kSentence";
    default:
      return nullptr;
  }
}

std::string SelectionGranularityToString(SelectionGranularity value) {
  const char *str = SelectionGranularityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectionGranularity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectionGranularity value) {
  return os << SelectionGranularityToString(value);
}

NOINLINE static const char* PanActionToStringHelper(PanAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PanAction::kNone:
      return "kNone";
    case PanAction::kScroll:
      return "kScroll";
    case PanAction::kMoveCursorOrScroll:
      return "kMoveCursorOrScroll";
    case PanAction::kStylusWritable:
      return "kStylusWritable";
    default:
      return nullptr;
  }
}

std::string PanActionToString(PanAction value) {
  const char *str = PanActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PanAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PanAction value) {
  return os << PanActionToString(value);
}

NOINLINE static const char* FocusStateToStringHelper(FocusState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FocusState::kFocused:
      return "kFocused";
    case FocusState::kNotFocusedAndActive:
      return "kNotFocusedAndActive";
    case FocusState::kNotFocusedAndNotActive:
      return "kNotFocusedAndNotActive";
    default:
      return nullptr;
  }
}

std::string FocusStateToString(FocusState value) {
  const char *str = FocusStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FocusState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FocusState value) {
  return os << FocusStateToString(value);
}

namespace internal {


// static
bool KeyData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const KeyData_Data* object =
      static_cast<const KeyData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unmodified_text, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unmodified_text, validation_context))
    return false;

  return true;
}

KeyData_Data::KeyData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PointerData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PointerData_Data* object =
      static_cast<const PointerData_Data*>(data);


  if (!::blink::mojom::internal::Button_Data
        ::Validate(object->button, validation_context))
    return false;


  if (!::ui::mojom::internal::EventPointerType_Data
        ::Validate(object->pointer_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget_position, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget_position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_position, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_position, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mouse_data, validation_context))
    return false;

  return true;
}

PointerData_Data::PointerData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WheelData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WheelData_Data* object =
      static_cast<const WheelData_Data*>(data);


  if (!::blink::mojom::internal::DispatchType_Data
        ::Validate(object->cancelable, validation_context))
    return false;

  return true;
}

WheelData_Data::WheelData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MouseData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MouseData_Data* object =
      static_cast<const MouseData_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->wheel_data, validation_context))
    return false;

  return true;
}

MouseData_Data::MouseData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollData_Data* object =
      static_cast<const ScrollData_Data*>(data);


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->delta_units, validation_context))
    return false;


  if (!::blink::mojom::internal::InertialPhaseState_Data
        ::Validate(object->inertial_phase, validation_context))
    return false;

  return true;
}

ScrollData_Data::ScrollData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinchBeginData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinchBeginData_Data* object =
      static_cast<const PinchBeginData_Data*>(data);

  return true;
}

PinchBeginData_Data::PinchBeginData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinchUpdateData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinchUpdateData_Data* object =
      static_cast<const PinchUpdateData_Data*>(data);

  return true;
}

PinchUpdateData_Data::PinchUpdateData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinchEndData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinchEndData_Data* object =
      static_cast<const PinchEndData_Data*>(data);

  return true;
}

PinchEndData_Data::PinchEndData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FlingData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FlingData_Data* object =
      static_cast<const FlingData_Data*>(data);

  return true;
}

FlingData_Data::FlingData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TapData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TapData_Data* object =
      static_cast<const TapData_Data*>(data);

  return true;
}

TapData_Data::TapData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TapDownData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TapDownData_Data* object =
      static_cast<const TapDownData_Data*>(data);

  return true;
}

TapDownData_Data::TapDownData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GestureData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GestureData_Data* object =
      static_cast<const GestureData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_position, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget_position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget_position, validation_context))
    return false;


  if (!::blink::mojom::internal::GestureDevice_Data
        ::Validate(object->source_device, validation_context))
    return false;


  if (!::ui::mojom::internal::EventPointerType_Data
        ::Validate(object->primary_pointer_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->contact_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scroll_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pinch_begin_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pinch_update_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pinch_end_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tap_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tap_down_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fling_data, validation_context))
    return false;

  return true;
}

GestureData_Data::GestureData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchPoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TouchPoint_Data* object =
      static_cast<const TouchPoint_Data*>(data);


  if (!::blink::mojom::internal::TouchState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_data, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_data, validation_context))
    return false;

  return true;
}

TouchPoint_Data::TouchPoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TouchData_Data* object =
      static_cast<const TouchData_Data*>(data);


  if (!::blink::mojom::internal::DispatchType_Data
        ::Validate(object->cancelable, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->touches, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& touches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->touches, validation_context,
                                         &touches_validate_params)) {
    return false;
  }

  return true;
}

TouchData_Data::TouchData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Event_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Event_Data* object =
      static_cast<const Event_Data*>(data);


  if (!::blink::mojom::internal::EventType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_latency_metadata, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event_latency_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->key_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pointer_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gesture_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->touch_data, validation_context))
    return false;

  return true;
}

Event_Data::Event_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DidOverscrollParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DidOverscrollParams_Data* object =
      static_cast<const DidOverscrollParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accumulated_overscroll, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accumulated_overscroll, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latest_overscroll_delta, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->latest_overscroll_delta, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_fling_velocity, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->current_fling_velocity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->causal_event_viewport_point, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->causal_event_viewport_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overscroll_behavior, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->overscroll_behavior, validation_context))
    return false;

  return true;
}

DidOverscrollParams_Data::DidOverscrollParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchActionOptional_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TouchActionOptional_Data* object =
      static_cast<const TouchActionOptional_Data*>(data);


  if (!::cc::mojom::internal::TouchAction_Data
        ::Validate(object->touch_action, validation_context))
    return false;

  return true;
}

TouchActionOptional_Data::TouchActionOptional_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EditCommand_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EditCommand_Data* object =
      static_cast<const EditCommand_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

EditCommand_Data::EditCommand_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectAroundCaretResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectAroundCaretResult_Data* object =
      static_cast<const SelectAroundCaretResult_Data*>(data);

  return true;
}

SelectAroundCaretResult_Data::SelectAroundCaretResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data*>(data);


  if (!::cc::mojom::internal::TouchAction_Data
        ::Validate(object->touch_action, validation_context))
    return false;

  return true;
}

WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_SetPanAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_SetPanAction_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_SetPanAction_Params_Data*>(data);


  if (!::blink::mojom::internal::PanAction_Data
        ::Validate(object->pan_action, validation_context))
    return false;

  return true;
}

WidgetInputHandlerHost_SetPanAction_Params_Data::WidgetInputHandlerHost_SetPanAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_DidOverscroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_DidOverscroll_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_DidOverscroll_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WidgetInputHandlerHost_DidOverscroll_Params_Data::WidgetInputHandlerHost_DidOverscroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data*>(data);

  return true;
}

WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_ImeCancelComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_ImeCancelComposition_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_ImeCancelComposition_Params_Data*>(data);

  return true;
}

WidgetInputHandlerHost_ImeCancelComposition_Params_Data::WidgetInputHandlerHost_ImeCancelComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& character_bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->character_bounds, validation_context,
                                         &character_bounds_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& line_bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->line_bounds, validation_context,
                                         &line_bounds_validate_params)) {
    return false;
  }

  return true;
}

WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_SetMouseCapture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_SetMouseCapture_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_SetMouseCapture_Params_Data*>(data);

  return true;
}

WidgetInputHandlerHost_SetMouseCapture_Params_Data::WidgetInputHandlerHost_SetMouseCapture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data*>(data);

  return true;
}

WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data::WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_RequestMouseLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_RequestMouseLock_Params_Data* object =
      static_cast<const WidgetInputHandlerHost_RequestMouseLock_Params_Data*>(data);

  return true;
}

WidgetInputHandlerHost_RequestMouseLock_Params_Data::WidgetInputHandlerHost_RequestMouseLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data* object =
      static_cast<const WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PointerLockResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->context,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  return true;
}

FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data*>(data);


  if (!::ui::mojom::internal::ImeTextSpanType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  return true;
}

FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_text, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement_text, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data::FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_DeleteSurroundingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_DeleteSurroundingText_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_DeleteSurroundingText_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_DeleteSurroundingText_Params_Data::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gesture_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gesture_data, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data::FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data* object =
      static_cast<const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::HandwritingGestureResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data::FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ExecuteEditCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ExecuteEditCommand_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ExecuteEditCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->command, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& command_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->command, validation_context,
                                         &command_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_ExecuteEditCommand_Params_Data::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Undo_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Undo_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Undo_Params_Data::FrameWidgetInputHandler_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Redo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Redo_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Redo_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Redo_Params_Data::FrameWidgetInputHandler_Redo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Cut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Cut_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Cut_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Cut_Params_Data::FrameWidgetInputHandler_Cut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Copy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Copy_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Copy_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Copy_Params_Data::FrameWidgetInputHandler_Copy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_CopyToFindPboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_CopyToFindPboard_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_CopyToFindPboard_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_CopyToFindPboard_Params_Data::FrameWidgetInputHandler_CopyToFindPboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_CenterSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_CenterSelection_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_CenterSelection_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_CenterSelection_Params_Data::FrameWidgetInputHandler_CenterSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Paste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Paste_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Paste_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Paste_Params_Data::FrameWidgetInputHandler_Paste_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Delete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Delete_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Delete_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_Delete_Params_Data::FrameWidgetInputHandler_Delete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SelectAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SelectAll_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_SelectAll_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_SelectAll_Params_Data::FrameWidgetInputHandler_SelectAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_CollapseSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_CollapseSelection_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_CollapseSelection_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_CollapseSelection_Params_Data::FrameWidgetInputHandler_CollapseSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_Replace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_Replace_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_Replace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->word, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->word, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_Replace_Params_Data::FrameWidgetInputHandler_Replace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ReplaceMisspelling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ReplaceMisspelling_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ReplaceMisspelling_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->word, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->word, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_ReplaceMisspelling_Params_Data::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SelectRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SelectRange_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_SelectRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->base, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->base, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extent, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extent, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_SelectRange_Params_Data::FrameWidgetInputHandler_SelectRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data*>(data);


  if (!::blink::mojom::internal::SelectionMenuBehavior_Data
        ::Validate(object->behavior, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SelectAroundCaret_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SelectAroundCaret_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_SelectAroundCaret_Params_Data*>(data);


  if (!::blink::mojom::internal::SelectionGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_SelectAroundCaret_Params_Data::FrameWidgetInputHandler_SelectAroundCaret_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data* object =
      static_cast<const FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data::FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extent, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data*>(data);

  return true;
}

FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data* object =
      static_cast<const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data*>(data);

  return true;
}

FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameWidgetInputHandler_MoveCaret_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameWidgetInputHandler_MoveCaret_Params_Data* object =
      static_cast<const FrameWidgetInputHandler_MoveCaret_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  return true;
}

FrameWidgetInputHandler_MoveCaret_Params_Data::FrameWidgetInputHandler_MoveCaret_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_SetFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_SetFocus_Params_Data* object =
      static_cast<const WidgetInputHandler_SetFocus_Params_Data*>(data);


  if (!::blink::mojom::internal::FocusState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

WidgetInputHandler_SetFocus_Params_Data::WidgetInputHandler_SetFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_MouseCaptureLost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_MouseCaptureLost_Params_Data* object =
      static_cast<const WidgetInputHandler_MouseCaptureLost_Params_Data*>(data);

  return true;
}

WidgetInputHandler_MouseCaptureLost_Params_Data::WidgetInputHandler_MouseCaptureLost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data* object =
      static_cast<const WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->commands, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->commands, validation_context,
                                         &commands_validate_params)) {
    return false;
  }

  return true;
}

WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_CursorVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_CursorVisibilityChanged_Params_Data* object =
      static_cast<const WidgetInputHandler_CursorVisibilityChanged_Params_Data*>(data);

  return true;
}

WidgetInputHandler_CursorVisibilityChanged_Params_Data::WidgetInputHandler_CursorVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_ImeSetComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_ImeSetComposition_Params_Data* object =
      static_cast<const WidgetInputHandler_ImeSetComposition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

WidgetInputHandler_ImeSetComposition_Params_Data::WidgetInputHandler_ImeSetComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_ImeSetComposition_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_ImeSetComposition_ResponseParams_Data* object =
      static_cast<const WidgetInputHandler_ImeSetComposition_ResponseParams_Data*>(data);

  return true;
}

WidgetInputHandler_ImeSetComposition_ResponseParams_Data::WidgetInputHandler_ImeSetComposition_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_ImeCommitText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_ImeCommitText_Params_Data* object =
      static_cast<const WidgetInputHandler_ImeCommitText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

WidgetInputHandler_ImeCommitText_Params_Data::WidgetInputHandler_ImeCommitText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_ImeCommitText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_ImeCommitText_ResponseParams_Data* object =
      static_cast<const WidgetInputHandler_ImeCommitText_ResponseParams_Data*>(data);

  return true;
}

WidgetInputHandler_ImeCommitText_ResponseParams_Data::WidgetInputHandler_ImeCommitText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_ImeFinishComposingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_ImeFinishComposingText_Params_Data* object =
      static_cast<const WidgetInputHandler_ImeFinishComposingText_Params_Data*>(data);

  return true;
}

WidgetInputHandler_ImeFinishComposingText_Params_Data::WidgetInputHandler_ImeFinishComposingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_RequestTextInputStateUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_RequestTextInputStateUpdate_Params_Data* object =
      static_cast<const WidgetInputHandler_RequestTextInputStateUpdate_Params_Data*>(data);

  return true;
}

WidgetInputHandler_RequestTextInputStateUpdate_Params_Data::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_RequestCompositionUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_RequestCompositionUpdates_Params_Data* object =
      static_cast<const WidgetInputHandler_RequestCompositionUpdates_Params_Data*>(data);

  return true;
}

WidgetInputHandler_RequestCompositionUpdates_Params_Data::WidgetInputHandler_RequestCompositionUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_DispatchEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_DispatchEvent_Params_Data* object =
      static_cast<const WidgetInputHandler_DispatchEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WidgetInputHandler_DispatchEvent_Params_Data::WidgetInputHandler_DispatchEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_DispatchEvent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_DispatchEvent_ResponseParams_Data* object =
      static_cast<const WidgetInputHandler_DispatchEvent_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::InputEventResultSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_latency, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->updated_latency, validation_context))
    return false;


  if (!::blink::mojom::internal::InputEventResultState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->overscroll, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->touch_action, validation_context))
    return false;

  return true;
}

WidgetInputHandler_DispatchEvent_ResponseParams_Data::WidgetInputHandler_DispatchEvent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_DispatchNonBlockingEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_DispatchNonBlockingEvent_Params_Data* object =
      static_cast<const WidgetInputHandler_DispatchNonBlockingEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WidgetInputHandler_DispatchNonBlockingEvent_Params_Data::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_WaitForInputProcessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_WaitForInputProcessed_Params_Data* object =
      static_cast<const WidgetInputHandler_WaitForInputProcessed_Params_Data*>(data);

  return true;
}

WidgetInputHandler_WaitForInputProcessed_Params_Data::WidgetInputHandler_WaitForInputProcessed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data* object =
      static_cast<const WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data*>(data);

  return true;
}

WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data* object =
      static_cast<const WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->interface_request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->interface_request,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WidgetInputHandler_UpdateBrowserControlsState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WidgetInputHandler_UpdateBrowserControlsState_Params_Data* object =
      static_cast<const WidgetInputHandler_UpdateBrowserControlsState_Params_Data*>(data);


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->constraints, validation_context))
    return false;


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->current, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->offset_tag_modifications, validation_context))
    return false;

  return true;
}

WidgetInputHandler_UpdateBrowserControlsState_Params_Data::WidgetInputHandler_UpdateBrowserControlsState_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SelectionGranularity>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SelectionGranularity value) {
  return std::move(context).WriteString(::blink::mojom::SelectionGranularityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PanAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PanAction value) {
  return std::move(context).WriteString(::blink::mojom::PanActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FocusState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FocusState value) {
  return std::move(context).WriteString(::blink::mojom::FocusStateToString(value));
}

} // namespace perfetto