// ui/display/mojom/display_snapshot.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display_snapshot.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_snapshot.mojom-params-data.h"
namespace display {
namespace mojom {

namespace internal {


// static
bool DisplaySnapshotColorInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DisplaySnapshotColorInfo_Data* object =
      static_cast<const DisplaySnapshotColorInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->edid_primaries, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->edid_primaries, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hdr_static_metadata, validation_context))
    return false;

  return true;
}

DisplaySnapshotColorInfo_Data::DisplaySnapshotColorInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DisplaySnapshot_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DisplaySnapshot_Data* object =
      static_cast<const DisplaySnapshot_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->physical_size, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->physical_size, validation_context))
    return false;


  if (!::display::mojom::internal::DisplayConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path_topology, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_topology_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path_topology, validation_context,
                                         &path_topology_validate_params)) {
    return false;
  }


  if (!::display::mojom::internal::PrivacyScreenState_Data
        ::Validate(object->privacy_screen_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_info, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sys_path, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sys_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modes, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->modes, validation_context,
                                         &modes_validate_params)) {
    return false;
  }


  if (!::display::mojom::internal::PanelOrientation_Data
        ::Validate(object->panel_orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->edid, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& edid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->edid, validation_context,
                                         &edid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maximum_cursor_size, 26, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->maximum_cursor_size, validation_context))
    return false;


  if (!::display::mojom::internal::VariableRefreshRateState_Data
        ::Validate(object->variable_refresh_rate_state, validation_context))
    return false;

  return true;
}

DisplaySnapshot_Data::DisplaySnapshot_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display