#ifndef A8XX_DESCRIPTORS_XML
#define A8XX_DESCRIPTORS_XML

/* Autogenerated file, DO NOT EDIT manually! */

#ifdef __KERNEL__
#include <linux/bug.h>
#define assert(x) BUG_ON(!(x))
#else
#include <assert.h>
#endif

#ifdef __cplusplus
#define __struct_cast(X)
#define CONSTEXPR constexpr
#else
#define __struct_cast(X) (struct X)
#define CONSTEXPR
#endif

#if defined(__clang__) && !defined(FD_NO_DEPRECATED_PACK)
#define __FD_DEPRECATED _Pragma ("GCC warning \"Deprecated reg builder\"")
#else
#define __FD_DEPRECATED
#endif

#define REG_A8XX_TEX_SAMP_0					0x00000000
#define A8XX_TEX_SAMP_0_MIPFILTER_LINEAR_NEAR			0x00000001
#define A8XX_TEX_SAMP_0_MIPMAPING_DIS				0x00000002
#define A8XX_TEX_SAMP_0_XY_MAG__MASK				0x0000000cull
#define A8XX_TEX_SAMP_0_XY_MAG__SHIFT				2
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_XY_MAG(enum a6xx_tex_filter val)
{
	return ((val) << A8XX_TEX_SAMP_0_XY_MAG__SHIFT) & A8XX_TEX_SAMP_0_XY_MAG__MASK;
}
#define A8XX_TEX_SAMP_0_XY_MIN__MASK				0x00000030ull
#define A8XX_TEX_SAMP_0_XY_MIN__SHIFT				4
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_XY_MIN(enum a6xx_tex_filter val)
{
	return ((val) << A8XX_TEX_SAMP_0_XY_MIN__SHIFT) & A8XX_TEX_SAMP_0_XY_MIN__MASK;
}
#define A8XX_TEX_SAMP_0_WRAP_S__MASK				0x000001c0ull
#define A8XX_TEX_SAMP_0_WRAP_S__SHIFT				6
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_WRAP_S(enum a6xx_tex_clamp val)
{
	return ((val) << A8XX_TEX_SAMP_0_WRAP_S__SHIFT) & A8XX_TEX_SAMP_0_WRAP_S__MASK;
}
#define A8XX_TEX_SAMP_0_WRAP_T__MASK				0x00000e00ull
#define A8XX_TEX_SAMP_0_WRAP_T__SHIFT				9
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_WRAP_T(enum a6xx_tex_clamp val)
{
	return ((val) << A8XX_TEX_SAMP_0_WRAP_T__SHIFT) & A8XX_TEX_SAMP_0_WRAP_T__MASK;
}
#define A8XX_TEX_SAMP_0_WRAP_R__MASK				0x00007000ull
#define A8XX_TEX_SAMP_0_WRAP_R__SHIFT				12
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_WRAP_R(enum a6xx_tex_clamp val)
{
	return ((val) << A8XX_TEX_SAMP_0_WRAP_R__SHIFT) & A8XX_TEX_SAMP_0_WRAP_R__MASK;
}
#define A8XX_TEX_SAMP_0_MSAA_BOX_FILTERING			0x00008000
#define A8XX_TEX_SAMP_0_LOD_BIAS__MASK				0x1fff0000ull
#define A8XX_TEX_SAMP_0_LOD_BIAS__SHIFT				16
static inline uint32_t A8XX_TEX_SAMP_0_LOD_BIAS(float val)
{
	return ((((int32_t)(val * 256.0))) << A8XX_TEX_SAMP_0_LOD_BIAS__SHIFT) & A8XX_TEX_SAMP_0_LOD_BIAS__MASK;
}
#define A8XX_TEX_SAMP_0_ANISO__MASK				0xe0000000ull
#define A8XX_TEX_SAMP_0_ANISO__SHIFT				29
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_0_ANISO(enum a6xx_tex_aniso val)
{
	return ((val) << A8XX_TEX_SAMP_0_ANISO__SHIFT) & A8XX_TEX_SAMP_0_ANISO__MASK;
}


#define REG_A8XX_TEX_SAMP_1					0x00000001
#define A8XX_TEX_SAMP_1_MAX_LOD__MASK				0x00000fffull
#define A8XX_TEX_SAMP_1_MAX_LOD__SHIFT				0
static inline uint32_t A8XX_TEX_SAMP_1_MAX_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A8XX_TEX_SAMP_1_MAX_LOD__SHIFT) & A8XX_TEX_SAMP_1_MAX_LOD__MASK;
}
#define A8XX_TEX_SAMP_1_MIN_LOD__MASK				0x00fff000ull
#define A8XX_TEX_SAMP_1_MIN_LOD__SHIFT				12
static inline uint32_t A8XX_TEX_SAMP_1_MIN_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A8XX_TEX_SAMP_1_MIN_LOD__SHIFT) & A8XX_TEX_SAMP_1_MIN_LOD__MASK;
}
#define A8XX_TEX_SAMP_1_REDUCTION_MODE__MASK			0x03000000ull
#define A8XX_TEX_SAMP_1_REDUCTION_MODE__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_1_REDUCTION_MODE(enum a6xx_reduction_mode val)
{
	return ((val) << A8XX_TEX_SAMP_1_REDUCTION_MODE__SHIFT) & A8XX_TEX_SAMP_1_REDUCTION_MODE__MASK;
}
#define A8XX_TEX_SAMP_1_COMPARE_FUNC__MASK			0x1c000000ull
#define A8XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT			26
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_1_COMPARE_FUNC(enum adreno_compare_func val)
{
	return ((val) << A8XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT) & A8XX_TEX_SAMP_1_COMPARE_FUNC__MASK;
}
#define A8XX_TEX_SAMP_1_CHROMA_LINEAR				0x20000000
#define A8XX_TEX_SAMP_1_CUBEMAPSEAMLESSFILTOFF			0x40000000
#define A8XX_TEX_SAMP_1_UNNORM_COORDS				0x80000000


#define REG_A8XX_TEX_SAMP_2					0x00000002
#define A8XX_TEX_SAMP_2_FASTBORDERCOLOREN			0x00000001
#define A8XX_TEX_SAMP_2_FASTBORDERCOLOR__MASK			0x00000006ull
#define A8XX_TEX_SAMP_2_FASTBORDERCOLOR__SHIFT			1
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_2_FASTBORDERCOLOR(enum a6xx_fast_border_color val)
{
	return ((val) << A8XX_TEX_SAMP_2_FASTBORDERCOLOR__SHIFT) & A8XX_TEX_SAMP_2_FASTBORDERCOLOR__MASK;
}
#define A8XX_TEX_SAMP_2_BCOLOR__MASK				0xffffff80ull
#define A8XX_TEX_SAMP_2_BCOLOR__SHIFT				7
static CONSTEXPR inline uint32_t A8XX_TEX_SAMP_2_BCOLOR(uint32_t val)
{
	return ((val) << A8XX_TEX_SAMP_2_BCOLOR__SHIFT) & A8XX_TEX_SAMP_2_BCOLOR__MASK;
}


#define REG_A8XX_TEX_SAMP_3					0x00000003


#define REG_A8XX_TEX_MEMOBJ_0					0x00000000
#define A8XX_TEX_MEMOBJ_0_BASE_LO__MASK				0xffffffc0ull
#define A8XX_TEX_MEMOBJ_0_BASE_LO__SHIFT			6
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_0_BASE_LO(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_0_BASE_LO__SHIFT) & A8XX_TEX_MEMOBJ_0_BASE_LO__MASK;
}
#define A8XX_TEX_MEMOBJ_0_INSTANCE_DESC_BASE_LO__MASK		0xffffffffull
#define A8XX_TEX_MEMOBJ_0_INSTANCE_DESC_BASE_LO__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_0_INSTANCE_DESC_BASE_LO(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_0_INSTANCE_DESC_BASE_LO__SHIFT) & A8XX_TEX_MEMOBJ_0_INSTANCE_DESC_BASE_LO__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_1					0x00000001
#define A8XX_TEX_MEMOBJ_1_BASE_HI__MASK				0x0001ffffull
#define A8XX_TEX_MEMOBJ_1_BASE_HI__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_1_BASE_HI(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_1_BASE_HI__SHIFT) & A8XX_TEX_MEMOBJ_1_BASE_HI__MASK;
}
#define A8XX_TEX_MEMOBJ_1_TYPE__MASK				0x000e0000ull
#define A8XX_TEX_MEMOBJ_1_TYPE__SHIFT				17
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_1_TYPE(enum a6xx_tex_type val)
{
	return ((val) << A8XX_TEX_MEMOBJ_1_TYPE__SHIFT) & A8XX_TEX_MEMOBJ_1_TYPE__MASK;
}
#define A8XX_TEX_MEMOBJ_1_DEPTH__MASK				0xfff00000ull
#define A8XX_TEX_MEMOBJ_1_DEPTH__SHIFT				20
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_1_DEPTH(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_1_DEPTH__SHIFT) & A8XX_TEX_MEMOBJ_1_DEPTH__MASK;
}
#define A8XX_TEX_MEMOBJ_1_STRUCTSIZETEXELS__MASK		0xfff00000ull
#define A8XX_TEX_MEMOBJ_1_STRUCTSIZETEXELS__SHIFT		20
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_1_STRUCTSIZETEXELS(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_1_STRUCTSIZETEXELS__SHIFT) & A8XX_TEX_MEMOBJ_1_STRUCTSIZETEXELS__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_2					0x00000002
#define A8XX_TEX_MEMOBJ_2_WIDTH__MASK				0x00007fffull
#define A8XX_TEX_MEMOBJ_2_WIDTH__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_2_WIDTH(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_2_WIDTH__SHIFT) & A8XX_TEX_MEMOBJ_2_WIDTH__MASK;
}
#define A8XX_TEX_MEMOBJ_2_HEIGHT__MASK				0x3fff8000ull
#define A8XX_TEX_MEMOBJ_2_HEIGHT__SHIFT				15
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_2_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_2_HEIGHT__SHIFT) & A8XX_TEX_MEMOBJ_2_HEIGHT__MASK;
}
#define A8XX_TEX_MEMOBJ_2_SAMPLES__MASK				0xc0000000ull
#define A8XX_TEX_MEMOBJ_2_SAMPLES__SHIFT			30
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_2_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A8XX_TEX_MEMOBJ_2_SAMPLES__SHIFT) & A8XX_TEX_MEMOBJ_2_SAMPLES__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_3					0x00000003
#define A8XX_TEX_MEMOBJ_3_FMT__MASK				0x000000ffull
#define A8XX_TEX_MEMOBJ_3_FMT__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_FMT(enum a6xx_format val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_FMT__SHIFT) & A8XX_TEX_MEMOBJ_3_FMT__MASK;
}
#define A8XX_TEX_MEMOBJ_3_SWAP__MASK				0x00000300ull
#define A8XX_TEX_MEMOBJ_3_SWAP__SHIFT				8
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_SWAP__SHIFT) & A8XX_TEX_MEMOBJ_3_SWAP__MASK;
}
#define A8XX_TEX_MEMOBJ_3_SWIZ_X__MASK				0x00001c00ull
#define A8XX_TEX_MEMOBJ_3_SWIZ_X__SHIFT				10
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_SWIZ_X(enum a8xx_tex_swiz val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_SWIZ_X__SHIFT) & A8XX_TEX_MEMOBJ_3_SWIZ_X__MASK;
}
#define A8XX_TEX_MEMOBJ_3_SWIZ_Y__MASK				0x0000e000ull
#define A8XX_TEX_MEMOBJ_3_SWIZ_Y__SHIFT				13
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_SWIZ_Y(enum a8xx_tex_swiz val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_SWIZ_Y__SHIFT) & A8XX_TEX_MEMOBJ_3_SWIZ_Y__MASK;
}
#define A8XX_TEX_MEMOBJ_3_SWIZ_Z__MASK				0x00070000ull
#define A8XX_TEX_MEMOBJ_3_SWIZ_Z__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_SWIZ_Z(enum a8xx_tex_swiz val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_SWIZ_Z__SHIFT) & A8XX_TEX_MEMOBJ_3_SWIZ_Z__MASK;
}
#define A8XX_TEX_MEMOBJ_3_SWIZ_W__MASK				0x00380000ull
#define A8XX_TEX_MEMOBJ_3_SWIZ_W__SHIFT				19
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_3_SWIZ_W(enum a8xx_tex_swiz val)
{
	return ((val) << A8XX_TEX_MEMOBJ_3_SWIZ_W__SHIFT) & A8XX_TEX_MEMOBJ_3_SWIZ_W__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_4					0x00000004
#define A8XX_TEX_MEMOBJ_4_TILE_MODE__MASK			0x00000003ull
#define A8XX_TEX_MEMOBJ_4_TILE_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_4_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A8XX_TEX_MEMOBJ_4_TILE_MODE__SHIFT) & A8XX_TEX_MEMOBJ_4_TILE_MODE__MASK;
}
#define A8XX_TEX_MEMOBJ_4_FLAG					0x00000004
#define A8XX_TEX_MEMOBJ_4_PRT_EN				0x00000008
#define A8XX_TEX_MEMOBJ_4_TILE_ALL				0x00000010
#define A8XX_TEX_MEMOBJ_4_SRGB					0x00000020
#define A8XX_TEX_MEMOBJ_4_FLAG_LO__MASK				0xffffffc0ull
#define A8XX_TEX_MEMOBJ_4_FLAG_LO__SHIFT			6
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_4_FLAG_LO(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_4_FLAG_LO__SHIFT) & A8XX_TEX_MEMOBJ_4_FLAG_LO__MASK;
}
#define A8XX_TEX_MEMOBJ_4_BASE_U_LO__MASK			0xffffffc0ull
#define A8XX_TEX_MEMOBJ_4_BASE_U_LO__SHIFT			6
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_4_BASE_U_LO(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_4_BASE_U_LO__SHIFT) & A8XX_TEX_MEMOBJ_4_BASE_U_LO__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_5					0x00000005
#define A8XX_TEX_MEMOBJ_5_FLAG_HI__MASK				0x0001ffffull
#define A8XX_TEX_MEMOBJ_5_FLAG_HI__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_5_FLAG_HI(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_5_FLAG_HI__SHIFT) & A8XX_TEX_MEMOBJ_5_FLAG_HI__MASK;
}
#define A8XX_TEX_MEMOBJ_5_BASE_U_HI__MASK			0x0001ffffull
#define A8XX_TEX_MEMOBJ_5_BASE_U_HI__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_5_BASE_U_HI(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_5_BASE_U_HI__SHIFT) & A8XX_TEX_MEMOBJ_5_BASE_U_HI__MASK;
}
#define A8XX_TEX_MEMOBJ_5_FLAG_BUFFER_PITCH__MASK		0x01fe0000ull
#define A8XX_TEX_MEMOBJ_5_FLAG_BUFFER_PITCH__SHIFT		17
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_5_FLAG_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_5_FLAG_BUFFER_PITCH__SHIFT) & A8XX_TEX_MEMOBJ_5_FLAG_BUFFER_PITCH__MASK;
}
#define A8XX_TEX_MEMOBJ_5_ALL_SAMPLES_CENTER			0x20000000
#define A8XX_TEX_MEMOBJ_5_MUTABLEEN				0x80000000


#define REG_A8XX_TEX_MEMOBJ_6					0x00000006
#define A8XX_TEX_MEMOBJ_6_TEX_LINE_OFFSET__MASK			0x00ffffffull
#define A8XX_TEX_MEMOBJ_6_TEX_LINE_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_6_TEX_LINE_OFFSET(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_6_TEX_LINE_OFFSET__SHIFT) & A8XX_TEX_MEMOBJ_6_TEX_LINE_OFFSET__MASK;
}
#define A8XX_TEX_MEMOBJ_6_MIN_LINE_OFFSET__MASK			0x0f000000ull
#define A8XX_TEX_MEMOBJ_6_MIN_LINE_OFFSET__SHIFT		24
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_6_MIN_LINE_OFFSET(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_6_MIN_LINE_OFFSET__SHIFT) & A8XX_TEX_MEMOBJ_6_MIN_LINE_OFFSET__MASK;
}
#define A8XX_TEX_MEMOBJ_6_MIPLVLS__MASK				0xf0000000ull
#define A8XX_TEX_MEMOBJ_6_MIPLVLS__SHIFT			28
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_6_MIPLVLS(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_6_MIPLVLS__SHIFT) & A8XX_TEX_MEMOBJ_6_MIPLVLS__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_7					0x00000007
#define A8XX_TEX_MEMOBJ_7_ARRAY_SLICE_OFFSET__MASK		0x007fffffull
#define A8XX_TEX_MEMOBJ_7_ARRAY_SLICE_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_7_ARRAY_SLICE_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A8XX_TEX_MEMOBJ_7_ARRAY_SLICE_OFFSET__SHIFT) & A8XX_TEX_MEMOBJ_7_ARRAY_SLICE_OFFSET__MASK;
}
#define A8XX_TEX_MEMOBJ_7_ASO_UNIT				0x00800000
#define A8XX_TEX_MEMOBJ_7_MIN_ARRAY_SLIZE_OFFSET__MASK		0x0f000000ull
#define A8XX_TEX_MEMOBJ_7_MIN_ARRAY_SLIZE_OFFSET__SHIFT		24
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_7_MIN_ARRAY_SLIZE_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A8XX_TEX_MEMOBJ_7_MIN_ARRAY_SLIZE_OFFSET__SHIFT) & A8XX_TEX_MEMOBJ_7_MIN_ARRAY_SLIZE_OFFSET__MASK;
}
#define A8XX_TEX_MEMOBJ_7_GMEM_TILING_FALLBACK_EN		0x10000000
#define A8XX_TEX_MEMOBJ_7_CORNER_BASED_EN			0x40000000
#define A8XX_TEX_MEMOBJ_7_GMEM_FULL_SURF			0x80000000
#define A8XX_TEX_MEMOBJ_7_UV_OFFSET_H__MASK			0x03000000ull
#define A8XX_TEX_MEMOBJ_7_UV_OFFSET_H__SHIFT			24
static inline uint32_t A8XX_TEX_MEMOBJ_7_UV_OFFSET_H(float val)
{
	return ((((uint32_t)(val * 4.0))) << A8XX_TEX_MEMOBJ_7_UV_OFFSET_H__SHIFT) & A8XX_TEX_MEMOBJ_7_UV_OFFSET_H__MASK;
}
#define A8XX_TEX_MEMOBJ_7_UV_OFFSET_V__MASK			0x0c000000ull
#define A8XX_TEX_MEMOBJ_7_UV_OFFSET_V__SHIFT			26
static inline uint32_t A8XX_TEX_MEMOBJ_7_UV_OFFSET_V(float val)
{
	return ((((uint32_t)(val * 4.0))) << A8XX_TEX_MEMOBJ_7_UV_OFFSET_V__SHIFT) & A8XX_TEX_MEMOBJ_7_UV_OFFSET_V__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_8					0x00000008
#define A8XX_TEX_MEMOBJ_8_FLAG_ARRAY_PITCH__MASK		0x00007fffull
#define A8XX_TEX_MEMOBJ_8_FLAG_ARRAY_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_8_FLAG_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A8XX_TEX_MEMOBJ_8_FLAG_ARRAY_PITCH__SHIFT) & A8XX_TEX_MEMOBJ_8_FLAG_ARRAY_PITCH__MASK;
}
#define A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGW__MASK		0x0f000000ull
#define A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGW__SHIFT		24
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGW(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGW__SHIFT) & A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGW__MASK;
}
#define A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGH__MASK		0xf0000000ull
#define A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGH__SHIFT		28
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGH(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGH__SHIFT) & A8XX_TEX_MEMOBJ_8_FLAG_BUFFER_LOGH__MASK;
}
#define A8XX_TEX_MEMOBJ_8_BASE_V_LO__MASK			0xffffffc0ull
#define A8XX_TEX_MEMOBJ_8_BASE_V_LO__SHIFT			6
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_8_BASE_V_LO(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_8_BASE_V_LO__SHIFT) & A8XX_TEX_MEMOBJ_8_BASE_V_LO__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_9					0x00000009
#define A8XX_TEX_MEMOBJ_9_MIN_LOD_CLAMP__MASK			0x7ff80000ull
#define A8XX_TEX_MEMOBJ_9_MIN_LOD_CLAMP__SHIFT			19
static inline uint32_t A8XX_TEX_MEMOBJ_9_MIN_LOD_CLAMP(float val)
{
	return ((((uint32_t)(val * 256.0))) << A8XX_TEX_MEMOBJ_9_MIN_LOD_CLAMP__SHIFT) & A8XX_TEX_MEMOBJ_9_MIN_LOD_CLAMP__MASK;
}
#define A8XX_TEX_MEMOBJ_9_BASE_V_HI__MASK			0x0001ffffull
#define A8XX_TEX_MEMOBJ_9_BASE_V_HI__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_9_BASE_V_HI(uint32_t val)
{
	return ((val) << A8XX_TEX_MEMOBJ_9_BASE_V_HI__SHIFT) & A8XX_TEX_MEMOBJ_9_BASE_V_HI__MASK;
}
#define A8XX_TEX_MEMOBJ_9_UV_PITCH__MASK			0x07fe0000ull
#define A8XX_TEX_MEMOBJ_9_UV_PITCH__SHIFT			17
static CONSTEXPR inline uint32_t A8XX_TEX_MEMOBJ_9_UV_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_TEX_MEMOBJ_9_UV_PITCH__SHIFT) & A8XX_TEX_MEMOBJ_9_UV_PITCH__MASK;
}


#define REG_A8XX_TEX_MEMOBJ_10					0x0000000a


#define REG_A8XX_TEX_MEMOBJ_11					0x0000000b


#define REG_A8XX_TEX_MEMOBJ_12					0x0000000c


#define REG_A8XX_TEX_MEMOBJ_13					0x0000000d


#define REG_A8XX_TEX_MEMOBJ_14					0x0000000e


#define REG_A8XX_TEX_MEMOBJ_15					0x0000000f


#ifdef __cplusplus
#endif
#endif /* A8XX_DESCRIPTORS_XML */
