#include "nv_push_clc96f.h"

#include <stdio.h>





const char *P_PARSE_NVC86F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC86F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC96F_MTHD(uint16_t idx)
{
    switch (idx) {

  
        
    case NVC96F_MEM_OP_B:

        
    case NVC96F_SEM_ADDR_LO:

        
    case NVC96F_SEM_ADDR_HI:


    return P_PARSE_NVC86F_MTHD(idx);

    case NVC96F_MEM_OP_A:
        return "NVC96F_MEM_OP_A";
        case NVC96F_MEM_OP_C:
        return "NVC96F_MEM_OP_C";
    case NVC96F_MEM_OP_D:
        return "NVC96F_MEM_OP_D";
            case NVC96F_SEM_EXECUTE:
        return "NVC96F_SEM_EXECUTE";

    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC96F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
        
    case NVC96F_MEM_OP_B:

        
    case NVC96F_SEM_ADDR_LO:

        
    case NVC96F_SEM_ADDR_HI:


    P_DUMP_NVC86F_MTHD_DATA(fp, idx, data, prefix);
    break;

  
    case NVC96F_MEM_OP_A:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVALIDATION_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVAL_SCOPE = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS:
            fprintf(fp, "NON_LINK_TLBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
      
    case NVC96F_MEM_OP_C:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_REPLAY = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACK_TYPE = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY:
            fprintf(fp, "GLOBALLY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PAGE_TABLE_LEVEL = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY:
            fprintf(fp, "PTE_ONLY\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4:
            fprintf(fp, "UP_TO_PDE4\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_APERTURE = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC96F_MEM_OP_D:

    
        parsed = (data >> 0) & ((1u << 27) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED:
            fprintf(fp, "MMU_TLB_INVALIDATE_TARGETED\n");
            break;
        case NVC96F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY:
            fprintf(fp, "L2_FLUSH_DIRTY\n");
            break;
        case NVC96F_MEM_OP_D_OPERATION_L2_SYSMEM_NCOH_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_NCOH_INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVC96F_SEM_EXECUTE:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC96F_SEM_EXECUTE_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC96F_SEM_EXECUTE_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVC96F_SEM_EXECUTE_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE = ", prefix);
        switch (parsed) {
        case NVC96F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT:
            fprintf(fp, "32BIT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
