// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/plugin/v1beta1/plugin_service.proto

package pluginv1beta1connect

import (
	v1beta1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// PluginServiceName is the fully-qualified name of the PluginService service.
	PluginServiceName = "buf.registry.plugin.v1beta1.PluginService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// PluginServiceGetPluginsProcedure is the fully-qualified name of the PluginService's GetPlugins
	// RPC.
	PluginServiceGetPluginsProcedure = "/buf.registry.plugin.v1beta1.PluginService/GetPlugins"
	// PluginServiceListPluginsProcedure is the fully-qualified name of the PluginService's ListPlugins
	// RPC.
	PluginServiceListPluginsProcedure = "/buf.registry.plugin.v1beta1.PluginService/ListPlugins"
	// PluginServiceCreatePluginsProcedure is the fully-qualified name of the PluginService's
	// CreatePlugins RPC.
	PluginServiceCreatePluginsProcedure = "/buf.registry.plugin.v1beta1.PluginService/CreatePlugins"
	// PluginServiceUpdatePluginsProcedure is the fully-qualified name of the PluginService's
	// UpdatePlugins RPC.
	PluginServiceUpdatePluginsProcedure = "/buf.registry.plugin.v1beta1.PluginService/UpdatePlugins"
	// PluginServiceDeletePluginsProcedure is the fully-qualified name of the PluginService's
	// DeletePlugins RPC.
	PluginServiceDeletePluginsProcedure = "/buf.registry.plugin.v1beta1.PluginService/DeletePlugins"
)

// PluginServiceClient is a client for the buf.registry.plugin.v1beta1.PluginService service.
type PluginServiceClient interface {
	// Get Plugins by id or name.
	GetPlugins(context.Context, *connect.Request[v1beta1.GetPluginsRequest]) (*connect.Response[v1beta1.GetPluginsResponse], error)
	// List Plugins, usually for a specific Organization.
	ListPlugins(context.Context, *connect.Request[v1beta1.ListPluginsRequest]) (*connect.Response[v1beta1.ListPluginsResponse], error)
	// Create new Plugins.
	//
	// This operation is atomic. Either all Plugins are created or an error is returned.
	CreatePlugins(context.Context, *connect.Request[v1beta1.CreatePluginsRequest]) (*connect.Response[v1beta1.CreatePluginsResponse], error)
	// Update existing Plugins.
	//
	// This operation is atomic. Either all Plugins are updated or an error is returned.
	UpdatePlugins(context.Context, *connect.Request[v1beta1.UpdatePluginsRequest]) (*connect.Response[v1beta1.UpdatePluginsResponse], error)
	// Delete existing Plugins.
	//
	// This operation is atomic. Either all Plugins are deleted or an error is returned.
	DeletePlugins(context.Context, *connect.Request[v1beta1.DeletePluginsRequest]) (*connect.Response[v1beta1.DeletePluginsResponse], error)
}

// NewPluginServiceClient constructs a client for the buf.registry.plugin.v1beta1.PluginService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewPluginServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) PluginServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	pluginServiceMethods := v1beta1.File_buf_registry_plugin_v1beta1_plugin_service_proto.Services().ByName("PluginService").Methods()
	return &pluginServiceClient{
		getPlugins: connect.NewClient[v1beta1.GetPluginsRequest, v1beta1.GetPluginsResponse](
			httpClient,
			baseURL+PluginServiceGetPluginsProcedure,
			connect.WithSchema(pluginServiceMethods.ByName("GetPlugins")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listPlugins: connect.NewClient[v1beta1.ListPluginsRequest, v1beta1.ListPluginsResponse](
			httpClient,
			baseURL+PluginServiceListPluginsProcedure,
			connect.WithSchema(pluginServiceMethods.ByName("ListPlugins")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		createPlugins: connect.NewClient[v1beta1.CreatePluginsRequest, v1beta1.CreatePluginsResponse](
			httpClient,
			baseURL+PluginServiceCreatePluginsProcedure,
			connect.WithSchema(pluginServiceMethods.ByName("CreatePlugins")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		updatePlugins: connect.NewClient[v1beta1.UpdatePluginsRequest, v1beta1.UpdatePluginsResponse](
			httpClient,
			baseURL+PluginServiceUpdatePluginsProcedure,
			connect.WithSchema(pluginServiceMethods.ByName("UpdatePlugins")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		deletePlugins: connect.NewClient[v1beta1.DeletePluginsRequest, v1beta1.DeletePluginsResponse](
			httpClient,
			baseURL+PluginServiceDeletePluginsProcedure,
			connect.WithSchema(pluginServiceMethods.ByName("DeletePlugins")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// pluginServiceClient implements PluginServiceClient.
type pluginServiceClient struct {
	getPlugins    *connect.Client[v1beta1.GetPluginsRequest, v1beta1.GetPluginsResponse]
	listPlugins   *connect.Client[v1beta1.ListPluginsRequest, v1beta1.ListPluginsResponse]
	createPlugins *connect.Client[v1beta1.CreatePluginsRequest, v1beta1.CreatePluginsResponse]
	updatePlugins *connect.Client[v1beta1.UpdatePluginsRequest, v1beta1.UpdatePluginsResponse]
	deletePlugins *connect.Client[v1beta1.DeletePluginsRequest, v1beta1.DeletePluginsResponse]
}

// GetPlugins calls buf.registry.plugin.v1beta1.PluginService.GetPlugins.
func (c *pluginServiceClient) GetPlugins(ctx context.Context, req *connect.Request[v1beta1.GetPluginsRequest]) (*connect.Response[v1beta1.GetPluginsResponse], error) {
	return c.getPlugins.CallUnary(ctx, req)
}

// ListPlugins calls buf.registry.plugin.v1beta1.PluginService.ListPlugins.
func (c *pluginServiceClient) ListPlugins(ctx context.Context, req *connect.Request[v1beta1.ListPluginsRequest]) (*connect.Response[v1beta1.ListPluginsResponse], error) {
	return c.listPlugins.CallUnary(ctx, req)
}

// CreatePlugins calls buf.registry.plugin.v1beta1.PluginService.CreatePlugins.
func (c *pluginServiceClient) CreatePlugins(ctx context.Context, req *connect.Request[v1beta1.CreatePluginsRequest]) (*connect.Response[v1beta1.CreatePluginsResponse], error) {
	return c.createPlugins.CallUnary(ctx, req)
}

// UpdatePlugins calls buf.registry.plugin.v1beta1.PluginService.UpdatePlugins.
func (c *pluginServiceClient) UpdatePlugins(ctx context.Context, req *connect.Request[v1beta1.UpdatePluginsRequest]) (*connect.Response[v1beta1.UpdatePluginsResponse], error) {
	return c.updatePlugins.CallUnary(ctx, req)
}

// DeletePlugins calls buf.registry.plugin.v1beta1.PluginService.DeletePlugins.
func (c *pluginServiceClient) DeletePlugins(ctx context.Context, req *connect.Request[v1beta1.DeletePluginsRequest]) (*connect.Response[v1beta1.DeletePluginsResponse], error) {
	return c.deletePlugins.CallUnary(ctx, req)
}

// PluginServiceHandler is an implementation of the buf.registry.plugin.v1beta1.PluginService
// service.
type PluginServiceHandler interface {
	// Get Plugins by id or name.
	GetPlugins(context.Context, *connect.Request[v1beta1.GetPluginsRequest]) (*connect.Response[v1beta1.GetPluginsResponse], error)
	// List Plugins, usually for a specific Organization.
	ListPlugins(context.Context, *connect.Request[v1beta1.ListPluginsRequest]) (*connect.Response[v1beta1.ListPluginsResponse], error)
	// Create new Plugins.
	//
	// This operation is atomic. Either all Plugins are created or an error is returned.
	CreatePlugins(context.Context, *connect.Request[v1beta1.CreatePluginsRequest]) (*connect.Response[v1beta1.CreatePluginsResponse], error)
	// Update existing Plugins.
	//
	// This operation is atomic. Either all Plugins are updated or an error is returned.
	UpdatePlugins(context.Context, *connect.Request[v1beta1.UpdatePluginsRequest]) (*connect.Response[v1beta1.UpdatePluginsResponse], error)
	// Delete existing Plugins.
	//
	// This operation is atomic. Either all Plugins are deleted or an error is returned.
	DeletePlugins(context.Context, *connect.Request[v1beta1.DeletePluginsRequest]) (*connect.Response[v1beta1.DeletePluginsResponse], error)
}

// NewPluginServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewPluginServiceHandler(svc PluginServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	pluginServiceMethods := v1beta1.File_buf_registry_plugin_v1beta1_plugin_service_proto.Services().ByName("PluginService").Methods()
	pluginServiceGetPluginsHandler := connect.NewUnaryHandler(
		PluginServiceGetPluginsProcedure,
		svc.GetPlugins,
		connect.WithSchema(pluginServiceMethods.ByName("GetPlugins")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	pluginServiceListPluginsHandler := connect.NewUnaryHandler(
		PluginServiceListPluginsProcedure,
		svc.ListPlugins,
		connect.WithSchema(pluginServiceMethods.ByName("ListPlugins")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	pluginServiceCreatePluginsHandler := connect.NewUnaryHandler(
		PluginServiceCreatePluginsProcedure,
		svc.CreatePlugins,
		connect.WithSchema(pluginServiceMethods.ByName("CreatePlugins")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	pluginServiceUpdatePluginsHandler := connect.NewUnaryHandler(
		PluginServiceUpdatePluginsProcedure,
		svc.UpdatePlugins,
		connect.WithSchema(pluginServiceMethods.ByName("UpdatePlugins")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	pluginServiceDeletePluginsHandler := connect.NewUnaryHandler(
		PluginServiceDeletePluginsProcedure,
		svc.DeletePlugins,
		connect.WithSchema(pluginServiceMethods.ByName("DeletePlugins")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.plugin.v1beta1.PluginService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case PluginServiceGetPluginsProcedure:
			pluginServiceGetPluginsHandler.ServeHTTP(w, r)
		case PluginServiceListPluginsProcedure:
			pluginServiceListPluginsHandler.ServeHTTP(w, r)
		case PluginServiceCreatePluginsProcedure:
			pluginServiceCreatePluginsHandler.ServeHTTP(w, r)
		case PluginServiceUpdatePluginsProcedure:
			pluginServiceUpdatePluginsHandler.ServeHTTP(w, r)
		case PluginServiceDeletePluginsProcedure:
			pluginServiceDeletePluginsHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedPluginServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedPluginServiceHandler struct{}

func (UnimplementedPluginServiceHandler) GetPlugins(context.Context, *connect.Request[v1beta1.GetPluginsRequest]) (*connect.Response[v1beta1.GetPluginsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.PluginService.GetPlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) ListPlugins(context.Context, *connect.Request[v1beta1.ListPluginsRequest]) (*connect.Response[v1beta1.ListPluginsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.PluginService.ListPlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) CreatePlugins(context.Context, *connect.Request[v1beta1.CreatePluginsRequest]) (*connect.Response[v1beta1.CreatePluginsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.PluginService.CreatePlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) UpdatePlugins(context.Context, *connect.Request[v1beta1.UpdatePluginsRequest]) (*connect.Response[v1beta1.UpdatePluginsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.PluginService.UpdatePlugins is not implemented"))
}

func (UnimplementedPluginServiceHandler) DeletePlugins(context.Context, *connect.Request[v1beta1.DeletePluginsRequest]) (*connect.Response[v1beta1.DeletePluginsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.PluginService.DeletePlugins is not implemented"))
}
