// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum noun.yaml. DO NOT EDIT.

package taxa

import (
	"fmt"
	"iter"
)

// Noun is a syntactic or semantic element within the grammar that can be
// referred to within a diagnostic.
//
// All [keyword.Keyword] values can be safely cast to [taxa.Noun].
type Noun int

const (
	Unrecognized Noun = keywordCount + iota + 1
	TopLevel
	EOF
	SyntaxMode
	EditionMode
	Decl
	Empty
	Syntax
	Edition
	Package
	Import
	Extensions
	Reserved
	Body
	Def
	Message
	Enum
	Service
	Extend
	Oneof
	Group
	Option
	CustomOption
	FieldSelector
	PseudoOption
	Field
	Extension
	EnumValue
	Method
	CompactOptions
	MethodIns
	MethodOuts
	Signature
	FieldTag
	FieldNumber
	MessageSetNumber
	FieldName
	OptionValue
	QualifiedName
	FullyQualifiedName
	ExtensionName
	TypeURL
	Expr
	Range
	Array
	Dict
	DictField
	Type
	TypePath
	TypeParams
	TypePrefix
	MessageType
	MessageSet
	EnumType
	ScalarType
	EntryType
	MapKey
	MapValue
	Whitespace
	Comment
	Ident
	String
	Float
	Int
	Number
	ReturnsParens
	nounCount int = iota
)

// String implements [fmt.Stringer].
func (v Noun) String() string {
	if int(v) < 0 || int(v) > len(_table_Noun_String) {
		return fmt.Sprintf("Noun(%v)", int(v))
	}
	return _table_Noun_String[v]
}

// GoString implements [fmt.GoStringer].
func (v Noun) GoString() string {
	if int(v) < 0 || int(v) > len(_table_Noun_GoString) {
		return fmt.Sprintf("taxa.Noun(%v)", int(v))
	}
	return _table_Noun_GoString[v]
}

var _table_Noun_String = [...]string{
	Unrecognized:       "unrecognized token",
	TopLevel:           "file scope",
	EOF:                "end-of-file",
	SyntaxMode:         "syntax mode",
	EditionMode:        "editions mode",
	Decl:               "declaration",
	Empty:              "empty declaration",
	Syntax:             "`syntax` declaration",
	Edition:            "`edition` declaration",
	Package:            "`package` declaration",
	Import:             "import",
	Extensions:         "extension range",
	Reserved:           "reserved range",
	Body:               "definition body",
	Def:                "definition",
	Message:            "message definition",
	Enum:               "enum definition",
	Service:            "service definition",
	Extend:             "message extension block",
	Oneof:              "oneof definition",
	Group:              "group definition",
	Option:             "option setting",
	CustomOption:       "custom option setting",
	FieldSelector:      "field selector",
	PseudoOption:       "pseudo-option",
	Field:              "message field",
	Extension:          "message extension",
	EnumValue:          "enum value",
	Method:             "service method",
	CompactOptions:     "compact options",
	MethodIns:          "method parameter list",
	MethodOuts:         "method return type",
	Signature:          "method signature",
	FieldTag:           "message field tag",
	FieldNumber:        "field number",
	MessageSetNumber:   "message set extension number",
	FieldName:          "message field name",
	OptionValue:        "option setting value",
	QualifiedName:      "qualified name",
	FullyQualifiedName: "fully qualified name",
	ExtensionName:      "extension name",
	TypeURL:            "`Any` type URL",
	Expr:               "expression",
	Range:              "range expression",
	Array:              "array expression",
	Dict:               "message expression",
	DictField:          "message field value",
	Type:               "type",
	TypePath:           "type name",
	TypeParams:         "type parameters",
	TypePrefix:         "type modifier",
	MessageType:        "message type",
	MessageSet:         "message set type",
	EnumType:           "enum type",
	ScalarType:         "scalar type",
	EntryType:          "map entry type",
	MapKey:             "map key type",
	MapValue:           "map value type",
	Whitespace:         "whitespace",
	Comment:            "comment",
	Ident:              "identifier",
	String:             "string literal",
	Float:              "floating-point literal",
	Int:                "integer literal",
	Number:             "number literal",
	ReturnsParens:      "`returns (...)`",
}

var _table_Noun_GoString = [...]string{
	Unrecognized:       "taxa.Unrecognized",
	TopLevel:           "taxa.TopLevel",
	EOF:                "taxa.EOF",
	SyntaxMode:         "taxa.SyntaxMode",
	EditionMode:        "taxa.EditionMode",
	Decl:               "taxa.Decl",
	Empty:              "taxa.Empty",
	Syntax:             "taxa.Syntax",
	Edition:            "taxa.Edition",
	Package:            "taxa.Package",
	Import:             "taxa.Import",
	Extensions:         "taxa.Extensions",
	Reserved:           "taxa.Reserved",
	Body:               "taxa.Body",
	Def:                "taxa.Def",
	Message:            "taxa.Message",
	Enum:               "taxa.Enum",
	Service:            "taxa.Service",
	Extend:             "taxa.Extend",
	Oneof:              "taxa.Oneof",
	Group:              "taxa.Group",
	Option:             "taxa.Option",
	CustomOption:       "taxa.CustomOption",
	FieldSelector:      "taxa.FieldSelector",
	PseudoOption:       "taxa.PseudoOption",
	Field:              "taxa.Field",
	Extension:          "taxa.Extension",
	EnumValue:          "taxa.EnumValue",
	Method:             "taxa.Method",
	CompactOptions:     "taxa.CompactOptions",
	MethodIns:          "taxa.MethodIns",
	MethodOuts:         "taxa.MethodOuts",
	Signature:          "taxa.Signature",
	FieldTag:           "taxa.FieldTag",
	FieldNumber:        "taxa.FieldNumber",
	MessageSetNumber:   "taxa.MessageSetNumber",
	FieldName:          "taxa.FieldName",
	OptionValue:        "taxa.OptionValue",
	QualifiedName:      "taxa.QualifiedName",
	FullyQualifiedName: "taxa.FullyQualifiedName",
	ExtensionName:      "taxa.ExtensionName",
	TypeURL:            "taxa.TypeURL",
	Expr:               "taxa.Expr",
	Range:              "taxa.Range",
	Array:              "taxa.Array",
	Dict:               "taxa.Dict",
	DictField:          "taxa.DictField",
	Type:               "taxa.Type",
	TypePath:           "taxa.TypePath",
	TypeParams:         "taxa.TypeParams",
	TypePrefix:         "taxa.TypePrefix",
	MessageType:        "taxa.MessageType",
	MessageSet:         "taxa.MessageSet",
	EnumType:           "taxa.EnumType",
	ScalarType:         "taxa.ScalarType",
	EntryType:          "taxa.EntryType",
	MapKey:             "taxa.MapKey",
	MapValue:           "taxa.MapValue",
	Whitespace:         "taxa.Whitespace",
	Comment:            "taxa.Comment",
	Ident:              "taxa.Ident",
	String:             "taxa.String",
	Float:              "taxa.Float",
	Int:                "taxa.Int",
	Number:             "taxa.Number",
	ReturnsParens:      "taxa.ReturnsParens",
}
var _ iter.Seq[int] // Mark iter as used.
