// Copyright 2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/descriptor/v1/file_descriptor_proto_extension.proto

//go:build !protoopaque

package descriptorv1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Extensions to google.protobuf.FileDescriptorProto.
//
// This message is not actually an extension to FileDescriptorProto, rather it lives within
// a FileDescriptorSetExtension, which itself is used for an extension to FileDescriptorSet.
// This is because the Google team preferred these extensions live on FileDescriptorSet and
// SourceCodeInfo instead of on FileDescriptorProto.
//
// These are encapsulated in a single message so that a single extension number can be used
// on google.protobuf.FileDescriptorProto.
type FileDescriptorProtoExtension struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Whether or not the file is considered an "import".
	//
	// An import is a file that is either:
	//
	//   - A Well-Known Type included from the compiler and imported by a targeted file.
	//   - A file that was included from a Buf module dependency and imported by a targeted file.
	//   - A file that was not targeted, but was imported by a targeted file.
	//
	// We use "import" as this matches with the protoc concept of --include_imports, however
	// import is a bit of an overloaded term.
	IsImport bool `protobuf:"varint,1,opt,name=is_import,json=isImport,proto3" json:"is_import,omitempty"`
	// The name of the Buf module that the file belongs to.
	//
	// Will not be proto if this is unknown, or the file did not come from a Buf module.
	ModuleName    *ModuleName `protobuf:"bytes,2,opt,name=module_name,json=moduleName,proto3" json:"module_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileDescriptorProtoExtension) Reset() {
	*x = FileDescriptorProtoExtension{}
	mi := &file_buf_descriptor_v1_file_descriptor_proto_extension_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileDescriptorProtoExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileDescriptorProtoExtension) ProtoMessage() {}

func (x *FileDescriptorProtoExtension) ProtoReflect() protoreflect.Message {
	mi := &file_buf_descriptor_v1_file_descriptor_proto_extension_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileDescriptorProtoExtension) GetIsImport() bool {
	if x != nil {
		return x.IsImport
	}
	return false
}

func (x *FileDescriptorProtoExtension) GetModuleName() *ModuleName {
	if x != nil {
		return x.ModuleName
	}
	return nil
}

func (x *FileDescriptorProtoExtension) SetIsImport(v bool) {
	x.IsImport = v
}

func (x *FileDescriptorProtoExtension) SetModuleName(v *ModuleName) {
	x.ModuleName = v
}

func (x *FileDescriptorProtoExtension) HasModuleName() bool {
	if x == nil {
		return false
	}
	return x.ModuleName != nil
}

func (x *FileDescriptorProtoExtension) ClearModuleName() {
	x.ModuleName = nil
}

type FileDescriptorProtoExtension_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Whether or not the file is considered an "import".
	//
	// An import is a file that is either:
	//
	//   - A Well-Known Type included from the compiler and imported by a targeted file.
	//   - A file that was included from a Buf module dependency and imported by a targeted file.
	//   - A file that was not targeted, but was imported by a targeted file.
	//
	// We use "import" as this matches with the protoc concept of --include_imports, however
	// import is a bit of an overloaded term.
	IsImport bool
	// The name of the Buf module that the file belongs to.
	//
	// Will not be proto if this is unknown, or the file did not come from a Buf module.
	ModuleName *ModuleName
}

func (b0 FileDescriptorProtoExtension_builder) Build() *FileDescriptorProtoExtension {
	m0 := &FileDescriptorProtoExtension{}
	b, x := &b0, m0
	_, _ = b, x
	x.IsImport = b.IsImport
	x.ModuleName = b.ModuleName
	return m0
}

var File_buf_descriptor_v1_file_descriptor_proto_extension_proto protoreflect.FileDescriptor

const file_buf_descriptor_v1_file_descriptor_proto_extension_proto_rawDesc = "" +
	"\n" +
	"7buf/descriptor/v1/file_descriptor_proto_extension.proto\x12\x11buf.descriptor.v1\x1a#buf/descriptor/v1/module_name.proto\"{\n" +
	"\x1cFileDescriptorProtoExtension\x12\x1b\n" +
	"\tis_import\x18\x01 \x01(\bR\bisImport\x12>\n" +
	"\vmodule_name\x18\x02 \x01(\v2\x1d.buf.descriptor.v1.ModuleNameR\n" +
	"moduleNameB]Z[buf.build/gen/go/bufbuild/protodescriptor/protocolbuffers/go/buf/descriptor/v1;descriptorv1b\x06proto3"

var file_buf_descriptor_v1_file_descriptor_proto_extension_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_descriptor_v1_file_descriptor_proto_extension_proto_goTypes = []any{
	(*FileDescriptorProtoExtension)(nil), // 0: buf.descriptor.v1.FileDescriptorProtoExtension
	(*ModuleName)(nil),                   // 1: buf.descriptor.v1.ModuleName
}
var file_buf_descriptor_v1_file_descriptor_proto_extension_proto_depIdxs = []int32{
	1, // 0: buf.descriptor.v1.FileDescriptorProtoExtension.module_name:type_name -> buf.descriptor.v1.ModuleName
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_buf_descriptor_v1_file_descriptor_proto_extension_proto_init() }
func file_buf_descriptor_v1_file_descriptor_proto_extension_proto_init() {
	if File_buf_descriptor_v1_file_descriptor_proto_extension_proto != nil {
		return
	}
	file_buf_descriptor_v1_module_name_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_descriptor_v1_file_descriptor_proto_extension_proto_rawDesc), len(file_buf_descriptor_v1_file_descriptor_proto_extension_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_descriptor_v1_file_descriptor_proto_extension_proto_goTypes,
		DependencyIndexes: file_buf_descriptor_v1_file_descriptor_proto_extension_proto_depIdxs,
		MessageInfos:      file_buf_descriptor_v1_file_descriptor_proto_extension_proto_msgTypes,
	}.Build()
	File_buf_descriptor_v1_file_descriptor_proto_extension_proto = out.File
	file_buf_descriptor_v1_file_descriptor_proto_extension_proto_goTypes = nil
	file_buf_descriptor_v1_file_descriptor_proto_extension_proto_depIdxs = nil
}
