// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.1
// source: flow/flow.proto

package flow

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type FlowType int32

const (
	FlowType_UNKNOWN_TYPE FlowType = 0
	FlowType_L3_L4        FlowType = 1 // not sure about the underscore here, but `L34` also reads strange
	FlowType_L7           FlowType = 2
	FlowType_SOCK         FlowType = 3
)

// Enum value maps for FlowType.
var (
	FlowType_name = map[int32]string{
		0: "UNKNOWN_TYPE",
		1: "L3_L4",
		2: "L7",
		3: "SOCK",
	}
	FlowType_value = map[string]int32{
		"UNKNOWN_TYPE": 0,
		"L3_L4":        1,
		"L7":           2,
		"SOCK":         3,
	}
)

func (x FlowType) Enum() *FlowType {
	p := new(FlowType)
	*p = x
	return p
}

func (x FlowType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FlowType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[0].Descriptor()
}

func (FlowType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[0]
}

func (x FlowType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FlowType.Descriptor instead.
func (FlowType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{0}
}

// These types correspond to definitions in pkg/policy/l4.go.
type AuthType int32

const (
	AuthType_DISABLED         AuthType = 0
	AuthType_SPIRE            AuthType = 1
	AuthType_TEST_ALWAYS_FAIL AuthType = 2
)

// Enum value maps for AuthType.
var (
	AuthType_name = map[int32]string{
		0: "DISABLED",
		1: "SPIRE",
		2: "TEST_ALWAYS_FAIL",
	}
	AuthType_value = map[string]int32{
		"DISABLED":         0,
		"SPIRE":            1,
		"TEST_ALWAYS_FAIL": 2,
	}
)

func (x AuthType) Enum() *AuthType {
	p := new(AuthType)
	*p = x
	return p
}

func (x AuthType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[1].Descriptor()
}

func (AuthType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[1]
}

func (x AuthType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthType.Descriptor instead.
func (AuthType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{1}
}

type TraceObservationPoint int32

const (
	// Cilium treats 0 as TO_LXC, but its's something we should work to remove.
	// This is intentionally set as unknown, so proto API can guarantee the
	// observation point is always going to be present on trace events.
	TraceObservationPoint_UNKNOWN_POINT TraceObservationPoint = 0
	// TO_PROXY indicates network packets are transmitted towards the l7 proxy.
	TraceObservationPoint_TO_PROXY TraceObservationPoint = 1
	// TO_HOST indicates network packets are transmitted towards the host
	// namespace.
	TraceObservationPoint_TO_HOST TraceObservationPoint = 2
	// TO_STACK indicates network packets are transmitted towards the Linux
	// kernel network stack on host machine.
	TraceObservationPoint_TO_STACK TraceObservationPoint = 3
	// TO_OVERLAY indicates network packets are transmitted towards the tunnel
	// device.
	TraceObservationPoint_TO_OVERLAY TraceObservationPoint = 4
	// TO_ENDPOINT indicates network packets are transmitted towards endpoints
	// (containers).
	TraceObservationPoint_TO_ENDPOINT TraceObservationPoint = 101
	// FROM_ENDPOINT indicates network packets were received from endpoints
	// (containers).
	TraceObservationPoint_FROM_ENDPOINT TraceObservationPoint = 5
	// FROM_PROXY indicates network packets were received from the l7 proxy.
	TraceObservationPoint_FROM_PROXY TraceObservationPoint = 6
	// FROM_HOST indicates network packets were received from the host
	// namespace.
	TraceObservationPoint_FROM_HOST TraceObservationPoint = 7
	// FROM_STACK indicates network packets were received from the Linux kernel
	// network stack on host machine.
	TraceObservationPoint_FROM_STACK TraceObservationPoint = 8
	// FROM_OVERLAY indicates network packets were received from the tunnel
	// device.
	TraceObservationPoint_FROM_OVERLAY TraceObservationPoint = 9
	// FROM_NETWORK indicates network packets were received from native
	// devices.
	TraceObservationPoint_FROM_NETWORK TraceObservationPoint = 10
	// TO_NETWORK indicates network packets are transmitted towards native
	// devices.
	TraceObservationPoint_TO_NETWORK TraceObservationPoint = 11
	// FROM_CRYPTO indicates network packets were received from the crypto
	// process for decryption.
	TraceObservationPoint_FROM_CRYPTO TraceObservationPoint = 12
	// TO_CRYPTO indicates network packets are transmitted towards the crypto
	// process for encryption.
	TraceObservationPoint_TO_CRYPTO TraceObservationPoint = 13
)

// Enum value maps for TraceObservationPoint.
var (
	TraceObservationPoint_name = map[int32]string{
		0:   "UNKNOWN_POINT",
		1:   "TO_PROXY",
		2:   "TO_HOST",
		3:   "TO_STACK",
		4:   "TO_OVERLAY",
		101: "TO_ENDPOINT",
		5:   "FROM_ENDPOINT",
		6:   "FROM_PROXY",
		7:   "FROM_HOST",
		8:   "FROM_STACK",
		9:   "FROM_OVERLAY",
		10:  "FROM_NETWORK",
		11:  "TO_NETWORK",
		12:  "FROM_CRYPTO",
		13:  "TO_CRYPTO",
	}
	TraceObservationPoint_value = map[string]int32{
		"UNKNOWN_POINT": 0,
		"TO_PROXY":      1,
		"TO_HOST":       2,
		"TO_STACK":      3,
		"TO_OVERLAY":    4,
		"TO_ENDPOINT":   101,
		"FROM_ENDPOINT": 5,
		"FROM_PROXY":    6,
		"FROM_HOST":     7,
		"FROM_STACK":    8,
		"FROM_OVERLAY":  9,
		"FROM_NETWORK":  10,
		"TO_NETWORK":    11,
		"FROM_CRYPTO":   12,
		"TO_CRYPTO":     13,
	}
)

func (x TraceObservationPoint) Enum() *TraceObservationPoint {
	p := new(TraceObservationPoint)
	*p = x
	return p
}

func (x TraceObservationPoint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TraceObservationPoint) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[2].Descriptor()
}

func (TraceObservationPoint) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[2]
}

func (x TraceObservationPoint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TraceObservationPoint.Descriptor instead.
func (TraceObservationPoint) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{2}
}

type TraceReason int32

const (
	TraceReason_TRACE_REASON_UNKNOWN TraceReason = 0
	TraceReason_NEW                  TraceReason = 1
	TraceReason_ESTABLISHED          TraceReason = 2
	TraceReason_REPLY                TraceReason = 3
	TraceReason_RELATED              TraceReason = 4
	// Deprecated: Marked as deprecated in flow/flow.proto.
	TraceReason_REOPENED   TraceReason = 5
	TraceReason_SRV6_ENCAP TraceReason = 6
	TraceReason_SRV6_DECAP TraceReason = 7
	// Deprecated: Marked as deprecated in flow/flow.proto.
	TraceReason_ENCRYPT_OVERLAY TraceReason = 8
)

// Enum value maps for TraceReason.
var (
	TraceReason_name = map[int32]string{
		0: "TRACE_REASON_UNKNOWN",
		1: "NEW",
		2: "ESTABLISHED",
		3: "REPLY",
		4: "RELATED",
		5: "REOPENED",
		6: "SRV6_ENCAP",
		7: "SRV6_DECAP",
		8: "ENCRYPT_OVERLAY",
	}
	TraceReason_value = map[string]int32{
		"TRACE_REASON_UNKNOWN": 0,
		"NEW":                  1,
		"ESTABLISHED":          2,
		"REPLY":                3,
		"RELATED":              4,
		"REOPENED":             5,
		"SRV6_ENCAP":           6,
		"SRV6_DECAP":           7,
		"ENCRYPT_OVERLAY":      8,
	}
)

func (x TraceReason) Enum() *TraceReason {
	p := new(TraceReason)
	*p = x
	return p
}

func (x TraceReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TraceReason) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[3].Descriptor()
}

func (TraceReason) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[3]
}

func (x TraceReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TraceReason.Descriptor instead.
func (TraceReason) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{3}
}

// This enum corresponds to Cilium's L7 accesslog [FlowType](https://github.com/cilium/cilium/blob/728c79e427438ab6f8d9375b62fccd6fed4ace3a/pkg/proxy/accesslog/record.go#L26):
type L7FlowType int32

const (
	L7FlowType_UNKNOWN_L7_TYPE L7FlowType = 0
	L7FlowType_REQUEST         L7FlowType = 1
	L7FlowType_RESPONSE        L7FlowType = 2
	L7FlowType_SAMPLE          L7FlowType = 3
)

// Enum value maps for L7FlowType.
var (
	L7FlowType_name = map[int32]string{
		0: "UNKNOWN_L7_TYPE",
		1: "REQUEST",
		2: "RESPONSE",
		3: "SAMPLE",
	}
	L7FlowType_value = map[string]int32{
		"UNKNOWN_L7_TYPE": 0,
		"REQUEST":         1,
		"RESPONSE":        2,
		"SAMPLE":          3,
	}
)

func (x L7FlowType) Enum() *L7FlowType {
	p := new(L7FlowType)
	*p = x
	return p
}

func (x L7FlowType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (L7FlowType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[4].Descriptor()
}

func (L7FlowType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[4]
}

func (x L7FlowType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use L7FlowType.Descriptor instead.
func (L7FlowType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{4}
}

type IPVersion int32

const (
	IPVersion_IP_NOT_USED IPVersion = 0
	IPVersion_IPv4        IPVersion = 1
	IPVersion_IPv6        IPVersion = 2
)

// Enum value maps for IPVersion.
var (
	IPVersion_name = map[int32]string{
		0: "IP_NOT_USED",
		1: "IPv4",
		2: "IPv6",
	}
	IPVersion_value = map[string]int32{
		"IP_NOT_USED": 0,
		"IPv4":        1,
		"IPv6":        2,
	}
)

func (x IPVersion) Enum() *IPVersion {
	p := new(IPVersion)
	*p = x
	return p
}

func (x IPVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IPVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[5].Descriptor()
}

func (IPVersion) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[5]
}

func (x IPVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IPVersion.Descriptor instead.
func (IPVersion) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{5}
}

type Verdict int32

const (
	// UNKNOWN is used if there is no verdict for this flow event
	Verdict_VERDICT_UNKNOWN Verdict = 0
	// FORWARDED is used for flow events where the trace point has forwarded
	// this packet or connection to the next processing entity.
	Verdict_FORWARDED Verdict = 1
	// DROPPED is used for flow events where the connection or packet has
	// been dropped (e.g. due to a malformed packet, it being rejected by a
	// network policy etc). The exact drop reason may be found in drop_reason_desc.
	Verdict_DROPPED Verdict = 2
	// ERROR is used for flow events where an error occurred during processing
	Verdict_ERROR Verdict = 3
	// AUDIT is used on policy verdict events in policy audit mode, to
	// denominate flows that would have been dropped by policy if audit mode
	// was turned off
	Verdict_AUDIT Verdict = 4
	// REDIRECTED is used for flow events which have been redirected to the proxy
	Verdict_REDIRECTED Verdict = 5
	// TRACED is used for flow events which have been observed at a trace point,
	// but no particular verdict has been reached yet
	Verdict_TRACED Verdict = 6
	// TRANSLATED is used for flow events where an address has been translated
	Verdict_TRANSLATED Verdict = 7
)

// Enum value maps for Verdict.
var (
	Verdict_name = map[int32]string{
		0: "VERDICT_UNKNOWN",
		1: "FORWARDED",
		2: "DROPPED",
		3: "ERROR",
		4: "AUDIT",
		5: "REDIRECTED",
		6: "TRACED",
		7: "TRANSLATED",
	}
	Verdict_value = map[string]int32{
		"VERDICT_UNKNOWN": 0,
		"FORWARDED":       1,
		"DROPPED":         2,
		"ERROR":           3,
		"AUDIT":           4,
		"REDIRECTED":      5,
		"TRACED":          6,
		"TRANSLATED":      7,
	}
)

func (x Verdict) Enum() *Verdict {
	p := new(Verdict)
	*p = x
	return p
}

func (x Verdict) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Verdict) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[6].Descriptor()
}

func (Verdict) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[6]
}

func (x Verdict) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Verdict.Descriptor instead.
func (Verdict) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{6}
}

// These values are shared with pkg/monitor/api/drop.go and bpf/lib/common.h.
// Note that non-drop reasons (i.e. values less than api.DropMin) are not used
// here.
type DropReason int32

const (
	// non-drop reasons
	DropReason_DROP_REASON_UNKNOWN DropReason = 0
	// drop reasons
	//
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_INVALID_SOURCE_MAC DropReason = 130
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_INVALID_DESTINATION_MAC        DropReason = 131
	DropReason_INVALID_SOURCE_IP              DropReason = 132
	DropReason_POLICY_DENIED                  DropReason = 133
	DropReason_INVALID_PACKET_DROPPED         DropReason = 134
	DropReason_CT_TRUNCATED_OR_INVALID_HEADER DropReason = 135
	DropReason_CT_MISSING_TCP_ACK_FLAG        DropReason = 136
	DropReason_CT_UNKNOWN_L4_PROTOCOL         DropReason = 137
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_CT_CANNOT_CREATE_ENTRY_FROM_PACKET DropReason = 138
	DropReason_UNSUPPORTED_L3_PROTOCOL            DropReason = 139
	DropReason_MISSED_TAIL_CALL                   DropReason = 140
	DropReason_ERROR_WRITING_TO_PACKET            DropReason = 141
	DropReason_UNKNOWN_L4_PROTOCOL                DropReason = 142
	DropReason_UNKNOWN_ICMPV4_CODE                DropReason = 143
	DropReason_UNKNOWN_ICMPV4_TYPE                DropReason = 144
	DropReason_UNKNOWN_ICMPV6_CODE                DropReason = 145
	DropReason_UNKNOWN_ICMPV6_TYPE                DropReason = 146
	DropReason_ERROR_RETRIEVING_TUNNEL_KEY        DropReason = 147
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_ERROR_RETRIEVING_TUNNEL_OPTIONS DropReason = 148
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_INVALID_GENEVE_OPTION     DropReason = 149
	DropReason_UNKNOWN_L3_TARGET_ADDRESS DropReason = 150
	DropReason_STALE_OR_UNROUTABLE_IP    DropReason = 151
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_NO_MATCHING_LOCAL_CONTAINER_FOUND                     DropReason = 152
	DropReason_ERROR_WHILE_CORRECTING_L3_CHECKSUM                    DropReason = 153
	DropReason_ERROR_WHILE_CORRECTING_L4_CHECKSUM                    DropReason = 154
	DropReason_CT_MAP_INSERTION_FAILED                               DropReason = 155
	DropReason_INVALID_IPV6_EXTENSION_HEADER                         DropReason = 156
	DropReason_IP_FRAGMENTATION_NOT_SUPPORTED                        DropReason = 157
	DropReason_SERVICE_BACKEND_NOT_FOUND                             DropReason = 158
	DropReason_NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT                   DropReason = 160
	DropReason_FAILED_TO_INSERT_INTO_PROXYMAP                        DropReason = 161
	DropReason_REACHED_EDT_RATE_LIMITING_DROP_HORIZON                DropReason = 162
	DropReason_UNKNOWN_CONNECTION_TRACKING_STATE                     DropReason = 163
	DropReason_LOCAL_HOST_IS_UNREACHABLE                             DropReason = 164
	DropReason_NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION DropReason = 165
	DropReason_UNSUPPORTED_L2_PROTOCOL                               DropReason = 166
	DropReason_NO_MAPPING_FOR_NAT_MASQUERADE                         DropReason = 167
	DropReason_UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE               DropReason = 168
	DropReason_FIB_LOOKUP_FAILED                                     DropReason = 169
	DropReason_ENCAPSULATION_TRAFFIC_IS_PROHIBITED                   DropReason = 170
	DropReason_INVALID_IDENTITY                                      DropReason = 171
	DropReason_UNKNOWN_SENDER                                        DropReason = 172
	DropReason_NAT_NOT_NEEDED                                        DropReason = 173
	DropReason_IS_A_CLUSTERIP                                        DropReason = 174
	DropReason_FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND             DropReason = 175
	DropReason_FORBIDDEN_ICMPV6_MESSAGE                              DropReason = 176
	DropReason_DENIED_BY_LB_SRC_RANGE_CHECK                          DropReason = 177
	DropReason_SOCKET_LOOKUP_FAILED                                  DropReason = 178
	DropReason_SOCKET_ASSIGN_FAILED                                  DropReason = 179
	DropReason_PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL          DropReason = 180
	DropReason_POLICY_DENY                                           DropReason = 181
	DropReason_VLAN_FILTERED                                         DropReason = 182
	DropReason_INVALID_VNI                                           DropReason = 183
	DropReason_INVALID_TC_BUFFER                                     DropReason = 184
	DropReason_NO_SID                                                DropReason = 185
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason_MISSING_SRV6_STATE                 DropReason = 186
	DropReason_NAT46                              DropReason = 187
	DropReason_NAT64                              DropReason = 188
	DropReason_AUTH_REQUIRED                      DropReason = 189
	DropReason_CT_NO_MAP_FOUND                    DropReason = 190
	DropReason_SNAT_NO_MAP_FOUND                  DropReason = 191
	DropReason_INVALID_CLUSTER_ID                 DropReason = 192
	DropReason_UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP DropReason = 193
	DropReason_NO_EGRESS_GATEWAY                  DropReason = 194
	DropReason_UNENCRYPTED_TRAFFIC                DropReason = 195
	DropReason_TTL_EXCEEDED                       DropReason = 196
	DropReason_NO_NODE_ID                         DropReason = 197
	DropReason_DROP_RATE_LIMITED                  DropReason = 198
	DropReason_IGMP_HANDLED                       DropReason = 199
	DropReason_IGMP_SUBSCRIBED                    DropReason = 200
	DropReason_MULTICAST_HANDLED                  DropReason = 201
	// A BPF program wants to tail call into bpf_host, but the host datapath
	// hasn't been loaded yet.
	DropReason_DROP_HOST_NOT_READY DropReason = 202
	// A BPF program wants to tail call some endpoint's policy program in
	// cilium_call_policy, but the program is not available.
	DropReason_DROP_EP_NOT_READY DropReason = 203
	// An Egress Gateway node matched a packet against an Egress Gateway policy
	// that didn't select a valid Egress IP.
	DropReason_DROP_NO_EGRESS_IP DropReason = 204
	// Punt packet to a user space proxy.
	DropReason_DROP_PUNT_PROXY DropReason = 205
)

// Enum value maps for DropReason.
var (
	DropReason_name = map[int32]string{
		0:   "DROP_REASON_UNKNOWN",
		130: "INVALID_SOURCE_MAC",
		131: "INVALID_DESTINATION_MAC",
		132: "INVALID_SOURCE_IP",
		133: "POLICY_DENIED",
		134: "INVALID_PACKET_DROPPED",
		135: "CT_TRUNCATED_OR_INVALID_HEADER",
		136: "CT_MISSING_TCP_ACK_FLAG",
		137: "CT_UNKNOWN_L4_PROTOCOL",
		138: "CT_CANNOT_CREATE_ENTRY_FROM_PACKET",
		139: "UNSUPPORTED_L3_PROTOCOL",
		140: "MISSED_TAIL_CALL",
		141: "ERROR_WRITING_TO_PACKET",
		142: "UNKNOWN_L4_PROTOCOL",
		143: "UNKNOWN_ICMPV4_CODE",
		144: "UNKNOWN_ICMPV4_TYPE",
		145: "UNKNOWN_ICMPV6_CODE",
		146: "UNKNOWN_ICMPV6_TYPE",
		147: "ERROR_RETRIEVING_TUNNEL_KEY",
		148: "ERROR_RETRIEVING_TUNNEL_OPTIONS",
		149: "INVALID_GENEVE_OPTION",
		150: "UNKNOWN_L3_TARGET_ADDRESS",
		151: "STALE_OR_UNROUTABLE_IP",
		152: "NO_MATCHING_LOCAL_CONTAINER_FOUND",
		153: "ERROR_WHILE_CORRECTING_L3_CHECKSUM",
		154: "ERROR_WHILE_CORRECTING_L4_CHECKSUM",
		155: "CT_MAP_INSERTION_FAILED",
		156: "INVALID_IPV6_EXTENSION_HEADER",
		157: "IP_FRAGMENTATION_NOT_SUPPORTED",
		158: "SERVICE_BACKEND_NOT_FOUND",
		160: "NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT",
		161: "FAILED_TO_INSERT_INTO_PROXYMAP",
		162: "REACHED_EDT_RATE_LIMITING_DROP_HORIZON",
		163: "UNKNOWN_CONNECTION_TRACKING_STATE",
		164: "LOCAL_HOST_IS_UNREACHABLE",
		165: "NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION",
		166: "UNSUPPORTED_L2_PROTOCOL",
		167: "NO_MAPPING_FOR_NAT_MASQUERADE",
		168: "UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE",
		169: "FIB_LOOKUP_FAILED",
		170: "ENCAPSULATION_TRAFFIC_IS_PROHIBITED",
		171: "INVALID_IDENTITY",
		172: "UNKNOWN_SENDER",
		173: "NAT_NOT_NEEDED",
		174: "IS_A_CLUSTERIP",
		175: "FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND",
		176: "FORBIDDEN_ICMPV6_MESSAGE",
		177: "DENIED_BY_LB_SRC_RANGE_CHECK",
		178: "SOCKET_LOOKUP_FAILED",
		179: "SOCKET_ASSIGN_FAILED",
		180: "PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL",
		181: "POLICY_DENY",
		182: "VLAN_FILTERED",
		183: "INVALID_VNI",
		184: "INVALID_TC_BUFFER",
		185: "NO_SID",
		186: "MISSING_SRV6_STATE",
		187: "NAT46",
		188: "NAT64",
		189: "AUTH_REQUIRED",
		190: "CT_NO_MAP_FOUND",
		191: "SNAT_NO_MAP_FOUND",
		192: "INVALID_CLUSTER_ID",
		193: "UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP",
		194: "NO_EGRESS_GATEWAY",
		195: "UNENCRYPTED_TRAFFIC",
		196: "TTL_EXCEEDED",
		197: "NO_NODE_ID",
		198: "DROP_RATE_LIMITED",
		199: "IGMP_HANDLED",
		200: "IGMP_SUBSCRIBED",
		201: "MULTICAST_HANDLED",
		202: "DROP_HOST_NOT_READY",
		203: "DROP_EP_NOT_READY",
		204: "DROP_NO_EGRESS_IP",
		205: "DROP_PUNT_PROXY",
	}
	DropReason_value = map[string]int32{
		"DROP_REASON_UNKNOWN":                                   0,
		"INVALID_SOURCE_MAC":                                    130,
		"INVALID_DESTINATION_MAC":                               131,
		"INVALID_SOURCE_IP":                                     132,
		"POLICY_DENIED":                                         133,
		"INVALID_PACKET_DROPPED":                                134,
		"CT_TRUNCATED_OR_INVALID_HEADER":                        135,
		"CT_MISSING_TCP_ACK_FLAG":                               136,
		"CT_UNKNOWN_L4_PROTOCOL":                                137,
		"CT_CANNOT_CREATE_ENTRY_FROM_PACKET":                    138,
		"UNSUPPORTED_L3_PROTOCOL":                               139,
		"MISSED_TAIL_CALL":                                      140,
		"ERROR_WRITING_TO_PACKET":                               141,
		"UNKNOWN_L4_PROTOCOL":                                   142,
		"UNKNOWN_ICMPV4_CODE":                                   143,
		"UNKNOWN_ICMPV4_TYPE":                                   144,
		"UNKNOWN_ICMPV6_CODE":                                   145,
		"UNKNOWN_ICMPV6_TYPE":                                   146,
		"ERROR_RETRIEVING_TUNNEL_KEY":                           147,
		"ERROR_RETRIEVING_TUNNEL_OPTIONS":                       148,
		"INVALID_GENEVE_OPTION":                                 149,
		"UNKNOWN_L3_TARGET_ADDRESS":                             150,
		"STALE_OR_UNROUTABLE_IP":                                151,
		"NO_MATCHING_LOCAL_CONTAINER_FOUND":                     152,
		"ERROR_WHILE_CORRECTING_L3_CHECKSUM":                    153,
		"ERROR_WHILE_CORRECTING_L4_CHECKSUM":                    154,
		"CT_MAP_INSERTION_FAILED":                               155,
		"INVALID_IPV6_EXTENSION_HEADER":                         156,
		"IP_FRAGMENTATION_NOT_SUPPORTED":                        157,
		"SERVICE_BACKEND_NOT_FOUND":                             158,
		"NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT":                   160,
		"FAILED_TO_INSERT_INTO_PROXYMAP":                        161,
		"REACHED_EDT_RATE_LIMITING_DROP_HORIZON":                162,
		"UNKNOWN_CONNECTION_TRACKING_STATE":                     163,
		"LOCAL_HOST_IS_UNREACHABLE":                             164,
		"NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION": 165,
		"UNSUPPORTED_L2_PROTOCOL":                               166,
		"NO_MAPPING_FOR_NAT_MASQUERADE":                         167,
		"UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE":               168,
		"FIB_LOOKUP_FAILED":                                     169,
		"ENCAPSULATION_TRAFFIC_IS_PROHIBITED":                   170,
		"INVALID_IDENTITY":                                      171,
		"UNKNOWN_SENDER":                                        172,
		"NAT_NOT_NEEDED":                                        173,
		"IS_A_CLUSTERIP":                                        174,
		"FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND":             175,
		"FORBIDDEN_ICMPV6_MESSAGE":                              176,
		"DENIED_BY_LB_SRC_RANGE_CHECK":                          177,
		"SOCKET_LOOKUP_FAILED":                                  178,
		"SOCKET_ASSIGN_FAILED":                                  179,
		"PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL":          180,
		"POLICY_DENY":                                           181,
		"VLAN_FILTERED":                                         182,
		"INVALID_VNI":                                           183,
		"INVALID_TC_BUFFER":                                     184,
		"NO_SID":                                                185,
		"MISSING_SRV6_STATE":                                    186,
		"NAT46":                                                 187,
		"NAT64":                                                 188,
		"AUTH_REQUIRED":                                         189,
		"CT_NO_MAP_FOUND":                                       190,
		"SNAT_NO_MAP_FOUND":                                     191,
		"INVALID_CLUSTER_ID":                                    192,
		"UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP":                    193,
		"NO_EGRESS_GATEWAY":                                     194,
		"UNENCRYPTED_TRAFFIC":                                   195,
		"TTL_EXCEEDED":                                          196,
		"NO_NODE_ID":                                            197,
		"DROP_RATE_LIMITED":                                     198,
		"IGMP_HANDLED":                                          199,
		"IGMP_SUBSCRIBED":                                       200,
		"MULTICAST_HANDLED":                                     201,
		"DROP_HOST_NOT_READY":                                   202,
		"DROP_EP_NOT_READY":                                     203,
		"DROP_NO_EGRESS_IP":                                     204,
		"DROP_PUNT_PROXY":                                       205,
	}
)

func (x DropReason) Enum() *DropReason {
	p := new(DropReason)
	*p = x
	return p
}

func (x DropReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DropReason) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[7].Descriptor()
}

func (DropReason) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[7]
}

func (x DropReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DropReason.Descriptor instead.
func (DropReason) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{7}
}

type TrafficDirection int32

const (
	TrafficDirection_TRAFFIC_DIRECTION_UNKNOWN TrafficDirection = 0
	TrafficDirection_INGRESS                   TrafficDirection = 1
	TrafficDirection_EGRESS                    TrafficDirection = 2
)

// Enum value maps for TrafficDirection.
var (
	TrafficDirection_name = map[int32]string{
		0: "TRAFFIC_DIRECTION_UNKNOWN",
		1: "INGRESS",
		2: "EGRESS",
	}
	TrafficDirection_value = map[string]int32{
		"TRAFFIC_DIRECTION_UNKNOWN": 0,
		"INGRESS":                   1,
		"EGRESS":                    2,
	}
)

func (x TrafficDirection) Enum() *TrafficDirection {
	p := new(TrafficDirection)
	*p = x
	return p
}

func (x TrafficDirection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrafficDirection) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[8].Descriptor()
}

func (TrafficDirection) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[8]
}

func (x TrafficDirection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrafficDirection.Descriptor instead.
func (TrafficDirection) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{8}
}

// These values are shared with pkg/monitor/api/datapath_debug.go and bpf/lib/dbg.h.
type DebugCapturePoint int32

const (
	DebugCapturePoint_DBG_CAPTURE_POINT_UNKNOWN DebugCapturePoint = 0
	DebugCapturePoint_DBG_CAPTURE_DELIVERY      DebugCapturePoint = 4
	DebugCapturePoint_DBG_CAPTURE_FROM_LB       DebugCapturePoint = 5
	DebugCapturePoint_DBG_CAPTURE_AFTER_V46     DebugCapturePoint = 6
	DebugCapturePoint_DBG_CAPTURE_AFTER_V64     DebugCapturePoint = 7
	DebugCapturePoint_DBG_CAPTURE_PROXY_PRE     DebugCapturePoint = 8
	DebugCapturePoint_DBG_CAPTURE_PROXY_POST    DebugCapturePoint = 9
	DebugCapturePoint_DBG_CAPTURE_SNAT_PRE      DebugCapturePoint = 10
	DebugCapturePoint_DBG_CAPTURE_SNAT_POST     DebugCapturePoint = 11
)

// Enum value maps for DebugCapturePoint.
var (
	DebugCapturePoint_name = map[int32]string{
		0:  "DBG_CAPTURE_POINT_UNKNOWN",
		4:  "DBG_CAPTURE_DELIVERY",
		5:  "DBG_CAPTURE_FROM_LB",
		6:  "DBG_CAPTURE_AFTER_V46",
		7:  "DBG_CAPTURE_AFTER_V64",
		8:  "DBG_CAPTURE_PROXY_PRE",
		9:  "DBG_CAPTURE_PROXY_POST",
		10: "DBG_CAPTURE_SNAT_PRE",
		11: "DBG_CAPTURE_SNAT_POST",
	}
	DebugCapturePoint_value = map[string]int32{
		"DBG_CAPTURE_POINT_UNKNOWN": 0,
		"DBG_CAPTURE_DELIVERY":      4,
		"DBG_CAPTURE_FROM_LB":       5,
		"DBG_CAPTURE_AFTER_V46":     6,
		"DBG_CAPTURE_AFTER_V64":     7,
		"DBG_CAPTURE_PROXY_PRE":     8,
		"DBG_CAPTURE_PROXY_POST":    9,
		"DBG_CAPTURE_SNAT_PRE":      10,
		"DBG_CAPTURE_SNAT_POST":     11,
	}
)

func (x DebugCapturePoint) Enum() *DebugCapturePoint {
	p := new(DebugCapturePoint)
	*p = x
	return p
}

func (x DebugCapturePoint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugCapturePoint) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[9].Descriptor()
}

func (DebugCapturePoint) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[9]
}

func (x DebugCapturePoint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugCapturePoint.Descriptor instead.
func (DebugCapturePoint) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{9}
}

// EventType are constants are based on the ones from <linux/perf_event.h>.
type EventType int32

const (
	EventType_UNKNOWN EventType = 0
	// EventSample is equivalent to PERF_RECORD_SAMPLE.
	EventType_EventSample EventType = 9
	// RecordLost is equivalent to PERF_RECORD_LOST.
	EventType_RecordLost EventType = 2
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0: "UNKNOWN",
		9: "EventSample",
		2: "RecordLost",
	}
	EventType_value = map[string]int32{
		"UNKNOWN":     0,
		"EventSample": 9,
		"RecordLost":  2,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[10].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[10]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventType.Descriptor instead.
func (EventType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{10}
}

type LostEventSource int32

const (
	LostEventSource_UNKNOWN_LOST_EVENT_SOURCE LostEventSource = 0
	// PERF_EVENT_RING_BUFFER indicates that events were dropped in the BPF
	// perf event ring buffer, indicating that userspace agent did not keep up
	// with the events produced by the datapath.
	LostEventSource_PERF_EVENT_RING_BUFFER LostEventSource = 1
	// OBSERVER_EVENTS_QUEUE indicates that events were dropped because the
	// Hubble events queue was full, indicating that the Hubble observer did
	// not keep up.
	LostEventSource_OBSERVER_EVENTS_QUEUE LostEventSource = 2
	// HUBBLE_RING_BUFFER indicates that the event was dropped because it could
	// not be read from Hubble's ring buffer in time before being overwritten.
	LostEventSource_HUBBLE_RING_BUFFER LostEventSource = 3
)

// Enum value maps for LostEventSource.
var (
	LostEventSource_name = map[int32]string{
		0: "UNKNOWN_LOST_EVENT_SOURCE",
		1: "PERF_EVENT_RING_BUFFER",
		2: "OBSERVER_EVENTS_QUEUE",
		3: "HUBBLE_RING_BUFFER",
	}
	LostEventSource_value = map[string]int32{
		"UNKNOWN_LOST_EVENT_SOURCE": 0,
		"PERF_EVENT_RING_BUFFER":    1,
		"OBSERVER_EVENTS_QUEUE":     2,
		"HUBBLE_RING_BUFFER":        3,
	}
)

func (x LostEventSource) Enum() *LostEventSource {
	p := new(LostEventSource)
	*p = x
	return p
}

func (x LostEventSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LostEventSource) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[11].Descriptor()
}

func (LostEventSource) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[11]
}

func (x LostEventSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LostEventSource.Descriptor instead.
func (LostEventSource) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{11}
}

// AgentEventType is the type of agent event. These values are shared with type
// AgentNotification in pkg/monitor/api/types.go.
type AgentEventType int32

const (
	AgentEventType_AGENT_EVENT_UNKNOWN         AgentEventType = 0
	AgentEventType_AGENT_STARTED               AgentEventType = 2
	AgentEventType_POLICY_UPDATED              AgentEventType = 3
	AgentEventType_POLICY_DELETED              AgentEventType = 4
	AgentEventType_ENDPOINT_REGENERATE_SUCCESS AgentEventType = 5
	AgentEventType_ENDPOINT_REGENERATE_FAILURE AgentEventType = 6
	AgentEventType_ENDPOINT_CREATED            AgentEventType = 7
	AgentEventType_ENDPOINT_DELETED            AgentEventType = 8
	AgentEventType_IPCACHE_UPSERTED            AgentEventType = 9
	AgentEventType_IPCACHE_DELETED             AgentEventType = 10
	// Deprecated: Marked as deprecated in flow/flow.proto.
	AgentEventType_SERVICE_UPSERTED AgentEventType = 11
	// Deprecated: Marked as deprecated in flow/flow.proto.
	AgentEventType_SERVICE_DELETED AgentEventType = 12
)

// Enum value maps for AgentEventType.
var (
	AgentEventType_name = map[int32]string{
		0:  "AGENT_EVENT_UNKNOWN",
		2:  "AGENT_STARTED",
		3:  "POLICY_UPDATED",
		4:  "POLICY_DELETED",
		5:  "ENDPOINT_REGENERATE_SUCCESS",
		6:  "ENDPOINT_REGENERATE_FAILURE",
		7:  "ENDPOINT_CREATED",
		8:  "ENDPOINT_DELETED",
		9:  "IPCACHE_UPSERTED",
		10: "IPCACHE_DELETED",
		11: "SERVICE_UPSERTED",
		12: "SERVICE_DELETED",
	}
	AgentEventType_value = map[string]int32{
		"AGENT_EVENT_UNKNOWN":         0,
		"AGENT_STARTED":               2,
		"POLICY_UPDATED":              3,
		"POLICY_DELETED":              4,
		"ENDPOINT_REGENERATE_SUCCESS": 5,
		"ENDPOINT_REGENERATE_FAILURE": 6,
		"ENDPOINT_CREATED":            7,
		"ENDPOINT_DELETED":            8,
		"IPCACHE_UPSERTED":            9,
		"IPCACHE_DELETED":             10,
		"SERVICE_UPSERTED":            11,
		"SERVICE_DELETED":             12,
	}
)

func (x AgentEventType) Enum() *AgentEventType {
	p := new(AgentEventType)
	*p = x
	return p
}

func (x AgentEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[12].Descriptor()
}

func (AgentEventType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[12]
}

func (x AgentEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentEventType.Descriptor instead.
func (AgentEventType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{12}
}

// This mirrors enum xlate_point in bpf/lib/trace_sock.h
type SocketTranslationPoint int32

const (
	SocketTranslationPoint_SOCK_XLATE_POINT_UNKNOWN            SocketTranslationPoint = 0
	SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_FWD  SocketTranslationPoint = 1 // Pre service translation
	SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_FWD SocketTranslationPoint = 2 // Post service translation
	SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_REV  SocketTranslationPoint = 3 // Pre reverse service translation
	SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_REV SocketTranslationPoint = 4 // Post reverse service translation
)

// Enum value maps for SocketTranslationPoint.
var (
	SocketTranslationPoint_name = map[int32]string{
		0: "SOCK_XLATE_POINT_UNKNOWN",
		1: "SOCK_XLATE_POINT_PRE_DIRECTION_FWD",
		2: "SOCK_XLATE_POINT_POST_DIRECTION_FWD",
		3: "SOCK_XLATE_POINT_PRE_DIRECTION_REV",
		4: "SOCK_XLATE_POINT_POST_DIRECTION_REV",
	}
	SocketTranslationPoint_value = map[string]int32{
		"SOCK_XLATE_POINT_UNKNOWN":            0,
		"SOCK_XLATE_POINT_PRE_DIRECTION_FWD":  1,
		"SOCK_XLATE_POINT_POST_DIRECTION_FWD": 2,
		"SOCK_XLATE_POINT_PRE_DIRECTION_REV":  3,
		"SOCK_XLATE_POINT_POST_DIRECTION_REV": 4,
	}
)

func (x SocketTranslationPoint) Enum() *SocketTranslationPoint {
	p := new(SocketTranslationPoint)
	*p = x
	return p
}

func (x SocketTranslationPoint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SocketTranslationPoint) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[13].Descriptor()
}

func (SocketTranslationPoint) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[13]
}

func (x SocketTranslationPoint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SocketTranslationPoint.Descriptor instead.
func (SocketTranslationPoint) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{13}
}

// These values are shared with pkg/monitor/api/datapath_debug.go and bpf/lib/dbg.h.
type DebugEventType int32

const (
	DebugEventType_DBG_EVENT_UNKNOWN                   DebugEventType = 0
	DebugEventType_DBG_GENERIC                         DebugEventType = 1
	DebugEventType_DBG_LOCAL_DELIVERY                  DebugEventType = 2
	DebugEventType_DBG_ENCAP                           DebugEventType = 3
	DebugEventType_DBG_LXC_FOUND                       DebugEventType = 4
	DebugEventType_DBG_POLICY_DENIED                   DebugEventType = 5
	DebugEventType_DBG_CT_LOOKUP                       DebugEventType = 6
	DebugEventType_DBG_CT_LOOKUP_REV                   DebugEventType = 7
	DebugEventType_DBG_CT_MATCH                        DebugEventType = 8
	DebugEventType_DBG_CT_CREATED                      DebugEventType = 9
	DebugEventType_DBG_CT_CREATED2                     DebugEventType = 10
	DebugEventType_DBG_ICMP6_HANDLE                    DebugEventType = 11
	DebugEventType_DBG_ICMP6_REQUEST                   DebugEventType = 12
	DebugEventType_DBG_ICMP6_NS                        DebugEventType = 13
	DebugEventType_DBG_ICMP6_TIME_EXCEEDED             DebugEventType = 14
	DebugEventType_DBG_CT_VERDICT                      DebugEventType = 15
	DebugEventType_DBG_DECAP                           DebugEventType = 16
	DebugEventType_DBG_PORT_MAP                        DebugEventType = 17
	DebugEventType_DBG_ERROR_RET                       DebugEventType = 18
	DebugEventType_DBG_TO_HOST                         DebugEventType = 19
	DebugEventType_DBG_TO_STACK                        DebugEventType = 20
	DebugEventType_DBG_PKT_HASH                        DebugEventType = 21
	DebugEventType_DBG_LB6_LOOKUP_FRONTEND             DebugEventType = 22
	DebugEventType_DBG_LB6_LOOKUP_FRONTEND_FAIL        DebugEventType = 23
	DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT         DebugEventType = 24
	DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS DebugEventType = 25
	DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL DebugEventType = 26
	DebugEventType_DBG_LB6_LOOKUP_BACKEND_FAIL         DebugEventType = 27
	DebugEventType_DBG_LB6_REVERSE_NAT_LOOKUP          DebugEventType = 28
	DebugEventType_DBG_LB6_REVERSE_NAT                 DebugEventType = 29
	DebugEventType_DBG_LB4_LOOKUP_FRONTEND             DebugEventType = 30
	DebugEventType_DBG_LB4_LOOKUP_FRONTEND_FAIL        DebugEventType = 31
	DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT         DebugEventType = 32
	DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS DebugEventType = 33
	DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL DebugEventType = 34
	DebugEventType_DBG_LB4_LOOKUP_BACKEND_FAIL         DebugEventType = 35
	DebugEventType_DBG_LB4_REVERSE_NAT_LOOKUP          DebugEventType = 36
	DebugEventType_DBG_LB4_REVERSE_NAT                 DebugEventType = 37
	DebugEventType_DBG_LB4_LOOPBACK_SNAT               DebugEventType = 38
	DebugEventType_DBG_LB4_LOOPBACK_SNAT_REV           DebugEventType = 39
	DebugEventType_DBG_CT_LOOKUP4                      DebugEventType = 40
	DebugEventType_DBG_RR_BACKEND_SLOT_SEL             DebugEventType = 41
	DebugEventType_DBG_REV_PROXY_LOOKUP                DebugEventType = 42
	DebugEventType_DBG_REV_PROXY_FOUND                 DebugEventType = 43
	DebugEventType_DBG_REV_PROXY_UPDATE                DebugEventType = 44
	DebugEventType_DBG_L4_POLICY                       DebugEventType = 45
	DebugEventType_DBG_NETDEV_IN_CLUSTER               DebugEventType = 46
	DebugEventType_DBG_NETDEV_ENCAP4                   DebugEventType = 47
	DebugEventType_DBG_CT_LOOKUP4_1                    DebugEventType = 48
	DebugEventType_DBG_CT_LOOKUP4_2                    DebugEventType = 49
	DebugEventType_DBG_CT_CREATED4                     DebugEventType = 50
	DebugEventType_DBG_CT_LOOKUP6_1                    DebugEventType = 51
	DebugEventType_DBG_CT_LOOKUP6_2                    DebugEventType = 52
	DebugEventType_DBG_CT_CREATED6                     DebugEventType = 53
	DebugEventType_DBG_SKIP_PROXY                      DebugEventType = 54
	DebugEventType_DBG_L4_CREATE                       DebugEventType = 55
	DebugEventType_DBG_IP_ID_MAP_FAILED4               DebugEventType = 56
	DebugEventType_DBG_IP_ID_MAP_FAILED6               DebugEventType = 57
	DebugEventType_DBG_IP_ID_MAP_SUCCEED4              DebugEventType = 58
	DebugEventType_DBG_IP_ID_MAP_SUCCEED6              DebugEventType = 59
	DebugEventType_DBG_LB_STALE_CT                     DebugEventType = 60
	DebugEventType_DBG_INHERIT_IDENTITY                DebugEventType = 61
	DebugEventType_DBG_SK_LOOKUP4                      DebugEventType = 62
	DebugEventType_DBG_SK_LOOKUP6                      DebugEventType = 63
	DebugEventType_DBG_SK_ASSIGN                       DebugEventType = 64
	DebugEventType_DBG_L7_LB                           DebugEventType = 65
	DebugEventType_DBG_SKIP_POLICY                     DebugEventType = 66
	DebugEventType_DBG_LB6_LOOPBACK_SNAT               DebugEventType = 67
	DebugEventType_DBG_LB6_LOOPBACK_SNAT_REV           DebugEventType = 68
)

// Enum value maps for DebugEventType.
var (
	DebugEventType_name = map[int32]string{
		0:  "DBG_EVENT_UNKNOWN",
		1:  "DBG_GENERIC",
		2:  "DBG_LOCAL_DELIVERY",
		3:  "DBG_ENCAP",
		4:  "DBG_LXC_FOUND",
		5:  "DBG_POLICY_DENIED",
		6:  "DBG_CT_LOOKUP",
		7:  "DBG_CT_LOOKUP_REV",
		8:  "DBG_CT_MATCH",
		9:  "DBG_CT_CREATED",
		10: "DBG_CT_CREATED2",
		11: "DBG_ICMP6_HANDLE",
		12: "DBG_ICMP6_REQUEST",
		13: "DBG_ICMP6_NS",
		14: "DBG_ICMP6_TIME_EXCEEDED",
		15: "DBG_CT_VERDICT",
		16: "DBG_DECAP",
		17: "DBG_PORT_MAP",
		18: "DBG_ERROR_RET",
		19: "DBG_TO_HOST",
		20: "DBG_TO_STACK",
		21: "DBG_PKT_HASH",
		22: "DBG_LB6_LOOKUP_FRONTEND",
		23: "DBG_LB6_LOOKUP_FRONTEND_FAIL",
		24: "DBG_LB6_LOOKUP_BACKEND_SLOT",
		25: "DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS",
		26: "DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL",
		27: "DBG_LB6_LOOKUP_BACKEND_FAIL",
		28: "DBG_LB6_REVERSE_NAT_LOOKUP",
		29: "DBG_LB6_REVERSE_NAT",
		30: "DBG_LB4_LOOKUP_FRONTEND",
		31: "DBG_LB4_LOOKUP_FRONTEND_FAIL",
		32: "DBG_LB4_LOOKUP_BACKEND_SLOT",
		33: "DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS",
		34: "DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL",
		35: "DBG_LB4_LOOKUP_BACKEND_FAIL",
		36: "DBG_LB4_REVERSE_NAT_LOOKUP",
		37: "DBG_LB4_REVERSE_NAT",
		38: "DBG_LB4_LOOPBACK_SNAT",
		39: "DBG_LB4_LOOPBACK_SNAT_REV",
		40: "DBG_CT_LOOKUP4",
		41: "DBG_RR_BACKEND_SLOT_SEL",
		42: "DBG_REV_PROXY_LOOKUP",
		43: "DBG_REV_PROXY_FOUND",
		44: "DBG_REV_PROXY_UPDATE",
		45: "DBG_L4_POLICY",
		46: "DBG_NETDEV_IN_CLUSTER",
		47: "DBG_NETDEV_ENCAP4",
		48: "DBG_CT_LOOKUP4_1",
		49: "DBG_CT_LOOKUP4_2",
		50: "DBG_CT_CREATED4",
		51: "DBG_CT_LOOKUP6_1",
		52: "DBG_CT_LOOKUP6_2",
		53: "DBG_CT_CREATED6",
		54: "DBG_SKIP_PROXY",
		55: "DBG_L4_CREATE",
		56: "DBG_IP_ID_MAP_FAILED4",
		57: "DBG_IP_ID_MAP_FAILED6",
		58: "DBG_IP_ID_MAP_SUCCEED4",
		59: "DBG_IP_ID_MAP_SUCCEED6",
		60: "DBG_LB_STALE_CT",
		61: "DBG_INHERIT_IDENTITY",
		62: "DBG_SK_LOOKUP4",
		63: "DBG_SK_LOOKUP6",
		64: "DBG_SK_ASSIGN",
		65: "DBG_L7_LB",
		66: "DBG_SKIP_POLICY",
		67: "DBG_LB6_LOOPBACK_SNAT",
		68: "DBG_LB6_LOOPBACK_SNAT_REV",
	}
	DebugEventType_value = map[string]int32{
		"DBG_EVENT_UNKNOWN":                   0,
		"DBG_GENERIC":                         1,
		"DBG_LOCAL_DELIVERY":                  2,
		"DBG_ENCAP":                           3,
		"DBG_LXC_FOUND":                       4,
		"DBG_POLICY_DENIED":                   5,
		"DBG_CT_LOOKUP":                       6,
		"DBG_CT_LOOKUP_REV":                   7,
		"DBG_CT_MATCH":                        8,
		"DBG_CT_CREATED":                      9,
		"DBG_CT_CREATED2":                     10,
		"DBG_ICMP6_HANDLE":                    11,
		"DBG_ICMP6_REQUEST":                   12,
		"DBG_ICMP6_NS":                        13,
		"DBG_ICMP6_TIME_EXCEEDED":             14,
		"DBG_CT_VERDICT":                      15,
		"DBG_DECAP":                           16,
		"DBG_PORT_MAP":                        17,
		"DBG_ERROR_RET":                       18,
		"DBG_TO_HOST":                         19,
		"DBG_TO_STACK":                        20,
		"DBG_PKT_HASH":                        21,
		"DBG_LB6_LOOKUP_FRONTEND":             22,
		"DBG_LB6_LOOKUP_FRONTEND_FAIL":        23,
		"DBG_LB6_LOOKUP_BACKEND_SLOT":         24,
		"DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS": 25,
		"DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL": 26,
		"DBG_LB6_LOOKUP_BACKEND_FAIL":         27,
		"DBG_LB6_REVERSE_NAT_LOOKUP":          28,
		"DBG_LB6_REVERSE_NAT":                 29,
		"DBG_LB4_LOOKUP_FRONTEND":             30,
		"DBG_LB4_LOOKUP_FRONTEND_FAIL":        31,
		"DBG_LB4_LOOKUP_BACKEND_SLOT":         32,
		"DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS": 33,
		"DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL": 34,
		"DBG_LB4_LOOKUP_BACKEND_FAIL":         35,
		"DBG_LB4_REVERSE_NAT_LOOKUP":          36,
		"DBG_LB4_REVERSE_NAT":                 37,
		"DBG_LB4_LOOPBACK_SNAT":               38,
		"DBG_LB4_LOOPBACK_SNAT_REV":           39,
		"DBG_CT_LOOKUP4":                      40,
		"DBG_RR_BACKEND_SLOT_SEL":             41,
		"DBG_REV_PROXY_LOOKUP":                42,
		"DBG_REV_PROXY_FOUND":                 43,
		"DBG_REV_PROXY_UPDATE":                44,
		"DBG_L4_POLICY":                       45,
		"DBG_NETDEV_IN_CLUSTER":               46,
		"DBG_NETDEV_ENCAP4":                   47,
		"DBG_CT_LOOKUP4_1":                    48,
		"DBG_CT_LOOKUP4_2":                    49,
		"DBG_CT_CREATED4":                     50,
		"DBG_CT_LOOKUP6_1":                    51,
		"DBG_CT_LOOKUP6_2":                    52,
		"DBG_CT_CREATED6":                     53,
		"DBG_SKIP_PROXY":                      54,
		"DBG_L4_CREATE":                       55,
		"DBG_IP_ID_MAP_FAILED4":               56,
		"DBG_IP_ID_MAP_FAILED6":               57,
		"DBG_IP_ID_MAP_SUCCEED4":              58,
		"DBG_IP_ID_MAP_SUCCEED6":              59,
		"DBG_LB_STALE_CT":                     60,
		"DBG_INHERIT_IDENTITY":                61,
		"DBG_SK_LOOKUP4":                      62,
		"DBG_SK_LOOKUP6":                      63,
		"DBG_SK_ASSIGN":                       64,
		"DBG_L7_LB":                           65,
		"DBG_SKIP_POLICY":                     66,
		"DBG_LB6_LOOPBACK_SNAT":               67,
		"DBG_LB6_LOOPBACK_SNAT_REV":           68,
	}
)

func (x DebugEventType) Enum() *DebugEventType {
	p := new(DebugEventType)
	*p = x
	return p
}

func (x DebugEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[14].Descriptor()
}

func (DebugEventType) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[14]
}

func (x DebugEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugEventType.Descriptor instead.
func (DebugEventType) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{14}
}

type Tunnel_Protocol int32

const (
	Tunnel_UNKNOWN Tunnel_Protocol = 0
	Tunnel_VXLAN   Tunnel_Protocol = 1
	Tunnel_GENEVE  Tunnel_Protocol = 2
)

// Enum value maps for Tunnel_Protocol.
var (
	Tunnel_Protocol_name = map[int32]string{
		0: "UNKNOWN",
		1: "VXLAN",
		2: "GENEVE",
	}
	Tunnel_Protocol_value = map[string]int32{
		"UNKNOWN": 0,
		"VXLAN":   1,
		"GENEVE":  2,
	}
)

func (x Tunnel_Protocol) Enum() *Tunnel_Protocol {
	p := new(Tunnel_Protocol)
	*p = x
	return p
}

func (x Tunnel_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tunnel_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_flow_flow_proto_enumTypes[15].Descriptor()
}

func (Tunnel_Protocol) Type() protoreflect.EnumType {
	return &file_flow_flow_proto_enumTypes[15]
}

func (x Tunnel_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tunnel_Protocol.Descriptor instead.
func (Tunnel_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{19, 0}
}

type Flow struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Time  *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// uuid is a universally unique identifier for this flow.
	Uuid string `protobuf:"bytes,34,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// emitter identifies the source that emitted the flow.
	Emitter *Emitter `protobuf:"bytes,41,opt,name=emitter,proto3" json:"emitter,omitempty"`
	Verdict Verdict  `protobuf:"varint,2,opt,name=verdict,proto3,enum=flow.Verdict" json:"verdict,omitempty"`
	// only applicable to Verdict = DROPPED.
	// deprecated in favor of drop_reason_desc.
	//
	// Deprecated: Marked as deprecated in flow/flow.proto.
	DropReason uint32 `protobuf:"varint,3,opt,name=drop_reason,json=dropReason,proto3" json:"drop_reason,omitempty"`
	// auth_type is the authentication type specified for the flow in Cilium Network Policy.
	// Only set on policy verdict events.
	AuthType AuthType `protobuf:"varint,35,opt,name=auth_type,json=authType,proto3,enum=flow.AuthType" json:"auth_type,omitempty"`
	// l2
	Ethernet *Ethernet `protobuf:"bytes,4,opt,name=ethernet,proto3" json:"ethernet,omitempty"`
	// l3
	IP *IP `protobuf:"bytes,5,opt,name=IP,proto3" json:"IP,omitempty"`
	// l4
	L4          *Layer4   `protobuf:"bytes,6,opt,name=l4,proto3" json:"l4,omitempty"`
	Tunnel      *Tunnel   `protobuf:"bytes,39,opt,name=tunnel,proto3" json:"tunnel,omitempty"`
	Source      *Endpoint `protobuf:"bytes,8,opt,name=source,proto3" json:"source,omitempty"`
	Destination *Endpoint `protobuf:"bytes,9,opt,name=destination,proto3" json:"destination,omitempty"`
	Type        FlowType  `protobuf:"varint,10,opt,name=Type,proto3,enum=flow.FlowType" json:"Type,omitempty"`
	// NodeName is the name of the node from which this Flow was captured.
	NodeName string `protobuf:"bytes,11,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// node labels in `foo=bar` format.
	NodeLabels []string `protobuf:"bytes,37,rep,name=node_labels,json=nodeLabels,proto3" json:"node_labels,omitempty"`
	// all names the source IP can have.
	SourceNames []string `protobuf:"bytes,13,rep,name=source_names,json=sourceNames,proto3" json:"source_names,omitempty"`
	// all names the destination IP can have.
	DestinationNames []string `protobuf:"bytes,14,rep,name=destination_names,json=destinationNames,proto3" json:"destination_names,omitempty"`
	// L7 information. This field is set if and only if FlowType is L7.
	L7 *Layer7 `protobuf:"bytes,15,opt,name=l7,proto3" json:"l7,omitempty"`
	// Deprecated. This suffers from false negatives due to protobuf not being
	// able to distinguish between the value being false or it being absent.
	// Please use is_reply instead.
	//
	// Deprecated: Marked as deprecated in flow/flow.proto.
	Reply bool `protobuf:"varint,16,opt,name=reply,proto3" json:"reply,omitempty"`
	// EventType of the originating Cilium event
	EventType *CiliumEventType `protobuf:"bytes,19,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// source_service contains the service name of the source
	SourceService *Service `protobuf:"bytes,20,opt,name=source_service,json=sourceService,proto3" json:"source_service,omitempty"`
	// destination_service contains the service name of the destination
	DestinationService *Service `protobuf:"bytes,21,opt,name=destination_service,json=destinationService,proto3" json:"destination_service,omitempty"`
	// traffic_direction of the connection, e.g. ingress or egress
	TrafficDirection TrafficDirection `protobuf:"varint,22,opt,name=traffic_direction,json=trafficDirection,proto3,enum=flow.TrafficDirection" json:"traffic_direction,omitempty"`
	// policy_match_type is only applicable to the cilium event type PolicyVerdict
	// https://github.com/cilium/cilium/blob/e831859b5cc336c6d964a6d35bbd34d1840e21b9/pkg/monitor/datapath_policy.go#L50
	PolicyMatchType uint32 `protobuf:"varint,23,opt,name=policy_match_type,json=policyMatchType,proto3" json:"policy_match_type,omitempty"`
	// Only applicable to cilium trace notifications, blank for other types.
	TraceObservationPoint TraceObservationPoint `protobuf:"varint,24,opt,name=trace_observation_point,json=traceObservationPoint,proto3,enum=flow.TraceObservationPoint" json:"trace_observation_point,omitempty"`
	// Cilium datapath trace reason info.
	TraceReason TraceReason `protobuf:"varint,36,opt,name=trace_reason,json=traceReason,proto3,enum=flow.TraceReason" json:"trace_reason,omitempty"`
	// Cilium datapath filename and line number. Currently only applicable when
	// Verdict = DROPPED.
	File *FileInfo `protobuf:"bytes,38,opt,name=file,proto3" json:"file,omitempty"`
	// IPTraceID relates to the trace ID in the IP options of a packet.
	IpTraceId *IPTraceID `protobuf:"bytes,40,opt,name=ip_trace_id,json=ipTraceId,proto3" json:"ip_trace_id,omitempty"`
	// only applicable to Verdict = DROPPED.
	DropReasonDesc DropReason `protobuf:"varint,25,opt,name=drop_reason_desc,json=dropReasonDesc,proto3,enum=flow.DropReason" json:"drop_reason_desc,omitempty"`
	// is_reply indicates that this was a packet (L4) or message (L7) in the
	// reply direction. May be absent (in which case it is unknown whether it
	// is a reply or not).
	IsReply *wrapperspb.BoolValue `protobuf:"bytes,26,opt,name=is_reply,json=isReply,proto3" json:"is_reply,omitempty"`
	// Only applicable to cilium debug capture events, blank for other types
	DebugCapturePoint DebugCapturePoint `protobuf:"varint,27,opt,name=debug_capture_point,json=debugCapturePoint,proto3,enum=flow.DebugCapturePoint" json:"debug_capture_point,omitempty"`
	// interface is the network interface on which this flow was observed
	Interface *NetworkInterface `protobuf:"bytes,28,opt,name=interface,proto3" json:"interface,omitempty"`
	// proxy_port indicates the port of the proxy to which the flow was forwarded
	ProxyPort uint32 `protobuf:"varint,29,opt,name=proxy_port,json=proxyPort,proto3" json:"proxy_port,omitempty"`
	// trace_context contains information about a trace related to the flow, if
	// any.
	TraceContext *TraceContext `protobuf:"bytes,30,opt,name=trace_context,json=traceContext,proto3" json:"trace_context,omitempty"`
	// sock_xlate_point is the socket translation point.
	// Only applicable to TraceSock notifications, blank for other types
	SockXlatePoint SocketTranslationPoint `protobuf:"varint,31,opt,name=sock_xlate_point,json=sockXlatePoint,proto3,enum=flow.SocketTranslationPoint" json:"sock_xlate_point,omitempty"`
	// socket_cookie is the Linux kernel socket cookie for this flow.
	// Only applicable to TraceSock notifications, zero for other types
	SocketCookie uint64 `protobuf:"varint,32,opt,name=socket_cookie,json=socketCookie,proto3" json:"socket_cookie,omitempty"`
	// cgroup_id of the process which emitted this event.
	// Only applicable to TraceSock notifications, zero for other types
	CgroupId uint64 `protobuf:"varint,33,opt,name=cgroup_id,json=cgroupId,proto3" json:"cgroup_id,omitempty"`
	// This is a temporary workaround to support summary field for pb.Flow without
	// duplicating logic from the old parser. This field will be removed once we
	// fully migrate to the new parser.
	//
	// Deprecated: Marked as deprecated in flow/flow.proto.
	Summary string `protobuf:"bytes,100000,opt,name=Summary,proto3" json:"Summary,omitempty"`
	// extensions can be used to add arbitrary additional metadata to flows.
	// This can be used to extend functionality for other Hubble compatible
	// APIs, or experiment with new functionality without needing to change the public API.
	Extensions *anypb.Any `protobuf:"bytes,150000,opt,name=extensions,proto3" json:"extensions,omitempty"`
	// The CiliumNetworkPolicies allowing the egress of the flow.
	EgressAllowedBy []*Policy `protobuf:"bytes,21001,rep,name=egress_allowed_by,json=egressAllowedBy,proto3" json:"egress_allowed_by,omitempty"`
	// The CiliumNetworkPolicies allowing the ingress of the flow.
	IngressAllowedBy []*Policy `protobuf:"bytes,21002,rep,name=ingress_allowed_by,json=ingressAllowedBy,proto3" json:"ingress_allowed_by,omitempty"`
	// The CiliumNetworkPolicies denying the egress of the flow.
	EgressDeniedBy []*Policy `protobuf:"bytes,21004,rep,name=egress_denied_by,json=egressDeniedBy,proto3" json:"egress_denied_by,omitempty"`
	// The CiliumNetworkPolicies denying the ingress of the flow.
	IngressDeniedBy []*Policy `protobuf:"bytes,21005,rep,name=ingress_denied_by,json=ingressDeniedBy,proto3" json:"ingress_denied_by,omitempty"`
	// The set of Log values for policies that matched this flow.
	// If no matched policies have an explicit log value configured,
	// this list is empty. Duplicate values are elided; each
	// entry is unique.
	PolicyLog []string `protobuf:"bytes,21006,rep,name=policy_log,json=policyLog,proto3" json:"policy_log,omitempty"`
	// Aggregate contains flow aggregation counters when flow aggregation is enabled.
	// This field is only populated for aggregated flows.
	Aggregate     *Aggregate `protobuf:"bytes,21007,opt,name=aggregate,proto3" json:"aggregate,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Flow) Reset() {
	*x = Flow{}
	mi := &file_flow_flow_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Flow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Flow) ProtoMessage() {}

func (x *Flow) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Flow.ProtoReflect.Descriptor instead.
func (*Flow) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{0}
}

func (x *Flow) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *Flow) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *Flow) GetEmitter() *Emitter {
	if x != nil {
		return x.Emitter
	}
	return nil
}

func (x *Flow) GetVerdict() Verdict {
	if x != nil {
		return x.Verdict
	}
	return Verdict_VERDICT_UNKNOWN
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *Flow) GetDropReason() uint32 {
	if x != nil {
		return x.DropReason
	}
	return 0
}

func (x *Flow) GetAuthType() AuthType {
	if x != nil {
		return x.AuthType
	}
	return AuthType_DISABLED
}

func (x *Flow) GetEthernet() *Ethernet {
	if x != nil {
		return x.Ethernet
	}
	return nil
}

func (x *Flow) GetIP() *IP {
	if x != nil {
		return x.IP
	}
	return nil
}

func (x *Flow) GetL4() *Layer4 {
	if x != nil {
		return x.L4
	}
	return nil
}

func (x *Flow) GetTunnel() *Tunnel {
	if x != nil {
		return x.Tunnel
	}
	return nil
}

func (x *Flow) GetSource() *Endpoint {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Flow) GetDestination() *Endpoint {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *Flow) GetType() FlowType {
	if x != nil {
		return x.Type
	}
	return FlowType_UNKNOWN_TYPE
}

func (x *Flow) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *Flow) GetNodeLabels() []string {
	if x != nil {
		return x.NodeLabels
	}
	return nil
}

func (x *Flow) GetSourceNames() []string {
	if x != nil {
		return x.SourceNames
	}
	return nil
}

func (x *Flow) GetDestinationNames() []string {
	if x != nil {
		return x.DestinationNames
	}
	return nil
}

func (x *Flow) GetL7() *Layer7 {
	if x != nil {
		return x.L7
	}
	return nil
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *Flow) GetReply() bool {
	if x != nil {
		return x.Reply
	}
	return false
}

func (x *Flow) GetEventType() *CiliumEventType {
	if x != nil {
		return x.EventType
	}
	return nil
}

func (x *Flow) GetSourceService() *Service {
	if x != nil {
		return x.SourceService
	}
	return nil
}

func (x *Flow) GetDestinationService() *Service {
	if x != nil {
		return x.DestinationService
	}
	return nil
}

func (x *Flow) GetTrafficDirection() TrafficDirection {
	if x != nil {
		return x.TrafficDirection
	}
	return TrafficDirection_TRAFFIC_DIRECTION_UNKNOWN
}

func (x *Flow) GetPolicyMatchType() uint32 {
	if x != nil {
		return x.PolicyMatchType
	}
	return 0
}

func (x *Flow) GetTraceObservationPoint() TraceObservationPoint {
	if x != nil {
		return x.TraceObservationPoint
	}
	return TraceObservationPoint_UNKNOWN_POINT
}

func (x *Flow) GetTraceReason() TraceReason {
	if x != nil {
		return x.TraceReason
	}
	return TraceReason_TRACE_REASON_UNKNOWN
}

func (x *Flow) GetFile() *FileInfo {
	if x != nil {
		return x.File
	}
	return nil
}

func (x *Flow) GetIpTraceId() *IPTraceID {
	if x != nil {
		return x.IpTraceId
	}
	return nil
}

func (x *Flow) GetDropReasonDesc() DropReason {
	if x != nil {
		return x.DropReasonDesc
	}
	return DropReason_DROP_REASON_UNKNOWN
}

func (x *Flow) GetIsReply() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsReply
	}
	return nil
}

func (x *Flow) GetDebugCapturePoint() DebugCapturePoint {
	if x != nil {
		return x.DebugCapturePoint
	}
	return DebugCapturePoint_DBG_CAPTURE_POINT_UNKNOWN
}

func (x *Flow) GetInterface() *NetworkInterface {
	if x != nil {
		return x.Interface
	}
	return nil
}

func (x *Flow) GetProxyPort() uint32 {
	if x != nil {
		return x.ProxyPort
	}
	return 0
}

func (x *Flow) GetTraceContext() *TraceContext {
	if x != nil {
		return x.TraceContext
	}
	return nil
}

func (x *Flow) GetSockXlatePoint() SocketTranslationPoint {
	if x != nil {
		return x.SockXlatePoint
	}
	return SocketTranslationPoint_SOCK_XLATE_POINT_UNKNOWN
}

func (x *Flow) GetSocketCookie() uint64 {
	if x != nil {
		return x.SocketCookie
	}
	return 0
}

func (x *Flow) GetCgroupId() uint64 {
	if x != nil {
		return x.CgroupId
	}
	return 0
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *Flow) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Flow) GetExtensions() *anypb.Any {
	if x != nil {
		return x.Extensions
	}
	return nil
}

func (x *Flow) GetEgressAllowedBy() []*Policy {
	if x != nil {
		return x.EgressAllowedBy
	}
	return nil
}

func (x *Flow) GetIngressAllowedBy() []*Policy {
	if x != nil {
		return x.IngressAllowedBy
	}
	return nil
}

func (x *Flow) GetEgressDeniedBy() []*Policy {
	if x != nil {
		return x.EgressDeniedBy
	}
	return nil
}

func (x *Flow) GetIngressDeniedBy() []*Policy {
	if x != nil {
		return x.IngressDeniedBy
	}
	return nil
}

func (x *Flow) GetPolicyLog() []string {
	if x != nil {
		return x.PolicyLog
	}
	return nil
}

func (x *Flow) GetAggregate() *Aggregate {
	if x != nil {
		return x.Aggregate
	}
	return nil
}

// Emitter identifies the source that emits a Hubble flow.
type Emitter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name identifies the emitter.
	// The name should be capitalized ("Hubble", not "hubble" nor "HUBBLE").
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// version identifiers the emitter version.
	// The version should not contain a 'v' prefix as sometimes seen ("1.19.0",
	// not "v1.19.0").
	Version       string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Emitter) Reset() {
	*x = Emitter{}
	mi := &file_flow_flow_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Emitter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Emitter) ProtoMessage() {}

func (x *Emitter) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Emitter.ProtoReflect.Descriptor instead.
func (*Emitter) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{1}
}

func (x *Emitter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Emitter) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type FileInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Line          uint32                 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileInfo) Reset() {
	*x = FileInfo{}
	mi := &file_flow_flow_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInfo) ProtoMessage() {}

func (x *FileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInfo.ProtoReflect.Descriptor instead.
func (*FileInfo) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{2}
}

func (x *FileInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileInfo) GetLine() uint32 {
	if x != nil {
		return x.Line
	}
	return 0
}

type Layer4 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Protocol:
	//
	//	*Layer4_TCP
	//	*Layer4_UDP
	//	*Layer4_ICMPv4
	//	*Layer4_ICMPv6
	//	*Layer4_SCTP
	//	*Layer4_VRRP
	//	*Layer4_IGMP
	Protocol      isLayer4_Protocol `protobuf_oneof:"protocol"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Layer4) Reset() {
	*x = Layer4{}
	mi := &file_flow_flow_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Layer4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Layer4) ProtoMessage() {}

func (x *Layer4) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Layer4.ProtoReflect.Descriptor instead.
func (*Layer4) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{3}
}

func (x *Layer4) GetProtocol() isLayer4_Protocol {
	if x != nil {
		return x.Protocol
	}
	return nil
}

func (x *Layer4) GetTCP() *TCP {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_TCP); ok {
			return x.TCP
		}
	}
	return nil
}

func (x *Layer4) GetUDP() *UDP {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_UDP); ok {
			return x.UDP
		}
	}
	return nil
}

func (x *Layer4) GetICMPv4() *ICMPv4 {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_ICMPv4); ok {
			return x.ICMPv4
		}
	}
	return nil
}

func (x *Layer4) GetICMPv6() *ICMPv6 {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_ICMPv6); ok {
			return x.ICMPv6
		}
	}
	return nil
}

func (x *Layer4) GetSCTP() *SCTP {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_SCTP); ok {
			return x.SCTP
		}
	}
	return nil
}

func (x *Layer4) GetVRRP() *VRRP {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_VRRP); ok {
			return x.VRRP
		}
	}
	return nil
}

func (x *Layer4) GetIGMP() *IGMP {
	if x != nil {
		if x, ok := x.Protocol.(*Layer4_IGMP); ok {
			return x.IGMP
		}
	}
	return nil
}

type isLayer4_Protocol interface {
	isLayer4_Protocol()
}

type Layer4_TCP struct {
	TCP *TCP `protobuf:"bytes,1,opt,name=TCP,proto3,oneof"`
}

type Layer4_UDP struct {
	UDP *UDP `protobuf:"bytes,2,opt,name=UDP,proto3,oneof"`
}

type Layer4_ICMPv4 struct {
	// ICMP is technically not L4, but mutually exclusive with the above
	ICMPv4 *ICMPv4 `protobuf:"bytes,3,opt,name=ICMPv4,proto3,oneof"`
}

type Layer4_ICMPv6 struct {
	ICMPv6 *ICMPv6 `protobuf:"bytes,4,opt,name=ICMPv6,proto3,oneof"`
}

type Layer4_SCTP struct {
	SCTP *SCTP `protobuf:"bytes,5,opt,name=SCTP,proto3,oneof"`
}

type Layer4_VRRP struct {
	VRRP *VRRP `protobuf:"bytes,6,opt,name=VRRP,proto3,oneof"`
}

type Layer4_IGMP struct {
	IGMP *IGMP `protobuf:"bytes,7,opt,name=IGMP,proto3,oneof"`
}

func (*Layer4_TCP) isLayer4_Protocol() {}

func (*Layer4_UDP) isLayer4_Protocol() {}

func (*Layer4_ICMPv4) isLayer4_Protocol() {}

func (*Layer4_ICMPv6) isLayer4_Protocol() {}

func (*Layer4_SCTP) isLayer4_Protocol() {}

func (*Layer4_VRRP) isLayer4_Protocol() {}

func (*Layer4_IGMP) isLayer4_Protocol() {}

// Message for L7 flow, which roughly corresponds to Cilium's accesslog [LogRecord](https://github.com/cilium/cilium/blob/728c79e427438ab6f8d9375b62fccd6fed4ace3a/pkg/proxy/accesslog/record.go#L141):
type Layer7 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  L7FlowType             `protobuf:"varint,1,opt,name=type,proto3,enum=flow.L7FlowType" json:"type,omitempty"`
	// Latency of the response
	LatencyNs uint64 `protobuf:"varint,2,opt,name=latency_ns,json=latencyNs,proto3" json:"latency_ns,omitempty"`
	// L7 field. This field is set if and only if FlowType is L7.
	//
	// Types that are valid to be assigned to Record:
	//
	//	*Layer7_Dns
	//	*Layer7_Http
	//	*Layer7_Kafka
	Record        isLayer7_Record `protobuf_oneof:"record"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Layer7) Reset() {
	*x = Layer7{}
	mi := &file_flow_flow_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Layer7) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Layer7) ProtoMessage() {}

func (x *Layer7) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Layer7.ProtoReflect.Descriptor instead.
func (*Layer7) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{4}
}

func (x *Layer7) GetType() L7FlowType {
	if x != nil {
		return x.Type
	}
	return L7FlowType_UNKNOWN_L7_TYPE
}

func (x *Layer7) GetLatencyNs() uint64 {
	if x != nil {
		return x.LatencyNs
	}
	return 0
}

func (x *Layer7) GetRecord() isLayer7_Record {
	if x != nil {
		return x.Record
	}
	return nil
}

func (x *Layer7) GetDns() *DNS {
	if x != nil {
		if x, ok := x.Record.(*Layer7_Dns); ok {
			return x.Dns
		}
	}
	return nil
}

func (x *Layer7) GetHttp() *HTTP {
	if x != nil {
		if x, ok := x.Record.(*Layer7_Http); ok {
			return x.Http
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *Layer7) GetKafka() *Kafka {
	if x != nil {
		if x, ok := x.Record.(*Layer7_Kafka); ok {
			return x.Kafka
		}
	}
	return nil
}

type isLayer7_Record interface {
	isLayer7_Record()
}

type Layer7_Dns struct {
	Dns *DNS `protobuf:"bytes,100,opt,name=dns,proto3,oneof"`
}

type Layer7_Http struct {
	Http *HTTP `protobuf:"bytes,101,opt,name=http,proto3,oneof"`
}

type Layer7_Kafka struct {
	// Deprecated: Marked as deprecated in flow/flow.proto.
	Kafka *Kafka `protobuf:"bytes,102,opt,name=kafka,proto3,oneof"`
}

func (*Layer7_Dns) isLayer7_Record() {}

func (*Layer7_Http) isLayer7_Record() {}

func (*Layer7_Kafka) isLayer7_Record() {}

// TraceContext contains trace context propagation data, i.e. information about a
// distributed trace.
// For more information about trace context, check the [W3C Trace Context specification](https://www.w3.org/TR/trace-context/).
type TraceContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// parent identifies the incoming request in a tracing system.
	Parent        *TraceParent `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TraceContext) Reset() {
	*x = TraceContext{}
	mi := &file_flow_flow_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TraceContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TraceContext) ProtoMessage() {}

func (x *TraceContext) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TraceContext.ProtoReflect.Descriptor instead.
func (*TraceContext) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{5}
}

func (x *TraceContext) GetParent() *TraceParent {
	if x != nil {
		return x.Parent
	}
	return nil
}

// TraceParent identifies the incoming request in a tracing system.
type TraceParent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// trace_id is a unique value that identifies a trace. It is a byte array
	// represented as a hex string.
	TraceId       string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TraceParent) Reset() {
	*x = TraceParent{}
	mi := &file_flow_flow_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TraceParent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TraceParent) ProtoMessage() {}

func (x *TraceParent) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TraceParent.ProtoReflect.Descriptor instead.
func (*TraceParent) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{6}
}

func (x *TraceParent) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

type Endpoint struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	ID          uint32                 `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Identity    uint32                 `protobuf:"varint,2,opt,name=identity,proto3" json:"identity,omitempty"`
	ClusterName string                 `protobuf:"bytes,7,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	Namespace   string                 `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// labels in `foo=bar` format.
	Labels        []string    `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty"`
	PodName       string      `protobuf:"bytes,5,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	Workloads     []*Workload `protobuf:"bytes,6,rep,name=workloads,proto3" json:"workloads,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	mi := &file_flow_flow_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{7}
}

func (x *Endpoint) GetID() uint32 {
	if x != nil {
		return x.ID
	}
	return 0
}

func (x *Endpoint) GetIdentity() uint32 {
	if x != nil {
		return x.Identity
	}
	return 0
}

func (x *Endpoint) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *Endpoint) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Endpoint) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Endpoint) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *Endpoint) GetWorkloads() []*Workload {
	if x != nil {
		return x.Workloads
	}
	return nil
}

type Workload struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Kind          string                 `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Workload) Reset() {
	*x = Workload{}
	mi := &file_flow_flow_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload) ProtoMessage() {}

func (x *Workload) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload.ProtoReflect.Descriptor instead.
func (*Workload) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{8}
}

func (x *Workload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workload) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

type TCP struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	SourcePort      uint32                 `protobuf:"varint,1,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	DestinationPort uint32                 `protobuf:"varint,2,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	Flags           *TCPFlags              `protobuf:"bytes,3,opt,name=flags,proto3" json:"flags,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TCP) Reset() {
	*x = TCP{}
	mi := &file_flow_flow_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TCP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCP) ProtoMessage() {}

func (x *TCP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCP.ProtoReflect.Descriptor instead.
func (*TCP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{9}
}

func (x *TCP) GetSourcePort() uint32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *TCP) GetDestinationPort() uint32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

func (x *TCP) GetFlags() *TCPFlags {
	if x != nil {
		return x.Flags
	}
	return nil
}

type IP struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Source string                 `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// source_xlated is the post-translation source IP when the flow was
	// SNATed. When "source_xlated" is set, the "source" field is populated
	// with the pre-translation source IP address.
	SourceXlated string    `protobuf:"bytes,5,opt,name=source_xlated,json=sourceXlated,proto3" json:"source_xlated,omitempty"`
	Destination  string    `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	IpVersion    IPVersion `protobuf:"varint,3,opt,name=ipVersion,proto3,enum=flow.IPVersion" json:"ipVersion,omitempty"`
	// This field indicates whether the TraceReasonEncryptMask is set or not.
	// https://github.com/cilium/cilium/blob/ba0ed147bd5bb342f67b1794c2ad13c6e99d5236/pkg/monitor/datapath_trace.go#L27
	Encrypted     bool `protobuf:"varint,4,opt,name=encrypted,proto3" json:"encrypted,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IP) Reset() {
	*x = IP{}
	mi := &file_flow_flow_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IP) ProtoMessage() {}

func (x *IP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IP.ProtoReflect.Descriptor instead.
func (*IP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{10}
}

func (x *IP) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *IP) GetSourceXlated() string {
	if x != nil {
		return x.SourceXlated
	}
	return ""
}

func (x *IP) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *IP) GetIpVersion() IPVersion {
	if x != nil {
		return x.IpVersion
	}
	return IPVersion_IP_NOT_USED
}

func (x *IP) GetEncrypted() bool {
	if x != nil {
		return x.Encrypted
	}
	return false
}

type Ethernet struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Source        string                 `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	Destination   string                 `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Ethernet) Reset() {
	*x = Ethernet{}
	mi := &file_flow_flow_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Ethernet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ethernet) ProtoMessage() {}

func (x *Ethernet) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ethernet.ProtoReflect.Descriptor instead.
func (*Ethernet) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{11}
}

func (x *Ethernet) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Ethernet) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

type TCPFlags struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FIN           bool                   `protobuf:"varint,1,opt,name=FIN,proto3" json:"FIN,omitempty"`
	SYN           bool                   `protobuf:"varint,2,opt,name=SYN,proto3" json:"SYN,omitempty"`
	RST           bool                   `protobuf:"varint,3,opt,name=RST,proto3" json:"RST,omitempty"`
	PSH           bool                   `protobuf:"varint,4,opt,name=PSH,proto3" json:"PSH,omitempty"`
	ACK           bool                   `protobuf:"varint,5,opt,name=ACK,proto3" json:"ACK,omitempty"`
	URG           bool                   `protobuf:"varint,6,opt,name=URG,proto3" json:"URG,omitempty"`
	ECE           bool                   `protobuf:"varint,7,opt,name=ECE,proto3" json:"ECE,omitempty"`
	CWR           bool                   `protobuf:"varint,8,opt,name=CWR,proto3" json:"CWR,omitempty"`
	NS            bool                   `protobuf:"varint,9,opt,name=NS,proto3" json:"NS,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TCPFlags) Reset() {
	*x = TCPFlags{}
	mi := &file_flow_flow_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TCPFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPFlags) ProtoMessage() {}

func (x *TCPFlags) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPFlags.ProtoReflect.Descriptor instead.
func (*TCPFlags) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{12}
}

func (x *TCPFlags) GetFIN() bool {
	if x != nil {
		return x.FIN
	}
	return false
}

func (x *TCPFlags) GetSYN() bool {
	if x != nil {
		return x.SYN
	}
	return false
}

func (x *TCPFlags) GetRST() bool {
	if x != nil {
		return x.RST
	}
	return false
}

func (x *TCPFlags) GetPSH() bool {
	if x != nil {
		return x.PSH
	}
	return false
}

func (x *TCPFlags) GetACK() bool {
	if x != nil {
		return x.ACK
	}
	return false
}

func (x *TCPFlags) GetURG() bool {
	if x != nil {
		return x.URG
	}
	return false
}

func (x *TCPFlags) GetECE() bool {
	if x != nil {
		return x.ECE
	}
	return false
}

func (x *TCPFlags) GetCWR() bool {
	if x != nil {
		return x.CWR
	}
	return false
}

func (x *TCPFlags) GetNS() bool {
	if x != nil {
		return x.NS
	}
	return false
}

type UDP struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	SourcePort      uint32                 `protobuf:"varint,1,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	DestinationPort uint32                 `protobuf:"varint,2,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *UDP) Reset() {
	*x = UDP{}
	mi := &file_flow_flow_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UDP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UDP) ProtoMessage() {}

func (x *UDP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UDP.ProtoReflect.Descriptor instead.
func (*UDP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{13}
}

func (x *UDP) GetSourcePort() uint32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *UDP) GetDestinationPort() uint32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

type SCTP struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	SourcePort      uint32                 `protobuf:"varint,1,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	DestinationPort uint32                 `protobuf:"varint,2,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SCTP) Reset() {
	*x = SCTP{}
	mi := &file_flow_flow_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SCTP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SCTP) ProtoMessage() {}

func (x *SCTP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SCTP.ProtoReflect.Descriptor instead.
func (*SCTP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{14}
}

func (x *SCTP) GetSourcePort() uint32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *SCTP) GetDestinationPort() uint32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

type ICMPv4 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Code          uint32                 `protobuf:"varint,2,opt,name=code,proto3" json:"code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ICMPv4) Reset() {
	*x = ICMPv4{}
	mi := &file_flow_flow_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ICMPv4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ICMPv4) ProtoMessage() {}

func (x *ICMPv4) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ICMPv4.ProtoReflect.Descriptor instead.
func (*ICMPv4) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{15}
}

func (x *ICMPv4) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *ICMPv4) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type ICMPv6 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Code          uint32                 `protobuf:"varint,2,opt,name=code,proto3" json:"code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ICMPv6) Reset() {
	*x = ICMPv6{}
	mi := &file_flow_flow_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ICMPv6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ICMPv6) ProtoMessage() {}

func (x *ICMPv6) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ICMPv6.ProtoReflect.Descriptor instead.
func (*ICMPv6) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{16}
}

func (x *ICMPv6) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *ICMPv6) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

type VRRP struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Vrid          uint32                 `protobuf:"varint,2,opt,name=vrid,proto3" json:"vrid,omitempty"`
	Priority      uint32                 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VRRP) Reset() {
	*x = VRRP{}
	mi := &file_flow_flow_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VRRP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRRP) ProtoMessage() {}

func (x *VRRP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRRP.ProtoReflect.Descriptor instead.
func (*VRRP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{17}
}

func (x *VRRP) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *VRRP) GetVrid() uint32 {
	if x != nil {
		return x.Vrid
	}
	return 0
}

func (x *VRRP) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

type IGMP struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	GroupAddress  string                 `protobuf:"bytes,2,opt,name=group_address,json=groupAddress,proto3" json:"group_address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IGMP) Reset() {
	*x = IGMP{}
	mi := &file_flow_flow_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IGMP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IGMP) ProtoMessage() {}

func (x *IGMP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IGMP.ProtoReflect.Descriptor instead.
func (*IGMP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{18}
}

func (x *IGMP) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *IGMP) GetGroupAddress() string {
	if x != nil {
		return x.GroupAddress
	}
	return ""
}

type Tunnel struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Protocol      Tunnel_Protocol        `protobuf:"varint,1,opt,name=protocol,proto3,enum=flow.Tunnel_Protocol" json:"protocol,omitempty"`
	IP            *IP                    `protobuf:"bytes,2,opt,name=IP,proto3" json:"IP,omitempty"`
	L4            *Layer4                `protobuf:"bytes,3,opt,name=l4,proto3" json:"l4,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tunnel) Reset() {
	*x = Tunnel{}
	mi := &file_flow_flow_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tunnel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tunnel) ProtoMessage() {}

func (x *Tunnel) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tunnel.ProtoReflect.Descriptor instead.
func (*Tunnel) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{19}
}

func (x *Tunnel) GetProtocol() Tunnel_Protocol {
	if x != nil {
		return x.Protocol
	}
	return Tunnel_UNKNOWN
}

func (x *Tunnel) GetIP() *IP {
	if x != nil {
		return x.IP
	}
	return nil
}

func (x *Tunnel) GetL4() *Layer4 {
	if x != nil {
		return x.L4
	}
	return nil
}

type Policy struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Labels        []string               `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	Revision      uint64                 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
	Kind          string                 `protobuf:"bytes,5,opt,name=kind,proto3" json:"kind,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Policy) Reset() {
	*x = Policy{}
	mi := &file_flow_flow_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{20}
}

func (x *Policy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Policy) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Policy) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Policy) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *Policy) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// EventTypeFilter is a filter describing a particular event type.
type EventTypeFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type is the primary flow type as defined by:
	// github.com/cilium/cilium/pkg/monitor/api.MessageType*
	Type int32 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	// match_sub_type is set to true when matching on the sub_type should
	// be done. This flag is required as 0 is a valid sub_type.
	MatchSubType bool `protobuf:"varint,2,opt,name=match_sub_type,json=matchSubType,proto3" json:"match_sub_type,omitempty"`
	// sub_type is the secondary type, e.g.
	// - github.com/cilium/cilium/pkg/monitor/api.Trace*
	SubType       int32 `protobuf:"varint,3,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EventTypeFilter) Reset() {
	*x = EventTypeFilter{}
	mi := &file_flow_flow_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventTypeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventTypeFilter) ProtoMessage() {}

func (x *EventTypeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventTypeFilter.ProtoReflect.Descriptor instead.
func (*EventTypeFilter) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{21}
}

func (x *EventTypeFilter) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *EventTypeFilter) GetMatchSubType() bool {
	if x != nil {
		return x.MatchSubType
	}
	return false
}

func (x *EventTypeFilter) GetSubType() int32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

// CiliumEventType from which the flow originated.
type CiliumEventType struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type of event the flow originated from, i.e.
	// github.com/cilium/cilium/pkg/monitor/api.MessageType*
	Type int32 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	// sub_type may indicate more details depending on type, e.g.
	// - github.com/cilium/cilium/pkg/monitor/api.Trace*
	// - github.com/cilium/cilium/pkg/monitor/api.Drop*
	// - github.com/cilium/cilium/pkg/monitor/api.DbgCapture*
	SubType       int32 `protobuf:"varint,2,opt,name=sub_type,json=subType,proto3" json:"sub_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CiliumEventType) Reset() {
	*x = CiliumEventType{}
	mi := &file_flow_flow_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CiliumEventType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CiliumEventType) ProtoMessage() {}

func (x *CiliumEventType) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CiliumEventType.ProtoReflect.Descriptor instead.
func (*CiliumEventType) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{22}
}

func (x *CiliumEventType) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *CiliumEventType) GetSubType() int32 {
	if x != nil {
		return x.SubType
	}
	return 0
}

// FlowFilter represent an individual flow filter. All fields are optional. If
// multiple fields are set, then all fields must match for the filter to match.
type FlowFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// uuid filters by a list of flow uuids.
	Uuid []string `protobuf:"bytes,29,rep,name=uuid,proto3" json:"uuid,omitempty"`
	// source_ip filters by a list of source ips. Each of the source ips can be
	// specified as an exact match (e.g. "1.1.1.1") or as a CIDR range (e.g.
	// "1.1.1.0/24").
	SourceIp []string `protobuf:"bytes,1,rep,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// source_ip_xlated filters by a list IPs. Each of the IPs can be specified
	// as an exact match (e.g. "1.1.1.1") or as a CIDR range (e.g.
	// "1.1.1.0/24").
	SourceIpXlated []string `protobuf:"bytes,34,rep,name=source_ip_xlated,json=sourceIpXlated,proto3" json:"source_ip_xlated,omitempty"`
	// source_pod filters by a list of source pod name prefixes, optionally
	// within a given namespace (e.g. "xwing", "kube-system/coredns-").
	// The pod name can be omitted to only filter by namespace
	// (e.g. "kube-system/") or the namespace can be omitted to filter for
	// pods in any namespace (e.g. "/xwing")
	SourcePod []string `protobuf:"bytes,2,rep,name=source_pod,json=sourcePod,proto3" json:"source_pod,omitempty"`
	// source_fqdn filters by a list of source fully qualified domain names
	SourceFqdn []string `protobuf:"bytes,7,rep,name=source_fqdn,json=sourceFqdn,proto3" json:"source_fqdn,omitempty"`
	// source_labels filters on a list of source label selectors. Selectors
	// support the full Kubernetes label selector syntax.
	SourceLabel []string `protobuf:"bytes,10,rep,name=source_label,json=sourceLabel,proto3" json:"source_label,omitempty"`
	// source_service filters on a list of source service names. This field
	// supports the same syntax as the source_pod field.
	SourceService []string `protobuf:"bytes,16,rep,name=source_service,json=sourceService,proto3" json:"source_service,omitempty"`
	// source_workload filters by a list of source workload.
	SourceWorkload []*Workload `protobuf:"bytes,26,rep,name=source_workload,json=sourceWorkload,proto3" json:"source_workload,omitempty"`
	// source_cluster_name filters by a list of source cluster names.
	SourceClusterName []string `protobuf:"bytes,37,rep,name=source_cluster_name,json=sourceClusterName,proto3" json:"source_cluster_name,omitempty"`
	// destination_ip filters by a list of destination ips. Each of the
	// destination ips can be specified as an exact match (e.g. "1.1.1.1") or
	// as a CIDR range (e.g. "1.1.1.0/24").
	DestinationIp []string `protobuf:"bytes,3,rep,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// destination_pod filters by a list of destination pod names
	DestinationPod []string `protobuf:"bytes,4,rep,name=destination_pod,json=destinationPod,proto3" json:"destination_pod,omitempty"`
	// destination_fqdn filters by a list of destination fully qualified domain names
	DestinationFqdn []string `protobuf:"bytes,8,rep,name=destination_fqdn,json=destinationFqdn,proto3" json:"destination_fqdn,omitempty"`
	// destination_label filters on a list of destination label selectors
	DestinationLabel []string `protobuf:"bytes,11,rep,name=destination_label,json=destinationLabel,proto3" json:"destination_label,omitempty"`
	// destination_service filters on a list of destination service names
	DestinationService []string `protobuf:"bytes,17,rep,name=destination_service,json=destinationService,proto3" json:"destination_service,omitempty"`
	// destination_workload filters by a list of destination workload.
	DestinationWorkload []*Workload `protobuf:"bytes,27,rep,name=destination_workload,json=destinationWorkload,proto3" json:"destination_workload,omitempty"`
	// destination_cluster_name filters by a list of destination cluster names.
	DestinationClusterName []string `protobuf:"bytes,38,rep,name=destination_cluster_name,json=destinationClusterName,proto3" json:"destination_cluster_name,omitempty"`
	// traffic_direction filters flow by direction of the connection, e.g.
	// ingress or egress.
	TrafficDirection []TrafficDirection `protobuf:"varint,30,rep,packed,name=traffic_direction,json=trafficDirection,proto3,enum=flow.TrafficDirection" json:"traffic_direction,omitempty"`
	// only return Flows that were classified with a particular verdict.
	Verdict []Verdict `protobuf:"varint,5,rep,packed,name=verdict,proto3,enum=flow.Verdict" json:"verdict,omitempty"`
	// only applicable to Verdict = DROPPED (e.g. "POLICY_DENIED", "UNSUPPORTED_L3_PROTOCOL")
	DropReasonDesc []DropReason `protobuf:"varint,33,rep,packed,name=drop_reason_desc,json=dropReasonDesc,proto3,enum=flow.DropReason" json:"drop_reason_desc,omitempty"`
	// interface is the network interface on which this flow was observed.
	Interface []*NetworkInterface `protobuf:"bytes,35,rep,name=interface,proto3" json:"interface,omitempty"`
	// event_type is the list of event types to filter on
	EventType []*EventTypeFilter `protobuf:"bytes,6,rep,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// http_status_code is a list of string prefixes (e.g. "4+", "404", "5+")
	// to filter on the HTTP status code
	HttpStatusCode []string `protobuf:"bytes,9,rep,name=http_status_code,json=httpStatusCode,proto3" json:"http_status_code,omitempty"`
	// protocol filters flows by L4 or L7 protocol, e.g. (e.g. "tcp", "http")
	Protocol []string `protobuf:"bytes,12,rep,name=protocol,proto3" json:"protocol,omitempty"`
	// source_port filters flows by L4 source port
	SourcePort []string `protobuf:"bytes,13,rep,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	// destination_port filters flows by L4 destination port
	DestinationPort []string `protobuf:"bytes,14,rep,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// reply filters flows based on the direction of the flow.
	Reply []bool `protobuf:"varint,15,rep,packed,name=reply,proto3" json:"reply,omitempty"`
	// dns_query filters L7 DNS flows by query patterns (RE2 regex), e.g. 'kube.*local'.
	DnsQuery []string `protobuf:"bytes,18,rep,name=dns_query,json=dnsQuery,proto3" json:"dns_query,omitempty"`
	// source_identity filters by the security identity of the source endpoint.
	SourceIdentity []uint32 `protobuf:"varint,19,rep,packed,name=source_identity,json=sourceIdentity,proto3" json:"source_identity,omitempty"`
	// destination_identity filters by the security identity of the destination endpoint.
	DestinationIdentity []uint32 `protobuf:"varint,20,rep,packed,name=destination_identity,json=destinationIdentity,proto3" json:"destination_identity,omitempty"`
	// GET, POST, PUT, etc. methods. This type of field is well suited for an
	// enum but every single existing place is using a string already.
	HttpMethod []string `protobuf:"bytes,21,rep,name=http_method,json=httpMethod,proto3" json:"http_method,omitempty"`
	// http_path is a list of regular expressions to filter on the HTTP path.
	HttpPath []string `protobuf:"bytes,22,rep,name=http_path,json=httpPath,proto3" json:"http_path,omitempty"`
	// http_url is a list of regular expressions to filter on the HTTP URL.
	HttpUrl []string `protobuf:"bytes,31,rep,name=http_url,json=httpUrl,proto3" json:"http_url,omitempty"`
	// http_header is a list of key:value pairs to filter on the HTTP headers.
	HttpHeader []*HTTPHeader `protobuf:"bytes,32,rep,name=http_header,json=httpHeader,proto3" json:"http_header,omitempty"`
	// tcp_flags filters flows based on TCP header flags
	TcpFlags []*TCPFlags `protobuf:"bytes,23,rep,name=tcp_flags,json=tcpFlags,proto3" json:"tcp_flags,omitempty"`
	// node_name is a list of patterns to filter on the node name, e.g. "k8s*",
	// "test-cluster/*.domain.com", "cluster-name/" etc.
	NodeName []string `protobuf:"bytes,24,rep,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// node_labels filters on a list of node label selectors. Selectors support
	// the full Kubernetes label selector syntax.
	NodeLabels []string `protobuf:"bytes,36,rep,name=node_labels,json=nodeLabels,proto3" json:"node_labels,omitempty"`
	// filter based on IP version (ipv4 or ipv6)
	IpVersion []IPVersion `protobuf:"varint,25,rep,packed,name=ip_version,json=ipVersion,proto3,enum=flow.IPVersion" json:"ip_version,omitempty"`
	// trace_id filters flows by trace ID
	TraceId []string `protobuf:"bytes,28,rep,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// ip_trace_id filters flows by IPTraceID
	IpTraceId []uint64 `protobuf:"varint,39,rep,packed,name=ip_trace_id,json=ipTraceId,proto3" json:"ip_trace_id,omitempty"`
	// experimental contains filters that are not stable yet. Support for
	// experimental features is always optional and subject to change.
	Experimental  *FlowFilter_Experimental `protobuf:"bytes,999,opt,name=experimental,proto3" json:"experimental,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowFilter) Reset() {
	*x = FlowFilter{}
	mi := &file_flow_flow_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowFilter) ProtoMessage() {}

func (x *FlowFilter) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowFilter.ProtoReflect.Descriptor instead.
func (*FlowFilter) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{23}
}

func (x *FlowFilter) GetUuid() []string {
	if x != nil {
		return x.Uuid
	}
	return nil
}

func (x *FlowFilter) GetSourceIp() []string {
	if x != nil {
		return x.SourceIp
	}
	return nil
}

func (x *FlowFilter) GetSourceIpXlated() []string {
	if x != nil {
		return x.SourceIpXlated
	}
	return nil
}

func (x *FlowFilter) GetSourcePod() []string {
	if x != nil {
		return x.SourcePod
	}
	return nil
}

func (x *FlowFilter) GetSourceFqdn() []string {
	if x != nil {
		return x.SourceFqdn
	}
	return nil
}

func (x *FlowFilter) GetSourceLabel() []string {
	if x != nil {
		return x.SourceLabel
	}
	return nil
}

func (x *FlowFilter) GetSourceService() []string {
	if x != nil {
		return x.SourceService
	}
	return nil
}

func (x *FlowFilter) GetSourceWorkload() []*Workload {
	if x != nil {
		return x.SourceWorkload
	}
	return nil
}

func (x *FlowFilter) GetSourceClusterName() []string {
	if x != nil {
		return x.SourceClusterName
	}
	return nil
}

func (x *FlowFilter) GetDestinationIp() []string {
	if x != nil {
		return x.DestinationIp
	}
	return nil
}

func (x *FlowFilter) GetDestinationPod() []string {
	if x != nil {
		return x.DestinationPod
	}
	return nil
}

func (x *FlowFilter) GetDestinationFqdn() []string {
	if x != nil {
		return x.DestinationFqdn
	}
	return nil
}

func (x *FlowFilter) GetDestinationLabel() []string {
	if x != nil {
		return x.DestinationLabel
	}
	return nil
}

func (x *FlowFilter) GetDestinationService() []string {
	if x != nil {
		return x.DestinationService
	}
	return nil
}

func (x *FlowFilter) GetDestinationWorkload() []*Workload {
	if x != nil {
		return x.DestinationWorkload
	}
	return nil
}

func (x *FlowFilter) GetDestinationClusterName() []string {
	if x != nil {
		return x.DestinationClusterName
	}
	return nil
}

func (x *FlowFilter) GetTrafficDirection() []TrafficDirection {
	if x != nil {
		return x.TrafficDirection
	}
	return nil
}

func (x *FlowFilter) GetVerdict() []Verdict {
	if x != nil {
		return x.Verdict
	}
	return nil
}

func (x *FlowFilter) GetDropReasonDesc() []DropReason {
	if x != nil {
		return x.DropReasonDesc
	}
	return nil
}

func (x *FlowFilter) GetInterface() []*NetworkInterface {
	if x != nil {
		return x.Interface
	}
	return nil
}

func (x *FlowFilter) GetEventType() []*EventTypeFilter {
	if x != nil {
		return x.EventType
	}
	return nil
}

func (x *FlowFilter) GetHttpStatusCode() []string {
	if x != nil {
		return x.HttpStatusCode
	}
	return nil
}

func (x *FlowFilter) GetProtocol() []string {
	if x != nil {
		return x.Protocol
	}
	return nil
}

func (x *FlowFilter) GetSourcePort() []string {
	if x != nil {
		return x.SourcePort
	}
	return nil
}

func (x *FlowFilter) GetDestinationPort() []string {
	if x != nil {
		return x.DestinationPort
	}
	return nil
}

func (x *FlowFilter) GetReply() []bool {
	if x != nil {
		return x.Reply
	}
	return nil
}

func (x *FlowFilter) GetDnsQuery() []string {
	if x != nil {
		return x.DnsQuery
	}
	return nil
}

func (x *FlowFilter) GetSourceIdentity() []uint32 {
	if x != nil {
		return x.SourceIdentity
	}
	return nil
}

func (x *FlowFilter) GetDestinationIdentity() []uint32 {
	if x != nil {
		return x.DestinationIdentity
	}
	return nil
}

func (x *FlowFilter) GetHttpMethod() []string {
	if x != nil {
		return x.HttpMethod
	}
	return nil
}

func (x *FlowFilter) GetHttpPath() []string {
	if x != nil {
		return x.HttpPath
	}
	return nil
}

func (x *FlowFilter) GetHttpUrl() []string {
	if x != nil {
		return x.HttpUrl
	}
	return nil
}

func (x *FlowFilter) GetHttpHeader() []*HTTPHeader {
	if x != nil {
		return x.HttpHeader
	}
	return nil
}

func (x *FlowFilter) GetTcpFlags() []*TCPFlags {
	if x != nil {
		return x.TcpFlags
	}
	return nil
}

func (x *FlowFilter) GetNodeName() []string {
	if x != nil {
		return x.NodeName
	}
	return nil
}

func (x *FlowFilter) GetNodeLabels() []string {
	if x != nil {
		return x.NodeLabels
	}
	return nil
}

func (x *FlowFilter) GetIpVersion() []IPVersion {
	if x != nil {
		return x.IpVersion
	}
	return nil
}

func (x *FlowFilter) GetTraceId() []string {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *FlowFilter) GetIpTraceId() []uint64 {
	if x != nil {
		return x.IpTraceId
	}
	return nil
}

func (x *FlowFilter) GetExperimental() *FlowFilter_Experimental {
	if x != nil {
		return x.Experimental
	}
	return nil
}

// DNS flow. This is basically directly mapped from Cilium's [LogRecordDNS](https://github.com/cilium/cilium/blob/04f3889d627774f79e56d14ddbc165b3169e2d01/pkg/proxy/accesslog/record.go#L264):
type DNS struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// DNS name that's being looked up: e.g. "isovalent.com."
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// List of IP addresses in the DNS response.
	Ips []string `protobuf:"bytes,2,rep,name=ips,proto3" json:"ips,omitempty"`
	// TTL in the DNS response.
	Ttl uint32 `protobuf:"varint,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// List of CNames in the DNS response.
	Cnames []string `protobuf:"bytes,4,rep,name=cnames,proto3" json:"cnames,omitempty"`
	// Corresponds to DNSDataSource defined in:
	//
	//	https://github.com/cilium/cilium/blob/04f3889d627774f79e56d14ddbc165b3169e2d01/pkg/proxy/accesslog/record.go#L253
	ObservationSource string `protobuf:"bytes,5,opt,name=observation_source,json=observationSource,proto3" json:"observation_source,omitempty"`
	// Return code of the DNS request defined in:
	//
	//	https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6
	Rcode uint32 `protobuf:"varint,6,opt,name=rcode,proto3" json:"rcode,omitempty"`
	// String representation of qtypes defined in:
	//
	//	https://tools.ietf.org/html/rfc1035#section-3.2.3
	Qtypes []string `protobuf:"bytes,7,rep,name=qtypes,proto3" json:"qtypes,omitempty"`
	// String representation of rrtypes defined in:
	// https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4
	Rrtypes       []string `protobuf:"bytes,8,rep,name=rrtypes,proto3" json:"rrtypes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DNS) Reset() {
	*x = DNS{}
	mi := &file_flow_flow_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNS) ProtoMessage() {}

func (x *DNS) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNS.ProtoReflect.Descriptor instead.
func (*DNS) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{24}
}

func (x *DNS) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *DNS) GetIps() []string {
	if x != nil {
		return x.Ips
	}
	return nil
}

func (x *DNS) GetTtl() uint32 {
	if x != nil {
		return x.Ttl
	}
	return 0
}

func (x *DNS) GetCnames() []string {
	if x != nil {
		return x.Cnames
	}
	return nil
}

func (x *DNS) GetObservationSource() string {
	if x != nil {
		return x.ObservationSource
	}
	return ""
}

func (x *DNS) GetRcode() uint32 {
	if x != nil {
		return x.Rcode
	}
	return 0
}

func (x *DNS) GetQtypes() []string {
	if x != nil {
		return x.Qtypes
	}
	return nil
}

func (x *DNS) GetRrtypes() []string {
	if x != nil {
		return x.Rrtypes
	}
	return nil
}

type HTTPHeader struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         string                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPHeader) Reset() {
	*x = HTTPHeader{}
	mi := &file_flow_flow_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeader) ProtoMessage() {}

func (x *HTTPHeader) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeader.ProtoReflect.Descriptor instead.
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{25}
}

func (x *HTTPHeader) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *HTTPHeader) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// L7 information for HTTP flows. It corresponds to Cilium's [accesslog.LogRecordHTTP](https://github.com/cilium/cilium/blob/728c79e427438ab6f8d9375b62fccd6fed4ace3a/pkg/proxy/accesslog/record.go#L206) type.
type HTTP struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Code          uint32                 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Method        string                 `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	Url           string                 `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	Protocol      string                 `protobuf:"bytes,4,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Headers       []*HTTPHeader          `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTP) Reset() {
	*x = HTTP{}
	mi := &file_flow_flow_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTP) ProtoMessage() {}

func (x *HTTP) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTP.ProtoReflect.Descriptor instead.
func (*HTTP) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{26}
}

func (x *HTTP) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *HTTP) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *HTTP) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HTTP) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *HTTP) GetHeaders() []*HTTPHeader {
	if x != nil {
		return x.Headers
	}
	return nil
}

// L7 information for Kafka flows. It corresponds to Cilium's [accesslog.LogRecordKafka](https://github.com/cilium/cilium/blob/728c79e427438ab6f8d9375b62fccd6fed4ace3a/pkg/proxy/accesslog/record.go#L229) type.
//
// Deprecated: Marked as deprecated in flow/flow.proto.
type Kafka struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ErrorCode     int32                  `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3" json:"error_code,omitempty"`
	ApiVersion    int32                  `protobuf:"varint,2,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	ApiKey        string                 `protobuf:"bytes,3,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	CorrelationId int32                  `protobuf:"varint,4,opt,name=correlation_id,json=correlationId,proto3" json:"correlation_id,omitempty"`
	Topic         string                 `protobuf:"bytes,5,opt,name=topic,proto3" json:"topic,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Kafka) Reset() {
	*x = Kafka{}
	mi := &file_flow_flow_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kafka) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kafka) ProtoMessage() {}

func (x *Kafka) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kafka.ProtoReflect.Descriptor instead.
func (*Kafka) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{27}
}

func (x *Kafka) GetErrorCode() int32 {
	if x != nil {
		return x.ErrorCode
	}
	return 0
}

func (x *Kafka) GetApiVersion() int32 {
	if x != nil {
		return x.ApiVersion
	}
	return 0
}

func (x *Kafka) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *Kafka) GetCorrelationId() int32 {
	if x != nil {
		return x.CorrelationId
	}
	return 0
}

func (x *Kafka) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

type Service struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_flow_flow_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{28}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type IPTraceID struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TraceId       uint64                 `protobuf:"varint,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	IpOptionType  uint32                 `protobuf:"varint,2,opt,name=ip_option_type,json=ipOptionType,proto3" json:"ip_option_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IPTraceID) Reset() {
	*x = IPTraceID{}
	mi := &file_flow_flow_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPTraceID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPTraceID) ProtoMessage() {}

func (x *IPTraceID) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPTraceID.ProtoReflect.Descriptor instead.
func (*IPTraceID) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{29}
}

func (x *IPTraceID) GetTraceId() uint64 {
	if x != nil {
		return x.TraceId
	}
	return 0
}

func (x *IPTraceID) GetIpOptionType() uint32 {
	if x != nil {
		return x.IpOptionType
	}
	return 0
}

// LostEvent is a message which notifies consumers about a loss of events
// that happened before the events were captured by Hubble.
type LostEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// source is the location where events got lost.
	Source LostEventSource `protobuf:"varint,1,opt,name=source,proto3,enum=flow.LostEventSource" json:"source,omitempty"`
	// num_events_lost is the number of events that haven been lost at source.
	NumEventsLost uint64 `protobuf:"varint,2,opt,name=num_events_lost,json=numEventsLost,proto3" json:"num_events_lost,omitempty"`
	// cpu on which the event was lost if the source of lost events is
	// PERF_EVENT_RING_BUFFER.
	Cpu *wrapperspb.Int32Value `protobuf:"bytes,3,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// first is the timestamp of the first event that was lost.
	First *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=first,proto3" json:"first,omitempty"`
	// last is the timestamp of the last event that was lost.
	Last          *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last,proto3" json:"last,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LostEvent) Reset() {
	*x = LostEvent{}
	mi := &file_flow_flow_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LostEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LostEvent) ProtoMessage() {}

func (x *LostEvent) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LostEvent.ProtoReflect.Descriptor instead.
func (*LostEvent) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{30}
}

func (x *LostEvent) GetSource() LostEventSource {
	if x != nil {
		return x.Source
	}
	return LostEventSource_UNKNOWN_LOST_EVENT_SOURCE
}

func (x *LostEvent) GetNumEventsLost() uint64 {
	if x != nil {
		return x.NumEventsLost
	}
	return 0
}

func (x *LostEvent) GetCpu() *wrapperspb.Int32Value {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *LostEvent) GetFirst() *timestamppb.Timestamp {
	if x != nil {
		return x.First
	}
	return nil
}

func (x *LostEvent) GetLast() *timestamppb.Timestamp {
	if x != nil {
		return x.Last
	}
	return nil
}

type AgentEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  AgentEventType         `protobuf:"varint,1,opt,name=type,proto3,enum=flow.AgentEventType" json:"type,omitempty"`
	// Types that are valid to be assigned to Notification:
	//
	//	*AgentEvent_Unknown
	//	*AgentEvent_AgentStart
	//	*AgentEvent_PolicyUpdate
	//	*AgentEvent_EndpointRegenerate
	//	*AgentEvent_EndpointUpdate
	//	*AgentEvent_IpcacheUpdate
	//	*AgentEvent_ServiceUpsert
	//	*AgentEvent_ServiceDelete
	Notification  isAgentEvent_Notification `protobuf_oneof:"notification"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AgentEvent) Reset() {
	*x = AgentEvent{}
	mi := &file_flow_flow_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentEvent) ProtoMessage() {}

func (x *AgentEvent) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentEvent.ProtoReflect.Descriptor instead.
func (*AgentEvent) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{31}
}

func (x *AgentEvent) GetType() AgentEventType {
	if x != nil {
		return x.Type
	}
	return AgentEventType_AGENT_EVENT_UNKNOWN
}

func (x *AgentEvent) GetNotification() isAgentEvent_Notification {
	if x != nil {
		return x.Notification
	}
	return nil
}

func (x *AgentEvent) GetUnknown() *AgentEventUnknown {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_Unknown); ok {
			return x.Unknown
		}
	}
	return nil
}

func (x *AgentEvent) GetAgentStart() *TimeNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_AgentStart); ok {
			return x.AgentStart
		}
	}
	return nil
}

func (x *AgentEvent) GetPolicyUpdate() *PolicyUpdateNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_PolicyUpdate); ok {
			return x.PolicyUpdate
		}
	}
	return nil
}

func (x *AgentEvent) GetEndpointRegenerate() *EndpointRegenNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_EndpointRegenerate); ok {
			return x.EndpointRegenerate
		}
	}
	return nil
}

func (x *AgentEvent) GetEndpointUpdate() *EndpointUpdateNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_EndpointUpdate); ok {
			return x.EndpointUpdate
		}
	}
	return nil
}

func (x *AgentEvent) GetIpcacheUpdate() *IPCacheNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_IpcacheUpdate); ok {
			return x.IpcacheUpdate
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *AgentEvent) GetServiceUpsert() *ServiceUpsertNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_ServiceUpsert); ok {
			return x.ServiceUpsert
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *AgentEvent) GetServiceDelete() *ServiceDeleteNotification {
	if x != nil {
		if x, ok := x.Notification.(*AgentEvent_ServiceDelete); ok {
			return x.ServiceDelete
		}
	}
	return nil
}

type isAgentEvent_Notification interface {
	isAgentEvent_Notification()
}

type AgentEvent_Unknown struct {
	Unknown *AgentEventUnknown `protobuf:"bytes,100,opt,name=unknown,proto3,oneof"`
}

type AgentEvent_AgentStart struct {
	AgentStart *TimeNotification `protobuf:"bytes,101,opt,name=agent_start,json=agentStart,proto3,oneof"`
}

type AgentEvent_PolicyUpdate struct {
	// used for POLICY_UPDATED and POLICY_DELETED
	PolicyUpdate *PolicyUpdateNotification `protobuf:"bytes,102,opt,name=policy_update,json=policyUpdate,proto3,oneof"`
}

type AgentEvent_EndpointRegenerate struct {
	// used for ENDPOINT_REGENERATE_SUCCESS and ENDPOINT_REGENERATE_FAILURE
	EndpointRegenerate *EndpointRegenNotification `protobuf:"bytes,103,opt,name=endpoint_regenerate,json=endpointRegenerate,proto3,oneof"`
}

type AgentEvent_EndpointUpdate struct {
	// used for ENDPOINT_CREATED and ENDPOINT_DELETED
	EndpointUpdate *EndpointUpdateNotification `protobuf:"bytes,104,opt,name=endpoint_update,json=endpointUpdate,proto3,oneof"`
}

type AgentEvent_IpcacheUpdate struct {
	// used for IPCACHE_UPSERTED and IPCACHE_DELETED
	IpcacheUpdate *IPCacheNotification `protobuf:"bytes,105,opt,name=ipcache_update,json=ipcacheUpdate,proto3,oneof"`
}

type AgentEvent_ServiceUpsert struct {
	// Deprecated: Marked as deprecated in flow/flow.proto.
	ServiceUpsert *ServiceUpsertNotification `protobuf:"bytes,106,opt,name=service_upsert,json=serviceUpsert,proto3,oneof"`
}

type AgentEvent_ServiceDelete struct {
	// Deprecated: Marked as deprecated in flow/flow.proto.
	ServiceDelete *ServiceDeleteNotification `protobuf:"bytes,107,opt,name=service_delete,json=serviceDelete,proto3,oneof"`
}

func (*AgentEvent_Unknown) isAgentEvent_Notification() {}

func (*AgentEvent_AgentStart) isAgentEvent_Notification() {}

func (*AgentEvent_PolicyUpdate) isAgentEvent_Notification() {}

func (*AgentEvent_EndpointRegenerate) isAgentEvent_Notification() {}

func (*AgentEvent_EndpointUpdate) isAgentEvent_Notification() {}

func (*AgentEvent_IpcacheUpdate) isAgentEvent_Notification() {}

func (*AgentEvent_ServiceUpsert) isAgentEvent_Notification() {}

func (*AgentEvent_ServiceDelete) isAgentEvent_Notification() {}

type AgentEventUnknown struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          string                 `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Notification  string                 `protobuf:"bytes,2,opt,name=notification,proto3" json:"notification,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AgentEventUnknown) Reset() {
	*x = AgentEventUnknown{}
	mi := &file_flow_flow_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentEventUnknown) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentEventUnknown) ProtoMessage() {}

func (x *AgentEventUnknown) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentEventUnknown.ProtoReflect.Descriptor instead.
func (*AgentEventUnknown) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{32}
}

func (x *AgentEventUnknown) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AgentEventUnknown) GetNotification() string {
	if x != nil {
		return x.Notification
	}
	return ""
}

type TimeNotification struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Time          *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TimeNotification) Reset() {
	*x = TimeNotification{}
	mi := &file_flow_flow_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeNotification) ProtoMessage() {}

func (x *TimeNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeNotification.ProtoReflect.Descriptor instead.
func (*TimeNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{33}
}

func (x *TimeNotification) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type PolicyUpdateNotification struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Labels        []string               `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	Revision      uint64                 `protobuf:"varint,2,opt,name=revision,proto3" json:"revision,omitempty"`
	RuleCount     int64                  `protobuf:"varint,3,opt,name=rule_count,json=ruleCount,proto3" json:"rule_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyUpdateNotification) Reset() {
	*x = PolicyUpdateNotification{}
	mi := &file_flow_flow_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyUpdateNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyUpdateNotification) ProtoMessage() {}

func (x *PolicyUpdateNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyUpdateNotification.ProtoReflect.Descriptor instead.
func (*PolicyUpdateNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{34}
}

func (x *PolicyUpdateNotification) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PolicyUpdateNotification) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *PolicyUpdateNotification) GetRuleCount() int64 {
	if x != nil {
		return x.RuleCount
	}
	return 0
}

type EndpointRegenNotification struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint64                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Labels        []string               `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty"`
	Error         string                 `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EndpointRegenNotification) Reset() {
	*x = EndpointRegenNotification{}
	mi := &file_flow_flow_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndpointRegenNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointRegenNotification) ProtoMessage() {}

func (x *EndpointRegenNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointRegenNotification.ProtoReflect.Descriptor instead.
func (*EndpointRegenNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{35}
}

func (x *EndpointRegenNotification) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *EndpointRegenNotification) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EndpointRegenNotification) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type EndpointUpdateNotification struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint64                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Labels        []string               `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty"`
	Error         string                 `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	PodName       string                 `protobuf:"bytes,4,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	Namespace     string                 `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EndpointUpdateNotification) Reset() {
	*x = EndpointUpdateNotification{}
	mi := &file_flow_flow_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndpointUpdateNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointUpdateNotification) ProtoMessage() {}

func (x *EndpointUpdateNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointUpdateNotification.ProtoReflect.Descriptor instead.
func (*EndpointUpdateNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{36}
}

func (x *EndpointUpdateNotification) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *EndpointUpdateNotification) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EndpointUpdateNotification) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *EndpointUpdateNotification) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *EndpointUpdateNotification) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type IPCacheNotification struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Cidr          string                  `protobuf:"bytes,1,opt,name=cidr,proto3" json:"cidr,omitempty"`
	Identity      uint32                  `protobuf:"varint,2,opt,name=identity,proto3" json:"identity,omitempty"`
	OldIdentity   *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=old_identity,json=oldIdentity,proto3" json:"old_identity,omitempty"`
	HostIp        string                  `protobuf:"bytes,4,opt,name=host_ip,json=hostIp,proto3" json:"host_ip,omitempty"`
	OldHostIp     string                  `protobuf:"bytes,5,opt,name=old_host_ip,json=oldHostIp,proto3" json:"old_host_ip,omitempty"`
	EncryptKey    uint32                  `protobuf:"varint,6,opt,name=encrypt_key,json=encryptKey,proto3" json:"encrypt_key,omitempty"`
	Namespace     string                  `protobuf:"bytes,7,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PodName       string                  `protobuf:"bytes,8,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IPCacheNotification) Reset() {
	*x = IPCacheNotification{}
	mi := &file_flow_flow_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPCacheNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPCacheNotification) ProtoMessage() {}

func (x *IPCacheNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPCacheNotification.ProtoReflect.Descriptor instead.
func (*IPCacheNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{37}
}

func (x *IPCacheNotification) GetCidr() string {
	if x != nil {
		return x.Cidr
	}
	return ""
}

func (x *IPCacheNotification) GetIdentity() uint32 {
	if x != nil {
		return x.Identity
	}
	return 0
}

func (x *IPCacheNotification) GetOldIdentity() *wrapperspb.UInt32Value {
	if x != nil {
		return x.OldIdentity
	}
	return nil
}

func (x *IPCacheNotification) GetHostIp() string {
	if x != nil {
		return x.HostIp
	}
	return ""
}

func (x *IPCacheNotification) GetOldHostIp() string {
	if x != nil {
		return x.OldHostIp
	}
	return ""
}

func (x *IPCacheNotification) GetEncryptKey() uint32 {
	if x != nil {
		return x.EncryptKey
	}
	return 0
}

func (x *IPCacheNotification) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *IPCacheNotification) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

// Deprecated: Marked as deprecated in flow/flow.proto.
type ServiceUpsertNotificationAddr struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ip            string                 `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	Port          uint32                 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceUpsertNotificationAddr) Reset() {
	*x = ServiceUpsertNotificationAddr{}
	mi := &file_flow_flow_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceUpsertNotificationAddr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceUpsertNotificationAddr) ProtoMessage() {}

func (x *ServiceUpsertNotificationAddr) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceUpsertNotificationAddr.ProtoReflect.Descriptor instead.
func (*ServiceUpsertNotificationAddr) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{38}
}

func (x *ServiceUpsertNotificationAddr) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *ServiceUpsertNotificationAddr) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// Deprecated: Marked as deprecated in flow/flow.proto.
type ServiceUpsertNotification struct {
	state            protoimpl.MessageState           `protogen:"open.v1"`
	Id               uint32                           `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	FrontendAddress  *ServiceUpsertNotificationAddr   `protobuf:"bytes,2,opt,name=frontend_address,json=frontendAddress,proto3" json:"frontend_address,omitempty"`
	BackendAddresses []*ServiceUpsertNotificationAddr `protobuf:"bytes,3,rep,name=backend_addresses,json=backendAddresses,proto3" json:"backend_addresses,omitempty"`
	Type             string                           `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// Deprecated: Marked as deprecated in flow/flow.proto.
	TrafficPolicy    string `protobuf:"bytes,5,opt,name=traffic_policy,json=trafficPolicy,proto3" json:"traffic_policy,omitempty"`
	Name             string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	Namespace        string `protobuf:"bytes,7,opt,name=namespace,proto3" json:"namespace,omitempty"`
	ExtTrafficPolicy string `protobuf:"bytes,8,opt,name=ext_traffic_policy,json=extTrafficPolicy,proto3" json:"ext_traffic_policy,omitempty"`
	IntTrafficPolicy string `protobuf:"bytes,9,opt,name=int_traffic_policy,json=intTrafficPolicy,proto3" json:"int_traffic_policy,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ServiceUpsertNotification) Reset() {
	*x = ServiceUpsertNotification{}
	mi := &file_flow_flow_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceUpsertNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceUpsertNotification) ProtoMessage() {}

func (x *ServiceUpsertNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceUpsertNotification.ProtoReflect.Descriptor instead.
func (*ServiceUpsertNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{39}
}

func (x *ServiceUpsertNotification) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ServiceUpsertNotification) GetFrontendAddress() *ServiceUpsertNotificationAddr {
	if x != nil {
		return x.FrontendAddress
	}
	return nil
}

func (x *ServiceUpsertNotification) GetBackendAddresses() []*ServiceUpsertNotificationAddr {
	if x != nil {
		return x.BackendAddresses
	}
	return nil
}

func (x *ServiceUpsertNotification) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Deprecated: Marked as deprecated in flow/flow.proto.
func (x *ServiceUpsertNotification) GetTrafficPolicy() string {
	if x != nil {
		return x.TrafficPolicy
	}
	return ""
}

func (x *ServiceUpsertNotification) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceUpsertNotification) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ServiceUpsertNotification) GetExtTrafficPolicy() string {
	if x != nil {
		return x.ExtTrafficPolicy
	}
	return ""
}

func (x *ServiceUpsertNotification) GetIntTrafficPolicy() string {
	if x != nil {
		return x.IntTrafficPolicy
	}
	return ""
}

// Deprecated: Marked as deprecated in flow/flow.proto.
type ServiceDeleteNotification struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint32                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceDeleteNotification) Reset() {
	*x = ServiceDeleteNotification{}
	mi := &file_flow_flow_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceDeleteNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceDeleteNotification) ProtoMessage() {}

func (x *ServiceDeleteNotification) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceDeleteNotification.ProtoReflect.Descriptor instead.
func (*ServiceDeleteNotification) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{40}
}

func (x *ServiceDeleteNotification) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

type NetworkInterface struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Index         uint32                 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	mi := &file_flow_flow_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{41}
}

func (x *NetworkInterface) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *NetworkInterface) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DebugEvent struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Type          DebugEventType          `protobuf:"varint,1,opt,name=type,proto3,enum=flow.DebugEventType" json:"type,omitempty"`
	Source        *Endpoint               `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Hash          *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
	Arg1          *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=arg1,proto3" json:"arg1,omitempty"`
	Arg2          *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=arg2,proto3" json:"arg2,omitempty"`
	Arg3          *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=arg3,proto3" json:"arg3,omitempty"`
	Message       string                  `protobuf:"bytes,7,opt,name=message,proto3" json:"message,omitempty"`
	Cpu           *wrapperspb.Int32Value  `protobuf:"bytes,8,opt,name=cpu,proto3" json:"cpu,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DebugEvent) Reset() {
	*x = DebugEvent{}
	mi := &file_flow_flow_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DebugEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugEvent) ProtoMessage() {}

func (x *DebugEvent) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugEvent.ProtoReflect.Descriptor instead.
func (*DebugEvent) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{42}
}

func (x *DebugEvent) GetType() DebugEventType {
	if x != nil {
		return x.Type
	}
	return DebugEventType_DBG_EVENT_UNKNOWN
}

func (x *DebugEvent) GetSource() *Endpoint {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *DebugEvent) GetHash() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *DebugEvent) GetArg1() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Arg1
	}
	return nil
}

func (x *DebugEvent) GetArg2() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Arg2
	}
	return nil
}

func (x *DebugEvent) GetArg3() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Arg3
	}
	return nil
}

func (x *DebugEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DebugEvent) GetCpu() *wrapperspb.Int32Value {
	if x != nil {
		return x.Cpu
	}
	return nil
}

// Aggregate contains flow aggregation counters
type Aggregate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ingress_flow_count is the count of flows in the ingress direction
	IngressFlowCount uint32 `protobuf:"varint,1,opt,name=ingress_flow_count,json=ingressFlowCount,proto3" json:"ingress_flow_count,omitempty"`
	// egress_flow_count is the count of flows in the egress direction
	EgressFlowCount uint32 `protobuf:"varint,2,opt,name=egress_flow_count,json=egressFlowCount,proto3" json:"egress_flow_count,omitempty"`
	// unknown_direction_flow_count is the count of flows with unknown traffic direction
	UnknownDirectionFlowCount uint32 `protobuf:"varint,3,opt,name=unknown_direction_flow_count,json=unknownDirectionFlowCount,proto3" json:"unknown_direction_flow_count,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Aggregate) Reset() {
	*x = Aggregate{}
	mi := &file_flow_flow_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Aggregate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregate) ProtoMessage() {}

func (x *Aggregate) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregate.ProtoReflect.Descriptor instead.
func (*Aggregate) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{43}
}

func (x *Aggregate) GetIngressFlowCount() uint32 {
	if x != nil {
		return x.IngressFlowCount
	}
	return 0
}

func (x *Aggregate) GetEgressFlowCount() uint32 {
	if x != nil {
		return x.EgressFlowCount
	}
	return 0
}

func (x *Aggregate) GetUnknownDirectionFlowCount() uint32 {
	if x != nil {
		return x.UnknownDirectionFlowCount
	}
	return 0
}

// Experimental contains filters that are not stable yet. Support for
// experimental features is always optional and subject to change.
type FlowFilter_Experimental struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cel_expression takes a common expression language (CEL) expression
	// returning a boolean to determine if the filter matched or not.
	// You can use the `_flow` variable to access fields on the flow using
	// the flow.Flow protobuf field names.
	// See https://github.com/google/cel-spec/blob/v0.14.0/doc/intro.md#introduction
	// for more details on CEL and accessing the protobuf fields in CEL.
	// Using CEL has performance cost compared to other filters, so prefer
	// using non-CEL filters when possible, and try to specify CEL filters
	// last in the list of FlowFilters.
	CelExpression []string `protobuf:"bytes,1,rep,name=cel_expression,json=celExpression,proto3" json:"cel_expression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowFilter_Experimental) Reset() {
	*x = FlowFilter_Experimental{}
	mi := &file_flow_flow_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowFilter_Experimental) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowFilter_Experimental) ProtoMessage() {}

func (x *FlowFilter_Experimental) ProtoReflect() protoreflect.Message {
	mi := &file_flow_flow_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowFilter_Experimental.ProtoReflect.Descriptor instead.
func (*FlowFilter_Experimental) Descriptor() ([]byte, []int) {
	return file_flow_flow_proto_rawDescGZIP(), []int{23, 0}
}

func (x *FlowFilter_Experimental) GetCelExpression() []string {
	if x != nil {
		return x.CelExpression
	}
	return nil
}

var File_flow_flow_proto protoreflect.FileDescriptor

const file_flow_flow_proto_rawDesc = "" +
	"\n" +
	"\x0fflow/flow.proto\x12\x04flow\x1a\x19google/protobuf/any.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xbf\x10\n" +
	"\x04Flow\x12.\n" +
	"\x04time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04time\x12\x12\n" +
	"\x04uuid\x18\" \x01(\tR\x04uuid\x12'\n" +
	"\aemitter\x18) \x01(\v2\r.flow.EmitterR\aemitter\x12'\n" +
	"\averdict\x18\x02 \x01(\x0e2\r.flow.VerdictR\averdict\x12#\n" +
	"\vdrop_reason\x18\x03 \x01(\rB\x02\x18\x01R\n" +
	"dropReason\x12+\n" +
	"\tauth_type\x18# \x01(\x0e2\x0e.flow.AuthTypeR\bauthType\x12*\n" +
	"\bethernet\x18\x04 \x01(\v2\x0e.flow.EthernetR\bethernet\x12\x18\n" +
	"\x02IP\x18\x05 \x01(\v2\b.flow.IPR\x02IP\x12\x1c\n" +
	"\x02l4\x18\x06 \x01(\v2\f.flow.Layer4R\x02l4\x12$\n" +
	"\x06tunnel\x18' \x01(\v2\f.flow.TunnelR\x06tunnel\x12&\n" +
	"\x06source\x18\b \x01(\v2\x0e.flow.EndpointR\x06source\x120\n" +
	"\vdestination\x18\t \x01(\v2\x0e.flow.EndpointR\vdestination\x12\"\n" +
	"\x04Type\x18\n" +
	" \x01(\x0e2\x0e.flow.FlowTypeR\x04Type\x12\x1b\n" +
	"\tnode_name\x18\v \x01(\tR\bnodeName\x12\x1f\n" +
	"\vnode_labels\x18% \x03(\tR\n" +
	"nodeLabels\x12!\n" +
	"\fsource_names\x18\r \x03(\tR\vsourceNames\x12+\n" +
	"\x11destination_names\x18\x0e \x03(\tR\x10destinationNames\x12\x1c\n" +
	"\x02l7\x18\x0f \x01(\v2\f.flow.Layer7R\x02l7\x12\x18\n" +
	"\x05reply\x18\x10 \x01(\bB\x02\x18\x01R\x05reply\x124\n" +
	"\n" +
	"event_type\x18\x13 \x01(\v2\x15.flow.CiliumEventTypeR\teventType\x124\n" +
	"\x0esource_service\x18\x14 \x01(\v2\r.flow.ServiceR\rsourceService\x12>\n" +
	"\x13destination_service\x18\x15 \x01(\v2\r.flow.ServiceR\x12destinationService\x12C\n" +
	"\x11traffic_direction\x18\x16 \x01(\x0e2\x16.flow.TrafficDirectionR\x10trafficDirection\x12*\n" +
	"\x11policy_match_type\x18\x17 \x01(\rR\x0fpolicyMatchType\x12S\n" +
	"\x17trace_observation_point\x18\x18 \x01(\x0e2\x1b.flow.TraceObservationPointR\x15traceObservationPoint\x124\n" +
	"\ftrace_reason\x18$ \x01(\x0e2\x11.flow.TraceReasonR\vtraceReason\x12\"\n" +
	"\x04file\x18& \x01(\v2\x0e.flow.FileInfoR\x04file\x12/\n" +
	"\vip_trace_id\x18( \x01(\v2\x0f.flow.IPTraceIDR\tipTraceId\x12:\n" +
	"\x10drop_reason_desc\x18\x19 \x01(\x0e2\x10.flow.DropReasonR\x0edropReasonDesc\x125\n" +
	"\bis_reply\x18\x1a \x01(\v2\x1a.google.protobuf.BoolValueR\aisReply\x12G\n" +
	"\x13debug_capture_point\x18\x1b \x01(\x0e2\x17.flow.DebugCapturePointR\x11debugCapturePoint\x124\n" +
	"\tinterface\x18\x1c \x01(\v2\x16.flow.NetworkInterfaceR\tinterface\x12\x1d\n" +
	"\n" +
	"proxy_port\x18\x1d \x01(\rR\tproxyPort\x127\n" +
	"\rtrace_context\x18\x1e \x01(\v2\x12.flow.TraceContextR\ftraceContext\x12F\n" +
	"\x10sock_xlate_point\x18\x1f \x01(\x0e2\x1c.flow.SocketTranslationPointR\x0esockXlatePoint\x12#\n" +
	"\rsocket_cookie\x18  \x01(\x04R\fsocketCookie\x12\x1b\n" +
	"\tcgroup_id\x18! \x01(\x04R\bcgroupId\x12\x1e\n" +
	"\aSummary\x18\xa0\x8d\x06 \x01(\tB\x02\x18\x01R\aSummary\x126\n" +
	"\n" +
	"extensions\x18\xf0\x93\t \x01(\v2\x14.google.protobuf.AnyR\n" +
	"extensions\x12:\n" +
	"\x11egress_allowed_by\x18\x89\xa4\x01 \x03(\v2\f.flow.PolicyR\x0fegressAllowedBy\x12<\n" +
	"\x12ingress_allowed_by\x18\x8a\xa4\x01 \x03(\v2\f.flow.PolicyR\x10ingressAllowedBy\x128\n" +
	"\x10egress_denied_by\x18\x8c\xa4\x01 \x03(\v2\f.flow.PolicyR\x0eegressDeniedBy\x12:\n" +
	"\x11ingress_denied_by\x18\x8d\xa4\x01 \x03(\v2\f.flow.PolicyR\x0fingressDeniedBy\x12\x1f\n" +
	"\n" +
	"policy_log\x18\x8e\xa4\x01 \x03(\tR\tpolicyLog\x12/\n" +
	"\taggregate\x18\x8f\xa4\x01 \x01(\v2\x0f.flow.AggregateR\taggregateJ\x04\b\a\x10\bJ\x04\b\f\x10\rJ\x04\b\x11\x10\x12J\x04\b\x12\x10\x13\"7\n" +
	"\aEmitter\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"2\n" +
	"\bFileInfo\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04line\x18\x02 \x01(\rR\x04line\"\x88\x02\n" +
	"\x06Layer4\x12\x1d\n" +
	"\x03TCP\x18\x01 \x01(\v2\t.flow.TCPH\x00R\x03TCP\x12\x1d\n" +
	"\x03UDP\x18\x02 \x01(\v2\t.flow.UDPH\x00R\x03UDP\x12&\n" +
	"\x06ICMPv4\x18\x03 \x01(\v2\f.flow.ICMPv4H\x00R\x06ICMPv4\x12&\n" +
	"\x06ICMPv6\x18\x04 \x01(\v2\f.flow.ICMPv6H\x00R\x06ICMPv6\x12 \n" +
	"\x04SCTP\x18\x05 \x01(\v2\n" +
	".flow.SCTPH\x00R\x04SCTP\x12 \n" +
	"\x04VRRP\x18\x06 \x01(\v2\n" +
	".flow.VRRPH\x00R\x04VRRP\x12 \n" +
	"\x04IGMP\x18\a \x01(\v2\n" +
	".flow.IGMPH\x00R\x04IGMPB\n" +
	"\n" +
	"\bprotocol\"\xc1\x01\n" +
	"\x06Layer7\x12$\n" +
	"\x04type\x18\x01 \x01(\x0e2\x10.flow.L7FlowTypeR\x04type\x12\x1d\n" +
	"\n" +
	"latency_ns\x18\x02 \x01(\x04R\tlatencyNs\x12\x1d\n" +
	"\x03dns\x18d \x01(\v2\t.flow.DNSH\x00R\x03dns\x12 \n" +
	"\x04http\x18e \x01(\v2\n" +
	".flow.HTTPH\x00R\x04http\x12'\n" +
	"\x05kafka\x18f \x01(\v2\v.flow.KafkaB\x02\x18\x01H\x00R\x05kafkaB\b\n" +
	"\x06record\"9\n" +
	"\fTraceContext\x12)\n" +
	"\x06parent\x18\x01 \x01(\v2\x11.flow.TraceParentR\x06parent\"(\n" +
	"\vTraceParent\x12\x19\n" +
	"\btrace_id\x18\x01 \x01(\tR\atraceId\"\xd8\x01\n" +
	"\bEndpoint\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\rR\x02ID\x12\x1a\n" +
	"\bidentity\x18\x02 \x01(\rR\bidentity\x12!\n" +
	"\fcluster_name\x18\a \x01(\tR\vclusterName\x12\x1c\n" +
	"\tnamespace\x18\x03 \x01(\tR\tnamespace\x12\x16\n" +
	"\x06labels\x18\x04 \x03(\tR\x06labels\x12\x19\n" +
	"\bpod_name\x18\x05 \x01(\tR\apodName\x12,\n" +
	"\tworkloads\x18\x06 \x03(\v2\x0e.flow.WorkloadR\tworkloads\"2\n" +
	"\bWorkload\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04kind\x18\x02 \x01(\tR\x04kind\"w\n" +
	"\x03TCP\x12\x1f\n" +
	"\vsource_port\x18\x01 \x01(\rR\n" +
	"sourcePort\x12)\n" +
	"\x10destination_port\x18\x02 \x01(\rR\x0fdestinationPort\x12$\n" +
	"\x05flags\x18\x03 \x01(\v2\x0e.flow.TCPFlagsR\x05flags\"\xb0\x01\n" +
	"\x02IP\x12\x16\n" +
	"\x06source\x18\x01 \x01(\tR\x06source\x12#\n" +
	"\rsource_xlated\x18\x05 \x01(\tR\fsourceXlated\x12 \n" +
	"\vdestination\x18\x02 \x01(\tR\vdestination\x12-\n" +
	"\tipVersion\x18\x03 \x01(\x0e2\x0f.flow.IPVersionR\tipVersion\x12\x1c\n" +
	"\tencrypted\x18\x04 \x01(\bR\tencrypted\"D\n" +
	"\bEthernet\x12\x16\n" +
	"\x06source\x18\x01 \x01(\tR\x06source\x12 \n" +
	"\vdestination\x18\x02 \x01(\tR\vdestination\"\xaa\x01\n" +
	"\bTCPFlags\x12\x10\n" +
	"\x03FIN\x18\x01 \x01(\bR\x03FIN\x12\x10\n" +
	"\x03SYN\x18\x02 \x01(\bR\x03SYN\x12\x10\n" +
	"\x03RST\x18\x03 \x01(\bR\x03RST\x12\x10\n" +
	"\x03PSH\x18\x04 \x01(\bR\x03PSH\x12\x10\n" +
	"\x03ACK\x18\x05 \x01(\bR\x03ACK\x12\x10\n" +
	"\x03URG\x18\x06 \x01(\bR\x03URG\x12\x10\n" +
	"\x03ECE\x18\a \x01(\bR\x03ECE\x12\x10\n" +
	"\x03CWR\x18\b \x01(\bR\x03CWR\x12\x0e\n" +
	"\x02NS\x18\t \x01(\bR\x02NS\"Q\n" +
	"\x03UDP\x12\x1f\n" +
	"\vsource_port\x18\x01 \x01(\rR\n" +
	"sourcePort\x12)\n" +
	"\x10destination_port\x18\x02 \x01(\rR\x0fdestinationPort\"R\n" +
	"\x04SCTP\x12\x1f\n" +
	"\vsource_port\x18\x01 \x01(\rR\n" +
	"sourcePort\x12)\n" +
	"\x10destination_port\x18\x02 \x01(\rR\x0fdestinationPort\"0\n" +
	"\x06ICMPv4\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x12\n" +
	"\x04code\x18\x02 \x01(\rR\x04code\"0\n" +
	"\x06ICMPv6\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x12\n" +
	"\x04code\x18\x02 \x01(\rR\x04code\"J\n" +
	"\x04VRRP\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x12\n" +
	"\x04vrid\x18\x02 \x01(\rR\x04vrid\x12\x1a\n" +
	"\bpriority\x18\x03 \x01(\rR\bpriority\"?\n" +
	"\x04IGMP\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12#\n" +
	"\rgroup_address\x18\x02 \x01(\tR\fgroupAddress\"\xa3\x01\n" +
	"\x06Tunnel\x121\n" +
	"\bprotocol\x18\x01 \x01(\x0e2\x15.flow.Tunnel.ProtocolR\bprotocol\x12\x18\n" +
	"\x02IP\x18\x02 \x01(\v2\b.flow.IPR\x02IP\x12\x1c\n" +
	"\x02l4\x18\x03 \x01(\v2\f.flow.Layer4R\x02l4\".\n" +
	"\bProtocol\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\t\n" +
	"\x05VXLAN\x10\x01\x12\n" +
	"\n" +
	"\x06GENEVE\x10\x02\"\x82\x01\n" +
	"\x06Policy\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\x12\x16\n" +
	"\x06labels\x18\x03 \x03(\tR\x06labels\x12\x1a\n" +
	"\brevision\x18\x04 \x01(\x04R\brevision\x12\x12\n" +
	"\x04kind\x18\x05 \x01(\tR\x04kind\"f\n" +
	"\x0fEventTypeFilter\x12\x12\n" +
	"\x04type\x18\x01 \x01(\x05R\x04type\x12$\n" +
	"\x0ematch_sub_type\x18\x02 \x01(\bR\fmatchSubType\x12\x19\n" +
	"\bsub_type\x18\x03 \x01(\x05R\asubType\"@\n" +
	"\x0fCiliumEventType\x12\x12\n" +
	"\x04type\x18\x01 \x01(\x05R\x04type\x12\x19\n" +
	"\bsub_type\x18\x02 \x01(\x05R\asubType\"\xc4\r\n" +
	"\n" +
	"FlowFilter\x12\x12\n" +
	"\x04uuid\x18\x1d \x03(\tR\x04uuid\x12\x1b\n" +
	"\tsource_ip\x18\x01 \x03(\tR\bsourceIp\x12(\n" +
	"\x10source_ip_xlated\x18\" \x03(\tR\x0esourceIpXlated\x12\x1d\n" +
	"\n" +
	"source_pod\x18\x02 \x03(\tR\tsourcePod\x12\x1f\n" +
	"\vsource_fqdn\x18\a \x03(\tR\n" +
	"sourceFqdn\x12!\n" +
	"\fsource_label\x18\n" +
	" \x03(\tR\vsourceLabel\x12%\n" +
	"\x0esource_service\x18\x10 \x03(\tR\rsourceService\x127\n" +
	"\x0fsource_workload\x18\x1a \x03(\v2\x0e.flow.WorkloadR\x0esourceWorkload\x12.\n" +
	"\x13source_cluster_name\x18% \x03(\tR\x11sourceClusterName\x12%\n" +
	"\x0edestination_ip\x18\x03 \x03(\tR\rdestinationIp\x12'\n" +
	"\x0fdestination_pod\x18\x04 \x03(\tR\x0edestinationPod\x12)\n" +
	"\x10destination_fqdn\x18\b \x03(\tR\x0fdestinationFqdn\x12+\n" +
	"\x11destination_label\x18\v \x03(\tR\x10destinationLabel\x12/\n" +
	"\x13destination_service\x18\x11 \x03(\tR\x12destinationService\x12A\n" +
	"\x14destination_workload\x18\x1b \x03(\v2\x0e.flow.WorkloadR\x13destinationWorkload\x128\n" +
	"\x18destination_cluster_name\x18& \x03(\tR\x16destinationClusterName\x12C\n" +
	"\x11traffic_direction\x18\x1e \x03(\x0e2\x16.flow.TrafficDirectionR\x10trafficDirection\x12'\n" +
	"\averdict\x18\x05 \x03(\x0e2\r.flow.VerdictR\averdict\x12:\n" +
	"\x10drop_reason_desc\x18! \x03(\x0e2\x10.flow.DropReasonR\x0edropReasonDesc\x124\n" +
	"\tinterface\x18# \x03(\v2\x16.flow.NetworkInterfaceR\tinterface\x124\n" +
	"\n" +
	"event_type\x18\x06 \x03(\v2\x15.flow.EventTypeFilterR\teventType\x12(\n" +
	"\x10http_status_code\x18\t \x03(\tR\x0ehttpStatusCode\x12\x1a\n" +
	"\bprotocol\x18\f \x03(\tR\bprotocol\x12\x1f\n" +
	"\vsource_port\x18\r \x03(\tR\n" +
	"sourcePort\x12)\n" +
	"\x10destination_port\x18\x0e \x03(\tR\x0fdestinationPort\x12\x14\n" +
	"\x05reply\x18\x0f \x03(\bR\x05reply\x12\x1b\n" +
	"\tdns_query\x18\x12 \x03(\tR\bdnsQuery\x12'\n" +
	"\x0fsource_identity\x18\x13 \x03(\rR\x0esourceIdentity\x121\n" +
	"\x14destination_identity\x18\x14 \x03(\rR\x13destinationIdentity\x12\x1f\n" +
	"\vhttp_method\x18\x15 \x03(\tR\n" +
	"httpMethod\x12\x1b\n" +
	"\thttp_path\x18\x16 \x03(\tR\bhttpPath\x12\x19\n" +
	"\bhttp_url\x18\x1f \x03(\tR\ahttpUrl\x121\n" +
	"\vhttp_header\x18  \x03(\v2\x10.flow.HTTPHeaderR\n" +
	"httpHeader\x12+\n" +
	"\ttcp_flags\x18\x17 \x03(\v2\x0e.flow.TCPFlagsR\btcpFlags\x12\x1b\n" +
	"\tnode_name\x18\x18 \x03(\tR\bnodeName\x12\x1f\n" +
	"\vnode_labels\x18$ \x03(\tR\n" +
	"nodeLabels\x12.\n" +
	"\n" +
	"ip_version\x18\x19 \x03(\x0e2\x0f.flow.IPVersionR\tipVersion\x12\x19\n" +
	"\btrace_id\x18\x1c \x03(\tR\atraceId\x12\x1e\n" +
	"\vip_trace_id\x18' \x03(\x04R\tipTraceId\x12B\n" +
	"\fexperimental\x18\xe7\a \x01(\v2\x1d.flow.FlowFilter.ExperimentalR\fexperimental\x1a5\n" +
	"\fExperimental\x12%\n" +
	"\x0ecel_expression\x18\x01 \x03(\tR\rcelExpression\"\xce\x01\n" +
	"\x03DNS\x12\x14\n" +
	"\x05query\x18\x01 \x01(\tR\x05query\x12\x10\n" +
	"\x03ips\x18\x02 \x03(\tR\x03ips\x12\x10\n" +
	"\x03ttl\x18\x03 \x01(\rR\x03ttl\x12\x16\n" +
	"\x06cnames\x18\x04 \x03(\tR\x06cnames\x12-\n" +
	"\x12observation_source\x18\x05 \x01(\tR\x11observationSource\x12\x14\n" +
	"\x05rcode\x18\x06 \x01(\rR\x05rcode\x12\x16\n" +
	"\x06qtypes\x18\a \x03(\tR\x06qtypes\x12\x18\n" +
	"\arrtypes\x18\b \x03(\tR\arrtypes\"4\n" +
	"\n" +
	"HTTPHeader\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"\x8c\x01\n" +
	"\x04HTTP\x12\x12\n" +
	"\x04code\x18\x01 \x01(\rR\x04code\x12\x16\n" +
	"\x06method\x18\x02 \x01(\tR\x06method\x12\x10\n" +
	"\x03url\x18\x03 \x01(\tR\x03url\x12\x1a\n" +
	"\bprotocol\x18\x04 \x01(\tR\bprotocol\x12*\n" +
	"\aheaders\x18\x05 \x03(\v2\x10.flow.HTTPHeaderR\aheaders\"\xa1\x01\n" +
	"\x05Kafka\x12\x1d\n" +
	"\n" +
	"error_code\x18\x01 \x01(\x05R\terrorCode\x12\x1f\n" +
	"\vapi_version\x18\x02 \x01(\x05R\n" +
	"apiVersion\x12\x17\n" +
	"\aapi_key\x18\x03 \x01(\tR\x06apiKey\x12%\n" +
	"\x0ecorrelation_id\x18\x04 \x01(\x05R\rcorrelationId\x12\x14\n" +
	"\x05topic\x18\x05 \x01(\tR\x05topic:\x02\x18\x01\";\n" +
	"\aService\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\"L\n" +
	"\tIPTraceID\x12\x19\n" +
	"\btrace_id\x18\x01 \x01(\x04R\atraceId\x12$\n" +
	"\x0eip_option_type\x18\x02 \x01(\rR\fipOptionType\"\xf3\x01\n" +
	"\tLostEvent\x12-\n" +
	"\x06source\x18\x01 \x01(\x0e2\x15.flow.LostEventSourceR\x06source\x12&\n" +
	"\x0fnum_events_lost\x18\x02 \x01(\x04R\rnumEventsLost\x12-\n" +
	"\x03cpu\x18\x03 \x01(\v2\x1b.google.protobuf.Int32ValueR\x03cpu\x120\n" +
	"\x05first\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x05first\x12.\n" +
	"\x04last\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\x04last\"\xfe\x04\n" +
	"\n" +
	"AgentEvent\x12(\n" +
	"\x04type\x18\x01 \x01(\x0e2\x14.flow.AgentEventTypeR\x04type\x123\n" +
	"\aunknown\x18d \x01(\v2\x17.flow.AgentEventUnknownH\x00R\aunknown\x129\n" +
	"\vagent_start\x18e \x01(\v2\x16.flow.TimeNotificationH\x00R\n" +
	"agentStart\x12E\n" +
	"\rpolicy_update\x18f \x01(\v2\x1e.flow.PolicyUpdateNotificationH\x00R\fpolicyUpdate\x12R\n" +
	"\x13endpoint_regenerate\x18g \x01(\v2\x1f.flow.EndpointRegenNotificationH\x00R\x12endpointRegenerate\x12K\n" +
	"\x0fendpoint_update\x18h \x01(\v2 .flow.EndpointUpdateNotificationH\x00R\x0eendpointUpdate\x12B\n" +
	"\x0eipcache_update\x18i \x01(\v2\x19.flow.IPCacheNotificationH\x00R\ripcacheUpdate\x12L\n" +
	"\x0eservice_upsert\x18j \x01(\v2\x1f.flow.ServiceUpsertNotificationB\x02\x18\x01H\x00R\rserviceUpsert\x12L\n" +
	"\x0eservice_delete\x18k \x01(\v2\x1f.flow.ServiceDeleteNotificationB\x02\x18\x01H\x00R\rserviceDeleteB\x0e\n" +
	"\fnotification\"K\n" +
	"\x11AgentEventUnknown\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x12\"\n" +
	"\fnotification\x18\x02 \x01(\tR\fnotification\"B\n" +
	"\x10TimeNotification\x12.\n" +
	"\x04time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04time\"m\n" +
	"\x18PolicyUpdateNotification\x12\x16\n" +
	"\x06labels\x18\x01 \x03(\tR\x06labels\x12\x1a\n" +
	"\brevision\x18\x02 \x01(\x04R\brevision\x12\x1d\n" +
	"\n" +
	"rule_count\x18\x03 \x01(\x03R\truleCount\"Y\n" +
	"\x19EndpointRegenNotification\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\x04R\x02id\x12\x16\n" +
	"\x06labels\x18\x02 \x03(\tR\x06labels\x12\x14\n" +
	"\x05error\x18\x03 \x01(\tR\x05error\"\x93\x01\n" +
	"\x1aEndpointUpdateNotification\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\x04R\x02id\x12\x16\n" +
	"\x06labels\x18\x02 \x03(\tR\x06labels\x12\x14\n" +
	"\x05error\x18\x03 \x01(\tR\x05error\x12\x19\n" +
	"\bpod_name\x18\x04 \x01(\tR\apodName\x12\x1c\n" +
	"\tnamespace\x18\x05 \x01(\tR\tnamespace\"\x99\x02\n" +
	"\x13IPCacheNotification\x12\x12\n" +
	"\x04cidr\x18\x01 \x01(\tR\x04cidr\x12\x1a\n" +
	"\bidentity\x18\x02 \x01(\rR\bidentity\x12?\n" +
	"\fold_identity\x18\x03 \x01(\v2\x1c.google.protobuf.UInt32ValueR\voldIdentity\x12\x17\n" +
	"\ahost_ip\x18\x04 \x01(\tR\x06hostIp\x12\x1e\n" +
	"\vold_host_ip\x18\x05 \x01(\tR\toldHostIp\x12\x1f\n" +
	"\vencrypt_key\x18\x06 \x01(\rR\n" +
	"encryptKey\x12\x1c\n" +
	"\tnamespace\x18\a \x01(\tR\tnamespace\x12\x19\n" +
	"\bpod_name\x18\b \x01(\tR\apodName\"G\n" +
	"\x1dServiceUpsertNotificationAddr\x12\x0e\n" +
	"\x02ip\x18\x01 \x01(\tR\x02ip\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port:\x02\x18\x01\"\x9e\x03\n" +
	"\x19ServiceUpsertNotification\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\rR\x02id\x12N\n" +
	"\x10frontend_address\x18\x02 \x01(\v2#.flow.ServiceUpsertNotificationAddrR\x0ffrontendAddress\x12P\n" +
	"\x11backend_addresses\x18\x03 \x03(\v2#.flow.ServiceUpsertNotificationAddrR\x10backendAddresses\x12\x12\n" +
	"\x04type\x18\x04 \x01(\tR\x04type\x12)\n" +
	"\x0etraffic_policy\x18\x05 \x01(\tB\x02\x18\x01R\rtrafficPolicy\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\a \x01(\tR\tnamespace\x12,\n" +
	"\x12ext_traffic_policy\x18\b \x01(\tR\x10extTrafficPolicy\x12,\n" +
	"\x12int_traffic_policy\x18\t \x01(\tR\x10intTrafficPolicy:\x02\x18\x01\"/\n" +
	"\x19ServiceDeleteNotification\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\rR\x02id:\x02\x18\x01\"<\n" +
	"\x10NetworkInterface\x12\x14\n" +
	"\x05index\x18\x01 \x01(\rR\x05index\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\"\xef\x02\n" +
	"\n" +
	"DebugEvent\x12(\n" +
	"\x04type\x18\x01 \x01(\x0e2\x14.flow.DebugEventTypeR\x04type\x12&\n" +
	"\x06source\x18\x02 \x01(\v2\x0e.flow.EndpointR\x06source\x120\n" +
	"\x04hash\x18\x03 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x04hash\x120\n" +
	"\x04arg1\x18\x04 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x04arg1\x120\n" +
	"\x04arg2\x18\x05 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x04arg2\x120\n" +
	"\x04arg3\x18\x06 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x04arg3\x12\x18\n" +
	"\amessage\x18\a \x01(\tR\amessage\x12-\n" +
	"\x03cpu\x18\b \x01(\v2\x1b.google.protobuf.Int32ValueR\x03cpu\"\xa6\x01\n" +
	"\tAggregate\x12,\n" +
	"\x12ingress_flow_count\x18\x01 \x01(\rR\x10ingressFlowCount\x12*\n" +
	"\x11egress_flow_count\x18\x02 \x01(\rR\x0fegressFlowCount\x12?\n" +
	"\x1cunknown_direction_flow_count\x18\x03 \x01(\rR\x19unknownDirectionFlowCount*9\n" +
	"\bFlowType\x12\x10\n" +
	"\fUNKNOWN_TYPE\x10\x00\x12\t\n" +
	"\x05L3_L4\x10\x01\x12\x06\n" +
	"\x02L7\x10\x02\x12\b\n" +
	"\x04SOCK\x10\x03*9\n" +
	"\bAuthType\x12\f\n" +
	"\bDISABLED\x10\x00\x12\t\n" +
	"\x05SPIRE\x10\x01\x12\x14\n" +
	"\x10TEST_ALWAYS_FAIL\x10\x02*\x8a\x02\n" +
	"\x15TraceObservationPoint\x12\x11\n" +
	"\rUNKNOWN_POINT\x10\x00\x12\f\n" +
	"\bTO_PROXY\x10\x01\x12\v\n" +
	"\aTO_HOST\x10\x02\x12\f\n" +
	"\bTO_STACK\x10\x03\x12\x0e\n" +
	"\n" +
	"TO_OVERLAY\x10\x04\x12\x0f\n" +
	"\vTO_ENDPOINT\x10e\x12\x11\n" +
	"\rFROM_ENDPOINT\x10\x05\x12\x0e\n" +
	"\n" +
	"FROM_PROXY\x10\x06\x12\r\n" +
	"\tFROM_HOST\x10\a\x12\x0e\n" +
	"\n" +
	"FROM_STACK\x10\b\x12\x10\n" +
	"\fFROM_OVERLAY\x10\t\x12\x10\n" +
	"\fFROM_NETWORK\x10\n" +
	"\x12\x0e\n" +
	"\n" +
	"TO_NETWORK\x10\v\x12\x0f\n" +
	"\vFROM_CRYPTO\x10\f\x12\r\n" +
	"\tTO_CRYPTO\x10\r*\xa4\x01\n" +
	"\vTraceReason\x12\x18\n" +
	"\x14TRACE_REASON_UNKNOWN\x10\x00\x12\a\n" +
	"\x03NEW\x10\x01\x12\x0f\n" +
	"\vESTABLISHED\x10\x02\x12\t\n" +
	"\x05REPLY\x10\x03\x12\v\n" +
	"\aRELATED\x10\x04\x12\x10\n" +
	"\bREOPENED\x10\x05\x1a\x02\b\x01\x12\x0e\n" +
	"\n" +
	"SRV6_ENCAP\x10\x06\x12\x0e\n" +
	"\n" +
	"SRV6_DECAP\x10\a\x12\x17\n" +
	"\x0fENCRYPT_OVERLAY\x10\b\x1a\x02\b\x01*H\n" +
	"\n" +
	"L7FlowType\x12\x13\n" +
	"\x0fUNKNOWN_L7_TYPE\x10\x00\x12\v\n" +
	"\aREQUEST\x10\x01\x12\f\n" +
	"\bRESPONSE\x10\x02\x12\n" +
	"\n" +
	"\x06SAMPLE\x10\x03*0\n" +
	"\tIPVersion\x12\x0f\n" +
	"\vIP_NOT_USED\x10\x00\x12\b\n" +
	"\x04IPv4\x10\x01\x12\b\n" +
	"\x04IPv6\x10\x02*|\n" +
	"\aVerdict\x12\x13\n" +
	"\x0fVERDICT_UNKNOWN\x10\x00\x12\r\n" +
	"\tFORWARDED\x10\x01\x12\v\n" +
	"\aDROPPED\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\t\n" +
	"\x05AUDIT\x10\x04\x12\x0e\n" +
	"\n" +
	"REDIRECTED\x10\x05\x12\n" +
	"\n" +
	"\x06TRACED\x10\x06\x12\x0e\n" +
	"\n" +
	"TRANSLATED\x10\a*\xc5\x11\n" +
	"\n" +
	"DropReason\x12\x17\n" +
	"\x13DROP_REASON_UNKNOWN\x10\x00\x12\x1b\n" +
	"\x12INVALID_SOURCE_MAC\x10\x82\x01\x1a\x02\b\x01\x12 \n" +
	"\x17INVALID_DESTINATION_MAC\x10\x83\x01\x1a\x02\b\x01\x12\x16\n" +
	"\x11INVALID_SOURCE_IP\x10\x84\x01\x12\x12\n" +
	"\rPOLICY_DENIED\x10\x85\x01\x12\x1b\n" +
	"\x16INVALID_PACKET_DROPPED\x10\x86\x01\x12#\n" +
	"\x1eCT_TRUNCATED_OR_INVALID_HEADER\x10\x87\x01\x12\x1c\n" +
	"\x17CT_MISSING_TCP_ACK_FLAG\x10\x88\x01\x12\x1b\n" +
	"\x16CT_UNKNOWN_L4_PROTOCOL\x10\x89\x01\x12+\n" +
	"\"CT_CANNOT_CREATE_ENTRY_FROM_PACKET\x10\x8a\x01\x1a\x02\b\x01\x12\x1c\n" +
	"\x17UNSUPPORTED_L3_PROTOCOL\x10\x8b\x01\x12\x15\n" +
	"\x10MISSED_TAIL_CALL\x10\x8c\x01\x12\x1c\n" +
	"\x17ERROR_WRITING_TO_PACKET\x10\x8d\x01\x12\x18\n" +
	"\x13UNKNOWN_L4_PROTOCOL\x10\x8e\x01\x12\x18\n" +
	"\x13UNKNOWN_ICMPV4_CODE\x10\x8f\x01\x12\x18\n" +
	"\x13UNKNOWN_ICMPV4_TYPE\x10\x90\x01\x12\x18\n" +
	"\x13UNKNOWN_ICMPV6_CODE\x10\x91\x01\x12\x18\n" +
	"\x13UNKNOWN_ICMPV6_TYPE\x10\x92\x01\x12 \n" +
	"\x1bERROR_RETRIEVING_TUNNEL_KEY\x10\x93\x01\x12(\n" +
	"\x1fERROR_RETRIEVING_TUNNEL_OPTIONS\x10\x94\x01\x1a\x02\b\x01\x12\x1e\n" +
	"\x15INVALID_GENEVE_OPTION\x10\x95\x01\x1a\x02\b\x01\x12\x1e\n" +
	"\x19UNKNOWN_L3_TARGET_ADDRESS\x10\x96\x01\x12\x1b\n" +
	"\x16STALE_OR_UNROUTABLE_IP\x10\x97\x01\x12*\n" +
	"!NO_MATCHING_LOCAL_CONTAINER_FOUND\x10\x98\x01\x1a\x02\b\x01\x12'\n" +
	"\"ERROR_WHILE_CORRECTING_L3_CHECKSUM\x10\x99\x01\x12'\n" +
	"\"ERROR_WHILE_CORRECTING_L4_CHECKSUM\x10\x9a\x01\x12\x1c\n" +
	"\x17CT_MAP_INSERTION_FAILED\x10\x9b\x01\x12\"\n" +
	"\x1dINVALID_IPV6_EXTENSION_HEADER\x10\x9c\x01\x12#\n" +
	"\x1eIP_FRAGMENTATION_NOT_SUPPORTED\x10\x9d\x01\x12\x1e\n" +
	"\x19SERVICE_BACKEND_NOT_FOUND\x10\x9e\x01\x12(\n" +
	"#NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT\x10\xa0\x01\x12#\n" +
	"\x1eFAILED_TO_INSERT_INTO_PROXYMAP\x10\xa1\x01\x12+\n" +
	"&REACHED_EDT_RATE_LIMITING_DROP_HORIZON\x10\xa2\x01\x12&\n" +
	"!UNKNOWN_CONNECTION_TRACKING_STATE\x10\xa3\x01\x12\x1e\n" +
	"\x19LOCAL_HOST_IS_UNREACHABLE\x10\xa4\x01\x12:\n" +
	"5NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION\x10\xa5\x01\x12\x1c\n" +
	"\x17UNSUPPORTED_L2_PROTOCOL\x10\xa6\x01\x12\"\n" +
	"\x1dNO_MAPPING_FOR_NAT_MASQUERADE\x10\xa7\x01\x12,\n" +
	"'UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE\x10\xa8\x01\x12\x16\n" +
	"\x11FIB_LOOKUP_FAILED\x10\xa9\x01\x12(\n" +
	"#ENCAPSULATION_TRAFFIC_IS_PROHIBITED\x10\xaa\x01\x12\x15\n" +
	"\x10INVALID_IDENTITY\x10\xab\x01\x12\x13\n" +
	"\x0eUNKNOWN_SENDER\x10\xac\x01\x12\x13\n" +
	"\x0eNAT_NOT_NEEDED\x10\xad\x01\x12\x13\n" +
	"\x0eIS_A_CLUSTERIP\x10\xae\x01\x12.\n" +
	")FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND\x10\xaf\x01\x12\x1d\n" +
	"\x18FORBIDDEN_ICMPV6_MESSAGE\x10\xb0\x01\x12!\n" +
	"\x1cDENIED_BY_LB_SRC_RANGE_CHECK\x10\xb1\x01\x12\x19\n" +
	"\x14SOCKET_LOOKUP_FAILED\x10\xb2\x01\x12\x19\n" +
	"\x14SOCKET_ASSIGN_FAILED\x10\xb3\x01\x121\n" +
	",PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL\x10\xb4\x01\x12\x10\n" +
	"\vPOLICY_DENY\x10\xb5\x01\x12\x12\n" +
	"\rVLAN_FILTERED\x10\xb6\x01\x12\x10\n" +
	"\vINVALID_VNI\x10\xb7\x01\x12\x16\n" +
	"\x11INVALID_TC_BUFFER\x10\xb8\x01\x12\v\n" +
	"\x06NO_SID\x10\xb9\x01\x12\x1b\n" +
	"\x12MISSING_SRV6_STATE\x10\xba\x01\x1a\x02\b\x01\x12\n" +
	"\n" +
	"\x05NAT46\x10\xbb\x01\x12\n" +
	"\n" +
	"\x05NAT64\x10\xbc\x01\x12\x12\n" +
	"\rAUTH_REQUIRED\x10\xbd\x01\x12\x14\n" +
	"\x0fCT_NO_MAP_FOUND\x10\xbe\x01\x12\x16\n" +
	"\x11SNAT_NO_MAP_FOUND\x10\xbf\x01\x12\x17\n" +
	"\x12INVALID_CLUSTER_ID\x10\xc0\x01\x12'\n" +
	"\"UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP\x10\xc1\x01\x12\x16\n" +
	"\x11NO_EGRESS_GATEWAY\x10\xc2\x01\x12\x18\n" +
	"\x13UNENCRYPTED_TRAFFIC\x10\xc3\x01\x12\x11\n" +
	"\fTTL_EXCEEDED\x10\xc4\x01\x12\x0f\n" +
	"\n" +
	"NO_NODE_ID\x10\xc5\x01\x12\x16\n" +
	"\x11DROP_RATE_LIMITED\x10\xc6\x01\x12\x11\n" +
	"\fIGMP_HANDLED\x10\xc7\x01\x12\x14\n" +
	"\x0fIGMP_SUBSCRIBED\x10\xc8\x01\x12\x16\n" +
	"\x11MULTICAST_HANDLED\x10\xc9\x01\x12\x18\n" +
	"\x13DROP_HOST_NOT_READY\x10\xca\x01\x12\x16\n" +
	"\x11DROP_EP_NOT_READY\x10\xcb\x01\x12\x16\n" +
	"\x11DROP_NO_EGRESS_IP\x10\xcc\x01\x12\x14\n" +
	"\x0fDROP_PUNT_PROXY\x10\xcd\x01*J\n" +
	"\x10TrafficDirection\x12\x1d\n" +
	"\x19TRAFFIC_DIRECTION_UNKNOWN\x10\x00\x12\v\n" +
	"\aINGRESS\x10\x01\x12\n" +
	"\n" +
	"\x06EGRESS\x10\x02*\x8d\x02\n" +
	"\x11DebugCapturePoint\x12\x1d\n" +
	"\x19DBG_CAPTURE_POINT_UNKNOWN\x10\x00\x12\x18\n" +
	"\x14DBG_CAPTURE_DELIVERY\x10\x04\x12\x17\n" +
	"\x13DBG_CAPTURE_FROM_LB\x10\x05\x12\x19\n" +
	"\x15DBG_CAPTURE_AFTER_V46\x10\x06\x12\x19\n" +
	"\x15DBG_CAPTURE_AFTER_V64\x10\a\x12\x19\n" +
	"\x15DBG_CAPTURE_PROXY_PRE\x10\b\x12\x1a\n" +
	"\x16DBG_CAPTURE_PROXY_POST\x10\t\x12\x18\n" +
	"\x14DBG_CAPTURE_SNAT_PRE\x10\n" +
	"\x12\x19\n" +
	"\x15DBG_CAPTURE_SNAT_POST\x10\v\"\x04\b\x01\x10\x03*9\n" +
	"\tEventType\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x0f\n" +
	"\vEventSample\x10\t\x12\x0e\n" +
	"\n" +
	"RecordLost\x10\x02*\x7f\n" +
	"\x0fLostEventSource\x12\x1d\n" +
	"\x19UNKNOWN_LOST_EVENT_SOURCE\x10\x00\x12\x1a\n" +
	"\x16PERF_EVENT_RING_BUFFER\x10\x01\x12\x19\n" +
	"\x15OBSERVER_EVENTS_QUEUE\x10\x02\x12\x16\n" +
	"\x12HUBBLE_RING_BUFFER\x10\x03*\xb6\x02\n" +
	"\x0eAgentEventType\x12\x17\n" +
	"\x13AGENT_EVENT_UNKNOWN\x10\x00\x12\x11\n" +
	"\rAGENT_STARTED\x10\x02\x12\x12\n" +
	"\x0ePOLICY_UPDATED\x10\x03\x12\x12\n" +
	"\x0ePOLICY_DELETED\x10\x04\x12\x1f\n" +
	"\x1bENDPOINT_REGENERATE_SUCCESS\x10\x05\x12\x1f\n" +
	"\x1bENDPOINT_REGENERATE_FAILURE\x10\x06\x12\x14\n" +
	"\x10ENDPOINT_CREATED\x10\a\x12\x14\n" +
	"\x10ENDPOINT_DELETED\x10\b\x12\x14\n" +
	"\x10IPCACHE_UPSERTED\x10\t\x12\x13\n" +
	"\x0fIPCACHE_DELETED\x10\n" +
	"\x12\x18\n" +
	"\x10SERVICE_UPSERTED\x10\v\x1a\x02\b\x01\x12\x17\n" +
	"\x0fSERVICE_DELETED\x10\f\x1a\x02\b\x01\"\x04\b\x01\x10\x01*\xd8\x01\n" +
	"\x16SocketTranslationPoint\x12\x1c\n" +
	"\x18SOCK_XLATE_POINT_UNKNOWN\x10\x00\x12&\n" +
	"\"SOCK_XLATE_POINT_PRE_DIRECTION_FWD\x10\x01\x12'\n" +
	"#SOCK_XLATE_POINT_POST_DIRECTION_FWD\x10\x02\x12&\n" +
	"\"SOCK_XLATE_POINT_PRE_DIRECTION_REV\x10\x03\x12'\n" +
	"#SOCK_XLATE_POINT_POST_DIRECTION_REV\x10\x04*\xbb\r\n" +
	"\x0eDebugEventType\x12\x15\n" +
	"\x11DBG_EVENT_UNKNOWN\x10\x00\x12\x0f\n" +
	"\vDBG_GENERIC\x10\x01\x12\x16\n" +
	"\x12DBG_LOCAL_DELIVERY\x10\x02\x12\r\n" +
	"\tDBG_ENCAP\x10\x03\x12\x11\n" +
	"\rDBG_LXC_FOUND\x10\x04\x12\x15\n" +
	"\x11DBG_POLICY_DENIED\x10\x05\x12\x11\n" +
	"\rDBG_CT_LOOKUP\x10\x06\x12\x15\n" +
	"\x11DBG_CT_LOOKUP_REV\x10\a\x12\x10\n" +
	"\fDBG_CT_MATCH\x10\b\x12\x12\n" +
	"\x0eDBG_CT_CREATED\x10\t\x12\x13\n" +
	"\x0fDBG_CT_CREATED2\x10\n" +
	"\x12\x14\n" +
	"\x10DBG_ICMP6_HANDLE\x10\v\x12\x15\n" +
	"\x11DBG_ICMP6_REQUEST\x10\f\x12\x10\n" +
	"\fDBG_ICMP6_NS\x10\r\x12\x1b\n" +
	"\x17DBG_ICMP6_TIME_EXCEEDED\x10\x0e\x12\x12\n" +
	"\x0eDBG_CT_VERDICT\x10\x0f\x12\r\n" +
	"\tDBG_DECAP\x10\x10\x12\x10\n" +
	"\fDBG_PORT_MAP\x10\x11\x12\x11\n" +
	"\rDBG_ERROR_RET\x10\x12\x12\x0f\n" +
	"\vDBG_TO_HOST\x10\x13\x12\x10\n" +
	"\fDBG_TO_STACK\x10\x14\x12\x10\n" +
	"\fDBG_PKT_HASH\x10\x15\x12\x1b\n" +
	"\x17DBG_LB6_LOOKUP_FRONTEND\x10\x16\x12 \n" +
	"\x1cDBG_LB6_LOOKUP_FRONTEND_FAIL\x10\x17\x12\x1f\n" +
	"\x1bDBG_LB6_LOOKUP_BACKEND_SLOT\x10\x18\x12'\n" +
	"#DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS\x10\x19\x12'\n" +
	"#DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL\x10\x1a\x12\x1f\n" +
	"\x1bDBG_LB6_LOOKUP_BACKEND_FAIL\x10\x1b\x12\x1e\n" +
	"\x1aDBG_LB6_REVERSE_NAT_LOOKUP\x10\x1c\x12\x17\n" +
	"\x13DBG_LB6_REVERSE_NAT\x10\x1d\x12\x1b\n" +
	"\x17DBG_LB4_LOOKUP_FRONTEND\x10\x1e\x12 \n" +
	"\x1cDBG_LB4_LOOKUP_FRONTEND_FAIL\x10\x1f\x12\x1f\n" +
	"\x1bDBG_LB4_LOOKUP_BACKEND_SLOT\x10 \x12'\n" +
	"#DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS\x10!\x12'\n" +
	"#DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL\x10\"\x12\x1f\n" +
	"\x1bDBG_LB4_LOOKUP_BACKEND_FAIL\x10#\x12\x1e\n" +
	"\x1aDBG_LB4_REVERSE_NAT_LOOKUP\x10$\x12\x17\n" +
	"\x13DBG_LB4_REVERSE_NAT\x10%\x12\x19\n" +
	"\x15DBG_LB4_LOOPBACK_SNAT\x10&\x12\x1d\n" +
	"\x19DBG_LB4_LOOPBACK_SNAT_REV\x10'\x12\x12\n" +
	"\x0eDBG_CT_LOOKUP4\x10(\x12\x1b\n" +
	"\x17DBG_RR_BACKEND_SLOT_SEL\x10)\x12\x18\n" +
	"\x14DBG_REV_PROXY_LOOKUP\x10*\x12\x17\n" +
	"\x13DBG_REV_PROXY_FOUND\x10+\x12\x18\n" +
	"\x14DBG_REV_PROXY_UPDATE\x10,\x12\x11\n" +
	"\rDBG_L4_POLICY\x10-\x12\x19\n" +
	"\x15DBG_NETDEV_IN_CLUSTER\x10.\x12\x15\n" +
	"\x11DBG_NETDEV_ENCAP4\x10/\x12\x14\n" +
	"\x10DBG_CT_LOOKUP4_1\x100\x12\x14\n" +
	"\x10DBG_CT_LOOKUP4_2\x101\x12\x13\n" +
	"\x0fDBG_CT_CREATED4\x102\x12\x14\n" +
	"\x10DBG_CT_LOOKUP6_1\x103\x12\x14\n" +
	"\x10DBG_CT_LOOKUP6_2\x104\x12\x13\n" +
	"\x0fDBG_CT_CREATED6\x105\x12\x12\n" +
	"\x0eDBG_SKIP_PROXY\x106\x12\x11\n" +
	"\rDBG_L4_CREATE\x107\x12\x19\n" +
	"\x15DBG_IP_ID_MAP_FAILED4\x108\x12\x19\n" +
	"\x15DBG_IP_ID_MAP_FAILED6\x109\x12\x1a\n" +
	"\x16DBG_IP_ID_MAP_SUCCEED4\x10:\x12\x1a\n" +
	"\x16DBG_IP_ID_MAP_SUCCEED6\x10;\x12\x13\n" +
	"\x0fDBG_LB_STALE_CT\x10<\x12\x18\n" +
	"\x14DBG_INHERIT_IDENTITY\x10=\x12\x12\n" +
	"\x0eDBG_SK_LOOKUP4\x10>\x12\x12\n" +
	"\x0eDBG_SK_LOOKUP6\x10?\x12\x11\n" +
	"\rDBG_SK_ASSIGN\x10@\x12\r\n" +
	"\tDBG_L7_LB\x10A\x12\x13\n" +
	"\x0fDBG_SKIP_POLICY\x10B\x12\x19\n" +
	"\x15DBG_LB6_LOOPBACK_SNAT\x10C\x12\x1d\n" +
	"\x19DBG_LB6_LOOPBACK_SNAT_REV\x10DB&Z$github.com/cilium/cilium/api/v1/flowb\x06proto3"

var (
	file_flow_flow_proto_rawDescOnce sync.Once
	file_flow_flow_proto_rawDescData []byte
)

func file_flow_flow_proto_rawDescGZIP() []byte {
	file_flow_flow_proto_rawDescOnce.Do(func() {
		file_flow_flow_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_flow_flow_proto_rawDesc), len(file_flow_flow_proto_rawDesc)))
	})
	return file_flow_flow_proto_rawDescData
}

var file_flow_flow_proto_enumTypes = make([]protoimpl.EnumInfo, 16)
var file_flow_flow_proto_msgTypes = make([]protoimpl.MessageInfo, 45)
var file_flow_flow_proto_goTypes = []any{
	(FlowType)(0),                         // 0: flow.FlowType
	(AuthType)(0),                         // 1: flow.AuthType
	(TraceObservationPoint)(0),            // 2: flow.TraceObservationPoint
	(TraceReason)(0),                      // 3: flow.TraceReason
	(L7FlowType)(0),                       // 4: flow.L7FlowType
	(IPVersion)(0),                        // 5: flow.IPVersion
	(Verdict)(0),                          // 6: flow.Verdict
	(DropReason)(0),                       // 7: flow.DropReason
	(TrafficDirection)(0),                 // 8: flow.TrafficDirection
	(DebugCapturePoint)(0),                // 9: flow.DebugCapturePoint
	(EventType)(0),                        // 10: flow.EventType
	(LostEventSource)(0),                  // 11: flow.LostEventSource
	(AgentEventType)(0),                   // 12: flow.AgentEventType
	(SocketTranslationPoint)(0),           // 13: flow.SocketTranslationPoint
	(DebugEventType)(0),                   // 14: flow.DebugEventType
	(Tunnel_Protocol)(0),                  // 15: flow.Tunnel.Protocol
	(*Flow)(nil),                          // 16: flow.Flow
	(*Emitter)(nil),                       // 17: flow.Emitter
	(*FileInfo)(nil),                      // 18: flow.FileInfo
	(*Layer4)(nil),                        // 19: flow.Layer4
	(*Layer7)(nil),                        // 20: flow.Layer7
	(*TraceContext)(nil),                  // 21: flow.TraceContext
	(*TraceParent)(nil),                   // 22: flow.TraceParent
	(*Endpoint)(nil),                      // 23: flow.Endpoint
	(*Workload)(nil),                      // 24: flow.Workload
	(*TCP)(nil),                           // 25: flow.TCP
	(*IP)(nil),                            // 26: flow.IP
	(*Ethernet)(nil),                      // 27: flow.Ethernet
	(*TCPFlags)(nil),                      // 28: flow.TCPFlags
	(*UDP)(nil),                           // 29: flow.UDP
	(*SCTP)(nil),                          // 30: flow.SCTP
	(*ICMPv4)(nil),                        // 31: flow.ICMPv4
	(*ICMPv6)(nil),                        // 32: flow.ICMPv6
	(*VRRP)(nil),                          // 33: flow.VRRP
	(*IGMP)(nil),                          // 34: flow.IGMP
	(*Tunnel)(nil),                        // 35: flow.Tunnel
	(*Policy)(nil),                        // 36: flow.Policy
	(*EventTypeFilter)(nil),               // 37: flow.EventTypeFilter
	(*CiliumEventType)(nil),               // 38: flow.CiliumEventType
	(*FlowFilter)(nil),                    // 39: flow.FlowFilter
	(*DNS)(nil),                           // 40: flow.DNS
	(*HTTPHeader)(nil),                    // 41: flow.HTTPHeader
	(*HTTP)(nil),                          // 42: flow.HTTP
	(*Kafka)(nil),                         // 43: flow.Kafka
	(*Service)(nil),                       // 44: flow.Service
	(*IPTraceID)(nil),                     // 45: flow.IPTraceID
	(*LostEvent)(nil),                     // 46: flow.LostEvent
	(*AgentEvent)(nil),                    // 47: flow.AgentEvent
	(*AgentEventUnknown)(nil),             // 48: flow.AgentEventUnknown
	(*TimeNotification)(nil),              // 49: flow.TimeNotification
	(*PolicyUpdateNotification)(nil),      // 50: flow.PolicyUpdateNotification
	(*EndpointRegenNotification)(nil),     // 51: flow.EndpointRegenNotification
	(*EndpointUpdateNotification)(nil),    // 52: flow.EndpointUpdateNotification
	(*IPCacheNotification)(nil),           // 53: flow.IPCacheNotification
	(*ServiceUpsertNotificationAddr)(nil), // 54: flow.ServiceUpsertNotificationAddr
	(*ServiceUpsertNotification)(nil),     // 55: flow.ServiceUpsertNotification
	(*ServiceDeleteNotification)(nil),     // 56: flow.ServiceDeleteNotification
	(*NetworkInterface)(nil),              // 57: flow.NetworkInterface
	(*DebugEvent)(nil),                    // 58: flow.DebugEvent
	(*Aggregate)(nil),                     // 59: flow.Aggregate
	(*FlowFilter_Experimental)(nil),       // 60: flow.FlowFilter.Experimental
	(*timestamppb.Timestamp)(nil),         // 61: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),          // 62: google.protobuf.BoolValue
	(*anypb.Any)(nil),                     // 63: google.protobuf.Any
	(*wrapperspb.Int32Value)(nil),         // 64: google.protobuf.Int32Value
	(*wrapperspb.UInt32Value)(nil),        // 65: google.protobuf.UInt32Value
}
var file_flow_flow_proto_depIdxs = []int32{
	61, // 0: flow.Flow.time:type_name -> google.protobuf.Timestamp
	17, // 1: flow.Flow.emitter:type_name -> flow.Emitter
	6,  // 2: flow.Flow.verdict:type_name -> flow.Verdict
	1,  // 3: flow.Flow.auth_type:type_name -> flow.AuthType
	27, // 4: flow.Flow.ethernet:type_name -> flow.Ethernet
	26, // 5: flow.Flow.IP:type_name -> flow.IP
	19, // 6: flow.Flow.l4:type_name -> flow.Layer4
	35, // 7: flow.Flow.tunnel:type_name -> flow.Tunnel
	23, // 8: flow.Flow.source:type_name -> flow.Endpoint
	23, // 9: flow.Flow.destination:type_name -> flow.Endpoint
	0,  // 10: flow.Flow.Type:type_name -> flow.FlowType
	20, // 11: flow.Flow.l7:type_name -> flow.Layer7
	38, // 12: flow.Flow.event_type:type_name -> flow.CiliumEventType
	44, // 13: flow.Flow.source_service:type_name -> flow.Service
	44, // 14: flow.Flow.destination_service:type_name -> flow.Service
	8,  // 15: flow.Flow.traffic_direction:type_name -> flow.TrafficDirection
	2,  // 16: flow.Flow.trace_observation_point:type_name -> flow.TraceObservationPoint
	3,  // 17: flow.Flow.trace_reason:type_name -> flow.TraceReason
	18, // 18: flow.Flow.file:type_name -> flow.FileInfo
	45, // 19: flow.Flow.ip_trace_id:type_name -> flow.IPTraceID
	7,  // 20: flow.Flow.drop_reason_desc:type_name -> flow.DropReason
	62, // 21: flow.Flow.is_reply:type_name -> google.protobuf.BoolValue
	9,  // 22: flow.Flow.debug_capture_point:type_name -> flow.DebugCapturePoint
	57, // 23: flow.Flow.interface:type_name -> flow.NetworkInterface
	21, // 24: flow.Flow.trace_context:type_name -> flow.TraceContext
	13, // 25: flow.Flow.sock_xlate_point:type_name -> flow.SocketTranslationPoint
	63, // 26: flow.Flow.extensions:type_name -> google.protobuf.Any
	36, // 27: flow.Flow.egress_allowed_by:type_name -> flow.Policy
	36, // 28: flow.Flow.ingress_allowed_by:type_name -> flow.Policy
	36, // 29: flow.Flow.egress_denied_by:type_name -> flow.Policy
	36, // 30: flow.Flow.ingress_denied_by:type_name -> flow.Policy
	59, // 31: flow.Flow.aggregate:type_name -> flow.Aggregate
	25, // 32: flow.Layer4.TCP:type_name -> flow.TCP
	29, // 33: flow.Layer4.UDP:type_name -> flow.UDP
	31, // 34: flow.Layer4.ICMPv4:type_name -> flow.ICMPv4
	32, // 35: flow.Layer4.ICMPv6:type_name -> flow.ICMPv6
	30, // 36: flow.Layer4.SCTP:type_name -> flow.SCTP
	33, // 37: flow.Layer4.VRRP:type_name -> flow.VRRP
	34, // 38: flow.Layer4.IGMP:type_name -> flow.IGMP
	4,  // 39: flow.Layer7.type:type_name -> flow.L7FlowType
	40, // 40: flow.Layer7.dns:type_name -> flow.DNS
	42, // 41: flow.Layer7.http:type_name -> flow.HTTP
	43, // 42: flow.Layer7.kafka:type_name -> flow.Kafka
	22, // 43: flow.TraceContext.parent:type_name -> flow.TraceParent
	24, // 44: flow.Endpoint.workloads:type_name -> flow.Workload
	28, // 45: flow.TCP.flags:type_name -> flow.TCPFlags
	5,  // 46: flow.IP.ipVersion:type_name -> flow.IPVersion
	15, // 47: flow.Tunnel.protocol:type_name -> flow.Tunnel.Protocol
	26, // 48: flow.Tunnel.IP:type_name -> flow.IP
	19, // 49: flow.Tunnel.l4:type_name -> flow.Layer4
	24, // 50: flow.FlowFilter.source_workload:type_name -> flow.Workload
	24, // 51: flow.FlowFilter.destination_workload:type_name -> flow.Workload
	8,  // 52: flow.FlowFilter.traffic_direction:type_name -> flow.TrafficDirection
	6,  // 53: flow.FlowFilter.verdict:type_name -> flow.Verdict
	7,  // 54: flow.FlowFilter.drop_reason_desc:type_name -> flow.DropReason
	57, // 55: flow.FlowFilter.interface:type_name -> flow.NetworkInterface
	37, // 56: flow.FlowFilter.event_type:type_name -> flow.EventTypeFilter
	41, // 57: flow.FlowFilter.http_header:type_name -> flow.HTTPHeader
	28, // 58: flow.FlowFilter.tcp_flags:type_name -> flow.TCPFlags
	5,  // 59: flow.FlowFilter.ip_version:type_name -> flow.IPVersion
	60, // 60: flow.FlowFilter.experimental:type_name -> flow.FlowFilter.Experimental
	41, // 61: flow.HTTP.headers:type_name -> flow.HTTPHeader
	11, // 62: flow.LostEvent.source:type_name -> flow.LostEventSource
	64, // 63: flow.LostEvent.cpu:type_name -> google.protobuf.Int32Value
	61, // 64: flow.LostEvent.first:type_name -> google.protobuf.Timestamp
	61, // 65: flow.LostEvent.last:type_name -> google.protobuf.Timestamp
	12, // 66: flow.AgentEvent.type:type_name -> flow.AgentEventType
	48, // 67: flow.AgentEvent.unknown:type_name -> flow.AgentEventUnknown
	49, // 68: flow.AgentEvent.agent_start:type_name -> flow.TimeNotification
	50, // 69: flow.AgentEvent.policy_update:type_name -> flow.PolicyUpdateNotification
	51, // 70: flow.AgentEvent.endpoint_regenerate:type_name -> flow.EndpointRegenNotification
	52, // 71: flow.AgentEvent.endpoint_update:type_name -> flow.EndpointUpdateNotification
	53, // 72: flow.AgentEvent.ipcache_update:type_name -> flow.IPCacheNotification
	55, // 73: flow.AgentEvent.service_upsert:type_name -> flow.ServiceUpsertNotification
	56, // 74: flow.AgentEvent.service_delete:type_name -> flow.ServiceDeleteNotification
	61, // 75: flow.TimeNotification.time:type_name -> google.protobuf.Timestamp
	65, // 76: flow.IPCacheNotification.old_identity:type_name -> google.protobuf.UInt32Value
	54, // 77: flow.ServiceUpsertNotification.frontend_address:type_name -> flow.ServiceUpsertNotificationAddr
	54, // 78: flow.ServiceUpsertNotification.backend_addresses:type_name -> flow.ServiceUpsertNotificationAddr
	14, // 79: flow.DebugEvent.type:type_name -> flow.DebugEventType
	23, // 80: flow.DebugEvent.source:type_name -> flow.Endpoint
	65, // 81: flow.DebugEvent.hash:type_name -> google.protobuf.UInt32Value
	65, // 82: flow.DebugEvent.arg1:type_name -> google.protobuf.UInt32Value
	65, // 83: flow.DebugEvent.arg2:type_name -> google.protobuf.UInt32Value
	65, // 84: flow.DebugEvent.arg3:type_name -> google.protobuf.UInt32Value
	64, // 85: flow.DebugEvent.cpu:type_name -> google.protobuf.Int32Value
	86, // [86:86] is the sub-list for method output_type
	86, // [86:86] is the sub-list for method input_type
	86, // [86:86] is the sub-list for extension type_name
	86, // [86:86] is the sub-list for extension extendee
	0,  // [0:86] is the sub-list for field type_name
}

func init() { file_flow_flow_proto_init() }
func file_flow_flow_proto_init() {
	if File_flow_flow_proto != nil {
		return
	}
	file_flow_flow_proto_msgTypes[3].OneofWrappers = []any{
		(*Layer4_TCP)(nil),
		(*Layer4_UDP)(nil),
		(*Layer4_ICMPv4)(nil),
		(*Layer4_ICMPv6)(nil),
		(*Layer4_SCTP)(nil),
		(*Layer4_VRRP)(nil),
		(*Layer4_IGMP)(nil),
	}
	file_flow_flow_proto_msgTypes[4].OneofWrappers = []any{
		(*Layer7_Dns)(nil),
		(*Layer7_Http)(nil),
		(*Layer7_Kafka)(nil),
	}
	file_flow_flow_proto_msgTypes[31].OneofWrappers = []any{
		(*AgentEvent_Unknown)(nil),
		(*AgentEvent_AgentStart)(nil),
		(*AgentEvent_PolicyUpdate)(nil),
		(*AgentEvent_EndpointRegenerate)(nil),
		(*AgentEvent_EndpointUpdate)(nil),
		(*AgentEvent_IpcacheUpdate)(nil),
		(*AgentEvent_ServiceUpsert)(nil),
		(*AgentEvent_ServiceDelete)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_flow_flow_proto_rawDesc), len(file_flow_flow_proto_rawDesc)),
			NumEnums:      16,
			NumMessages:   45,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_flow_flow_proto_goTypes,
		DependencyIndexes: file_flow_flow_proto_depIdxs,
		EnumInfos:         file_flow_flow_proto_enumTypes,
		MessageInfos:      file_flow_flow_proto_msgTypes,
	}.Build()
	File_flow_flow_proto = out.File
	file_flow_flow_proto_goTypes = nil
	file_flow_flow_proto_depIdxs = nil
}
