/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// CapacityRequirementsApplyConfiguration represents a declarative configuration of the CapacityRequirements type for use
// with apply.
//
// CapacityRequirements defines the capacity requirements for a specific device request.
type CapacityRequirementsApplyConfiguration struct {
	// Requests represent individual device resource requests for distinct resources,
	// all of which must be provided by the device.
	//
	// This value is used as an additional filtering condition against the available capacity on the device.
	// This is semantically equivalent to a CEL selector with
	// `device.capacity[<domain>].<name>.compareTo(quantity(<request quantity>)) >= 0`.
	// For example, device.capacity['test-driver.cdi.k8s.io'].counters.compareTo(quantity('2')) >= 0.
	//
	// When a requestPolicy is defined, the requested amount is adjusted upward
	// to the nearest valid value based on the policy.
	// If the requested amount cannot be adjusted to a valid value—because it exceeds what the requestPolicy allows—
	// the device is considered ineligible for allocation.
	//
	// For any capacity that is not explicitly requested:
	// - If no requestPolicy is set, the default consumed capacity is equal to the full device capacity
	// (i.e., the whole device is claimed).
	// - If a requestPolicy is set, the default consumed capacity is determined according to that policy.
	//
	// If the device allows multiple allocation,
	// the aggregated amount across all requests must not exceed the capacity value.
	// The consumed capacity, which may be adjusted based on the requestPolicy if defined,
	// is recorded in the resource claim’s status.devices[*].consumedCapacity field.
	Requests map[resourcev1beta2.QualifiedName]resource.Quantity `json:"requests,omitempty"`
}

// CapacityRequirementsApplyConfiguration constructs a declarative configuration of the CapacityRequirements type for use with
// apply.
func CapacityRequirements() *CapacityRequirementsApplyConfiguration {
	return &CapacityRequirementsApplyConfiguration{}
}

// WithRequests puts the entries into the Requests field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Requests field,
// overwriting an existing map entries in Requests field with the same key.
func (b *CapacityRequirementsApplyConfiguration) WithRequests(entries map[resourcev1beta2.QualifiedName]resource.Quantity) *CapacityRequirementsApplyConfiguration {
	if b.Requests == nil && len(entries) > 0 {
		b.Requests = make(map[resourcev1beta2.QualifiedName]resource.Quantity, len(entries))
	}
	for k, v := range entries {
		b.Requests[k] = v
	}
	return b
}
