// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: control.proto

package moby_buildkit_v1

import (
	context "context"
	fmt "fmt"
	types "github.com/dagger/dagger/internal/buildkit/api/types"
	pb "github.com/dagger/dagger/internal/buildkit/solver/pb"
	pb1 "github.com/dagger/dagger/internal/buildkit/sourcepolicy/pb"
	github_com_dagger_dagger_internal_buildkit_util_entitlements "github.com/dagger/dagger/internal/buildkit/util/entitlements"
	rpc "github.com/gogo/googleapis/google/rpc"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	github_com_opencontainers_go_digest "github.com/opencontainers/go-digest"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	_ "google.golang.org/protobuf/types/known/timestamppb"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type BuildHistoryEventType int32

const (
	BuildHistoryEventType_STARTED  BuildHistoryEventType = 0
	BuildHistoryEventType_COMPLETE BuildHistoryEventType = 1
	BuildHistoryEventType_DELETED  BuildHistoryEventType = 2
)

var BuildHistoryEventType_name = map[int32]string{
	0: "STARTED",
	1: "COMPLETE",
	2: "DELETED",
}

var BuildHistoryEventType_value = map[string]int32{
	"STARTED":  0,
	"COMPLETE": 1,
	"DELETED":  2,
}

func (x BuildHistoryEventType) String() string {
	return proto.EnumName(BuildHistoryEventType_name, int32(x))
}

func (BuildHistoryEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{0}
}

type PruneRequest struct {
	Filter               []string `protobuf:"bytes,1,rep,name=filter,proto3" json:"filter,omitempty"`
	All                  bool     `protobuf:"varint,2,opt,name=all,proto3" json:"all,omitempty"`
	KeepDuration         int64    `protobuf:"varint,3,opt,name=keepDuration,proto3" json:"keepDuration,omitempty"`
	ReservedSpace        int64    `protobuf:"varint,4,opt,name=reservedSpace,proto3" json:"reservedSpace,omitempty"`
	TargetSpace          int64    `protobuf:"varint,7,opt,name=targetSpace,proto3" json:"targetSpace,omitempty"`
	MaxUsedSpace         int64    `protobuf:"varint,5,opt,name=maxUsedSpace,proto3" json:"maxUsedSpace,omitempty"`
	MinFreeSpace         int64    `protobuf:"varint,6,opt,name=minFreeSpace,proto3" json:"minFreeSpace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PruneRequest) Reset()         { *m = PruneRequest{} }
func (m *PruneRequest) String() string { return proto.CompactTextString(m) }
func (*PruneRequest) ProtoMessage()    {}
func (*PruneRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{0}
}
func (m *PruneRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PruneRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PruneRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PruneRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PruneRequest.Merge(m, src)
}
func (m *PruneRequest) XXX_Size() int {
	return m.Size()
}
func (m *PruneRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PruneRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PruneRequest proto.InternalMessageInfo

func (m *PruneRequest) GetFilter() []string {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *PruneRequest) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *PruneRequest) GetKeepDuration() int64 {
	if m != nil {
		return m.KeepDuration
	}
	return 0
}

func (m *PruneRequest) GetReservedSpace() int64 {
	if m != nil {
		return m.ReservedSpace
	}
	return 0
}

func (m *PruneRequest) GetTargetSpace() int64 {
	if m != nil {
		return m.TargetSpace
	}
	return 0
}

func (m *PruneRequest) GetMaxUsedSpace() int64 {
	if m != nil {
		return m.MaxUsedSpace
	}
	return 0
}

func (m *PruneRequest) GetMinFreeSpace() int64 {
	if m != nil {
		return m.MinFreeSpace
	}
	return 0
}

type DiskUsageRequest struct {
	Filter               []string `protobuf:"bytes,1,rep,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiskUsageRequest) Reset()         { *m = DiskUsageRequest{} }
func (m *DiskUsageRequest) String() string { return proto.CompactTextString(m) }
func (*DiskUsageRequest) ProtoMessage()    {}
func (*DiskUsageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{1}
}
func (m *DiskUsageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DiskUsageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DiskUsageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DiskUsageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskUsageRequest.Merge(m, src)
}
func (m *DiskUsageRequest) XXX_Size() int {
	return m.Size()
}
func (m *DiskUsageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskUsageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiskUsageRequest proto.InternalMessageInfo

func (m *DiskUsageRequest) GetFilter() []string {
	if m != nil {
		return m.Filter
	}
	return nil
}

type DiskUsageResponse struct {
	Record               []*UsageRecord `protobuf:"bytes,1,rep,name=record,proto3" json:"record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DiskUsageResponse) Reset()         { *m = DiskUsageResponse{} }
func (m *DiskUsageResponse) String() string { return proto.CompactTextString(m) }
func (*DiskUsageResponse) ProtoMessage()    {}
func (*DiskUsageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{2}
}
func (m *DiskUsageResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DiskUsageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DiskUsageResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DiskUsageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskUsageResponse.Merge(m, src)
}
func (m *DiskUsageResponse) XXX_Size() int {
	return m.Size()
}
func (m *DiskUsageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskUsageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DiskUsageResponse proto.InternalMessageInfo

func (m *DiskUsageResponse) GetRecord() []*UsageRecord {
	if m != nil {
		return m.Record
	}
	return nil
}

type UsageRecord struct {
	ID                   string     `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Mutable              bool       `protobuf:"varint,2,opt,name=Mutable,proto3" json:"Mutable,omitempty"`
	InUse                bool       `protobuf:"varint,3,opt,name=InUse,proto3" json:"InUse,omitempty"`
	Size_                int64      `protobuf:"varint,4,opt,name=Size,proto3" json:"Size,omitempty"`
	Parent               string     `protobuf:"bytes,5,opt,name=Parent,proto3" json:"Parent,omitempty"` // Deprecated: Do not use.
	CreatedAt            time.Time  `protobuf:"bytes,6,opt,name=CreatedAt,proto3,stdtime" json:"CreatedAt"`
	LastUsedAt           *time.Time `protobuf:"bytes,7,opt,name=LastUsedAt,proto3,stdtime" json:"LastUsedAt,omitempty"`
	UsageCount           int64      `protobuf:"varint,8,opt,name=UsageCount,proto3" json:"UsageCount,omitempty"`
	Description          string     `protobuf:"bytes,9,opt,name=Description,proto3" json:"Description,omitempty"`
	RecordType           string     `protobuf:"bytes,10,opt,name=RecordType,proto3" json:"RecordType,omitempty"`
	Shared               bool       `protobuf:"varint,11,opt,name=Shared,proto3" json:"Shared,omitempty"`
	Parents              []string   `protobuf:"bytes,12,rep,name=Parents,proto3" json:"Parents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *UsageRecord) Reset()         { *m = UsageRecord{} }
func (m *UsageRecord) String() string { return proto.CompactTextString(m) }
func (*UsageRecord) ProtoMessage()    {}
func (*UsageRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{3}
}
func (m *UsageRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageRecord.Merge(m, src)
}
func (m *UsageRecord) XXX_Size() int {
	return m.Size()
}
func (m *UsageRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageRecord.DiscardUnknown(m)
}

var xxx_messageInfo_UsageRecord proto.InternalMessageInfo

func (m *UsageRecord) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *UsageRecord) GetMutable() bool {
	if m != nil {
		return m.Mutable
	}
	return false
}

func (m *UsageRecord) GetInUse() bool {
	if m != nil {
		return m.InUse
	}
	return false
}

func (m *UsageRecord) GetSize_() int64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

// Deprecated: Do not use.
func (m *UsageRecord) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *UsageRecord) GetCreatedAt() time.Time {
	if m != nil {
		return m.CreatedAt
	}
	return time.Time{}
}

func (m *UsageRecord) GetLastUsedAt() *time.Time {
	if m != nil {
		return m.LastUsedAt
	}
	return nil
}

func (m *UsageRecord) GetUsageCount() int64 {
	if m != nil {
		return m.UsageCount
	}
	return 0
}

func (m *UsageRecord) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UsageRecord) GetRecordType() string {
	if m != nil {
		return m.RecordType
	}
	return ""
}

func (m *UsageRecord) GetShared() bool {
	if m != nil {
		return m.Shared
	}
	return false
}

func (m *UsageRecord) GetParents() []string {
	if m != nil {
		return m.Parents
	}
	return nil
}

type SolveRequest struct {
	Ref        string         `protobuf:"bytes,1,opt,name=Ref,proto3" json:"Ref,omitempty"`
	Definition *pb.Definition `protobuf:"bytes,2,opt,name=Definition,proto3" json:"Definition,omitempty"`
	// ExporterDeprecated and ExporterAttrsDeprecated are deprecated in favor
	// of the new Exporters. If these fields are set, then they will be
	// appended to the Exporters field if Exporters was not explicitly set.
	ExporterDeprecated      string                                                                     `protobuf:"bytes,3,opt,name=ExporterDeprecated,proto3" json:"ExporterDeprecated,omitempty"`
	ExporterAttrsDeprecated map[string]string                                                          `protobuf:"bytes,4,rep,name=ExporterAttrsDeprecated,proto3" json:"ExporterAttrsDeprecated,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Session                 string                                                                     `protobuf:"bytes,5,opt,name=Session,proto3" json:"Session,omitempty"`
	Frontend                string                                                                     `protobuf:"bytes,6,opt,name=Frontend,proto3" json:"Frontend,omitempty"`
	FrontendAttrs           map[string]string                                                          `protobuf:"bytes,7,rep,name=FrontendAttrs,proto3" json:"FrontendAttrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Cache                   CacheOptions                                                               `protobuf:"bytes,8,opt,name=Cache,proto3" json:"Cache"`
	Entitlements            []github_com_dagger_dagger_internal_buildkit_util_entitlements.Entitlement `protobuf:"bytes,9,rep,name=Entitlements,proto3,customtype=github.com/dagger/dagger/internal/buildkit/util/entitlements.Entitlement" json:"Entitlements,omitempty"`
	FrontendInputs          map[string]*pb.Definition                                                  `protobuf:"bytes,10,rep,name=FrontendInputs,proto3" json:"FrontendInputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Internal                bool                                                                       `protobuf:"varint,11,opt,name=Internal,proto3" json:"Internal,omitempty"`
	SourcePolicy            *pb1.Policy                                                                `protobuf:"bytes,12,opt,name=SourcePolicy,proto3" json:"SourcePolicy,omitempty"`
	Exporters               []*Exporter                                                                `protobuf:"bytes,13,rep,name=Exporters,proto3" json:"Exporters,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                                                                   `json:"-"`
	XXX_unrecognized        []byte                                                                     `json:"-"`
	XXX_sizecache           int32                                                                      `json:"-"`
}

func (m *SolveRequest) Reset()         { *m = SolveRequest{} }
func (m *SolveRequest) String() string { return proto.CompactTextString(m) }
func (*SolveRequest) ProtoMessage()    {}
func (*SolveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{4}
}
func (m *SolveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SolveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SolveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SolveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SolveRequest.Merge(m, src)
}
func (m *SolveRequest) XXX_Size() int {
	return m.Size()
}
func (m *SolveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SolveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SolveRequest proto.InternalMessageInfo

func (m *SolveRequest) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *SolveRequest) GetDefinition() *pb.Definition {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (m *SolveRequest) GetExporterDeprecated() string {
	if m != nil {
		return m.ExporterDeprecated
	}
	return ""
}

func (m *SolveRequest) GetExporterAttrsDeprecated() map[string]string {
	if m != nil {
		return m.ExporterAttrsDeprecated
	}
	return nil
}

func (m *SolveRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *SolveRequest) GetFrontend() string {
	if m != nil {
		return m.Frontend
	}
	return ""
}

func (m *SolveRequest) GetFrontendAttrs() map[string]string {
	if m != nil {
		return m.FrontendAttrs
	}
	return nil
}

func (m *SolveRequest) GetCache() CacheOptions {
	if m != nil {
		return m.Cache
	}
	return CacheOptions{}
}

func (m *SolveRequest) GetFrontendInputs() map[string]*pb.Definition {
	if m != nil {
		return m.FrontendInputs
	}
	return nil
}

func (m *SolveRequest) GetInternal() bool {
	if m != nil {
		return m.Internal
	}
	return false
}

func (m *SolveRequest) GetSourcePolicy() *pb1.Policy {
	if m != nil {
		return m.SourcePolicy
	}
	return nil
}

func (m *SolveRequest) GetExporters() []*Exporter {
	if m != nil {
		return m.Exporters
	}
	return nil
}

type CacheOptions struct {
	// ExportRefDeprecated is deprecated in favor or the new Exports since BuildKit v0.4.0.
	// When ExportRefDeprecated is set, the solver appends
	// {.Type = "registry", .Attrs = ExportAttrs.add("ref", ExportRef)}
	// to Exports for compatibility. (planned to be removed)
	ExportRefDeprecated string `protobuf:"bytes,1,opt,name=ExportRefDeprecated,proto3" json:"ExportRefDeprecated,omitempty"`
	// ImportRefsDeprecated is deprecated in favor or the new Imports since BuildKit v0.4.0.
	// When ImportRefsDeprecated is set, the solver appends
	// {.Type = "registry", .Attrs = {"ref": importRef}}
	// for each of the ImportRefs entry to Imports for compatibility. (planned to be removed)
	ImportRefsDeprecated []string `protobuf:"bytes,2,rep,name=ImportRefsDeprecated,proto3" json:"ImportRefsDeprecated,omitempty"`
	// ExportAttrsDeprecated is deprecated since BuildKit v0.4.0.
	// See the description of ExportRefDeprecated.
	ExportAttrsDeprecated map[string]string `protobuf:"bytes,3,rep,name=ExportAttrsDeprecated,proto3" json:"ExportAttrsDeprecated,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Exports was introduced in BuildKit v0.4.0.
	Exports []*CacheOptionsEntry `protobuf:"bytes,4,rep,name=Exports,proto3" json:"Exports,omitempty"`
	// Imports was introduced in BuildKit v0.4.0.
	Imports              []*CacheOptionsEntry `protobuf:"bytes,5,rep,name=Imports,proto3" json:"Imports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CacheOptions) Reset()         { *m = CacheOptions{} }
func (m *CacheOptions) String() string { return proto.CompactTextString(m) }
func (*CacheOptions) ProtoMessage()    {}
func (*CacheOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{5}
}
func (m *CacheOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CacheOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CacheOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CacheOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CacheOptions.Merge(m, src)
}
func (m *CacheOptions) XXX_Size() int {
	return m.Size()
}
func (m *CacheOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_CacheOptions.DiscardUnknown(m)
}

var xxx_messageInfo_CacheOptions proto.InternalMessageInfo

func (m *CacheOptions) GetExportRefDeprecated() string {
	if m != nil {
		return m.ExportRefDeprecated
	}
	return ""
}

func (m *CacheOptions) GetImportRefsDeprecated() []string {
	if m != nil {
		return m.ImportRefsDeprecated
	}
	return nil
}

func (m *CacheOptions) GetExportAttrsDeprecated() map[string]string {
	if m != nil {
		return m.ExportAttrsDeprecated
	}
	return nil
}

func (m *CacheOptions) GetExports() []*CacheOptionsEntry {
	if m != nil {
		return m.Exports
	}
	return nil
}

func (m *CacheOptions) GetImports() []*CacheOptionsEntry {
	if m != nil {
		return m.Imports
	}
	return nil
}

type CacheOptionsEntry struct {
	// Type is like "registry" or "local"
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty"`
	// Attrs are like mode=(min,max), ref=example.com:5000/foo/bar .
	// See cache importer/exporter implementations' documentation.
	Attrs                map[string]string `protobuf:"bytes,2,rep,name=Attrs,proto3" json:"Attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CacheOptionsEntry) Reset()         { *m = CacheOptionsEntry{} }
func (m *CacheOptionsEntry) String() string { return proto.CompactTextString(m) }
func (*CacheOptionsEntry) ProtoMessage()    {}
func (*CacheOptionsEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{6}
}
func (m *CacheOptionsEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CacheOptionsEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CacheOptionsEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CacheOptionsEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CacheOptionsEntry.Merge(m, src)
}
func (m *CacheOptionsEntry) XXX_Size() int {
	return m.Size()
}
func (m *CacheOptionsEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_CacheOptionsEntry.DiscardUnknown(m)
}

var xxx_messageInfo_CacheOptionsEntry proto.InternalMessageInfo

func (m *CacheOptionsEntry) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *CacheOptionsEntry) GetAttrs() map[string]string {
	if m != nil {
		return m.Attrs
	}
	return nil
}

type SolveResponse struct {
	ExporterResponse     map[string]string `protobuf:"bytes,1,rep,name=ExporterResponse,proto3" json:"ExporterResponse,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SolveResponse) Reset()         { *m = SolveResponse{} }
func (m *SolveResponse) String() string { return proto.CompactTextString(m) }
func (*SolveResponse) ProtoMessage()    {}
func (*SolveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{7}
}
func (m *SolveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SolveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SolveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SolveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SolveResponse.Merge(m, src)
}
func (m *SolveResponse) XXX_Size() int {
	return m.Size()
}
func (m *SolveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SolveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SolveResponse proto.InternalMessageInfo

func (m *SolveResponse) GetExporterResponse() map[string]string {
	if m != nil {
		return m.ExporterResponse
	}
	return nil
}

type StatusRequest struct {
	Ref                  string   `protobuf:"bytes,1,opt,name=Ref,proto3" json:"Ref,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatusRequest) Reset()         { *m = StatusRequest{} }
func (m *StatusRequest) String() string { return proto.CompactTextString(m) }
func (*StatusRequest) ProtoMessage()    {}
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{8}
}
func (m *StatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusRequest.Merge(m, src)
}
func (m *StatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *StatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StatusRequest proto.InternalMessageInfo

func (m *StatusRequest) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

type StatusResponse struct {
	Vertexes             []*Vertex        `protobuf:"bytes,1,rep,name=vertexes,proto3" json:"vertexes,omitempty"`
	Statuses             []*VertexStatus  `protobuf:"bytes,2,rep,name=statuses,proto3" json:"statuses,omitempty"`
	Logs                 []*VertexLog     `protobuf:"bytes,3,rep,name=logs,proto3" json:"logs,omitempty"`
	Warnings             []*VertexWarning `protobuf:"bytes,4,rep,name=warnings,proto3" json:"warnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *StatusResponse) Reset()         { *m = StatusResponse{} }
func (m *StatusResponse) String() string { return proto.CompactTextString(m) }
func (*StatusResponse) ProtoMessage()    {}
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{9}
}
func (m *StatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusResponse.Merge(m, src)
}
func (m *StatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *StatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StatusResponse proto.InternalMessageInfo

func (m *StatusResponse) GetVertexes() []*Vertex {
	if m != nil {
		return m.Vertexes
	}
	return nil
}

func (m *StatusResponse) GetStatuses() []*VertexStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *StatusResponse) GetLogs() []*VertexLog {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *StatusResponse) GetWarnings() []*VertexWarning {
	if m != nil {
		return m.Warnings
	}
	return nil
}

type Vertex struct {
	Digest               github_com_opencontainers_go_digest.Digest   `protobuf:"bytes,1,opt,name=digest,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"digest"`
	Inputs               []github_com_opencontainers_go_digest.Digest `protobuf:"bytes,2,rep,name=inputs,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"inputs"`
	Name                 string                                       `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Cached               bool                                         `protobuf:"varint,4,opt,name=cached,proto3" json:"cached,omitempty"`
	Started              *time.Time                                   `protobuf:"bytes,5,opt,name=started,proto3,stdtime" json:"started,omitempty"`
	Completed            *time.Time                                   `protobuf:"bytes,6,opt,name=completed,proto3,stdtime" json:"completed,omitempty"`
	Error                string                                       `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	ProgressGroup        *pb.ProgressGroup                            `protobuf:"bytes,8,opt,name=progressGroup,proto3" json:"progressGroup,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *Vertex) Reset()         { *m = Vertex{} }
func (m *Vertex) String() string { return proto.CompactTextString(m) }
func (*Vertex) ProtoMessage()    {}
func (*Vertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{10}
}
func (m *Vertex) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Vertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Vertex.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Vertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vertex.Merge(m, src)
}
func (m *Vertex) XXX_Size() int {
	return m.Size()
}
func (m *Vertex) XXX_DiscardUnknown() {
	xxx_messageInfo_Vertex.DiscardUnknown(m)
}

var xxx_messageInfo_Vertex proto.InternalMessageInfo

func (m *Vertex) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Vertex) GetCached() bool {
	if m != nil {
		return m.Cached
	}
	return false
}

func (m *Vertex) GetStarted() *time.Time {
	if m != nil {
		return m.Started
	}
	return nil
}

func (m *Vertex) GetCompleted() *time.Time {
	if m != nil {
		return m.Completed
	}
	return nil
}

func (m *Vertex) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Vertex) GetProgressGroup() *pb.ProgressGroup {
	if m != nil {
		return m.ProgressGroup
	}
	return nil
}

type VertexStatus struct {
	ID                   string                                     `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Vertex               github_com_opencontainers_go_digest.Digest `protobuf:"bytes,2,opt,name=vertex,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"vertex"`
	Name                 string                                     `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Current              int64                                      `protobuf:"varint,4,opt,name=current,proto3" json:"current,omitempty"`
	Total                int64                                      `protobuf:"varint,5,opt,name=total,proto3" json:"total,omitempty"`
	Timestamp            time.Time                                  `protobuf:"bytes,6,opt,name=timestamp,proto3,stdtime" json:"timestamp"`
	Started              *time.Time                                 `protobuf:"bytes,7,opt,name=started,proto3,stdtime" json:"started,omitempty"`
	Completed            *time.Time                                 `protobuf:"bytes,8,opt,name=completed,proto3,stdtime" json:"completed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *VertexStatus) Reset()         { *m = VertexStatus{} }
func (m *VertexStatus) String() string { return proto.CompactTextString(m) }
func (*VertexStatus) ProtoMessage()    {}
func (*VertexStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{11}
}
func (m *VertexStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VertexStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VertexStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VertexStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VertexStatus.Merge(m, src)
}
func (m *VertexStatus) XXX_Size() int {
	return m.Size()
}
func (m *VertexStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_VertexStatus.DiscardUnknown(m)
}

var xxx_messageInfo_VertexStatus proto.InternalMessageInfo

func (m *VertexStatus) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *VertexStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VertexStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *VertexStatus) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *VertexStatus) GetTimestamp() time.Time {
	if m != nil {
		return m.Timestamp
	}
	return time.Time{}
}

func (m *VertexStatus) GetStarted() *time.Time {
	if m != nil {
		return m.Started
	}
	return nil
}

func (m *VertexStatus) GetCompleted() *time.Time {
	if m != nil {
		return m.Completed
	}
	return nil
}

type VertexLog struct {
	Vertex               github_com_opencontainers_go_digest.Digest `protobuf:"bytes,1,opt,name=vertex,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"vertex"`
	Timestamp            time.Time                                  `protobuf:"bytes,2,opt,name=timestamp,proto3,stdtime" json:"timestamp"`
	Stream               int64                                      `protobuf:"varint,3,opt,name=stream,proto3" json:"stream,omitempty"`
	Msg                  []byte                                     `protobuf:"bytes,4,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *VertexLog) Reset()         { *m = VertexLog{} }
func (m *VertexLog) String() string { return proto.CompactTextString(m) }
func (*VertexLog) ProtoMessage()    {}
func (*VertexLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{12}
}
func (m *VertexLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VertexLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VertexLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VertexLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VertexLog.Merge(m, src)
}
func (m *VertexLog) XXX_Size() int {
	return m.Size()
}
func (m *VertexLog) XXX_DiscardUnknown() {
	xxx_messageInfo_VertexLog.DiscardUnknown(m)
}

var xxx_messageInfo_VertexLog proto.InternalMessageInfo

func (m *VertexLog) GetTimestamp() time.Time {
	if m != nil {
		return m.Timestamp
	}
	return time.Time{}
}

func (m *VertexLog) GetStream() int64 {
	if m != nil {
		return m.Stream
	}
	return 0
}

func (m *VertexLog) GetMsg() []byte {
	if m != nil {
		return m.Msg
	}
	return nil
}

type VertexWarning struct {
	Vertex               github_com_opencontainers_go_digest.Digest `protobuf:"bytes,1,opt,name=vertex,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"vertex"`
	Level                int64                                      `protobuf:"varint,2,opt,name=level,proto3" json:"level,omitempty"`
	Short                []byte                                     `protobuf:"bytes,3,opt,name=short,proto3" json:"short,omitempty"`
	Detail               [][]byte                                   `protobuf:"bytes,4,rep,name=detail,proto3" json:"detail,omitempty"`
	Url                  string                                     `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
	Info                 *pb.SourceInfo                             `protobuf:"bytes,6,opt,name=info,proto3" json:"info,omitempty"`
	Ranges               []*pb.Range                                `protobuf:"bytes,7,rep,name=ranges,proto3" json:"ranges,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *VertexWarning) Reset()         { *m = VertexWarning{} }
func (m *VertexWarning) String() string { return proto.CompactTextString(m) }
func (*VertexWarning) ProtoMessage()    {}
func (*VertexWarning) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{13}
}
func (m *VertexWarning) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VertexWarning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VertexWarning.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VertexWarning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VertexWarning.Merge(m, src)
}
func (m *VertexWarning) XXX_Size() int {
	return m.Size()
}
func (m *VertexWarning) XXX_DiscardUnknown() {
	xxx_messageInfo_VertexWarning.DiscardUnknown(m)
}

var xxx_messageInfo_VertexWarning proto.InternalMessageInfo

func (m *VertexWarning) GetLevel() int64 {
	if m != nil {
		return m.Level
	}
	return 0
}

func (m *VertexWarning) GetShort() []byte {
	if m != nil {
		return m.Short
	}
	return nil
}

func (m *VertexWarning) GetDetail() [][]byte {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (m *VertexWarning) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *VertexWarning) GetInfo() *pb.SourceInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *VertexWarning) GetRanges() []*pb.Range {
	if m != nil {
		return m.Ranges
	}
	return nil
}

type BytesMessage struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BytesMessage) Reset()         { *m = BytesMessage{} }
func (m *BytesMessage) String() string { return proto.CompactTextString(m) }
func (*BytesMessage) ProtoMessage()    {}
func (*BytesMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{14}
}
func (m *BytesMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BytesMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BytesMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BytesMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BytesMessage.Merge(m, src)
}
func (m *BytesMessage) XXX_Size() int {
	return m.Size()
}
func (m *BytesMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_BytesMessage.DiscardUnknown(m)
}

var xxx_messageInfo_BytesMessage proto.InternalMessageInfo

func (m *BytesMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ListWorkersRequest struct {
	Filter               []string `protobuf:"bytes,1,rep,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkersRequest) Reset()         { *m = ListWorkersRequest{} }
func (m *ListWorkersRequest) String() string { return proto.CompactTextString(m) }
func (*ListWorkersRequest) ProtoMessage()    {}
func (*ListWorkersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{15}
}
func (m *ListWorkersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListWorkersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListWorkersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListWorkersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkersRequest.Merge(m, src)
}
func (m *ListWorkersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListWorkersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkersRequest proto.InternalMessageInfo

func (m *ListWorkersRequest) GetFilter() []string {
	if m != nil {
		return m.Filter
	}
	return nil
}

type ListWorkersResponse struct {
	Record               []*types.WorkerRecord `protobuf:"bytes,1,rep,name=record,proto3" json:"record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListWorkersResponse) Reset()         { *m = ListWorkersResponse{} }
func (m *ListWorkersResponse) String() string { return proto.CompactTextString(m) }
func (*ListWorkersResponse) ProtoMessage()    {}
func (*ListWorkersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{16}
}
func (m *ListWorkersResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListWorkersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListWorkersResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListWorkersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkersResponse.Merge(m, src)
}
func (m *ListWorkersResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListWorkersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkersResponse proto.InternalMessageInfo

func (m *ListWorkersResponse) GetRecord() []*types.WorkerRecord {
	if m != nil {
		return m.Record
	}
	return nil
}

type InfoRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InfoRequest) Reset()         { *m = InfoRequest{} }
func (m *InfoRequest) String() string { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()    {}
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{17}
}
func (m *InfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoRequest.Merge(m, src)
}
func (m *InfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *InfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InfoRequest proto.InternalMessageInfo

type InfoResponse struct {
	BuildkitVersion      *types.BuildkitVersion `protobuf:"bytes,1,opt,name=buildkitVersion,proto3" json:"buildkitVersion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *InfoResponse) Reset()         { *m = InfoResponse{} }
func (m *InfoResponse) String() string { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()    {}
func (*InfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{18}
}
func (m *InfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoResponse.Merge(m, src)
}
func (m *InfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *InfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InfoResponse proto.InternalMessageInfo

func (m *InfoResponse) GetBuildkitVersion() *types.BuildkitVersion {
	if m != nil {
		return m.BuildkitVersion
	}
	return nil
}

type BuildHistoryRequest struct {
	ActiveOnly           bool     `protobuf:"varint,1,opt,name=ActiveOnly,proto3" json:"ActiveOnly,omitempty"`
	Ref                  string   `protobuf:"bytes,2,opt,name=Ref,proto3" json:"Ref,omitempty"`
	EarlyExit            bool     `protobuf:"varint,3,opt,name=EarlyExit,proto3" json:"EarlyExit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildHistoryRequest) Reset()         { *m = BuildHistoryRequest{} }
func (m *BuildHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*BuildHistoryRequest) ProtoMessage()    {}
func (*BuildHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{19}
}
func (m *BuildHistoryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildHistoryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildHistoryRequest.Merge(m, src)
}
func (m *BuildHistoryRequest) XXX_Size() int {
	return m.Size()
}
func (m *BuildHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BuildHistoryRequest proto.InternalMessageInfo

func (m *BuildHistoryRequest) GetActiveOnly() bool {
	if m != nil {
		return m.ActiveOnly
	}
	return false
}

func (m *BuildHistoryRequest) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *BuildHistoryRequest) GetEarlyExit() bool {
	if m != nil {
		return m.EarlyExit
	}
	return false
}

type BuildHistoryEvent struct {
	Type                 BuildHistoryEventType `protobuf:"varint,1,opt,name=type,proto3,enum=moby.buildkit.v1.BuildHistoryEventType" json:"type,omitempty"`
	Record               *BuildHistoryRecord   `protobuf:"bytes,2,opt,name=record,proto3" json:"record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BuildHistoryEvent) Reset()         { *m = BuildHistoryEvent{} }
func (m *BuildHistoryEvent) String() string { return proto.CompactTextString(m) }
func (*BuildHistoryEvent) ProtoMessage()    {}
func (*BuildHistoryEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{20}
}
func (m *BuildHistoryEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildHistoryEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildHistoryEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildHistoryEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildHistoryEvent.Merge(m, src)
}
func (m *BuildHistoryEvent) XXX_Size() int {
	return m.Size()
}
func (m *BuildHistoryEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildHistoryEvent.DiscardUnknown(m)
}

var xxx_messageInfo_BuildHistoryEvent proto.InternalMessageInfo

func (m *BuildHistoryEvent) GetType() BuildHistoryEventType {
	if m != nil {
		return m.Type
	}
	return BuildHistoryEventType_STARTED
}

func (m *BuildHistoryEvent) GetRecord() *BuildHistoryRecord {
	if m != nil {
		return m.Record
	}
	return nil
}

type BuildHistoryRecord struct {
	Ref                  string                      `protobuf:"bytes,1,opt,name=Ref,proto3" json:"Ref,omitempty"`
	Frontend             string                      `protobuf:"bytes,2,opt,name=Frontend,proto3" json:"Frontend,omitempty"`
	FrontendAttrs        map[string]string           `protobuf:"bytes,3,rep,name=FrontendAttrs,proto3" json:"FrontendAttrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Exporters            []*Exporter                 `protobuf:"bytes,4,rep,name=Exporters,proto3" json:"Exporters,omitempty"`
	Error                *rpc.Status                 `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	CreatedAt            *time.Time                  `protobuf:"bytes,6,opt,name=CreatedAt,proto3,stdtime" json:"CreatedAt,omitempty"`
	CompletedAt          *time.Time                  `protobuf:"bytes,7,opt,name=CompletedAt,proto3,stdtime" json:"CompletedAt,omitempty"`
	Logs                 *Descriptor                 `protobuf:"bytes,8,opt,name=logs,proto3" json:"logs,omitempty"`
	ExporterResponse     map[string]string           `protobuf:"bytes,9,rep,name=ExporterResponse,proto3" json:"ExporterResponse,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Result               *BuildResultInfo            `protobuf:"bytes,10,opt,name=Result,proto3" json:"Result,omitempty"`
	Results              map[string]*BuildResultInfo `protobuf:"bytes,11,rep,name=Results,proto3" json:"Results,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Generation           int32                       `protobuf:"varint,12,opt,name=Generation,proto3" json:"Generation,omitempty"`
	Trace                *Descriptor                 `protobuf:"bytes,13,opt,name=trace,proto3" json:"trace,omitempty"`
	Pinned               bool                        `protobuf:"varint,14,opt,name=pinned,proto3" json:"pinned,omitempty"`
	NumCachedSteps       int32                       `protobuf:"varint,15,opt,name=numCachedSteps,proto3" json:"numCachedSteps,omitempty"`
	NumTotalSteps        int32                       `protobuf:"varint,16,opt,name=numTotalSteps,proto3" json:"numTotalSteps,omitempty"`
	NumCompletedSteps    int32                       `protobuf:"varint,17,opt,name=numCompletedSteps,proto3" json:"numCompletedSteps,omitempty"`
	ExternalError        *Descriptor                 `protobuf:"bytes,18,opt,name=externalError,proto3" json:"externalError,omitempty"`
	NumWarnings          int32                       `protobuf:"varint,19,opt,name=numWarnings,proto3" json:"numWarnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *BuildHistoryRecord) Reset()         { *m = BuildHistoryRecord{} }
func (m *BuildHistoryRecord) String() string { return proto.CompactTextString(m) }
func (*BuildHistoryRecord) ProtoMessage()    {}
func (*BuildHistoryRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{21}
}
func (m *BuildHistoryRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildHistoryRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildHistoryRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildHistoryRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildHistoryRecord.Merge(m, src)
}
func (m *BuildHistoryRecord) XXX_Size() int {
	return m.Size()
}
func (m *BuildHistoryRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildHistoryRecord.DiscardUnknown(m)
}

var xxx_messageInfo_BuildHistoryRecord proto.InternalMessageInfo

func (m *BuildHistoryRecord) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *BuildHistoryRecord) GetFrontend() string {
	if m != nil {
		return m.Frontend
	}
	return ""
}

func (m *BuildHistoryRecord) GetFrontendAttrs() map[string]string {
	if m != nil {
		return m.FrontendAttrs
	}
	return nil
}

func (m *BuildHistoryRecord) GetExporters() []*Exporter {
	if m != nil {
		return m.Exporters
	}
	return nil
}

func (m *BuildHistoryRecord) GetError() *rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BuildHistoryRecord) GetCreatedAt() *time.Time {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *BuildHistoryRecord) GetCompletedAt() *time.Time {
	if m != nil {
		return m.CompletedAt
	}
	return nil
}

func (m *BuildHistoryRecord) GetLogs() *Descriptor {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *BuildHistoryRecord) GetExporterResponse() map[string]string {
	if m != nil {
		return m.ExporterResponse
	}
	return nil
}

func (m *BuildHistoryRecord) GetResult() *BuildResultInfo {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BuildHistoryRecord) GetResults() map[string]*BuildResultInfo {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *BuildHistoryRecord) GetGeneration() int32 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *BuildHistoryRecord) GetTrace() *Descriptor {
	if m != nil {
		return m.Trace
	}
	return nil
}

func (m *BuildHistoryRecord) GetPinned() bool {
	if m != nil {
		return m.Pinned
	}
	return false
}

func (m *BuildHistoryRecord) GetNumCachedSteps() int32 {
	if m != nil {
		return m.NumCachedSteps
	}
	return 0
}

func (m *BuildHistoryRecord) GetNumTotalSteps() int32 {
	if m != nil {
		return m.NumTotalSteps
	}
	return 0
}

func (m *BuildHistoryRecord) GetNumCompletedSteps() int32 {
	if m != nil {
		return m.NumCompletedSteps
	}
	return 0
}

func (m *BuildHistoryRecord) GetExternalError() *Descriptor {
	if m != nil {
		return m.ExternalError
	}
	return nil
}

func (m *BuildHistoryRecord) GetNumWarnings() int32 {
	if m != nil {
		return m.NumWarnings
	}
	return 0
}

type UpdateBuildHistoryRequest struct {
	Ref                  string   `protobuf:"bytes,1,opt,name=Ref,proto3" json:"Ref,omitempty"`
	Pinned               bool     `protobuf:"varint,2,opt,name=Pinned,proto3" json:"Pinned,omitempty"`
	Delete               bool     `protobuf:"varint,3,opt,name=Delete,proto3" json:"Delete,omitempty"`
	Finalize             bool     `protobuf:"varint,4,opt,name=Finalize,proto3" json:"Finalize,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateBuildHistoryRequest) Reset()         { *m = UpdateBuildHistoryRequest{} }
func (m *UpdateBuildHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBuildHistoryRequest) ProtoMessage()    {}
func (*UpdateBuildHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{22}
}
func (m *UpdateBuildHistoryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateBuildHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateBuildHistoryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateBuildHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBuildHistoryRequest.Merge(m, src)
}
func (m *UpdateBuildHistoryRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateBuildHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBuildHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBuildHistoryRequest proto.InternalMessageInfo

func (m *UpdateBuildHistoryRequest) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *UpdateBuildHistoryRequest) GetPinned() bool {
	if m != nil {
		return m.Pinned
	}
	return false
}

func (m *UpdateBuildHistoryRequest) GetDelete() bool {
	if m != nil {
		return m.Delete
	}
	return false
}

func (m *UpdateBuildHistoryRequest) GetFinalize() bool {
	if m != nil {
		return m.Finalize
	}
	return false
}

type UpdateBuildHistoryResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateBuildHistoryResponse) Reset()         { *m = UpdateBuildHistoryResponse{} }
func (m *UpdateBuildHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateBuildHistoryResponse) ProtoMessage()    {}
func (*UpdateBuildHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{23}
}
func (m *UpdateBuildHistoryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateBuildHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateBuildHistoryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateBuildHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBuildHistoryResponse.Merge(m, src)
}
func (m *UpdateBuildHistoryResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateBuildHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBuildHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBuildHistoryResponse proto.InternalMessageInfo

type Descriptor struct {
	MediaType            string                                     `protobuf:"bytes,1,opt,name=media_type,json=mediaType,proto3" json:"media_type,omitempty"`
	Digest               github_com_opencontainers_go_digest.Digest `protobuf:"bytes,2,opt,name=digest,proto3,customtype=github.com/opencontainers/go-digest.Digest" json:"digest"`
	Size_                int64                                      `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	Annotations          map[string]string                          `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *Descriptor) Reset()         { *m = Descriptor{} }
func (m *Descriptor) String() string { return proto.CompactTextString(m) }
func (*Descriptor) ProtoMessage()    {}
func (*Descriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{24}
}
func (m *Descriptor) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Descriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Descriptor.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Descriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Descriptor.Merge(m, src)
}
func (m *Descriptor) XXX_Size() int {
	return m.Size()
}
func (m *Descriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_Descriptor.DiscardUnknown(m)
}

var xxx_messageInfo_Descriptor proto.InternalMessageInfo

func (m *Descriptor) GetMediaType() string {
	if m != nil {
		return m.MediaType
	}
	return ""
}

func (m *Descriptor) GetSize_() int64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *Descriptor) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type BuildResultInfo struct {
	ResultDeprecated     *Descriptor           `protobuf:"bytes,1,opt,name=ResultDeprecated,proto3" json:"ResultDeprecated,omitempty"`
	Attestations         []*Descriptor         `protobuf:"bytes,2,rep,name=Attestations,proto3" json:"Attestations,omitempty"`
	Results              map[int64]*Descriptor `protobuf:"bytes,3,rep,name=Results,proto3" json:"Results,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BuildResultInfo) Reset()         { *m = BuildResultInfo{} }
func (m *BuildResultInfo) String() string { return proto.CompactTextString(m) }
func (*BuildResultInfo) ProtoMessage()    {}
func (*BuildResultInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{25}
}
func (m *BuildResultInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildResultInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildResultInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildResultInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildResultInfo.Merge(m, src)
}
func (m *BuildResultInfo) XXX_Size() int {
	return m.Size()
}
func (m *BuildResultInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildResultInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BuildResultInfo proto.InternalMessageInfo

func (m *BuildResultInfo) GetResultDeprecated() *Descriptor {
	if m != nil {
		return m.ResultDeprecated
	}
	return nil
}

func (m *BuildResultInfo) GetAttestations() []*Descriptor {
	if m != nil {
		return m.Attestations
	}
	return nil
}

func (m *BuildResultInfo) GetResults() map[int64]*Descriptor {
	if m != nil {
		return m.Results
	}
	return nil
}

// Exporter describes the output exporter
type Exporter struct {
	// Type identifies the exporter
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty"`
	// Attrs specifies exporter configuration
	Attrs                map[string]string `protobuf:"bytes,2,rep,name=Attrs,proto3" json:"Attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Exporter) Reset()         { *m = Exporter{} }
func (m *Exporter) String() string { return proto.CompactTextString(m) }
func (*Exporter) ProtoMessage()    {}
func (*Exporter) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c5120591600887d, []int{26}
}
func (m *Exporter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Exporter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Exporter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Exporter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Exporter.Merge(m, src)
}
func (m *Exporter) XXX_Size() int {
	return m.Size()
}
func (m *Exporter) XXX_DiscardUnknown() {
	xxx_messageInfo_Exporter.DiscardUnknown(m)
}

var xxx_messageInfo_Exporter proto.InternalMessageInfo

func (m *Exporter) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Exporter) GetAttrs() map[string]string {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func init() {
	proto.RegisterEnum("moby.buildkit.v1.BuildHistoryEventType", BuildHistoryEventType_name, BuildHistoryEventType_value)
	proto.RegisterType((*PruneRequest)(nil), "moby.buildkit.v1.PruneRequest")
	proto.RegisterType((*DiskUsageRequest)(nil), "moby.buildkit.v1.DiskUsageRequest")
	proto.RegisterType((*DiskUsageResponse)(nil), "moby.buildkit.v1.DiskUsageResponse")
	proto.RegisterType((*UsageRecord)(nil), "moby.buildkit.v1.UsageRecord")
	proto.RegisterType((*SolveRequest)(nil), "moby.buildkit.v1.SolveRequest")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.SolveRequest.ExporterAttrsDeprecatedEntry")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.SolveRequest.FrontendAttrsEntry")
	proto.RegisterMapType((map[string]*pb.Definition)(nil), "moby.buildkit.v1.SolveRequest.FrontendInputsEntry")
	proto.RegisterType((*CacheOptions)(nil), "moby.buildkit.v1.CacheOptions")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.CacheOptions.ExportAttrsDeprecatedEntry")
	proto.RegisterType((*CacheOptionsEntry)(nil), "moby.buildkit.v1.CacheOptionsEntry")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.CacheOptionsEntry.AttrsEntry")
	proto.RegisterType((*SolveResponse)(nil), "moby.buildkit.v1.SolveResponse")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.SolveResponse.ExporterResponseEntry")
	proto.RegisterType((*StatusRequest)(nil), "moby.buildkit.v1.StatusRequest")
	proto.RegisterType((*StatusResponse)(nil), "moby.buildkit.v1.StatusResponse")
	proto.RegisterType((*Vertex)(nil), "moby.buildkit.v1.Vertex")
	proto.RegisterType((*VertexStatus)(nil), "moby.buildkit.v1.VertexStatus")
	proto.RegisterType((*VertexLog)(nil), "moby.buildkit.v1.VertexLog")
	proto.RegisterType((*VertexWarning)(nil), "moby.buildkit.v1.VertexWarning")
	proto.RegisterType((*BytesMessage)(nil), "moby.buildkit.v1.BytesMessage")
	proto.RegisterType((*ListWorkersRequest)(nil), "moby.buildkit.v1.ListWorkersRequest")
	proto.RegisterType((*ListWorkersResponse)(nil), "moby.buildkit.v1.ListWorkersResponse")
	proto.RegisterType((*InfoRequest)(nil), "moby.buildkit.v1.InfoRequest")
	proto.RegisterType((*InfoResponse)(nil), "moby.buildkit.v1.InfoResponse")
	proto.RegisterType((*BuildHistoryRequest)(nil), "moby.buildkit.v1.BuildHistoryRequest")
	proto.RegisterType((*BuildHistoryEvent)(nil), "moby.buildkit.v1.BuildHistoryEvent")
	proto.RegisterType((*BuildHistoryRecord)(nil), "moby.buildkit.v1.BuildHistoryRecord")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.BuildHistoryRecord.ExporterResponseEntry")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.BuildHistoryRecord.FrontendAttrsEntry")
	proto.RegisterMapType((map[string]*BuildResultInfo)(nil), "moby.buildkit.v1.BuildHistoryRecord.ResultsEntry")
	proto.RegisterType((*UpdateBuildHistoryRequest)(nil), "moby.buildkit.v1.UpdateBuildHistoryRequest")
	proto.RegisterType((*UpdateBuildHistoryResponse)(nil), "moby.buildkit.v1.UpdateBuildHistoryResponse")
	proto.RegisterType((*Descriptor)(nil), "moby.buildkit.v1.Descriptor")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.Descriptor.AnnotationsEntry")
	proto.RegisterType((*BuildResultInfo)(nil), "moby.buildkit.v1.BuildResultInfo")
	proto.RegisterMapType((map[int64]*Descriptor)(nil), "moby.buildkit.v1.BuildResultInfo.ResultsEntry")
	proto.RegisterType((*Exporter)(nil), "moby.buildkit.v1.Exporter")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.Exporter.AttrsEntry")
}

func init() { proto.RegisterFile("control.proto", fileDescriptor_0c5120591600887d) }

var fileDescriptor_0c5120591600887d = []byte{
	// 2406 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0x4f, 0x6f, 0x1b, 0xc7,
	0x15, 0xcf, 0x52, 0x14, 0x45, 0x3e, 0x92, 0x32, 0x35, 0x76, 0xdc, 0xed, 0xd6, 0x91, 0xe4, 0x8d,
	0x9d, 0x0a, 0xae, 0xbd, 0x54, 0xd8, 0x06, 0x76, 0xec, 0xd6, 0xb5, 0x28, 0x32, 0x91, 0x5c, 0x1b,
	0x56, 0x46, 0x72, 0x5c, 0x04, 0x08, 0x8a, 0x15, 0x39, 0xa2, 0x17, 0x5a, 0xee, 0x6e, 0x67, 0x87,
	0x8a, 0xd9, 0x6f, 0xd0, 0x1e, 0x8a, 0xa2, 0x40, 0xd1, 0x4b, 0xef, 0x3d, 0xf5, 0xdc, 0x73, 0x0f,
	0x05, 0x7c, 0xec, 0x39, 0x07, 0xa7, 0xf0, 0x07, 0x28, 0x7a, 0xec, 0xb1, 0x98, 0x3f, 0x4b, 0x0e,
	0xb9, 0x4b, 0x89, 0xb2, 0x7d, 0xda, 0x79, 0x33, 0xbf, 0xf7, 0xe6, 0xcd, 0x9b, 0x37, 0x6f, 0xde,
	0x9b, 0x85, 0x6a, 0x27, 0x0c, 0x18, 0x0d, 0x7d, 0x27, 0xa2, 0x21, 0x0b, 0x51, 0xad, 0x1f, 0x1e,
	0x0e, 0x9d, 0xc3, 0x81, 0xe7, 0x77, 0x8f, 0x3d, 0xe6, 0x9c, 0x7c, 0x6c, 0x35, 0x7a, 0x1e, 0x7b,
	0x3e, 0x38, 0x74, 0x3a, 0x61, 0xbf, 0xde, 0x0b, 0x7b, 0x61, 0xbd, 0x17, 0x86, 0x3d, 0x9f, 0xb8,
	0x91, 0x17, 0xab, 0x66, 0x9d, 0x46, 0x9d, 0x7a, 0xcc, 0x5c, 0x36, 0x88, 0xa5, 0x14, 0xeb, 0xd6,
	0x34, 0x8f, 0xe8, 0x3e, 0x1c, 0x1c, 0x09, 0x4a, 0x10, 0xa2, 0xa5, 0xe0, 0x1b, 0x5e, 0xc0, 0x08,
	0x0d, 0x5c, 0xbf, 0x9e, 0x4c, 0x5c, 0x77, 0x23, 0xaf, 0xce, 0x86, 0x11, 0x89, 0xeb, 0xdf, 0x84,
	0xf4, 0x98, 0x50, 0x85, 0xbc, 0x9e, 0x46, 0xc6, 0xa1, 0x7f, 0x42, 0x68, 0x3d, 0x3a, 0xac, 0x87,
	0x51, 0x32, 0xbf, 0x93, 0x05, 0x1b, 0xd0, 0x0e, 0x89, 0x42, 0xdf, 0xeb, 0x0c, 0x39, 0x58, 0xb6,
	0x14, 0x7e, 0x4d, 0x2d, 0x64, 0xa4, 0x26, 0xf3, 0xfa, 0x24, 0x66, 0x6e, 0x3f, 0x92, 0x00, 0xfb,
	0x77, 0x39, 0xa8, 0xec, 0xd1, 0x41, 0x40, 0x30, 0xf9, 0xf5, 0x80, 0xc4, 0x0c, 0x5d, 0x86, 0xc2,
	0x91, 0xe7, 0x33, 0x42, 0x4d, 0x63, 0x7d, 0x61, 0xa3, 0x84, 0x15, 0x85, 0x6a, 0xb0, 0xe0, 0xfa,
	0xbe, 0x99, 0x5b, 0x37, 0x36, 0x8a, 0x98, 0x37, 0xd1, 0x06, 0x54, 0x8e, 0x09, 0x89, 0x5a, 0x03,
	0xea, 0x32, 0x2f, 0x0c, 0xcc, 0x85, 0x75, 0x63, 0x63, 0xa1, 0x99, 0x7f, 0xf9, 0x6a, 0xcd, 0xc0,
	0x13, 0x23, 0xe8, 0x06, 0x54, 0x29, 0x89, 0x09, 0x3d, 0x21, 0xdd, 0xfd, 0xc8, 0xed, 0x10, 0x33,
	0xaf, 0x41, 0x27, 0x87, 0xd0, 0x47, 0x50, 0x66, 0x2e, 0xed, 0x11, 0x26, 0x91, 0x4b, 0x1a, 0x52,
	0x1f, 0xe0, 0xb3, 0xf7, 0xdd, 0x17, 0x4f, 0xe3, 0x44, 0xe4, 0xa2, 0x3e, 0xbb, 0x3e, 0x22, 0x90,
	0x5e, 0xf0, 0x19, 0x25, 0x44, 0x22, 0x0b, 0x13, 0x48, 0x6d, 0xc4, 0xbe, 0x01, 0xb5, 0x96, 0x17,
	0x1f, 0x3f, 0x8d, 0xdd, 0xde, 0x59, 0xf6, 0xb0, 0x1f, 0xc2, 0x8a, 0x86, 0x8d, 0xa3, 0x30, 0x88,
	0x09, 0xfa, 0x04, 0x0a, 0x94, 0x74, 0x42, 0xda, 0x15, 0xe0, 0x72, 0xe3, 0x03, 0x67, 0xda, 0xeb,
	0x1c, 0xc5, 0xc0, 0x41, 0x58, 0x81, 0xed, 0x3f, 0x2f, 0x40, 0x59, 0xeb, 0x47, 0xcb, 0x90, 0xdb,
	0x6d, 0x99, 0xc6, 0xba, 0xb1, 0x51, 0xc2, 0xb9, 0xdd, 0x16, 0x32, 0x61, 0xe9, 0xf1, 0x80, 0xb9,
	0x87, 0x3e, 0x51, 0xf6, 0x4f, 0x48, 0x74, 0x09, 0x16, 0x77, 0x83, 0xa7, 0x31, 0x11, 0xc6, 0x2f,
	0x62, 0x49, 0x20, 0x04, 0xf9, 0x7d, 0xef, 0x37, 0xca, 0xcc, 0x58, 0xb4, 0x91, 0x05, 0x85, 0x3d,
	0x97, 0x92, 0x80, 0x09, 0x4b, 0x95, 0x9a, 0x39, 0xd3, 0xc0, 0xaa, 0x07, 0x35, 0xa1, 0xb4, 0x4d,
	0x89, 0xcb, 0x48, 0x77, 0x8b, 0x09, 0xf3, 0x94, 0x1b, 0x96, 0x23, 0x3d, 0xc7, 0x49, 0x3c, 0xc7,
	0x39, 0x48, 0x3c, 0xa7, 0x59, 0x7c, 0xf9, 0x6a, 0xed, 0xbd, 0x3f, 0x7c, 0xb7, 0x66, 0xe0, 0x31,
	0x1b, 0x7a, 0x00, 0xf0, 0xc8, 0x8d, 0x19, 0x37, 0xfb, 0x16, 0x13, 0xdb, 0x76, 0xba, 0x90, 0xbc,
	0x10, 0xa0, 0xf1, 0xa0, 0x55, 0x00, 0x61, 0x84, 0xed, 0x70, 0x10, 0x30, 0xb3, 0x28, 0x74, 0xd7,
	0x7a, 0xd0, 0x3a, 0x94, 0x5b, 0x24, 0xee, 0x50, 0x2f, 0x12, 0xee, 0x56, 0x12, 0xe6, 0xd1, 0xbb,
	0xb8, 0x04, 0x69, 0xc1, 0x83, 0x61, 0x44, 0x4c, 0x10, 0x00, 0xad, 0x87, 0xef, 0xe5, 0xfe, 0x73,
	0x97, 0x92, 0xae, 0x59, 0x16, 0xe6, 0x52, 0x14, 0xb7, 0xaf, 0xb4, 0x44, 0x6c, 0x56, 0xc4, 0x26,
	0x27, 0xa4, 0xfd, 0xc7, 0x22, 0x54, 0xf6, 0xf9, 0x39, 0x4c, 0xdc, 0xa1, 0x06, 0x0b, 0x98, 0x1c,
	0xa9, 0xbd, 0xe1, 0x4d, 0xe4, 0x00, 0xb4, 0xc8, 0x91, 0x17, 0x78, 0x42, 0xab, 0x9c, 0x58, 0xf8,
	0xb2, 0x13, 0x1d, 0x3a, 0xe3, 0x5e, 0xac, 0x21, 0x90, 0x03, 0xa8, 0xfd, 0x22, 0x0a, 0x29, 0x23,
	0xb4, 0x45, 0x22, 0x4a, 0x3a, 0xdc, 0x80, 0x62, 0xff, 0x4a, 0x38, 0x63, 0x04, 0x0d, 0xe0, 0x7b,
	0x49, 0xef, 0x16, 0x63, 0x34, 0xd6, 0x98, 0xf2, 0xc2, 0xc9, 0xee, 0xa5, 0x9d, 0x4c, 0x57, 0xd9,
	0x99, 0xc1, 0xdd, 0x0e, 0x18, 0x1d, 0xe2, 0x59, 0xb2, 0xb9, 0x4d, 0xf6, 0x49, 0x1c, 0xf3, 0x35,
	0x09, 0x87, 0xc1, 0x09, 0x89, 0x2c, 0x28, 0x7e, 0x46, 0xc3, 0x80, 0x91, 0xa0, 0x2b, 0x9c, 0xa5,
	0x84, 0x47, 0x34, 0x7a, 0x06, 0xd5, 0xa4, 0x2d, 0x04, 0x9a, 0x4b, 0x42, 0xc5, 0x8f, 0xcf, 0x50,
	0x71, 0x82, 0x47, 0x2a, 0x36, 0x29, 0x07, 0xdd, 0x85, 0xc5, 0x6d, 0xb7, 0xf3, 0x9c, 0x08, 0xbf,
	0x28, 0x37, 0x56, 0xd3, 0x02, 0xc5, 0xf0, 0x13, 0xe1, 0x08, 0xb1, 0x38, 0xdd, 0xef, 0x61, 0xc9,
	0x82, 0x22, 0xa8, 0xb4, 0x03, 0xe6, 0x31, 0x9f, 0xf4, 0xc5, 0x1e, 0x97, 0xf8, 0x1e, 0x37, 0x1f,
	0x7d, 0xfb, 0x6a, 0x6d, 0x47, 0x0b, 0xe7, 0x5d, 0xb7, 0xd7, 0x23, 0x34, 0xf9, 0xa4, 0xe3, 0xec,
	0x80, 0x79, 0x7e, 0x9d, 0x68, 0x72, 0x1c, 0x4d, 0x28, 0x9e, 0x98, 0x01, 0x7d, 0x05, 0xcb, 0x89,
	0xfa, 0xbb, 0x41, 0x34, 0x60, 0xb1, 0x09, 0xc2, 0x0e, 0x8d, 0x39, 0xed, 0x20, 0x99, 0xa4, 0x21,
	0xa6, 0x24, 0x71, 0xf3, 0xef, 0x2a, 0xe5, 0x94, 0x1b, 0x8f, 0x68, 0xb4, 0xcb, 0xbd, 0x95, 0x5f,
	0x07, 0x7b, 0xe2, 0x12, 0x30, 0x2b, 0xc2, 0x58, 0xd7, 0xd3, 0xb3, 0xea, 0x97, 0x86, 0x23, 0xc1,
	0x78, 0x82, 0x15, 0xdd, 0x81, 0x52, 0xe2, 0x1a, 0xb1, 0x59, 0x15, 0xda, 0x5b, 0x69, 0x39, 0x09,
	0x04, 0x8f, 0xc1, 0xd6, 0x43, 0xb8, 0x72, 0x9a, 0xcb, 0xf1, 0x23, 0x74, 0x4c, 0x86, 0xc9, 0x11,
	0x3a, 0x26, 0x43, 0x1e, 0xc5, 0x4e, 0x5c, 0x7f, 0x20, 0xa3, 0x5b, 0x09, 0x4b, 0xe2, 0x6e, 0xee,
	0x8e, 0x61, 0x3d, 0x00, 0x94, 0xf6, 0x8d, 0x73, 0x49, 0xf8, 0x02, 0x2e, 0x66, 0x58, 0x35, 0x43,
	0xc4, 0x35, 0x5d, 0x44, 0xfa, 0x08, 0x8f, 0x45, 0xda, 0x7f, 0x5b, 0x80, 0x8a, 0xee, 0x6d, 0x68,
	0x13, 0x2e, 0xca, 0x15, 0x63, 0x72, 0xa4, 0x1d, 0x4f, 0x29, 0x3c, 0x6b, 0x08, 0x35, 0xe0, 0xd2,
	0x6e, 0x5f, 0x75, 0xeb, 0x27, 0x3a, 0x27, 0xc2, 0x4f, 0xe6, 0x18, 0x0a, 0xe1, 0x7d, 0x29, 0x6a,
	0x3a, 0x0c, 0x2c, 0x88, 0xdd, 0xf9, 0xf4, 0xf4, 0x23, 0xe1, 0x64, 0xf2, 0x4a, 0x17, 0xcb, 0x96,
	0x8b, 0x7e, 0x06, 0x4b, 0x72, 0x20, 0x56, 0x91, 0xe6, 0xc3, 0xd3, 0xa7, 0x90, 0xc2, 0x12, 0x1e,
	0xce, 0x2e, 0xd7, 0x11, 0x9b, 0x8b, 0xe7, 0x60, 0x57, 0x3c, 0xd6, 0x0e, 0x58, 0xb3, 0x55, 0x3e,
	0x8f, 0x0b, 0xd8, 0x7f, 0x35, 0x60, 0x25, 0x35, 0x11, 0xbf, 0x24, 0xc5, 0x35, 0x21, 0x45, 0x88,
	0x36, 0x6a, 0xc1, 0xa2, 0x0c, 0x5b, 0x39, 0xa1, 0xb0, 0x33, 0x87, 0xc2, 0x8e, 0x16, 0xb3, 0x24,
	0xb3, 0x75, 0x07, 0xe0, 0xcd, 0x9c, 0xd5, 0xfe, 0xbb, 0x01, 0x55, 0x15, 0x10, 0x54, 0x46, 0xe1,
	0x42, 0x6d, 0x74, 0xc6, 0x54, 0x9f, 0xca, 0x2d, 0x3e, 0x99, 0x19, 0x4b, 0x24, 0xcc, 0x99, 0xe6,
	0x93, 0x3a, 0xa6, 0xc4, 0x59, 0xdb, 0x89, 0x5f, 0x4d, 0x41, 0xcf, 0xa5, 0xf9, 0x55, 0xa8, 0xee,
	0x8b, 0x44, 0x79, 0xe6, 0x45, 0x69, 0xff, 0xd7, 0x80, 0xe5, 0x04, 0xa3, 0x56, 0xf7, 0x13, 0x28,
	0x9e, 0x10, 0xca, 0xc8, 0x0b, 0x12, 0xab, 0x55, 0x99, 0xe9, 0x55, 0x7d, 0x29, 0x10, 0x78, 0x84,
	0x44, 0x77, 0xa1, 0x28, 0x93, 0x72, 0x92, 0x6c, 0xd4, 0xea, 0x2c, 0x2e, 0x35, 0xdf, 0x08, 0x8f,
	0xea, 0x90, 0xf7, 0xc3, 0x5e, 0xac, 0xce, 0xcc, 0x0f, 0x66, 0xf1, 0x3d, 0x0a, 0x7b, 0x58, 0x00,
	0xd1, 0x3d, 0x28, 0x7e, 0xe3, 0xd2, 0xc0, 0x0b, 0x7a, 0xc9, 0x29, 0x58, 0x9b, 0xc5, 0xf4, 0x4c,
	0xe2, 0xf0, 0x88, 0x81, 0x27, 0x76, 0x05, 0x39, 0x86, 0x1e, 0x42, 0xa1, 0xeb, 0xf5, 0x48, 0xcc,
	0xa4, 0x49, 0x9a, 0x0d, 0x7e, 0x43, 0x7d, 0xfb, 0x6a, 0xed, 0x86, 0x76, 0x05, 0x85, 0x11, 0x09,
	0x78, 0xd5, 0xe2, 0x7a, 0x01, 0xa1, 0xbc, 0x08, 0xb9, 0x25, 0x59, 0x9c, 0x96, 0xf8, 0x60, 0x25,
	0x81, 0xcb, 0xf2, 0xe4, 0xb5, 0x22, 0xe2, 0xc5, 0x9b, 0xc9, 0x92, 0x12, 0xf8, 0x31, 0x08, 0xdc,
	0x3e, 0x51, 0x09, 0x88, 0x68, 0xf3, 0x3c, 0xa9, 0xc3, 0xfd, 0xbc, 0x2b, 0x32, 0xc8, 0x22, 0x56,
	0x14, 0xba, 0x0b, 0x4b, 0x31, 0x73, 0x29, 0x8f, 0x39, 0x8b, 0x73, 0x26, 0x78, 0x09, 0x03, 0xba,
	0x0f, 0xa5, 0x4e, 0xd8, 0x8f, 0x7c, 0xc2, 0xb9, 0x0b, 0x73, 0x72, 0x8f, 0x59, 0xb8, 0xeb, 0x11,
	0x4a, 0x43, 0x2a, 0x52, 0xcb, 0x12, 0x96, 0x04, 0xba, 0x0d, 0xd5, 0x88, 0x86, 0x3d, 0x4a, 0xe2,
	0xf8, 0x73, 0x1a, 0x0e, 0x22, 0x95, 0x1e, 0xac, 0xf0, 0xe0, 0xbd, 0xa7, 0x0f, 0xe0, 0x49, 0x9c,
	0xfd, 0x9f, 0x1c, 0x54, 0x74, 0x17, 0x49, 0xe5, 0xdc, 0x0f, 0xa1, 0x20, 0x1d, 0x4e, 0xfa, 0xfa,
	0x9b, 0xd9, 0x58, 0x4a, 0xc8, 0xb4, 0xb1, 0x09, 0x4b, 0x9d, 0x01, 0x15, 0x09, 0xb9, 0x4c, 0xd3,
	0x13, 0x92, 0xaf, 0x94, 0x85, 0xcc, 0xf5, 0x65, 0x49, 0x83, 0x25, 0xc1, 0x73, 0xf4, 0x51, 0xed,
	0x76, 0xbe, 0x1c, 0x7d, 0xc4, 0xa6, 0xef, 0xdf, 0xd2, 0x5b, 0xed, 0x5f, 0xf1, 0xdc, 0xfb, 0x67,
	0xff, 0xd3, 0x80, 0xd2, 0xe8, 0x6c, 0x69, 0xd6, 0x35, 0xde, 0xda, 0xba, 0x13, 0x96, 0xc9, 0xbd,
	0x99, 0x65, 0x2e, 0x43, 0x21, 0x66, 0x94, 0xb8, 0x7d, 0x59, 0xc5, 0x62, 0x45, 0xf1, 0x28, 0xd6,
	0x8f, 0x7b, 0x62, 0x87, 0x2a, 0x98, 0x37, 0xed, 0xff, 0x19, 0x50, 0x9d, 0x38, 0xee, 0xef, 0x74,
	0x2d, 0x97, 0x60, 0xd1, 0x27, 0x27, 0x44, 0xd6, 0xd9, 0x0b, 0x58, 0x12, 0xbc, 0x37, 0x7e, 0x1e,
	0x52, 0x26, 0x94, 0xab, 0x60, 0x49, 0x70, 0x9d, 0xbb, 0x84, 0xb9, 0x9e, 0x2f, 0xe2, 0x52, 0x05,
	0x2b, 0x8a, 0xeb, 0x3c, 0xa0, 0xbe, 0xca, 0xda, 0x79, 0x13, 0xd9, 0x90, 0xf7, 0x82, 0xa3, 0x50,
	0xb9, 0x8d, 0xc8, 0x6c, 0x64, 0xae, 0xb7, 0x1b, 0x1c, 0x85, 0x58, 0x8c, 0xa1, 0xab, 0x50, 0xa0,
	0x6e, 0xd0, 0x23, 0x49, 0xca, 0x5e, 0xe2, 0x28, 0xcc, 0x7b, 0xb0, 0x1a, 0xb0, 0x6d, 0xa8, 0x34,
	0x87, 0x8c, 0xc4, 0x8f, 0x49, 0xcc, 0xab, 0x32, 0xee, 0xd6, 0x5d, 0x97, 0xb9, 0x62, 0xd9, 0x15,
	0x2c, 0xda, 0xf6, 0x4d, 0x40, 0x8f, 0xbc, 0x98, 0x3d, 0x13, 0x6f, 0x1b, 0xf1, 0x59, 0x45, 0xf4,
	0x3e, 0x5c, 0x9c, 0x40, 0xab, 0x6b, 0xe1, 0xa7, 0x53, 0x65, 0xf4, 0xb5, 0x74, 0xc4, 0x15, 0x4f,
	0x28, 0x8e, 0x64, 0x9c, 0xaa, 0xa6, 0xab, 0x50, 0x16, 0xeb, 0x92, 0x73, 0xdb, 0x2e, 0x54, 0x24,
	0xa9, 0x84, 0x7f, 0x01, 0x17, 0x12, 0x41, 0x5f, 0x12, 0x2a, 0x0a, 0x1c, 0x43, 0xd8, 0xe5, 0x87,
	0xb3, 0x66, 0x69, 0x4e, 0xc2, 0xf1, 0x34, 0xbf, 0x4d, 0xe0, 0xa2, 0xc0, 0xec, 0x78, 0x31, 0x0b,
	0xe9, 0x30, 0x59, 0xf5, 0x2a, 0xc0, 0x56, 0x87, 0x79, 0x27, 0xe4, 0x49, 0xe0, 0xcb, 0x6b, 0xb4,
	0x88, 0xb5, 0x9e, 0xe4, 0x8a, 0xcc, 0x8d, 0x6b, 0xc9, 0x2b, 0x50, 0x6a, 0xbb, 0xd4, 0x1f, 0xb6,
	0x5f, 0x78, 0x4c, 0x95, 0xf4, 0xe3, 0x0e, 0xfb, 0xf7, 0x06, 0xac, 0xe8, 0xf3, 0xb4, 0x4f, 0x78,
	0xb8, 0xb8, 0x07, 0x79, 0x96, 0xe4, 0x31, 0xcb, 0x59, 0x8b, 0x48, 0xb1, 0xf0, 0x54, 0x07, 0x0b,
	0x26, 0xcd, 0xd2, 0xf2, 0xe0, 0x5c, 0x3b, 0x9d, 0x7d, 0xca, 0xd2, 0xdf, 0x95, 0x00, 0xa5, 0x87,
	0x33, 0x6a, 0x64, 0xbd, 0x64, 0xcc, 0x4d, 0x95, 0x8c, 0x5f, 0x4f, 0x97, 0x8c, 0xf2, 0x6a, 0xbe,
	0x3d, 0x8f, 0x26, 0x73, 0x14, 0x8e, 0x13, 0x75, 0x4c, 0xfe, 0x1c, 0x75, 0x0c, 0xda, 0x48, 0x6e,
	0x1c, 0x79, 0xd7, 0xa1, 0x24, 0xa6, 0xd0, 0xa8, 0xe3, 0xa8, 0xbc, 0x42, 0xdd, 0x42, 0xf7, 0xcf,
	0xf7, 0x7e, 0x92, 0x9f, 0x7e, 0x3b, 0x69, 0x42, 0x79, 0x3b, 0x09, 0x94, 0xe7, 0x78, 0x3c, 0xd1,
	0x99, 0xd0, 0xa6, 0x4a, 0x6c, 0x64, 0x68, 0xbe, 0x92, 0x5e, 0x62, 0xf2, 0x50, 0x12, 0x52, 0x95,
	0xd9, 0x1c, 0x65, 0xa4, 0x96, 0x25, 0x61, 0xa0, 0xbb, 0x73, 0xd9, 0x7e, 0xce, 0xfc, 0x12, 0x7d,
	0x0a, 0x05, 0x4c, 0xe2, 0x81, 0xcf, 0xc4, 0x8b, 0x4c, 0xb9, 0x71, 0x75, 0x86, 0x74, 0x09, 0x12,
	0x67, 0x55, 0x31, 0xa0, 0x5f, 0xc0, 0x92, 0x6c, 0xc5, 0x66, 0x79, 0xd6, 0x43, 0x42, 0x86, 0x66,
	0x8a, 0x47, 0x15, 0x14, 0x8a, 0xe2, 0xc7, 0xf1, 0x73, 0x12, 0x10, 0xf5, 0x5a, 0xc9, 0x4b, 0xe3,
	0x45, 0xac, 0xf5, 0xa0, 0x06, 0x2c, 0x32, 0xea, 0x76, 0x88, 0x59, 0x9d, 0xc3, 0x84, 0x12, 0xca,
	0x03, 0x5b, 0xe4, 0x05, 0x01, 0xe9, 0x9a, 0xcb, 0x32, 0x53, 0x92, 0x14, 0xfa, 0x08, 0x96, 0x83,
	0x41, 0x5f, 0x14, 0x0b, 0xdd, 0x7d, 0x46, 0xa2, 0xd8, 0xbc, 0x20, 0xe6, 0x9b, 0xea, 0x45, 0xd7,
	0xa0, 0x1a, 0x0c, 0xfa, 0x07, 0xfc, 0x86, 0x97, 0xb0, 0x9a, 0x80, 0x4d, 0x76, 0xa2, 0x9b, 0xb0,
	0xc2, 0xf9, 0x92, 0xdd, 0x96, 0xc8, 0x15, 0x81, 0x4c, 0x0f, 0xa0, 0x26, 0x54, 0xc9, 0x0b, 0xf9,
	0x20, 0xd0, 0x16, 0xfe, 0x8b, 0xe6, 0x58, 0xcf, 0x24, 0x0b, 0x5a, 0x87, 0x72, 0x30, 0xe8, 0x3f,
	0x4b, 0x12, 0xdf, 0x8b, 0x62, 0x2e, 0xbd, 0xeb, 0x1d, 0x54, 0xe6, 0xef, 0xa2, 0xee, 0xb0, 0xbe,
	0x86, 0x8a, 0xbe, 0xdb, 0x19, 0xbc, 0xb7, 0x27, 0xeb, 0xfa, 0x39, 0xbc, 0x4f, 0x2b, 0x6b, 0x86,
	0xf0, 0xfd, 0xa7, 0x51, 0xd7, 0x65, 0x24, 0x2b, 0xbe, 0xa7, 0xe3, 0xdc, 0x65, 0x28, 0xec, 0x49,
	0x77, 0x90, 0xef, 0xb4, 0x8a, 0xe2, 0xfd, 0x2d, 0xc2, 0xb7, 0x48, 0x05, 0x75, 0x45, 0x89, 0xb8,
	0xe8, 0x05, 0xae, 0x9f, 0x3c, 0xd6, 0x16, 0xf1, 0x88, 0xb6, 0xaf, 0x80, 0x95, 0x35, 0xb5, 0x34,
	0x94, 0xfd, 0x97, 0x1c, 0xc0, 0x78, 0xfb, 0xd0, 0x07, 0x00, 0x7d, 0xd2, 0xf5, 0xdc, 0x5f, 0xb1,
	0x71, 0x49, 0x5b, 0x12, 0x3d, 0xa2, 0xae, 0x1d, 0x17, 0x1f, 0xb9, 0xb7, 0x2e, 0x3e, 0x10, 0xe4,
	0x63, 0xae, 0xaf, 0x4c, 0x94, 0x44, 0x1b, 0x3d, 0x81, 0xb2, 0x1b, 0x04, 0x21, 0x13, 0x07, 0x29,
	0x29, 0xf7, 0x6f, 0x9d, 0xe6, 0x70, 0xce, 0xd6, 0x18, 0x2f, 0xcf, 0xa9, 0x2e, 0xc1, 0xba, 0x0f,
	0xb5, 0x69, 0xc0, 0xb9, 0xca, 0xd1, 0x7f, 0xe4, 0xe0, 0xc2, 0xd4, 0xb6, 0xa2, 0x1d, 0xa8, 0x49,
	0x6a, 0xea, 0x89, 0xe6, 0xac, 0xa3, 0x91, 0xe2, 0x42, 0x0f, 0xa0, 0xb2, 0xc5, 0x18, 0x8f, 0xc5,
	0x72, 0xbd, 0xb2, 0x08, 0x3d, 0x5d, 0xca, 0x04, 0x07, 0xda, 0x19, 0x07, 0xb6, 0x85, 0x59, 0x4f,
	0x0d, 0x53, 0xfa, 0x67, 0x47, 0x35, 0xeb, 0x97, 0xb3, 0x0f, 0xc0, 0x82, 0xb4, 0x52, 0x63, 0xf2,
	0x00, 0x9c, 0x11, 0xd7, 0xc6, 0x36, 0xfc, 0x93, 0x01, 0xc5, 0xe4, 0x80, 0x66, 0xbe, 0x96, 0xdc,
	0x9b, 0x7c, 0x2d, 0xb9, 0x3e, 0xfb, 0x5a, 0x7d, 0x97, 0x8f, 0x24, 0x37, 0x7e, 0x0e, 0xef, 0x67,
	0xa6, 0x34, 0xa8, 0x0c, 0x4b, 0xfb, 0x07, 0x5b, 0xf8, 0xa0, 0xdd, 0xaa, 0xbd, 0x87, 0x2a, 0x50,
	0xdc, 0x7e, 0xf2, 0x78, 0xef, 0x51, 0xfb, 0xa0, 0x5d, 0x33, 0xf8, 0x50, 0xab, 0xcd, 0xdb, 0xad,
	0x5a, 0xae, 0xf1, 0xdb, 0x02, 0x2c, 0x6d, 0xcb, 0x9f, 0x83, 0xe8, 0x00, 0x4a, 0xa3, 0xdf, 0x38,
	0xc8, 0xce, 0x30, 0xcd, 0xd4, 0xff, 0x20, 0xeb, 0xc3, 0x53, 0x31, 0xea, 0xca, 0xdb, 0x81, 0x45,
	0xf1, 0x53, 0x0d, 0x65, 0x3c, 0x4c, 0xe8, 0x7f, 0xdb, 0xac, 0xd3, 0x7f, 0x10, 0x6d, 0x1a, 0x5c,
	0x92, 0x78, 0xd5, 0xc9, 0x92, 0xa4, 0x3f, 0x1d, 0x5b, 0x6b, 0x67, 0x3c, 0x07, 0xa1, 0xc7, 0x50,
	0x50, 0xa5, 0x6e, 0x16, 0x54, 0x7f, 0xbb, 0xb1, 0xd6, 0x67, 0x03, 0xa4, 0xb0, 0x4d, 0x03, 0x3d,
	0x1e, 0xfd, 0x1f, 0xc8, 0x52, 0x4d, 0xaf, 0x13, 0xac, 0x33, 0xc6, 0x37, 0x8c, 0x4d, 0x03, 0x7d,
	0x05, 0x65, 0xad, 0x12, 0x40, 0x19, 0x79, 0x68, 0xba, 0xac, 0xb0, 0xae, 0x9f, 0x81, 0x52, 0x2b,
	0x6f, 0x43, 0x5e, 0x04, 0x80, 0x0c, 0x63, 0x6b, 0x85, 0x42, 0x96, 0x9a, 0x13, 0x85, 0xc3, 0xa1,
	0x2c, 0x6d, 0x48, 0xa0, 0x7b, 0x1f, 0xba, 0x7e, 0x56, 0x46, 0x32, 0xd3, 0x6d, 0x52, 0x4e, 0xbc,
	0x69, 0xa0, 0x10, 0x50, 0x3a, 0xe8, 0xa3, 0x1f, 0x65, 0x78, 0xc9, 0xac, 0x5b, 0xc9, 0xba, 0x39,
	0x1f, 0x58, 0x2e, 0xaa, 0x59, 0x79, 0xf9, 0x7a, 0xd5, 0xf8, 0xd7, 0xeb, 0x55, 0xe3, 0xdf, 0xaf,
	0x57, 0x8d, 0xc3, 0x82, 0xc8, 0x35, 0x7f, 0xfc, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x38, 0x84,
	0xcc, 0x6f, 0x3c, 0x1f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ControlClient is the client API for Control service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ControlClient interface {
	DiskUsage(ctx context.Context, in *DiskUsageRequest, opts ...grpc.CallOption) (*DiskUsageResponse, error)
	Prune(ctx context.Context, in *PruneRequest, opts ...grpc.CallOption) (Control_PruneClient, error)
	Solve(ctx context.Context, in *SolveRequest, opts ...grpc.CallOption) (*SolveResponse, error)
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (Control_StatusClient, error)
	Session(ctx context.Context, opts ...grpc.CallOption) (Control_SessionClient, error)
	ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error)
	Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error)
	ListenBuildHistory(ctx context.Context, in *BuildHistoryRequest, opts ...grpc.CallOption) (Control_ListenBuildHistoryClient, error)
	UpdateBuildHistory(ctx context.Context, in *UpdateBuildHistoryRequest, opts ...grpc.CallOption) (*UpdateBuildHistoryResponse, error)
}

type controlClient struct {
	cc *grpc.ClientConn
}

func NewControlClient(cc *grpc.ClientConn) ControlClient {
	return &controlClient{cc}
}

func (c *controlClient) DiskUsage(ctx context.Context, in *DiskUsageRequest, opts ...grpc.CallOption) (*DiskUsageResponse, error) {
	out := new(DiskUsageResponse)
	err := c.cc.Invoke(ctx, "/moby.buildkit.v1.Control/DiskUsage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlClient) Prune(ctx context.Context, in *PruneRequest, opts ...grpc.CallOption) (Control_PruneClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Control_serviceDesc.Streams[0], "/moby.buildkit.v1.Control/Prune", opts...)
	if err != nil {
		return nil, err
	}
	x := &controlPruneClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Control_PruneClient interface {
	Recv() (*UsageRecord, error)
	grpc.ClientStream
}

type controlPruneClient struct {
	grpc.ClientStream
}

func (x *controlPruneClient) Recv() (*UsageRecord, error) {
	m := new(UsageRecord)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *controlClient) Solve(ctx context.Context, in *SolveRequest, opts ...grpc.CallOption) (*SolveResponse, error) {
	out := new(SolveResponse)
	err := c.cc.Invoke(ctx, "/moby.buildkit.v1.Control/Solve", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (Control_StatusClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Control_serviceDesc.Streams[1], "/moby.buildkit.v1.Control/Status", opts...)
	if err != nil {
		return nil, err
	}
	x := &controlStatusClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Control_StatusClient interface {
	Recv() (*StatusResponse, error)
	grpc.ClientStream
}

type controlStatusClient struct {
	grpc.ClientStream
}

func (x *controlStatusClient) Recv() (*StatusResponse, error) {
	m := new(StatusResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *controlClient) Session(ctx context.Context, opts ...grpc.CallOption) (Control_SessionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Control_serviceDesc.Streams[2], "/moby.buildkit.v1.Control/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &controlSessionClient{stream}
	return x, nil
}

type Control_SessionClient interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ClientStream
}

type controlSessionClient struct {
	grpc.ClientStream
}

func (x *controlSessionClient) Send(m *BytesMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *controlSessionClient) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *controlClient) ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error) {
	out := new(ListWorkersResponse)
	err := c.cc.Invoke(ctx, "/moby.buildkit.v1.Control/ListWorkers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlClient) Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error) {
	out := new(InfoResponse)
	err := c.cc.Invoke(ctx, "/moby.buildkit.v1.Control/Info", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlClient) ListenBuildHistory(ctx context.Context, in *BuildHistoryRequest, opts ...grpc.CallOption) (Control_ListenBuildHistoryClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Control_serviceDesc.Streams[3], "/moby.buildkit.v1.Control/ListenBuildHistory", opts...)
	if err != nil {
		return nil, err
	}
	x := &controlListenBuildHistoryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Control_ListenBuildHistoryClient interface {
	Recv() (*BuildHistoryEvent, error)
	grpc.ClientStream
}

type controlListenBuildHistoryClient struct {
	grpc.ClientStream
}

func (x *controlListenBuildHistoryClient) Recv() (*BuildHistoryEvent, error) {
	m := new(BuildHistoryEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *controlClient) UpdateBuildHistory(ctx context.Context, in *UpdateBuildHistoryRequest, opts ...grpc.CallOption) (*UpdateBuildHistoryResponse, error) {
	out := new(UpdateBuildHistoryResponse)
	err := c.cc.Invoke(ctx, "/moby.buildkit.v1.Control/UpdateBuildHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ControlServer is the server API for Control service.
type ControlServer interface {
	DiskUsage(context.Context, *DiskUsageRequest) (*DiskUsageResponse, error)
	Prune(*PruneRequest, Control_PruneServer) error
	Solve(context.Context, *SolveRequest) (*SolveResponse, error)
	Status(*StatusRequest, Control_StatusServer) error
	Session(Control_SessionServer) error
	ListWorkers(context.Context, *ListWorkersRequest) (*ListWorkersResponse, error)
	Info(context.Context, *InfoRequest) (*InfoResponse, error)
	ListenBuildHistory(*BuildHistoryRequest, Control_ListenBuildHistoryServer) error
	UpdateBuildHistory(context.Context, *UpdateBuildHistoryRequest) (*UpdateBuildHistoryResponse, error)
}

// UnimplementedControlServer can be embedded to have forward compatible implementations.
type UnimplementedControlServer struct {
}

func (*UnimplementedControlServer) DiskUsage(ctx context.Context, req *DiskUsageRequest) (*DiskUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiskUsage not implemented")
}
func (*UnimplementedControlServer) Prune(req *PruneRequest, srv Control_PruneServer) error {
	return status.Errorf(codes.Unimplemented, "method Prune not implemented")
}
func (*UnimplementedControlServer) Solve(ctx context.Context, req *SolveRequest) (*SolveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Solve not implemented")
}
func (*UnimplementedControlServer) Status(req *StatusRequest, srv Control_StatusServer) error {
	return status.Errorf(codes.Unimplemented, "method Status not implemented")
}
func (*UnimplementedControlServer) Session(srv Control_SessionServer) error {
	return status.Errorf(codes.Unimplemented, "method Session not implemented")
}
func (*UnimplementedControlServer) ListWorkers(ctx context.Context, req *ListWorkersRequest) (*ListWorkersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkers not implemented")
}
func (*UnimplementedControlServer) Info(ctx context.Context, req *InfoRequest) (*InfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Info not implemented")
}
func (*UnimplementedControlServer) ListenBuildHistory(req *BuildHistoryRequest, srv Control_ListenBuildHistoryServer) error {
	return status.Errorf(codes.Unimplemented, "method ListenBuildHistory not implemented")
}
func (*UnimplementedControlServer) UpdateBuildHistory(ctx context.Context, req *UpdateBuildHistoryRequest) (*UpdateBuildHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBuildHistory not implemented")
}

func RegisterControlServer(s *grpc.Server, srv ControlServer) {
	s.RegisterService(&_Control_serviceDesc, srv)
}

func _Control_DiskUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiskUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServer).DiskUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/moby.buildkit.v1.Control/DiskUsage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServer).DiskUsage(ctx, req.(*DiskUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Control_Prune_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PruneRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ControlServer).Prune(m, &controlPruneServer{stream})
}

type Control_PruneServer interface {
	Send(*UsageRecord) error
	grpc.ServerStream
}

type controlPruneServer struct {
	grpc.ServerStream
}

func (x *controlPruneServer) Send(m *UsageRecord) error {
	return x.ServerStream.SendMsg(m)
}

func _Control_Solve_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SolveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServer).Solve(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/moby.buildkit.v1.Control/Solve",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServer).Solve(ctx, req.(*SolveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Control_Status_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StatusRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ControlServer).Status(m, &controlStatusServer{stream})
}

type Control_StatusServer interface {
	Send(*StatusResponse) error
	grpc.ServerStream
}

type controlStatusServer struct {
	grpc.ServerStream
}

func (x *controlStatusServer) Send(m *StatusResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Control_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ControlServer).Session(&controlSessionServer{stream})
}

type Control_SessionServer interface {
	Send(*BytesMessage) error
	Recv() (*BytesMessage, error)
	grpc.ServerStream
}

type controlSessionServer struct {
	grpc.ServerStream
}

func (x *controlSessionServer) Send(m *BytesMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *controlSessionServer) Recv() (*BytesMessage, error) {
	m := new(BytesMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Control_ListWorkers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServer).ListWorkers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/moby.buildkit.v1.Control/ListWorkers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServer).ListWorkers(ctx, req.(*ListWorkersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Control_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/moby.buildkit.v1.Control/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServer).Info(ctx, req.(*InfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Control_ListenBuildHistory_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BuildHistoryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ControlServer).ListenBuildHistory(m, &controlListenBuildHistoryServer{stream})
}

type Control_ListenBuildHistoryServer interface {
	Send(*BuildHistoryEvent) error
	grpc.ServerStream
}

type controlListenBuildHistoryServer struct {
	grpc.ServerStream
}

func (x *controlListenBuildHistoryServer) Send(m *BuildHistoryEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _Control_UpdateBuildHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBuildHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServer).UpdateBuildHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/moby.buildkit.v1.Control/UpdateBuildHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServer).UpdateBuildHistory(ctx, req.(*UpdateBuildHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Control_serviceDesc = grpc.ServiceDesc{
	ServiceName: "moby.buildkit.v1.Control",
	HandlerType: (*ControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DiskUsage",
			Handler:    _Control_DiskUsage_Handler,
		},
		{
			MethodName: "Solve",
			Handler:    _Control_Solve_Handler,
		},
		{
			MethodName: "ListWorkers",
			Handler:    _Control_ListWorkers_Handler,
		},
		{
			MethodName: "Info",
			Handler:    _Control_Info_Handler,
		},
		{
			MethodName: "UpdateBuildHistory",
			Handler:    _Control_UpdateBuildHistory_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Prune",
			Handler:       _Control_Prune_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Status",
			Handler:       _Control_Status_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Session",
			Handler:       _Control_Session_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ListenBuildHistory",
			Handler:       _Control_ListenBuildHistory_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "control.proto",
}

func (m *PruneRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PruneRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PruneRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TargetSpace != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.TargetSpace))
		i--
		dAtA[i] = 0x38
	}
	if m.MinFreeSpace != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.MinFreeSpace))
		i--
		dAtA[i] = 0x30
	}
	if m.MaxUsedSpace != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.MaxUsedSpace))
		i--
		dAtA[i] = 0x28
	}
	if m.ReservedSpace != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.ReservedSpace))
		i--
		dAtA[i] = 0x20
	}
	if m.KeepDuration != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.KeepDuration))
		i--
		dAtA[i] = 0x18
	}
	if m.All {
		i--
		if m.All {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Filter) > 0 {
		for iNdEx := len(m.Filter) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filter[iNdEx])
			copy(dAtA[i:], m.Filter[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Filter[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DiskUsageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiskUsageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DiskUsageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Filter) > 0 {
		for iNdEx := len(m.Filter) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filter[iNdEx])
			copy(dAtA[i:], m.Filter[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Filter[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DiskUsageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiskUsageResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DiskUsageResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Record) > 0 {
		for iNdEx := len(m.Record) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Record[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UsageRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Parents) > 0 {
		for iNdEx := len(m.Parents) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Parents[iNdEx])
			copy(dAtA[i:], m.Parents[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Parents[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Shared {
		i--
		if m.Shared {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.RecordType) > 0 {
		i -= len(m.RecordType)
		copy(dAtA[i:], m.RecordType)
		i = encodeVarintControl(dAtA, i, uint64(len(m.RecordType)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x4a
	}
	if m.UsageCount != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.UsageCount))
		i--
		dAtA[i] = 0x40
	}
	if m.LastUsedAt != nil {
		n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastUsedAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUsedAt):])
		if err1 != nil {
			return 0, err1
		}
		i -= n1
		i = encodeVarintControl(dAtA, i, uint64(n1))
		i--
		dAtA[i] = 0x3a
	}
	n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.CreatedAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.CreatedAt):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintControl(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x32
	if len(m.Parent) > 0 {
		i -= len(m.Parent)
		copy(dAtA[i:], m.Parent)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Parent)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Size_ != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x20
	}
	if m.InUse {
		i--
		if m.InUse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Mutable {
		i--
		if m.Mutable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintControl(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SolveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SolveRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SolveRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Exporters) > 0 {
		for iNdEx := len(m.Exporters) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exporters[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6a
		}
	}
	if m.SourcePolicy != nil {
		{
			size, err := m.SourcePolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Internal {
		i--
		if m.Internal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.FrontendInputs) > 0 {
		for k := range m.FrontendInputs {
			v := m.FrontendInputs[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintControl(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.Entitlements) > 0 {
		for iNdEx := len(m.Entitlements) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Entitlements[iNdEx])
			copy(dAtA[i:], m.Entitlements[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Entitlements[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	{
		size, err := m.Cache.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintControl(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if len(m.FrontendAttrs) > 0 {
		for k := range m.FrontendAttrs {
			v := m.FrontendAttrs[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Frontend) > 0 {
		i -= len(m.Frontend)
		copy(dAtA[i:], m.Frontend)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Frontend)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Session) > 0 {
		i -= len(m.Session)
		copy(dAtA[i:], m.Session)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Session)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ExporterAttrsDeprecated) > 0 {
		for k := range m.ExporterAttrsDeprecated {
			v := m.ExporterAttrsDeprecated[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ExporterDeprecated) > 0 {
		i -= len(m.ExporterDeprecated)
		copy(dAtA[i:], m.ExporterDeprecated)
		i = encodeVarintControl(dAtA, i, uint64(len(m.ExporterDeprecated)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Definition != nil {
		{
			size, err := m.Definition.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ref) > 0 {
		i -= len(m.Ref)
		copy(dAtA[i:], m.Ref)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Ref)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CacheOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CacheOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CacheOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Imports) > 0 {
		for iNdEx := len(m.Imports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Imports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Exports) > 0 {
		for iNdEx := len(m.Exports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ExportAttrsDeprecated) > 0 {
		for k := range m.ExportAttrsDeprecated {
			v := m.ExportAttrsDeprecated[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ImportRefsDeprecated) > 0 {
		for iNdEx := len(m.ImportRefsDeprecated) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ImportRefsDeprecated[iNdEx])
			copy(dAtA[i:], m.ImportRefsDeprecated[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.ImportRefsDeprecated[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ExportRefDeprecated) > 0 {
		i -= len(m.ExportRefDeprecated)
		copy(dAtA[i:], m.ExportRefDeprecated)
		i = encodeVarintControl(dAtA, i, uint64(len(m.ExportRefDeprecated)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CacheOptionsEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CacheOptionsEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CacheOptionsEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Attrs) > 0 {
		for k := range m.Attrs {
			v := m.Attrs[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SolveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SolveResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SolveResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExporterResponse) > 0 {
		for k := range m.ExporterResponse {
			v := m.ExporterResponse[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *StatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ref) > 0 {
		i -= len(m.Ref)
		copy(dAtA[i:], m.Ref)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Ref)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Warnings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Logs) > 0 {
		for iNdEx := len(m.Logs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Logs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Statuses) > 0 {
		for iNdEx := len(m.Statuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Statuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Vertexes) > 0 {
		for iNdEx := len(m.Vertexes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Vertexes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Vertex) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Vertex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Vertex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProgressGroup != nil {
		{
			size, err := m.ProgressGroup.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Completed != nil {
		n8, err8 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Completed, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.Completed):])
		if err8 != nil {
			return 0, err8
		}
		i -= n8
		i = encodeVarintControl(dAtA, i, uint64(n8))
		i--
		dAtA[i] = 0x32
	}
	if m.Started != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Started, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.Started):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintControl(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x2a
	}
	if m.Cached {
		i--
		if m.Cached {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Inputs) > 0 {
		for iNdEx := len(m.Inputs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Inputs[iNdEx])
			copy(dAtA[i:], m.Inputs[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Inputs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Digest) > 0 {
		i -= len(m.Digest)
		copy(dAtA[i:], m.Digest)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Digest)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VertexStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VertexStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VertexStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Completed != nil {
		n10, err10 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Completed, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.Completed):])
		if err10 != nil {
			return 0, err10
		}
		i -= n10
		i = encodeVarintControl(dAtA, i, uint64(n10))
		i--
		dAtA[i] = 0x42
	}
	if m.Started != nil {
		n11, err11 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Started, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.Started):])
		if err11 != nil {
			return 0, err11
		}
		i -= n11
		i = encodeVarintControl(dAtA, i, uint64(n11))
		i--
		dAtA[i] = 0x3a
	}
	n12, err12 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Timestamp, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp):])
	if err12 != nil {
		return 0, err12
	}
	i -= n12
	i = encodeVarintControl(dAtA, i, uint64(n12))
	i--
	dAtA[i] = 0x32
	if m.Total != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Total))
		i--
		dAtA[i] = 0x28
	}
	if m.Current != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Vertex) > 0 {
		i -= len(m.Vertex)
		copy(dAtA[i:], m.Vertex)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Vertex)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintControl(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VertexLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VertexLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VertexLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x22
	}
	if m.Stream != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Stream))
		i--
		dAtA[i] = 0x18
	}
	n13, err13 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Timestamp, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp):])
	if err13 != nil {
		return 0, err13
	}
	i -= n13
	i = encodeVarintControl(dAtA, i, uint64(n13))
	i--
	dAtA[i] = 0x12
	if len(m.Vertex) > 0 {
		i -= len(m.Vertex)
		copy(dAtA[i:], m.Vertex)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Vertex)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VertexWarning) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VertexWarning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VertexWarning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ranges) > 0 {
		for iNdEx := len(m.Ranges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ranges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Detail) > 0 {
		for iNdEx := len(m.Detail) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Detail[iNdEx])
			copy(dAtA[i:], m.Detail[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Detail[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Short) > 0 {
		i -= len(m.Short)
		copy(dAtA[i:], m.Short)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Short)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Level != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Level))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Vertex) > 0 {
		i -= len(m.Vertex)
		copy(dAtA[i:], m.Vertex)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Vertex)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BytesMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BytesMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BytesMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListWorkersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListWorkersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListWorkersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Filter) > 0 {
		for iNdEx := len(m.Filter) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filter[iNdEx])
			copy(dAtA[i:], m.Filter[iNdEx])
			i = encodeVarintControl(dAtA, i, uint64(len(m.Filter[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListWorkersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListWorkersResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListWorkersResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Record) > 0 {
		for iNdEx := len(m.Record) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Record[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BuildkitVersion != nil {
		{
			size, err := m.BuildkitVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BuildHistoryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildHistoryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildHistoryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.EarlyExit {
		i--
		if m.EarlyExit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Ref) > 0 {
		i -= len(m.Ref)
		copy(dAtA[i:], m.Ref)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Ref)))
		i--
		dAtA[i] = 0x12
	}
	if m.ActiveOnly {
		i--
		if m.ActiveOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BuildHistoryEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildHistoryEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildHistoryEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Record != nil {
		{
			size, err := m.Record.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BuildHistoryRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildHistoryRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildHistoryRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NumWarnings != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.NumWarnings))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.ExternalError != nil {
		{
			size, err := m.ExternalError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.NumCompletedSteps != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.NumCompletedSteps))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.NumTotalSteps != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.NumTotalSteps))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.NumCachedSteps != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.NumCachedSteps))
		i--
		dAtA[i] = 0x78
	}
	if m.Pinned {
		i--
		if m.Pinned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.Trace != nil {
		{
			size, err := m.Trace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.Generation != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Generation))
		i--
		dAtA[i] = 0x60
	}
	if len(m.Results) > 0 {
		for k := range m.Results {
			v := m.Results[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintControl(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.ExporterResponse) > 0 {
		for k := range m.ExporterResponse {
			v := m.ExporterResponse[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.Logs != nil {
		{
			size, err := m.Logs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CompletedAt != nil {
		n22, err22 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CompletedAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CompletedAt):])
		if err22 != nil {
			return 0, err22
		}
		i -= n22
		i = encodeVarintControl(dAtA, i, uint64(n22))
		i--
		dAtA[i] = 0x3a
	}
	if m.CreatedAt != nil {
		n23, err23 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CreatedAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CreatedAt):])
		if err23 != nil {
			return 0, err23
		}
		i -= n23
		i = encodeVarintControl(dAtA, i, uint64(n23))
		i--
		dAtA[i] = 0x32
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Exporters) > 0 {
		for iNdEx := len(m.Exporters) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exporters[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.FrontendAttrs) > 0 {
		for k := range m.FrontendAttrs {
			v := m.FrontendAttrs[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Frontend) > 0 {
		i -= len(m.Frontend)
		copy(dAtA[i:], m.Frontend)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Frontend)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ref) > 0 {
		i -= len(m.Ref)
		copy(dAtA[i:], m.Ref)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Ref)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateBuildHistoryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateBuildHistoryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateBuildHistoryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Finalize {
		i--
		if m.Finalize {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Delete {
		i--
		if m.Delete {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Pinned {
		i--
		if m.Pinned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Ref) > 0 {
		i -= len(m.Ref)
		copy(dAtA[i:], m.Ref)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Ref)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateBuildHistoryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateBuildHistoryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateBuildHistoryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *Descriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Descriptor) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Descriptor) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Size_ != 0 {
		i = encodeVarintControl(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Digest) > 0 {
		i -= len(m.Digest)
		copy(dAtA[i:], m.Digest)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Digest)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MediaType) > 0 {
		i -= len(m.MediaType)
		copy(dAtA[i:], m.MediaType)
		i = encodeVarintControl(dAtA, i, uint64(len(m.MediaType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BuildResultInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildResultInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildResultInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Results) > 0 {
		for k := range m.Results {
			v := m.Results[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintControl(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintControl(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Attestations) > 0 {
		for iNdEx := len(m.Attestations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attestations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ResultDeprecated != nil {
		{
			size, err := m.ResultDeprecated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Exporter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Exporter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exporter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Attrs) > 0 {
		for k := range m.Attrs {
			v := m.Attrs[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintControl(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintControl(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintControl(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintControl(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintControl(dAtA []byte, offset int, v uint64) int {
	offset -= sovControl(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PruneRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Filter) > 0 {
		for _, s := range m.Filter {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.All {
		n += 2
	}
	if m.KeepDuration != 0 {
		n += 1 + sovControl(uint64(m.KeepDuration))
	}
	if m.ReservedSpace != 0 {
		n += 1 + sovControl(uint64(m.ReservedSpace))
	}
	if m.MaxUsedSpace != 0 {
		n += 1 + sovControl(uint64(m.MaxUsedSpace))
	}
	if m.MinFreeSpace != 0 {
		n += 1 + sovControl(uint64(m.MinFreeSpace))
	}
	if m.TargetSpace != 0 {
		n += 1 + sovControl(uint64(m.TargetSpace))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DiskUsageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Filter) > 0 {
		for _, s := range m.Filter {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DiskUsageResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Record) > 0 {
		for _, e := range m.Record {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UsageRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Mutable {
		n += 2
	}
	if m.InUse {
		n += 2
	}
	if m.Size_ != 0 {
		n += 1 + sovControl(uint64(m.Size_))
	}
	l = len(m.Parent)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.CreatedAt)
	n += 1 + l + sovControl(uint64(l))
	if m.LastUsedAt != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUsedAt)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.UsageCount != 0 {
		n += 1 + sovControl(uint64(m.UsageCount))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.RecordType)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Shared {
		n += 2
	}
	if len(m.Parents) > 0 {
		for _, s := range m.Parents {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SolveRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ref)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Definition != nil {
		l = m.Definition.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.ExporterDeprecated)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.ExporterAttrsDeprecated) > 0 {
		for k, v := range m.ExporterAttrsDeprecated {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	l = len(m.Session)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Frontend)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.FrontendAttrs) > 0 {
		for k, v := range m.FrontendAttrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	l = m.Cache.Size()
	n += 1 + l + sovControl(uint64(l))
	if len(m.Entitlements) > 0 {
		for _, s := range m.Entitlements {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.FrontendInputs) > 0 {
		for k, v := range m.FrontendInputs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovControl(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.Internal {
		n += 2
	}
	if m.SourcePolicy != nil {
		l = m.SourcePolicy.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Exporters) > 0 {
		for _, e := range m.Exporters {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CacheOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ExportRefDeprecated)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.ImportRefsDeprecated) > 0 {
		for _, s := range m.ImportRefsDeprecated {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.ExportAttrsDeprecated) > 0 {
		for k, v := range m.ExportAttrsDeprecated {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if len(m.Exports) > 0 {
		for _, e := range m.Exports {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.Imports) > 0 {
		for _, e := range m.Imports {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CacheOptionsEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Attrs) > 0 {
		for k, v := range m.Attrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SolveResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ExporterResponse) > 0 {
		for k, v := range m.ExporterResponse {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ref)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Vertexes) > 0 {
		for _, e := range m.Vertexes {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.Statuses) > 0 {
		for _, e := range m.Statuses {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Vertex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Digest)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Inputs) > 0 {
		for _, s := range m.Inputs {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Cached {
		n += 2
	}
	if m.Started != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Started)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Completed != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Completed)
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.ProgressGroup != nil {
		l = m.ProgressGroup.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VertexStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Vertex)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Current != 0 {
		n += 1 + sovControl(uint64(m.Current))
	}
	if m.Total != 0 {
		n += 1 + sovControl(uint64(m.Total))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovControl(uint64(l))
	if m.Started != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Started)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Completed != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Completed)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VertexLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Vertex)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovControl(uint64(l))
	if m.Stream != 0 {
		n += 1 + sovControl(uint64(m.Stream))
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VertexWarning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Vertex)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Level != 0 {
		n += 1 + sovControl(uint64(m.Level))
	}
	l = len(m.Short)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Detail) > 0 {
		for _, b := range m.Detail {
			l = len(b)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BytesMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListWorkersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Filter) > 0 {
		for _, s := range m.Filter {
			l = len(s)
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListWorkersResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Record) > 0 {
		for _, e := range m.Record {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BuildkitVersion != nil {
		l = m.BuildkitVersion.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildHistoryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActiveOnly {
		n += 2
	}
	l = len(m.Ref)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.EarlyExit {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildHistoryEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovControl(uint64(m.Type))
	}
	if m.Record != nil {
		l = m.Record.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildHistoryRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ref)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Frontend)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.FrontendAttrs) > 0 {
		for k, v := range m.FrontendAttrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if len(m.Exporters) > 0 {
		for _, e := range m.Exporters {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if m.CreatedAt != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CreatedAt)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.CompletedAt != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CompletedAt)
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Logs != nil {
		l = m.Logs.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.ExporterResponse) > 0 {
		for k, v := range m.ExporterResponse {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Results) > 0 {
		for k, v := range m.Results {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovControl(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.Generation != 0 {
		n += 1 + sovControl(uint64(m.Generation))
	}
	if m.Trace != nil {
		l = m.Trace.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Pinned {
		n += 2
	}
	if m.NumCachedSteps != 0 {
		n += 1 + sovControl(uint64(m.NumCachedSteps))
	}
	if m.NumTotalSteps != 0 {
		n += 2 + sovControl(uint64(m.NumTotalSteps))
	}
	if m.NumCompletedSteps != 0 {
		n += 2 + sovControl(uint64(m.NumCompletedSteps))
	}
	if m.ExternalError != nil {
		l = m.ExternalError.Size()
		n += 2 + l + sovControl(uint64(l))
	}
	if m.NumWarnings != 0 {
		n += 2 + sovControl(uint64(m.NumWarnings))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateBuildHistoryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ref)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Pinned {
		n += 2
	}
	if m.Delete {
		n += 2
	}
	if m.Finalize {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateBuildHistoryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Descriptor) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MediaType)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	l = len(m.Digest)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovControl(uint64(m.Size_))
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildResultInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResultDeprecated != nil {
		l = m.ResultDeprecated.Size()
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Attestations) > 0 {
		for _, e := range m.Attestations {
			l = e.Size()
			n += 1 + l + sovControl(uint64(l))
		}
	}
	if len(m.Results) > 0 {
		for k, v := range m.Results {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovControl(uint64(l))
			}
			mapEntrySize := 1 + sovControl(uint64(k)) + l
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Exporter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovControl(uint64(l))
	}
	if len(m.Attrs) > 0 {
		for k, v := range m.Attrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovControl(uint64(len(k))) + 1 + len(v) + sovControl(uint64(len(v)))
			n += mapEntrySize + 1 + sovControl(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovControl(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozControl(x uint64) (n int) {
	return sovControl(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *PruneRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PruneRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PruneRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = append(m.Filter, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field All", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.All = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepDuration", wireType)
			}
			m.KeepDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepDuration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReservedSpace", wireType)
			}
			m.ReservedSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReservedSpace |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUsedSpace", wireType)
			}
			m.MaxUsedSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUsedSpace |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinFreeSpace", wireType)
			}
			m.MinFreeSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinFreeSpace |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetSpace", wireType)
			}
			m.TargetSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetSpace |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DiskUsageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiskUsageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiskUsageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = append(m.Filter, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DiskUsageResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiskUsageResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiskUsageResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Record", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Record = append(m.Record, &UsageRecord{})
			if err := m.Record[len(m.Record)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsageRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsageRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsageRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mutable = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InUse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InUse = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.CreatedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUsedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUsedAt == nil {
				m.LastUsedAt = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastUsedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsageCount", wireType)
			}
			m.UsageCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UsageCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RecordType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shared", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Shared = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parents", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parents = append(m.Parents, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SolveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SolveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SolveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ref = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Definition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Definition == nil {
				m.Definition = &pb.Definition{}
			}
			if err := m.Definition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExporterDeprecated", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExporterDeprecated = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExporterAttrsDeprecated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExporterAttrsDeprecated == nil {
				m.ExporterAttrsDeprecated = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExporterAttrsDeprecated[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Session", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Session = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frontend", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frontend = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrontendAttrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrontendAttrs == nil {
				m.FrontendAttrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FrontendAttrs[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cache", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Cache.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entitlements", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entitlements = append(m.Entitlements, github_com_dagger_dagger_internal_buildkit_util_entitlements.Entitlement(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrontendInputs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrontendInputs == nil {
				m.FrontendInputs = make(map[string]*pb.Definition)
			}
			var mapkey string
			var mapvalue *pb.Definition
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthControl
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthControl
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &pb.Definition{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FrontendInputs[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Internal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Internal = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourcePolicy == nil {
				m.SourcePolicy = &pb1.Policy{}
			}
			if err := m.SourcePolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exporters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exporters = append(m.Exporters, &Exporter{})
			if err := m.Exporters[len(m.Exporters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CacheOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CacheOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CacheOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExportRefDeprecated", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExportRefDeprecated = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImportRefsDeprecated", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImportRefsDeprecated = append(m.ImportRefsDeprecated, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExportAttrsDeprecated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExportAttrsDeprecated == nil {
				m.ExportAttrsDeprecated = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExportAttrsDeprecated[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exports = append(m.Exports, &CacheOptionsEntry{})
			if err := m.Exports[len(m.Exports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Imports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Imports = append(m.Imports, &CacheOptionsEntry{})
			if err := m.Imports[len(m.Imports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CacheOptionsEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CacheOptionsEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CacheOptionsEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attrs == nil {
				m.Attrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attrs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SolveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SolveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SolveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExporterResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExporterResponse == nil {
				m.ExporterResponse = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExporterResponse[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ref = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vertexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vertexes = append(m.Vertexes, &Vertex{})
			if err := m.Vertexes[len(m.Vertexes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Statuses = append(m.Statuses, &VertexStatus{})
			if err := m.Statuses[len(m.Statuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, &VertexLog{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &VertexWarning{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Vertex) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Vertex: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Vertex: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Digest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Digest = github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inputs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Inputs = append(m.Inputs, github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cached", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Cached = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Started", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Started == nil {
				m.Started = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Started, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Completed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Completed == nil {
				m.Completed = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Completed, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProgressGroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProgressGroup == nil {
				m.ProgressGroup = &pb.ProgressGroup{}
			}
			if err := m.ProgressGroup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VertexStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VertexStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VertexStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vertex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vertex = github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Current", wireType)
			}
			m.Current = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Current |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Started", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Started == nil {
				m.Started = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Started, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Completed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Completed == nil {
				m.Completed = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Completed, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VertexLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VertexLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VertexLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vertex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vertex = github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stream", wireType)
			}
			m.Stream = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stream |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = append(m.Msg[:0], dAtA[iNdEx:postIndex]...)
			if m.Msg == nil {
				m.Msg = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VertexWarning) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VertexWarning: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VertexWarning: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vertex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vertex = github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Short", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Short = append(m.Short[:0], dAtA[iNdEx:postIndex]...)
			if m.Short == nil {
				m.Short = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Detail = append(m.Detail, make([]byte, postIndex-iNdEx))
			copy(m.Detail[len(m.Detail)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &pb.SourceInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, &pb.Range{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BytesMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BytesMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BytesMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListWorkersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListWorkersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListWorkersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = append(m.Filter, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListWorkersResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListWorkersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListWorkersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Record", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Record = append(m.Record, &types.WorkerRecord{})
			if err := m.Record[len(m.Record)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildkitVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BuildkitVersion == nil {
				m.BuildkitVersion = &types.BuildkitVersion{}
			}
			if err := m.BuildkitVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildHistoryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildHistoryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildHistoryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ActiveOnly = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ref = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EarlyExit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EarlyExit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildHistoryEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildHistoryEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildHistoryEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= BuildHistoryEventType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Record", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Record == nil {
				m.Record = &BuildHistoryRecord{}
			}
			if err := m.Record.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildHistoryRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildHistoryRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildHistoryRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ref = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frontend", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frontend = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrontendAttrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrontendAttrs == nil {
				m.FrontendAttrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FrontendAttrs[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exporters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exporters = append(m.Exporters, &Exporter{})
			if err := m.Exporters[len(m.Exporters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &rpc.Status{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CreatedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedAt == nil {
				m.CompletedAt = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CompletedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Logs == nil {
				m.Logs = &Descriptor{}
			}
			if err := m.Logs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExporterResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExporterResponse == nil {
				m.ExporterResponse = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExporterResponse[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &BuildResultInfo{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Results == nil {
				m.Results = make(map[string]*BuildResultInfo)
			}
			var mapkey string
			var mapvalue *BuildResultInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthControl
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthControl
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &BuildResultInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Results[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Generation", wireType)
			}
			m.Generation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Generation |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Trace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Trace == nil {
				m.Trace = &Descriptor{}
			}
			if err := m.Trace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pinned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Pinned = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumCachedSteps", wireType)
			}
			m.NumCachedSteps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumCachedSteps |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumTotalSteps", wireType)
			}
			m.NumTotalSteps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumTotalSteps |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumCompletedSteps", wireType)
			}
			m.NumCompletedSteps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumCompletedSteps |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExternalError == nil {
				m.ExternalError = &Descriptor{}
			}
			if err := m.ExternalError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumWarnings", wireType)
			}
			m.NumWarnings = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumWarnings |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateBuildHistoryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateBuildHistoryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateBuildHistoryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ref = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pinned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Pinned = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Delete = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Finalize", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Finalize = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateBuildHistoryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateBuildHistoryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateBuildHistoryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Descriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Descriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Descriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MediaType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MediaType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Digest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Digest = github_com_opencontainers_go_digest.Digest(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildResultInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildResultInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildResultInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultDeprecated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResultDeprecated == nil {
				m.ResultDeprecated = &Descriptor{}
			}
			if err := m.ResultDeprecated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attestations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attestations = append(m.Attestations, &Descriptor{})
			if err := m.Attestations[len(m.Attestations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Results == nil {
				m.Results = make(map[int64]*Descriptor)
			}
			var mapkey int64
			var mapvalue *Descriptor
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthControl
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthControl
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Descriptor{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Results[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Exporter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exporter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exporter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attrs == nil {
				m.Attrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowControl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowControl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthControl
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipControl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthControl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attrs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipControl(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowControl
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthControl
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupControl
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthControl
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthControl        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowControl          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupControl = fmt.Errorf("proto: unexpected end of group")
)
