/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated by generate_profiling_categories.py from
   profiling_categories.yaml. DO NOT EDIT! */

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Idle {
  Other = 0,
}

impl Default for Idle {
  fn default() -> Self {
      Idle::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Other {
  Other = 1,
  PreferenceRead = 2,
  Profiling = 3,
}

impl Default for Other {
  fn default() -> Self {
      Other::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Test {
  Test = 4,
}

impl Default for Test {
  fn default() -> Self {
      Test::Test
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Layout {
  Other = 5,
  FrameConstruction = 6,
  Reflow = 7,
  CSSParsing = 8,
  SelectorQuery = 9,
  StyleComputation = 10,
  Destroy = 11,
  Printing = 12,
}

impl Default for Layout {
  fn default() -> Self {
      Layout::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum JavaScript {
  Other = 13,
  Parsing = 14,
  BaselineCompilation = 15,
  IonCompilation = 16,
  Interpreter = 17,
  BaselineInterpret = 18,
  Baseline = 19,
  IonMonkey = 20,
  Builtin = 21,
  WasmIon = 22,
  WasmBaseline = 23,
  WasmOther = 24,
}

impl Default for JavaScript {
  fn default() -> Self {
      JavaScript::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum GCCC {
  Other = 25,
  MinorGC = 26,
  MajorGC = 27,
  MajorGCMark = 28,
  MajorGCSweep = 29,
  MajorGCCompact = 30,
  UnmarkGray = 31,
  Barrier = 32,
  FreeSnowWhite = 33,
  BuildGraph = 34,
  ScanRoots = 35,
  CollectWhite = 36,
  Finalize = 37,
}

impl Default for GCCC {
  fn default() -> Self {
      GCCC::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Network {
  Other = 38,
}

impl Default for Network {
  fn default() -> Self {
      Network::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Graphics {
  Other = 39,
  DisplayListBuilding = 40,
  DisplayListMerging = 41,
  LayerBuilding = 42,
  TileAllocation = 43,
  WRDisplayList = 44,
  Rasterization = 45,
  FlushingAsyncPaints = 46,
  ImageDecoding = 47,
  WebGPU = 48,
  VSync = 49,
}

impl Default for Graphics {
  fn default() -> Self {
      Graphics::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum DOM {
  Other = 50,
}

impl Default for DOM {
  fn default() -> Self {
      DOM::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Android {
  Other = 51,
}

impl Default for Android {
  fn default() -> Self {
      Android::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum AndroidX {
  Other = 52,
}

impl Default for AndroidX {
  fn default() -> Self {
      AndroidX::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Java {
  Other = 53,
}

impl Default for Java {
  fn default() -> Self {
      Java::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Mozilla {
  Other = 54,
}

impl Default for Mozilla {
  fn default() -> Self {
      Mozilla::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Kotlin {
  Other = 55,
}

impl Default for Kotlin {
  fn default() -> Self {
      Kotlin::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Blocked {
  Other = 56,
}

impl Default for Blocked {
  fn default() -> Self {
      Blocked::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Mailnews {
  Other = 57,
}

impl Default for Mailnews {
  fn default() -> Self {
      Mailnews::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum IPC {
  Other = 58,
}

impl Default for IPC {
  fn default() -> Self {
      IPC::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Media {
  Other = 59,
  CUBEB = 60,
  PLAYBACK = 61,
  RT = 62,
}

impl Default for Media {
  fn default() -> Self {
      Media::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Accessibility {
  Other = 63,
}

impl Default for Accessibility {
  fn default() -> Self {
      Accessibility::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Profiler {
  Other = 64,
}

impl Default for Profiler {
  fn default() -> Self {
      Profiler::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Timer {
  Other = 65,
}

impl Default for Timer {
  fn default() -> Self {
      Timer::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum RemoteProtocol {
  Other = 66,
}

impl Default for RemoteProtocol {
  fn default() -> Self {
      RemoteProtocol::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Sandbox {
  Other = 67,
}

impl Default for Sandbox {
  fn default() -> Self {
      Sandbox::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum Telemetry {
  Other = 68,
}

impl Default for Telemetry {
  fn default() -> Self {
      Telemetry::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum ML {
  Other = 69,
  INFERENCE = 70,
  SETUP = 71,
}

impl Default for ML {
  fn default() -> Self {
      ML::Other
  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum ProfilingCategoryPair {
  Idle(Option<Idle>),
  Other(Option<Other>),
  Test(Option<Test>),
  Layout(Option<Layout>),
  JavaScript(Option<JavaScript>),
  GCCC(Option<GCCC>),
  Network(Option<Network>),
  Graphics(Option<Graphics>),
  DOM(Option<DOM>),
  Android(Option<Android>),
  AndroidX(Option<AndroidX>),
  Java(Option<Java>),
  Mozilla(Option<Mozilla>),
  Kotlin(Option<Kotlin>),
  Blocked(Option<Blocked>),
  Mailnews(Option<Mailnews>),
  IPC(Option<IPC>),
  Media(Option<Media>),
  Accessibility(Option<Accessibility>),
  Profiler(Option<Profiler>),
  Timer(Option<Timer>),
  RemoteProtocol(Option<RemoteProtocol>),
  Sandbox(Option<Sandbox>),
  Telemetry(Option<Telemetry>),
  ML(Option<ML>),
}

impl ProfilingCategoryPair {
  pub fn to_cpp_enum_value(&self) -> u32 {
    match *self {
      ProfilingCategoryPair::Idle(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Other(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Test(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Layout(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::JavaScript(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::GCCC(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Network(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Graphics(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::DOM(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Android(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::AndroidX(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Java(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Mozilla(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Kotlin(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Blocked(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Mailnews(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::IPC(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Media(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Accessibility(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Profiler(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Timer(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::RemoteProtocol(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Sandbox(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::Telemetry(val) => val.unwrap_or_default() as u32,
      ProfilingCategoryPair::ML(val) => val.unwrap_or_default() as u32,
    }

  }
}

#[repr(u32)]
#[derive(Debug, Copy, Clone)]
pub enum ProfilingCategory {
  Idle = 0,
  Other = 1,
  Test = 2,
  Layout = 3,
  JavaScript = 4,
  GCCC = 5,
  Network = 6,
  Graphics = 7,
  DOM = 8,
  Android = 9,
  AndroidX = 10,
  Java = 11,
  Mozilla = 12,
  Kotlin = 13,
  Blocked = 14,
  Mailnews = 15,
  IPC = 16,
  Media = 17,
  Accessibility = 18,
  Profiler = 19,
  Timer = 20,
  RemoteProtocol = 21,
  Sandbox = 22,
  Telemetry = 23,
  ML = 24,
}

impl ProfilingCategory {
  pub fn to_cpp_enum_value(&self) -> u32 {
      *self as u32
  }
}
