/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-hpi-cfu-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_hpi_cfu_state_to_string:
 * @val: value, e.g. %FU_HPI_CFU_STATE_START_ENTIRE_TRANSACTION_ACCEPTED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_hpi_cfu_state_to_string(FuHpiCfuState val)
{
    if (val == FU_HPI_CFU_STATE_START_ENTIRE_TRANSACTION)
        return "start-entire-transaction";
    if (val == FU_HPI_CFU_STATE_START_ENTIRE_TRANSACTION_ACCEPTED)
        return "start-entire-transaction-accepted";
    if (val == FU_HPI_CFU_STATE_START_OFFER_LIST)
        return "start-offer-list";
    if (val == FU_HPI_CFU_STATE_START_OFFER_LIST_ACCEPTED)
        return "start-offer-list-accepted";
    if (val == FU_HPI_CFU_STATE_UPDATE_OFFER)
        return "update-offer";
    if (val == FU_HPI_CFU_STATE_UPDATE_OFFER_ACCEPTED)
        return "update-offer-accepted";
    if (val == FU_HPI_CFU_STATE_UPDATE_CONTENT)
        return "update-content";
    if (val == FU_HPI_CFU_STATE_UPDATE_SUCCESS)
        return "update-success";
    if (val == FU_HPI_CFU_STATE_UPDATE_OFFER_REJECTED)
        return "update-offer-rejected";
    if (val == FU_HPI_CFU_STATE_UPDATE_MORE_OFFERS)
        return "update-more-offers";
    if (val == FU_HPI_CFU_STATE_END_OFFER_LIST)
        return "end-offer-list";
    if (val == FU_HPI_CFU_STATE_END_OFFER_LIST_ACCEPTED)
        return "end-offer-list-accepted";
    if (val == FU_HPI_CFU_STATE_UPDATE_STOP)
        return "update-stop";
    if (val == FU_HPI_CFU_STATE_ERROR)
        return "error";
    if (val == FU_HPI_CFU_STATE_CHECK_UPDATE_CONTENT)
        return "check-update-content";
    if (val == FU_HPI_CFU_STATE_NOTIFY_ON_READY)
        return "notify-on-ready";
    if (val == FU_HPI_CFU_STATE_WAIT_FOR_READY_NOTIFICATION)
        return "wait-for-ready-notification";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_BY_SENDING_OFFER_LIST_AGAIN)
        return "verify-check-swap-pending-by-sending-offer-list-again";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_OFFER_LIST_ACCEPTED)
        return "verify-check-swap-pending-offer-list-accepted";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_SEND_OFFER_AGAIN)
        return "verify-check-swap-pending-send-offer-again";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_OFFER_ACCEPTED)
        return "verify-check-swap-pending-offer-accepted";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_SEND_UPDATE_END_OFFER_LIST)
        return "verify-check-swap-pending-send-update-end-offer-list";
    if (val == FU_HPI_CFU_STATE_VERIFY_CHECK_SWAP_PENDING_UPDATE_END_OFFER_LIST_ACCEPTED)
        return "verify-check-swap-pending-update-end-offer-list-accepted";
    if (val == FU_HPI_CFU_STATE_UPDATE_VERIFY_ERROR)
        return "update-verify-error";
    return NULL;
}

/**
 * fu_hpi_cfu_firmware_offer_reject_to_string:
 * @val: value, e.g. %FU_HPI_CFU_FIRMWARE_OFFER_REJECT_INV_COMPONENT
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_hpi_cfu_firmware_offer_reject_to_string(FuHpiCfuFirmwareOfferReject val)
{
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_OLD_FW)
        return "old-fw";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_INV_COMPONENT)
        return "inv-component";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_SWAP_PENDING)
        return "swap-pending";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_MISMATCH)
        return "mismatch";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_BANK)
        return "bank";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_PLATFORM)
        return "platform";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_MILESTONE)
        return "milestone";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_INV_PCOL_REV)
        return "inv-pcol-rev";
    if (val == FU_HPI_CFU_FIRMWARE_OFFER_REJECT_VARIANT)
        return "variant";
    return NULL;
}

/**
 * fu_hpi_cfu_firmware_update_offer_to_string:
 * @val: value, e.g. %FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_ACCEPT
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_hpi_cfu_firmware_update_offer_to_string(FuHpiCfuFirmwareUpdateOffer val)
{
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_SKIP)
        return "skip";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_ACCEPT)
        return "accept";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_REJECT)
        return "reject";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_BUSY)
        return "busy";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_COMMAND_READY)
        return "command-ready";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_OFFER_CMD_NOT_SUPPORTED)
        return "cmd-not-supported";
    return NULL;
}

/**
 * fu_hpi_cfu_firmware_update_status_to_string:
 * @val: value, e.g. %FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_PREPARE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_hpi_cfu_firmware_update_status_to_string(FuHpiCfuFirmwareUpdateStatus val)
{
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_SUCCESS)
        return "success";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_PREPARE)
        return "error-prepare";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_WRITE)
        return "error-write";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_COMPLETE)
        return "error-complete";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_VERIFY)
        return "error-verify";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_CRC)
        return "error-crc";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_SIGNATURE)
        return "error-signature";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_VERSION)
        return "error-version";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_SWAP_PENDING)
        return "swap-pending";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_INVALID_ADDR)
        return "error-invalid-addr";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_NO_OFFER)
        return "error-no-offer";
    if (val == FU_HPI_CFU_FIRMWARE_UPDATE_STATUS_ERROR_INVALID)
        return "error-invalid";
    return NULL;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_ref: (skip):
 **/
FuStructHpiCfuOfferCmd *
fu_struct_hpi_cfu_offer_cmd_ref(FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_unref: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_unref(FuStructHpiCfuOfferCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHpiCfuOfferCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_new_internal: (skip):
 **/
static FuStructHpiCfuOfferCmd *
fu_struct_hpi_cfu_offer_cmd_new_internal(void)
{
    FuStructHpiCfuOfferCmd *st = g_new0(FuStructHpiCfuOfferCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hpi_cfu_offer_cmd_get_report_id: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_report_id(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_segment_number: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_segment_number(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_flags: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_flags(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_component_id: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_component_id(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_token: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_token(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_variant: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_variant(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_minor_version: (skip):
 **/
guint16
fu_struct_hpi_cfu_offer_cmd_get_minor_version(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_major_version: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_major_version(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_vendor_specific: (skip):
 **/
guint32
fu_struct_hpi_cfu_offer_cmd_get_vendor_specific(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 9, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_protocol_version: (skip):
 **/
guint8
fu_struct_hpi_cfu_offer_cmd_get_protocol_version(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}
/**
 * fu_struct_hpi_cfu_offer_cmd_get_product_specific: (skip):
 **/
guint16
fu_struct_hpi_cfu_offer_cmd_get_product_specific(const FuStructHpiCfuOfferCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 15, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_hpi_cfu_offer_cmd_set_report_id: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_report_id(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_segment_number: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_segment_number(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_flags: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_flags(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_component_id: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_component_id(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_token: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_token(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_variant: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_variant(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_minor_version: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_minor_version(FuStructHpiCfuOfferCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_major_version: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_major_version(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_vendor_specific: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_vendor_specific(FuStructHpiCfuOfferCmd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 9, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_protocol_version: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_protocol_version(FuStructHpiCfuOfferCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[13] = value;
}
/**
 * fu_struct_hpi_cfu_offer_cmd_set_product_specific: (skip):
 **/
void
fu_struct_hpi_cfu_offer_cmd_set_product_specific(FuStructHpiCfuOfferCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 15, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_offer_cmd_new: (skip):
 **/
FuStructHpiCfuOfferCmd *
fu_struct_hpi_cfu_offer_cmd_new(void)
{
    FuStructHpiCfuOfferCmd *st = fu_struct_hpi_cfu_offer_cmd_new_internal();
    st->buf = g_byte_array_sized_new(17);
    fu_byte_array_set_size(st->buf, 17, 0x0);
    return st;
}
/**
 * fu_struct_hpi_cfu_payload_cmd_ref: (skip):
 **/
FuStructHpiCfuPayloadCmd *
fu_struct_hpi_cfu_payload_cmd_ref(FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hpi_cfu_payload_cmd_unref: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_unref(FuStructHpiCfuPayloadCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHpiCfuPayloadCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_new_internal: (skip):
 **/
static FuStructHpiCfuPayloadCmd *
fu_struct_hpi_cfu_payload_cmd_new_internal(void)
{
    FuStructHpiCfuPayloadCmd *st = g_new0(FuStructHpiCfuPayloadCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hpi_cfu_payload_cmd_get_report_id: (skip):
 **/
guint8
fu_struct_hpi_cfu_payload_cmd_get_report_id(const FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_hpi_cfu_payload_cmd_get_flags: (skip):
 **/
guint8
fu_struct_hpi_cfu_payload_cmd_get_flags(const FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_hpi_cfu_payload_cmd_get_length: (skip):
 **/
guint8
fu_struct_hpi_cfu_payload_cmd_get_length(const FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_hpi_cfu_payload_cmd_get_seq_number: (skip):
 **/
guint16
fu_struct_hpi_cfu_payload_cmd_get_seq_number(const FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_get_address: (skip):
 **/
guint32
fu_struct_hpi_cfu_payload_cmd_get_address(const FuStructHpiCfuPayloadCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_get_data: (skip):
 **/
const guint8 *
fu_struct_hpi_cfu_payload_cmd_get_data(const FuStructHpiCfuPayloadCmd *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 52;
    return st->buf->data + 9;
}

/* setters */
/**
 * fu_struct_hpi_cfu_payload_cmd_set_report_id: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_set_report_id(FuStructHpiCfuPayloadCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hpi_cfu_payload_cmd_set_flags: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_set_flags(FuStructHpiCfuPayloadCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hpi_cfu_payload_cmd_set_length: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_set_length(FuStructHpiCfuPayloadCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_hpi_cfu_payload_cmd_set_seq_number: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_set_seq_number(FuStructHpiCfuPayloadCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_set_address: (skip):
 **/
void
fu_struct_hpi_cfu_payload_cmd_set_address(FuStructHpiCfuPayloadCmd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 5, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_set_data: (skip):
 **/
gboolean
fu_struct_hpi_cfu_payload_cmd_set_data(FuStructHpiCfuPayloadCmd *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 9, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_hpi_cfu_payload_cmd_new: (skip):
 **/
FuStructHpiCfuPayloadCmd *
fu_struct_hpi_cfu_payload_cmd_new(void)
{
    FuStructHpiCfuPayloadCmd *st = fu_struct_hpi_cfu_payload_cmd_new_internal();
    st->buf = g_byte_array_sized_new(61);
    fu_byte_array_set_size(st->buf, 61, 0x0);
    return st;
}
/**
 * fu_struct_hpi_cfu_buf_ref: (skip):
 **/
FuStructHpiCfuBuf *
fu_struct_hpi_cfu_buf_ref(FuStructHpiCfuBuf *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hpi_cfu_buf_unref: (skip):
 **/
void
fu_struct_hpi_cfu_buf_unref(FuStructHpiCfuBuf *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHpiCfuBuf refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_hpi_cfu_buf_new_internal: (skip):
 **/
static FuStructHpiCfuBuf *
fu_struct_hpi_cfu_buf_new_internal(void)
{
    FuStructHpiCfuBuf *st = g_new0(FuStructHpiCfuBuf, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hpi_cfu_buf_get_report_id: (skip):
 **/
guint8
fu_struct_hpi_cfu_buf_get_report_id(const FuStructHpiCfuBuf *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_hpi_cfu_buf_get_command: (skip):
 **/
guint8
fu_struct_hpi_cfu_buf_get_command(const FuStructHpiCfuBuf *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_hpi_cfu_buf_get_report_data: (skip):
 **/
const guint8 *
fu_struct_hpi_cfu_buf_get_report_data(const FuStructHpiCfuBuf *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 15;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_hpi_cfu_buf_set_report_id: (skip):
 **/
void
fu_struct_hpi_cfu_buf_set_report_id(FuStructHpiCfuBuf *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hpi_cfu_buf_set_command: (skip):
 **/
void
fu_struct_hpi_cfu_buf_set_command(FuStructHpiCfuBuf *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hpi_cfu_buf_set_report_data: (skip):
 **/
gboolean
fu_struct_hpi_cfu_buf_set_report_data(FuStructHpiCfuBuf *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_hpi_cfu_buf_new: (skip):
 **/
FuStructHpiCfuBuf *
fu_struct_hpi_cfu_buf_new(void)
{
    FuStructHpiCfuBuf *st = fu_struct_hpi_cfu_buf_new_internal();
    st->buf = g_byte_array_sized_new(17);
    fu_byte_array_set_size(st->buf, 17, 0x0);
    return st;
}
