// -*- mode:C++ ; compile-command: "g++-3.4 -I.. -I../include -g -c icas.cc" -*-
// N.B. for valgrind check, use export GIAC_RELEASE=1
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef EMCC2
#include <emscripten.h>
#endif
#include "first.h"
#ifdef KHICAS
int main(){
  return 0;
}
#else
/*
 *  Copyright (C) 2000,2020 B. Parisse, Institut Fourier, 38402 St Martin d'Heres
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "global.h"
#ifdef HAVE_LIBREADLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif // HAVE_LIBREADLINE
using namespace std;

#include <string>
#include <stdexcept>
#include <fstream>
#include <iomanip>
#include <time.h>
#if defined HAVE_SYS_TIME_H || defined EMCC2
#include <sys/time.h>
#endif
//#include <unistd.h> // For reading arguments from file
#ifdef HAVE_REGEX
#include <regex>
#endif
#include <fcntl.h>
#include <cstdlib>
#include "gen.h"
#include "index.h"
#include "sym2poly.h"
#include "derive.h"
#include "intg.h"
#include "tex.h"
#include "lin.h"
#include "solve.h"
#include "modpoly.h"
#include "usual.h"
#include "sym2poly.h"
#include "moyal.h"
#include "ifactor.h"
#include "gauss.h"
#include "isom.h"
#include "plot.h"
#include "prog.h"
#include "rpn.h"
#include "pari.h"
#include "help.h"
#include "plot.h"
#include "input_lexer.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#include "Python.h"
#include "qjsgiac.h"
#ifdef __MINGW_H
#include <direct.h>
#endif

// using namespace giac;
#ifdef HAVE_LIBREADLINE
static char *line_read = (char *)NULL;

/* Read a string, and return a pointer to it.  Returns NULL on EOF. */
char *
rl_gets (int count)
{
  /* If the buffer has already been allocated, return the memory
     to the free pool. */
  if (line_read)
    {
      free (line_read);
      line_read = (char *)NULL;
    }
  
  /* Get a line from the user. */
  string prompt(giac::print_INT_(count)+">> ");
  line_read = readline ((char *)prompt.c_str());
  
  /* If the line has any text in it, save it on the history. */
  if (line_read && *line_read)
    add_history (line_read);
  
  return (line_read);
}

#endif // HAVE_LIBREADLINE

#ifdef HAVE_EQASCII
extern "C" {
typedef struct
  {
    int x;			/* width */
    int y;			/* heigth */
    int baseline;		/* default line for single characters
				   counting from down */
  }
Tdim;

struct Tgraph;
struct Tgraph		/* the order of fields is important--see Tarray */
  {
    struct Tgraph **down;	/* downnodes for sequential chilren */
    Tdim dim;			/* dimensions of this field */
    int children;		/* number of children */
    struct Tgraph *up;		/* upnode */
    char *txt;			/* the text. #1 points for a child */
  };

Tdim dim (char *txt, struct Tgraph *graph);
char **draw (struct Tgraph *graph);
char *preparse (char *txt);
void dealloc(struct Tgraph *graph); 
}
#endif // HAVE_EQASCII


/* TeXmacs interface 
   See /usr/share/TeXmacs examples/plugins and progs for ex. of scheme commands
   Run texmacs -x '(make-session "giac" "default")' to start automatically
   giac at texmacs beginning
 */

#define TEXMACS_DATA_BEGIN   ((char) 2)
#define TEXMACS_DATA_END     ((char) 5)
#define TEXMACS_DATA_ESCAPE  ((char) 27)
#define TEXMACS_DATA_COMMAND ((char) 16)

#define EMACS_ESCAPE   ((char) 8)
#define EMACS_DATA_BEGIN   ((char) 6)
#define EMACS_DATA_END   ((char) 7)
#define EMACS_QUESTION ((char) 1)
#define EMACS_RESULT ((char) 2)
#define EMACS_ERROR ((char) 9)
#define EMACS_INLINE_HELP ((char) 8)
#define EMACS_PROMPT ((char) 13)
#define EMACS_ASK_COMPLETION ((char) 31)
#define EMACS_COMPLETION ((char) 32)
#define EMACS_END_COMPLETION ((char) 33)

static int texmacs_counter= 0;

#ifndef EMCC2
#include "Xcas1.h"
#endif

#ifndef HAVE_LIBFLTK
using namespace giac;
#define STDIN_FILENO 0

#else

#include "Cfg.h"
void ctrl_c_signal_handler(int signum){
  giac::ctrl_c=true;
  cerr << "icas/giac process " << getpid() << ", Ctrl-C pressed, interruption requested" << '\n';
}
#endif // fltk

void format_plugin () {
  // The configuration of a plugin can be completed at startup time.
  // This is for instance interesting if you add tab-completion a posteriori.
  cout << TEXMACS_DATA_BEGIN << "command:";
  cout << "(plugin-configure complete (:tab-completion #t))";
  cout << TEXMACS_DATA_END;
}

void flush_stdout(int slp = 0){
#ifdef NSPIRE_NEWLIB
  giac::usleep(2000);
#else
  usleep(2000);
#endif
  fflush (stdout);
  if (slp>0) {
#ifdef NSPIRE_NEWLIB
    giac::usleep(slp*1000);
#else
    usleep(slp*1000);
#endif
  }
}

void flush_stderr(){
#ifdef NSPIRE_NEWLIB
  giac::usleep(2000);
#else
  usleep(2000);
#endif
  fflush (stderr);
}

void suspend_stderr() {
  std::cerr.setstate(ios_base::failbit);
}

void restore_stderr() {
  std::cerr.clear(std::cerr.rdstate() & ~ios_base::failbit);
}

vector<string> split_string(const string &s,const string &delim) {
  size_t pos_start=0,pos_end,delim_len=delim.length();
  string token;
  vector<string> res;
  while ((pos_end=s.find(delim,pos_start))!=string::npos) {
    token=s.substr(pos_start,pos_end-pos_start);
    pos_start=pos_end+delim_len;
    res.push_back(token);
  }
  res.push_back(s.substr(pos_start));
  return res;
}

string join_strings(const vector<string> &sv,const string &delim,bool insert_quotes=false) {
  string ret="";
  for (int i=sv.size();i-->0;) {
    ret=(insert_quotes?"\""+sv[i]+"\"":sv[i])+(ret.empty()?"":delim)+ret;
  }
  return ret;
}

string trim_string(const string &s) {
  string ws=" \t\n\r";
  int i,j;
  for (j=s.length();j-->0 && ws.find(s[j])!=string::npos;);
  for (i=0;i<j && ws.find(s[i])!=string::npos;++i);
  return s.substr(i,j-i+1);
}

size_t example_pos(const string &s) {
  if (s.find("Ex")!=0)
    return string::npos;
  size_t pos=s.find(':');
  if (pos==string::npos)
    return pos;
  if (pos>2 && atoi(s.substr(2,pos-2).c_str())>0)
    return pos+1;
  return string::npos;
}

bool is_help_text(const string &str,string &desc,string &usg,vector<string> &rel,vector<string> &ex) {
  string desc_text=gettext("Description"),usg_text=gettext("Usage"),rel_text=gettext("Related"),ex_text=gettext("Examples");
  string see_also=gettext("See also");
  vector<string> lines=split_string(str,"\n"),fields(4),content(4,"");
  for (int i=lines.size();i-->0;) {
    lines[i]=trim_string(lines[i]);
    if (lines[i].empty())
      lines.erase(lines.begin()+i);
  }
  int lc=lines.size();
  fields[0]=desc_text;
  fields[1]=usg_text;
  fields[2]=rel_text;
  fields[3]=ex_text;
  int j=0;
  size_t pos;
  for (int i=0;i<4 && j<lc;++i) {
    if (lines[j].find(fields[i]+":")==0) {
      content[i]=trim_string(lines[j].substr(fields[i].length()+1));
      if (i==3 && content[i].empty())
        content[i]=trim_string(lines[++j]);
      ++j;
    }
  }
  if (j==lc) {
    desc=content[0];
    usg=content[1];
    rel=split_string(content[2],", ");
    for (int i=rel.size();i-->0;) {
      if (trim_string(rel[i]).empty())
        rel.erase(rel.begin()+i);
    }
    if (*content[3].rbegin()==';')
      content[3]=content[3].substr(0,content[3].size()-1); // content[3].pop_back();
    ex=split_string(content[3],";");
    for (int i=ex.size();i-->0;) {
      ex[i]=trim_string(ex[i]);
      if (*ex[i].rbegin()==':') {
        ex[i].push_back(';');
        if (i+1<int(ex.size())) {
          ex[i+1]=ex[i]+ex[i+1];
          ex.erase(ex.begin()+i);
        }
      }
    }
    return true;
  } else {
    int i=lc;
    bool test=false;
    for (;i-->0 && (pos=example_pos(lines[i]))!=string::npos;) {
      ex.push_back(trim_string(lines[i].substr(pos)));
      test=true;
    }
    if (i>=0) {
      if (lines[i].find(see_also+": ")==0) {
        rel=split_string(trim_string(lines[i].substr(see_also.length()+2))," ");
        for (j=rel.size();j-->0;) {
          if (trim_string(rel[j]).empty())
            rel.erase(rel.begin()+j);
        }
        if (rel.size()%2)
          return false;
        for (j=rel.size();j-->0;) {
          if (j%2==0) {
            string sep=rel[j];
            if (*sep.rbegin()!='/')
              return false;
            sep=sep.substr(0,sep.size()-1);//sep.pop_back();
            if (atoi(sep.c_str())<=0)
              return false;
            rel.erase(rel.begin()+j);
          }
        }
        i--;
        test=true;
      }
      if (!test)
        return false;
      if (i>=0) {
        desc=lines[i];
        i--;
      }
      if (i>=0) {
        usg=lines[i];
        i--;
      }
    }
    std::reverse(ex.begin(),ex.end());
    return i<0;
  }
  return false;
}

string str2texmacs(const string &str) {
  string ret;
  string::const_iterator it=str.begin(),itend=str.end();
  for (;it!=itend;++it) {
    switch (*it) {
    case '<':
      ret.append("<less>");
      break;
    case '>':
      ret.append("<gtr>");
      break;
    default:
      ret.append(1,*it);
      break;
    }
  }
  return ret;
}

void texmacs_begin() {
  putchar(TEXMACS_DATA_BEGIN);
}

void texmacs_end() {
  putchar(TEXMACS_DATA_END);
}

void texmacs_endbegin() {
  texmacs_end();
  texmacs_begin();
}

void print_help_text(const string &desc,const string &usg,const vector<string> &rel,const vector<string> &ex) {
  string col="dark cyan",numcol="dark magenta";
  bool newline=false;
  if (!desc.empty()) {
    printf("scheme:%s",string("(with \"font-series\" \"bold\" \"color\" \""+col+"\" \""+gettext("Description")+":\")").c_str());
    texmacs_endbegin();
    printf("verbatim: %s",str2texmacs(desc).c_str());
    if (*desc.rbegin()!='.')
      printf(".");
    newline=true;
  }
  if (!usg.empty()) {
    if (newline) printf("\n");
    texmacs_endbegin();
    printf("scheme:%s",string("(with \"font-series\" \"bold\" \"color\" \""+col+"\" \""+gettext("Usage")+":\")").c_str());
    texmacs_endbegin();
    printf("verbatim: %s",str2texmacs(usg).c_str());
    newline=true;
  }
  if (!rel.empty()) {
    if (newline) printf("\n");
    texmacs_endbegin();
    printf("scheme:%s",string("(with \"font-series\" \"bold\" \"color\" \""+col+"\" \""+gettext("See also")+":\")").c_str());
    texmacs_endbegin();
    printf("verbatim: %s",str2texmacs(join_strings(rel,", ")).c_str());
    newline=true;
  }
  if (!ex.empty()) {
    bool more_than_nine=ex.size()>9;
    if (newline) printf("\n");
    texmacs_endbegin();
    printf("scheme:%s",string("(with \"font-series\" \"bold\" \"color\" \""+col+"\" \""+gettext("Examples")+":\")").c_str());
    int cnt=0;
    for (vector<string>::const_iterator it=ex.begin();it!=ex.end();++it) {
      texmacs_endbegin();
      printf("verbatim:\n");
      texmacs_endbegin();
      printf("scheme:(document (with \"color\" \"%s\" \"(%d)\"))",numcol.c_str(),++cnt);
      texmacs_endbegin();
      if (cnt<10 && more_than_nine)
        printf("verbatim:  %s",str2texmacs(*it).c_str());
      else printf("verbatim: %s",str2texmacs(*it).c_str());
    }
  }
}

void texmacs_next_input () {
  texmacs_begin();
  printf("prompt#");
  //printf("[%d] ",texmacs_counter);
  printf("> ");
  texmacs_end();
  flush_stdout();
  if (std::cerr.rdstate() & ios_base::failbit) {
    flush_stderr();
    restore_stderr();
  }
}

#ifdef __MINGW_H
static const string silent_all(" >nul 2>&1");
static const string silent_err(" 2>nul");
#else
static const string silent_all(" >/dev/null 2>&1");
static const string silent_err(" 2>/dev/null");
#endif

bool texmacs_graph_lr_margins(const string &fname,int &val,bool init=true,int width=0) {
#if defined VISUALC || defined USE_GMP_REPLACEMENTS
  return false;
#else
  char buffer[1024];
  int left,w;
  FILE *pipe=popen(((init?"pdfcrop --verbose ":"pdfinfo ")+giac::to_unix_path(fname)+silent_err).c_str(),"r");
  if (!pipe) return false;
  try {
    int i=-1,j;
    while(fgets(buffer,sizeof(buffer),pipe)!=NULL) {
      string line(buffer);
      if (init) {
        if (line.substr(2,12)=="BoundingBox:") {
          line=line.substr(15);
          i=line.find_first_of(' ');
          left=atoi(line.substr(0,i).c_str());
          j=line.find_first_of(' ',i+1)+1;
          i=line.find_last_of(' ');
          w=atoi(line.substr(j,i-j).c_str());
          break;
        }
      } else {
        if (line.substr(0,10)=="Page size:") {
          for (i=10;line[i]==' ';++i);
          for (j=i;line[j]!=' ';++j);
          val=atoi(line.substr(i,j-i).c_str())-width;
          break;
        }
      }
    }
    if (i<0)
      return false;
  } catch (...) {
    pclose(pipe);
    return false;
  }
  pclose(pipe);
  if (init) {
    int right;
    if (!texmacs_graph_lr_margins(fname,right,false,w))
      return false;
    val=(left+right)/2;
  }
  return true;
#endif
}

bool system_status_ok(int status) {
  return status!=-1
#if !defined __MINGW_H && !defined VISUALC
    && WEXITSTATUS(status)==0
#endif
    ;
}

std::string texmacs_image_file;
int texmacs_image_files_count;

void texmacs_graph_output(const giac::gen & g,giac::gen & gg,std::string & figfilename,int file_type,const giac::context * contextptr){
#ifdef HAVE_LIBFLTK 
#if 1 // changes by L. Marohnić
  string fcrop=texmacs_image_file+"-crop.pdf";
  string fclean=texmacs_image_file+"-clean.eps";
  string feps=texmacs_image_file+".eps";
  string fpdf=texmacs_image_file+".pdf";
  if (!xcas::fltk_view(g,gg,feps,figfilename,file_type,contextptr)){
    texmacs_begin();
    printf("verbatim:%s\n",gettext("Plot cancelled or unable to plot"));
    texmacs_end();
    flush_stdout();
    return;
  }
  if (0 && figfilename.empty()){
    texmacs_begin();
    if (gg.is_symb_of_sommet(giac::at_program))
      printf("verbatim:%s\n",gg.print().c_str());
    else {
      if (gg.type==giac::_STRNG)
        printf("verbatim:%s\n",gg._STRNGptr->c_str());
      else 
        printf("scheme:%s",giac::gen2scm(gg,giac::context0).c_str());
    }
    texmacs_end();
    flush_stdout();
  }
  else {
    bool cleaned=false,cropped=false,no_pdfcrop=true;
#ifdef HAVE_SYSTEM
    if (system(NULL)) {
#ifdef __MINGW_H
      no_pdfcrop=system("where pdfcrop >nul 2>&1") || system("where pdfinfo >nul 2>&1");
#else
      no_pdfcrop=system("which pdfcrop >/dev/null 2>&1") || system("which pdfinfo >/dev/null 2>&1");
#endif
      stringstream ss;
      int lr,status;
#ifdef __MINGW_H
      cleaned=system_status_ok(system(("eps2eps "+feps+" "+fclean).c_str())) &&
              system_status_ok(system(("ps2pdf -dEPSCrop "+fclean+" "+fpdf).c_str()));
#else
      status=system(("eps2eps "+feps+" - | ps2pdf -dEPSCrop - "+fpdf).c_str());
      cleaned=system_status_ok(status);
#endif
      if (cleaned && !no_pdfcrop) {
        if (!texmacs_graph_lr_margins(fpdf,lr))
          no_pdfcrop=true;
        else ss << lr << " 0 " << lr << " 0";
      }
      string mrg=ss.str();
      if (cleaned && !no_pdfcrop) {
        status=system(("pdfcrop --margins '"+mrg+"' "+giac::to_unix_path(fpdf)+" "+giac::to_unix_path(fcrop)+silent_all).c_str());
        cropped=system_status_ok(status);
      }
    }
#endif
    usleep(1000);
    texmacs_begin();
    printf("scheme:(htab \"\")");
    texmacs_endbegin();
    printf("file:%s", (cleaned?(cropped?fcrop:fpdf):feps).c_str());
    texmacs_endbegin();
    printf("scheme:(htab \"\")");
    texmacs_end();
    flush_stdout(200);
    // delete temporary image files
    remove(feps.c_str());
    remove(fpdf.c_str());
    remove(fclean.c_str());
    remove(fcrop.c_str());
  }
#else
  if (!xcas::fltk_view(g,gg,"casgraph.eps",figfilename,file_type,contextptr)){
    putchar(TEXMACS_DATA_BEGIN);
    printf("verbatim: Plot cancelled or unable to plot\n");
    putchar(TEXMACS_DATA_END);
    flush_stdout();
    return;
  }
  if (0 
      && figfilename.empty()
      ){
    putchar(TEXMACS_DATA_BEGIN);
    if (gg.is_symb_of_sommet(giac::at_program))
      printf("verbatim: %s\n",gg.print().c_str());
    else {
      if (gg.type==giac::_STRNG)
        printf("verbatim: %s\n",gg._STRNGptr->c_str());
      else 
        printf("latex:\\[ %s \\]",giac::gen2tex(gg,giac::context0).c_str());
    }
  }
  else {
    putchar(TEXMACS_DATA_END);
    // putchar(TEXMACS_DATA_END);
    flush_stdout();
    // putchar(TEXMACS_DATA_BEGIN);
    // printf("output#");
    putchar(TEXMACS_DATA_BEGIN);
    printf("verbatim:");
    ifstream tmpif("casgraph.eps");
    ifstream_output(tmpif);
    putchar(TEXMACS_DATA_END);
    // putchar(TEXMACS_DATA_END);
    flush_stdout();
    // ofstream log("log");
    // log << g << '\n';
  }
#endif
#endif
}

void texmacs_output(const giac::gen & g,giac::gen & gg,bool reading_file,int no,const giac::context * contextptr){
  giac::history_in(contextptr).push_back(g);
  giac::history_out(contextptr).push_back(gg);
#if 1 // changes by L. Marohnić
  if (reading_file){
    texmacs_begin();
    printf("verbatim:%s\n",str2texmacs(g.print()).c_str());
    texmacs_end();
    flush_stdout();
  }
  int graph_output=graph_output_type(gg);
  if (graph_output){
    string filename="";
    texmacs_graph_output(g,gg,filename,0,contextptr);
    return;
  }
  if (reading_file && gg.is_symb_of_sommet(giac::at_program))
    return;
  if (g.is_symb_of_sommet(giac::at_nodisp))
    return;
  texmacs_begin();
  if (gg.type==giac::_STRNG) {
    string desc,usg;
    vector<string> rel,ex;
    if (is_help_text(*gg._STRNGptr,desc,usg,rel,ex)) {
      if (usg.find(gettext("No help available for "))==0) {
        printf("%s, %s%s: %s?\n",usg.c_str(),gettext("did you mean"),(rel.size()>1?gettext(" one of"):""),join_strings(rel,", ").c_str());
      } else {
        giac::gen h=history_in(contextptr).back(),cmd;
        if (h.is_symb_of_sommet(giac::at_findhelp)) {
          cmd=h._SYMBptr->feuille;
          string c=cmd.print(contextptr);
          if (*c.begin()=='\'' && *c.rbegin()=='\'')
            c=c.substr(1,c.length()-2);
          if (usg.size()>4 && usg.substr(usg.length()-5,5)=="(Opt)")
            usg.clear();
          printf("scheme:(document (with \"color\" \"dark red\" \"font-series\" \"bold\" \"%s\") \"\")",c.c_str());
          texmacs_endbegin();
          std::map<std::string,std::string>::const_iterator it=giac::lexer_localization_map().find(c),itend=giac::lexer_localization_map().end();
          if (it!=itend)
            c=it->second;
#if !defined EMCC && !defined EMCC2
          vector<string> v=giac::html_help(giac::html_mtt,c);
          if (!v.empty())
            ;
#endif
        }
        print_help_text(desc,usg,rel,ex);
      }
    } else {
      string err_text=gettext("Error");
      vector<string> lines=split_string(*gg._STRNGptr,"\n");
      for (int i=lines.size();i-->0;) {
        if (trim_string(lines[i]).empty())
          lines.erase(lines.begin()+i);
      }
      string ts;
      if ((ts=trim_string(lines.back())).find(err_text+":")==0) {
        lines.pop_back();
        printf("verbatim:%s",str2texmacs(join_strings(lines,"\n")).c_str());
        printf("\n");
        texmacs_endbegin();
        string msg=trim_string(ts.substr(err_text.length()+1));
        printf("scheme:(with \"color\" \"red\" \"%s\")",string(err_text+":").c_str());
        texmacs_endbegin();
        printf("verbatim: %s",str2texmacs(msg).c_str());
      } else printf("verbatim:%s\n",str2texmacs(*gg._STRNGptr).c_str());
    }
  } else {
    int ans_num=(int)history_out(contextptr).size()-1;
#ifndef USE_GMP_REPLACEMENTS
    printf("scheme:(equation* (document %s))",giac::gen2scm(gg,giac::context0).c_str());
#endif
  }
#else
  if (reading_file){
    putchar(TEXMACS_DATA_BEGIN);
    printf("verbatim: %s\n",g.print().c_str());
    putchar(TEXMACS_DATA_END);
    flush_stdout();
  }
  int graph_output=graph_output_type(gg);
  if (graph_output){
    string filename="";
    texmacs_graph_output(g,gg,filename,0,contextptr);
    return;
  }
  if (reading_file && gg.is_symb_of_sommet(giac::at_program))
    return; 
  if (g.is_symb_of_sommet(giac::at_nodisp))
    return;
  putchar(TEXMACS_DATA_BEGIN);
  if (gg.is_symb_of_sommet(giac::at_program))
    printf("verbatim: %s\n",gg.print().c_str());
  else {
    if (gg.type==giac::_STRNG)
      printf("verbatim: %s\n",gg._STRNGptr->c_str());
    else 
      printf("latex:\\[ %s \\]",giac::gen2tex(gg,giac::context0).c_str());
  }
#endif
  texmacs_end();
  flush_stdout();
}

void check_browser_help(const giac::gen & g){
  if (g.is_symb_of_sommet(giac::at_findhelp)){
    giac::gen f=g._SYMBptr->feuille;
    string s;
    if (f.type==giac::_SYMB)
      f=f._SYMBptr->sommet;
    if (f.type==giac::_FUNC)
      s=f._FUNCptr->ptr()->s;
#if !defined EMCC && !defined EMCC2 && !defined NSPIRE_NEWLIB && !defined KHICAS
    giac::html_vtt=giac::html_help(giac::html_mtt,s);
#ifndef HAVE_NO_SYSTEM
    if (!giac::html_vtt.empty())
      giac::system_browser_command(giac::html_vtt.front());
#endif
#endif
  }
}

#ifdef HAVE_LIBFLTK
//#include "Equation.h"
// split s at newline or space to avoid too long strings
void split(std::string & s,int cut){
  if (cut<30) cut=30;
  std::string remains(s);
  s.clear();
  int ss;
  while ( (ss=remains.size())>cut ){
    int i=0;
    for (;i<cut;++i){
      if (remains[i]=='\n')
	break;
    }
    if (i<cut){
      s = s+remains.substr(0,i+1);
      remains=remains.substr(i+1,ss-i-1);
      ss=remains.size();
      continue;
    }
    for (i=cut-10;i<ss;++i){
      if (remains[i]==' ' || remains[i]=='\\' || remains[i]=='(' || remains[i]==')' || remains[i]=='{' || remains[i]=='}' || remains[i]=='[' || remains[i]==']')
	break;
    }
    s = s+remains.substr(0,i)+'\n';
    remains=remains.substr(i,ss-i);
    ss=remains.size();
  }
  s = s+remains;
}

string ltgt(const string & s){
  int ss=s.size(),i;
  string res;
  for (i=0;i<ss-4;i++){
    if (s[i]!='&' || s[i+2]!='t' || s[i+3]!=';'){
      res += s[i];
      continue;
    }
    if (s[i+1]=='l'){
      res += '<';
      i +=3;
      continue;
    }
    if (s[i+1]=='g'){
      res += '>';
      i +=3;
      continue;
    }
    res += s[i];
  }
  for (;i<ss;i++) res+=s[i];
  return res;
}

void verb(std::string & warn,int line,ostream & out,std::string cmd_,const std::string & infile,int & texmacs_counter,bool slider,giac::context * contextptr,ostream * checkptr,std::ostream * checkptrin){
  std::string cmd;
  if (giac::python_compat(contextptr))
    cmd="@@"+cmd_;
  else
    cmd=cmd_;
  giac::gen g(cmd,contextptr),gg;
  string gs=cmd;
  split(cmd,50);
  cmd=ltgt(cmd);
  int pos=cmd.find('\n');
  if (pos<0 || pos>=cmd.size())
    pos=cmd.find('|');
  if (pos<0 || pos>=cmd.size())
    out << "\\verb|"<<cmd<<"|\\\\"<<'\n';
  else
    out << "\\begin{verbatim}\n" << cmd << "\\end{verbatim}" << '\n';
  int reading_file=0;
  std::string filename,tmp;
  xcas::icas_eval(g,gg,reading_file,filename,contextptr);
  if (checkptrin){
    int ss=gs.size();
    for (;ss>0;--ss){
      if (gs[ss-1]!=' ' && gs[ss-1]!='\n')
	break;
    }
    if (ss && gs[ss-1]!=';')
      gs += ';';
    *checkptrin << gs << '\n' ;
  }
  if (checkptr) *checkptr << gg << '\n';
  int graph_output=graph_output_type(gg);
  if (graph_output){
    filename=infile+giac::print_INT_(texmacs_counter)+".eps";
    if (xcas::fltk_view(g,gg,filename,tmp,-1,contextptr)){
      out << "\n\\begin{center}\n\\includegraphics[width=0.8\\linewidth]{" << filename << "}\n\\end{center}\n"<<'\n';
      ++texmacs_counter;
    }
  }
  else {
    if (slider) {
      string tmp=gg.print(contextptr);
      if (tmp.size()>256) tmp=tmp.substr(0,255)+"...";
      warn +=  "Line " + giac::print_INT_(line)+" slider "+ g.print(contextptr)+ " -> " +tmp + '\n';
      return;
    }
    int ta=taille(gg,41);
    if (ta>=40){
      string tmp=gg.print(contextptr);
      if (tmp.size()>256) tmp=tmp.substr(0,255)+"...";
      warn +=  "Line " + giac::print_INT_(line)+ " large output "+g.print(contextptr)+ " -> " +tmp + '\n';
      // giac::attributs attr(14,0,1);
      // giac::gen data=xcas::Equation_compute_size(g,attr,600,contextptr);
    }
    gg=giac::string2gen(giac::gen2tex(gg,contextptr),false);
    std::string s=(gg.type==giac::_STRNG)?(*gg._STRNGptr):gg.print(contextptr);
    out << "$$" << s << "$$" << '\n';
  }  
}

void pgiac(std::string infile,std::string outfile,std::ostream * checkptr,std::ostream * checkptrin,bool dohevea){
  COUT << "Giac pdflatex and HTML5 output" << '\n';
  COUT << "Partly inspired from pgiac by Jean-Michel Sarlat" << '\n';
  if (!giac::is_file_available("giac.tex")){
    if (giac::is_file_available("/usr/share/giac/doc/giac.tex"))
      giac::system_no_deprecation("cp /usr/share/giac/doc/giac.tex .");
    else {
      if (giac::is_file_available("/usr/local/share/giac/doc/giac.tex"))
	giac::system_no_deprecation("cp /usr/local/share/giac/doc/giac.tex .");
      else 
	if (giac::is_file_available("/Applications/share/giac/doc/giac.tex"))
	  giac::system_no_deprecation("cp /Applications/share/giac/doc/giac.tex .");
    }
  }
  if (!giac::is_file_available("giacfr.tex")){
    if (giac::is_file_available("/usr/share/giac/doc/giacfr.tex"))
      giac::system_no_deprecation("cp /usr/share/giac/doc/giacfr.tex .");
    else {
      if (giac::is_file_available("/usr/local/share/giac/doc/giacfr.tex"))
	giac::system_no_deprecation("cp /usr/local/share/giac/doc/giacfr.tex .");
      else 
	if (giac::is_file_available("/Applications/share/giac/doc/giacfr.tex"))
	  giac::system_no_deprecation("cp /Applications/share/giac/doc/giacfr.tex .");
    }
  }
  std::string infile_=giac::remove_extension(infile),warn;
  int line=0;
  giac::context ct;
  debug_ptr(&ct)->debug_allowed=false;
  ifstream in(infile.c_str());
  ofstream out(outfile.c_str());
  const int BUFFER_SIZE=32768-1;
  char buf[BUFFER_SIZE+1];
  buf[BUFFER_SIZE]=0;
  bool inside=false,inprog=false,inverb=false;
  int inhevea=0; // 1: \ifhevea, -1: \else
  string prg;
  for (;;){
    if (in.eof())
      break;
    in.getline(buf,BUFFER_SIZE,'\n');++line;
    string s(buf);
    if (s.empty() && inside)
      out << '\n';
    for (;!s.empty();){
      int ss=s.size();
      int pos=0;
      if (inhevea==1){
	pos=s.find("\\fi");
	if (pos>=0 && pos<ss){
	  inhevea=0;
	  break;
	}
	pos=s.find("\\else");
	if (pos>=0 && pos<ss){
	  inhevea=-1;
	}
	break;
      }
      if (inhevea){
	pos=s.find("\\fi");
	if (pos>=0 && pos<ss){
	  inhevea=0;
	  break;
	}
      }
      else {
	pos=s.find("\\ifhevea");
	if (pos>=0 && pos<ss){
	  inhevea=1;
	  break;
	}
      }
      if (inside){
	if (!inverb){
	  pos=s.find("\\verb");
	  if (pos>=0 && pos<ss){
	    out << s << '\n'; // ignore filtering if \verb inside
	    break;
	  }
	  pos=s.find("\\begin{verbatim}");
	  if (pos>=0 && pos<ss){
	    inverb=true;
	    out << s << '\n';
	    break;
	  }
	}
	pos=s.find("\\end{verbatim}");
	if (pos>=0 && pos<ss){
	  inverb=false;
	  out << s << '\n';
	  break;
	}
      }
      pos=s.find("%");
      while (pos>0 && s[pos-1]=='\\')
	pos=s.find("%",pos+1);
      if (pos>=0 && pos<ss){
	int pos1=s.find("{"),pos2=s.find("}");
	if (pos1<0 || pos1>=pos || pos2<0 || pos2>=ss){ 
	  s=s.substr(0,pos); // should check % inside verb/verbatim
	  continue;
	}
      }
      if (!inside){
	int pos=s.find("\\begin{document}");
	if (pos>=0 && pos<ss){
	  out << "\\usepackage{graphicx}\n\\usepackage{xcolor}\n\\newcommand{\\MarqueCommandeGiac}[1]{\n\\color[HTML]{8B7500}$\\rightarrow$}\n\\newcommand{\\MarqueLaTeXGiac}{%\n\\color[HTML]{08868B}}\n\\newcommand{\\InscriptionFigureGiac}[1]{%\n\\begin{center}\n\\includegraphics[width=0.7\\linewidth]{#1}\n\\end{center}\n}" << '\n';
	  inside=true;
	}
      }
      else {
	int pos=s.find("\\end{document}");
	if (pos>=0 && pos<ss){
	  out << s << '\n';
	  out.close();
	  COUT << "File " << outfile << " created" << outfile << '\n' << "Then I will run pdflatex " << giac::remove_extension(outfile) << '\n' ;
	  if (dohevea){
	    std::string cmd="hevea2mml "+infile_+" &";
	    COUT << "Running " << cmd << '\n';
	    giac::system_no_deprecation(cmd.c_str());
	  }
	  else
	    COUT << "For HTML5 output, you can run\nhevea2mml " << infile_ << '\n';
	  std::string cmd="makeindex "+giac::remove_extension(outfile);
	  giac::system_no_deprecation(cmd.c_str());
	  cmd=("pdflatex "+giac::remove_extension(outfile)+" && mv "+giac::remove_extension(outfile)+".pdf "+infile_+".pdf");
	  COUT << cmd << '\n';
	  giac::system_no_deprecation(cmd.c_str());
	  if (!warn.empty()){
	    COUT << "*********************************" << '\n';
	    COUT << "*********************************" << '\n';
	    COUT << "Please take care of the warnings below. Press ENTER to continue" << '\n' << warn;
	    COUT << "*********************************" << '\n';	    
	    COUT << "*********************************" << '\n';
	  }
	  return;
	}
      }
      if (inprog){
	pos=s.find("\\end{giacprog}");
	int decal=16;
	bool hide=false;
	if (pos<0 || pos>=ss){
	  pos=s.find("\\end{giaconload}");
	  if (pos<0 || pos>=ss){
	    pos=s.find("\\end{giaconloadhide}");
	    decal=20;
	    hide=true;
	  }
	}
	else
	  decal=14;
	if (pos>=0 && pos<ss){
	  prg += s.substr(0,pos);
	  if (hide){
	    if (prg.substr(prg.size()-3,3)==":;\n")
	      prg=prg.substr(0,prg.size()-3);
	  }
	  else
	    out << "\\begin{verbatim}\n" << prg << "\\end{verbatim}" << '\n';
 	  if (giac::python_compat(&ct))
	    prg="@@"+prg;
	  giac::gen g(prg,&ct),gg;
	  int reading_file=0;
	  std::string filename;
	  xcas::icas_eval(g,gg,reading_file,filename,&ct);  
	  if (checkptrin){
	    string gs=prg;
	    int ss=gs.size();
	    for (;ss>0;--ss){
	      if (gs[ss-1]!=' ' && gs[ss-1]!='\n')
		break;
	    }
	    if (ss && gs[ss-1]!=';')
	      gs += ';';
	    *checkptrin << gs << '\n' ;
	  }
	  if (checkptr) *checkptr << gg << '\n';
	  s=s.substr(pos+decal,ss-decal-pos);
	  inprog=false;
	  int graph_output=graph_output_type(gg);
	  if (graph_output){
	    filename=giac::remove_extension(infile)+giac::print_INT_(texmacs_counter)+".eps";
	    string tmp;
	    if (xcas::fltk_view(g,gg,filename,tmp,-1,&ct)){
	      out << "\n\\begin{center}\n\\includegraphics[width=0.8\\linewidth]{" << filename << "}\n\\end{center}\n"<<'\n';
	      ++texmacs_counter;
	    }
	  }
	  continue;
	}
	prg += s + '\n';
	break; // read next line until \end{giacprog}
      }
      pos=s.find("\\begin{giacprog}");
      if (pos>=0 && pos<ss){
	prg = "";
	s=s.substr(pos+16,ss-16-pos);
	inprog=true;
	continue;
      }
      pos=s.find("\\begin{giaconload}");
      if (pos>=0 && pos<ss){
	prg = "";
	s=s.substr(pos+18,ss-18-pos);
	inprog=true;
	continue;
      }
      pos=s.find("\\begin{giaconloadhide}");
      if (pos>=0 && pos<ss){
	prg = "";
	s=s.substr(pos+22,ss-22-pos);
	inprog=true;
	continue;
      }
      pos=s.find("\\giac");
      if (inside && pos>=0 && pos<ss){
	out << s.substr(0,pos) << '\n';
	s=s.substr(pos,ss-pos);
	ss=s.size();
	if (s=="\\giacpython" ){
	  giac::python_compat(1,&ct);
	  s=s.substr(pos+11,ss-pos-11);
	  continue;
	}
	bool invalid=false;
	int pos1=s.find("{"),pos2=s.find("}");
	while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	  // scan file until matching }
	  if (in.eof())
	    break;
	  in.getline(buf,BUFFER_SIZE,'\n');++line;
	  string adds(buf);
	  s += adds; ss=s.size();
	  pos2=s.find("}");
	}
	if (ss>10 && s.substr(1,8)=="giaclink" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  out << s.substr(0,pos2+1) << '\n';
	  s=s.substr(pos2+1,ss-pos2-1);
	  continue;
	}
	if (ss>20 && s.substr(1,10)=="giacslider" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1)+":=";
	  for (int j=2;j<6;++j){
	    s=s.substr(pos2+1,ss-pos2-1);
	    ss=s.size();
	    pos1=s.find("{");pos2=s.find("}");
	    while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	      // scan file until matching }
	      if (in.eof())
		break;
	      in.getline(buf,BUFFER_SIZE,'\n'); ++line;
	      string adds(buf);
	      s += adds; ss=s.size();
	      pos2=s.find("}");
	    }
	    if (pos1>=0 && pos1<ss && pos2>=0 && pos2<ss)
	      continue;
	    invalid=true;
	  }
	  if (!invalid){
	    cmd += s.substr(pos1+1,pos2-pos1-1);
	    s=s.substr(pos2+1,ss-pos2-1);
	    ss=s.size();
	    pos1=s.find("{");pos2=s.find("}");
	    while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	      // scan file until matching }
	      if (in.eof())
		break;
	      in.getline(buf,BUFFER_SIZE,'\n'); ++line;
	      string adds(buf);
	      s += adds; ss=s.size();
	      pos2=s.find("}");
	    }
	    if (pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	      cmd += ';'+s.substr(pos1+1,pos2-pos1-1);
	      s=s.substr(pos2+1,ss-pos2-1);
	      ss=s.size();
	      verb(warn,line,out,cmd,infile_,texmacs_counter,true,&ct,checkptr,checkptrin);
	    }
	  }
	  continue;
	}
	if (ss>10 && s.substr(1,7)=="giaccmd" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1);
	  s=s.substr(pos2+1,ss-pos2-1);
	  ss=s.size();
	  pos1=s.find("{");pos2=s.find("}");
	  while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	    // scan file until matching }
	    if (in.eof())
	      break;
	    in.getline(buf,BUFFER_SIZE,'\n'); ++line;
	    string adds(buf);
	    s += adds; ss=s.size();
	    pos2=s.find("}");
	  }
	  cmd = cmd + '('+s.substr(pos1+1,pos2-pos1-1)+')';
	  verb(warn,line,out,cmd,infile_,texmacs_counter,false,&ct,checkptr,checkptrin); 
	  s=s.substr(pos2+1,ss-pos2-1);	
	  continue;
	}
	if (pos1>0 && pos1<ss && pos2>0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1);
	  verb(warn,line,out,cmd,infile_,texmacs_counter,false,&ct,checkptr,checkptrin); 
	  s=s.substr(pos2+1,ss-pos2-1);
	  continue;
	}
	else
	  COUT << "Invalid giac command " << s << '\n';
      }
      out << s << '\n';
      break;
    }
  }
  out.close();
  COUT << "Missing \\end{document}. File " << outfile << " created" << '\n';
  //giac::system_no_deprecation(("pgiac "+outfile).c_str());
}

#else
void pgiac(std::string infile,std::string outfile,std::ostream * checkptr,std::ostream * checkptrin,bool dohevea){
  ifstream in(infile.c_str());
  ofstream out(outfile.c_str());
  const int BUFFER_SIZE=32768-1;
  char buf[BUFFER_SIZE+1];
  buf[BUFFER_SIZE]=0;
  bool inside=false,inprog=false,inverb=false;
  string prg;
  for (;;){
    if (in.eof())
      break;
    in.getline(buf,BUFFER_SIZE,'\n');
    string s(buf);
    for (;!s.empty();){
      int ss=s.size();
      int pos=0;
      if (inside){
	if (!inverb){
	  pos=s.find("\\verb");
	  if (pos>=0 && pos<ss){
	    out << s << '\n'; // ignore filtering if \verb inside
	    break;
	  }
	  pos=s.find("\\begin{verbatim}");
	  if (pos>=0 && pos<ss){
	    inverb=true;
	    out << s << '\n';
	    break;
	  }
	}
	pos=s.find("\\end{verbatim}");
	if (pos>=0 && pos<ss){
	  inverb=false;
	  out << s << '\n';
	  break;
	}
      }
      pos=s.find("%");
      if (pos>=0 && pos<ss){
	int pos1=s.find("{"),pos2=s.find("}");
	if (pos1<0 || pos1>=pos || pos2<0 || pos2>=ss){ 
	  s=s.substr(0,pos); // should check % inside verb/verbatim
	  continue;
	}
      }
      if (!inside){
	int pos=s.find("\\begin{document}");
	if (pos>=0 && pos<ss){
	  out << "\\usepackage{graphicx}\n\\usepackage{xcolor}\n\\newcommand{\\MarqueCommandeGiac}[1]{\n\\color[HTML]{8B7500}$\\rightarrow$}\n\\newcommand{\\MarqueLaTeXGiac}{%\n\\color[HTML]{08868B}}\n\\newcommand{\\InscriptionFigureGiac}[1]{%\n\\begin{center}\n\\includegraphics[width=0.7\\linewidth]{#1}\n\\end{center}\n}" << '\n';
	  inside=true;
	}
      }
      else {
	int pos=s.find("\\end{document}");
	if (pos>=0 && pos<ss){
	  out << s << '\n';
	  out.close();
	  COUT << "File " << outfile << " created, now running hevea2mml in background and pgiac " << outfile << '\n' << "Then I will run pdflatex " << giac::remove_extension(outfile) << '\n' << "For HTML5 output, you can run\nhevea2mml " << giac::remove_extension(infile) << '\n';
	  std::string cmd="hevea2mml "+giac::remove_extension(infile)+" &";
	  giac::system_no_deprecation(cmd.c_str());
	  cmd=("pgiac "+outfile+" && pdflatex "+giac::remove_extension(outfile)+" && mv "+giac::remove_extension(outfile)+".pdf "+giac::remove_extension(infile)+".pdf");
	  COUT << cmd << '\n';
	  giac::system_no_deprecation(cmd.c_str());
	  return;
	}
      }
      if (inprog){
	pos=s.find("\\end{giacprog}");
	if (pos>=0 && pos<ss){
	  prg += s.substr(0,pos);
	  out << ".g " << prg << '\n';
	  s=s.substr(pos+14,ss-14-pos);
	  inprog=false;
	  continue;
	}
	prg += s + " ";
	break; // read next line until \end{giacprog}
      }
      pos=s.find("\\begin{giacprog}");
      if (pos>=0 && pos<ss){
	prg = "";
	s=s.substr(pos+16,ss-16-pos);
	inprog=true;
	continue;
      }
      pos=s.find("\\giac");
      if (inside && pos>=0 && pos<ss){
	out << s.substr(0,pos) << '\n';
	s=s.substr(pos,ss-pos);
	ss=s.size();
	bool invalid=false;
	int pos1=s.find("{"),pos2=s.find("}");
	while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	  // scan file until matching }
	  if (in.eof())
	    break;
	  in.getline(buf,BUFFER_SIZE,'\n');
	  string adds(buf);
	  s += adds; ss=s.size();
	  pos2=s.find("}");
	}
	if (ss>10 && s.substr(1,8)=="giaclink" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  out << s.substr(0,pos2+1) << '\n';
	  s=s.substr(pos2+1,ss-pos2-1);
	  continue;
	}
	if (ss>20 && s.substr(1,10)=="giacslider" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1)+":=";
	  for (int j=2;j<6;++j){
	    s=s.substr(pos2+1,ss-pos2-1);
	    ss=s.size();
	    pos1=s.find("{");pos2=s.find("}");
	    while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	      // scan file until matching }
	      if (in.eof())
		break;
	      in.getline(buf,BUFFER_SIZE,'\n');
	      string adds(buf);
	      s += adds; ss=s.size();
	      pos2=s.find("}");
	    }
	    if (pos1>=0 && pos1<ss && pos2>=0 && pos2<ss)
	      continue;
	    invalid=true;
	  }
	  if (!invalid){
	    cmd += s.substr(pos1+1,pos2-pos1-1);
	    s=s.substr(pos2+1,ss-pos2-1);
	    ss=s.size();
	    pos1=s.find("{");pos2=s.find("}");
	    while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	      // scan file until matching }
	      if (in.eof())
		break;
	      in.getline(buf,BUFFER_SIZE,'\n');
	      string adds(buf);
	      s += adds; ss=s.size();
	      pos2=s.find("}");
	    }
	    if (pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	      cmd += ';'+s.substr(pos1+1,pos2-pos1-1);
	      s=s.substr(pos2+1,ss-pos2-1);
	      ss=s.size();
	      out << ".g " << cmd << '\n' ;
	    }
	  }
	  continue;
	}
	if (ss>10 && s.substr(1,7)=="giaccmd" && pos1>=0 && pos1<ss && pos2>=0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1);
	  s=s.substr(pos2+1,ss-pos2-1);
	  ss=s.size();
	  pos1=s.find("{");pos2=s.find("}");
	  while ( (pos1>=0 && pos1<ss ) && (pos2<0 || pos2>=ss)){
	    // scan file until matching }
	    if (in.eof())
	      break;
	    in.getline(buf,BUFFER_SIZE,'\n');
	    string adds(buf);
	    s += adds; ss=s.size();
	    pos2=s.find("}");
	  }
	  cmd = cmd + '('+s.substr(pos1+1,pos2-pos1-1)+')';
	  out << ".g " << cmd << '\n' ;
	  s=s.substr(pos2+1,ss-pos2-1);	
	  continue;
	}
	if (pos1>0 && pos1<ss && pos2>0 && pos2<ss){
	  string cmd=s.substr(pos1+1,pos2-pos1-1);
	  out << ".g " << cmd << '\n' ;
	  s=s.substr(pos2+1,ss-pos2-1);
	  continue;
	}
	else
	  COUT << "Invalid giac command " << s << '\n';
      }
      out << s << '\n';
      break;
    }
  }
  out.close();
  COUT << "Missing \\end{document}. File " << outfile << " created, now running pgiac" << '\n';
  giac::system_no_deprecation(("pgiac "+outfile).c_str());
}
#endif

int micropyjs_evaled(string & s,const giac::context * contextptr){
#ifdef QUICKJS
  if (python_compat(contextptr) <0){
    if (s.size() && s[0]=='@')
      s=s.substr(1,s.size()-1);
    else
      s="\"use math\";"+s;
    char * js=js_ck_eval(s.c_str(),&global_js_context);
    if (js){
      printf("%s\n",js);
      free(js);
    }
    else printf("%s\n","QuickJS error");
    return 1;
  }
#endif
#ifdef HAVE_LIBMICROPYTHON
  if (python_compat(contextptr) & 4){
    const char * ptr=s.c_str();
    while (*ptr==' ')
      ++ptr;
    bool gr= strcmp(ptr,"show()")==0 || strcmp(ptr,",")==0;
    bool pix =strcmp(ptr,";")==0;
    bool turt=strcmp(ptr,".")==0;
    if (!gr && !pix && !turt){
      giac::python_contextptr=contextptr;
      python_console()="";
      int i=micropy_ck_eval(s.c_str());
      cout << python_console() ;
      return 1;
    }
    giac::context * cascontextptr=(giac::context *)giac::caseval("caseval contextptr");
    if (gr){
      history_plot(contextptr)=history_plot(cascontextptr);
      s="show()";
    }
    if (pix)
      s="show_pixels()";
    if (freezeturtle || turt){
      turtle(contextptr)=turtle(cascontextptr);
      turtle_stack(contextptr)=turtle_stack(cascontextptr);
      s="avance(0)";
    }
  }
#endif
  return 0;
}

#ifdef EMCC2
std::string get_string(const std::string & in){
  char buf[1024];
  EM_ASM({
      var msg=UTF8ToString($0);
      var jsString = prompt(msg);
      if (jsString==null) jsString="";
      var lengthBytes = lengthBytesUTF8(jsString)+1;
      stringToUTF8(jsString,$1,1024);
      },in.c_str(),buf);
  std::string s(buf);
  //free(buf);
  return s;
}
#endif

void end_icas(){
#if defined HAVE_SIGNAL_H && !defined __MINGW_H
  if (giac::child_id>1){
    cerr << "Killing child process " << giac::child_id << "\n";
    kill(giac::child_id,SIGKILL);
    usleep(1);
    if (1){
      unlink(giac::cas_entree_name().c_str());
      unlink(giac::cas_sortie_name().c_str());
    } else {
      cerr << "Fork files may be present,  rm -f " <<  giac::cas_entree_name() << " " << giac::cas_sortie_name() << "\n";
    }
  }
#endif
  if (getenv("GIAC_RELEASE")) // for valgrind
    giac::release_globals();
}  

int main(int ARGC, char *ARGV[]){
  //giac::stack_check_init(512*1024);  
  bool inmcp=((ARGC>=2) && std::string(ARGV[1])=="--mcp");
  bool inemacs=((ARGC>=2) && std::string(ARGV[1])=="--emacs");
  bool insage=((ARGC>=2) && std::string(ARGV[1])=="--sage");
  bool intexmacs=((ARGC>=2) && std::string(ARGV[1])=="--texmacs");
  if (intexmacs) suspend_stderr(); // suppress stderr output when in texmacs (L. Marohnić)
  if (getenv("GIAC_WARN")) giac::warn_symb_program_sto=atoi(getenv("GIAC_WARN"));
#ifdef HAVE_LIBFLTK
#if !defined(__APPLE__) && !defined(WIN32)
  if (getenv("DISPLAY"))
#endif    
    xcas::fonts_available=Fl::set_fonts(0);
#ifndef USE_OBJET_BIDON
  xcas::localisation(); // change by L. Marohnić
#endif
  giac::__get_key.op=&xcas::Xcas_fltk_getKey;
#endif
  //giac::step_infolevel=1;
  cerr << "// Maximum number of parallel threads " << giac::threads << '\n';
  giac::context giac_context;
  giac::context * contextptr = 
    //  (giac::context *) giac::context0 ; 
    &giac_context;
#ifdef EMCC2
  for (int i=0;;++i){
    string s;
    s=get_string("Empty string -> end");
    if (s.size()==0)
      break;
    cout << ">>> " << s << "\n" ;
    giac::gen g(s,contextptr);
    g=eval(g,eval_level(contextptr),contextptr);
    cout << g.print(contextptr) << "\n";
  }
  end_icas();
  return 0;
#endif  
  bool dohevea=true;
  if (ARGC>1 && strcmp(ARGV[ARGC-1],"--pdf")==0)
    dohevea=false;
#if !defined EMCC && !defined EMCC2 && !defined NSPIRE_NEWLIB && !defined KHICAS
  giac::xcasroot()=giac::xcasroot_dir(ARGV[0]);
#endif
#ifndef VISUALC
  signal(SIGINT,ctrl_c_signal_handler);
#endif
  //cerr << giac::remove_filename(ARGV[0]) << '\n';
#ifdef HAVE_LIBGSL
  gsl_set_error_handler_off();
#endif
#ifdef HAVE_LIBFLTK
#if !defined(__APPLE__) && !defined(WIN32)
  if (getenv("DISPLAY"))
#endif
#ifdef HAVE_LIBFLTK_GL
    Fl::gl_visual(FL_RGB | FL_DEPTH | FL_ACCUM | FL_ALPHA);
#endif
#endif
  giac::secure_run=false;
#if !defined EMCC && !defined EMCC2 && !defined NSPIRE_NEWLIB && !defined KHICAS
  if (ARGC==2 && !strcmp(ARGV[1],"--rebuild-help-cache")){
    // works with old version of hevea (1.10) but not with hevea 2.29
    for (int i=0;i<=4;++i)
      giac::html_help_init("aide_cas",i,true,true);
    return 0;
  }
#endif
  giac::gnuplot_ymin=-2.4;
  giac::gnuplot_ymax=2.1;
#ifdef GNUWINCE
  if (ARGC<2 || ARGC==3){
    giac::child_id=1;
    // chdir("My Documents");
    if (ARGC==3){
      chdir(ARGV[1]);
      giac::language(atoi(ARGV[2]),contextptr);
    }
    else
      chdir(giac::remove_filename(ARGV[0]).c_str());
    FILE * stream = fopen("gnuplot.txt","w");
    fputc(' ',stream);
    fflush(stream);
    fclose(stream);
    ifstream in("Cas.txt");
    ofstream out("Out.txt");
    giac::outptr=&out;
    giac::vecteur args;
    giac::readargs_from_stream(in,args);
    clock_t start, end;  
    int s=args.size();
    for (int i=0;i<s;++i){
      out << "// " << args[i] << ' ' << char(10) << char(13) ;
      start = clock();
      giac::gen tmp=giac::_simplifier(giac::protecteval(args[i],giac::DEFAULT_EVAL_LEVEL,contextptr),contextptr);
      end = clock();
      out << tmp.print(contextptr) << ' ' << char(10) << char(13) ;
      // out << "// Time " << double(end-start)/CLOCKS_PER_SEC << char(10) << char(13)  << char(10) << char(13) ;
    }
    end_icas();
    return 0;
  }
#endif
  if (ARGC==2 && (string(ARGV[1])=="-v" || string(ARGV[1])=="--version" ) ){
    cout << "// (c) 2001, 2021 B. Parisse & others" << '\n';
    cout << GIAC_VERSION << '\n';
#ifndef GNUWINCE
    end_icas();
    return 0;
#endif
  }
  //signal(SIGUSR1,data_signal_handler);
  //signal(SIGUSR2,plot_signal_handler);
  giac::child_id=1;
  if (inemacs){
    putchar(EMACS_DATA_BEGIN);
    putchar(EMACS_ERROR);
  }
  if (insage)
    ARGC=1;
  // Config
  bool show_time=true,show_tex=false;
  giac::read_env(contextptr,!inemacs && !intexmacs);
  int savedbg=giac::debug_infolevel;
  giac::protected_read_config(contextptr,false);
  if (getenv("GIAC_THREADS")){
    int t=atoi(getenv("GIAC_THREADS"));
    if (t>=1){
      giac::threads=t;
      *logptr(contextptr) << "Setting threads to " << t << '\n';
    }
  }
  if (getenv("GIAC_FFTMUL_SIZE")){
    int t=atoi(getenv("GIAC_FFTMUL_SIZE"));
    if (t>=1){
      giac::FFTMUL_SIZE=t;
      *logptr(contextptr) << "Setting FFT mult size to " << t << '\n';
    }
  }
  if (getenv("GIAC_MIN_PROBA_TIME")){
    double t=atof(getenv("GIAC_MIN_PROBA_TIME"));
    if (t>=0){
      giac::min_proba_time=t;
      *logptr(contextptr) << "Setting minimal probabilistic answer time delat to " << t << '\n';
    }
  }
  ofstream * filestream=0;
  if (getenv("GIAC_LOG_FILE")){
    filestream = new ofstream(getenv("GIAC_LOG_FILE"));
    *logptr(contextptr) << "Some logs will be redirected to " << getenv("GIAC_LOG_FILE") << "\n";
    logptr(filestream,contextptr);
    *logptr(contextptr) << "// Redirection of giac logs\n";
  }
  if (savedbg)
    giac::debug_infolevel=savedbg;
  if (ARGC>=2){
    giac::set_language(giac::language(contextptr),contextptr);
    ostream * checkptr=0,*checkptrin=0;
    std::string infile(ARGV[1]),outfile=giac::remove_extension(infile);
    if (infile==outfile && !giac::is_file_available(ARGV[1]) && giac::is_file_available((infile+".tex").c_str()))
      infile=outfile+".tex";
    if (infile==outfile+".tex"){
      outfile=outfile+"_.tex";
      // outfile=outfile+"_.w";
      if (ARGC>=3){
	if (std::string(ARGV[2])=="--check"){
	  if (ARGC>=4){
	    checkptr=new ofstream((string(ARGV[3])+".out").c_str());
	    checkptrin=new ofstream((string(ARGV[3])+".in").c_str());
	  }
	  else {
	    checkptr=new ofstream((infile+".out").c_str());
	    checkptrin=new ofstream((infile+".in").c_str());
	  }
	}
	else
	  outfile=ARGV[2];
      }
      if (!giac::is_file_available(infile.c_str())){
	COUT << "Unable to read " << infile << '\n';
        end_icas();
	return 1;
      }
      pgiac(infile,outfile,checkptr,checkptrin,dohevea);
      if (checkptr) delete checkptr;
      if (checkptrin) delete checkptrin;
      end_icas();
      return 0;
    }
  }
  if (ARGC>=3 && std::string(ARGV[1])=="--tex"){
    giac::set_language(giac::language(contextptr),contextptr);
    ostream * checkptr=0,*checkptrin=0;
    // scan ARGV[2], search for commands starting by \giac...{}
    // output .g command, output everything else verbatim 
    // output goes in ARGV[3] or in ARGV[2].w
    // after that it is processed by pgiac
    std::string infile(ARGV[2]),outfile=giac::remove_extension(infile);
    if (infile==outfile){
      infile=infile+".tex";
      outfile=outfile+"_.w";
    }
    if (ARGC>=4){
      if (std::string(ARGV[2])=="--check"){
	if (ARGC>=5){
	  checkptr=new ofstream((string(ARGV[4])+".out").c_str());
	  checkptrin=new ofstream((string(ARGV[4])+".in").c_str());
	}
	else {
	  checkptr=new ofstream((infile+".out").c_str());
	  checkptrin=new ofstream((infile+".in").c_str());
	}
      }
      else
	outfile=ARGV[3];
    }
    if (!giac::is_file_available(infile.c_str())){
      COUT << "Unable to read " << infile << '\n';
      end_icas();
      return 1;
    }
    pgiac(infile,outfile,checkptr,checkptrin,dohevea);
    if (checkptr) delete checkptr;
    if (checkptrin) delete checkptrin;
    end_icas();
    return 0;
  }
  // Help and completion
  int helpitems;
  // export GIAC_DEBUG==-2 to output static_help*
  // export GIAC_DEBUG==-3 or -4 to output mcp tool list
#ifdef STATIC_BUILTIN_LEXER_FUNCTIONS
  if (giac::debug_infolevel<=-2 && giac::debug_infolevel>=-4){
#endif
    giac::readhelp((*giac::vector_aide_ptr()),"aide_cas",helpitems,false);
    if (!helpitems){
      if (getenv("XCAS_HELP"))
	giac::readhelp((*giac::vector_aide_ptr()),getenv("XCAS_HELP"),helpitems,true);
      else
	giac::readhelp((*giac::vector_aide_ptr()),(giac::giac_aide_dir()+"aide_cas").c_str(),helpitems,false);
    }
#ifdef STATIC_BUILTIN_LEXER_FUNCTIONS
  }
#endif
  if (giac::debug_infolevel){
    if (!helpitems)
      cerr << "Unable to open help file aide_cas" << '\n';
    else
      cerr << "Registered " << helpitems << " commands" << '\n';
  }
  giac::set_language(giac::language(contextptr),contextptr);
  /* *******
   * EMACS *
   *********/
  //#define EMACS_DEBUG 1
#if !defined EMCC && !defined EMCC2 && !defined NSPIRE_NEWLIB && !defined KHICAS
  if (inemacs || inmcp){
    giac::html_help_init(ARGV[0],false);
    int out_handle;
#ifdef WITH_GNUPLOT
    giac::run_gnuplot(out_handle);
#endif
    if (inemacs){
      putchar(EMACS_DATA_END);
      putchar(EMACS_DATA_BEGIN);
      putchar(EMACS_RESULT);
      printf("Giac CAS for mupacs, released under the GPL license 3.0\n");
      printf("See http://www.gnu.org for license details\n");
      printf("May contain BSD licensed software parts (lapack, atlas, tinymt)\n");
      printf("| (c) 2006, 2021 B. Parisse & al (giac), F.Maltey & al (mupacs) |\n");
      putchar(EMACS_DATA_END);
    }
    bool prompt=true;
    for (int k=0;;++k) {
      if (prompt && inemacs){
	putchar(EMACS_DATA_BEGIN);
	putchar(EMACS_PROMPT);
	printf(">> ");
	putchar(EMACS_DATA_END);
      }
      else
	prompt=true;
      string buffer;
      char car;//,nxt;
#ifdef EMACS_DEBUG
      ofstream logfile(("log"+giac::print_INT_(k%16)).c_str());
#endif
      for (;;){
	int i=getchar();
	car=i;
#ifdef EMACS_DEBUG
        if (i!=-1){
          if (i<32)
            logfile << "Ctrl-" << giac::print_INT_(i) << '\n';
          else {
            logfile << car << '\n';
          }
          logfile.flush();
        }
#endif
	if (inemacs && i==EOF)
	  break;
	if (i==EMACS_DATA_END){
	  buffer = buffer + '\n';
	  break;
	}
	buffer=buffer+car;
      }
      // end read buffer
      int s=buffer.size();
      if (s<=2)
	continue;
      if (buffer[0]==10){
	--s;
	buffer=buffer.substr(1,s);
	if (s<=2)
	  continue;
      }
      if (buffer[0]==EMACS_DATA_BEGIN){
	char cmd=buffer[1];
	s -= 2;
	buffer=buffer.substr(2,s);
	if (s && buffer[s-1]=='\n'){
	  --s;
	  buffer=buffer.substr(0,s);
	}
#ifdef EMACS_DEBUG
	logfile << buffer << " " << s << " " << int(buffer[buffer.size()-1]) <<'\n';
#endif
	if (cmd==EMACS_ASK_COMPLETION){
	  // reading possible completions from aide_cas
	  vector<string> vres;
	  for (unsigned k=0;k<(*giac::vector_completions_ptr()).size();++k){
	    if ((*giac::vector_completions_ptr())[k].substr(0,s)==buffer){
	      vres.push_back((*giac::vector_completions_ptr())[k]);
	    }
	  }
	  // add global names
	  giac::gen gv(giac::_VARS(giac::zero,contextptr));
	  if (gv.type==giac::_VECT){
	    giac::vecteur & vv =*gv._VECTptr;
	    for (unsigned k=0;k<vv.size();++k){
	      if (vv[k].print(contextptr).substr(0,s)==buffer){
		vres.push_back(vv[k].print(contextptr));
	      }
	    }
	  }
	  string common;
	  int l=s;
	  int vs=vres.size();
#ifdef EMACS_DEBUG
	  logfile << vs << " completions" << '\n';
#endif
	  for (int k=0;k<vs;k++){
	    if (common.empty()){
	      common=vres[k];
	      l=common.size();
	    }
	    else {
	      int maxl=min(common.size(),vres[k].size());
#ifdef EMACS_DEBUG
	      logfile << maxl << " " << common << " " << vres[k] << '\n';
#endif
	      for (l=s;l<maxl;++l){
		if (common[l]!=vres[k][l])
		  break;
	      }
	      common=common.substr(0,l);
	    }
	  }
	  putchar(EMACS_DATA_BEGIN);
	  putchar(EMACS_COMPLETION);
	  if (vs!=1){
	    if (vs==0){
	      putchar(EMACS_ESCAPE);
	      putchar(EMACS_DATA_END);
	    }
	    for (int k=0;k<vs;k++){
	      printf("%s",vres[k].c_str());
	      if (k!=vs-1)
		printf(", ");
	    }
	  }
	  putchar(EMACS_DATA_END);
	  putchar(EMACS_DATA_BEGIN);
	  putchar(EMACS_END_COMPLETION);
	  // common completion
#ifdef EMACS_DEBUG
	  logfile << common << " " << l << " " << s;
#endif
	  if (l>s)
	    printf("%s",common.substr(s,l-s).c_str());
	  putchar(EMACS_DATA_END);
	  prompt=false;
	}
	if (cmd==EMACS_QUESTION){
#ifdef EMACS_DEBUG
	  logfile << "cmd: " << buffer << "\n" ;
#endif
	  if (buffer=="quit" || buffer=="quit;")
	    break;
	  if (buffer=="?")
	    buffer="?giac";
#ifdef HAVE_SIGNAL_H_OLD
	  giac::messages_to_print="";
#endif
	  giac::gen g(buffer,contextptr),gg;
	  
#ifdef HAVE_SIGNAL_H_OLD
	  if (inemacs && giac::messages_to_print.size()>1){
	    putchar(EMACS_DATA_BEGIN);
	    putchar(EMACS_ERROR);
	    printf("%s\n",giac::messages_to_print.c_str());
	    putchar(EMACS_DATA_END);
	  }
#endif
	  check_browser_help(g);
          if (inemacs){
            putchar(EMACS_DATA_BEGIN);
            putchar(EMACS_RESULT);
          }
	  // printf("%s\n",giac::messages_to_print.c_str());

	  // GEO SETUP?
	  if ( (g.type==giac::_SYMB) && (g._SYMBptr->sommet==giac::at_xyztrange) && (g._SYMBptr->feuille.type==giac::_VECT) && (g._SYMBptr->feuille._VECTptr->size()<12) ){
	    printf("Done\n");
	    putchar(EMACS_DATA_END); // end answer
#ifdef HAVE_LIBFLTK
	    xcas::Xcas_load_graph_setup(contextptr);
	    Fl::run();
	    Fl::wait(0.001);
#endif
	    giac::history_in(contextptr).push_back(g);
	    giac::history_out(contextptr).push_back(gg);
	    continue;
	  }

	  int reading_file=0;
	  std::string filename;
#ifdef HAVE_LIBFLTK
	  xcas::icas_eval(g,gg,reading_file,filename,contextptr);
	  if (reading_file>=1 || graph_output_type(gg)){
            if (inmcp){
              printf("Close the graphic window before running next command\n");
              putchar(EMACS_DATA_END);
              fflush(stdout);
              xcas::fltk_view(g,gg,"",filename,reading_file,contextptr);
            }
            else {
              printf(xcas::fltk_view(g,gg,"",filename,reading_file,contextptr)?"Done\n":"Plot cancelled or unable to plot\n");
              putchar(EMACS_DATA_END);
              fflush(stdout);
            }
          }
	  else {
	    giac::history_in(contextptr).push_back(g);
	    giac::history_out(contextptr).push_back(gg);
	    printf("%s\n",gg.print(contextptr).c_str());
            putchar(EMACS_DATA_END);
            fflush(stdout);
	  }
#else
          gg=eval(g,1,contextptr);
          giac::history_in(contextptr).push_back(g);
          giac::history_out(contextptr).push_back(gg);
          printf("%s\n",gg.print(contextptr).c_str());
	  putchar(EMACS_DATA_END);
          fflush(stdout);
#endif
#ifdef EMACS_DEBUG
	  logfile << "evaled: " << gg.print(contextptr) << "\n" ;
#endif
	}
      } // end normal command
    } // end while(1)
    end_icas();
    return 0;
  } // if (inemacs)
  /* END EMACS */

  /* *********************************************************
   *                       BEGIN TEXMACS                  *
   ********************************************************* */
  if (intexmacs){
    giac::html_help_init(ARGV[0],false);
    giac::enable_texmacs_compatible_latex_export(true);
#ifdef USE_GMP_REPLACEMENTS
    texmacs_image_file="casgraph";
#else
    texmacs_image_file=giac::temp_file_name("casgraph");
#endif
#ifdef WITH_GNUPLOT
    int out_handle;
    giac::run_gnuplot(out_handle);
#endif
    texmacs_begin();
    printf("verbatim:");
    format_plugin();
    texmacs_begin();
    printf("scheme:(hrule)");
    texmacs_end();
    printf("\nGiac %s for TeXmacs, released under the GPL license (3.0)\n",PACKAGE_VERSION);
    printf("See www.gnu.org for license details\n");
    printf("May contain BSD licensed software parts (lapack, atlas, tinymt)\n");
    printf("© 2003–2021 B. Parisse & al (giac), J. van der Hoeven (TeXmacs), L. Marohnić (interface)\n");
    texmacs_begin();
    printf("scheme:(hrule)");
    texmacs_end();
    printf("\n");
    switch (giac::xcas_mode(contextptr)){
    case 0:
      printf("Xcas (C-like) syntax mode\n");
      break;
    case 1:
      printf("Maple syntax mode\n");
      break;
    case 2:
      printf("MuPAD syntax mode\n");
      break;
    case 3:
      printf("TI89/92 syntax mode\n");
    } 
    printf("Type ? for documentation or ? NAME for help on NAME\n");
    printf("Type tabulation key to complete a partial command\n");
    texmacs_end();
    texmacs_next_input();
#ifdef __MINGW_H
    char buf[4096];
#endif
    while (1) {      
      string buffer;
#ifdef __MINGW_H
      cin.getline(buf,4096,'\n');
      buffer=string(buf);
#else
      char car;//,nxt;
      for (;;){
        int i=getchar();
        // cerr << i << '\n';
        if (i==EOF)
          break;
        car=i;
        if (car=='\n'){
#if !defined VISUALC
          giac::set_nonblock_flag(STDIN_FILENO,1); // set non blocking mode on stdin
#endif
          usleep(5000);
          // ssize_t s=read(STDIN_FILENO,&nxt,1);
          i=getchar();
#if !defined VISUALC
          giac::set_nonblock_flag(STDIN_FILENO,0); // set blocking mode on stdin
#endif
          // cerr << "read "  << s << '\n';
          if (i==EOF)
            break;
          buffer += car;
          car = i;
          buffer += car;
        }
        else
          buffer +=car;
      }
#endif
      // end read buffer
      if (buffer[0]==TEXMACS_DATA_COMMAND){
        int bs=buffer.size();
        --bs;
        buffer=buffer.substr(1,bs);
        int pos=buffer.find(' ');
        if (pos>0 && pos<bs-1){
          bs = bs-pos-1;
          buffer=buffer.substr(pos+1,bs);
          pos=buffer.find(' ');
          string complete_string=buffer.substr(1,pos-2);
          // search non ascii char starting from the end
          int ss=complete_string.size(),cs=ss;
          string partial_string;
          for (int i=ss-1;i>=0;--i){
            if (giac::isalphan(complete_string[i]))
              ;
            else
              break;
            partial_string=complete_string[i]+partial_string;
          }
          ss=partial_string.size();
          // remove beginning part
          buffer=buffer.substr(pos+1,bs-pos-2);
          int n=atoi(buffer.c_str());
          string cmd("(tuple ");
          cmd += '"'+complete_string.substr(0,n)+'"' ;
          n=n-(cs-ss);
          if (n>=0 && n<=cs){
            // reading possible completions from aide_cas
            vector<string> vres;
            string res=partial_string.substr(0,n);
            for (unsigned k=0;k<(*giac::vector_completions_ptr()).size();++k){
              if ((*giac::vector_completions_ptr())[k].substr(0,n)==res){
                vres.push_back((*giac::vector_completions_ptr())[k]);
              }
            }
            int vs=vres.size();
            for (int k=0;k<vs;k++){
              string & tmp=vres[k];
              cmd += " \""+tmp.substr(n,tmp.size()-n)+'"';
            }
            putchar(TEXMACS_DATA_BEGIN);
            printf("scheme:%s)",cmd.c_str());
            putchar(TEXMACS_DATA_END);
            flush_stdout();
          } 
          else {
            putchar(TEXMACS_DATA_BEGIN);
            printf("scheme:(tuple \"%s\" \"\")",complete_string.c_str());
            putchar(TEXMACS_DATA_END);
            flush_stdout();
          }
        }
        else {
          // should not happen
        }
        buffer="";
        continue;
      }
      if ( buffer=="quit") 
        break; // end of session
      // Begin answer
      putchar(TEXMACS_DATA_BEGIN);
      printf("verbatim:");
      // ONLINE HELP
      if (buffer=="?"){
#ifndef HAVE_NO_SYSTEM
        giac::system_browser_command("doc/index.html");
#endif
        buffer="?giac";
      }
#ifdef HAVE_SIGNAL_H_OLD
      giac::messages_to_print="";
#endif
      if (buffer=="xcas"){
#if 0 // def HAVE_LIBFLTK
	giac::gen ge; std::string filename;
	xcas::fltk_view(0,ge,"session.xws",filename,5,contextptr);
#else
        giac::system_browser_command("xcas.html");        
#endif
	continue;
      }
      giac::gen g(buffer,contextptr),gg;
#ifdef HAVE_SIGNAL_H_OLD
      printf("%s\n",giac::messages_to_print.c_str());
#endif
      check_browser_help(g);
      // END ONLINE HELP
      // GEO SETUP
      if ( (g.type==giac::_SYMB) && (g._SYMBptr->sommet==giac::at_xyztrange) && (g._SYMBptr->feuille.type==giac::_VECT) && (g._SYMBptr->feuille._VECTptr->size()<12) ){
#ifdef HAVE_LIBFLTK
        xcas::Xcas_load_graph_setup(contextptr);
        Fl::run();
        Fl::wait(0.001);
#endif
        giac::history_in(contextptr).push_back(g);
        giac::history_out(contextptr).push_back(gg);
        printf("Done\n");
        putchar(TEXMACS_DATA_BEGIN); 
        printf("latex:");
        printf("x_-=%.4f,x_+=%.4f,y_-=%.4f,y_+=%.4f",giac::gnuplot_xmin,giac::gnuplot_xmax,giac::gnuplot_ymin,giac::gnuplot_ymax);
        putchar(TEXMACS_DATA_END); 
        texmacs_counter++;
        putchar(TEXMACS_DATA_END); // end answer
        texmacs_next_input();
        continue;
      }
      // END GEO SETUP
      int reading_file=0;
      std::string filename;
#ifdef HAVE_LIBFLTK
      xcas::icas_eval(g,gg,reading_file,filename,contextptr);
#else
      gg=eval(g,1,contextptr);
#endif
      bool done=false;
      if (reading_file){ 
        if (reading_file>=2 || (giac::ckmatrix(gg,true)&&gg.subtype==giac::_SPREAD__VECT) ){
          texmacs_graph_output(g,gg,filename,reading_file,contextptr);
          done=true;
        }
        if (!done && g.type==giac::_VECT && gg.type==giac::_VECT){
          giac::vecteur & gv=*g._VECTptr;
          giac::vecteur & ggv=*gg._VECTptr;
          // check if ggv last element is geometric -> geo2d or geo3d
          int ggs=ggv.size();
          if (ggs && (graph_output_type(ggv[ggs-1])) ){
            texmacs_graph_output(g,gg,filename,reading_file,contextptr);
            done=true;
          }
          // output each component of the vector gg 1 by 1
          int s=min(gv.size(),ggv.size());
          for (int j=0;!done && j<s;++j){
            texmacs_output(gv[j],ggv[j],reading_file,texmacs_counter,contextptr);
            texmacs_counter++;
          }
          done = true;
        }
      }
      if (!done) {
#ifdef HAVE_LIBFLTK
        if (g.type==giac::_SYMB && gg.is_symb_of_sommet(giac::at_pnt) && gg.subtype>=0 && equalposcomp(giac::implicittex_plot_sommets,g._SYMBptr->sommet))
          ;// set_view_point(0,0); // FIXME
#endif
        texmacs_output(g,gg,false,0,contextptr);
        texmacs_counter++;
      }
      putchar(TEXMACS_DATA_END); // end answer
      texmacs_next_input();
    }
#ifdef WITH_GNUPLOT
    if (giac::has_gnuplot)
      giac::kill_gnuplot();
#endif
    end_icas();
    return 0;
  }
  /* *********************************************************
   *                       END OF TEXMACS                  *
   ********************************************************* */
#endif // EMCC/EMCC2/... not defined

  if (insage || getenv("GIAC_NO_TIME"))
    show_time=false;
  if (getenv("GIAC_TIME"))
    show_time=true;
  if (getenv("GIAC_TEX")){
    cerr << "// Setting tex log" << '\n';
    show_tex=true;
  }
#ifdef HAVE_LIBMICROPYTHON
  if (getenv("GIAC_MICROPY")){
    cerr << "Micropython mode\n";
    python_compat(4 | python_compat(contextptr),contextptr);
    if (ARGC==2){
      python_console()="";
      micropy_ck_eval(ARGV[1]);
      cout << python_console() ;
      if (filestream)
        filestream->close();
      end_icas();
      return 0;
    }
  }
#endif
#ifdef HAVE_LIBREADLINE
  if (ARGC==1){
    int taillemax=1000;
    if (getenv("GIAC_TAILLEMAX"))
      taillemax=atoi(getenv("GIAC_TAILLEMAX"));
#ifndef HAVE_NO_SYS_TIMES_H
    struct tms start, end;
#else
    clock_t start, end;
#endif
    using_history();
    giac::html_help_init("aide_cas",giac::language(contextptr));
    cout << gettext("Welcome to giac readline interface, version ") << GIAC_VERSION << '\n';
    cout << "(c) 2002,2023 B. Parisse & others" << '\n';
    cout << "Homepage https://www-fourier.univ-grenoble-alpes.fr/~parisse/giac.html" << '\n';
    cout << "Released under the GPL license 3.0 or above" << '\n';
    cout << "See http://www.gnu.org for license details" << '\n';
    cout << "May contain BSD licensed software parts (lapack, atlas, tinymt)" << '\n';
    cout << "-------------------------------------------------" << '\n';
#ifdef __MINGW_H
    cout << "Press CTRL and C or D simultaneously to finish session" << '\n';
#else
    cout << "Press CTRL and D simultaneously to finish session" << '\n';
#endif
    cout << "Type ?commandname for help" << '\n';
#ifdef HAVE_LIBFLTK
    cout << gettext("*** Type xcas to launch a light version of Xcas ***\n");
#endif
    for (int count=0;;++count) {
      char * res=rl_gets(count);
      if (!res)
	break;
      string s(res);
      int bs=s.size();
      if (s=="python"){
#ifdef HAVE_LIBMICROPYTHON
	python_compat(4 | python_compat(contextptr),contextptr);
	printf("%s\n","MicroPython 1.12");
#else
	printf("%s\n","MicroPython support not compiled");
#endif
	continue;
      }
#if 0 // def HAVE_LIBFLTK
      if (s=="!xcas"){
	system("./xcas");
	printf("%s\n","Running ./xcas");
	continue;
      }
      if (s=="xcas"){
	giac::gen ge; std::string filename;
	xcas::fltk_view(0,ge,"session.xws",filename,5,contextptr);
	continue;
      }
#else
      if (s=="xcas"){
        giac::system_browser_command("xcas.html");
        continue;
      }
#endif
      if (s=="giac"){
	python_compat(python_compat(contextptr)&3,contextptr);
	printf("%s\n","Switching to giac interpreter");
	continue;
      }
      if (s=="js"){
#ifdef QUICKJS
	python_compat(-1,contextptr);
	printf("%s\n","QuickJS");
#else
	printf("%s\n","QuickJS support not compiled");
#endif
	continue;
      }
      // changes suggested by V. Ledda
      // empty string
      if (s=="")
        continue;
      // comment string
      if ( (s.size()>=2 && s.substr(0,2)=="//")
#ifdef HAVE_REGEX           
           || std::regex_match (s, std::regex("\\s*/\\*.*\\*/.*|\\s*//.*") )
#endif
        ){
        printf("%s\n",s.c_str());
        continue;
      }
      // end
      if (micropyjs_evaled(s,contextptr))
	continue;
      if (insage && bs && s[bs-1]==63){
	string complete_string(s.substr(0,bs-1));
	// search non ascii char starting from the end
	int bs=complete_string.size();
	string partial_string;
	for (int i=bs-1;i>=0;--i){
	  if (giac::isalphan(complete_string[i]))
	    ;
	  else {
	    complete_string=complete_string.substr(i+1,bs-i-1);
	    break;
	  }
	}
	bs=complete_string.size();
	// reading pobsible completions from aide_cas
	vector<string> vres;
	for (unsigned k=0;k<(*giac::vector_completions_ptr()).size();++k){
	  if ((*giac::vector_completions_ptr())[k].substr(0,bs)==complete_string){
	    vres.push_back((*giac::vector_completions_ptr())[k]);
	  }
	}
	int vs=vres.size();
	for (int k=0;k<vs;k++){
	  string & tmp=vres[k];
	  printf("%s\n",tmp.c_str());
	}
	printf("%s","----\n");
	continue;
      }
      s += '\n';
#ifdef HAVE_SIGNAL_H_OLD
      giac::messages_to_print="";
#endif
      giac::gen gq(s,contextptr),ge;
      if (giac::python_compat(contextptr))
	gq=giac::equaltosto(gq,contextptr);
      if (giac::first_error_line(contextptr)){
	cout << parser_error(contextptr);
      }
      giac::ctrl_c=false; giac::interrupted=false;
      int reading_file=0;
      std::string filename;
#ifdef __APPLE__
      unsigned startc=clock();
#endif
#ifndef HAVE_NO_SYS_TIMES_H
      times(&start);
#else
      start=clock();
#endif
      xcas::icas_eval(gq,ge,reading_file,filename,contextptr);
#ifdef __APPLE_
      startc=clock()-startc;
#endif
#ifndef HAVE_NO_SYS_TIMES_H
      times(&end);
#else
      end=clock();
#endif
      giac::history_in(contextptr).push_back(gq);
      giac::history_out(contextptr).push_back(ge);
      // 2-d plot?
      int graph_output=graph_output_type(ge);
      if (reading_file>=2 || graph_output || (giac::ckmatrix(ge,true) &&ge.subtype==giac::_SPREAD__VECT) ){
#ifdef HAVE_LIBFLTK
	if (xcas::fltk_view(gq,ge,"",filename,reading_file,contextptr))
	  cout << "Done";
	else
#endif
	  cout << "Plot cancelled or unable to plot";
      }
      else {
	string s=(!insage && taille(ge,taillemax)>taillemax)?"Done":ge.print(contextptr);
	cout << s;
      }
      cout << '\n';
#ifdef HAVE_SIGNAL_H_OLD
      cerr << giac::messages_to_print << '\n';
#endif
      if (show_time){
#ifdef __APPLE__
	cerr << "// dclock1 " << double(startc)/CLOCKS_PER_SEC << '\n';
#endif
	cerr << "// Time " << giac::delta_tms(start,end) << '\n';
      }
#ifdef HAVE_EQASCII
      struct Tgraph *graph=(Tgraph *)malloc(sizeof(struct Tgraph));
      char **screen;
      int i, j;
      graph->up = 0;
      graph->down = 0;
      graph->children = 0;
      string ges(ge.print(contextptr));
      dim (preparse ((char *)ges.c_str()), graph);
      screen = draw (graph);
      for (i = 0; i < graph->dim.y; i++)
	{
	  for (j = 0; j < graph->dim.x; j++)
	    printf ("%c", screen[i][j]);
	  printf ("\n");
	}
      dealloc(graph); 
#endif // HAVE_EQASCII
    }
#ifdef WITH_GNUPLOT
    if (giac::has_gnuplot)
      giac::kill_gnuplot();
#endif
    end_icas();
    return 0;
  }
#endif // HAVE_LIBREADLINE
  int command=0;
  bool showcommand=false;
  if (getenv("GIAC_SHOWCOMMAND"))
    showcommand=true;
  string s(ARGV[0]);
  // keep only what remains after the last / of s
  string t;
  giac::gen u;
  for (int i=s.size()-1;i>=0;--i){
    if (s[i]!='/')
      t=s[i]+t;
    else
      break;
  }
  if (t=="cas2tex"){
    command=-1;
    cout << giac::tex_preamble ;
  }
  else {
    if ( t=="icas" || t=="maplec" || t=="mupadc" || t=="giac" ){
      command=0;
      if (t=="maplec")
	giac::xcas_mode(contextptr)=1;
      if (t=="mupadc")
	giac::xcas_mode(contextptr)=2;
    }
    else {
      command=1;
      t = "'"+t+"'";
      u=giac::gen(t,contextptr);
      if (u.type!=giac::_FUNC)
	command=0;
    }
  }
  ofstream texlog("session.tex",ios::app);
  giac::vecteur v;
  giac::gen e;
#if defined VISUALC || defined __MINGW_H
  int f1,f2;
  string st;
#else
  timeval tt; // get time info for label initialization
  gettimeofday(&tt,0);
  giac::gen et((int) tt.tv_sec);
  string st(et.print(contextptr));
  struct tms start, end,f1,f2;  
  times(&start);
  f2=start;
#endif
  //xcas_mode(contextptr)=1;
  //rpn_mode=true;
#ifdef HAVE_SIGNAL_H_OLD
  giac::messages_to_print="";
#endif
  if (ARGC==2)
    giac::parser_filename(ARGV[1],contextptr);
  giac::readargs(ARGC,ARGV,v,contextptr);
#ifdef HAVE_SIGNAL_H_OLD
  cerr << giac::messages_to_print << '\n';
  bool resultat=(giac::messages_to_print=="\n");
#else
  bool resultat=false;
#endif
  giac::vecteur::const_iterator it=v.begin(),itend=v.end();
  for (int i=0;it!=itend;++it,++i){
#ifdef HAVE_SIGNAL_H_OLD
    giac::messages_to_print = "";
#endif
    f1=f2;
    giac::gen gq(*it);
    giac::history_in(contextptr).push_back(gq);
    int reading_file=0;
    std::string filename;
    unsigned startc;
    if (command==-1){
      cout << "\\begin{equation} \\label{eq:d_" << st << "_" << i << "}" << '\n';
      cout << giac::gen2tex(gq,contextptr)  ;
#ifdef __APPLE__
      startc=clock();
#endif
#ifdef HAVE_LIBFLTK
      xcas::icas_eval(gq,e,reading_file,filename,contextptr);
#else
      e=eval(gq,1,contextptr);
#endif
#ifdef __APPLE__
      startc=clock()-startc;
#endif
#ifdef HAVE_SIGNAL_H_OLD
      if (!giac::messages_to_print.empty())
	cerr << giac::messages_to_print << '\n';
#endif
      if ((gq.type==giac::_SYMB) && (gq!=e))
	cout << " = " << giac::gen2tex(e,contextptr) ;
      cout << " \\end{equation} " << '\n';
    }
    else {
      if (command>0)
	gq=giac::symbolic(*u._FUNCptr,gq);
#ifdef __APPLE__
      startc=clock();
#endif
#ifndef EMCC2
      xcas::icas_eval(gq,e,reading_file,filename,contextptr);
#else
      e=eval(gq,1,contextptr);
#endif
#ifdef __APPLE__
      startc=clock()-startc;
#endif
#ifdef HAVE_SIGNAL_H_OLD
      if (!giac::messages_to_print.empty())
	cerr << giac::messages_to_print << '\n';
#endif
      if (showcommand)
	cout << "// " << *it << '\n';
      cout << e.print(contextptr) ;
      if (it+1!=itend){
	if ( (it->type!=giac::_SYMB) || (it->_SYMBptr->sommet!=giac::at_comment)) 
	  cout << "," <<'\n' ;
      }
      else
	cout << '\n';
#if !defined VISUALC && ! defined __MINGW_H
      times(&f2);
      if (show_time){
#ifdef __APPLE__
	cerr << "// dclock2 " << double(startc)/CLOCKS_PER_SEC << '\n';
#endif
	cerr << "// Time " << giac::delta_tms(f1,f2) << '\n';
      }
#endif
      if (show_tex) { // append to session.tex
	texlog << "\\begin{equation} \\label{eq:d_" << st << "_" << i << "}" << '\n';
	texlog << giac::gen2tex(gq,contextptr);
	if ((gq.type==giac::_SYMB) && (gq!=e))
	  texlog << " = " << giac::gen2tex(e,contextptr) ;
	texlog << " \\end{equation} " << '\n';
      }
    } // end if (command==-1) else
    giac::history_out(contextptr).push_back(e); 
  }
  // cerr << messages_to_print << '\n';
  // ofstream ans((string("ans")+giac::cas_suffixe).c_str());
  // ans << e << '\n';
#if !defined VISUALC && !defined __MINGW_H
  times(&end);
  if (command==-1){
    cout << giac::tex_end << '\n';
    cout << "% Generated by cas2tex in " << giac::delta_tms(start,end) << '\n';
  }
  else {
    if (show_time)
      cerr << "// Total time " << giac::delta_tms(start,end) << '\n';
  }
#endif
#ifdef WITH_GNUPLOT
  giac::kill_gnuplot();
#endif
  if (filestream)
    filestream->close();
  end_icas();
  return resultat;
}
#endif // KHICAS
