// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v6.30.2
// source: cluster.proto

package gitalypb

import (
	raftpb "go.etcd.io/raft/v3/raftpb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReplicaType indicates whether a replica is a voter or learner in the Raft cluster
type ReplicaID_ReplicaType int32

const (
	// REPLICA_TYPE_UNSPECIFIED.
	ReplicaID_REPLICA_TYPE_UNSPECIFIED ReplicaID_ReplicaType = 0
	// REPLICA_TYPE_VOTER indicates a replica that can participate in Raft elections and voting.
	ReplicaID_REPLICA_TYPE_VOTER ReplicaID_ReplicaType = 1
	// REPLICA_TYPE_LEARNER indicates a replica that receives updates but cannot vote.
	ReplicaID_REPLICA_TYPE_LEARNER ReplicaID_ReplicaType = 2
)

// Enum value maps for ReplicaID_ReplicaType.
var (
	ReplicaID_ReplicaType_name = map[int32]string{
		0: "REPLICA_TYPE_UNSPECIFIED",
		1: "REPLICA_TYPE_VOTER",
		2: "REPLICA_TYPE_LEARNER",
	}
	ReplicaID_ReplicaType_value = map[string]int32{
		"REPLICA_TYPE_UNSPECIFIED": 0,
		"REPLICA_TYPE_VOTER":       1,
		"REPLICA_TYPE_LEARNER":     2,
	}
)

func (x ReplicaID_ReplicaType) Enum() *ReplicaID_ReplicaType {
	p := new(ReplicaID_ReplicaType)
	*p = x
	return p
}

func (x ReplicaID_ReplicaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicaID_ReplicaType) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[0].Descriptor()
}

func (ReplicaID_ReplicaType) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[0]
}

func (x ReplicaID_ReplicaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicaID_ReplicaType.Descriptor instead.
func (ReplicaID_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2, 0}
}

// RaftEntry encapsulates critical data for replication using etcd/raft library.
// It has a request ID allowing the primary to track when the action is
// effectively applied.
type RaftEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is the unique identifier for the Raft message. This ID is generated by
	// an in-memory event registry. Raft uses this ID to track the commit status
	// of a log entry.
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// data represents packed and serialized log data.
	Data          *RaftEntry_LogData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftEntry) Reset() {
	*x = RaftEntry{}
	mi := &file_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftEntry) ProtoMessage() {}

func (x *RaftEntry) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftEntry.ProtoReflect.Descriptor instead.
func (*RaftEntry) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *RaftEntry) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *RaftEntry) GetData() *RaftEntry_LogData {
	if x != nil {
		return x.Data
	}
	return nil
}

// RaftPartitionKey is a globally-unique identifier for a replicated partition.
// The replica which minted the partition is responsible for computing the RaftPartitionKey,
// which is a hash of the storage name and partition ID. The key is then consumed
// as-is by other replicas wishing to store the partition.
type RaftPartitionKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// value is the SHA256 digest of the storage name and partition ID of the
	// newly-minted partition.
	Value         string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftPartitionKey) Reset() {
	*x = RaftPartitionKey{}
	mi := &file_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftPartitionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftPartitionKey) ProtoMessage() {}

func (x *RaftPartitionKey) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftPartitionKey.ProtoReflect.Descriptor instead.
func (*RaftPartitionKey) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *RaftPartitionKey) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// ReplicaID uniquely identifies a replica in the Raft cluster.
// It combines partition information with node-specific details.
type ReplicaID struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// partition_key identifies which partition this replica belongs to.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,1,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// member_id is the unique identifier assigned by etcd/raft.
	MemberId uint64 `protobuf:"varint,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// storage_name is the name of the storage where this replica is hosted.
	StorageName string `protobuf:"bytes,3,opt,name=storage_name,json=storageName,proto3" json:"storage_name,omitempty"`
	// metadata contains replica information.
	Metadata *ReplicaID_Metadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// type indicates whether the replica is learner or voter.
	Type          ReplicaID_ReplicaType `protobuf:"varint,5,opt,name=type,proto3,enum=gitaly.ReplicaID_ReplicaType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicaID) Reset() {
	*x = ReplicaID{}
	mi := &file_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaID) ProtoMessage() {}

func (x *ReplicaID) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaID.ProtoReflect.Descriptor instead.
func (*ReplicaID) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ReplicaID) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *ReplicaID) GetMemberId() uint64 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *ReplicaID) GetStorageName() string {
	if x != nil {
		return x.StorageName
	}
	return ""
}

func (x *ReplicaID) GetMetadata() *ReplicaID_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ReplicaID) GetType() ReplicaID_ReplicaType {
	if x != nil {
		return x.Type
	}
	return ReplicaID_REPLICA_TYPE_UNSPECIFIED
}

// RaftMessageRequest is a request for the SendMessage RPC. It serves as a
// wrapper for raftpb.Message. etcd/raft's state machines on each member emit
// this message. Since Gitaly employs multi-raft, routing metadata is attached
// to ensure the message reaches the correct Raft group inside the receiving
// Gitaly server.
type RaftMessageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster to which this message belongs.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// replica_id uniquely identifies a replica in the Raft cluster.
	ReplicaId *ReplicaID `protobuf:"bytes,2,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	// message is the Raft message to be delivered.
	Message       *raftpb.Message `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftMessageRequest) Reset() {
	*x = RaftMessageRequest{}
	mi := &file_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftMessageRequest) ProtoMessage() {}

func (x *RaftMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftMessageRequest.ProtoReflect.Descriptor instead.
func (*RaftMessageRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *RaftMessageRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RaftMessageRequest) GetReplicaId() *ReplicaID {
	if x != nil {
		return x.ReplicaId
	}
	return nil
}

func (x *RaftMessageRequest) GetMessage() *raftpb.Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// RaftMessageResponse represents a response to the SendMessage RPC.
type RaftMessageResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftMessageResponse) Reset() {
	*x = RaftMessageResponse{}
	mi := &file_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftMessageResponse) ProtoMessage() {}

func (x *RaftMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftMessageResponse.ProtoReflect.Descriptor instead.
func (*RaftMessageResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{4}
}

// RaftSnapshotMessageRequest is the input to SendSnapshot RPC.
type RaftSnapshotMessageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to RaftSnapshotPayload:
	//
	//	*RaftSnapshotMessageRequest_RaftMsg
	//	*RaftSnapshotMessageRequest_Chunk
	RaftSnapshotPayload isRaftSnapshotMessageRequest_RaftSnapshotPayload `protobuf_oneof:"raft_snapshot_payload"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *RaftSnapshotMessageRequest) Reset() {
	*x = RaftSnapshotMessageRequest{}
	mi := &file_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftSnapshotMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftSnapshotMessageRequest) ProtoMessage() {}

func (x *RaftSnapshotMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftSnapshotMessageRequest.ProtoReflect.Descriptor instead.
func (*RaftSnapshotMessageRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *RaftSnapshotMessageRequest) GetRaftSnapshotPayload() isRaftSnapshotMessageRequest_RaftSnapshotPayload {
	if x != nil {
		return x.RaftSnapshotPayload
	}
	return nil
}

func (x *RaftSnapshotMessageRequest) GetRaftMsg() *RaftMessageRequest {
	if x != nil {
		if x, ok := x.RaftSnapshotPayload.(*RaftSnapshotMessageRequest_RaftMsg); ok {
			return x.RaftMsg
		}
	}
	return nil
}

func (x *RaftSnapshotMessageRequest) GetChunk() []byte {
	if x != nil {
		if x, ok := x.RaftSnapshotPayload.(*RaftSnapshotMessageRequest_Chunk); ok {
			return x.Chunk
		}
	}
	return nil
}

type isRaftSnapshotMessageRequest_RaftSnapshotPayload interface {
	isRaftSnapshotMessageRequest_RaftSnapshotPayload()
}

type RaftSnapshotMessageRequest_RaftMsg struct {
	// raft_msg is a wrapper for raftpb.Message
	RaftMsg *RaftMessageRequest `protobuf:"bytes,1,opt,name=raft_msg,json=raftMsg,proto3,oneof"`
}

type RaftSnapshotMessageRequest_Chunk struct {
	// chunk of snapshot data
	Chunk []byte `protobuf:"bytes,2,opt,name=chunk,proto3,oneof"`
}

func (*RaftSnapshotMessageRequest_RaftMsg) isRaftSnapshotMessageRequest_RaftSnapshotPayload() {}

func (*RaftSnapshotMessageRequest_Chunk) isRaftSnapshotMessageRequest_RaftSnapshotPayload() {}

// RaftSnapshotMessageResponse is the response to SendSnapshot RPC.
type RaftSnapshotMessageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// destination is where the snapshot is saved.
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// snapshot_size is the snapshot size in bytes.
	SnapshotSize  uint64 `protobuf:"varint,2,opt,name=snapshot_size,json=snapshotSize,proto3" json:"snapshot_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftSnapshotMessageResponse) Reset() {
	*x = RaftSnapshotMessageResponse{}
	mi := &file_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftSnapshotMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftSnapshotMessageResponse) ProtoMessage() {}

func (x *RaftSnapshotMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftSnapshotMessageResponse.ProtoReflect.Descriptor instead.
func (*RaftSnapshotMessageResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *RaftSnapshotMessageResponse) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *RaftSnapshotMessageResponse) GetSnapshotSize() uint64 {
	if x != nil {
		return x.SnapshotSize
	}
	return 0
}

// JoinClusterRequest is sent by the leader to a new node to join a specific partition.
type JoinClusterRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// partition_key identifies which partition the new node should join.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,1,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// leader_id is the Member ID of the current Raft group leader
	LeaderId uint64 `protobuf:"varint,2,opt,name=leader_id,json=leaderId,proto3" json:"leader_id,omitempty"`
	// member_id is the unique Raft member ID assigned by the leader for this replica.
	MemberId uint64 `protobuf:"varint,3,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// storage_name is the name of the storage where the replica should be created.
	StorageName string `protobuf:"bytes,4,opt,name=storage_name,json=storageName,proto3" json:"storage_name,omitempty"`
	// relative_path is the path within the storage where the partition data is located.
	RelativePath string `protobuf:"bytes,5,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// replicas contains the current list of all cluster members for routing table initialization.
	Replicas      []*ReplicaID `protobuf:"bytes,6,rep,name=replicas,proto3" json:"replicas,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinClusterRequest) Reset() {
	*x = JoinClusterRequest{}
	mi := &file_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinClusterRequest) ProtoMessage() {}

func (x *JoinClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinClusterRequest.ProtoReflect.Descriptor instead.
func (*JoinClusterRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *JoinClusterRequest) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *JoinClusterRequest) GetLeaderId() uint64 {
	if x != nil {
		return x.LeaderId
	}
	return 0
}

func (x *JoinClusterRequest) GetMemberId() uint64 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *JoinClusterRequest) GetStorageName() string {
	if x != nil {
		return x.StorageName
	}
	return ""
}

func (x *JoinClusterRequest) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *JoinClusterRequest) GetReplicas() []*ReplicaID {
	if x != nil {
		return x.Replicas
	}
	return nil
}

// JoinClusterResponse indicates the result of the join operation.
type JoinClusterResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinClusterResponse) Reset() {
	*x = JoinClusterResponse{}
	mi := &file_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinClusterResponse) ProtoMessage() {}

func (x *JoinClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinClusterResponse.ProtoReflect.Descriptor instead.
func (*JoinClusterResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{8}
}

// GetPartitionsRequest is the request for the GetPartitions RPC.
type GetPartitionsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster to query.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// partition_key is an optional filter to get information about a specific partition.
	// If not provided, returns information about all partitions.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// relative_path is an optional filter to get information about partitions containing
	// the specified repository relative path. When specified, this is mapped to a partition_key
	// internally, and the storage filter (if provided) is preserved.
	RelativePath string `protobuf:"bytes,3,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// storage is an optional filter to get information about partitions that have
	// replicas on the specified storage name. Can be combined with relative_path or partition_key.
	Storage string `protobuf:"bytes,4,opt,name=storage,proto3" json:"storage,omitempty"`
	// include_replica_details determines whether to include detailed replica state information.
	IncludeReplicaDetails bool `protobuf:"varint,5,opt,name=include_replica_details,json=includeReplicaDetails,proto3" json:"include_replica_details,omitempty"`
	// include_relative_paths determines whether to include the list of repository paths
	// for each partition in the response. Set to false if you only need partition counts
	// to reduce memory usage and improve performance.
	IncludeRelativePaths bool `protobuf:"varint,6,opt,name=include_relative_paths,json=includeRelativePaths,proto3" json:"include_relative_paths,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetPartitionsRequest) Reset() {
	*x = GetPartitionsRequest{}
	mi := &file_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionsRequest) ProtoMessage() {}

func (x *GetPartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionsRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionsRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *GetPartitionsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *GetPartitionsRequest) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *GetPartitionsRequest) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *GetPartitionsRequest) GetStorage() string {
	if x != nil {
		return x.Storage
	}
	return ""
}

func (x *GetPartitionsRequest) GetIncludeReplicaDetails() bool {
	if x != nil {
		return x.IncludeReplicaDetails
	}
	return false
}

func (x *GetPartitionsRequest) GetIncludeRelativePaths() bool {
	if x != nil {
		return x.IncludeRelativePaths
	}
	return false
}

// ClusterStatistics contains aggregated statistics about the entire cluster.
type ClusterStatistics struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// total_partitions is the total number of partitions in the cluster.
	TotalPartitions uint32 `protobuf:"varint,1,opt,name=total_partitions,json=totalPartitions,proto3" json:"total_partitions,omitempty"`
	// healthy_partitions is the number of partitions with a leader that has a configured address.
	// A partition is considered healthy if:
	// 1. It has a leader (leader_id != 0)
	// 2. The leader replica has metadata with a non-empty address
	// Note: This checks configuration presence, not actual reachability or operational status.
	HealthyPartitions uint32 `protobuf:"varint,2,opt,name=healthy_partitions,json=healthyPartitions,proto3" json:"healthy_partitions,omitempty"`
	// total_replicas is the total number of replicas across all partitions.
	TotalReplicas uint32 `protobuf:"varint,3,opt,name=total_replicas,json=totalReplicas,proto3" json:"total_replicas,omitempty"`
	// healthy_replicas is the number of replicas that have a configured address.
	// A replica is considered healthy if it has metadata with a non-empty address field.
	// Note: This checks configuration presence, not actual reachability or operational status.
	HealthyReplicas uint32 `protobuf:"varint,4,opt,name=healthy_replicas,json=healthyReplicas,proto3" json:"healthy_replicas,omitempty"`
	// storage_stats maps storage names (authorities) to their leader and replica counts.
	StorageStats  map[string]*ClusterStatistics_StorageStats `protobuf:"bytes,5,rep,name=storage_stats,json=storageStats,proto3" json:"storage_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterStatistics) Reset() {
	*x = ClusterStatistics{}
	mi := &file_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterStatistics) ProtoMessage() {}

func (x *ClusterStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterStatistics.ProtoReflect.Descriptor instead.
func (*ClusterStatistics) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *ClusterStatistics) GetTotalPartitions() uint32 {
	if x != nil {
		return x.TotalPartitions
	}
	return 0
}

func (x *ClusterStatistics) GetHealthyPartitions() uint32 {
	if x != nil {
		return x.HealthyPartitions
	}
	return 0
}

func (x *ClusterStatistics) GetTotalReplicas() uint32 {
	if x != nil {
		return x.TotalReplicas
	}
	return 0
}

func (x *ClusterStatistics) GetHealthyReplicas() uint32 {
	if x != nil {
		return x.HealthyReplicas
	}
	return 0
}

func (x *ClusterStatistics) GetStorageStats() map[string]*ClusterStatistics_StorageStats {
	if x != nil {
		return x.StorageStats
	}
	return nil
}

// GetPartitionsResponse is the response for the GetPartitions streaming RPC.
// Each response message contains information about a single partition.
type GetPartitionsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// partition_key identifies the partition this response describes.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// replicas contains information about all replicas in this partition.
	Replicas []*GetPartitionsResponse_ReplicaStatus `protobuf:"bytes,3,rep,name=replicas,proto3" json:"replicas,omitempty"`
	// leader_id is the member ID of the current leader, 0 if no leader.
	LeaderId uint64 `protobuf:"varint,4,opt,name=leader_id,json=leaderId,proto3" json:"leader_id,omitempty"`
	// term is the current Raft term for this partition.
	Term uint64 `protobuf:"varint,5,opt,name=term,proto3" json:"term,omitempty"`
	// index is the current Raft log index for this partition.
	Index uint64 `protobuf:"varint,6,opt,name=index,proto3" json:"index,omitempty"`
	// relative_path is the repository path for backward compatibility.
	RelativePath string `protobuf:"bytes,7,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// relative_paths contains the list of repository paths in this partition
	// when include_relative_paths is set to true in the request.
	RelativePaths []string `protobuf:"bytes,8,rep,name=relative_paths,json=relativePaths,proto3" json:"relative_paths,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPartitionsResponse) Reset() {
	*x = GetPartitionsResponse{}
	mi := &file_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionsResponse) ProtoMessage() {}

func (x *GetPartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionsResponse.ProtoReflect.Descriptor instead.
func (*GetPartitionsResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *GetPartitionsResponse) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *GetPartitionsResponse) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *GetPartitionsResponse) GetReplicas() []*GetPartitionsResponse_ReplicaStatus {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *GetPartitionsResponse) GetLeaderId() uint64 {
	if x != nil {
		return x.LeaderId
	}
	return 0
}

func (x *GetPartitionsResponse) GetTerm() uint64 {
	if x != nil {
		return x.Term
	}
	return 0
}

func (x *GetPartitionsResponse) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *GetPartitionsResponse) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *GetPartitionsResponse) GetRelativePaths() []string {
	if x != nil {
		return x.RelativePaths
	}
	return nil
}

// RaftClusterInfoRequest is the request for the GetClusterInfo RPC.
type RaftClusterInfoRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster to query.
	ClusterId     string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftClusterInfoRequest) Reset() {
	*x = RaftClusterInfoRequest{}
	mi := &file_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftClusterInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftClusterInfoRequest) ProtoMessage() {}

func (x *RaftClusterInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftClusterInfoRequest.ProtoReflect.Descriptor instead.
func (*RaftClusterInfoRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *RaftClusterInfoRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// RaftClusterInfoResponse is the response for the GetClusterInfo RPC.
type RaftClusterInfoResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// statistics contains aggregated cluster statistics.
	Statistics    *ClusterStatistics `protobuf:"bytes,2,opt,name=statistics,proto3" json:"statistics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftClusterInfoResponse) Reset() {
	*x = RaftClusterInfoResponse{}
	mi := &file_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftClusterInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftClusterInfoResponse) ProtoMessage() {}

func (x *RaftClusterInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftClusterInfoResponse.ProtoReflect.Descriptor instead.
func (*RaftClusterInfoResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *RaftClusterInfoResponse) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RaftClusterInfoResponse) GetStatistics() *ClusterStatistics {
	if x != nil {
		return x.Statistics
	}
	return nil
}

// LogData contains serialized log data, including the log entry itself
// and all attached files in the log entry's directory. These data are
// exchanged at the Transport layer before sending and after receiving
// messages. They remain transparent to the core Raft engine.
type RaftEntry_LogData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// local_path is the path to the staging log entry directory. Before the
	// request is sent to other nodes, this whole directory of the entry is
	// serialized. So, this field is only relevant to the primary node who
	// issues the request.
	LocalPath []byte `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3" json:"local_path,omitempty"`
	// packed is the serialized form of the log entry data. Transport
	// implementations populates this field before sending out messages to other
	// members of a Raft group.
	Packed        []byte `protobuf:"bytes,2,opt,name=packed,proto3" json:"packed,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftEntry_LogData) Reset() {
	*x = RaftEntry_LogData{}
	mi := &file_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftEntry_LogData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftEntry_LogData) ProtoMessage() {}

func (x *RaftEntry_LogData) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftEntry_LogData.ProtoReflect.Descriptor instead.
func (*RaftEntry_LogData) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RaftEntry_LogData) GetLocalPath() []byte {
	if x != nil {
		return x.LocalPath
	}
	return nil
}

func (x *RaftEntry_LogData) GetPacked() []byte {
	if x != nil {
		return x.Packed
	}
	return nil
}

// Metadata contains routing information for the replica.
type ReplicaID_Metadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// address is the network address of the replica.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicaID_Metadata) Reset() {
	*x = ReplicaID_Metadata{}
	mi := &file_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaID_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaID_Metadata) ProtoMessage() {}

func (x *ReplicaID_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaID_Metadata.ProtoReflect.Descriptor instead.
func (*ReplicaID_Metadata) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ReplicaID_Metadata) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// StorageStats contains statistics for a specific storage/authority.
type ClusterStatistics_StorageStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// leader_count is the number of partitions where this storage is the leader.
	LeaderCount uint32 `protobuf:"varint,1,opt,name=leader_count,json=leaderCount,proto3" json:"leader_count,omitempty"`
	// replica_count is the total number of replicas hosted on this storage.
	ReplicaCount  uint32 `protobuf:"varint,2,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterStatistics_StorageStats) Reset() {
	*x = ClusterStatistics_StorageStats{}
	mi := &file_cluster_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterStatistics_StorageStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterStatistics_StorageStats) ProtoMessage() {}

func (x *ClusterStatistics_StorageStats) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterStatistics_StorageStats.ProtoReflect.Descriptor instead.
func (*ClusterStatistics_StorageStats) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{10, 0}
}

func (x *ClusterStatistics_StorageStats) GetLeaderCount() uint32 {
	if x != nil {
		return x.LeaderCount
	}
	return 0
}

func (x *ClusterStatistics_StorageStats) GetReplicaCount() uint32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

// ReplicaStatus contains status information about a single replica.
type GetPartitionsResponse_ReplicaStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// replica_id uniquely identifies the replica.
	ReplicaId *ReplicaID `protobuf:"bytes,1,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	// is_leader indicates whether this replica is currently the leader.
	IsLeader bool `protobuf:"varint,2,opt,name=is_leader,json=isLeader,proto3" json:"is_leader,omitempty"`
	// is_healthy indicates whether the replica has a configured address.
	// Note: This checks configuration presence (metadata.address != ""), not actual
	// reachability or operational status. A replica marked as healthy may still be
	// unreachable due to network issues or being offline.
	IsHealthy bool `protobuf:"varint,3,opt,name=is_healthy,json=isHealthy,proto3" json:"is_healthy,omitempty"`
	// last_index is the index of the last log entry this replica has.
	LastIndex uint64 `protobuf:"varint,4,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
	// match_index is the highest log index known to be replicated on this replica.
	MatchIndex uint64 `protobuf:"varint,5,opt,name=match_index,json=matchIndex,proto3" json:"match_index,omitempty"`
	// state represents the Raft state of this replica (follower, candidate, leader).
	// Possible values: "StateFollower", "StateCandidate", "StateLeader", "StatePreCandidate"
	State         string `protobuf:"bytes,6,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPartitionsResponse_ReplicaStatus) Reset() {
	*x = GetPartitionsResponse_ReplicaStatus{}
	mi := &file_cluster_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPartitionsResponse_ReplicaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionsResponse_ReplicaStatus) ProtoMessage() {}

func (x *GetPartitionsResponse_ReplicaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionsResponse_ReplicaStatus.ProtoReflect.Descriptor instead.
func (*GetPartitionsResponse_ReplicaStatus) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{11, 0}
}

func (x *GetPartitionsResponse_ReplicaStatus) GetReplicaId() *ReplicaID {
	if x != nil {
		return x.ReplicaId
	}
	return nil
}

func (x *GetPartitionsResponse_ReplicaStatus) GetIsLeader() bool {
	if x != nil {
		return x.IsLeader
	}
	return false
}

func (x *GetPartitionsResponse_ReplicaStatus) GetIsHealthy() bool {
	if x != nil {
		return x.IsHealthy
	}
	return false
}

func (x *GetPartitionsResponse_ReplicaStatus) GetLastIndex() uint64 {
	if x != nil {
		return x.LastIndex
	}
	return 0
}

func (x *GetPartitionsResponse_ReplicaStatus) GetMatchIndex() uint64 {
	if x != nil {
		return x.MatchIndex
	}
	return 0
}

func (x *GetPartitionsResponse_ReplicaStatus) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

var File_cluster_proto protoreflect.FileDescriptor

var file_cluster_proto_rawDesc = string([]byte{
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x06, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x1a, 0x0a, 0x6c, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x11, 0x72, 0x61, 0x66, 0x74, 0x70, 0x62, 0x2f, 0x72, 0x61, 0x66, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8c, 0x01, 0x0a, 0x09, 0x52, 0x61, 0x66, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x1a, 0x40, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1d,
	0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x28, 0x0a, 0x10, 0x52, 0x61, 0x66, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xfa, 0x02, 0x0a, 0x09, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x12, 0x3d, 0x0a,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61,
	0x66, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49,
	0x44, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x49, 0x44, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x24, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x5d, 0x0a,
	0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x4f, 0x54, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x02, 0x22, 0x90, 0x01, 0x0a,
	0x12, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x72, 0x61, 0x66, 0x74, 0x70, 0x62, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x15, 0x0a, 0x13, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x1a, 0x52, 0x61, 0x66, 0x74, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x08, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6d, 0x73,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79,
	0x2e, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x72, 0x61, 0x66, 0x74, 0x4d, 0x73, 0x67, 0x12, 0x16,
	0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x17, 0x0a, 0x15, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22,
	0x64, 0x0a, 0x1b, 0x52, 0x61, 0x66, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x8a, 0x02, 0x0a, 0x12, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x0d,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x6c,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0x88, 0xc6, 0x2c,
	0x01, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x2d, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa1, 0x02, 0x0a, 0x14, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x3d, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c,
	0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12,
	0x36, 0x0a, 0x17, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x22, 0xd2, 0x03,
	0x0a, 0x11, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d,
	0x0a, 0x12, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12,
	0x50, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x1a, 0x56, 0x0a, 0x0c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x67, 0x0a, 0x11, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xa7, 0x04, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x08, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04,
	0x74, 0x65, 0x72, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x25, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x1a, 0xd3, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x30, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x52,
	0x09, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73,
	0x5f, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69,
	0x73, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x6c, 0x61, 0x73, 0x74,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x37, 0x0a, 0x16,
	0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x22, 0x73, 0x0a, 0x17, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x0a,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x32, 0xcf, 0x03, 0x0a, 0x0b, 0x52,
	0x61, 0x66, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x53, 0x65,
	0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61,
	0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52,
	0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x01, 0x10, 0x02, 0x28, 0x01, 0x12, 0x63,
	0x0a, 0x0c, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x22,
	0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x01, 0x10,
	0x02, 0x28, 0x01, 0x12, 0x50, 0x0a, 0x0b, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4a, 0x6f, 0x69, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b,
	0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28,
	0x04, 0x08, 0x01, 0x10, 0x02, 0x12, 0x58, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x02, 0x10, 0x02, 0x30, 0x01, 0x12,
	0x5b, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1e, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x02, 0x10, 0x02, 0x42, 0x34, 0x5a, 0x32,
	0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x69, 0x74, 0x6c, 0x61,
	0x62, 0x2d, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2f, 0x76, 0x31, 0x38,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_cluster_proto_rawDescOnce sync.Once
	file_cluster_proto_rawDescData []byte
)

func file_cluster_proto_rawDescGZIP() []byte {
	file_cluster_proto_rawDescOnce.Do(func() {
		file_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_cluster_proto_rawDesc), len(file_cluster_proto_rawDesc)))
	})
	return file_cluster_proto_rawDescData
}

var file_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_cluster_proto_goTypes = []any{
	(ReplicaID_ReplicaType)(0),                  // 0: gitaly.ReplicaID.ReplicaType
	(*RaftEntry)(nil),                           // 1: gitaly.RaftEntry
	(*RaftPartitionKey)(nil),                    // 2: gitaly.RaftPartitionKey
	(*ReplicaID)(nil),                           // 3: gitaly.ReplicaID
	(*RaftMessageRequest)(nil),                  // 4: gitaly.RaftMessageRequest
	(*RaftMessageResponse)(nil),                 // 5: gitaly.RaftMessageResponse
	(*RaftSnapshotMessageRequest)(nil),          // 6: gitaly.RaftSnapshotMessageRequest
	(*RaftSnapshotMessageResponse)(nil),         // 7: gitaly.RaftSnapshotMessageResponse
	(*JoinClusterRequest)(nil),                  // 8: gitaly.JoinClusterRequest
	(*JoinClusterResponse)(nil),                 // 9: gitaly.JoinClusterResponse
	(*GetPartitionsRequest)(nil),                // 10: gitaly.GetPartitionsRequest
	(*ClusterStatistics)(nil),                   // 11: gitaly.ClusterStatistics
	(*GetPartitionsResponse)(nil),               // 12: gitaly.GetPartitionsResponse
	(*RaftClusterInfoRequest)(nil),              // 13: gitaly.RaftClusterInfoRequest
	(*RaftClusterInfoResponse)(nil),             // 14: gitaly.RaftClusterInfoResponse
	(*RaftEntry_LogData)(nil),                   // 15: gitaly.RaftEntry.LogData
	(*ReplicaID_Metadata)(nil),                  // 16: gitaly.ReplicaID.Metadata
	(*ClusterStatistics_StorageStats)(nil),      // 17: gitaly.ClusterStatistics.StorageStats
	nil,                                         // 18: gitaly.ClusterStatistics.StorageStatsEntry
	(*GetPartitionsResponse_ReplicaStatus)(nil), // 19: gitaly.GetPartitionsResponse.ReplicaStatus
	(*raftpb.Message)(nil),                      // 20: raftpb.Message
}
var file_cluster_proto_depIdxs = []int32{
	15, // 0: gitaly.RaftEntry.data:type_name -> gitaly.RaftEntry.LogData
	2,  // 1: gitaly.ReplicaID.partition_key:type_name -> gitaly.RaftPartitionKey
	16, // 2: gitaly.ReplicaID.metadata:type_name -> gitaly.ReplicaID.Metadata
	0,  // 3: gitaly.ReplicaID.type:type_name -> gitaly.ReplicaID.ReplicaType
	3,  // 4: gitaly.RaftMessageRequest.replica_id:type_name -> gitaly.ReplicaID
	20, // 5: gitaly.RaftMessageRequest.message:type_name -> raftpb.Message
	4,  // 6: gitaly.RaftSnapshotMessageRequest.raft_msg:type_name -> gitaly.RaftMessageRequest
	2,  // 7: gitaly.JoinClusterRequest.partition_key:type_name -> gitaly.RaftPartitionKey
	3,  // 8: gitaly.JoinClusterRequest.replicas:type_name -> gitaly.ReplicaID
	2,  // 9: gitaly.GetPartitionsRequest.partition_key:type_name -> gitaly.RaftPartitionKey
	18, // 10: gitaly.ClusterStatistics.storage_stats:type_name -> gitaly.ClusterStatistics.StorageStatsEntry
	2,  // 11: gitaly.GetPartitionsResponse.partition_key:type_name -> gitaly.RaftPartitionKey
	19, // 12: gitaly.GetPartitionsResponse.replicas:type_name -> gitaly.GetPartitionsResponse.ReplicaStatus
	11, // 13: gitaly.RaftClusterInfoResponse.statistics:type_name -> gitaly.ClusterStatistics
	17, // 14: gitaly.ClusterStatistics.StorageStatsEntry.value:type_name -> gitaly.ClusterStatistics.StorageStats
	3,  // 15: gitaly.GetPartitionsResponse.ReplicaStatus.replica_id:type_name -> gitaly.ReplicaID
	4,  // 16: gitaly.RaftService.SendMessage:input_type -> gitaly.RaftMessageRequest
	6,  // 17: gitaly.RaftService.SendSnapshot:input_type -> gitaly.RaftSnapshotMessageRequest
	8,  // 18: gitaly.RaftService.JoinCluster:input_type -> gitaly.JoinClusterRequest
	10, // 19: gitaly.RaftService.GetPartitions:input_type -> gitaly.GetPartitionsRequest
	13, // 20: gitaly.RaftService.GetClusterInfo:input_type -> gitaly.RaftClusterInfoRequest
	5,  // 21: gitaly.RaftService.SendMessage:output_type -> gitaly.RaftMessageResponse
	7,  // 22: gitaly.RaftService.SendSnapshot:output_type -> gitaly.RaftSnapshotMessageResponse
	9,  // 23: gitaly.RaftService.JoinCluster:output_type -> gitaly.JoinClusterResponse
	12, // 24: gitaly.RaftService.GetPartitions:output_type -> gitaly.GetPartitionsResponse
	14, // 25: gitaly.RaftService.GetClusterInfo:output_type -> gitaly.RaftClusterInfoResponse
	21, // [21:26] is the sub-list for method output_type
	16, // [16:21] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_cluster_proto_init() }
func file_cluster_proto_init() {
	if File_cluster_proto != nil {
		return
	}
	file_lint_proto_init()
	file_cluster_proto_msgTypes[5].OneofWrappers = []any{
		(*RaftSnapshotMessageRequest_RaftMsg)(nil),
		(*RaftSnapshotMessageRequest_Chunk)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_cluster_proto_rawDesc), len(file_cluster_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cluster_proto_goTypes,
		DependencyIndexes: file_cluster_proto_depIdxs,
		EnumInfos:         file_cluster_proto_enumTypes,
		MessageInfos:      file_cluster_proto_msgTypes,
	}.Build()
	File_cluster_proto = out.File
	file_cluster_proto_goTypes = nil
	file_cluster_proto_depIdxs = nil
}
