/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tagged_file_sink = R"doc(A file sink that uses tags to save files.

The sink uses a tag with the key 'burst' to trigger the saving of the burst data to a new file. If the value of this tag is True, it will open a new file and start writing all incoming data to it. If the tag is False, it will close the file (if already opened). The file names are based on the time when the burst tag was seen. If there is an 'rx_time' tag (standard with UHD sources), that is used as the time. If no 'rx_time' tag is found, the new time is calculated based off the sample rate of the block.

Constructor Specific Documentation:

Build a tagged_file_sink block.

Args:
    itemsize : The item size of the input data stream.
    samp_rate : The sample rate used to determine the time difference between bursts)doc";


static const char* __doc_gr_blocks_tagged_file_sink_tagged_file_sink = R"doc()doc";


static const char* __doc_gr_blocks_tagged_file_sink_make = R"doc(A file sink that uses tags to save files.

The sink uses a tag with the key 'burst' to trigger the saving of the burst data to a new file. If the value of this tag is True, it will open a new file and start writing all incoming data to it. If the tag is False, it will close the file (if already opened). The file names are based on the time when the burst tag was seen. If there is an 'rx_time' tag (standard with UHD sources), that is used as the time. If no 'rx_time' tag is found, the new time is calculated based off the sample rate of the block.

Constructor Specific Documentation:

Build a tagged_file_sink block.

Args:
    itemsize : The item size of the input data stream.
    samp_rate : The sample rate used to determine the time difference between bursts)doc";
