{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Collects the parameters that are needed when stroking a path.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Structs.Stroke
    ( 

-- * Exported types
    Stroke(..)                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Gsk.Structs.Stroke#g:method:copy"), [free]("GI.Gsk.Structs.Stroke#g:method:free"), [toCairo]("GI.Gsk.Structs.Stroke#g:method:toCairo").
-- 
-- ==== Getters
-- [getDash]("GI.Gsk.Structs.Stroke#g:method:getDash"), [getDashOffset]("GI.Gsk.Structs.Stroke#g:method:getDashOffset"), [getLineCap]("GI.Gsk.Structs.Stroke#g:method:getLineCap"), [getLineJoin]("GI.Gsk.Structs.Stroke#g:method:getLineJoin"), [getLineWidth]("GI.Gsk.Structs.Stroke#g:method:getLineWidth"), [getMiterLimit]("GI.Gsk.Structs.Stroke#g:method:getMiterLimit").
-- 
-- ==== Setters
-- [setDash]("GI.Gsk.Structs.Stroke#g:method:setDash"), [setDashOffset]("GI.Gsk.Structs.Stroke#g:method:setDashOffset"), [setLineCap]("GI.Gsk.Structs.Stroke#g:method:setLineCap"), [setLineJoin]("GI.Gsk.Structs.Stroke#g:method:setLineJoin"), [setLineWidth]("GI.Gsk.Structs.Stroke#g:method:setLineWidth"), [setMiterLimit]("GI.Gsk.Structs.Stroke#g:method:setMiterLimit").

#if defined(ENABLE_OVERLOADING)
    ResolveStrokeMethod                     ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    StrokeCopyMethodInfo                    ,
#endif
    strokeCopy                              ,


-- ** equal #method:equal#

    strokeEqual                             ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    StrokeFreeMethodInfo                    ,
#endif
    strokeFree                              ,


-- ** getDash #method:getDash#

#if defined(ENABLE_OVERLOADING)
    StrokeGetDashMethodInfo                 ,
#endif
    strokeGetDash                           ,


-- ** getDashOffset #method:getDashOffset#

#if defined(ENABLE_OVERLOADING)
    StrokeGetDashOffsetMethodInfo           ,
#endif
    strokeGetDashOffset                     ,


-- ** getLineCap #method:getLineCap#

#if defined(ENABLE_OVERLOADING)
    StrokeGetLineCapMethodInfo              ,
#endif
    strokeGetLineCap                        ,


-- ** getLineJoin #method:getLineJoin#

#if defined(ENABLE_OVERLOADING)
    StrokeGetLineJoinMethodInfo             ,
#endif
    strokeGetLineJoin                       ,


-- ** getLineWidth #method:getLineWidth#

#if defined(ENABLE_OVERLOADING)
    StrokeGetLineWidthMethodInfo            ,
#endif
    strokeGetLineWidth                      ,


-- ** getMiterLimit #method:getMiterLimit#

#if defined(ENABLE_OVERLOADING)
    StrokeGetMiterLimitMethodInfo           ,
#endif
    strokeGetMiterLimit                     ,


-- ** new #method:new#

    strokeNew                               ,


-- ** setDash #method:setDash#

#if defined(ENABLE_OVERLOADING)
    StrokeSetDashMethodInfo                 ,
#endif
    strokeSetDash                           ,


-- ** setDashOffset #method:setDashOffset#

#if defined(ENABLE_OVERLOADING)
    StrokeSetDashOffsetMethodInfo           ,
#endif
    strokeSetDashOffset                     ,


-- ** setLineCap #method:setLineCap#

#if defined(ENABLE_OVERLOADING)
    StrokeSetLineCapMethodInfo              ,
#endif
    strokeSetLineCap                        ,


-- ** setLineJoin #method:setLineJoin#

#if defined(ENABLE_OVERLOADING)
    StrokeSetLineJoinMethodInfo             ,
#endif
    strokeSetLineJoin                       ,


-- ** setLineWidth #method:setLineWidth#

#if defined(ENABLE_OVERLOADING)
    StrokeSetLineWidthMethodInfo            ,
#endif
    strokeSetLineWidth                      ,


-- ** setMiterLimit #method:setMiterLimit#

#if defined(ENABLE_OVERLOADING)
    StrokeSetMiterLimitMethodInfo           ,
#endif
    strokeSetMiterLimit                     ,


-- ** toCairo #method:toCairo#

#if defined(ENABLE_OVERLOADING)
    StrokeToCairoMethodInfo                 ,
#endif
    strokeToCairo                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums

#endif

-- | Memory-managed wrapper type.
newtype Stroke = Stroke (SP.ManagedPtr Stroke)
    deriving (Eq)

instance SP.ManagedPtrNewtype Stroke where
    toManagedPtr (Stroke p) = p

foreign import ccall "gsk_stroke_get_type" c_gsk_stroke_get_type :: 
    IO GType

type instance O.ParentTypes Stroke = '[]
instance O.HasParentTypes Stroke

instance B.Types.TypedObject Stroke where
    glibType = c_gsk_stroke_get_type

instance B.Types.GBoxed Stroke

-- | Convert t'Stroke' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Stroke) where
    gvalueGType_ = c_gsk_stroke_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Stroke)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Stroke)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Stroke ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Stroke
type instance O.AttributeList Stroke = StrokeAttributeList
type StrokeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Stroke::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "line_width"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "line width of the stroke. Must be > 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Stroke" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_new" gsk_stroke_new :: 
    CFloat ->                               -- line_width : TBasicType TFloat
    IO (Ptr Stroke)

-- | Creates a new @GskStroke@ with the given /@lineWidth@/.
-- 
-- /Since: 4.14/
strokeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Float
    -- ^ /@lineWidth@/: line width of the stroke. Must be > 0
    -> m Stroke
    -- ^ __Returns:__ a new @GskStroke@
strokeNew lineWidth = liftIO $ do
    let lineWidth' = realToFrac lineWidth
    result <- gsk_stroke_new lineWidth'
    checkUnexpectedReturnNULL "strokeNew" result
    result' <- (wrapBoxed Stroke) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Stroke::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "other"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stroke to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Stroke" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_copy" gsk_stroke_copy :: 
    Ptr Stroke ->                           -- other : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO (Ptr Stroke)

-- | Creates a copy of a @GskStroke@.
-- 
-- /Since: 4.14/
strokeCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@other@/: the stroke to copy
    -> m Stroke
    -- ^ __Returns:__ a new @GskStroke@. Use 'GI.Gsk.Structs.Stroke.strokeFree' to free it
strokeCopy other = liftIO $ do
    other' <- unsafeManagedPtrGetPtr other
    result <- gsk_stroke_copy other'
    checkUnexpectedReturnNULL "strokeCopy" result
    result' <- (wrapBoxed Stroke) result
    touchManagedPtr other
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeCopyMethodInfo
instance (signature ~ (m Stroke), MonadIO m) => O.OverloadedMethod StrokeCopyMethodInfo Stroke signature where
    overloadedMethod = strokeCopy

instance O.OverloadedMethodInfo StrokeCopyMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeCopy"
        })


#endif

-- method Stroke::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_free" gsk_stroke_free :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO ()

-- | Frees a @GskStroke@.
-- 
-- /Since: 4.14/
strokeFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m ()
strokeFree self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    gsk_stroke_free self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod StrokeFreeMethodInfo Stroke signature where
    overloadedMethod = strokeFree

instance O.OverloadedMethodInfo StrokeFreeMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeFree"
        })


#endif

-- method Stroke::get_dash
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_dash"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the array returned"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_dash"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the array returned"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TFloat))
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_dash" gsk_stroke_get_dash :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    Ptr FCT.CSize ->                        -- n_dash : TBasicType TSize
    IO (Ptr CFloat)

-- | Gets the dash array in use.
-- 
-- /Since: 4.14/
strokeGetDash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m (Maybe [Float])
    -- ^ __Returns:__ 
    --   the dash array or @NULL@ if the dash array is empty
strokeGetDash self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    nDash <- allocMem :: IO (Ptr FCT.CSize)
    result <- gsk_stroke_get_dash self' nDash
    nDash' <- peek nDash
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (unpackMapStorableArrayWithLength realToFrac nDash') result'
        return result''
    touchManagedPtr self
    freeMem nDash
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StrokeGetDashMethodInfo
instance (signature ~ (m (Maybe [Float])), MonadIO m) => O.OverloadedMethod StrokeGetDashMethodInfo Stroke signature where
    overloadedMethod = strokeGetDash

instance O.OverloadedMethodInfo StrokeGetDashMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetDash",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetDash"
        })


#endif

-- method Stroke::get_dash_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_dash_offset" gsk_stroke_get_dash_offset :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO CFloat

-- | Gets the dash offset.
-- 
-- /Since: 4.14/
strokeGetDashOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m Float
    -- ^ __Returns:__ the dash offset
strokeGetDashOffset self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gsk_stroke_get_dash_offset self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeGetDashOffsetMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod StrokeGetDashOffsetMethodInfo Stroke signature where
    overloadedMethod = strokeGetDashOffset

instance O.OverloadedMethodInfo StrokeGetDashOffsetMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetDashOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetDashOffset"
        })


#endif

-- method Stroke::get_line_cap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "LineCap" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_line_cap" gsk_stroke_get_line_cap :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO CUInt

-- | Gets the line cap used.
-- 
-- See t'GI.Gsk.Enums.LineCap' for details.
-- 
-- /Since: 4.14/
strokeGetLineCap ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m Gsk.Enums.LineCap
    -- ^ __Returns:__ the line cap
strokeGetLineCap self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gsk_stroke_get_line_cap self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeGetLineCapMethodInfo
instance (signature ~ (m Gsk.Enums.LineCap), MonadIO m) => O.OverloadedMethod StrokeGetLineCapMethodInfo Stroke signature where
    overloadedMethod = strokeGetLineCap

instance O.OverloadedMethodInfo StrokeGetLineCapMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetLineCap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetLineCap"
        })


#endif

-- method Stroke::get_line_join
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "LineJoin" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_line_join" gsk_stroke_get_line_join :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO CUInt

-- | Gets the line join used.
-- 
-- See t'GI.Gsk.Enums.LineJoin' for details.
-- 
-- /Since: 4.14/
strokeGetLineJoin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m Gsk.Enums.LineJoin
    -- ^ __Returns:__ the line join
strokeGetLineJoin self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gsk_stroke_get_line_join self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeGetLineJoinMethodInfo
instance (signature ~ (m Gsk.Enums.LineJoin), MonadIO m) => O.OverloadedMethod StrokeGetLineJoinMethodInfo Stroke signature where
    overloadedMethod = strokeGetLineJoin

instance O.OverloadedMethodInfo StrokeGetLineJoinMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetLineJoin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetLineJoin"
        })


#endif

-- method Stroke::get_line_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_line_width" gsk_stroke_get_line_width :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO CFloat

-- | Gets the line width used.
-- 
-- /Since: 4.14/
strokeGetLineWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m Float
    -- ^ __Returns:__ the line width
strokeGetLineWidth self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gsk_stroke_get_line_width self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeGetLineWidthMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod StrokeGetLineWidthMethodInfo Stroke signature where
    overloadedMethod = strokeGetLineWidth

instance O.OverloadedMethodInfo StrokeGetLineWidthMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetLineWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetLineWidth"
        })


#endif

-- method Stroke::get_miter_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_get_miter_limit" gsk_stroke_get_miter_limit :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    IO CFloat

-- | Gets the miter limit.
-- 
-- /Since: 4.14/
strokeGetMiterLimit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> m Float
    -- ^ __Returns:__ the miter limit
strokeGetMiterLimit self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gsk_stroke_get_miter_limit self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StrokeGetMiterLimitMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod StrokeGetMiterLimitMethodInfo Stroke signature where
    overloadedMethod = strokeGetMiterLimit

instance O.OverloadedMethodInfo StrokeGetMiterLimitMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeGetMiterLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeGetMiterLimit"
        })


#endif

-- method Stroke::set_dash
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dash"
--           , argType = TCArray False (-1) 2 (TBasicType TFloat)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n  the array of dashes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_dash"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in @dash"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_dash"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in @dash"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_dash" gsk_stroke_set_dash :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    Ptr CFloat ->                           -- dash : TCArray False (-1) 2 (TBasicType TFloat)
    FCT.CSize ->                            -- n_dash : TBasicType TSize
    IO ()

-- | Sets the dash pattern to use.
-- 
-- A dash pattern is specified by an array of alternating non-negative
-- values. Each value provides the length of alternate \"on\" and \"off\"
-- portions of the stroke.
-- 
-- Each \"on\" segment will have caps applied as if the segment were a
-- separate contour. In particular, it is valid to use an \"on\" length
-- of 0 with 'GI.Gsk.Enums.LineCapRound' or 'GI.Gsk.Enums.LineCapSquare'
-- to draw dots or squares along a path.
-- 
-- If /@nDash@/ is 0, if all elements in /@dash@/ are 0, or if there are
-- negative values in /@dash@/, then dashing is disabled.
-- 
-- If /@nDash@/ is 1, an alternating \"on\" and \"off\" pattern with the
-- single dash length provided is assumed.
-- 
-- If /@nDash@/ is uneven, the dash array will be used with the first
-- element in /@dash@/ defining an \"on\" or \"off\" in alternating passes
-- through the array.
-- 
-- You can specify a starting offset into the dash with
-- 'GI.Gsk.Structs.Stroke.strokeSetDashOffset'.
-- 
-- /Since: 4.14/
strokeSetDash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Maybe ([Float])
    -- ^ /@dash@/: 
    --   the array of dashes
    -> m ()
strokeSetDash self dash = liftIO $ do
    let nDash = case dash of
            Nothing -> 0
            Just jDash -> fromIntegral $ P.length jDash
    self' <- unsafeManagedPtrGetPtr self
    maybeDash <- case dash of
        Nothing -> return FP.nullPtr
        Just jDash -> do
            jDash' <- (packMapStorableArray realToFrac) jDash
            return jDash'
    gsk_stroke_set_dash self' maybeDash nDash
    touchManagedPtr self
    freeMem maybeDash
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetDashMethodInfo
instance (signature ~ (Maybe ([Float]) -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetDashMethodInfo Stroke signature where
    overloadedMethod = strokeSetDash

instance O.OverloadedMethodInfo StrokeSetDashMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetDash",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetDash"
        })


#endif

-- method Stroke::set_dash_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "offset into the dash pattern"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_dash_offset" gsk_stroke_set_dash_offset :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    CFloat ->                               -- offset : TBasicType TFloat
    IO ()

-- | Sets the offset into the dash pattern where dashing should begin.
-- 
-- This is an offset into the length of the path, not an index into
-- the array values of the dash array.
-- 
-- See 'GI.Gsk.Structs.Stroke.strokeSetDash' for more details on dashing.
-- 
-- /Since: 4.14/
strokeSetDashOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Float
    -- ^ /@offset@/: offset into the dash pattern
    -> m ()
strokeSetDashOffset self offset = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let offset' = realToFrac offset
    gsk_stroke_set_dash_offset self' offset'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetDashOffsetMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetDashOffsetMethodInfo Stroke signature where
    overloadedMethod = strokeSetDashOffset

instance O.OverloadedMethodInfo StrokeSetDashOffsetMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetDashOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetDashOffset"
        })


#endif

-- method Stroke::set_line_cap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_cap"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LineCap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the line cap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_line_cap" gsk_stroke_set_line_cap :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    CUInt ->                                -- line_cap : TInterface (Name {namespace = "Gsk", name = "LineCap"})
    IO ()

-- | Sets the line cap to be used when stroking.
-- 
-- See t'GI.Gsk.Enums.LineCap' for details.
-- 
-- /Since: 4.14/
strokeSetLineCap ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Gsk.Enums.LineCap
    -- ^ /@lineCap@/: the line cap
    -> m ()
strokeSetLineCap self lineCap = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let lineCap' = (fromIntegral . fromEnum) lineCap
    gsk_stroke_set_line_cap self' lineCap'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetLineCapMethodInfo
instance (signature ~ (Gsk.Enums.LineCap -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetLineCapMethodInfo Stroke signature where
    overloadedMethod = strokeSetLineCap

instance O.OverloadedMethodInfo StrokeSetLineCapMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetLineCap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetLineCap"
        })


#endif

-- method Stroke::set_line_join
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_join"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LineJoin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the line join to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_line_join" gsk_stroke_set_line_join :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    CUInt ->                                -- line_join : TInterface (Name {namespace = "Gsk", name = "LineJoin"})
    IO ()

-- | Sets the line join to be used when stroking.
-- 
-- See t'GI.Gsk.Enums.LineJoin' for details.
-- 
-- /Since: 4.14/
strokeSetLineJoin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Gsk.Enums.LineJoin
    -- ^ /@lineJoin@/: the line join to use
    -> m ()
strokeSetLineJoin self lineJoin = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let lineJoin' = (fromIntegral . fromEnum) lineJoin
    gsk_stroke_set_line_join self' lineJoin'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetLineJoinMethodInfo
instance (signature ~ (Gsk.Enums.LineJoin -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetLineJoinMethodInfo Stroke signature where
    overloadedMethod = strokeSetLineJoin

instance O.OverloadedMethodInfo StrokeSetLineJoinMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetLineJoin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetLineJoin"
        })


#endif

-- method Stroke::set_line_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_width"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the line in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_line_width" gsk_stroke_set_line_width :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    CFloat ->                               -- line_width : TBasicType TFloat
    IO ()

-- | Sets the line width to be used when stroking.
-- 
-- The line width must be >= 0.
-- 
-- /Since: 4.14/
strokeSetLineWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Float
    -- ^ /@lineWidth@/: width of the line in pixels
    -> m ()
strokeSetLineWidth self lineWidth = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let lineWidth' = realToFrac lineWidth
    gsk_stroke_set_line_width self' lineWidth'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetLineWidthMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetLineWidthMethodInfo Stroke signature where
    overloadedMethod = strokeSetLineWidth

instance O.OverloadedMethodInfo StrokeSetLineWidthMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetLineWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetLineWidth"
        })


#endif

-- method Stroke::set_miter_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "limit"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the miter limit" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_set_miter_limit" gsk_stroke_set_miter_limit :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    CFloat ->                               -- limit : TBasicType TFloat
    IO ()

-- | Sets the miter limit to be used when stroking.
-- 
-- The miter limit is the distance from the corner where sharp
-- turns of joins get cut off.
-- 
-- The limit is specfied in units of line width and must be non-negative.
-- 
-- For joins of type 'GI.Gsk.Enums.LineJoinMiter' that exceed the miter limit,
-- the join gets rendered as if it was of type 'GI.Gsk.Enums.LineJoinBevel'.
-- 
-- /Since: 4.14/
strokeSetMiterLimit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Float
    -- ^ /@limit@/: the miter limit
    -> m ()
strokeSetMiterLimit self limit = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    let limit' = realToFrac limit
    gsk_stroke_set_miter_limit self' limit'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeSetMiterLimitMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m) => O.OverloadedMethod StrokeSetMiterLimitMethodInfo Stroke signature where
    overloadedMethod = strokeSetMiterLimit

instance O.OverloadedMethodInfo StrokeSetMiterLimitMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeSetMiterLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeSetMiterLimit"
        })


#endif

-- method Stroke::to_cairo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Stroke" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the cairo context to configure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_to_cairo" gsk_stroke_to_cairo :: 
    Ptr Stroke ->                           -- self : TInterface (Name {namespace = "Gsk", name = "Stroke"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    IO ()

-- | A helper function that sets the stroke parameters
-- of a cairo context from a @GskStroke@.
-- 
-- /Since: 4.14/
strokeToCairo ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Stroke
    -- ^ /@self@/: a stroke
    -> Cairo.Context.Context
    -- ^ /@cr@/: the cairo context to configure
    -> m ()
strokeToCairo self cr = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    cr' <- unsafeManagedPtrGetPtr cr
    gsk_stroke_to_cairo self' cr'
    touchManagedPtr self
    touchManagedPtr cr
    return ()

#if defined(ENABLE_OVERLOADING)
data StrokeToCairoMethodInfo
instance (signature ~ (Cairo.Context.Context -> m ()), MonadIO m) => O.OverloadedMethod StrokeToCairoMethodInfo Stroke signature where
    overloadedMethod = strokeToCairo

instance O.OverloadedMethodInfo StrokeToCairoMethodInfo Stroke where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Stroke.strokeToCairo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Stroke.html#v:strokeToCairo"
        })


#endif

-- method Stroke::equal
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "stroke1"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stroke2"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second stroke" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_stroke_equal" gsk_stroke_equal :: 
    Ptr () ->                               -- stroke1 : TBasicType TPtr
    Ptr () ->                               -- stroke2 : TBasicType TPtr
    IO CInt

-- | Checks if two strokes are identical.
-- 
-- /Since: 4.14/
strokeEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@stroke1@/: the first stroke
    -> Ptr ()
    -- ^ /@stroke2@/: the second stroke
    -> m Bool
    -- ^ __Returns:__ true if the two strokes are equal, false otherwise
strokeEqual stroke1 stroke2 = liftIO $ do
    result <- gsk_stroke_equal stroke1 stroke2
    let result' = (/= 0) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveStrokeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStrokeMethod "copy" o = StrokeCopyMethodInfo
    ResolveStrokeMethod "free" o = StrokeFreeMethodInfo
    ResolveStrokeMethod "toCairo" o = StrokeToCairoMethodInfo
    ResolveStrokeMethod "getDash" o = StrokeGetDashMethodInfo
    ResolveStrokeMethod "getDashOffset" o = StrokeGetDashOffsetMethodInfo
    ResolveStrokeMethod "getLineCap" o = StrokeGetLineCapMethodInfo
    ResolveStrokeMethod "getLineJoin" o = StrokeGetLineJoinMethodInfo
    ResolveStrokeMethod "getLineWidth" o = StrokeGetLineWidthMethodInfo
    ResolveStrokeMethod "getMiterLimit" o = StrokeGetMiterLimitMethodInfo
    ResolveStrokeMethod "setDash" o = StrokeSetDashMethodInfo
    ResolveStrokeMethod "setDashOffset" o = StrokeSetDashOffsetMethodInfo
    ResolveStrokeMethod "setLineCap" o = StrokeSetLineCapMethodInfo
    ResolveStrokeMethod "setLineJoin" o = StrokeSetLineJoinMethodInfo
    ResolveStrokeMethod "setLineWidth" o = StrokeSetLineWidthMethodInfo
    ResolveStrokeMethod "setMiterLimit" o = StrokeSetMiterLimitMethodInfo
    ResolveStrokeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStrokeMethod t Stroke, O.OverloadedMethod info Stroke p) => OL.IsLabel t (Stroke -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStrokeMethod t Stroke, O.OverloadedMethod info Stroke p, R.HasField t Stroke p) => R.HasField t Stroke p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStrokeMethod t Stroke, O.OverloadedMethodInfo info Stroke) => OL.IsLabel t (O.MethodProxy info Stroke) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


