/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_bdw.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_bdw.h"

static bool bdw_render_basic_Sampler0Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x09) {
        return true;
    }
    return false;
}
static bool bdw_render_basic_Sampler0Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x09) {
        return true;
    }
    return false;
}
static bool bdw_render_basic_Sampler1Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x12) {
        return true;
    }
    return false;
}
static bool bdw_render_basic_Sampler1Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x12) {
        return true;
    }
    return false;
}

static void
bdw_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "b541bd57-0e0f-4154-b4c0-5858010a2bf7";
    metric_set->counters = calloc(52, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Depth Throughput",
                .symbol_name = "GtiDepthThroughput",
                .desc = "The total number of GPU memory bytes transferred between depth caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_depth_throughput__read,
                .max_uint64 = bdw__render_basic__gti_depth_throughput__max,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GTI HDC TLB Lookup Throughput",
                .symbol_name = "GtiHdcLookupsThroughput",
                .desc = "The total number of GPU memory bytes transferred between GTI and HDC, when HDC is doing TLB lookups.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_hdc_lookups_throughput__read,
                .max_uint64 = bdw__render_basic__gti_hdc_lookups_throughput__max,
                .group = "GTI/L3",
            },

            {
                .name = "GTI L3 Throughput",
                .symbol_name = "GtiL3Throughput",
                .desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_l3_throughput__read,
                .max_uint64 = bdw__render_basic__gti_l3_throughput__max,
                .group = "GTI/L3",
            },

            {
                .name = "GTI RCC Throughput",
                .symbol_name = "GtiRccThroughput",
                .desc = "The total number of GPU memory bytes transferred between render color caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_rcc_throughput__read,
                .max_uint64 = bdw__render_basic__gti_rcc_throughput__max,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_read_throughput__read,
                .max_uint64 = bdw__render_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Fixed Pipe Throughput",
                .symbol_name = "GtiVfThroughput",
                .desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_vf_throughput__read,
                .max_uint64 = bdw__render_basic__gti_vf_throughput__max,
                .group = "GTI/3D Pipe",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__gti_write_throughput__read,
                .max_uint64 = bdw__render_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Lookup Accesses w/o IC",
                .symbol_name = "L3Lookups",
                .desc = "The total number of L3 cache lookup accesses w/o IC.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__l3_lookups__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/TAG",
            },

            {
                .name = "L3 Misses",
                .symbol_name = "L3Misses",
                .desc = "The total number of L3 misses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__l3_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/TAG",
            },

            {
                .name = "L3 Sampler Throughput",
                .symbol_name = "L3SamplerThroughput",
                .desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__l3_sampler_throughput__read,
                .max_uint64 = bdw__render_basic__l3_sampler_throughput__max,
                .group = "L3/Sampler",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__l3_shader_throughput__read,
                .max_uint64 = bdw__render_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler 0 Bottleneck",
                .symbol_name = "Sampler0Bottleneck",
                .desc = "The percentage of time in which Sampler 0 has been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__sampler0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = bdw_render_basic_Sampler0Bottleneck_availability,
            },

            {
                .name = "Sampler 0 Busy",
                .symbol_name = "Sampler0Busy",
                .desc = "The percentage of time in which Sampler 0 has been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__sampler0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = bdw_render_basic_Sampler0Busy_availability,
            },

            {
                .name = "Sampler 1 Bottleneck",
                .symbol_name = "Sampler1Bottleneck",
                .desc = "The percentage of time in which Sampler 1 has been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__sampler1_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = bdw_render_basic_Sampler1Bottleneck_availability,
            },

            {
                .name = "Sampler 1 Busy",
                .symbol_name = "Sampler1Busy",
                .desc = "The percentage of time in which Sampler 1 has been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__sampler1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = bdw_render_basic_Sampler1Busy_availability,
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
            },

            {
                .name = "Sampler Cache Misses",
                .symbol_name = "SamplerL1Misses",
                .desc = "The total number of sampler cache misses in all LODs in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__sampler_l1_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers have been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__slm_bytes_read__read,
                .max_uint64 = bdw__render_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_basic__slm_bytes_written__read,
                .max_uint64 = bdw__render_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_basic__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 52);
}


static void
bdw_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "35fbc9b2-a891-40a6-a38d-022bb7057552";
    metric_set->counters = calloc(39, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = bdw__compute_basic__eu_avg_ipc_rate__read,
                .max_float = bdw__compute_basic__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__gti_read_throughput__read,
                .max_uint64 = bdw__compute_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__gti_write_throughput__read,
                .max_uint64 = bdw__compute_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__l3_shader_throughput__read,
                .max_uint64 = bdw__compute_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__slm_bytes_read__read,
                .max_uint64 = bdw__compute_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__slm_bytes_written__read,
                .max_uint64 = bdw__compute_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Typed Bytes Read",
                .symbol_name = "TypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__typed_bytes_read__read,
                .max_uint64 = bdw__compute_basic__typed_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Bytes Written",
                .symbol_name = "TypedBytesWritten",
                .desc = "The total number of typed memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__typed_bytes_written__read,
                .max_uint64 = bdw__compute_basic__typed_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Bytes Read",
                .symbol_name = "UntypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__untyped_bytes_read__read,
                .max_uint64 = bdw__compute_basic__untyped_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes",
                .symbol_name = "UntypedBytesWritten",
                .desc = "The total number of untyped memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_basic__untyped_bytes_written__read,
                .max_uint64 = bdw__compute_basic__untyped_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 39);
}


static void
bdw_add_render_pipe_profile_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "233d0544-fff7-4281-8291-e02f222aff72";
    metric_set->counters = calloc(44, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_render_pipe_profile_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__render_pipe_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__render_pipe_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC Bottleneck",
                .symbol_name = "BcBottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__bc_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Barycentric Calc",
            },

            {
                .name = "Clipper Bottleneck",
                .symbol_name = "ClBottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__cl_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CL Stall",
                .symbol_name = "ClStall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__cl_stall__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Bottleneck",
                .symbol_name = "DsBottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__ds_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Stall",
                .symbol_name = "DsStall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__ds_stall__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Bottleneck",
                .symbol_name = "EarlyDepthBottleneck",
                .desc = "The percentage of time in which early depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__early_depth_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__render_pipe_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__render_pipe_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Bottleneck",
                .symbol_name = "GsBottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__gs_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Hi-Depth Bottleneck",
                .symbol_name = "HiDepthBottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__hi_depth_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Bottleneck",
                .symbol_name = "HsBottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__hs_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Stall",
                .symbol_name = "HsStall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__hs_stall__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_pipe_profile__l3_shader_throughput__read,
                .max_uint64 = bdw__render_pipe_profile__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Accesses",
                .symbol_name = "SamplerAccesses",
                .desc = "The total number of messages send to samplers.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_pipe_profile__sampler_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__render_pipe_profile__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__render_pipe_profile__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__render_pipe_profile__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Strip-Fans Bottleneck",
                .symbol_name = "SfBottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__sf_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "SF Stall",
                .symbol_name = "SfStall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__sf_stall__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_pipe_profile__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_pipe_profile__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__render_pipe_profile__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_pipe_profile__slm_bytes_read__read,
                .max_uint64 = bdw__render_pipe_profile__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__render_pipe_profile__slm_bytes_written__read,
                .max_uint64 = bdw__render_pipe_profile__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SO Bottleneck",
                .symbol_name = "SoBottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__so_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "SO Stall",
                .symbol_name = "SoStall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__so_stall__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "VF Bottleneck",
                .symbol_name = "VfBottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__vf_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Input Assembler",
            },

            {
                .name = "VS Bottleneck",
                .symbol_name = "VsBottleneck",
                .desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__render_pipe_profile__vs_bottleneck__read,
                .max_float = NULL /* undefined */,
                .group = "3D Pipe/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__render_pipe_profile__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}


static void
bdw_add_memory_reads_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Reads Distribution metric set";
    metric_set->symbol_name = "MemoryReads";
    metric_set->hw_config_guid = "2b255d48-2117-4fef-a8f7-f151e1d25a2c";
    metric_set->counters = calloc(42, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_memory_reads_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__memory_reads__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__memory_reads__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_reads__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_reads__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_reads__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__memory_reads__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__memory_reads__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GtiCmdStreamerMemoryReads",
                .symbol_name = "GtiCmdStreamerMemoryReads",
                .desc = "The total number of GTI memory reads from Command Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_cmd_streamer_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Command Streamer",
            },

            {
                .name = "GtiHizMemoryReads",
                .symbol_name = "GtiHizMemoryReads",
                .desc = "The total number of GTI memory reads from Hierarchical Depth Cache (Hi-Depth Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_hiz_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiL3Bank0Reads",
                .symbol_name = "GtiL3Bank0Reads",
                .desc = "The total number of GTI memory reads from L3 Bank 0 (L3 Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_l3_bank0_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank1Reads",
                .symbol_name = "GtiL3Bank1Reads",
                .desc = "The total number of GTI memory reads from L3 Bank 1 (L3 Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_l3_bank1_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank2Reads",
                .symbol_name = "GtiL3Bank2Reads",
                .desc = "The total number of GTI memory reads from L3 Bank 2 (L3 Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_l3_bank2_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank3Reads",
                .symbol_name = "GtiL3Bank3Reads",
                .desc = "The total number of GTI memory reads from L3 Bank 3 (L3 Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_l3_bank3_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Reads",
                .symbol_name = "GtiL3Reads",
                .desc = "The total number of GTI memory reads from L3 (L3 Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_l3_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiMemoryReads",
                .symbol_name = "GtiMemoryReads",
                .desc = "The total number of GTI memory reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiMscMemoryReads",
                .symbol_name = "GtiMscMemoryReads",
                .desc = "The total number of GTI memory reads from Multisampling Color Cache (Multisampling Color Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_msc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRccMemoryReads",
                .symbol_name = "GtiRccMemoryReads",
                .desc = "The total number of GTI memory reads from Render Color Cache (Render Color Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_rcc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRczMemoryReads",
                .symbol_name = "GtiRczMemoryReads",
                .desc = "The total number of GTI memory reads from Render Depth Cache (Render Depth Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_rcz_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiRingAccesses",
                .symbol_name = "GtiRingAccesses",
                .desc = "The total number of all accesses from GTI to the ring.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_ring_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiRsMemoryReads",
                .symbol_name = "GtiRsMemoryReads",
                .desc = "The total number of GTI memory reads from Resource Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_rs_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Resource Streamer",
            },

            {
                .name = "GtiStcMemoryReads",
                .symbol_name = "GtiStcMemoryReads",
                .desc = "The total number of GTI memory reads from Stencil Cache (Stencil Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_stc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiVfMemoryReads",
                .symbol_name = "GtiVfMemoryReads",
                .desc = "The total number of GTI memory reads from Vertex Fetch.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__gti_vf_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Vertex Fetch",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_reads__l3_shader_throughput__read,
                .max_uint64 = bdw__memory_reads__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__memory_reads__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__memory_reads__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_reads__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_reads__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_reads__slm_bytes_read__read,
                .max_uint64 = bdw__memory_reads__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_reads__slm_bytes_written__read,
                .max_uint64 = bdw__memory_reads__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_reads__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 42);
}


static void
bdw_add_memory_writes_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Writes Distribution metric set";
    metric_set->symbol_name = "MemoryWrites";
    metric_set->hw_config_guid = "f7fd3220-b466-4a4d-9f98-b0caf3f2394c";
    metric_set->counters = calloc(41, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_memory_writes_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__memory_writes__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__memory_writes__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_writes__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_writes__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__memory_writes__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__memory_writes__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__memory_writes__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GtiCmdStreamerMemoryWrites",
                .symbol_name = "GtiCmdStreamerMemoryWrites",
                .desc = "The total number of GTI memory writes from Command Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_cmd_streamer_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Command Streamer",
            },

            {
                .name = "GtiHizMemoryWrites",
                .symbol_name = "GtiHizMemoryWrites",
                .desc = "The total number of GTI memory writes from Hierarchical Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_hiz_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiL3Bank0Writes",
                .symbol_name = "GtiL3Bank0Writes",
                .desc = "The total number of GTI memory writes from L3 Bank 0 (L3 Bank 0 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_l3_bank0_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank1Writes",
                .symbol_name = "GtiL3Bank1Writes",
                .desc = "The total number of GTI memory writes from L3 Bank 1 (L3 Bank 1 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_l3_bank1_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank2Writes",
                .symbol_name = "GtiL3Bank2Writes",
                .desc = "The total number of GTI memory writes from L3 Bank 2 (L3 Bank 2 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_l3_bank2_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Bank3Writes",
                .symbol_name = "GtiL3Bank3Writes",
                .desc = "The total number of GTI memory writes from L3 Bank 3 (L3 Bank 3 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_l3_bank3_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiL3Writes",
                .symbol_name = "GtiL3Writes",
                .desc = "The total number of GTI memory writes from L3 (L3 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_l3_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiMemoryWrites",
                .symbol_name = "GtiMemoryWrites",
                .desc = "The total number of GTI memory writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiMscMemoryWrites",
                .symbol_name = "GtiMscMemoryWrites",
                .desc = "The total number of GTI memory writes from Multisampling Color Cache (Multisampling Color Cache invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_msc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRccMemoryWrites",
                .symbol_name = "GtiRccMemoryWrites",
                .desc = "The total number of GTI memory writes from Render Color Cache (Render Color Cache invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_rcc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRczMemoryWrites",
                .symbol_name = "GtiRczMemoryWrites",
                .desc = "The total number of GTI memory writes from Render Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_rcz_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiRingAccesses",
                .symbol_name = "GtiRingAccesses",
                .desc = "The total number of all GTI accesses to the ring.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_ring_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiSoMemoryWrites",
                .symbol_name = "GtiSoMemoryWrites",
                .desc = "The total number of GTI memory writes from Stream Output.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_so_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Stream Output",
            },

            {
                .name = "GtiStcMemoryWrites",
                .symbol_name = "GtiStcMemoryWrites",
                .desc = "The total number of GTI memory writes from Stencil Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__gti_stc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_writes__l3_shader_throughput__read,
                .max_uint64 = bdw__memory_writes__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__memory_writes__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__memory_writes__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__memory_writes__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__memory_writes__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_writes__slm_bytes_read__read,
                .max_uint64 = bdw__memory_writes__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__memory_writes__slm_bytes_written__read,
                .max_uint64 = bdw__memory_writes__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__memory_writes__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 41);
}


static void
bdw_add_compute_extended_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Extended metric set";
    metric_set->symbol_name = "ComputeExtended";
    metric_set->hw_config_guid = "e99ccaca-821c-4df9-97a7-96bdb7204e43";
    metric_set->counters = calloc(38, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_compute_extended_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__compute_extended__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__compute_extended__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_extended__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "EuA64UntypedReads0",
                .symbol_name = "EuA64UntypedReads0",
                .desc = "The subslice 0 EU A64 Untyped Reads subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_a64_untyped_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuA64UntypedWrites0",
                .symbol_name = "EuA64UntypedWrites0",
                .desc = "The subslice 0 EU A64 Untyped Writes subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_a64_untyped_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = bdw__compute_extended__eu_avg_ipc_rate__read,
                .max_float = bdw__compute_extended__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EuTypedAtomics0",
                .symbol_name = "EuTypedAtomics0",
                .desc = "The subslice 0 EU Typed Atomics subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_typed_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuTypedReads0",
                .symbol_name = "EuTypedReads0",
                .desc = "The subslice 0 EU Typed Reads subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_typed_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuTypedWrites0",
                .symbol_name = "EuTypedWrites0",
                .desc = "The subslice 0 EU Typed Writes subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_typed_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedAtomics0",
                .symbol_name = "EuUntypedAtomics0",
                .desc = "The subslice 0 EU Untyped Atomics subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_untyped_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedReads0",
                .symbol_name = "EuUntypedReads0",
                .desc = "The subslice 0 EU Untyped Reads subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_untyped_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedWrites0",
                .symbol_name = "EuUntypedWrites0",
                .desc = "The subslice 0 EU Untyped Writes subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__eu_untyped_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extended__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__compute_extended__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__compute_extended__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_extended__l3_shader_throughput__read,
                .max_uint64 = bdw__compute_extended__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_extended__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_extended__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_extended__slm_bytes_read__read,
                .max_uint64 = bdw__compute_extended__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_extended__slm_bytes_written__read,
                .max_uint64 = bdw__compute_extended__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Typed Atomics 0",
                .symbol_name = "TypedAtomics0",
                .desc = "The subslice 0 typed atomics.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__typed_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedAtomicsPerCacheLine",
                .symbol_name = "TypedAtomicsPerCacheLine",
                .desc = "Ratio of EU typed atomics requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_ATOMIC_REQUESTS_TO_L3_CACHE_LINES,
                .read_float = bdw__compute_extended__typed_atomics_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Reads 0",
                .symbol_name = "TypedReads0",
                .desc = "The subslice 0 typed reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__typed_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedReadsPerCacheLine",
                .symbol_name = "TypedReadsPerCacheLine",
                .desc = "Ratio of EU typed read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_REQUESTS_TO_L3_CACHE_LINES,
                .read_float = bdw__compute_extended__typed_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Writes 0",
                .symbol_name = "TypedWrites0",
                .desc = "The subslice 0 typed writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__typed_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedWritesPerCacheLine",
                .symbol_name = "TypedWritesPerCacheLine",
                .desc = "Ratio of EU typed write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_REQUESTS_TO_L3_CACHE_LINES,
                .read_float = bdw__compute_extended__typed_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Reads 0",
                .symbol_name = "UntypedReads0",
                .desc = "The subslice 0 untyped reads (including SLM reads).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__untyped_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "UntypedReadsPerCacheLine",
                .symbol_name = "UntypedReadsPerCacheLine",
                .desc = "Ratio of EU untyped read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_REQUESTS_TO_L3_CACHE_LINES,
                .read_float = bdw__compute_extended__untyped_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes 0",
                .symbol_name = "UntypedWrites0",
                .desc = "The subslice 0 untyped writes (including SLM writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_extended__untyped_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "UntypedWritesPerCacheLine",
                .symbol_name = "UntypedWritesPerCacheLine",
                .desc = "Ratio of EU untyped write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_REQUESTS_TO_L3_CACHE_LINES,
                .read_float = bdw__compute_extended__untyped_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 38);
}

static bool bdw_compute_l3_cache_L3Bank00Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank00IcAccesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank00IcHits_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank01Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank02Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank03Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x01) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank10Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank10IcAccesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank10IcHits_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank11Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank12Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}
static bool bdw_compute_l3_cache_L3Bank13Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x02) {
        return true;
    }
    return false;
}

static void
bdw_add_compute_l3_cache_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics L3 Cache metric set";
    metric_set->symbol_name = "ComputeL3Cache";
    metric_set->hw_config_guid = "27a364dc-8225-4ecb-b607-d6f1925598d9";
    metric_set->counters = calloc(58, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_compute_l3_cache_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__compute_l3_cache__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__compute_l3_cache__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = bdw__compute_l3_cache__eu_avg_ipc_rate__read,
                .max_float = bdw__compute_l3_cache__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Binary Instruction",
                .symbol_name = "EuBinaryFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing binary instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_binary_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Binary Instruction",
                .symbol_name = "EuBinaryFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing binary instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_binary_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU0 Hybrid Instruction",
                .symbol_name = "EuHybridFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Hybrid Instruction",
                .symbol_name = "EuHybridFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU0 Move Instruction",
                .symbol_name = "EuMoveFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing move instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_move_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Move Instruction",
                .symbol_name = "EuMoveFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing move instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_move_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Ternary Instruction",
                .symbol_name = "EuTernaryFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_ternary_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Ternary Instruction",
                .symbol_name = "EuTernaryFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__eu_ternary_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_l3_cache__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__compute_l3_cache__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__compute_l3_cache__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI L3 Throughput",
                .symbol_name = "GtiL3Throughput",
                .desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__gti_l3_throughput__read,
                .max_uint64 = bdw__compute_l3_cache__gti_l3_throughput__max,
                .group = "GTI/L3",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__gti_read_throughput__read,
                .max_uint64 = bdw__compute_l3_cache__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__gti_write_throughput__read,
                .max_uint64 = bdw__compute_l3_cache__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Accesses",
                .symbol_name = "L3Accesses",
                .desc = "The total number of L3 accesses from all entities.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
            },

            {
                .name = "L3 Bank 00 Accesses",
                .symbol_name = "L3Bank00Accesses",
                .desc = "The total number of accesses to L3 Bank 00.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank00_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank00Accesses_availability,
            },

            {
                .name = "L3 Bank 00 IC Accesses",
                .symbol_name = "L3Bank00IcAccesses",
                .desc = "The total number of accesses to L3 Bank 00 from IC cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank00_ic_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/IC",
                .availability = bdw_compute_l3_cache_L3Bank00IcAccesses_availability,
            },

            {
                .name = "L3 Bank 00 IC Hits",
                .symbol_name = "L3Bank00IcHits",
                .desc = "The total number of hits in L3 Bank 00 from IC cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank00_ic_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/IC",
                .availability = bdw_compute_l3_cache_L3Bank00IcHits_availability,
            },

            {
                .name = "L3 Bank 01 Accesses",
                .symbol_name = "L3Bank01Accesses",
                .desc = "The total number of accesses to L3 Bank 01.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank01_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank01Accesses_availability,
            },

            {
                .name = "L3 Bank 02 Accesses",
                .symbol_name = "L3Bank02Accesses",
                .desc = "The total number of accesses to L3 Bank 02.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank02_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank02Accesses_availability,
            },

            {
                .name = "L3 Bank 03 Accesses",
                .symbol_name = "L3Bank03Accesses",
                .desc = "The total number of accesses to L3 Bank 03.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank03_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank03Accesses_availability,
            },

            {
                .name = "L3 Bank 10 Accesses",
                .symbol_name = "L3Bank10Accesses",
                .desc = "The total number of accesses to L3 Bank 10.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank10_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank10Accesses_availability,
            },

            {
                .name = "L3 Bank 10 IC Accesses",
                .symbol_name = "L3Bank10IcAccesses",
                .desc = "The total number of accesses to L3 Bank 10 from IC cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank10_ic_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/IC",
                .availability = bdw_compute_l3_cache_L3Bank10IcAccesses_availability,
            },

            {
                .name = "L3 Bank 10 IC Hits",
                .symbol_name = "L3Bank10IcHits",
                .desc = "The total number of hits in L3 Bank 10 from IC cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank10_ic_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/IC",
                .availability = bdw_compute_l3_cache_L3Bank10IcHits_availability,
            },

            {
                .name = "L3 Bank 11 Accesses",
                .symbol_name = "L3Bank11Accesses",
                .desc = "The total number of accesses to L3 Bank 11.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank11_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank11Accesses_availability,
            },

            {
                .name = "L3 Bank 12 Accesses",
                .symbol_name = "L3Bank12Accesses",
                .desc = "The total number of accesses to L3 Bank 12.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank12_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank12Accesses_availability,
            },

            {
                .name = "L3 Bank 13 Accesses",
                .symbol_name = "L3Bank13Accesses",
                .desc = "The total number of accesses to L3 Bank 13.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_bank13_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = bdw_compute_l3_cache_L3Bank13Accesses_availability,
            },

            {
                .name = "L3 Misses",
                .symbol_name = "L3Misses",
                .desc = "The total number of L3 misses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__l3_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/TAG",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__l3_shader_throughput__read,
                .max_uint64 = bdw__compute_l3_cache__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "L3 Total Throughput",
                .symbol_name = "L3TotalThroughput",
                .desc = "The total number of GPU memory bytes transferred via L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__l3_total_throughput__read,
                .max_uint64 = bdw__compute_l3_cache__l3_total_throughput__max,
                .group = "L3",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_l3_cache__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__compute_l3_cache__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__compute_l3_cache__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__compute_l3_cache__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__slm_bytes_read__read,
                .max_uint64 = bdw__compute_l3_cache__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__compute_l3_cache__slm_bytes_written__read,
                .max_uint64 = bdw__compute_l3_cache__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__compute_l3_cache__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 58);
}


static void
bdw_add_data_port_reads_coalescing_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Data Port Reads Coalescing metric set";
    metric_set->symbol_name = "DataPortReadsCoalescing";
    metric_set->hw_config_guid = "857fc630-2f09-4804-85f1-084adfadd5ab";
    metric_set->counters = calloc(35, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_data_port_reads_coalescing_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__data_port_reads_coalescing__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__data_port_reads_coalescing__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = bdw__data_port_reads_coalescing__eu_avg_ipc_rate__read,
                .max_float = bdw__data_port_reads_coalescing__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EuBytesReadPerCacheLine",
                .symbol_name = "EuBytesReadPerCacheLine",
                .desc = "Average EU bytes read per L3 cache line.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_BYTES_PER_L3_CACHE_LINE,
                .read_float = bdw__data_port_reads_coalescing__eu_bytes_read_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuDataReadsPerCacheLine",
                .symbol_name = "EuDataReadsPerCacheLine",
                .desc = "Coalescing ratio of EU read requests to L3 cache lines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_UTILIZATION,
                .read_float = bdw__data_port_reads_coalescing__eu_data_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU to Data Port 0 Reads 128",
                .symbol_name = "EuHdc0Reads128B",
                .desc = "The subslice 0 EU data reads from Data Port with 128B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__eu_hdc0_reads128_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Reads 256",
                .symbol_name = "EuHdc0Reads256B",
                .desc = "The subslice 0 EU data reads from Data Port with 256B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__eu_hdc0_reads256_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Reads 32",
                .symbol_name = "EuHdc0Reads32B",
                .desc = "The subslice 0 EU data reads from Data Port with 32B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__eu_hdc0_reads32_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Reads 64",
                .symbol_name = "EuHdc0Reads64B",
                .desc = "The subslice 0 EU data reads from Data Port with 64B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__eu_hdc0_reads64_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_reads_coalescing__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__data_port_reads_coalescing__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__data_port_reads_coalescing__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Data Port 0 to L3 Data Reads",
                .symbol_name = "Hdc0L3DataReads",
                .desc = "The subslice 0 Data Port data and constant reads from L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__hdc0_l3_data_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Data Port 0 to L3 Data Writes",
                .symbol_name = "Hdc0L3DataWrites",
                .desc = "The subslice 0 Data Port data writes to L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__hdc0_l3_data_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "All Data Port 0 Reads from L3",
                .symbol_name = "Hdc0L3Reads",
                .desc = "The subslice 0 Data Port reads from L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__hdc0_l3_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "All Data Port 0 Writes to L3",
                .symbol_name = "Hdc0L3Writes",
                .desc = "The subslice 0 Data Port writes to L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__hdc0_l3_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_reads_coalescing__l3_shader_throughput__read,
                .max_uint64 = bdw__data_port_reads_coalescing__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__data_port_reads_coalescing__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__data_port_reads_coalescing__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_reads_coalescing__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_reads_coalescing__slm_bytes_read__read,
                .max_uint64 = bdw__data_port_reads_coalescing__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_reads_coalescing__slm_bytes_written__read,
                .max_uint64 = bdw__data_port_reads_coalescing__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_reads_coalescing__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 35);
}


static void
bdw_add_data_port_writes_coalescing_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Data Port Writes Coalescing metric set";
    metric_set->symbol_name = "DataPortWritesCoalescing";
    metric_set->hw_config_guid = "343ebc99-4a55-414c-8c17-d8e259cf5e20";
    metric_set->counters = calloc(38, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_data_port_writes_coalescing_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__data_port_writes_coalescing__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__data_port_writes_coalescing__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = bdw__data_port_writes_coalescing__eu_avg_ipc_rate__read,
                .max_float = bdw__data_port_writes_coalescing__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EuBytesWrittenPerCacheLine",
                .symbol_name = "EuBytesWrittenPerCacheLine",
                .desc = "Average EU bytes written per L3 cache line.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_BYTES_PER_L3_CACHE_LINE,
                .read_float = bdw__data_port_writes_coalescing__eu_bytes_written_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuDataWritesPerCacheLine",
                .symbol_name = "EuDataWritesPerCacheLine",
                .desc = "Coalescing ratio of EU write requests to L3 cache lines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_UTILIZATION,
                .read_float = bdw__data_port_writes_coalescing__eu_data_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU to Data Port 0 Writes 128",
                .symbol_name = "EuHdc0Writes128B",
                .desc = "The subslice 0 EU data writes to Data Port with 128B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 64B",
                .symbol_name = "EuHdc0Writes128BSimd16",
                .desc = "The subslice 0 EU data simd16 writes to Data Port with 128B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b_simd16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 128",
                .symbol_name = "EuHdc0Writes192B",
                .desc = "The subslice 0 EU data simd16 writes to Data Port with 192B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes192_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 256B",
                .symbol_name = "EuHdc0Writes256BSimd16",
                .desc = "The subslice 0 EU data simd16 writes to Data Port with 256B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes256_b_simd16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 32B",
                .symbol_name = "EuHdc0Writes32B",
                .desc = "The subslice 0 EU data writes to Data Port with 32B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes32_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 64B",
                .symbol_name = "EuHdc0Writes64B",
                .desc = "The subslice 0 EU data writes to Data Port with 64B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes64_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU to Data Port 0 Writes 64B",
                .symbol_name = "EuHdc0Writes96B",
                .desc = "The subslice 0 EU data writes to Data Port with 64B per message.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__eu_hdc0_writes96_b__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__data_port_writes_coalescing__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__data_port_writes_coalescing__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__data_port_writes_coalescing__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Data Port 0 to L3 Data Reads",
                .symbol_name = "Hdc0L3DataReads",
                .desc = "The subslice 0 Data Port data and constant reads from L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__hdc0_l3_data_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Data Port 0 to L3 Data Writes",
                .symbol_name = "Hdc0L3DataWrites",
                .desc = "The subslice 0 Data Port data writes to L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__hdc0_l3_data_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "All Data Port 0 Reads from L3",
                .symbol_name = "Hdc0L3Reads",
                .desc = "The subslice 0 Data Port reads from L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__hdc0_l3_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "All Data Port 0 Writes to L3",
                .symbol_name = "Hdc0L3Writes",
                .desc = "The subslice 0 Data Port writes to L3 cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__hdc0_l3_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_writes_coalescing__l3_shader_throughput__read,
                .max_uint64 = bdw__data_port_writes_coalescing__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__data_port_writes_coalescing__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__data_port_writes_coalescing__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__data_port_writes_coalescing__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_writes_coalescing__slm_bytes_read__read,
                .max_uint64 = bdw__data_port_writes_coalescing__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__data_port_writes_coalescing__slm_bytes_written__read,
                .max_uint64 = bdw__data_port_writes_coalescing__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__data_port_writes_coalescing__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 38);
}

static bool bdw_hdc_and_sf_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader02AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader10AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader11AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_hdc_and_sf_NonSamplerShader12AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}

static void
bdw_add_hdc_and_sf_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF";
    metric_set->symbol_name = "HDCAndSF";
    metric_set->hw_config_guid = "78490af2-10fa-430b-ae3c-94ec04d5214e";
    metric_set->counters = calloc(43, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_hdc_and_sf_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__hdc_and_sf__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__hdc_and_sf__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_hdc_and_sf_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__hdc_and_sf__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__hdc_and_sf__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__hdc_and_sf__l3_shader_throughput__read,
                .max_uint64 = bdw__hdc_and_sf__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "HDC stalled by L3 (s0.ss0)",
                .symbol_name = "NonSamplerShader00AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability,
            },

            {
                .name = "HDC stalled by L3 (s0.ss1)",
                .symbol_name = "NonSamplerShader01AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability,
            },

            {
                .name = "HDC stalled by L3 (s0.ss2)",
                .symbol_name = "NonSamplerShader02AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader02AccessStalledOnL3_availability,
            },

            {
                .name = "HDC stalled by L3 (s0.ss0)",
                .symbol_name = "NonSamplerShader10AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader10AccessStalledOnL3_availability,
            },

            {
                .name = "HDC stalled by L3 (s0.ss1)",
                .symbol_name = "NonSamplerShader11AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader11AccessStalledOnL3_availability,
            },

            {
                .name = "HDC stalled by L3 (s0.ss2)",
                .symbol_name = "NonSamplerShader12AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = bdw_hdc_and_sf_NonSamplerShader12AccessStalledOnL3_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Polygon Data Ready",
                .symbol_name = "PolyDataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__poly_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe/Strip-Fans",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__hdc_and_sf__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__hdc_and_sf__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__hdc_and_sf__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__hdc_and_sf__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__hdc_and_sf__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__hdc_and_sf__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__hdc_and_sf__slm_bytes_read__read,
                .max_uint64 = bdw__hdc_and_sf__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__hdc_and_sf__slm_bytes_written__read,
                .max_uint64 = bdw__hdc_and_sf__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__hdc_and_sf__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__hdc_and_sf__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 43);
}

static bool bdw_l3_1_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_l3_1_L31Bank0Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_l3_1_L31Bank0Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_l3_1_L31Bank1Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_l3_1_L31Bank1Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}

static void
bdw_add_l3_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set L3_1";
    metric_set->symbol_name = "L3_1";
    metric_set->hw_config_guid = "c0abdd97-3b13-4cad-814c-bd178804e02c";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_l3_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__l3_1__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__l3_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_l3_1_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__l3_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__l3_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice1 L3 Bank0 Active",
                .symbol_name = "L31Bank0Active",
                .desc = "The percentage of time in which slice1 L3 bank0 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__l31_bank0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_1_L31Bank0Active_availability,
            },

            {
                .name = "Slice1 L3 Bank0 Stalled",
                .symbol_name = "L31Bank0Stalled",
                .desc = "The percentage of time in which slice1 L3 bank0 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__l31_bank0_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_1_L31Bank0Stalled_availability,
            },

            {
                .name = "Slice1 L3 Bank1 Active",
                .symbol_name = "L31Bank1Active",
                .desc = "The percentage of time in which slice1 L3 bank1 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__l31_bank1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_1_L31Bank1Active_availability,
            },

            {
                .name = "Slice1 L3 Bank1 Stalled",
                .symbol_name = "L31Bank1Stalled",
                .desc = "The percentage of time in which slice1 L3 bank1 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__l31_bank1_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_1_L31Bank1Stalled_availability,
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_1__l3_shader_throughput__read,
                .max_uint64 = bdw__l3_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_1__slm_bytes_read__read,
                .max_uint64 = bdw__l3_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_1__slm_bytes_written__read,
                .max_uint64 = bdw__l3_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 40);
}

static bool bdw_l3_2_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_l3_2_L30Bank0Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_2_L30Bank0Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_2_L30Bank1Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_2_L30Bank1Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}

static void
bdw_add_l3_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set L3_2";
    metric_set->symbol_name = "L3_2";
    metric_set->hw_config_guid = "ad665281-a7cf-483a-bd10-0e07c43f61c7";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_l3_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__l3_2__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__l3_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_l3_2_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__l3_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__l3_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank0 Active",
                .symbol_name = "L30Bank0Active",
                .desc = "The percentage of time in which slice0 L3 bank0 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__l30_bank0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_2_L30Bank0Active_availability,
            },

            {
                .name = "Slice0 L3 Bank0 Stalled",
                .symbol_name = "L30Bank0Stalled",
                .desc = "The percentage of time in which slice0 L3 bank0 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__l30_bank0_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_2_L30Bank0Stalled_availability,
            },

            {
                .name = "Slice0 L3 Bank1 Active",
                .symbol_name = "L30Bank1Active",
                .desc = "The percentage of time in which slice0 L3 bank1 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__l30_bank1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_2_L30Bank1Active_availability,
            },

            {
                .name = "Slice0 L3 Bank1 Stalled",
                .symbol_name = "L30Bank1Stalled",
                .desc = "The percentage of time in which slice0 L3 bank1 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__l30_bank1_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_2_L30Bank1Stalled_availability,
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_2__l3_shader_throughput__read,
                .max_uint64 = bdw__l3_2__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_2__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_2__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_2__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_2__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_2__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_2__slm_bytes_read__read,
                .max_uint64 = bdw__l3_2__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_2__slm_bytes_written__read,
                .max_uint64 = bdw__l3_2__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 40);
}

static bool bdw_l3_3_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_l3_3_L30Bank3Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_3_L30Bank3Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_3_L31Bank3Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_l3_3_L31Bank3Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}

static void
bdw_add_l3_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set L3_3";
    metric_set->symbol_name = "L3_3";
    metric_set->hw_config_guid = "930a15aa-4300-4fce-a9ba-edb0b9e880be";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_l3_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__l3_3__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__l3_3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_l3_3_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__l3_3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__l3_3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank3 Active",
                .symbol_name = "L30Bank3Active",
                .desc = "The percentage of time in which slice0 L3 bank3 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__l30_bank3_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_3_L30Bank3Active_availability,
            },

            {
                .name = "Slice0 L3 Bank3 Stalled",
                .symbol_name = "L30Bank3Stalled",
                .desc = "The percentage of time in which slice0 L3 bank3 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__l30_bank3_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_3_L30Bank3Stalled_availability,
            },

            {
                .name = "Slice1 L3 Bank3 Active",
                .symbol_name = "L31Bank3Active",
                .desc = "The percentage of time in which slice1 L3 bank3 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__l31_bank3_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_3_L31Bank3Active_availability,
            },

            {
                .name = "Slice1 L3 Bank3 Stalled",
                .symbol_name = "L31Bank3Stalled",
                .desc = "The percentage of time in which slice1 L3 bank3 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__l31_bank3_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_3_L31Bank3Stalled_availability,
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_3__l3_shader_throughput__read,
                .max_uint64 = bdw__l3_3__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_3__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_3__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_3__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_3__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_3__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_3__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_3__slm_bytes_read__read,
                .max_uint64 = bdw__l3_3__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_3__slm_bytes_written__read,
                .max_uint64 = bdw__l3_3__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_3__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_3__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 40);
}

static bool bdw_l3_4_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_l3_4_L30Bank2Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_4_L30Bank2Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_l3_4_L31Bank2Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_l3_4_L31Bank2Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}

static void
bdw_add_l3_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set L3_4";
    metric_set->symbol_name = "L3_4";
    metric_set->hw_config_guid = "d7793b26-b5e3-4f0f-ad78-7ebc9d0b4c7d";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_l3_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__l3_4__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__l3_4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_l3_4_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__l3_4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__l3_4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank2 Active",
                .symbol_name = "L30Bank2Active",
                .desc = "The percentage of time in which slice0 L3 bank2 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__l30_bank2_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_4_L30Bank2Active_availability,
            },

            {
                .name = "Slice0 L3 Bank2 Stalled",
                .symbol_name = "L30Bank2Stalled",
                .desc = "The percentage of time in which slice0 L3 bank2 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__l30_bank2_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_4_L30Bank2Stalled_availability,
            },

            {
                .name = "Slice1 L3 Bank2 Active",
                .symbol_name = "L31Bank2Active",
                .desc = "The percentage of time in which slice1 L3 bank2 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__l31_bank2_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_4_L31Bank2Active_availability,
            },

            {
                .name = "Slice1 L3 Bank2 Stalled",
                .symbol_name = "L31Bank2Stalled",
                .desc = "The percentage of time in which slice1 L3 bank2 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__l31_bank2_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = bdw_l3_4_L31Bank2Stalled_availability,
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_4__l3_shader_throughput__read,
                .max_uint64 = bdw__l3_4__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_4__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__l3_4__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__l3_4__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_4__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_4__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__l3_4__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_4__slm_bytes_read__read,
                .max_uint64 = bdw__l3_4__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__l3_4__slm_bytes_written__read,
                .max_uint64 = bdw__l3_4__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__l3_4__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__l3_4__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 40);
}

static bool bdw_rasterizer_and_pixel_backend_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PSOutput0Available_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PSOutput1Available_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PixelData0Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PixelData1Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PixelValues0Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_PixelValues1Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_Rasterizer1InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_rasterizer_and_pixel_backend_Rasterizer1OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 0x2) {
        return true;
    }
    return false;
}

static void
bdw_add_rasterizer_and_pixel_backend_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend";
    metric_set->symbol_name = "RasterizerAndPixelBackend";
    metric_set->hw_config_guid = "da0f7875-1143-4d73-a39c-9128a951c46a";
    metric_set->counters = calloc(46, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_rasterizer_and_pixel_backend_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_rasterizer_and_pixel_backend_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__l3_shader_throughput__read,
                .max_uint64 = bdw__rasterizer_and_pixel_backend__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Slice0 PS Output Available",
                .symbol_name = "PSOutput0Available",
                .desc = "The percentage of time in which slice0 PS output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_output0_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
                .availability = bdw_rasterizer_and_pixel_backend_PSOutput0Available_availability,
            },

            {
                .name = "Slice1 PS Output Available",
                .symbol_name = "PSOutput1Available",
                .desc = "The percentage of time in which slice1 PS output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_output1_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
                .availability = bdw_rasterizer_and_pixel_backend_PSOutput1Available_availability,
            },

            {
                .name = "Slice0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData0Ready",
                .desc = "The percentage of time in which slice0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__pixel_data0_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
                .availability = bdw_rasterizer_and_pixel_backend_PixelData0Ready_availability,
            },

            {
                .name = "Slice1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData1Ready",
                .desc = "The percentage of time in which slice1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__pixel_data1_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
                .availability = bdw_rasterizer_and_pixel_backend_PixelData1Ready_availability,
            },

            {
                .name = "Slice0 Pixel Values Ready",
                .symbol_name = "PixelValues0Ready",
                .desc = "The percentage of time in which slice0 pixel values are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__pixel_values0_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
                .availability = bdw_rasterizer_and_pixel_backend_PixelValues0Ready_availability,
            },

            {
                .name = "Slice1 Pixel Values Ready",
                .symbol_name = "PixelValues1Ready",
                .desc = "The percentage of time in which slice1 pixel values are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__pixel_values1_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
                .availability = bdw_rasterizer_and_pixel_backend_PixelValues1Ready_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Rasterizer Input Available",
                .symbol_name = "Rasterizer0InputAvailable",
                .desc = "The percentage of time in which slice0 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__rasterizer0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = bdw_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability,
            },

            {
                .name = "Slice0 Rasterizer Output Ready",
                .symbol_name = "Rasterizer0OutputReady",
                .desc = "The percentage of time in which slice0 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__rasterizer0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = bdw_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability,
            },

            {
                .name = "Slice1 Rasterizer Input Available",
                .symbol_name = "Rasterizer1InputAvailable",
                .desc = "The percentage of time in which slice1 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__rasterizer1_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = bdw_rasterizer_and_pixel_backend_Rasterizer1InputAvailable_availability,
            },

            {
                .name = "Slice1 Rasterizer Output Ready",
                .symbol_name = "Rasterizer1OutputReady",
                .desc = "The percentage of time in which slice1 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__rasterizer1_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = bdw_rasterizer_and_pixel_backend_Rasterizer1OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__slm_bytes_read__read,
                .max_uint64 = bdw__rasterizer_and_pixel_backend__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__slm_bytes_written__read,
                .max_uint64 = bdw__rasterizer_and_pixel_backend__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__rasterizer_and_pixel_backend__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__rasterizer_and_pixel_backend__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 46);
}

static bool bdw_sampler_1_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler10InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler10OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler11InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler11OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler12InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}
static bool bdw_sampler_1_Sampler12OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}

static void
bdw_add_sampler_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set Sampler_1";
    metric_set->symbol_name = "Sampler_1";
    metric_set->hw_config_guid = "52c186e4-39e3-4534-87cd-41bd47763df9";
    metric_set->counters = calloc(42, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_sampler_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__sampler_1__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__sampler_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_sampler_1_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__sampler_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__sampler_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_1__l3_shader_throughput__read,
                .max_uint64 = bdw__sampler_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice1 Subslice0 Input Available",
                .symbol_name = "Sampler10InputAvailable",
                .desc = "The percentage of time in which slice1 subslice0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler10_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler10InputAvailable_availability,
            },

            {
                .name = "Slice1 Subslice0 Sampler Output Ready",
                .symbol_name = "Sampler10OutputReady",
                .desc = "The percentage of time in which slice1 subslice0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler10_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler10OutputReady_availability,
            },

            {
                .name = "Slice1 Subslice1 Input Available",
                .symbol_name = "Sampler11InputAvailable",
                .desc = "The percentage of time in which slice1 subslice1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler11_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler11InputAvailable_availability,
            },

            {
                .name = "Slice1 Subslice1 Sampler Output Ready",
                .symbol_name = "Sampler11OutputReady",
                .desc = "The percentage of time in which slice1 subslice1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler11_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler11OutputReady_availability,
            },

            {
                .name = "Slice1 Subslice2 Input Available",
                .symbol_name = "Sampler12InputAvailable",
                .desc = "The percentage of time in which slice1 subslice2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler12_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler12InputAvailable_availability,
            },

            {
                .name = "Slice1 Subslice2 Sampler Output Ready",
                .symbol_name = "Sampler12OutputReady",
                .desc = "The percentage of time in which slice1 subslice2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__sampler12_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_1_Sampler12OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__sampler_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__sampler_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_1__slm_bytes_read__read,
                .max_uint64 = bdw__sampler_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_1__slm_bytes_written__read,
                .max_uint64 = bdw__sampler_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 42);
}

static bool bdw_sampler_2_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler00InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler00OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler01InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler01OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler02InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool bdw_sampler_2_Sampler02OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}

static void
bdw_add_sampler_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set Sampler_2";
    metric_set->symbol_name = "Sampler_2";
    metric_set->hw_config_guid = "edcb8c31-764d-451a-9ecd-c9c89fb54f8d";
    metric_set->counters = calloc(42, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_sampler_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__sampler_2__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__sampler_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_sampler_2_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__sampler_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__sampler_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_2__l3_shader_throughput__read,
                .max_uint64 = bdw__sampler_2__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Subslice0 Input Available",
                .symbol_name = "Sampler00InputAvailable",
                .desc = "The percentage of time in which slice0 subslice0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler00_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler00InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice0 Sampler Output Ready",
                .symbol_name = "Sampler00OutputReady",
                .desc = "The percentage of time in which slice0 subslice0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler00_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler00OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice1 Input Available",
                .symbol_name = "Sampler01InputAvailable",
                .desc = "The percentage of time in which slice0 subslice1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler01_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler01InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice1 Sampler Output Ready",
                .symbol_name = "Sampler01OutputReady",
                .desc = "The percentage of time in which slice0 subslice1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler01_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler01OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice2 Input Available",
                .symbol_name = "Sampler02InputAvailable",
                .desc = "The percentage of time in which slice0 subslice2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler02_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler02InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice2 Sampler Output Ready",
                .symbol_name = "Sampler02OutputReady",
                .desc = "The percentage of time in which slice0 subslice2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__sampler02_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = bdw_sampler_2_Sampler02OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__sampler_2__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__sampler_2__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__sampler_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_2__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_2__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__sampler_2__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_2__slm_bytes_read__read,
                .max_uint64 = bdw__sampler_2__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__sampler_2__slm_bytes_written__read,
                .max_uint64 = bdw__sampler_2__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__sampler_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__sampler_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 42);
}

static bool bdw_tdl_1_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_NonPSThread10ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_NonPSThread11ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_NonPSThread12ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_PSThread10ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_PSThread11ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_PSThread12ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader00ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader00ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader01ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader01ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader02ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool bdw_tdl_1_ThreadHeader02ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}

static void
bdw_add_tdl_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TDL_1";
    metric_set->symbol_name = "TDL_1";
    metric_set->hw_config_guid = "729fc3f4-ccff-4902-be6b-f1a22cc92c02";
    metric_set->counters = calloc(48, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_tdl_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__tdl_1__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__tdl_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_tdl_1_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__tdl_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__tdl_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_1__l3_shader_throughput__read,
                .max_uint64 = bdw__tdl_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice1 Subslice0",
                .symbol_name = "NonPSThread10ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__non_ps_thread10_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_NonPSThread10ReadyForDispatch_availability,
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice1 Subslice1",
                .symbol_name = "NonPSThread11ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__non_ps_thread11_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_NonPSThread11ReadyForDispatch_availability,
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice1 Subslice2",
                .symbol_name = "NonPSThread12ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__non_ps_thread12_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_NonPSThread12ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice1 Subslice0",
                .symbol_name = "PSThread10ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_thread10_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_PSThread10ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice1 Subslice1",
                .symbol_name = "PSThread11ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_thread11_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_PSThread11ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice1 Subslice2",
                .symbol_name = "PSThread12ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_thread12_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_PSThread12ReadyForDispatch_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__tdl_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__tdl_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_1__slm_bytes_read__read,
                .max_uint64 = bdw__tdl_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_1__slm_bytes_written__read,
                .max_uint64 = bdw__tdl_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice0 Port 0",
                .symbol_name = "ThreadHeader00ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header00_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader00ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice0 Port 1",
                .symbol_name = "ThreadHeader00ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header00_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader00ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice1 Port 0",
                .symbol_name = "ThreadHeader01ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header01_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader01ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice1 Port 1",
                .symbol_name = "ThreadHeader01ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header01_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader01ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice2 Port 0",
                .symbol_name = "ThreadHeader02ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header02_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader02ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice2 Port 1",
                .symbol_name = "ThreadHeader02ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__thread_header02_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_1_ThreadHeader02ReadyPort1_availability,
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 48);
}

static bool bdw_tdl_2_GTRequestQueueFull_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_NonPSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_NonPSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_NonPSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_PSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_PSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_PSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader10ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader10ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader11ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader11ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x10) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader12ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}
static bool bdw_tdl_2_ThreadHeader12ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x20) {
        return true;
    }
    return false;
}

static void
bdw_add_tdl_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TDL_2";
    metric_set->symbol_name = "TDL_2";
    metric_set->hw_config_guid = "29598975-4785-43ab-a981-1dfa58d0e835";
    metric_set->counters = calloc(48, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_tdl_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__tdl_2__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__tdl_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
                .availability = bdw_tdl_2_GTRequestQueueFull_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__tdl_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__tdl_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_2__l3_shader_throughput__read,
                .max_uint64 = bdw__tdl_2__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice0 Subslice0",
                .symbol_name = "NonPSThread00ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__non_ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_NonPSThread00ReadyForDispatch_availability,
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice0 Subslice1",
                .symbol_name = "NonPSThread01ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__non_ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_NonPSThread01ReadyForDispatch_availability,
            },

            {
                .name = "NonPS Thread Ready For Dispatch on Slice0 Subslice2",
                .symbol_name = "NonPSThread02ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__non_ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_NonPSThread02ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice0",
                .symbol_name = "PSThread00ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_PSThread00ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice1",
                .symbol_name = "PSThread01ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_PSThread01ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice2",
                .symbol_name = "PSThread02ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_PSThread02ReadyForDispatch_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__tdl_2__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = bdw__tdl_2__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = bdw__tdl_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_2__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_2__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bdw__tdl_2__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_2__slm_bytes_read__read,
                .max_uint64 = bdw__tdl_2__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bdw__tdl_2__slm_bytes_written__read,
                .max_uint64 = bdw__tdl_2__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice0 Port 0",
                .symbol_name = "ThreadHeader10ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header10_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader10ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice0 Port 1",
                .symbol_name = "ThreadHeader10ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header10_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader10ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice1 Port 0",
                .symbol_name = "ThreadHeader11ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header11_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader11ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice1 Port 1",
                .symbol_name = "ThreadHeader11ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header11_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader11ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice2 Port 0",
                .symbol_name = "ThreadHeader12ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header12_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader12ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice1 Subslice2 Port 1",
                .symbol_name = "ThreadHeader12ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice1 subslice2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__thread_header12_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = bdw_tdl_2_ThreadHeader12ReadyPort1_availability,
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__tdl_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__tdl_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 48);
}


static void
bdw_add_compute_extra_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Extra set";
    metric_set->symbol_name = "ComputeExtra";
    metric_set->hw_config_guid = "8fb61ba2-2fbb-454c-a136-2dec5a8a595e";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_compute_extra_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__compute_extra__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__compute_extra__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extra__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active including Ext Math",
                .symbol_name = "Fpu1ActiveAdjusted",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing including Extended Math processing",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__compute_extra__fpu1_active_adjusted__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__compute_extra__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__compute_extra__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}


static void
bdw_add_vme_pipe_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Media Vme Pipe metric set";
    metric_set->symbol_name = "VMEPipe";
    metric_set->hw_config_guid = "e1743ca0-7fc8-410b-a066-de7bbb9280b7";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_vme_pipe_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__vme_pipe__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__vme_pipe__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__vme_pipe__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__vme_pipe__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__vme_pipe__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "VME Busy",
                .symbol_name = "VMEBusy",
                .desc = "The percentage of time in which VME (IME or CRE) was actively processing data.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__vme_pipe__vme_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "VME Pipe",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}


static void
bdw_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Gpu Rings Busyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "0a9eb7be-feee-4275-a139-6d9cedf0fdb0";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AnyRingBusy",
                .symbol_name = "AnyRingBusy",
                .desc = "The percentage of time when any command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__any_ring_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__gpu_busyness__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__gpu_busyness__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Blitter Ring Busy",
                .symbol_name = "BlitterBusy",
                .desc = "The percentage of time when blitter command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__blitter_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__gpu_busyness__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__gpu_busyness__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox0 Ring Busy",
                .symbol_name = "Vdbox0Busy",
                .desc = "The percentage of time when Vdbox0 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__vdbox0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox1 Ring Busy",
                .symbol_name = "Vdbox1Busy",
                .desc = "The percentage of time when Vdbox1 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__vdbox1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vebox Ring Busy",
                .symbol_name = "VeboxBusy",
                .desc = "The percentage of time when vebox command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__gpu_busyness__vebox_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}


static void
bdw_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "MDAPI testing set";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "d6de6f55-e526-4f79-a6a6-d7315c09044e";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.166",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bdw__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool bdw_stc__pma_stall_StcPMAStall_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
bdw_add_stc__pma_stall_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set PMA Stall";
    metric_set->symbol_name = "STC_PmaStall";
    metric_set->hw_config_guid = "e713f347-953e-4d8c-b02f-6be31df2db2b";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    bdw_stc__pma_stall_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bdw__stc__pma_stall__avg_gpu_core_frequency__read,
                .max_uint64 = bdw__stc__pma_stall__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__stc__pma_stall__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bdw__stc__pma_stall__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bdw__stc__pma_stall__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "STC PMA stall",
                .symbol_name = "StcPMAStall",
                .desc = "Percentage of time when stencil cache line and an overlapping pixel are causing stalls",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bdw__stc__pma_stall__stc_pma_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Stencil Cache",
                .availability = bdw_stc__pma_stall_StcPMAStall_availability,
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = bdw__stc__pma_stall__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

void
intel_perf_load_metrics_bdw(struct intel_perf *perf)
{
    bdw_add_render_basic_metric_set(perf);
    bdw_add_compute_basic_metric_set(perf);
    bdw_add_render_pipe_profile_metric_set(perf);
    bdw_add_memory_reads_metric_set(perf);
    bdw_add_memory_writes_metric_set(perf);
    bdw_add_compute_extended_metric_set(perf);
    bdw_add_compute_l3_cache_metric_set(perf);
    bdw_add_data_port_reads_coalescing_metric_set(perf);
    bdw_add_data_port_writes_coalescing_metric_set(perf);
    bdw_add_hdc_and_sf_metric_set(perf);
    bdw_add_l3_1_metric_set(perf);
    bdw_add_l3_2_metric_set(perf);
    bdw_add_l3_3_metric_set(perf);
    bdw_add_l3_4_metric_set(perf);
    bdw_add_rasterizer_and_pixel_backend_metric_set(perf);
    bdw_add_sampler_1_metric_set(perf);
    bdw_add_sampler_2_metric_set(perf);
    bdw_add_tdl_1_metric_set(perf);
    bdw_add_tdl_2_metric_set(perf);
    bdw_add_compute_extra_metric_set(perf);
    bdw_add_vme_pipe_metric_set(perf);
    bdw_add_gpu_busyness_metric_set(perf);
    bdw_add_test_oa_metric_set(perf);
    bdw_add_stc__pma_stall_metric_set(perf);
}
