#ifndef SBK_KNOTIFICATIONJOBUIDELEGATEWRAPPER_H
#define SBK_KNOTIFICATIONJOBUIDELEGATEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <knotificationjobuidelegate.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KNotificationJobUiDelegateWrapper : public KNotificationJobUiDelegate
{
public:
    KNotificationJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags = {KJobUiDelegate::AutoHandlingDisabled});
    KNotificationJobUiDelegateWrapper(const KNotificationJobUiDelegateWrapper &) = delete;
    KNotificationJobUiDelegateWrapper& operator=(const KNotificationJobUiDelegateWrapper &) = delete;
    KNotificationJobUiDelegateWrapper(KNotificationJobUiDelegateWrapper &&) = delete;
    KNotificationJobUiDelegateWrapper& operator=(KNotificationJobUiDelegateWrapper &&) = delete;
    ~KNotificationJobUiDelegateWrapper() override;

    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify(const ::QMetaMethod & signal) override;
    static void sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal);
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool setJob(::KJob * job) override;
    static bool sbk_o_setJob(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job);
    void showErrorMessage() override;
    static void sbk_o_showErrorMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void slotWarning(::KJob * job, const ::QString & message) override;
    static void sbk_o_slotWarning(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & message);
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 10> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KNOTIFICATIONJOBUIDELEGATEWRAPPER_H
