/* slick-greeter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from slick-greeter.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Robert Ancell <robert.ancell@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-xlib.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <lightdm.h>
#include <canberra.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <stdio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <unistd.h>
#include <glib-unix.h>
#include <gobject/gvaluecollector.h>

#define grid_size 40
#define UG_SETTINGS_KEY_PLAY_READY_SOUND "play-ready-sound"
#define UG_SETTINGS_KEY_ENABLE_HIDPI "enable-hidpi"
#define UG_SETTINGS_KEY_ACTIVATE_NUMLOCK "activate-numlock"
#define UG_SETTINGS_KEY_THEME_NAME "theme-name"
#define UG_SETTINGS_KEY_ICON_THEME_NAME "icon-theme-name"
#define UG_SETTINGS_KEY_CURSOR_THEME_NAME "cursor-theme-name"
#define UG_SETTINGS_KEY_CURSOR_THEME_SIZE "cursor-theme-size"
#define UG_SETTINGS_KEY_FONT_NAME "font-name"
#define UG_SETTINGS_KEY_XFT_DPI "xft-dpi"
#define UG_SETTINGS_KEY_XFT_ANTIALIAS "xft-antialias"
#define UG_SETTINGS_KEY_XFT_HINTSTYLE "xft-hintstyle"
#define UG_SETTINGS_KEY_XFT_RGBA "xft-rgba"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DIALOG_DBUS_INTERFACE (dialog_dbus_interface_get_type ())
#define DIALOG_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIALOG_DBUS_INTERFACE, DialogDBusInterface))
#define DIALOG_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIALOG_DBUS_INTERFACE, DialogDBusInterfaceClass))
#define IS_DIALOG_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIALOG_DBUS_INTERFACE))
#define IS_DIALOG_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIALOG_DBUS_INTERFACE))
#define DIALOG_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIALOG_DBUS_INTERFACE, DialogDBusInterfaceClass))

typedef struct _DialogDBusInterface DialogDBusInterface;
typedef struct _DialogDBusInterfaceClass DialogDBusInterfaceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))
#define _slick_greeter_unref0(var) ((var == NULL) ? NULL : (var = (slick_greeter_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	SHUTDOWN_DIALOG_TYPE_LOGOUT,
	SHUTDOWN_DIALOG_TYPE_SHUTDOWN,
	SHUTDOWN_DIALOG_TYPE_RESTART
} ShutdownDialogType;

#define TYPE_SHUTDOWN_DIALOG_TYPE (shutdown_dialog_type_get_type ())

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_LIST_STACK (list_stack_get_type ())
#define LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STACK, ListStack))
#define LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STACK, ListStackClass))
#define IS_LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STACK))
#define IS_LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STACK))
#define LIST_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STACK, ListStackClass))

typedef struct _ListStack ListStack;
typedef struct _ListStackClass ListStackClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ParamSpecSlickGreeter ParamSpecSlickGreeter;
enum  {
	SLICK_GREETER_SHOW_MESSAGE_SIGNAL,
	SLICK_GREETER_SHOW_PROMPT_SIGNAL,
	SLICK_GREETER_AUTHENTICATION_COMPLETE_SIGNAL,
	SLICK_GREETER_STARTING_SESSION_SIGNAL,
	SLICK_GREETER_NUM_SIGNALS
};
static guint slick_greeter_signals[SLICK_GREETER_NUM_SIGNALS] = {0};
typedef struct _DialogDBusInterfacePrivate DialogDBusInterfacePrivate;
enum  {
	DIALOG_DBUS_INTERFACE_0_PROPERTY,
	DIALOG_DBUS_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* dialog_dbus_interface_properties[DIALOG_DBUS_INTERFACE_NUM_PROPERTIES];
enum  {
	DIALOG_DBUS_INTERFACE_OPEN_DIALOG_SIGNAL,
	DIALOG_DBUS_INTERFACE_CLOSE_DIALOG_SIGNAL,
	DIALOG_DBUS_INTERFACE_NUM_SIGNALS
};
static guint dialog_dbus_interface_signals[DIALOG_DBUS_INTERFACE_NUM_SIGNALS] = {0};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

struct _SlickGreeterPrivate {
	gchar* state_file;
	GKeyFile* state;
	cairo_surface_t* background_surface;
	MainWindow* main_window;
	LightDMGreeter* greeter;
	ca_context* canberra_context;
	DialogDBusInterface* dbus_object;
};

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	MenuBar* menubar;
	ListStack* stack;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _ParamSpecSlickGreeter {
	GParamSpec parent_instance;
};

struct _DialogDBusInterface {
	GObject parent_instance;
	DialogDBusInterfacePrivate * priv;
};

struct _DialogDBusInterfaceClass {
	GObjectClass parent_class;
};

static gint SlickGreeter_private_offset;
static gpointer slick_greeter_parent_class = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;
SlickGreeter* slick_greeter_singleton = NULL;
static GTimer* slick_greeter_log_timer;
static GTimer* slick_greeter_log_timer = NULL;
static gpointer dialog_dbus_interface_parent_class = NULL;

VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType dialog_dbus_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DialogDBusInterface, g_object_unref)
VALA_EXTERN guint dialog_dbus_interface_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
static SlickGreeter* slick_greeter_new (gboolean test_mode_);
static SlickGreeter* slick_greeter_construct (GType object_type,
                                       gboolean test_mode_);
static cairo_surface_t* slick_greeter_create_root_surface (GdkScreen* screen);
static void __lambda54_ (SlickGreeter* self,
                  const gchar* text,
                  LightDMMessageType type);
static void ___lambda54__lightdm_greeter_show_message (LightDMGreeter* _sender,
                                                const gchar* text,
                                                LightDMMessageType type,
                                                gpointer self);
static void __lambda55_ (SlickGreeter* self,
                  const gchar* text,
                  LightDMPromptType type);
static void ___lambda55__lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                               const gchar* text,
                                               LightDMPromptType type,
                                               gpointer self);
static void __lambda56_ (SlickGreeter* self);
static void ___lambda56__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender,
                                                           gpointer self);
static void __lambda57_ (SlickGreeter* self);
static void ___lambda57__lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                           gpointer self);
VALA_EXTERN MainWindow* main_window_new (void);
VALA_EXTERN MainWindow* main_window_construct (GType object_type);
static void __lambda58_ (SlickGreeter* self);
static void slick_greeter_kill_fake_wm (SlickGreeter* self);
static void ___lambda58__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static gboolean __lambda59_ (SlickGreeter* self);
static gboolean ___lambda59__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
VALA_EXTERN DialogDBusInterface* dialog_dbus_interface_new (void);
VALA_EXTERN DialogDBusInterface* dialog_dbus_interface_construct (GType object_type);
static void __lambda60_ (SlickGreeter* self,
                  guint32 type);
VALA_EXTERN GType shutdown_dialog_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void main_window_show_shutdown_dialog (MainWindow* self,
                                       ShutdownDialogType type);
static void ___lambda60__dialog_dbus_interface_open_dialog (DialogDBusInterface* _sender,
                                                     guint32 type,
                                                     gpointer self);
static void __lambda61_ (SlickGreeter* self,
                  DialogDBusInterface* type);
VALA_EXTERN void main_window_close_shutdown_dialog (MainWindow* self);
static void ___lambda61__dialog_dbus_interface_close_dialog (DialogDBusInterface* _sender,
                                                      gpointer self);
static void slick_greeter_start_fake_wm (SlickGreeter* self);
static gboolean slick_greeter_ready_cb (SlickGreeter* self);
static gboolean _slick_greeter_ready_cb_gsource_func (gpointer self);
VALA_EXTERN gchar* slick_greeter_get_state (SlickGreeter* self,
                                const gchar* key);
VALA_EXTERN void slick_greeter_set_state (SlickGreeter* self,
                              const gchar* key,
                              const gchar* value);
VALA_EXTERN GType fadable_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadableBox, g_object_unref)
VALA_EXTERN GType greeter_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterList, g_object_unref)
VALA_EXTERN void slick_greeter_push_list (SlickGreeter* self,
                              GreeterList* widget);
VALA_EXTERN void main_window_push_list (MainWindow* self,
                            GreeterList* widget);
VALA_EXTERN void slick_greeter_pop_list (SlickGreeter* self);
VALA_EXTERN void main_window_pop_list (MainWindow* self);
VALA_EXTERN void slick_greeter_add_style_class (GtkWidget* widget);
VALA_EXTERN gchar* slick_greeter_get_default_session (void);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN gchar* slick_greeter_validate_session (const gchar* session);
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN gboolean slick_greeter_start_session (SlickGreeter* self,
                                      const gchar* session,
                                      Background* bg);
VALA_EXTERN void main_window_before_session_start (MainWindow* self);
static gboolean slick_greeter_session_is_valid (SlickGreeter* self,
                                         const gchar* session);
VALA_EXTERN gchar* ug_settings_get_string (const gchar* key);
VALA_EXTERN void slick_greeter_show (SlickGreeter* self);
VALA_EXTERN void main_window_setup_window (MainWindow* self);
VALA_EXTERN void main_window_set_keyboard_state (MainWindow* self);
VALA_EXTERN gboolean slick_greeter_is_authenticated (SlickGreeter* self);
VALA_EXTERN void slick_greeter_authenticate (SlickGreeter* self,
                                 const gchar* userid);
VALA_EXTERN void slick_greeter_authenticate_as_guest (SlickGreeter* self);
VALA_EXTERN void slick_greeter_authenticate_remote (SlickGreeter* self,
                                        const gchar* session,
                                        const gchar* userid);
VALA_EXTERN void slick_greeter_cancel_authentication (SlickGreeter* self);
VALA_EXTERN void slick_greeter_respond (SlickGreeter* self,
                            const gchar* response);
VALA_EXTERN gchar* slick_greeter_authentication_user (SlickGreeter* self);
VALA_EXTERN gchar* slick_greeter_default_session_hint (SlickGreeter* self);
VALA_EXTERN gchar* slick_greeter_select_user_hint (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_show_manual_login_hint (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_show_remote_login_hint (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_hide_users_hint (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_has_guest_account_hint (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_is_live_session (SlickGreeter* self,
                                        gchar** live_username,
                                        gchar** live_realname);
static GdkFilterReturn slick_greeter_focus_upon_map (SlickGreeter* self,
                                              GdkXEvent* gxevent,
                                              GdkEvent* event);
VALA_EXTERN GType menu_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuBar, g_object_unref)
VALA_EXTERN GType list_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ListStack, g_object_unref)
VALA_EXTERN GtkWindow* menu_bar_get_keyboard_window (MenuBar* self);
static GdkFilterReturn _slick_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent,
                                                               GdkEvent* event,
                                                               gpointer self);
static void slick_greeter_log_cb (const gchar* log_domain,
                           GLogLevelFlags log_level,
                           const gchar* message);
static gboolean slick_greeter_check_hidpi (void);
static void slick_greeter_set_keyboard_layout (void);
static void slick_greeter_enable_tap_to_click (void);
static void slick_greeter_activate_numlock (void);
static gint slick_greeter_main (gchar** args,
                         gint args_length1);
static void _slick_greeter_log_cb_glog_func (const gchar* log_domain,
                                      GLogLevelFlags log_levels,
                                      const gchar* message,
                                      gpointer self);
VALA_EXTERN void ug_settings_apply_conf_settings (void);
VALA_EXTERN gboolean ug_settings_get_boolean (const gchar* key);
VALA_EXTERN gint ug_settings_get_integer (const gchar* key);
VALA_EXTERN gdouble ug_settings_get_double (const gchar* key);
static gboolean __lambda62_ (void);
static gboolean ___lambda62__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void slick_greeter_finalize (SlickGreeter * obj);
static GType slick_greeter_get_type_once (void);
VALA_EXTERN void dialog_dbus_interface_open (DialogDBusInterface* self,
                                 guint32 type,
                                 guint32 timestamp,
                                 guint32 seconds_to_stay_open,
                                 char** inhibitor_object_paths,
                                 gint inhibitor_object_paths_length1,
                                 GError** error);
VALA_EXTERN void dialog_dbus_interface_close (DialogDBusInterface* self,
                                  GError** error);
static GType dialog_dbus_interface_get_type_once (void);
static void _dbus_dialog_dbus_interface_open (DialogDBusInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_dialog_dbus_interface_close (DialogDBusInterface* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void dialog_dbus_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* dialog_dbus_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean dialog_dbus_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _dbus_dialog_dbus_interface_open_dialog (GObject* _sender,
                                              guint32 type,
                                              gpointer* _data);
static void _dbus_dialog_dbus_interface_close_dialog (GObject* _sender,
                                               gpointer* _data);
static void _dialog_dbus_interface_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static GRegex* _tmp_regex_2 = NULL;
static GRegex* _tmp_regex_3 = NULL;
static const GDBusArgInfo _dialog_dbus_interface_dbus_arg_info_open_type = {-1, "type", "u", NULL};
static const GDBusArgInfo _dialog_dbus_interface_dbus_arg_info_open_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo _dialog_dbus_interface_dbus_arg_info_open_seconds_to_stay_open = {-1, "seconds_to_stay_open", "u", NULL};
static const GDBusArgInfo _dialog_dbus_interface_dbus_arg_info_open_inhibitor_object_paths = {-1, "inhibitor_object_paths", "ao", NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_open_in[] = {&_dialog_dbus_interface_dbus_arg_info_open_type, &_dialog_dbus_interface_dbus_arg_info_open_timestamp, &_dialog_dbus_interface_dbus_arg_info_open_seconds_to_stay_open, &_dialog_dbus_interface_dbus_arg_info_open_inhibitor_object_paths, NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_open_out[] = {NULL};
static const GDBusMethodInfo _dialog_dbus_interface_dbus_method_info_open = {-1, "Open", (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_open_in), (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_open_out), NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_close_in[] = {NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_close_out[] = {NULL};
static const GDBusMethodInfo _dialog_dbus_interface_dbus_method_info_close = {-1, "Close", (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_close_in), (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_close_out), NULL};
static const GDBusMethodInfo * const _dialog_dbus_interface_dbus_method_info[] = {&_dialog_dbus_interface_dbus_method_info_open, &_dialog_dbus_interface_dbus_method_info_close, NULL};
static const GDBusArgInfo _dialog_dbus_interface_dbus_arg_info_open_dialog_type = {-1, "type", "u", NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_open_dialog[] = {&_dialog_dbus_interface_dbus_arg_info_open_dialog_type, NULL};
static const GDBusSignalInfo _dialog_dbus_interface_dbus_signal_info_open_dialog = {-1, "OpenDialog", (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_open_dialog), NULL};
static const GDBusArgInfo * const _dialog_dbus_interface_dbus_arg_info_close_dialog[] = {NULL};
static const GDBusSignalInfo _dialog_dbus_interface_dbus_signal_info_close_dialog = {-1, "CloseDialog", (GDBusArgInfo **) (&_dialog_dbus_interface_dbus_arg_info_close_dialog), NULL};
static const GDBusSignalInfo * const _dialog_dbus_interface_dbus_signal_info[] = {&_dialog_dbus_interface_dbus_signal_info_open_dialog, &_dialog_dbus_interface_dbus_signal_info_close_dialog, NULL};
static const GDBusPropertyInfo * const _dialog_dbus_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dialog_dbus_interface_dbus_interface_info = {-1, "org.gnome.SessionManager.EndSessionDialog", (GDBusMethodInfo **) (&_dialog_dbus_interface_dbus_method_info), (GDBusSignalInfo **) (&_dialog_dbus_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_dialog_dbus_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _dialog_dbus_interface_dbus_interface_vtable = {dialog_dbus_interface_dbus_interface_method_call, dialog_dbus_interface_dbus_interface_get_property, dialog_dbus_interface_dbus_interface_set_property};

static inline gpointer
slick_greeter_get_instance_private (SlickGreeter* self)
{
	return G_STRUCT_MEMBER_P (self, SlickGreeter_private_offset);
}

static gpointer
_slick_greeter_ref0 (gpointer self)
{
#line 51 "../src/slick-greeter.vala"
	return self ? slick_greeter_ref (self) : NULL;
#line 512 "slick-greeter.c"
}

static void
__lambda54_ (SlickGreeter* self,
             const gchar* text,
             LightDMMessageType type)
{
#line 59 "../src/slick-greeter.vala"
	g_return_if_fail (text != NULL);
#line 59 "../src/slick-greeter.vala"
	g_signal_emit (self, slick_greeter_signals[SLICK_GREETER_SHOW_MESSAGE_SIGNAL], 0, text, type);
#line 524 "slick-greeter.c"
}

static void
___lambda54__lightdm_greeter_show_message (LightDMGreeter* _sender,
                                           const gchar* text,
                                           LightDMMessageType type,
                                           gpointer self)
{
#line 59 "../src/slick-greeter.vala"
	__lambda54_ ((SlickGreeter*) self, text, type);
#line 535 "slick-greeter.c"
}

static void
__lambda55_ (SlickGreeter* self,
             const gchar* text,
             LightDMPromptType type)
{
#line 60 "../src/slick-greeter.vala"
	g_return_if_fail (text != NULL);
#line 60 "../src/slick-greeter.vala"
	g_signal_emit (self, slick_greeter_signals[SLICK_GREETER_SHOW_PROMPT_SIGNAL], 0, text, type);
#line 547 "slick-greeter.c"
}

static void
___lambda55__lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                          const gchar* text,
                                          LightDMPromptType type,
                                          gpointer self)
{
#line 60 "../src/slick-greeter.vala"
	__lambda55_ ((SlickGreeter*) self, text, type);
#line 558 "slick-greeter.c"
}

static void
__lambda56_ (SlickGreeter* self)
{
	GError* _inner_error0_ = NULL;
	{
		LightDMGreeter* _tmp0_;
#line 63 "../src/slick-greeter.vala"
		_tmp0_ = self->priv->greeter;
#line 63 "../src/slick-greeter.vala"
		lightdm_greeter_authenticate_autologin (_tmp0_, &_inner_error0_);
#line 63 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 573 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 62 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 62 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 66 "../src/slick-greeter.vala"
		_tmp1_ = e;
#line 66 "../src/slick-greeter.vala"
		_tmp2_ = _tmp1_->message;
#line 66 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:66: Unable to authenticate autologin: %s", _tmp2_);
#line 62 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 595 "slick-greeter.c"
	}
	__finally0:
#line 62 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 62 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 62 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 62 "../src/slick-greeter.vala"
		return;
#line 606 "slick-greeter.c"
	}
}

static void
___lambda56__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender,
                                                      gpointer self)
{
#line 61 "../src/slick-greeter.vala"
	__lambda56_ ((SlickGreeter*) self);
#line 616 "slick-greeter.c"
}

static void
__lambda57_ (SlickGreeter* self)
{
#line 70 "../src/slick-greeter.vala"
	g_signal_emit (self, slick_greeter_signals[SLICK_GREETER_AUTHENTICATION_COMPLETE_SIGNAL], 0);
#line 624 "slick-greeter.c"
}

static void
___lambda57__lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                      gpointer self)
{
#line 70 "../src/slick-greeter.vala"
	__lambda57_ ((SlickGreeter*) self);
#line 633 "slick-greeter.c"
}

static void
__lambda58_ (SlickGreeter* self)
{
#line 102 "../src/slick-greeter.vala"
	slick_greeter_kill_fake_wm (self);
#line 641 "slick-greeter.c"
}

static void
___lambda58__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
#line 102 "../src/slick-greeter.vala"
	__lambda58_ ((SlickGreeter*) self);
#line 650 "slick-greeter.c"
}

static gboolean
__lambda59_ (SlickGreeter* self)
{
	gboolean result;
#line 105 "../src/slick-greeter.vala"
	gtk_main_quit ();
#line 106 "../src/slick-greeter.vala"
	result = FALSE;
#line 106 "../src/slick-greeter.vala"
	return result;
#line 663 "slick-greeter.c"
}

static gboolean
___lambda59__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda59_ ((SlickGreeter*) self);
#line 103 "../src/slick-greeter.vala"
	return result;
#line 675 "slick-greeter.c"
}

static void
__lambda60_ (SlickGreeter* self,
             guint32 type)
{
	ShutdownDialogType dialog_type = 0;
	MainWindow* _tmp0_;
#line 115 "../src/slick-greeter.vala"
	switch (type) {
#line 686 "slick-greeter.c"
		default:
#line 115 "../src/slick-greeter.vala"
		case 1:
#line 690 "slick-greeter.c"
		{
#line 119 "../src/slick-greeter.vala"
			dialog_type = SHUTDOWN_DIALOG_TYPE_LOGOUT;
#line 120 "../src/slick-greeter.vala"
			break;
#line 696 "slick-greeter.c"
		}
#line 115 "../src/slick-greeter.vala"
		case 2:
#line 700 "slick-greeter.c"
		{
#line 122 "../src/slick-greeter.vala"
			dialog_type = SHUTDOWN_DIALOG_TYPE_RESTART;
#line 123 "../src/slick-greeter.vala"
			break;
#line 706 "slick-greeter.c"
		}
	}
#line 125 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->main_window;
#line 125 "../src/slick-greeter.vala"
	main_window_show_shutdown_dialog (_tmp0_, dialog_type);
#line 713 "slick-greeter.c"
}

static void
___lambda60__dialog_dbus_interface_open_dialog (DialogDBusInterface* _sender,
                                                guint32 type,
                                                gpointer self)
{
#line 112 "../src/slick-greeter.vala"
	__lambda60_ ((SlickGreeter*) self, type);
#line 723 "slick-greeter.c"
}

static void
__lambda61_ (SlickGreeter* self,
             DialogDBusInterface* type)
{
	MainWindow* _tmp0_;
#line 127 "../src/slick-greeter.vala"
	g_return_if_fail (type != NULL);
#line 127 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->main_window;
#line 127 "../src/slick-greeter.vala"
	main_window_close_shutdown_dialog (_tmp0_);
#line 737 "slick-greeter.c"
}

static void
___lambda61__dialog_dbus_interface_close_dialog (DialogDBusInterface* _sender,
                                                 gpointer self)
{
#line 127 "../src/slick-greeter.vala"
	__lambda61_ ((SlickGreeter*) self, _sender);
#line 746 "slick-greeter.c"
}

static gboolean
_slick_greeter_ready_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = slick_greeter_ready_cb ((SlickGreeter*) self);
#line 130 "../src/slick-greeter.vala"
	return result;
#line 756 "slick-greeter.c"
}

static SlickGreeter*
slick_greeter_construct (GType object_type,
                         gboolean test_mode_)
{
	SlickGreeter* self = NULL;
	SlickGreeter* _tmp0_;
	GdkScreen* _tmp1_;
	cairo_surface_t* _tmp2_;
	LightDMGreeter* _tmp3_;
	LightDMGreeter* _tmp4_;
	LightDMGreeter* _tmp5_;
	LightDMGreeter* _tmp6_;
	LightDMGreeter* _tmp7_;
	gboolean connected = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar* state_dir = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* xdg_seat = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gchar* state_file_name = NULL;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	GKeyFile* _tmp28_;
	MainWindow* _tmp35_;
	MainWindow* _tmp36_;
	MainWindow* _tmp37_;
	DialogDBusInterface* _tmp38_;
	DialogDBusInterface* _tmp39_;
	DialogDBusInterface* _tmp40_;
	GError* _inner_error0_ = NULL;
#line 49 "../src/slick-greeter.vala"
	self = (SlickGreeter*) g_type_create_instance (object_type);
#line 51 "../src/slick-greeter.vala"
	_tmp0_ = _slick_greeter_ref0 (self);
#line 51 "../src/slick-greeter.vala"
	_slick_greeter_unref0 (slick_greeter_singleton);
#line 51 "../src/slick-greeter.vala"
	slick_greeter_singleton = _tmp0_;
#line 52 "../src/slick-greeter.vala"
	self->test_mode = test_mode_;
#line 55 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:55: Creating background surface");
#line 56 "../src/slick-greeter.vala"
	_tmp1_ = gdk_screen_get_default ();
#line 56 "../src/slick-greeter.vala"
	_tmp2_ = slick_greeter_create_root_surface (_tmp1_);
#line 56 "../src/slick-greeter.vala"
	_cairo_surface_destroy0 (self->priv->background_surface);
#line 56 "../src/slick-greeter.vala"
	self->priv->background_surface = _tmp2_;
#line 58 "../src/slick-greeter.vala"
	_tmp3_ = lightdm_greeter_new ();
#line 58 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->greeter);
#line 58 "../src/slick-greeter.vala"
	self->priv->greeter = _tmp3_;
#line 59 "../src/slick-greeter.vala"
	_tmp4_ = self->priv->greeter;
#line 59 "../src/slick-greeter.vala"
	g_signal_connect (_tmp4_, "show-message", (GCallback) ___lambda54__lightdm_greeter_show_message, self);
#line 60 "../src/slick-greeter.vala"
	_tmp5_ = self->priv->greeter;
#line 60 "../src/slick-greeter.vala"
	g_signal_connect (_tmp5_, "show-prompt", (GCallback) ___lambda55__lightdm_greeter_show_prompt, self);
#line 61 "../src/slick-greeter.vala"
	_tmp6_ = self->priv->greeter;
#line 61 "../src/slick-greeter.vala"
	g_signal_connect (_tmp6_, "autologin-timer-expired", (GCallback) ___lambda56__lightdm_greeter_autologin_timer_expired, self);
#line 70 "../src/slick-greeter.vala"
	_tmp7_ = self->priv->greeter;
#line 70 "../src/slick-greeter.vala"
	g_signal_connect (_tmp7_, "authentication-complete", (GCallback) ___lambda57__lightdm_greeter_authentication_complete, self);
#line 71 "../src/slick-greeter.vala"
	connected = FALSE;
#line 840 "slick-greeter.c"
	{
		gboolean _tmp8_ = FALSE;
		LightDMGreeter* _tmp9_;
#line 74 "../src/slick-greeter.vala"
		_tmp9_ = self->priv->greeter;
#line 74 "../src/slick-greeter.vala"
		_tmp8_ = lightdm_greeter_connect_to_daemon_sync (_tmp9_, &_inner_error0_);
#line 74 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 850 "slick-greeter.c"
			goto __catch0_g_error;
		}
#line 74 "../src/slick-greeter.vala"
		connected = _tmp8_;
#line 855 "slick-greeter.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 72 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 72 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 78 "../src/slick-greeter.vala"
		_tmp10_ = e;
#line 78 "../src/slick-greeter.vala"
		_tmp11_ = _tmp10_->message;
#line 78 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:78: Failed to connect to LightDM daemon: %s", _tmp11_);
#line 72 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 875 "slick-greeter.c"
	}
	__finally0:
#line 72 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 72 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 72 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 72 "../src/slick-greeter.vala"
		return NULL;
#line 886 "slick-greeter.c"
	}
#line 80 "../src/slick-greeter.vala"
	if (!connected) {
#line 80 "../src/slick-greeter.vala"
		_tmp12_ = !self->test_mode;
#line 892 "slick-greeter.c"
	} else {
#line 80 "../src/slick-greeter.vala"
		_tmp12_ = FALSE;
#line 896 "slick-greeter.c"
	}
#line 80 "../src/slick-greeter.vala"
	if (_tmp12_) {
#line 81 "../src/slick-greeter.vala"
		exit (EXIT_FAILURE);
#line 902 "slick-greeter.c"
	}
#line 83 "../src/slick-greeter.vala"
	_tmp13_ = g_get_user_cache_dir ();
#line 83 "../src/slick-greeter.vala"
	_tmp14_ = g_build_filename (_tmp13_, "slick-greeter", NULL);
#line 83 "../src/slick-greeter.vala"
	state_dir = _tmp14_;
#line 84 "../src/slick-greeter.vala"
	_tmp15_ = state_dir;
#line 84 "../src/slick-greeter.vala"
	g_mkdir_with_parents (_tmp15_, 0775);
#line 86 "../src/slick-greeter.vala"
	_tmp16_ = g_getenv ("XDG_SEAT");
#line 86 "../src/slick-greeter.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 86 "../src/slick-greeter.vala"
	xdg_seat = _tmp17_;
#line 87 "../src/slick-greeter.vala"
	_tmp20_ = xdg_seat;
#line 87 "../src/slick-greeter.vala"
	if (_tmp20_ != NULL) {
#line 924 "slick-greeter.c"
		const gchar* _tmp21_;
#line 87 "../src/slick-greeter.vala"
		_tmp21_ = xdg_seat;
#line 87 "../src/slick-greeter.vala"
		_tmp19_ = g_strcmp0 (_tmp21_, "seat0") != 0;
#line 930 "slick-greeter.c"
	} else {
#line 87 "../src/slick-greeter.vala"
		_tmp19_ = FALSE;
#line 934 "slick-greeter.c"
	}
#line 87 "../src/slick-greeter.vala"
	if (_tmp19_) {
#line 938 "slick-greeter.c"
		const gchar* _tmp22_;
		gchar* _tmp23_;
#line 87 "../src/slick-greeter.vala"
		_tmp22_ = xdg_seat;
#line 87 "../src/slick-greeter.vala"
		_tmp23_ = g_strconcat (_tmp22_, "-state", NULL);
#line 87 "../src/slick-greeter.vala"
		_g_free0 (_tmp18_);
#line 87 "../src/slick-greeter.vala"
		_tmp18_ = _tmp23_;
#line 949 "slick-greeter.c"
	} else {
		gchar* _tmp24_;
#line 87 "../src/slick-greeter.vala"
		_tmp24_ = g_strdup ("state");
#line 87 "../src/slick-greeter.vala"
		_g_free0 (_tmp18_);
#line 87 "../src/slick-greeter.vala"
		_tmp18_ = _tmp24_;
#line 958 "slick-greeter.c"
	}
#line 87 "../src/slick-greeter.vala"
	_tmp25_ = g_strdup (_tmp18_);
#line 87 "../src/slick-greeter.vala"
	state_file_name = _tmp25_;
#line 89 "../src/slick-greeter.vala"
	_tmp26_ = state_dir;
#line 89 "../src/slick-greeter.vala"
	_tmp27_ = g_build_filename (_tmp26_, state_file_name, NULL);
#line 89 "../src/slick-greeter.vala"
	_g_free0 (self->priv->state_file);
#line 89 "../src/slick-greeter.vala"
	self->priv->state_file = _tmp27_;
#line 90 "../src/slick-greeter.vala"
	_tmp28_ = g_key_file_new ();
#line 90 "../src/slick-greeter.vala"
	_g_key_file_unref0 (self->priv->state);
#line 90 "../src/slick-greeter.vala"
	self->priv->state = _tmp28_;
#line 978 "slick-greeter.c"
	{
		GKeyFile* _tmp29_;
		const gchar* _tmp30_;
#line 93 "../src/slick-greeter.vala"
		_tmp29_ = self->priv->state;
#line 93 "../src/slick-greeter.vala"
		_tmp30_ = self->priv->state_file;
#line 93 "../src/slick-greeter.vala"
		g_key_file_load_from_file (_tmp29_, _tmp30_, G_KEY_FILE_NONE, &_inner_error0_);
#line 93 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 990 "slick-greeter.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
#line 91 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 91 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 97 "../src/slick-greeter.vala"
		_tmp31_ = e;
#line 97 "../src/slick-greeter.vala"
		if (!g_error_matches (_tmp31_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
#line 1007 "slick-greeter.c"
			const gchar* _tmp32_;
			GError* _tmp33_;
			const gchar* _tmp34_;
#line 98 "../src/slick-greeter.vala"
			_tmp32_ = self->priv->state_file;
#line 98 "../src/slick-greeter.vala"
			_tmp33_ = e;
#line 98 "../src/slick-greeter.vala"
			_tmp34_ = _tmp33_->message;
#line 98 "../src/slick-greeter.vala"
			g_warning ("slick-greeter.vala:98: Failed to load state from %s: %s\n", _tmp32_, _tmp34_);
#line 1019 "slick-greeter.c"
		}
#line 91 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 1023 "slick-greeter.c"
	}
	__finally1:
#line 91 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "../src/slick-greeter.vala"
		_g_free0 (state_file_name);
#line 91 "../src/slick-greeter.vala"
		_g_free0 (_tmp18_);
#line 91 "../src/slick-greeter.vala"
		_g_free0 (xdg_seat);
#line 91 "../src/slick-greeter.vala"
		_g_free0 (state_dir);
#line 91 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 91 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 91 "../src/slick-greeter.vala"
		return NULL;
#line 1042 "slick-greeter.c"
	}
#line 101 "../src/slick-greeter.vala"
	_tmp35_ = main_window_new ();
#line 101 "../src/slick-greeter.vala"
	g_object_ref_sink (_tmp35_);
#line 101 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->main_window);
#line 101 "../src/slick-greeter.vala"
	self->priv->main_window = _tmp35_;
#line 102 "../src/slick-greeter.vala"
	_tmp36_ = self->priv->main_window;
#line 102 "../src/slick-greeter.vala"
	g_signal_connect ((GtkWidget*) _tmp36_, "destroy", (GCallback) ___lambda58__gtk_widget_destroy, self);
#line 103 "../src/slick-greeter.vala"
	_tmp37_ = self->priv->main_window;
#line 103 "../src/slick-greeter.vala"
	g_signal_connect ((GtkWidget*) _tmp37_, "delete-event", (GCallback) ___lambda59__gtk_widget_delete_event, self);
#line 109 "../src/slick-greeter.vala"
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "x.dm.SlickGreeter", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 111 "../src/slick-greeter.vala"
	_tmp38_ = dialog_dbus_interface_new ();
#line 111 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->dbus_object);
#line 111 "../src/slick-greeter.vala"
	self->priv->dbus_object = _tmp38_;
#line 112 "../src/slick-greeter.vala"
	_tmp39_ = self->priv->dbus_object;
#line 112 "../src/slick-greeter.vala"
	g_signal_connect (_tmp39_, "open-dialog", (GCallback) ___lambda60__dialog_dbus_interface_open_dialog, self);
#line 127 "../src/slick-greeter.vala"
	_tmp40_ = self->priv->dbus_object;
#line 127 "../src/slick-greeter.vala"
	g_signal_connect (_tmp40_, "close-dialog", (GCallback) ___lambda61__dialog_dbus_interface_close_dialog, self);
#line 129 "../src/slick-greeter.vala"
	slick_greeter_start_fake_wm (self);
#line 130 "../src/slick-greeter.vala"
	gdk_threads_add_idle (_slick_greeter_ready_cb_gsource_func, self);
#line 49 "../src/slick-greeter.vala"
	_g_free0 (state_file_name);
#line 49 "../src/slick-greeter.vala"
	_g_free0 (_tmp18_);
#line 49 "../src/slick-greeter.vala"
	_g_free0 (xdg_seat);
#line 49 "../src/slick-greeter.vala"
	_g_free0 (state_dir);
#line 49 "../src/slick-greeter.vala"
	return self;
#line 1090 "slick-greeter.c"
}

static SlickGreeter*
slick_greeter_new (gboolean test_mode_)
{
#line 49 "../src/slick-greeter.vala"
	return slick_greeter_construct (TYPE_SLICK_GREETER, test_mode_);
#line 1098 "slick-greeter.c"
}

gchar*
slick_greeter_get_state (SlickGreeter* self,
                         const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 133 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "../src/slick-greeter.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1111 "slick-greeter.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 137 "../src/slick-greeter.vala"
		_tmp1_ = self->priv->state;
#line 137 "../src/slick-greeter.vala"
		_tmp2_ = g_key_file_get_value (_tmp1_, "greeter", key, &_inner_error0_);
#line 137 "../src/slick-greeter.vala"
		_tmp0_ = _tmp2_;
#line 137 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1125 "slick-greeter.c"
			goto __catch0_g_error;
		}
#line 137 "../src/slick-greeter.vala"
		_tmp3_ = _tmp0_;
#line 137 "../src/slick-greeter.vala"
		_tmp0_ = NULL;
#line 137 "../src/slick-greeter.vala"
		result = _tmp3_;
#line 137 "../src/slick-greeter.vala"
		_g_free0 (_tmp0_);
#line 137 "../src/slick-greeter.vala"
		return result;
#line 1138 "slick-greeter.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 135 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 141 "../src/slick-greeter.vala"
		result = NULL;
#line 141 "../src/slick-greeter.vala"
		return result;
#line 1149 "slick-greeter.c"
	}
	__finally0:
#line 135 "../src/slick-greeter.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 135 "../src/slick-greeter.vala"
	g_clear_error (&_inner_error0_);
#line 135 "../src/slick-greeter.vala"
	return NULL;
#line 1158 "slick-greeter.c"
}

void
slick_greeter_set_state (SlickGreeter* self,
                         const gchar* key,
                         const gchar* value)
{
	GKeyFile* _tmp0_;
	gchar* data = NULL;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 145 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 145 "../src/slick-greeter.vala"
	g_return_if_fail (key != NULL);
#line 145 "../src/slick-greeter.vala"
	g_return_if_fail (value != NULL);
#line 147 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->state;
#line 147 "../src/slick-greeter.vala"
	g_key_file_set_value (_tmp0_, "greeter", key, value);
#line 148 "../src/slick-greeter.vala"
	_tmp1_ = self->priv->state;
#line 148 "../src/slick-greeter.vala"
	_tmp2_ = g_key_file_to_data (_tmp1_, NULL, NULL);
#line 148 "../src/slick-greeter.vala"
	data = _tmp2_;
#line 1187 "slick-greeter.c"
	{
		const gchar* _tmp3_;
#line 151 "../src/slick-greeter.vala"
		_tmp3_ = self->priv->state_file;
#line 151 "../src/slick-greeter.vala"
		g_file_set_contents (_tmp3_, data, (gssize) -1, &_inner_error0_);
#line 151 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1196 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 149 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 149 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 155 "../src/slick-greeter.vala"
		_tmp4_ = e;
#line 155 "../src/slick-greeter.vala"
		_tmp5_ = _tmp4_->message;
#line 155 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:155: Failed to write state: %s", _tmp5_);
#line 149 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 1218 "slick-greeter.c"
	}
	__finally0:
#line 149 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 149 "../src/slick-greeter.vala"
		_g_free0 (data);
#line 149 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 149 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 149 "../src/slick-greeter.vala"
		return;
#line 1231 "slick-greeter.c"
	}
#line 145 "../src/slick-greeter.vala"
	_g_free0 (data);
#line 1235 "slick-greeter.c"
}

void
slick_greeter_push_list (SlickGreeter* self,
                         GreeterList* widget)
{
	MainWindow* _tmp0_;
#line 159 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 159 "../src/slick-greeter.vala"
	g_return_if_fail (widget != NULL);
#line 161 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->main_window;
#line 161 "../src/slick-greeter.vala"
	main_window_push_list (_tmp0_, widget);
#line 1251 "slick-greeter.c"
}

void
slick_greeter_pop_list (SlickGreeter* self)
{
	MainWindow* _tmp0_;
#line 164 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 166 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->main_window;
#line 166 "../src/slick-greeter.vala"
	main_window_pop_list (_tmp0_);
#line 1264 "slick-greeter.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 172 "../src/slick-greeter.vala"
	return self ? g_object_ref (self) : NULL;
#line 1272 "slick-greeter.c"
}

void
slick_greeter_add_style_class (GtkWidget* widget)
{
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
#line 169 "../src/slick-greeter.vala"
	g_return_if_fail (widget != NULL);
#line 172 "../src/slick-greeter.vala"
	_tmp0_ = gtk_widget_get_style_context (widget);
#line 172 "../src/slick-greeter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 172 "../src/slick-greeter.vala"
	ctx = _tmp1_;
#line 173 "../src/slick-greeter.vala"
	gtk_style_context_add_class (ctx, "lightdm");
#line 169 "../src/slick-greeter.vala"
	_g_object_unref0 (ctx);
#line 1293 "slick-greeter.c"
}

static void
_g_free0_ (gpointer var)
{
#line 206 "../src/slick-greeter.vala"
	var = (g_free (var), NULL);
#line 1301 "slick-greeter.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 206 "../src/slick-greeter.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 1309 "slick-greeter.c"
}

gchar*
slick_greeter_get_default_session (void)
{
	GList* sessions = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GList* _tmp23_;
	GList* _tmp31_;
	gchar* result;
#line 178 "../src/slick-greeter.vala"
	sessions = NULL;
#line 179 "../src/slick-greeter.vala"
	_tmp0_ = g_strdup ("cinnamon");
#line 179 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp0_);
#line 180 "../src/slick-greeter.vala"
	_tmp1_ = g_strdup ("mate");
#line 180 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp1_);
#line 181 "../src/slick-greeter.vala"
	_tmp2_ = g_strdup ("xfce");
#line 181 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp2_);
#line 182 "../src/slick-greeter.vala"
	_tmp3_ = g_strdup ("plasma");
#line 182 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp3_);
#line 183 "../src/slick-greeter.vala"
	_tmp4_ = g_strdup ("kde-plasma");
#line 183 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp4_);
#line 184 "../src/slick-greeter.vala"
	_tmp5_ = g_strdup ("kde");
#line 184 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp5_);
#line 185 "../src/slick-greeter.vala"
	_tmp6_ = g_strdup ("budgie-desktop");
#line 185 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp6_);
#line 186 "../src/slick-greeter.vala"
	_tmp7_ = g_strdup ("gnome");
#line 186 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp7_);
#line 187 "../src/slick-greeter.vala"
	_tmp8_ = g_strdup ("LXDE");
#line 187 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp8_);
#line 188 "../src/slick-greeter.vala"
	_tmp9_ = g_strdup ("lxqt");
#line 188 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp9_);
#line 189 "../src/slick-greeter.vala"
	_tmp10_ = g_strdup ("pekwm");
#line 189 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp10_);
#line 190 "../src/slick-greeter.vala"
	_tmp11_ = g_strdup ("pantheon");
#line 190 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp11_);
#line 191 "../src/slick-greeter.vala"
	_tmp12_ = g_strdup ("i3");
#line 191 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp12_);
#line 192 "../src/slick-greeter.vala"
	_tmp13_ = g_strdup ("sway");
#line 192 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp13_);
#line 193 "../src/slick-greeter.vala"
	_tmp14_ = g_strdup ("enlightenment");
#line 193 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp14_);
#line 194 "../src/slick-greeter.vala"
	_tmp15_ = g_strdup ("deepin");
#line 194 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp15_);
#line 195 "../src/slick-greeter.vala"
	_tmp16_ = g_strdup ("openbox");
#line 195 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp16_);
#line 196 "../src/slick-greeter.vala"
	_tmp17_ = g_strdup ("awesome");
#line 196 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp17_);
#line 197 "../src/slick-greeter.vala"
	_tmp18_ = g_strdup ("gnome-xorg");
#line 197 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp18_);
#line 198 "../src/slick-greeter.vala"
	_tmp19_ = g_strdup ("ubuntu-xorg");
#line 198 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp19_);
#line 199 "../src/slick-greeter.vala"
	_tmp20_ = g_strdup ("fynedesk");
#line 199 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp20_);
#line 200 "../src/slick-greeter.vala"
	_tmp21_ = g_strdup ("icewm");
#line 200 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp21_);
#line 201 "../src/slick-greeter.vala"
	_tmp22_ = g_strdup ("jwm");
#line 201 "../src/slick-greeter.vala"
	sessions = g_list_append (sessions, _tmp22_);
#line 203 "../src/slick-greeter.vala"
	_tmp23_ = sessions;
#line 1438 "slick-greeter.c"
	{
		GList* session_collection = NULL;
		GList* session_it = NULL;
#line 203 "../src/slick-greeter.vala"
		session_collection = _tmp23_;
#line 203 "../src/slick-greeter.vala"
		for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
#line 1446 "slick-greeter.c"
			gchar* _tmp24_;
			gchar* session = NULL;
#line 203 "../src/slick-greeter.vala"
			_tmp24_ = g_strdup ((const gchar*) session_it->data);
#line 203 "../src/slick-greeter.vala"
			session = _tmp24_;
#line 1453 "slick-greeter.c"
			{
				gchar* path = NULL;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
#line 204 "../src/slick-greeter.vala"
				_tmp25_ = session;
#line 204 "../src/slick-greeter.vala"
				_tmp26_ = g_strconcat (_tmp25_, ".desktop", NULL);
#line 204 "../src/slick-greeter.vala"
				_tmp27_ = _tmp26_;
#line 204 "../src/slick-greeter.vala"
				_tmp28_ = g_build_filename ("/usr/share/xsessions/", _tmp27_, NULL, NULL);
#line 204 "../src/slick-greeter.vala"
				_tmp29_ = _tmp28_;
#line 204 "../src/slick-greeter.vala"
				_g_free0 (_tmp27_);
#line 204 "../src/slick-greeter.vala"
				path = _tmp29_;
#line 205 "../src/slick-greeter.vala"
				_tmp30_ = path;
#line 205 "../src/slick-greeter.vala"
				if (g_file_test (_tmp30_, G_FILE_TEST_EXISTS)) {
#line 206 "../src/slick-greeter.vala"
					result = session;
#line 206 "../src/slick-greeter.vala"
					_g_free0 (path);
#line 206 "../src/slick-greeter.vala"
					(sessions == NULL) ? NULL : (sessions = (_g_list_free__g_free0_ (sessions), NULL));
#line 206 "../src/slick-greeter.vala"
					return result;
#line 1488 "slick-greeter.c"
				}
#line 203 "../src/slick-greeter.vala"
				_g_free0 (path);
#line 203 "../src/slick-greeter.vala"
				_g_free0 (session);
#line 1494 "slick-greeter.c"
			}
		}
	}
#line 210 "../src/slick-greeter.vala"
	_tmp31_ = sessions;
#line 1500 "slick-greeter.c"
	{
		GList* session_collection = NULL;
		GList* session_it = NULL;
#line 210 "../src/slick-greeter.vala"
		session_collection = _tmp31_;
#line 210 "../src/slick-greeter.vala"
		for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
#line 1508 "slick-greeter.c"
			gchar* _tmp32_;
			gchar* session = NULL;
#line 210 "../src/slick-greeter.vala"
			_tmp32_ = g_strdup ((const gchar*) session_it->data);
#line 210 "../src/slick-greeter.vala"
			session = _tmp32_;
#line 1515 "slick-greeter.c"
			{
				gchar* path = NULL;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
#line 211 "../src/slick-greeter.vala"
				_tmp33_ = session;
#line 211 "../src/slick-greeter.vala"
				_tmp34_ = g_strconcat (_tmp33_, ".desktop", NULL);
#line 211 "../src/slick-greeter.vala"
				_tmp35_ = _tmp34_;
#line 211 "../src/slick-greeter.vala"
				_tmp36_ = g_build_filename ("/usr/share/wayland-sessions/", _tmp35_, NULL, NULL);
#line 211 "../src/slick-greeter.vala"
				_tmp37_ = _tmp36_;
#line 211 "../src/slick-greeter.vala"
				_g_free0 (_tmp35_);
#line 211 "../src/slick-greeter.vala"
				path = _tmp37_;
#line 212 "../src/slick-greeter.vala"
				_tmp38_ = path;
#line 212 "../src/slick-greeter.vala"
				if (g_file_test (_tmp38_, G_FILE_TEST_EXISTS)) {
#line 213 "../src/slick-greeter.vala"
					result = session;
#line 213 "../src/slick-greeter.vala"
					_g_free0 (path);
#line 213 "../src/slick-greeter.vala"
					(sessions == NULL) ? NULL : (sessions = (_g_list_free__g_free0_ (sessions), NULL));
#line 213 "../src/slick-greeter.vala"
					return result;
#line 1550 "slick-greeter.c"
				}
#line 210 "../src/slick-greeter.vala"
				_g_free0 (path);
#line 210 "../src/slick-greeter.vala"
				_g_free0 (session);
#line 1556 "slick-greeter.c"
			}
		}
	}
#line 217 "../src/slick-greeter.vala"
	g_warning ("slick-greeter.vala:217: Could not find a default session.");
#line 218 "../src/slick-greeter.vala"
	result = NULL;
#line 218 "../src/slick-greeter.vala"
	(sessions == NULL) ? NULL : (sessions = (_g_list_free__g_free0_ (sessions), NULL));
#line 218 "../src/slick-greeter.vala"
	return result;
#line 1568 "slick-greeter.c"
}

gchar*
slick_greeter_validate_session (const gchar* session)
{
	gchar* _tmp12_;
	gchar* result;
#line 225 "../src/slick-greeter.vala"
	if (session != NULL) {
#line 1578 "slick-greeter.c"
		gchar* path = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* waypath = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 226 "../src/slick-greeter.vala"
		_tmp0_ = g_strconcat (session, ".desktop", NULL);
#line 226 "../src/slick-greeter.vala"
		_tmp1_ = _tmp0_;
#line 226 "../src/slick-greeter.vala"
		_tmp2_ = g_build_filename ("/usr/share/xsessions/", _tmp1_, NULL, NULL);
#line 226 "../src/slick-greeter.vala"
		_tmp3_ = _tmp2_;
#line 226 "../src/slick-greeter.vala"
		_g_free0 (_tmp1_);
#line 226 "../src/slick-greeter.vala"
		path = _tmp3_;
#line 227 "../src/slick-greeter.vala"
		_tmp4_ = g_strconcat (session, ".desktop", NULL);
#line 227 "../src/slick-greeter.vala"
		_tmp5_ = _tmp4_;
#line 227 "../src/slick-greeter.vala"
		_tmp6_ = g_build_filename ("/usr/share/wayland-sessions/", _tmp5_, NULL, NULL);
#line 227 "../src/slick-greeter.vala"
		_tmp7_ = _tmp6_;
#line 227 "../src/slick-greeter.vala"
		_g_free0 (_tmp5_);
#line 227 "../src/slick-greeter.vala"
		waypath = _tmp7_;
#line 228 "../src/slick-greeter.vala"
		_tmp8_ = path;
#line 228 "../src/slick-greeter.vala"
		_tmp9_ = waypath;
#line 228 "../src/slick-greeter.vala"
		if ((!g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) & (!g_file_test (_tmp9_, G_FILE_TEST_EXISTS))) {
#line 229 "../src/slick-greeter.vala"
			g_debug ("slick-greeter.vala:229: Invalid session: '%s'", session);
#line 230 "../src/slick-greeter.vala"
			session = NULL;
#line 1625 "slick-greeter.c"
		}
#line 225 "../src/slick-greeter.vala"
		_g_free0 (waypath);
#line 225 "../src/slick-greeter.vala"
		_g_free0 (path);
#line 1631 "slick-greeter.c"
	}
#line 234 "../src/slick-greeter.vala"
	if (session == NULL) {
#line 1635 "slick-greeter.c"
		gchar* default_session = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_;
#line 235 "../src/slick-greeter.vala"
		_tmp10_ = slick_greeter_get_default_session ();
#line 235 "../src/slick-greeter.vala"
		default_session = _tmp10_;
#line 236 "../src/slick-greeter.vala"
		_tmp11_ = default_session;
#line 236 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:236: Using default session: '%s'", _tmp11_);
#line 237 "../src/slick-greeter.vala"
		result = default_session;
#line 237 "../src/slick-greeter.vala"
		return result;
#line 1651 "slick-greeter.c"
	}
#line 240 "../src/slick-greeter.vala"
	_tmp12_ = g_strdup (session);
#line 240 "../src/slick-greeter.vala"
	result = _tmp12_;
#line 240 "../src/slick-greeter.vala"
	return result;
#line 1659 "slick-greeter.c"
}

gboolean
slick_greeter_start_session (SlickGreeter* self,
                             const gchar* session,
                             Background* bg)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp2_;
	GdkMonitor* _tmp3_;
	GdkMonitor* _tmp4_;
	gint scale = 0;
	GdkMonitor* _tmp5_;
	cairo_surface_t* _tmp6_;
	MainWindow* _tmp7_;
	gboolean _result_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 243 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "../src/slick-greeter.vala"
	g_return_val_if_fail (bg != NULL, FALSE);
#line 246 "../src/slick-greeter.vala"
	_tmp0_ = gdk_display_get_default ();
#line 246 "../src/slick-greeter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 246 "../src/slick-greeter.vala"
	display = _tmp1_;
#line 247 "../src/slick-greeter.vala"
	_tmp2_ = display;
#line 247 "../src/slick-greeter.vala"
	_tmp3_ = gdk_display_get_primary_monitor (_tmp2_);
#line 247 "../src/slick-greeter.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 247 "../src/slick-greeter.vala"
	monitor = _tmp4_;
#line 248 "../src/slick-greeter.vala"
	_tmp5_ = monitor;
#line 248 "../src/slick-greeter.vala"
	scale = gdk_monitor_get_scale_factor (_tmp5_);
#line 249 "../src/slick-greeter.vala"
	_tmp6_ = self->priv->background_surface;
#line 249 "../src/slick-greeter.vala"
	cairo_surface_set_device_scale (_tmp6_, (gdouble) scale, (gdouble) scale);
#line 257 "../src/slick-greeter.vala"
	_tmp7_ = self->priv->main_window;
#line 257 "../src/slick-greeter.vala"
	main_window_before_session_start (_tmp7_);
#line 259 "../src/slick-greeter.vala"
	if (self->test_mode) {
#line 261 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:261: Successfully logged in! Quitting...");
#line 262 "../src/slick-greeter.vala"
		gtk_main_quit ();
#line 263 "../src/slick-greeter.vala"
		result = TRUE;
#line 263 "../src/slick-greeter.vala"
		_g_object_unref0 (monitor);
#line 263 "../src/slick-greeter.vala"
		_g_object_unref0 (display);
#line 263 "../src/slick-greeter.vala"
		return result;
#line 1725 "slick-greeter.c"
	}
#line 266 "../src/slick-greeter.vala"
	if (!slick_greeter_session_is_valid (self, session)) {
#line 1729 "slick-greeter.c"
		LightDMGreeter* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		LightDMGreeter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
#line 268 "../src/slick-greeter.vala"
		_tmp8_ = self->priv->greeter;
#line 268 "../src/slick-greeter.vala"
		_tmp9_ = lightdm_greeter_get_default_session_hint (_tmp8_);
#line 268 "../src/slick-greeter.vala"
		_tmp10_ = _tmp9_;
#line 268 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:268: Session %s is not available, using system defa" \
"ult %s instead", session, _tmp10_);
#line 269 "../src/slick-greeter.vala"
		_tmp11_ = self->priv->greeter;
#line 269 "../src/slick-greeter.vala"
		_tmp12_ = lightdm_greeter_get_default_session_hint (_tmp11_);
#line 269 "../src/slick-greeter.vala"
		_tmp13_ = _tmp12_;
#line 269 "../src/slick-greeter.vala"
		session = _tmp13_;
#line 1752 "slick-greeter.c"
	}
#line 272 "../src/slick-greeter.vala"
	_result_ = FALSE;
#line 1756 "slick-greeter.c"
	{
		gboolean _tmp14_ = FALSE;
		LightDMGreeter* _tmp15_;
#line 275 "../src/slick-greeter.vala"
		_tmp15_ = self->priv->greeter;
#line 275 "../src/slick-greeter.vala"
		_tmp14_ = lightdm_greeter_start_session_sync (_tmp15_, session, &_inner_error0_);
#line 275 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1766 "slick-greeter.c"
			goto __catch0_g_error;
		}
#line 275 "../src/slick-greeter.vala"
		_result_ = _tmp14_;
#line 1771 "slick-greeter.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 273 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 273 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 279 "../src/slick-greeter.vala"
		_tmp16_ = e;
#line 279 "../src/slick-greeter.vala"
		_tmp17_ = _tmp16_->message;
#line 279 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:279: Failed to start session: %s", _tmp17_);
#line 273 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 1791 "slick-greeter.c"
	}
	__finally0:
#line 273 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1796 "slick-greeter.c"
		gboolean _tmp18_ = FALSE;
#line 273 "../src/slick-greeter.vala"
		_g_object_unref0 (monitor);
#line 273 "../src/slick-greeter.vala"
		_g_object_unref0 (display);
#line 273 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 273 "../src/slick-greeter.vala"
		return _tmp18_;
#line 1808 "slick-greeter.c"
	}
#line 282 "../src/slick-greeter.vala"
	if (_result_) {
#line 283 "../src/slick-greeter.vala"
		g_signal_emit (self, slick_greeter_signals[SLICK_GREETER_STARTING_SESSION_SIGNAL], 0);
#line 1814 "slick-greeter.c"
	}
#line 285 "../src/slick-greeter.vala"
	result = _result_;
#line 285 "../src/slick-greeter.vala"
	_g_object_unref0 (monitor);
#line 285 "../src/slick-greeter.vala"
	_g_object_unref0 (display);
#line 285 "../src/slick-greeter.vala"
	return result;
#line 1824 "slick-greeter.c"
}

static gboolean
slick_greeter_session_is_valid (SlickGreeter* self,
                                const gchar* session)
{
	GList* _tmp0_;
	gboolean result;
#line 288 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 290 "../src/slick-greeter.vala"
	if (session == NULL) {
#line 291 "../src/slick-greeter.vala"
		result = TRUE;
#line 291 "../src/slick-greeter.vala"
		return result;
#line 1841 "slick-greeter.c"
	}
#line 293 "../src/slick-greeter.vala"
	_tmp0_ = lightdm_get_sessions ();
#line 1845 "slick-greeter.c"
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
#line 293 "../src/slick-greeter.vala"
		s_collection = _tmp0_;
#line 293 "../src/slick-greeter.vala"
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
#line 1853 "slick-greeter.c"
			LightDMSession* _tmp1_;
			LightDMSession* s = NULL;
#line 293 "../src/slick-greeter.vala"
			_tmp1_ = _g_object_ref0 ((LightDMSession*) s_it->data);
#line 293 "../src/slick-greeter.vala"
			s = _tmp1_;
#line 1860 "slick-greeter.c"
			{
				LightDMSession* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 294 "../src/slick-greeter.vala"
				_tmp2_ = s;
#line 294 "../src/slick-greeter.vala"
				_tmp3_ = lightdm_session_get_key (_tmp2_);
#line 294 "../src/slick-greeter.vala"
				_tmp4_ = _tmp3_;
#line 294 "../src/slick-greeter.vala"
				if (g_strcmp0 (_tmp4_, session) == 0) {
#line 295 "../src/slick-greeter.vala"
					result = TRUE;
#line 295 "../src/slick-greeter.vala"
					_g_object_unref0 (s);
#line 295 "../src/slick-greeter.vala"
					return result;
#line 1879 "slick-greeter.c"
				}
#line 293 "../src/slick-greeter.vala"
				_g_object_unref0 (s);
#line 1883 "slick-greeter.c"
			}
		}
	}
#line 297 "../src/slick-greeter.vala"
	result = FALSE;
#line 297 "../src/slick-greeter.vala"
	return result;
#line 1891 "slick-greeter.c"
}

static gboolean
slick_greeter_ready_cb (SlickGreeter* self)
{
	ca_context* _tmp0_ = NULL;
	gchar* sound_file = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
#line 300 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 302 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:302: starting system-ready sound");
#line 305 "../src/slick-greeter.vala"
	ca_context_create (&_tmp0_);
#line 305 "../src/slick-greeter.vala"
	_ca_context_destroy0 (self->priv->canberra_context);
#line 305 "../src/slick-greeter.vala"
	self->priv->canberra_context = _tmp0_;
#line 306 "../src/slick-greeter.vala"
	_tmp1_ = ug_settings_get_string (UG_SETTINGS_KEY_PLAY_READY_SOUND);
#line 306 "../src/slick-greeter.vala"
	sound_file = _tmp1_;
#line 307 "../src/slick-greeter.vala"
	_tmp2_ = sound_file;
#line 307 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp2_, "") != 0) {
#line 1920 "slick-greeter.c"
		ca_context* _tmp3_;
		const gchar* _tmp4_;
#line 308 "../src/slick-greeter.vala"
		_tmp3_ = self->priv->canberra_context;
#line 308 "../src/slick-greeter.vala"
		_tmp4_ = sound_file;
#line 308 "../src/slick-greeter.vala"
		ca_context_play (_tmp3_, (guint32) 0, CA_PROP_MEDIA_FILENAME, _tmp4_, NULL);
#line 1929 "slick-greeter.c"
	}
#line 309 "../src/slick-greeter.vala"
	result = FALSE;
#line 309 "../src/slick-greeter.vala"
	_g_free0 (sound_file);
#line 309 "../src/slick-greeter.vala"
	return result;
#line 1937 "slick-greeter.c"
}

void
slick_greeter_show (SlickGreeter* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp2_;
	MainWindow* _tmp3_;
	GdkWindow* _tmp4_;
	MainWindow* _tmp5_;
#line 312 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 314 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:314: Showing main window");
#line 315 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->main_window;
#line 315 "../src/slick-greeter.vala"
	gtk_widget_realize ((GtkWidget*) _tmp0_);
#line 316 "../src/slick-greeter.vala"
	_tmp1_ = self->priv->main_window;
#line 316 "../src/slick-greeter.vala"
	main_window_setup_window (_tmp1_);
#line 317 "../src/slick-greeter.vala"
	_tmp2_ = self->priv->main_window;
#line 317 "../src/slick-greeter.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 318 "../src/slick-greeter.vala"
	_tmp3_ = self->priv->main_window;
#line 318 "../src/slick-greeter.vala"
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) _tmp3_);
#line 318 "../src/slick-greeter.vala"
	gdk_window_focus (_tmp4_, (guint32) GDK_CURRENT_TIME);
#line 319 "../src/slick-greeter.vala"
	_tmp5_ = self->priv->main_window;
#line 319 "../src/slick-greeter.vala"
	main_window_set_keyboard_state (_tmp5_);
#line 1975 "slick-greeter.c"
}

gboolean
slick_greeter_is_authenticated (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 322 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 324 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 324 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_is_authenticated (_tmp0_);
#line 324 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 324 "../src/slick-greeter.vala"
	result = _tmp2_;
#line 324 "../src/slick-greeter.vala"
	return result;
#line 1997 "slick-greeter.c"
}

void
slick_greeter_authenticate (SlickGreeter* self,
                            const gchar* userid)
{
	GError* _inner_error0_ = NULL;
#line 327 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 2007 "slick-greeter.c"
	{
		LightDMGreeter* _tmp0_;
#line 330 "../src/slick-greeter.vala"
		_tmp0_ = self->priv->greeter;
#line 330 "../src/slick-greeter.vala"
		lightdm_greeter_authenticate (_tmp0_, userid, &_inner_error0_);
#line 330 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2016 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 329 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 329 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 333 "../src/slick-greeter.vala"
		_tmp1_ = e;
#line 333 "../src/slick-greeter.vala"
		_tmp2_ = _tmp1_->message;
#line 333 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:333: Unable to authenticate greeter for %s, %s", userid, _tmp2_);
#line 329 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 2038 "slick-greeter.c"
	}
	__finally0:
#line 329 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 329 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 329 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 329 "../src/slick-greeter.vala"
		return;
#line 2049 "slick-greeter.c"
	}
}

void
slick_greeter_authenticate_as_guest (SlickGreeter* self)
{
	GError* _inner_error0_ = NULL;
#line 337 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 2059 "slick-greeter.c"
	{
		LightDMGreeter* _tmp0_;
#line 340 "../src/slick-greeter.vala"
		_tmp0_ = self->priv->greeter;
#line 340 "../src/slick-greeter.vala"
		lightdm_greeter_authenticate_as_guest (_tmp0_, &_inner_error0_);
#line 340 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2068 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 339 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 339 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 343 "../src/slick-greeter.vala"
		_tmp1_ = e;
#line 343 "../src/slick-greeter.vala"
		_tmp2_ = _tmp1_->message;
#line 343 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:343: Unable to authenticate greeter for guest: %s", _tmp2_);
#line 339 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 2090 "slick-greeter.c"
	}
	__finally0:
#line 339 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 339 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 339 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 339 "../src/slick-greeter.vala"
		return;
#line 2101 "slick-greeter.c"
	}
}

void
slick_greeter_authenticate_remote (SlickGreeter* self,
                                   const gchar* session,
                                   const gchar* userid)
{
	GError* _inner_error0_ = NULL;
#line 347 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 347 "../src/slick-greeter.vala"
	g_return_if_fail (session != NULL);
#line 2115 "slick-greeter.c"
	{
		SlickGreeter* _tmp0_;
		LightDMGreeter* _tmp1_;
#line 350 "../src/slick-greeter.vala"
		_tmp0_ = slick_greeter_singleton;
#line 350 "../src/slick-greeter.vala"
		_tmp1_ = _tmp0_->priv->greeter;
#line 350 "../src/slick-greeter.vala"
		lightdm_greeter_authenticate_remote (_tmp1_, session, userid, &_inner_error0_);
#line 350 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2127 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 349 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 349 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 353 "../src/slick-greeter.vala"
		_tmp2_ = e;
#line 353 "../src/slick-greeter.vala"
		_tmp3_ = _tmp2_->message;
#line 353 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:353: Unable to authenticate session for user %s, %s", userid, _tmp3_);
#line 349 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 2149 "slick-greeter.c"
	}
	__finally0:
#line 349 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 349 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 349 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 349 "../src/slick-greeter.vala"
		return;
#line 2160 "slick-greeter.c"
	}
}

void
slick_greeter_cancel_authentication (SlickGreeter* self)
{
	GError* _inner_error0_ = NULL;
#line 357 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 2170 "slick-greeter.c"
	{
		LightDMGreeter* _tmp0_;
#line 360 "../src/slick-greeter.vala"
		_tmp0_ = self->priv->greeter;
#line 360 "../src/slick-greeter.vala"
		lightdm_greeter_cancel_authentication (_tmp0_, &_inner_error0_);
#line 360 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2179 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 359 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 359 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 363 "../src/slick-greeter.vala"
		_tmp1_ = e;
#line 363 "../src/slick-greeter.vala"
		_tmp2_ = _tmp1_->message;
#line 363 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:363: Unable to cancel authentication: %s", _tmp2_);
#line 359 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 2201 "slick-greeter.c"
	}
	__finally0:
#line 359 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 359 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 359 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 359 "../src/slick-greeter.vala"
		return;
#line 2212 "slick-greeter.c"
	}
}

void
slick_greeter_respond (SlickGreeter* self,
                       const gchar* response)
{
	GError* _inner_error0_ = NULL;
#line 368 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 368 "../src/slick-greeter.vala"
	g_return_if_fail (response != NULL);
#line 2225 "slick-greeter.c"
	{
		LightDMGreeter* _tmp0_;
#line 371 "../src/slick-greeter.vala"
		_tmp0_ = self->priv->greeter;
#line 371 "../src/slick-greeter.vala"
		lightdm_greeter_respond (_tmp0_, response, &_inner_error0_);
#line 371 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2234 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 370 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 370 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 374 "../src/slick-greeter.vala"
		_tmp1_ = e;
#line 374 "../src/slick-greeter.vala"
		_tmp2_ = _tmp1_->message;
#line 374 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:374: Greeter unable to respond: %s", _tmp2_);
#line 370 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 2256 "slick-greeter.c"
	}
	__finally0:
#line 370 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 370 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 370 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 370 "../src/slick-greeter.vala"
		return;
#line 2267 "slick-greeter.c"
	}
}

gchar*
slick_greeter_authentication_user (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 378 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 380 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 380 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_authentication_user (_tmp0_);
#line 380 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 380 "../src/slick-greeter.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 380 "../src/slick-greeter.vala"
	result = _tmp3_;
#line 380 "../src/slick-greeter.vala"
	return result;
#line 2293 "slick-greeter.c"
}

gchar*
slick_greeter_default_session_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 383 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 385 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 385 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_default_session_hint (_tmp0_);
#line 385 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 385 "../src/slick-greeter.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 385 "../src/slick-greeter.vala"
	result = _tmp3_;
#line 385 "../src/slick-greeter.vala"
	return result;
#line 2318 "slick-greeter.c"
}

gchar*
slick_greeter_select_user_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 388 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 390 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 390 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_select_user_hint (_tmp0_);
#line 390 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 390 "../src/slick-greeter.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 390 "../src/slick-greeter.vala"
	result = _tmp3_;
#line 390 "../src/slick-greeter.vala"
	return result;
#line 2343 "slick-greeter.c"
}

gboolean
slick_greeter_show_manual_login_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 393 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 395 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 395 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_show_manual_login_hint (_tmp0_);
#line 395 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 395 "../src/slick-greeter.vala"
	result = _tmp2_;
#line 395 "../src/slick-greeter.vala"
	return result;
#line 2365 "slick-greeter.c"
}

gboolean
slick_greeter_show_remote_login_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 398 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 400 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 400 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_show_remote_login_hint (_tmp0_);
#line 400 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 400 "../src/slick-greeter.vala"
	result = _tmp2_;
#line 400 "../src/slick-greeter.vala"
	return result;
#line 2387 "slick-greeter.c"
}

gboolean
slick_greeter_hide_users_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 403 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 405 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 405 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_hide_users_hint (_tmp0_);
#line 405 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 405 "../src/slick-greeter.vala"
	result = _tmp2_;
#line 405 "../src/slick-greeter.vala"
	return result;
#line 2409 "slick-greeter.c"
}

gboolean
slick_greeter_has_guest_account_hint (SlickGreeter* self)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 408 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 410 "../src/slick-greeter.vala"
	_tmp0_ = self->priv->greeter;
#line 410 "../src/slick-greeter.vala"
	_tmp1_ = lightdm_greeter_get_has_guest_account_hint (_tmp0_);
#line 410 "../src/slick-greeter.vala"
	_tmp2_ = _tmp1_;
#line 410 "../src/slick-greeter.vala"
	result = _tmp2_;
#line 410 "../src/slick-greeter.vala"
	return result;
#line 2431 "slick-greeter.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 2450 "slick-greeter.c"
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 433 "../src/slick-greeter.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 433 "../src/slick-greeter.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 433 "../src/slick-greeter.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 2464 "slick-greeter.c"
	}
#line 433 "../src/slick-greeter.vala"
	return *re;
#line 2468 "slick-greeter.c"
}

static gpointer
_g_regex_ref0 (gpointer self)
{
#line 433 "../src/slick-greeter.vala"
	return self ? g_regex_ref (self) : NULL;
#line 2476 "slick-greeter.c"
}

gboolean
slick_greeter_is_live_session (SlickGreeter* self,
                               gchar** live_username,
                               gchar** live_realname)
{
	gchar* _vala_live_username = NULL;
	gchar* _vala_live_realname = NULL;
	gboolean is_live = FALSE;
	gboolean _tmp43_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 413 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 415 "../src/slick-greeter.vala"
	is_live = FALSE;
#line 416 "../src/slick-greeter.vala"
	_g_free0 (_vala_live_username);
#line 416 "../src/slick-greeter.vala"
	_vala_live_username = NULL;
#line 417 "../src/slick-greeter.vala"
	_g_free0 (_vala_live_realname);
#line 417 "../src/slick-greeter.vala"
	_vala_live_realname = NULL;
#line 419 "../src/slick-greeter.vala"
	if (g_file_test ("/proc/cmdline", G_FILE_TEST_EXISTS)) {
#line 2504 "slick-greeter.c"
		{
			gboolean success = FALSE;
			gchar* contents = NULL;
			gboolean _tmp0_ = FALSE;
			gchar* _tmp1_ = NULL;
			gboolean _tmp2_;
			const gchar* _tmp4_;
#line 423 "../src/slick-greeter.vala"
			contents = NULL;
#line 425 "../src/slick-greeter.vala"
			_tmp2_ = g_file_get_contents ("/proc/cmdline", &_tmp1_, NULL, &_inner_error0_);
#line 425 "../src/slick-greeter.vala"
			_g_free0 (contents);
#line 425 "../src/slick-greeter.vala"
			contents = _tmp1_;
#line 425 "../src/slick-greeter.vala"
			_tmp0_ = _tmp2_;
#line 425 "../src/slick-greeter.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2524 "slick-greeter.c"
				gboolean _tmp3_ = FALSE;
#line 425 "../src/slick-greeter.vala"
				_g_free0 (contents);
#line 425 "../src/slick-greeter.vala"
				if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2530 "slick-greeter.c"
					goto __catch0_g_file_error;
				}
#line 425 "../src/slick-greeter.vala"
				_g_free0 (_vala_live_username);
#line 425 "../src/slick-greeter.vala"
				_g_free0 (_vala_live_realname);
#line 425 "../src/slick-greeter.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 425 "../src/slick-greeter.vala"
				g_clear_error (&_inner_error0_);
#line 425 "../src/slick-greeter.vala"
				return _tmp3_;
#line 2543 "slick-greeter.c"
			}
#line 425 "../src/slick-greeter.vala"
			success = _tmp0_;
#line 427 "../src/slick-greeter.vala"
			_tmp4_ = contents;
#line 427 "../src/slick-greeter.vala"
			if (string_contains (_tmp4_, "boot=casper")) {
#line 2551 "slick-greeter.c"
				gboolean _tmp5_ = FALSE;
				gchar* _tmp6_ = NULL;
				gboolean _tmp7_;
#line 429 "../src/slick-greeter.vala"
				is_live = TRUE;
#line 431 "../src/slick-greeter.vala"
				_tmp7_ = g_file_get_contents ("/etc/casper.conf", &_tmp6_, NULL, &_inner_error0_);
#line 431 "../src/slick-greeter.vala"
				_g_free0 (contents);
#line 431 "../src/slick-greeter.vala"
				contents = _tmp6_;
#line 431 "../src/slick-greeter.vala"
				_tmp5_ = _tmp7_;
#line 431 "../src/slick-greeter.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2567 "slick-greeter.c"
					gboolean _tmp8_ = FALSE;
#line 431 "../src/slick-greeter.vala"
					_g_free0 (contents);
#line 431 "../src/slick-greeter.vala"
					if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2573 "slick-greeter.c"
						goto __catch0_g_file_error;
					}
#line 431 "../src/slick-greeter.vala"
					_g_free0 (_vala_live_username);
#line 431 "../src/slick-greeter.vala"
					_g_free0 (_vala_live_realname);
#line 431 "../src/slick-greeter.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 431 "../src/slick-greeter.vala"
					g_clear_error (&_inner_error0_);
#line 431 "../src/slick-greeter.vala"
					return _tmp8_;
#line 2586 "slick-greeter.c"
				}
#line 431 "../src/slick-greeter.vala"
				if (_tmp5_) {
#line 2590 "slick-greeter.c"
					GRegex* regex = NULL;
					GRegex* _tmp9_;
					GMatchInfo* info = NULL;
					GRegex* _tmp10_;
					const gchar* _tmp11_;
					GMatchInfo* _tmp12_ = NULL;
					gboolean _tmp13_;
					GRegex* _tmp16_;
					GRegex* _tmp17_;
					const gchar* _tmp18_;
					GMatchInfo* _tmp19_ = NULL;
					gboolean _tmp20_;
#line 433 "../src/slick-greeter.vala"
					_tmp9_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "(?:export USERNAME=\")([_a-zA-Z0-9]+)(?:\")", 0));
#line 433 "../src/slick-greeter.vala"
					regex = _tmp9_;
#line 436 "../src/slick-greeter.vala"
					_tmp10_ = regex;
#line 436 "../src/slick-greeter.vala"
					_tmp11_ = contents;
#line 436 "../src/slick-greeter.vala"
					_tmp13_ = g_regex_match (_tmp10_, _tmp11_, 0, &_tmp12_);
#line 436 "../src/slick-greeter.vala"
					_g_match_info_unref0 (info);
#line 436 "../src/slick-greeter.vala"
					info = _tmp12_;
#line 436 "../src/slick-greeter.vala"
					if (_tmp13_) {
#line 2619 "slick-greeter.c"
						GMatchInfo* _tmp14_;
						gchar* _tmp15_;
#line 437 "../src/slick-greeter.vala"
						_tmp14_ = info;
#line 437 "../src/slick-greeter.vala"
						_tmp15_ = g_match_info_fetch (_tmp14_, 1);
#line 437 "../src/slick-greeter.vala"
						_g_free0 (_vala_live_username);
#line 437 "../src/slick-greeter.vala"
						_vala_live_username = _tmp15_;
#line 2630 "slick-greeter.c"
					}
#line 440 "../src/slick-greeter.vala"
					_tmp16_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "(?:export USERFULLNAME=\")([ \\-_a-zA-Z0-9]+)(?:\")", 0));
#line 440 "../src/slick-greeter.vala"
					_g_regex_unref0 (regex);
#line 440 "../src/slick-greeter.vala"
					regex = _tmp16_;
#line 442 "../src/slick-greeter.vala"
					_g_match_info_unref0 (info);
#line 442 "../src/slick-greeter.vala"
					info = NULL;
#line 443 "../src/slick-greeter.vala"
					_tmp17_ = regex;
#line 443 "../src/slick-greeter.vala"
					_tmp18_ = contents;
#line 443 "../src/slick-greeter.vala"
					_tmp20_ = g_regex_match (_tmp17_, _tmp18_, 0, &_tmp19_);
#line 443 "../src/slick-greeter.vala"
					_g_match_info_unref0 (info);
#line 443 "../src/slick-greeter.vala"
					info = _tmp19_;
#line 443 "../src/slick-greeter.vala"
					if (_tmp20_) {
#line 2654 "slick-greeter.c"
						GMatchInfo* _tmp21_;
						gchar* _tmp22_;
#line 444 "../src/slick-greeter.vala"
						_tmp21_ = info;
#line 444 "../src/slick-greeter.vala"
						_tmp22_ = g_match_info_fetch (_tmp21_, 1);
#line 444 "../src/slick-greeter.vala"
						_g_free0 (_vala_live_realname);
#line 444 "../src/slick-greeter.vala"
						_vala_live_realname = _tmp22_;
#line 2665 "slick-greeter.c"
					}
#line 431 "../src/slick-greeter.vala"
					_g_match_info_unref0 (info);
#line 431 "../src/slick-greeter.vala"
					_g_regex_unref0 (regex);
#line 2671 "slick-greeter.c"
				}
			} else {
				const gchar* _tmp23_;
#line 450 "../src/slick-greeter.vala"
				_tmp23_ = contents;
#line 450 "../src/slick-greeter.vala"
				if (string_contains (_tmp23_, "boot=live")) {
#line 2679 "slick-greeter.c"
					gboolean _tmp24_ = FALSE;
					gchar* _tmp25_ = NULL;
					gboolean _tmp26_;
#line 452 "../src/slick-greeter.vala"
					is_live = TRUE;
#line 454 "../src/slick-greeter.vala"
					_g_free0 (contents);
#line 454 "../src/slick-greeter.vala"
					contents = NULL;
#line 455 "../src/slick-greeter.vala"
					_tmp26_ = g_file_get_contents ("/etc/live/config.conf.d/live-setup.conf", &_tmp25_, NULL, &_inner_error0_);
#line 455 "../src/slick-greeter.vala"
					_g_free0 (contents);
#line 455 "../src/slick-greeter.vala"
					contents = _tmp25_;
#line 455 "../src/slick-greeter.vala"
					_tmp24_ = _tmp26_;
#line 455 "../src/slick-greeter.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2699 "slick-greeter.c"
						gboolean _tmp27_ = FALSE;
#line 455 "../src/slick-greeter.vala"
						_g_free0 (contents);
#line 455 "../src/slick-greeter.vala"
						if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2705 "slick-greeter.c"
							goto __catch0_g_file_error;
						}
#line 455 "../src/slick-greeter.vala"
						_g_free0 (_vala_live_username);
#line 455 "../src/slick-greeter.vala"
						_g_free0 (_vala_live_realname);
#line 455 "../src/slick-greeter.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 455 "../src/slick-greeter.vala"
						g_clear_error (&_inner_error0_);
#line 455 "../src/slick-greeter.vala"
						return _tmp27_;
#line 2718 "slick-greeter.c"
					}
#line 455 "../src/slick-greeter.vala"
					if (_tmp24_) {
#line 2722 "slick-greeter.c"
						GRegex* regex = NULL;
						GRegex* _tmp28_;
						GMatchInfo* info = NULL;
						GRegex* _tmp29_;
						const gchar* _tmp30_;
						GMatchInfo* _tmp31_ = NULL;
						gboolean _tmp32_;
						GRegex* _tmp35_;
						GRegex* _tmp36_;
						const gchar* _tmp37_;
						GMatchInfo* _tmp38_ = NULL;
						gboolean _tmp39_;
#line 457 "../src/slick-greeter.vala"
						_tmp28_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_2, "(?:LIVE_USERNAME=\")([_a-zA-Z0-9]+)(?:\")", 0));
#line 457 "../src/slick-greeter.vala"
						regex = _tmp28_;
#line 460 "../src/slick-greeter.vala"
						_tmp29_ = regex;
#line 460 "../src/slick-greeter.vala"
						_tmp30_ = contents;
#line 460 "../src/slick-greeter.vala"
						_tmp32_ = g_regex_match (_tmp29_, _tmp30_, 0, &_tmp31_);
#line 460 "../src/slick-greeter.vala"
						_g_match_info_unref0 (info);
#line 460 "../src/slick-greeter.vala"
						info = _tmp31_;
#line 460 "../src/slick-greeter.vala"
						if (_tmp32_) {
#line 2751 "slick-greeter.c"
							GMatchInfo* _tmp33_;
							gchar* _tmp34_;
#line 461 "../src/slick-greeter.vala"
							_tmp33_ = info;
#line 461 "../src/slick-greeter.vala"
							_tmp34_ = g_match_info_fetch (_tmp33_, 1);
#line 461 "../src/slick-greeter.vala"
							_g_free0 (_vala_live_username);
#line 461 "../src/slick-greeter.vala"
							_vala_live_username = _tmp34_;
#line 2762 "slick-greeter.c"
						}
#line 464 "../src/slick-greeter.vala"
						_tmp35_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_3, "(?:LIVE_USER_FULLNAME=\")([ \\-_a-zA-Z0-9]+)(?:\")", 0));
#line 464 "../src/slick-greeter.vala"
						_g_regex_unref0 (regex);
#line 464 "../src/slick-greeter.vala"
						regex = _tmp35_;
#line 466 "../src/slick-greeter.vala"
						_g_match_info_unref0 (info);
#line 466 "../src/slick-greeter.vala"
						info = NULL;
#line 467 "../src/slick-greeter.vala"
						_tmp36_ = regex;
#line 467 "../src/slick-greeter.vala"
						_tmp37_ = contents;
#line 467 "../src/slick-greeter.vala"
						_tmp39_ = g_regex_match (_tmp36_, _tmp37_, 0, &_tmp38_);
#line 467 "../src/slick-greeter.vala"
						_g_match_info_unref0 (info);
#line 467 "../src/slick-greeter.vala"
						info = _tmp38_;
#line 467 "../src/slick-greeter.vala"
						if (_tmp39_) {
#line 2786 "slick-greeter.c"
							GMatchInfo* _tmp40_;
							gchar* _tmp41_;
#line 468 "../src/slick-greeter.vala"
							_tmp40_ = info;
#line 468 "../src/slick-greeter.vala"
							_tmp41_ = g_match_info_fetch (_tmp40_, 1);
#line 468 "../src/slick-greeter.vala"
							_g_free0 (_vala_live_realname);
#line 468 "../src/slick-greeter.vala"
							_vala_live_realname = _tmp41_;
#line 2797 "slick-greeter.c"
						}
#line 455 "../src/slick-greeter.vala"
						_g_match_info_unref0 (info);
#line 455 "../src/slick-greeter.vala"
						_g_regex_unref0 (regex);
#line 2803 "slick-greeter.c"
					}
				}
			}
#line 421 "../src/slick-greeter.vala"
			_g_free0 (contents);
#line 2809 "slick-greeter.c"
		}
		goto __finally0;
		__catch0_g_file_error:
		{
#line 421 "../src/slick-greeter.vala"
			g_clear_error (&_inner_error0_);
#line 2816 "slick-greeter.c"
		}
		__finally0:
#line 421 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2821 "slick-greeter.c"
			gboolean _tmp42_ = FALSE;
#line 421 "../src/slick-greeter.vala"
			_g_free0 (_vala_live_username);
#line 421 "../src/slick-greeter.vala"
			_g_free0 (_vala_live_realname);
#line 421 "../src/slick-greeter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 421 "../src/slick-greeter.vala"
			g_clear_error (&_inner_error0_);
#line 421 "../src/slick-greeter.vala"
			return _tmp42_;
#line 2833 "slick-greeter.c"
		}
	}
#line 477 "../src/slick-greeter.vala"
	if (is_live) {
#line 2838 "slick-greeter.c"
		const gchar* _tmp44_;
#line 477 "../src/slick-greeter.vala"
		_tmp44_ = _vala_live_username;
#line 477 "../src/slick-greeter.vala"
		_tmp43_ = !string_contains (_tmp44_, "lightdm");
#line 2844 "slick-greeter.c"
	} else {
#line 477 "../src/slick-greeter.vala"
		_tmp43_ = FALSE;
#line 2848 "slick-greeter.c"
	}
#line 477 "../src/slick-greeter.vala"
	result = _tmp43_;
#line 477 "../src/slick-greeter.vala"
	if (live_username) {
#line 477 "../src/slick-greeter.vala"
		*live_username = _vala_live_username;
#line 2856 "slick-greeter.c"
	} else {
#line 477 "../src/slick-greeter.vala"
		_g_free0 (_vala_live_username);
#line 2860 "slick-greeter.c"
	}
#line 477 "../src/slick-greeter.vala"
	if (live_realname) {
#line 477 "../src/slick-greeter.vala"
		*live_realname = _vala_live_realname;
#line 2866 "slick-greeter.c"
	} else {
#line 477 "../src/slick-greeter.vala"
		_g_free0 (_vala_live_realname);
#line 2870 "slick-greeter.c"
	}
#line 477 "../src/slick-greeter.vala"
	return result;
#line 2874 "slick-greeter.c"
}

static GdkFilterReturn
slick_greeter_focus_upon_map (SlickGreeter* self,
                              GdkXEvent* gxevent,
                              GdkEvent* event)
{
	XEvent* xevent = NULL;
	XEvent* _tmp0_;
	GdkFilterReturn result;
#line 480 "../src/slick-greeter.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 480 "../src/slick-greeter.vala"
	g_return_val_if_fail (gxevent != NULL, 0);
#line 480 "../src/slick-greeter.vala"
	g_return_val_if_fail (event != NULL, 0);
#line 482 "../src/slick-greeter.vala"
	xevent = (XEvent*) gxevent;
#line 483 "../src/slick-greeter.vala"
	_tmp0_ = xevent;
#line 483 "../src/slick-greeter.vala"
	if ((*_tmp0_).type == ((gint) MapNotify)) {
#line 2897 "slick-greeter.c"
		GdkX11Display* display = NULL;
		XEvent* _tmp1_;
		XMapEvent _tmp2_;
		Display* _tmp3_;
		GdkX11Display* _tmp4_;
		GdkX11Display* _tmp5_;
		Window xwin = 0;
		XEvent* _tmp6_;
		XMapEvent _tmp7_;
		GdkX11Window* win = NULL;
		GdkX11Display* _tmp8_;
		GdkX11Window* _tmp9_;
		gboolean _tmp10_ = FALSE;
		GdkX11Window* _tmp11_;
#line 485 "../src/slick-greeter.vala"
		_tmp1_ = xevent;
#line 485 "../src/slick-greeter.vala"
		_tmp2_ = (*_tmp1_).xmap;
#line 485 "../src/slick-greeter.vala"
		_tmp3_ = _tmp2_.display;
#line 485 "../src/slick-greeter.vala"
		_tmp4_ = gdk_x11_lookup_xdisplay (_tmp3_);
#line 485 "../src/slick-greeter.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 485 "../src/slick-greeter.vala"
		display = _tmp5_;
#line 486 "../src/slick-greeter.vala"
		_tmp6_ = xevent;
#line 486 "../src/slick-greeter.vala"
		_tmp7_ = (*_tmp6_).xmap;
#line 486 "../src/slick-greeter.vala"
		xwin = _tmp7_.window;
#line 487 "../src/slick-greeter.vala"
		_tmp8_ = display;
#line 487 "../src/slick-greeter.vala"
		_tmp9_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (_tmp8_, xwin);
#line 487 "../src/slick-greeter.vala"
		win = _tmp9_;
#line 488 "../src/slick-greeter.vala"
		_tmp11_ = win;
#line 488 "../src/slick-greeter.vala"
		if (_tmp11_ != NULL) {
#line 2940 "slick-greeter.c"
			XEvent* _tmp12_;
			XMapEvent _tmp13_;
#line 488 "../src/slick-greeter.vala"
			_tmp12_ = xevent;
#line 488 "../src/slick-greeter.vala"
			_tmp13_ = (*_tmp12_).xmap;
#line 488 "../src/slick-greeter.vala"
			_tmp10_ = !_tmp13_.override_redirect;
#line 2949 "slick-greeter.c"
		} else {
#line 488 "../src/slick-greeter.vala"
			_tmp10_ = FALSE;
#line 2953 "slick-greeter.c"
		}
#line 488 "../src/slick-greeter.vala"
		if (_tmp10_) {
#line 2957 "slick-greeter.c"
			Window keyboard_xid = 0;
			MainWindow* _tmp14_;
			MenuBar* _tmp15_;
			GtkWindow* _tmp16_;
			GtkWindow* _tmp17_;
			gboolean _tmp23_ = FALSE;
#line 491 "../src/slick-greeter.vala"
			keyboard_xid = (Window) 0;
#line 492 "../src/slick-greeter.vala"
			_tmp14_ = self->priv->main_window;
#line 492 "../src/slick-greeter.vala"
			_tmp15_ = _tmp14_->menubar;
#line 492 "../src/slick-greeter.vala"
			_tmp16_ = menu_bar_get_keyboard_window (_tmp15_);
#line 492 "../src/slick-greeter.vala"
			_tmp17_ = _tmp16_;
#line 492 "../src/slick-greeter.vala"
			if (_tmp17_ != NULL) {
#line 2976 "slick-greeter.c"
				MainWindow* _tmp18_;
				MenuBar* _tmp19_;
				GtkWindow* _tmp20_;
				GtkWindow* _tmp21_;
				GdkWindow* _tmp22_;
#line 493 "../src/slick-greeter.vala"
				_tmp18_ = self->priv->main_window;
#line 493 "../src/slick-greeter.vala"
				_tmp19_ = _tmp18_->menubar;
#line 493 "../src/slick-greeter.vala"
				_tmp20_ = menu_bar_get_keyboard_window (_tmp19_);
#line 493 "../src/slick-greeter.vala"
				_tmp21_ = _tmp20_;
#line 493 "../src/slick-greeter.vala"
				_tmp22_ = gtk_widget_get_window ((GtkWidget*) _tmp21_);
#line 493 "../src/slick-greeter.vala"
				keyboard_xid = gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gdk_x11_window_get_type ()) ? ((GdkX11Window*) _tmp22_) : NULL);
#line 2994 "slick-greeter.c"
			}
#line 495 "../src/slick-greeter.vala"
			if (xwin != keyboard_xid) {
#line 2998 "slick-greeter.c"
				GdkX11Window* _tmp24_;
#line 495 "../src/slick-greeter.vala"
				_tmp24_ = win;
#line 495 "../src/slick-greeter.vala"
				_tmp23_ = gdk_window_get_type_hint ((GdkWindow*) _tmp24_) != GDK_WINDOW_TYPE_HINT_NOTIFICATION;
#line 3004 "slick-greeter.c"
			} else {
#line 495 "../src/slick-greeter.vala"
				_tmp23_ = FALSE;
#line 3008 "slick-greeter.c"
			}
#line 495 "../src/slick-greeter.vala"
			if (_tmp23_) {
#line 3012 "slick-greeter.c"
				GdkX11Window* _tmp25_;
				MainWindow* _tmp26_;
				MenuBar* _tmp27_;
				GtkWindow* _tmp28_;
				GtkWindow* _tmp29_;
#line 497 "../src/slick-greeter.vala"
				_tmp25_ = win;
#line 497 "../src/slick-greeter.vala"
				gdk_window_focus ((GdkWindow*) _tmp25_, (guint32) GDK_CURRENT_TIME);
#line 500 "../src/slick-greeter.vala"
				_tmp26_ = self->priv->main_window;
#line 500 "../src/slick-greeter.vala"
				_tmp27_ = _tmp26_->menubar;
#line 500 "../src/slick-greeter.vala"
				_tmp28_ = menu_bar_get_keyboard_window (_tmp27_);
#line 500 "../src/slick-greeter.vala"
				_tmp29_ = _tmp28_;
#line 500 "../src/slick-greeter.vala"
				if (_tmp29_ != NULL) {
#line 3032 "slick-greeter.c"
					MainWindow* _tmp30_;
					MenuBar* _tmp31_;
					GtkWindow* _tmp32_;
					GtkWindow* _tmp33_;
					GdkWindow* _tmp34_;
#line 501 "../src/slick-greeter.vala"
					_tmp30_ = self->priv->main_window;
#line 501 "../src/slick-greeter.vala"
					_tmp31_ = _tmp30_->menubar;
#line 501 "../src/slick-greeter.vala"
					_tmp32_ = menu_bar_get_keyboard_window (_tmp31_);
#line 501 "../src/slick-greeter.vala"
					_tmp33_ = _tmp32_;
#line 501 "../src/slick-greeter.vala"
					_tmp34_ = gtk_widget_get_window ((GtkWidget*) _tmp33_);
#line 501 "../src/slick-greeter.vala"
					gdk_window_raise (_tmp34_);
#line 3050 "slick-greeter.c"
				}
			}
		}
#line 483 "../src/slick-greeter.vala"
		_g_object_unref0 (win);
#line 483 "../src/slick-greeter.vala"
		_g_object_unref0 (display);
#line 3058 "slick-greeter.c"
	} else {
		XEvent* _tmp35_;
#line 505 "../src/slick-greeter.vala"
		_tmp35_ = xevent;
#line 505 "../src/slick-greeter.vala"
		if ((*_tmp35_).type == ((gint) UnmapNotify)) {
#line 3065 "slick-greeter.c"
			Window xwin = 0;
			gint revert_to = 0;
			XEvent* _tmp36_;
			XUnmapEvent _tmp37_;
			Display* _tmp38_;
			Window _tmp39_ = 0;
			gint _tmp40_ = 0;
#line 517 "../src/slick-greeter.vala"
			_tmp36_ = xevent;
#line 517 "../src/slick-greeter.vala"
			_tmp37_ = (*_tmp36_).xunmap;
#line 517 "../src/slick-greeter.vala"
			_tmp38_ = _tmp37_.display;
#line 517 "../src/slick-greeter.vala"
			XGetInputFocus (_tmp38_, &_tmp39_, &_tmp40_);
#line 517 "../src/slick-greeter.vala"
			xwin = _tmp39_;
#line 517 "../src/slick-greeter.vala"
			revert_to = _tmp40_;
#line 519 "../src/slick-greeter.vala"
			if (revert_to == ((gint) RevertToNone)) {
#line 3087 "slick-greeter.c"
				MainWindow* _tmp41_;
				GdkWindow* _tmp42_;
				MainWindow* _tmp43_;
				MenuBar* _tmp44_;
				GtkWindow* _tmp45_;
				GtkWindow* _tmp46_;
#line 521 "../src/slick-greeter.vala"
				_tmp41_ = self->priv->main_window;
#line 521 "../src/slick-greeter.vala"
				_tmp42_ = gtk_widget_get_window ((GtkWidget*) _tmp41_);
#line 521 "../src/slick-greeter.vala"
				gdk_window_focus (_tmp42_, (guint32) GDK_CURRENT_TIME);
#line 524 "../src/slick-greeter.vala"
				_tmp43_ = self->priv->main_window;
#line 524 "../src/slick-greeter.vala"
				_tmp44_ = _tmp43_->menubar;
#line 524 "../src/slick-greeter.vala"
				_tmp45_ = menu_bar_get_keyboard_window (_tmp44_);
#line 524 "../src/slick-greeter.vala"
				_tmp46_ = _tmp45_;
#line 524 "../src/slick-greeter.vala"
				if (_tmp46_ != NULL) {
#line 3110 "slick-greeter.c"
					MainWindow* _tmp47_;
					MenuBar* _tmp48_;
					GtkWindow* _tmp49_;
					GtkWindow* _tmp50_;
					GdkWindow* _tmp51_;
#line 525 "../src/slick-greeter.vala"
					_tmp47_ = self->priv->main_window;
#line 525 "../src/slick-greeter.vala"
					_tmp48_ = _tmp47_->menubar;
#line 525 "../src/slick-greeter.vala"
					_tmp49_ = menu_bar_get_keyboard_window (_tmp48_);
#line 525 "../src/slick-greeter.vala"
					_tmp50_ = _tmp49_;
#line 525 "../src/slick-greeter.vala"
					_tmp51_ = gtk_widget_get_window ((GtkWidget*) _tmp50_);
#line 525 "../src/slick-greeter.vala"
					gdk_window_raise (_tmp51_);
#line 3128 "slick-greeter.c"
				}
			}
		}
	}
#line 528 "../src/slick-greeter.vala"
	result = GDK_FILTER_CONTINUE;
#line 528 "../src/slick-greeter.vala"
	return result;
#line 3137 "slick-greeter.c"
}

static GdkFilterReturn
_slick_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent,
                                               GdkEvent* event,
                                               gpointer self)
{
	GdkFilterReturn result;
	result = slick_greeter_focus_upon_map ((SlickGreeter*) self, xevent, event);
#line 539 "../src/slick-greeter.vala"
	return result;
#line 3149 "slick-greeter.c"
}

static void
slick_greeter_start_fake_wm (SlickGreeter* self)
{
	GdkWindow* root = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
#line 531 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 537 "../src/slick-greeter.vala"
	_tmp0_ = gdk_get_default_root_window ();
#line 537 "../src/slick-greeter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 537 "../src/slick-greeter.vala"
	root = _tmp1_;
#line 538 "../src/slick-greeter.vala"
	gdk_window_set_events (root, gdk_window_get_events (root) | GDK_SUBSTRUCTURE_MASK);
#line 539 "../src/slick-greeter.vala"
	gdk_window_add_filter (root, _slick_greeter_focus_upon_map_gdk_filter_func, self);
#line 531 "../src/slick-greeter.vala"
	_g_object_unref0 (root);
#line 3172 "slick-greeter.c"
}

static void
slick_greeter_kill_fake_wm (SlickGreeter* self)
{
	GdkWindow* root = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
#line 542 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 544 "../src/slick-greeter.vala"
	_tmp0_ = gdk_get_default_root_window ();
#line 544 "../src/slick-greeter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 544 "../src/slick-greeter.vala"
	root = _tmp1_;
#line 545 "../src/slick-greeter.vala"
	gdk_window_remove_filter (root, _slick_greeter_focus_upon_map_gdk_filter_func, self);
#line 542 "../src/slick-greeter.vala"
	_g_object_unref0 (root);
#line 3193 "slick-greeter.c"
}

static cairo_surface_t*
slick_greeter_create_root_surface (GdkScreen* screen)
{
	GdkVisual* visual = NULL;
	GdkVisual* _tmp0_;
	GdkVisual* _tmp1_;
	Display* display = NULL;
	GdkDisplay* _tmp2_;
	Display* _tmp3_;
	Screen* xscreen = NULL;
	Screen* _tmp4_;
	gint pixmap = 0;
	GdkWindow* _tmp5_;
	cairo_surface_t* surface = NULL;
	Visual* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* result;
#line 548 "../src/slick-greeter.vala"
	g_return_val_if_fail (screen != NULL, NULL);
#line 550 "../src/slick-greeter.vala"
	_tmp0_ = gdk_screen_get_system_visual (screen);
#line 550 "../src/slick-greeter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 550 "../src/slick-greeter.vala"
	visual = _tmp1_;
#line 552 "../src/slick-greeter.vala"
	_tmp2_ = gdk_screen_get_display (screen);
#line 552 "../src/slick-greeter.vala"
	_tmp3_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp2_) : NULL);
#line 552 "../src/slick-greeter.vala"
	display = _tmp3_;
#line 553 "../src/slick-greeter.vala"
	_tmp4_ = gdk_x11_screen_get_xscreen (G_TYPE_CHECK_INSTANCE_TYPE (screen, gdk_x11_screen_get_type ()) ? ((GdkX11Screen*) screen) : NULL);
#line 553 "../src/slick-greeter.vala"
	xscreen = _tmp4_;
#line 555 "../src/slick-greeter.vala"
	_tmp5_ = gdk_screen_get_root_window (screen);
#line 555 "../src/slick-greeter.vala"
	pixmap = XCreatePixmap (display, (Drawable) gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gdk_x11_window_get_type ()) ? ((GdkX11Window*) _tmp5_) : NULL), (guint) WidthOfScreen (xscreen), (guint) HeightOfScreen (xscreen), (guint) gdk_visual_get_depth (visual));
#line 562 "../src/slick-greeter.vala"
	_tmp6_ = gdk_x11_visual_get_xvisual (G_TYPE_CHECK_INSTANCE_TYPE (visual, gdk_x11_visual_get_type ()) ? ((GdkX11Visual*) visual) : NULL);
#line 562 "../src/slick-greeter.vala"
	_tmp7_ = cairo_xlib_surface_create (display, pixmap, _tmp6_, WidthOfScreen (xscreen), HeightOfScreen (xscreen));
#line 562 "../src/slick-greeter.vala"
	surface = _tmp7_;
#line 567 "../src/slick-greeter.vala"
	result = surface;
#line 567 "../src/slick-greeter.vala"
	_g_object_unref0 (visual);
#line 567 "../src/slick-greeter.vala"
	return result;
#line 3247 "slick-greeter.c"
}

static void
slick_greeter_log_cb (const gchar* log_domain,
                      GLogLevelFlags log_level,
                      const gchar* message)
{
	gchar* prefix = NULL;
	FILE* _tmp7_;
	GTimer* _tmp8_;
	const gchar* _tmp9_;
#line 586 "../src/slick-greeter.vala"
	g_return_if_fail (message != NULL);
#line 589 "../src/slick-greeter.vala"
	switch (log_level & G_LOG_LEVEL_MASK) {
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_ERROR:
#line 3265 "slick-greeter.c"
		{
			gchar* _tmp0_;
#line 592 "../src/slick-greeter.vala"
			_tmp0_ = g_strdup ("ERROR:");
#line 592 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 592 "../src/slick-greeter.vala"
			prefix = _tmp0_;
#line 593 "../src/slick-greeter.vala"
			break;
#line 3276 "slick-greeter.c"
		}
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 3280 "slick-greeter.c"
		{
			gchar* _tmp1_;
#line 595 "../src/slick-greeter.vala"
			_tmp1_ = g_strdup ("CRITICAL:");
#line 595 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 595 "../src/slick-greeter.vala"
			prefix = _tmp1_;
#line 596 "../src/slick-greeter.vala"
			break;
#line 3291 "slick-greeter.c"
		}
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_WARNING:
#line 3295 "slick-greeter.c"
		{
			gchar* _tmp2_;
#line 598 "../src/slick-greeter.vala"
			_tmp2_ = g_strdup ("WARNING:");
#line 598 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 598 "../src/slick-greeter.vala"
			prefix = _tmp2_;
#line 599 "../src/slick-greeter.vala"
			break;
#line 3306 "slick-greeter.c"
		}
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 3310 "slick-greeter.c"
		{
			gchar* _tmp3_;
#line 601 "../src/slick-greeter.vala"
			_tmp3_ = g_strdup ("MESSAGE:");
#line 601 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 601 "../src/slick-greeter.vala"
			prefix = _tmp3_;
#line 602 "../src/slick-greeter.vala"
			break;
#line 3321 "slick-greeter.c"
		}
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_INFO:
#line 3325 "slick-greeter.c"
		{
			gchar* _tmp4_;
#line 604 "../src/slick-greeter.vala"
			_tmp4_ = g_strdup ("INFO:");
#line 604 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 604 "../src/slick-greeter.vala"
			prefix = _tmp4_;
#line 605 "../src/slick-greeter.vala"
			break;
#line 3336 "slick-greeter.c"
		}
#line 589 "../src/slick-greeter.vala"
		case G_LOG_LEVEL_DEBUG:
#line 3340 "slick-greeter.c"
		{
			gchar* _tmp5_;
#line 607 "../src/slick-greeter.vala"
			_tmp5_ = g_strdup ("DEBUG:");
#line 607 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 607 "../src/slick-greeter.vala"
			prefix = _tmp5_;
#line 608 "../src/slick-greeter.vala"
			break;
#line 3351 "slick-greeter.c"
		}
		default:
		{
			gchar* _tmp6_;
#line 610 "../src/slick-greeter.vala"
			_tmp6_ = g_strdup ("LOG:");
#line 610 "../src/slick-greeter.vala"
			_g_free0 (prefix);
#line 610 "../src/slick-greeter.vala"
			prefix = _tmp6_;
#line 611 "../src/slick-greeter.vala"
			break;
#line 3364 "slick-greeter.c"
		}
	}
#line 614 "../src/slick-greeter.vala"
	_tmp7_ = stderr;
#line 614 "../src/slick-greeter.vala"
	_tmp8_ = slick_greeter_log_timer;
#line 614 "../src/slick-greeter.vala"
	_tmp9_ = prefix;
#line 614 "../src/slick-greeter.vala"
	fprintf (_tmp7_, "[%+.2fs] %s %s\n", g_timer_elapsed (_tmp8_, NULL), _tmp9_, message);
#line 586 "../src/slick-greeter.vala"
	_g_free0 (prefix);
#line 3377 "slick-greeter.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 3398 "slick-greeter.c"
}

static gboolean
slick_greeter_check_hidpi (void)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gchar* output = NULL;
		gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
#line 621 "../src/slick-greeter.vala"
		g_spawn_command_line_sync ("/usr/bin/slick-greeter-check-hidpi", &_tmp0_, NULL, NULL, &_inner_error0_);
#line 621 "../src/slick-greeter.vala"
		_g_free0 (output);
#line 621 "../src/slick-greeter.vala"
		output = _tmp0_;
#line 621 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 621 "../src/slick-greeter.vala"
			_g_free0 (output);
#line 3422 "slick-greeter.c"
			goto __catch0_g_error;
		}
#line 622 "../src/slick-greeter.vala"
		_tmp1_ = output;
#line 622 "../src/slick-greeter.vala"
		_tmp2_ = string_strip (_tmp1_);
#line 622 "../src/slick-greeter.vala"
		_g_free0 (output);
#line 622 "../src/slick-greeter.vala"
		output = _tmp2_;
#line 623 "../src/slick-greeter.vala"
		_tmp3_ = output;
#line 623 "../src/slick-greeter.vala"
		if (g_strcmp0 (_tmp3_, "2") == 0) {
#line 624 "../src/slick-greeter.vala"
			g_debug ("slick-greeter.vala:624: Activating HiDPI (2x scale ratio)");
#line 625 "../src/slick-greeter.vala"
			g_setenv ("GDK_SCALE", "2", TRUE);
#line 626 "../src/slick-greeter.vala"
			result = TRUE;
#line 626 "../src/slick-greeter.vala"
			_g_free0 (output);
#line 626 "../src/slick-greeter.vala"
			return result;
#line 3447 "slick-greeter.c"
		}
#line 619 "../src/slick-greeter.vala"
		_g_free0 (output);
#line 3451 "slick-greeter.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 619 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 619 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 630 "../src/slick-greeter.vala"
		_tmp4_ = e;
#line 630 "../src/slick-greeter.vala"
		_tmp5_ = _tmp4_->message;
#line 630 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:630: Error while setting HiDPI support: %s", _tmp5_);
#line 619 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 3471 "slick-greeter.c"
	}
	__finally0:
#line 619 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3476 "slick-greeter.c"
		gboolean _tmp6_ = FALSE;
#line 619 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 619 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 619 "../src/slick-greeter.vala"
		return _tmp6_;
#line 3484 "slick-greeter.c"
	}
#line 632 "../src/slick-greeter.vala"
	result = FALSE;
#line 632 "../src/slick-greeter.vala"
	return result;
#line 3490 "slick-greeter.c"
}

static void
slick_greeter_set_keyboard_layout (void)
{
	GError* _inner_error0_ = NULL;
#line 638 "../src/slick-greeter.vala"
	if (!g_file_test ("/etc/default/keyboard", G_FILE_TEST_EXISTS)) {
#line 639 "../src/slick-greeter.vala"
		return;
#line 3501 "slick-greeter.c"
	}
	{
#line 643 "../src/slick-greeter.vala"
		g_spawn_command_line_sync ("/usr/bin/slick-greeter-set-keyboard-layout", NULL, NULL, NULL, &_inner_error0_);
#line 643 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3508 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 642 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 642 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 646 "../src/slick-greeter.vala"
		_tmp0_ = e;
#line 646 "../src/slick-greeter.vala"
		_tmp1_ = _tmp0_->message;
#line 646 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:646: Error while setting the keyboard layout: %s", _tmp1_);
#line 642 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 3530 "slick-greeter.c"
	}
	__finally0:
#line 642 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 642 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 642 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 642 "../src/slick-greeter.vala"
		return;
#line 3541 "slick-greeter.c"
	}
}

static void
slick_greeter_enable_tap_to_click (void)
{
	GError* _inner_error0_ = NULL;
	{
#line 653 "../src/slick-greeter.vala"
		g_spawn_command_line_sync ("/usr/bin/slick-greeter-enable-tap-to-click", NULL, NULL, NULL, &_inner_error0_);
#line 653 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3554 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 652 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 652 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 656 "../src/slick-greeter.vala"
		_tmp0_ = e;
#line 656 "../src/slick-greeter.vala"
		_tmp1_ = _tmp0_->message;
#line 656 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:656: Error while enabling tap-to-click: %s", _tmp1_);
#line 652 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 3576 "slick-greeter.c"
	}
	__finally0:
#line 652 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 652 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 652 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 652 "../src/slick-greeter.vala"
		return;
#line 3587 "slick-greeter.c"
	}
}

static void
slick_greeter_activate_numlock (void)
{
	GError* _inner_error0_ = NULL;
	{
#line 663 "../src/slick-greeter.vala"
		g_spawn_command_line_sync ("/usr/bin/numlockx on", NULL, NULL, NULL, &_inner_error0_);
#line 663 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3600 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 662 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 662 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 666 "../src/slick-greeter.vala"
		_tmp0_ = e;
#line 666 "../src/slick-greeter.vala"
		_tmp1_ = _tmp0_->message;
#line 666 "../src/slick-greeter.vala"
		g_warning ("slick-greeter.vala:666: Error while activating numlock: %s", _tmp1_);
#line 662 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 3622 "slick-greeter.c"
	}
	__finally0:
#line 662 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 662 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 662 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 662 "../src/slick-greeter.vala"
		return;
#line 3633 "slick-greeter.c"
	}
}

static void
_slick_greeter_log_cb_glog_func (const gchar* log_domain,
                                 GLogLevelFlags log_levels,
                                 const gchar* message,
                                 gpointer self)
{
#line 716 "../src/slick-greeter.vala"
	slick_greeter_log_cb (log_domain, log_levels, message);
#line 3645 "slick-greeter.c"
}

static gboolean
__lambda62_ (void)
{
	gboolean result;
#line 837 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:837: Got a SIGTERM");
#line 838 "../src/slick-greeter.vala"
	gtk_main_quit ();
#line 839 "../src/slick-greeter.vala"
	result = TRUE;
#line 839 "../src/slick-greeter.vala"
	return result;
#line 3660 "slick-greeter.c"
}

static gboolean
___lambda62__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda62_ ();
#line 836 "../src/slick-greeter.vala"
	return result;
#line 3670 "slick-greeter.c"
}

static gint
slick_greeter_main (gchar** args,
                    gint args_length1)
{
	GTimer* _tmp0_;
	gchar* hidpi = NULL;
	gchar* _tmp1_;
	gint cursor_scale = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	GdkWindow* _tmp6_;
	GdkDisplay* _tmp7_;
	GdkCursor* _tmp8_;
	GdkCursor* _tmp9_;
	gboolean do_show_version = FALSE;
	gboolean do_test_mode = FALSE;
	GOptionEntry versionOption = {0};
	GOptionEntry _tmp10_ = {0};
	GOptionEntry testOption = {0};
	GOptionEntry _tmp11_ = {0};
	GOptionEntry nullOption = {0};
	GOptionEntry _tmp12_ = {0};
	GOptionEntry* options = NULL;
	GOptionEntry _tmp13_;
	GOptionEntry _tmp14_;
	GOptionEntry _tmp15_;
	GOptionEntry* _tmp16_;
	gint options_length1;
	gint _options_size_;
	GOptionContext* c = NULL;
	GOptionContext* _tmp17_;
	GOptionContext* _tmp18_;
	GOptionEntry* _tmp19_;
	gint _tmp19__length1;
	GOptionContext* _tmp20_;
	GOptionGroup* _tmp21_;
	GtkSettings* settings = NULL;
	GtkSettings* _tmp31_;
	GtkSettings* _tmp32_;
	gchar* value = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gint int_value = 0;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gdouble double_value = 0.0;
	gboolean boolean_value = FALSE;
	GtkSettings* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	SlickGreeter* greeter = NULL;
	SlickGreeter* _tmp63_;
	SlickGreeter* _tmp64_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp65_;
	GdkScreen* _tmp66_;
	Display* xdisplay = NULL;
	GdkScreen* _tmp67_;
	GdkDisplay* _tmp68_;
	Display* _tmp69_;
	Window window = 0;
	Display* _tmp70_;
	Atom atom = {0};
	Display* _tmp71_;
	GError* _inner_error0_ = NULL;
	gint result;
#line 698 "../src/slick-greeter.vala"
	g_unsetenv ("UBUNTU_MENUPROXY");
#line 701 "../src/slick-greeter.vala"
	setlocale (LC_ALL, "");
#line 702 "../src/slick-greeter.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 703 "../src/slick-greeter.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 704 "../src/slick-greeter.vala"
	textdomain (GETTEXT_PACKAGE);
#line 707 "../src/slick-greeter.vala"
	g_setenv ("GTK_MODULES", "atk-bridge", FALSE);
#line 713 "../src/slick-greeter.vala"
	g_setenv ("GDK_CORE_DEVICE_EVENTS", "1", TRUE);
#line 715 "../src/slick-greeter.vala"
	_tmp0_ = g_timer_new ();
#line 715 "../src/slick-greeter.vala"
	_g_timer_destroy0 (slick_greeter_log_timer);
#line 715 "../src/slick-greeter.vala"
	slick_greeter_log_timer = _tmp0_;
#line 716 "../src/slick-greeter.vala"
	g_log_set_default_handler (_slick_greeter_log_cb_glog_func, NULL);
#line 719 "../src/slick-greeter.vala"
	ug_settings_apply_conf_settings ();
#line 721 "../src/slick-greeter.vala"
	_tmp1_ = ug_settings_get_string (UG_SETTINGS_KEY_ENABLE_HIDPI);
#line 721 "../src/slick-greeter.vala"
	hidpi = _tmp1_;
#line 722 "../src/slick-greeter.vala"
	cursor_scale = 1;
#line 723 "../src/slick-greeter.vala"
	_tmp2_ = hidpi;
#line 723 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:723: HiDPI support: %s", _tmp2_);
#line 724 "../src/slick-greeter.vala"
	_tmp3_ = hidpi;
#line 724 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp3_, "auto") == 0) {
#line 725 "../src/slick-greeter.vala"
		if (slick_greeter_check_hidpi ()) {
#line 726 "../src/slick-greeter.vala"
			cursor_scale = 2;
#line 3788 "slick-greeter.c"
		}
	} else {
		const gchar* _tmp4_;
#line 728 "../src/slick-greeter.vala"
		_tmp4_ = hidpi;
#line 728 "../src/slick-greeter.vala"
		if (g_strcmp0 (_tmp4_, "on") == 0) {
#line 729 "../src/slick-greeter.vala"
			g_setenv ("GDK_SCALE", "2", TRUE);
#line 730 "../src/slick-greeter.vala"
			cursor_scale = 2;
#line 3800 "slick-greeter.c"
		}
	}
#line 734 "../src/slick-greeter.vala"
	slick_greeter_set_keyboard_layout ();
#line 737 "../src/slick-greeter.vala"
	if (ug_settings_get_boolean (UG_SETTINGS_KEY_ACTIVATE_NUMLOCK)) {
#line 738 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:738: Activating numlock");
#line 739 "../src/slick-greeter.vala"
		slick_greeter_activate_numlock ();
#line 3811 "slick-greeter.c"
	}
#line 743 "../src/slick-greeter.vala"
	slick_greeter_enable_tap_to_click ();
#line 745 "../src/slick-greeter.vala"
	gtk_init ((gint*) (&args_length1), &args);
#line 747 "../src/slick-greeter.vala"
	_tmp5_ = g_getenv ("LANG");
#line 747 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:747: Starting slick-greeter %s UID=%d LANG=%s", VERSION, (gint) getuid (), _tmp5_);
#line 750 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:750: Setting cursor");
#line 751 "../src/slick-greeter.vala"
	_tmp6_ = gdk_get_default_root_window ();
#line 751 "../src/slick-greeter.vala"
	_tmp7_ = gdk_display_get_default ();
#line 751 "../src/slick-greeter.vala"
	_tmp8_ = gdk_cursor_new_for_display (_tmp7_, GDK_LEFT_PTR);
#line 751 "../src/slick-greeter.vala"
	_tmp9_ = _tmp8_;
#line 751 "../src/slick-greeter.vala"
	gdk_window_set_cursor (_tmp6_, _tmp9_);
#line 751 "../src/slick-greeter.vala"
	_g_object_unref0 (_tmp9_);
#line 753 "../src/slick-greeter.vala"
	do_show_version = FALSE;
#line 754 "../src/slick-greeter.vala"
	do_test_mode = FALSE;
#line 755 "../src/slick-greeter.vala"
	_tmp10_.long_name = "version";
#line 755 "../src/slick-greeter.vala"
	_tmp10_.short_name = 'v';
#line 755 "../src/slick-greeter.vala"
	_tmp10_.flags = (gint) 0;
#line 755 "../src/slick-greeter.vala"
	_tmp10_.arg = G_OPTION_ARG_NONE;
#line 755 "../src/slick-greeter.vala"
	_tmp10_.arg_data = &do_show_version;
#line 755 "../src/slick-greeter.vala"
	_tmp10_.description = N_ ("Show release version");
#line 755 "../src/slick-greeter.vala"
	_tmp10_.arg_description = NULL;
#line 755 "../src/slick-greeter.vala"
	versionOption = _tmp10_;
#line 758 "../src/slick-greeter.vala"
	_tmp11_.long_name = "test-mode";
#line 758 "../src/slick-greeter.vala"
	_tmp11_.short_name = (gchar) 0;
#line 758 "../src/slick-greeter.vala"
	_tmp11_.flags = (gint) 0;
#line 758 "../src/slick-greeter.vala"
	_tmp11_.arg = G_OPTION_ARG_NONE;
#line 758 "../src/slick-greeter.vala"
	_tmp11_.arg_data = &do_test_mode;
#line 758 "../src/slick-greeter.vala"
	_tmp11_.description = N_ ("Run in test mode");
#line 758 "../src/slick-greeter.vala"
	_tmp11_.arg_description = NULL;
#line 758 "../src/slick-greeter.vala"
	testOption = _tmp11_;
#line 761 "../src/slick-greeter.vala"
	_tmp12_.long_name = NULL;
#line 761 "../src/slick-greeter.vala"
	nullOption = _tmp12_;
#line 762 "../src/slick-greeter.vala"
	_tmp13_ = versionOption;
#line 762 "../src/slick-greeter.vala"
	_tmp14_ = testOption;
#line 762 "../src/slick-greeter.vala"
	_tmp15_ = nullOption;
#line 762 "../src/slick-greeter.vala"
	_tmp16_ = g_new0 (GOptionEntry, 3);
#line 762 "../src/slick-greeter.vala"
	_tmp16_[0] = _tmp13_;
#line 762 "../src/slick-greeter.vala"
	_tmp16_[1] = _tmp14_;
#line 762 "../src/slick-greeter.vala"
	_tmp16_[2] = _tmp15_;
#line 762 "../src/slick-greeter.vala"
	options = _tmp16_;
#line 762 "../src/slick-greeter.vala"
	options_length1 = 3;
#line 762 "../src/slick-greeter.vala"
	_options_size_ = options_length1;
#line 764 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:764: Loading command line options");
#line 765 "../src/slick-greeter.vala"
	_tmp17_ = g_option_context_new ("- Slick Greeter");
#line 765 "../src/slick-greeter.vala"
	c = _tmp17_;
#line 766 "../src/slick-greeter.vala"
	_tmp18_ = c;
#line 766 "../src/slick-greeter.vala"
	_tmp19_ = options;
#line 766 "../src/slick-greeter.vala"
	_tmp19__length1 = options_length1;
#line 766 "../src/slick-greeter.vala"
	g_option_context_add_main_entries (_tmp18_, _tmp19_, GETTEXT_PACKAGE);
#line 767 "../src/slick-greeter.vala"
	_tmp20_ = c;
#line 767 "../src/slick-greeter.vala"
	_tmp21_ = gtk_get_option_group (TRUE);
#line 767 "../src/slick-greeter.vala"
	g_option_context_add_group (_tmp20_, _tmp21_);
#line 3915 "slick-greeter.c"
	{
		GOptionContext* _tmp22_;
#line 770 "../src/slick-greeter.vala"
		_tmp22_ = c;
#line 770 "../src/slick-greeter.vala"
		g_option_context_parse (_tmp22_, (gint*) (&args_length1), &args, &_inner_error0_);
#line 770 "../src/slick-greeter.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3924 "slick-greeter.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		FILE* _tmp26_;
		const gchar* _tmp27_;
		FILE* _tmp28_;
#line 768 "../src/slick-greeter.vala"
		e = _inner_error0_;
#line 768 "../src/slick-greeter.vala"
		_inner_error0_ = NULL;
#line 774 "../src/slick-greeter.vala"
		_tmp23_ = stderr;
#line 774 "../src/slick-greeter.vala"
		_tmp24_ = e;
#line 774 "../src/slick-greeter.vala"
		_tmp25_ = _tmp24_->message;
#line 774 "../src/slick-greeter.vala"
		fprintf (_tmp23_, "%s\n", _tmp25_);
#line 775 "../src/slick-greeter.vala"
		_tmp26_ = stderr;
#line 775 "../src/slick-greeter.vala"
		_tmp27_ = args[0];
#line 775 "../src/slick-greeter.vala"
		fprintf (_tmp26_, _ ("Run '%s --help' to see a full list of available command line options."), _tmp27_);
#line 777 "../src/slick-greeter.vala"
		_tmp28_ = stderr;
#line 777 "../src/slick-greeter.vala"
		fprintf (_tmp28_, "\n");
#line 778 "../src/slick-greeter.vala"
		result = EXIT_FAILURE;
#line 778 "../src/slick-greeter.vala"
		_g_error_free0 (e);
#line 778 "../src/slick-greeter.vala"
		_g_option_context_free0 (c);
#line 778 "../src/slick-greeter.vala"
		options = (g_free (options), NULL);
#line 778 "../src/slick-greeter.vala"
		_g_free0 (hidpi);
#line 778 "../src/slick-greeter.vala"
		return result;
#line 3972 "slick-greeter.c"
	}
	__finally0:
#line 768 "../src/slick-greeter.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3977 "slick-greeter.c"
		gint _tmp29_ = -1;
#line 768 "../src/slick-greeter.vala"
		_g_option_context_free0 (c);
#line 768 "../src/slick-greeter.vala"
		options = (g_free (options), NULL);
#line 768 "../src/slick-greeter.vala"
		_g_free0 (hidpi);
#line 768 "../src/slick-greeter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 768 "../src/slick-greeter.vala"
		g_clear_error (&_inner_error0_);
#line 768 "../src/slick-greeter.vala"
		return _tmp29_;
#line 3991 "slick-greeter.c"
	}
#line 780 "../src/slick-greeter.vala"
	if (do_show_version) {
#line 3995 "slick-greeter.c"
		FILE* _tmp30_;
#line 783 "../src/slick-greeter.vala"
		_tmp30_ = stderr;
#line 783 "../src/slick-greeter.vala"
		fprintf (_tmp30_, "slick-greeter %s\n", VERSION);
#line 784 "../src/slick-greeter.vala"
		result = EXIT_SUCCESS;
#line 784 "../src/slick-greeter.vala"
		_g_option_context_free0 (c);
#line 784 "../src/slick-greeter.vala"
		options = (g_free (options), NULL);
#line 784 "../src/slick-greeter.vala"
		_g_free0 (hidpi);
#line 784 "../src/slick-greeter.vala"
		return result;
#line 4011 "slick-greeter.c"
	}
#line 787 "../src/slick-greeter.vala"
	if (do_test_mode) {
#line 788 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:788: Running in test mode");
#line 4017 "slick-greeter.c"
	}
#line 791 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:791: Setting GTK+ settings");
#line 792 "../src/slick-greeter.vala"
	_tmp31_ = gtk_settings_get_default ();
#line 792 "../src/slick-greeter.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 792 "../src/slick-greeter.vala"
	settings = _tmp32_;
#line 793 "../src/slick-greeter.vala"
	_tmp33_ = ug_settings_get_string (UG_SETTINGS_KEY_THEME_NAME);
#line 793 "../src/slick-greeter.vala"
	value = _tmp33_;
#line 794 "../src/slick-greeter.vala"
	_tmp34_ = value;
#line 794 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp34_, "") != 0) {
#line 4035 "slick-greeter.c"
		const gchar* _tmp35_;
		GtkSettings* _tmp36_;
		const gchar* _tmp37_;
#line 795 "../src/slick-greeter.vala"
		_tmp35_ = value;
#line 795 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:795: Setting GTK theme: %s", _tmp35_);
#line 796 "../src/slick-greeter.vala"
		_tmp36_ = settings;
#line 796 "../src/slick-greeter.vala"
		_tmp37_ = value;
#line 796 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp36_, "gtk-theme-name", _tmp37_, NULL, NULL);
#line 4049 "slick-greeter.c"
	}
#line 798 "../src/slick-greeter.vala"
	_tmp38_ = ug_settings_get_string (UG_SETTINGS_KEY_ICON_THEME_NAME);
#line 798 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 798 "../src/slick-greeter.vala"
	value = _tmp38_;
#line 799 "../src/slick-greeter.vala"
	_tmp39_ = value;
#line 799 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp39_, "") != 0) {
#line 4061 "slick-greeter.c"
		const gchar* _tmp40_;
		GtkSettings* _tmp41_;
		const gchar* _tmp42_;
#line 800 "../src/slick-greeter.vala"
		_tmp40_ = value;
#line 800 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:800: Setting icon theme: %s", _tmp40_);
#line 801 "../src/slick-greeter.vala"
		_tmp41_ = settings;
#line 801 "../src/slick-greeter.vala"
		_tmp42_ = value;
#line 801 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp41_, "gtk-icon-theme-name", _tmp42_, NULL, NULL);
#line 4075 "slick-greeter.c"
	}
#line 803 "../src/slick-greeter.vala"
	_tmp43_ = ug_settings_get_string (UG_SETTINGS_KEY_CURSOR_THEME_NAME);
#line 803 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 803 "../src/slick-greeter.vala"
	value = _tmp43_;
#line 804 "../src/slick-greeter.vala"
	_tmp44_ = value;
#line 804 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp44_, "") != 0) {
#line 4087 "slick-greeter.c"
		const gchar* _tmp45_;
		GtkSettings* _tmp46_;
		const gchar* _tmp47_;
#line 805 "../src/slick-greeter.vala"
		_tmp45_ = value;
#line 805 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:805: Setting cursor theme: %s", _tmp45_);
#line 806 "../src/slick-greeter.vala"
		_tmp46_ = settings;
#line 806 "../src/slick-greeter.vala"
		_tmp47_ = value;
#line 806 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp46_, "gtk-cursor-theme-name", _tmp47_, NULL, NULL);
#line 4101 "slick-greeter.c"
	}
#line 808 "../src/slick-greeter.vala"
	int_value = ug_settings_get_integer (UG_SETTINGS_KEY_CURSOR_THEME_SIZE);
#line 809 "../src/slick-greeter.vala"
	if (int_value != 0) {
#line 4107 "slick-greeter.c"
		GtkSettings* _tmp48_;
#line 810 "../src/slick-greeter.vala"
		g_debug ("slick-greeter.vala:810: Settings cursor theme size: %d", int_value * cursor_scale);
#line 811 "../src/slick-greeter.vala"
		_tmp48_ = settings;
#line 811 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp48_, "gtk-cursor-theme-size", int_value * cursor_scale, NULL, NULL);
#line 4115 "slick-greeter.c"
	}
#line 813 "../src/slick-greeter.vala"
	_tmp49_ = ug_settings_get_string (UG_SETTINGS_KEY_FONT_NAME);
#line 813 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 813 "../src/slick-greeter.vala"
	value = _tmp49_;
#line 814 "../src/slick-greeter.vala"
	_tmp50_ = value;
#line 814 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp50_, "") != 0) {
#line 4127 "slick-greeter.c"
		GtkSettings* _tmp51_;
		const gchar* _tmp52_;
#line 815 "../src/slick-greeter.vala"
		_tmp51_ = settings;
#line 815 "../src/slick-greeter.vala"
		_tmp52_ = value;
#line 815 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp51_, "gtk-font-name", _tmp52_, NULL, NULL);
#line 4136 "slick-greeter.c"
	}
#line 817 "../src/slick-greeter.vala"
	double_value = ug_settings_get_double (UG_SETTINGS_KEY_XFT_DPI);
#line 818 "../src/slick-greeter.vala"
	if (double_value != 0.0) {
#line 4142 "slick-greeter.c"
		GtkSettings* _tmp53_;
#line 819 "../src/slick-greeter.vala"
		_tmp53_ = settings;
#line 819 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp53_, "gtk-xft-dpi", (gint) (1024 * double_value), NULL, NULL);
#line 4148 "slick-greeter.c"
	}
#line 820 "../src/slick-greeter.vala"
	boolean_value = ug_settings_get_boolean (UG_SETTINGS_KEY_XFT_ANTIALIAS);
#line 821 "../src/slick-greeter.vala"
	_tmp54_ = settings;
#line 821 "../src/slick-greeter.vala"
	g_object_set ((GObject*) _tmp54_, "gtk-xft-antialias", boolean_value, NULL, NULL);
#line 822 "../src/slick-greeter.vala"
	_tmp55_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_HINTSTYLE);
#line 822 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 822 "../src/slick-greeter.vala"
	value = _tmp55_;
#line 823 "../src/slick-greeter.vala"
	_tmp56_ = value;
#line 823 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp56_, "") != 0) {
#line 4166 "slick-greeter.c"
		GtkSettings* _tmp57_;
		const gchar* _tmp58_;
#line 824 "../src/slick-greeter.vala"
		_tmp57_ = settings;
#line 824 "../src/slick-greeter.vala"
		_tmp58_ = value;
#line 824 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp57_, "gtk-xft-hintstyle", _tmp58_, NULL, NULL);
#line 4175 "slick-greeter.c"
	}
#line 825 "../src/slick-greeter.vala"
	_tmp59_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_RGBA);
#line 825 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 825 "../src/slick-greeter.vala"
	value = _tmp59_;
#line 826 "../src/slick-greeter.vala"
	_tmp60_ = value;
#line 826 "../src/slick-greeter.vala"
	if (g_strcmp0 (_tmp60_, "") != 0) {
#line 4187 "slick-greeter.c"
		GtkSettings* _tmp61_;
		const gchar* _tmp62_;
#line 827 "../src/slick-greeter.vala"
		_tmp61_ = settings;
#line 827 "../src/slick-greeter.vala"
		_tmp62_ = value;
#line 827 "../src/slick-greeter.vala"
		g_object_set ((GObject*) _tmp61_, "gtk-xft-rgba", _tmp62_, NULL, NULL);
#line 4196 "slick-greeter.c"
	}
#line 829 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:829: Creating Slick Greeter");
#line 830 "../src/slick-greeter.vala"
	_tmp63_ = slick_greeter_new (do_test_mode);
#line 830 "../src/slick-greeter.vala"
	greeter = _tmp63_;
#line 832 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:832: Showing greeter");
#line 833 "../src/slick-greeter.vala"
	_tmp64_ = greeter;
#line 833 "../src/slick-greeter.vala"
	slick_greeter_show (_tmp64_);
#line 836 "../src/slick-greeter.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda62__gsource_func, NULL, NULL);
#line 842 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:842: Starting main loop");
#line 843 "../src/slick-greeter.vala"
	gtk_main ();
#line 845 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:845: Cleaning up");
#line 847 "../src/slick-greeter.vala"
	_tmp65_ = gdk_screen_get_default ();
#line 847 "../src/slick-greeter.vala"
	_tmp66_ = _g_object_ref0 (_tmp65_);
#line 847 "../src/slick-greeter.vala"
	screen = _tmp66_;
#line 848 "../src/slick-greeter.vala"
	_tmp67_ = screen;
#line 848 "../src/slick-greeter.vala"
	_tmp68_ = gdk_screen_get_display (_tmp67_);
#line 848 "../src/slick-greeter.vala"
	_tmp69_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp68_) : NULL);
#line 848 "../src/slick-greeter.vala"
	xdisplay = _tmp69_;
#line 850 "../src/slick-greeter.vala"
	_tmp70_ = xdisplay;
#line 850 "../src/slick-greeter.vala"
	window = DefaultRootWindow (_tmp70_);
#line 851 "../src/slick-greeter.vala"
	_tmp71_ = xdisplay;
#line 851 "../src/slick-greeter.vala"
	atom = XInternAtom (_tmp71_, "AT_SPI_BUS", TRUE);
#line 853 "../src/slick-greeter.vala"
	if (atom != ((Atom) None)) {
#line 4242 "slick-greeter.c"
		Display* _tmp72_;
#line 854 "../src/slick-greeter.vala"
		_tmp72_ = xdisplay;
#line 854 "../src/slick-greeter.vala"
		XDeleteProperty (_tmp72_, window, atom);
#line 855 "../src/slick-greeter.vala"
		gdk_flush ();
#line 4250 "slick-greeter.c"
	}
#line 858 "../src/slick-greeter.vala"
	g_debug ("slick-greeter.vala:858: Exiting");
#line 860 "../src/slick-greeter.vala"
	result = EXIT_SUCCESS;
#line 860 "../src/slick-greeter.vala"
	_g_object_unref0 (screen);
#line 860 "../src/slick-greeter.vala"
	_slick_greeter_unref0 (greeter);
#line 860 "../src/slick-greeter.vala"
	_g_free0 (value);
#line 860 "../src/slick-greeter.vala"
	_g_object_unref0 (settings);
#line 860 "../src/slick-greeter.vala"
	_g_option_context_free0 (c);
#line 860 "../src/slick-greeter.vala"
	options = (g_free (options), NULL);
#line 860 "../src/slick-greeter.vala"
	_g_free0 (hidpi);
#line 860 "../src/slick-greeter.vala"
	return result;
#line 4272 "slick-greeter.c"
}

int
main (int argc,
      char ** argv)
{
#line 670 "../src/slick-greeter.vala"
	return slick_greeter_main (argv, argc);
#line 4281 "slick-greeter.c"
}

static void
g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "../src/slick-greeter.vala"
	g_return_if_fail (n_param_values == 3);
#line 22 "../src/slick-greeter.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "../src/slick-greeter.vala"
		data1 = closure->data;
#line 22 "../src/slick-greeter.vala"
		data2 = param_values->data[0].v_pointer;
#line 4306 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "../src/slick-greeter.vala"
		data2 = closure->data;
#line 4312 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
#line 22 "../src/slick-greeter.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
#line 4318 "slick-greeter.c"
}

static void
value_slick_greeter_init (GValue* value)
{
#line 22 "../src/slick-greeter.vala"
	value->data[0].v_pointer = NULL;
#line 4326 "slick-greeter.c"
}

static void
value_slick_greeter_free_value (GValue* value)
{
#line 22 "../src/slick-greeter.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/slick-greeter.vala"
		slick_greeter_unref (value->data[0].v_pointer);
#line 4336 "slick-greeter.c"
	}
}

static void
value_slick_greeter_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 22 "../src/slick-greeter.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/slick-greeter.vala"
		dest_value->data[0].v_pointer = slick_greeter_ref (src_value->data[0].v_pointer);
#line 4348 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4352 "slick-greeter.c"
	}
}

static gpointer
value_slick_greeter_peek_pointer (const GValue* value)
{
#line 22 "../src/slick-greeter.vala"
	return value->data[0].v_pointer;
#line 4361 "slick-greeter.c"
}

static gchar*
value_slick_greeter_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 22 "../src/slick-greeter.vala"
	if (collect_values[0].v_pointer) {
#line 4372 "slick-greeter.c"
		SlickGreeter * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/slick-greeter.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/slick-greeter.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4379 "slick-greeter.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/slick-greeter.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4383 "slick-greeter.c"
		}
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = slick_greeter_ref (object);
#line 4387 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = NULL;
#line 4391 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	return NULL;
#line 4395 "slick-greeter.c"
}

static gchar*
value_slick_greeter_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	SlickGreeter ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/slick-greeter.vala"
	if (!object_p) {
#line 22 "../src/slick-greeter.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4410 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/slick-greeter.vala"
		*object_p = NULL;
#line 4416 "slick-greeter.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/slick-greeter.vala"
		*object_p = value->data[0].v_pointer;
#line 4420 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		*object_p = slick_greeter_ref (value->data[0].v_pointer);
#line 4424 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	return NULL;
#line 4428 "slick-greeter.c"
}

GParamSpec*
param_spec_slick_greeter (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecSlickGreeter* spec;
#line 22 "../src/slick-greeter.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SLICK_GREETER), NULL);
#line 22 "../src/slick-greeter.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/slick-greeter.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/slick-greeter.vala"
	return G_PARAM_SPEC (spec);
#line 4447 "slick-greeter.c"
}

gpointer
value_get_slick_greeter (const GValue* value)
{
#line 22 "../src/slick-greeter.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLICK_GREETER), NULL);
#line 22 "../src/slick-greeter.vala"
	return value->data[0].v_pointer;
#line 4457 "slick-greeter.c"
}

void
value_set_slick_greeter (GValue* value,
                         gpointer v_object)
{
	SlickGreeter * old;
#line 22 "../src/slick-greeter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLICK_GREETER));
#line 22 "../src/slick-greeter.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/slick-greeter.vala"
	if (v_object) {
#line 22 "../src/slick-greeter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SLICK_GREETER));
#line 22 "../src/slick-greeter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/slick-greeter.vala"
		slick_greeter_ref (value->data[0].v_pointer);
#line 4479 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = NULL;
#line 4483 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	if (old) {
#line 22 "../src/slick-greeter.vala"
		slick_greeter_unref (old);
#line 4489 "slick-greeter.c"
	}
}

void
value_take_slick_greeter (GValue* value,
                          gpointer v_object)
{
	SlickGreeter * old;
#line 22 "../src/slick-greeter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SLICK_GREETER));
#line 22 "../src/slick-greeter.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/slick-greeter.vala"
	if (v_object) {
#line 22 "../src/slick-greeter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SLICK_GREETER));
#line 22 "../src/slick-greeter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = v_object;
#line 4510 "slick-greeter.c"
	} else {
#line 22 "../src/slick-greeter.vala"
		value->data[0].v_pointer = NULL;
#line 4514 "slick-greeter.c"
	}
#line 22 "../src/slick-greeter.vala"
	if (old) {
#line 22 "../src/slick-greeter.vala"
		slick_greeter_unref (old);
#line 4520 "slick-greeter.c"
	}
}

static void
slick_greeter_class_init (SlickGreeterClass * klass,
                          gpointer klass_data)
{
#line 22 "../src/slick-greeter.vala"
	slick_greeter_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/slick-greeter.vala"
	((SlickGreeterClass *) klass)->finalize = slick_greeter_finalize;
#line 22 "../src/slick-greeter.vala"
	g_type_class_adjust_private_offset (klass, &SlickGreeter_private_offset);
#line 22 "../src/slick-greeter.vala"
	slick_greeter_signals[SLICK_GREETER_SHOW_MESSAGE_SIGNAL] = g_signal_new ("show-message", TYPE_SLICK_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, lightdm_message_type_get_type ());
#line 22 "../src/slick-greeter.vala"
	slick_greeter_signals[SLICK_GREETER_SHOW_PROMPT_SIGNAL] = g_signal_new ("show-prompt", TYPE_SLICK_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, lightdm_prompt_type_get_type ());
#line 22 "../src/slick-greeter.vala"
	slick_greeter_signals[SLICK_GREETER_AUTHENTICATION_COMPLETE_SIGNAL] = g_signal_new ("authentication-complete", TYPE_SLICK_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "../src/slick-greeter.vala"
	slick_greeter_signals[SLICK_GREETER_STARTING_SESSION_SIGNAL] = g_signal_new ("starting-session", TYPE_SLICK_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4542 "slick-greeter.c"
}

static void
slick_greeter_instance_init (SlickGreeter * self,
                             gpointer klass)
{
#line 22 "../src/slick-greeter.vala"
	self->priv = slick_greeter_get_instance_private (self);
#line 31 "../src/slick-greeter.vala"
	self->test_mode = FALSE;
#line 22 "../src/slick-greeter.vala"
	self->ref_count = 1;
#line 4555 "slick-greeter.c"
}

static void
slick_greeter_finalize (SlickGreeter * obj)
{
	SlickGreeter * self;
#line 22 "../src/slick-greeter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLICK_GREETER, SlickGreeter);
#line 22 "../src/slick-greeter.vala"
	g_signal_handlers_destroy (self);
#line 33 "../src/slick-greeter.vala"
	_g_free0 (self->priv->state_file);
#line 34 "../src/slick-greeter.vala"
	_g_key_file_unref0 (self->priv->state);
#line 36 "../src/slick-greeter.vala"
	_cairo_surface_destroy0 (self->priv->background_surface);
#line 39 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->main_window);
#line 41 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->greeter);
#line 43 "../src/slick-greeter.vala"
	_ca_context_destroy0 (self->priv->canberra_context);
#line 47 "../src/slick-greeter.vala"
	_g_object_unref0 (self->priv->dbus_object);
#line 4580 "slick-greeter.c"
}

static GType
slick_greeter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_slick_greeter_init, value_slick_greeter_free_value, value_slick_greeter_copy_value, value_slick_greeter_peek_pointer, "p", value_slick_greeter_collect_value, "p", value_slick_greeter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SlickGreeterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slick_greeter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlickGreeter), 0, (GInstanceInitFunc) slick_greeter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType slick_greeter_type_id;
	slick_greeter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SlickGreeter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SlickGreeter_private_offset = g_type_add_instance_private (slick_greeter_type_id, sizeof (SlickGreeterPrivate));
	return slick_greeter_type_id;
}

GType
slick_greeter_get_type (void)
{
	static volatile gsize slick_greeter_type_id__once = 0;
	if (g_once_init_enter (&slick_greeter_type_id__once)) {
		GType slick_greeter_type_id;
		slick_greeter_type_id = slick_greeter_get_type_once ();
		g_once_init_leave (&slick_greeter_type_id__once, slick_greeter_type_id);
	}
	return slick_greeter_type_id__once;
}

gpointer
slick_greeter_ref (gpointer instance)
{
	SlickGreeter * self;
	self = instance;
#line 22 "../src/slick-greeter.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/slick-greeter.vala"
	return instance;
#line 4616 "slick-greeter.c"
}

void
slick_greeter_unref (gpointer instance)
{
	SlickGreeter * self;
	self = instance;
#line 22 "../src/slick-greeter.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/slick-greeter.vala"
		SLICK_GREETER_GET_CLASS (self)->finalize (self);
#line 22 "../src/slick-greeter.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4630 "slick-greeter.c"
	}
}

void
dialog_dbus_interface_open (DialogDBusInterface* self,
                            guint32 type,
                            guint32 timestamp,
                            guint32 seconds_to_stay_open,
                            char** inhibitor_object_paths,
                            gint inhibitor_object_paths_length1,
                            GError** error)
{
#line 870 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 872 "../src/slick-greeter.vala"
	g_signal_emit (self, dialog_dbus_interface_signals[DIALOG_DBUS_INTERFACE_OPEN_DIALOG_SIGNAL], 0, type);
#line 4647 "slick-greeter.c"
}

void
dialog_dbus_interface_close (DialogDBusInterface* self,
                             GError** error)
{
#line 875 "../src/slick-greeter.vala"
	g_return_if_fail (self != NULL);
#line 877 "../src/slick-greeter.vala"
	g_signal_emit (self, dialog_dbus_interface_signals[DIALOG_DBUS_INTERFACE_CLOSE_DIALOG_SIGNAL], 0);
#line 4658 "slick-greeter.c"
}

DialogDBusInterface*
dialog_dbus_interface_construct (GType object_type)
{
	DialogDBusInterface * self = NULL;
#line 865 "../src/slick-greeter.vala"
	self = (DialogDBusInterface*) g_object_new (object_type, NULL);
#line 865 "../src/slick-greeter.vala"
	return self;
#line 4669 "slick-greeter.c"
}

DialogDBusInterface*
dialog_dbus_interface_new (void)
{
#line 865 "../src/slick-greeter.vala"
	return dialog_dbus_interface_construct (TYPE_DIALOG_DBUS_INTERFACE);
#line 4677 "slick-greeter.c"
}

static void
dialog_dbus_interface_class_init (DialogDBusInterfaceClass * klass,
                                  gpointer klass_data)
{
#line 865 "../src/slick-greeter.vala"
	dialog_dbus_interface_parent_class = g_type_class_peek_parent (klass);
#line 865 "../src/slick-greeter.vala"
	dialog_dbus_interface_signals[DIALOG_DBUS_INTERFACE_OPEN_DIALOG_SIGNAL] = g_signal_new ("open-dialog", TYPE_DIALOG_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
#line 865 "../src/slick-greeter.vala"
	dialog_dbus_interface_signals[DIALOG_DBUS_INTERFACE_CLOSE_DIALOG_SIGNAL] = g_signal_new ("close-dialog", TYPE_DIALOG_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4690 "slick-greeter.c"
}

static void
dialog_dbus_interface_instance_init (DialogDBusInterface * self,
                                     gpointer klass)
{
}

static GType
dialog_dbus_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DialogDBusInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dialog_dbus_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DialogDBusInterface), 0, (GInstanceInitFunc) dialog_dbus_interface_instance_init, NULL };
	GType dialog_dbus_interface_type_id;
	dialog_dbus_interface_type_id = g_type_register_static (G_TYPE_OBJECT, "DialogDBusInterface", &g_define_type_info, 0);
	g_type_set_qdata (dialog_dbus_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dialog_dbus_interface_register_object);
	return dialog_dbus_interface_type_id;
}

GType
dialog_dbus_interface_get_type (void)
{
	static volatile gsize dialog_dbus_interface_type_id__once = 0;
	if (g_once_init_enter (&dialog_dbus_interface_type_id__once)) {
		GType dialog_dbus_interface_type_id;
		dialog_dbus_interface_type_id = dialog_dbus_interface_get_type_once ();
		g_once_init_leave (&dialog_dbus_interface_type_id__once, dialog_dbus_interface_type_id);
	}
	return dialog_dbus_interface_type_id__once;
}

static void
_dbus_dialog_dbus_interface_open (DialogDBusInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 type = 0U;
	GVariant* _tmp245_;
	guint32 timestamp = 0U;
	GVariant* _tmp246_;
	guint32 seconds_to_stay_open = 0U;
	GVariant* _tmp247_;
	char** inhibitor_object_paths = NULL;
	gint inhibitor_object_paths_length1 = 0;
	GVariant* _tmp248_;
	char** _tmp249_;
	gint _tmp249__length;
	gint _tmp249__size;
	gint _tmp249__length1;
	GVariantIter _tmp250_;
	GVariant* _tmp251_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp245_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp245_);
	g_variant_unref (_tmp245_);
	_tmp246_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp246_);
	g_variant_unref (_tmp246_);
	_tmp247_ = g_variant_iter_next_value (&_arguments_iter);
	seconds_to_stay_open = g_variant_get_uint32 (_tmp247_);
	g_variant_unref (_tmp247_);
	_tmp248_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp249_ = g_new (char*, 5);
	_tmp249__length = 0;
	_tmp249__size = 4;
	_tmp249__length1 = 0;
	g_variant_iter_init (&_tmp250_, _tmp248_);
	for (; (_tmp251_ = g_variant_iter_next_value (&_tmp250_)) != NULL; _tmp249__length1++) {
		if (_tmp249__size == _tmp249__length) {
			_tmp249__size = 2 * _tmp249__size;
			_tmp249_ = g_renew (char*, _tmp249_, _tmp249__size + 1);
		}
		_tmp249_[_tmp249__length++] = g_variant_dup_string (_tmp251_, NULL);
		g_variant_unref (_tmp251_);
	}
	inhibitor_object_paths_length1 = _tmp249__length1;
	_tmp249_[_tmp249__length] = NULL;
	inhibitor_object_paths = _tmp249_;
	g_variant_unref (_tmp248_);
	dialog_dbus_interface_open (self, type, timestamp, seconds_to_stay_open, inhibitor_object_paths, inhibitor_object_paths_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	inhibitor_object_paths = (_vala_array_free (inhibitor_object_paths, inhibitor_object_paths_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_dialog_dbus_interface_close (DialogDBusInterface* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	dialog_dbus_interface_close (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
dialog_dbus_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Open") == 0) {
		_dbus_dialog_dbus_interface_open (object, parameters, invocation);
	} else if (strcmp (method_name, "Close") == 0) {
		_dbus_dialog_dbus_interface_close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
dialog_dbus_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
dialog_dbus_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_dialog_dbus_interface_open_dialog (GObject* _sender,
                                         guint32 type,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "OpenDialog", _arguments, NULL);
}

static void
_dbus_dialog_dbus_interface_close_dialog (GObject* _sender,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "CloseDialog", _arguments, NULL);
}

guint
dialog_dbus_interface_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dialog_dbus_interface_dbus_interface_info), &_dialog_dbus_interface_dbus_interface_vtable, data, _dialog_dbus_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "open-dialog", (GCallback) _dbus_dialog_dbus_interface_open_dialog, data);
	g_signal_connect (object, "close-dialog", (GCallback) _dbus_dialog_dbus_interface_close_dialog, data);
	return result;
}

static void
_dialog_dbus_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dialog_dbus_interface_open_dialog, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dialog_dbus_interface_close_dialog, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

