// Code generated by github.com/atombender/go-jsonschema, DO NOT EDIT.

package plugins

import "encoding/json"
import "fmt"

// Artwork service permissions for generating artwork URLs
type ArtworkPermission struct {
	// Explanation for why artwork access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// Cache service permissions for storing and retrieving data
type CachePermission struct {
	// Explanation for why cache access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// Configuration schema for the plugin using JSON Schema (draft-07) and optional
// JSONForms UI Schema
type ConfigDefinition struct {
	// JSON Schema (draft-07) defining the plugin's configuration options
	Schema map[string]interface{} `json:"schema" yaml:"schema" mapstructure:"schema"`

	// Optional JSONForms UI Schema for customizing form layout
	UiSchema map[string]interface{} `json:"uiSchema,omitempty" yaml:"uiSchema,omitempty" mapstructure:"uiSchema,omitempty"`
}

// UnmarshalJSON implements json.Unmarshaler.
func (j *ConfigDefinition) UnmarshalJSON(value []byte) error {
	var raw map[string]interface{}
	if err := json.Unmarshal(value, &raw); err != nil {
		return err
	}
	if _, ok := raw["schema"]; raw != nil && !ok {
		return fmt.Errorf("field schema in ConfigDefinition: required")
	}
	type Plain ConfigDefinition
	var plain Plain
	if err := json.Unmarshal(value, &plain); err != nil {
		return err
	}
	*j = ConfigDefinition(plain)
	return nil
}

// Experimental features that may change or be removed in future versions
type Experimental struct {
	// Threads corresponds to the JSON schema field "threads".
	Threads *ThreadsFeature `json:"threads,omitempty" yaml:"threads,omitempty" mapstructure:"threads,omitempty"`
}

// HTTP access permissions for a plugin
type HTTPPermission struct {
	// Explanation for why HTTP access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`

	// List of required host patterns for HTTP requests (e.g., 'api.example.com',
	// '*.spotify.com')
	RequiredHosts []string `json:"requiredHosts,omitempty" yaml:"requiredHosts,omitempty" mapstructure:"requiredHosts,omitempty"`
}

// Key-value store permissions for persistent plugin storage
type KVStorePermission struct {
	// Maximum storage size (e.g., '1MB', '500KB'). Default: 1MB
	MaxSize *string `json:"maxSize,omitempty" yaml:"maxSize,omitempty" mapstructure:"maxSize,omitempty"`

	// Explanation for why key-value store access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// Library service permissions for accessing library metadata and optionally
// filesystem
type LibraryPermission struct {
	// Whether the plugin requires read-only filesystem access to library directories
	Filesystem bool `json:"filesystem,omitempty" yaml:"filesystem,omitempty" mapstructure:"filesystem,omitempty"`

	// Explanation for why library access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// UnmarshalJSON implements json.Unmarshaler.
func (j *LibraryPermission) UnmarshalJSON(value []byte) error {
	var raw map[string]interface{}
	if err := json.Unmarshal(value, &raw); err != nil {
		return err
	}
	type Plain LibraryPermission
	var plain Plain
	if err := json.Unmarshal(value, &plain); err != nil {
		return err
	}
	if v, ok := raw["filesystem"]; !ok || v == nil {
		plain.Filesystem = false
	}
	*j = LibraryPermission(plain)
	return nil
}

// Plugin manifest for Navidrome plugins
type Manifest struct {
	// The author of the plugin
	Author string `json:"author" yaml:"author" mapstructure:"author"`

	// Config corresponds to the JSON schema field "config".
	Config *ConfigDefinition `json:"config,omitempty" yaml:"config,omitempty" mapstructure:"config,omitempty"`

	// A brief description of what the plugin does
	Description *string `json:"description,omitempty" yaml:"description,omitempty" mapstructure:"description,omitempty"`

	// Experimental corresponds to the JSON schema field "experimental".
	Experimental *Experimental `json:"experimental,omitempty" yaml:"experimental,omitempty" mapstructure:"experimental,omitempty"`

	// The display name of the plugin
	Name string `json:"name" yaml:"name" mapstructure:"name"`

	// Permissions corresponds to the JSON schema field "permissions".
	Permissions *Permissions `json:"permissions,omitempty" yaml:"permissions,omitempty" mapstructure:"permissions,omitempty"`

	// The version of the plugin (semver recommended)
	Version string `json:"version" yaml:"version" mapstructure:"version"`

	// URL to the plugin's website or repository
	Website *string `json:"website,omitempty" yaml:"website,omitempty" mapstructure:"website,omitempty"`
}

// UnmarshalJSON implements json.Unmarshaler.
func (j *Manifest) UnmarshalJSON(value []byte) error {
	var raw map[string]interface{}
	if err := json.Unmarshal(value, &raw); err != nil {
		return err
	}
	if _, ok := raw["author"]; raw != nil && !ok {
		return fmt.Errorf("field author in Manifest: required")
	}
	if _, ok := raw["name"]; raw != nil && !ok {
		return fmt.Errorf("field name in Manifest: required")
	}
	if _, ok := raw["version"]; raw != nil && !ok {
		return fmt.Errorf("field version in Manifest: required")
	}
	type Plain Manifest
	var plain Plain
	if err := json.Unmarshal(value, &plain); err != nil {
		return err
	}
	if len(plain.Author) < 1 {
		return fmt.Errorf("field %s length: must be >= %d", "author", 1)
	}
	if len(plain.Name) < 1 {
		return fmt.Errorf("field %s length: must be >= %d", "name", 1)
	}
	if len(plain.Version) < 1 {
		return fmt.Errorf("field %s length: must be >= %d", "version", 1)
	}
	*j = Manifest(plain)
	return nil
}

// Permissions required by the plugin
type Permissions struct {
	// Artwork corresponds to the JSON schema field "artwork".
	Artwork *ArtworkPermission `json:"artwork,omitempty" yaml:"artwork,omitempty" mapstructure:"artwork,omitempty"`

	// Cache corresponds to the JSON schema field "cache".
	Cache *CachePermission `json:"cache,omitempty" yaml:"cache,omitempty" mapstructure:"cache,omitempty"`

	// Http corresponds to the JSON schema field "http".
	Http *HTTPPermission `json:"http,omitempty" yaml:"http,omitempty" mapstructure:"http,omitempty"`

	// Kvstore corresponds to the JSON schema field "kvstore".
	Kvstore *KVStorePermission `json:"kvstore,omitempty" yaml:"kvstore,omitempty" mapstructure:"kvstore,omitempty"`

	// Library corresponds to the JSON schema field "library".
	Library *LibraryPermission `json:"library,omitempty" yaml:"library,omitempty" mapstructure:"library,omitempty"`

	// Scheduler corresponds to the JSON schema field "scheduler".
	Scheduler *SchedulerPermission `json:"scheduler,omitempty" yaml:"scheduler,omitempty" mapstructure:"scheduler,omitempty"`

	// Subsonicapi corresponds to the JSON schema field "subsonicapi".
	Subsonicapi *SubsonicAPIPermission `json:"subsonicapi,omitempty" yaml:"subsonicapi,omitempty" mapstructure:"subsonicapi,omitempty"`

	// Users corresponds to the JSON schema field "users".
	Users *UsersPermission `json:"users,omitempty" yaml:"users,omitempty" mapstructure:"users,omitempty"`

	// Websocket corresponds to the JSON schema field "websocket".
	Websocket *WebSocketPermission `json:"websocket,omitempty" yaml:"websocket,omitempty" mapstructure:"websocket,omitempty"`
}

// Scheduler service permissions for scheduling tasks
type SchedulerPermission struct {
	// Explanation for why scheduler access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// SubsonicAPI service permissions. Requires 'users' permission to be declared.
type SubsonicAPIPermission struct {
	// Explanation for why SubsonicAPI access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// Enable experimental WebAssembly threads support
type ThreadsFeature struct {
	// Explanation for why threads support is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// Users service permissions for accessing user information
type UsersPermission struct {
	// Explanation for why users access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`
}

// WebSocket service permissions for establishing WebSocket connections
type WebSocketPermission struct {
	// Explanation for why WebSocket access is needed
	Reason *string `json:"reason,omitempty" yaml:"reason,omitempty" mapstructure:"reason,omitempty"`

	// List of required host patterns for WebSocket connections (e.g.,
	// 'api.example.com', '*.spotify.com')
	RequiredHosts []string `json:"requiredHosts,omitempty" yaml:"requiredHosts,omitempty" mapstructure:"requiredHosts,omitempty"`
}
