// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the AMI that was used to launch an instance, even if the AMI is
// deprecated, deregistered, made private (no longer public or shared with your
// account), or not allowed.
//
// If you specify instance IDs, the output includes information for only the
// specified instances. If you specify filters, the output includes information for
// only those instances that meet the filter criteria. If you do not specify
// instance IDs or filters, the output includes information for all instances,
// which can affect performance.
//
// If you specify an instance ID that is not valid, an instance that doesn't
// exist, or an instance that you do not own, an error ( InvalidInstanceID.NotFound
// ) is returned.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// In the rare case where an Availability Zone is experiencing a service
// disruption and you specify instance IDs that are in the affected Availability
// Zone, or do not specify any instance IDs at all, the call fails. If you specify
// only instance IDs that are in an unaffected Availability Zone, the call works
// normally.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear in a
// particular order.
func (c *Client) DescribeInstanceImageMetadata(ctx context.Context, params *DescribeInstanceImageMetadataInput, optFns ...func(*Options)) (*DescribeInstanceImageMetadataOutput, error) {
	if params == nil {
		params = &DescribeInstanceImageMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInstanceImageMetadata", params, optFns, c.addOperationDescribeInstanceImageMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInstanceImageMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInstanceImageMetadataInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - availability-zone - The name of the Availability Zone (for example,
	//   us-west-2a ) or Local Zone (for example, us-west-2-lax-1b ) of the instance.
	//
	//   - instance-id - The ID of the instance.
	//
	//   - image-allowed - A Boolean that indicates whether the image meets the
	//   criteria specified for Allowed AMIs.
	//
	//   - instance-state-name - The state of the instance ( pending | running |
	//   shutting-down | terminated | stopping | stopped ).
	//
	//   - instance-type - The type of instance (for example, t3.micro ).
	//
	//   - launch-time - The time when the instance was launched, in the ISO 8601
	//   format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example,
	//   2023-09-29T11:04:43.305Z . You can use a wildcard ( * ), for example,
	//   2023-09-29T* , which matches an entire day.
	//
	//   - owner-alias - The owner alias ( amazon | aws-marketplace | aws-backup-vault
	//   ). The valid aliases are defined in an Amazon-maintained list. This is not the
	//   Amazon Web Services account alias that can be set using the IAM console. We
	//   recommend that you use the Owner request parameter instead of this filter.
	//
	//   - owner-id - The Amazon Web Services account ID of the owner. We recommend
	//   that you use the Owner request parameter instead of this filter.
	//
	//   - tag: - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources assigned a tag with a specific key, regardless of the tag value.
	//
	//   - zone-id - The ID of the Availability Zone (for example, usw2-az2 ) or Local
	//   Zone (for example, usw2-lax1-az1 ) of the instance.
	Filters []types.Filter

	// The instance IDs.
	//
	// If you don't specify an instance ID or filters, the output includes information
	// for all instances.
	InstanceIds []string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// Default: 1000
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token returned from a previous paginated request. Pagination continues from
	// the end of the items returned by the previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeInstanceImageMetadataOutput struct {

	// Information about the instance and the AMI used to launch the instance.
	InstanceImageMetadata []types.InstanceImageMetadata

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInstanceImageMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeInstanceImageMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeInstanceImageMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeInstanceImageMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInstanceImageMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeInstanceImageMetadataPaginatorOptions is the paginator options for
// DescribeInstanceImageMetadata
type DescribeInstanceImageMetadataPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// Default: 1000
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeInstanceImageMetadataPaginator is a paginator for
// DescribeInstanceImageMetadata
type DescribeInstanceImageMetadataPaginator struct {
	options   DescribeInstanceImageMetadataPaginatorOptions
	client    DescribeInstanceImageMetadataAPIClient
	params    *DescribeInstanceImageMetadataInput
	nextToken *string
	firstPage bool
}

// NewDescribeInstanceImageMetadataPaginator returns a new
// DescribeInstanceImageMetadataPaginator
func NewDescribeInstanceImageMetadataPaginator(client DescribeInstanceImageMetadataAPIClient, params *DescribeInstanceImageMetadataInput, optFns ...func(*DescribeInstanceImageMetadataPaginatorOptions)) *DescribeInstanceImageMetadataPaginator {
	if params == nil {
		params = &DescribeInstanceImageMetadataInput{}
	}

	options := DescribeInstanceImageMetadataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeInstanceImageMetadataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeInstanceImageMetadataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeInstanceImageMetadata page.
func (p *DescribeInstanceImageMetadataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeInstanceImageMetadataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeInstanceImageMetadata(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeInstanceImageMetadataAPIClient is a client that implements the
// DescribeInstanceImageMetadata operation.
type DescribeInstanceImageMetadataAPIClient interface {
	DescribeInstanceImageMetadata(context.Context, *DescribeInstanceImageMetadataInput, ...func(*Options)) (*DescribeInstanceImageMetadataOutput, error)
}

var _ DescribeInstanceImageMetadataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeInstanceImageMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInstanceImageMetadata",
	}
}
