/* calculator-plugin-backend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from calculator-plugin-backend.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2022 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <glib-object.h>

#define SYNAPSE_CALCULATOR_PLUGIN_BACKEND_VALID_NUM "0123456789ABCDEF"
#define SYNAPSE_CALCULATOR_PLUGIN_BACKEND_VALID_OP ".()%^&|!*/-+"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_CALCULATOR_PLUGIN_BACKEND_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_BACKEND_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_backend_properties[SYNAPSE_CALCULATOR_PLUGIN_BACKEND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseCalculatorPluginBackendGetSolutionData SynapseCalculatorPluginBackendGetSolutionData;

struct _SynapseCalculatorPluginBackendPrivate {
	gchar* use_num;
};

struct _SynapseCalculatorPluginBackendGetSolutionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCalculatorPluginBackend* self;
	gchar* query_string;
	GCancellable* cancellable;
	gchar* result;
	gchar* solution;
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** expressions;
	const gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint expressions_length1;
	gint _expressions_size_;
	gchar* final_input;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** expr_collection;
	gint expr_collection_length1;
	gint _expr_collection_size_;
	gint expr_it;
	gchar* _tmp24_;
	gchar* expr;
	gboolean is_base_expr;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	gchar** argv;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	GPid _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp49_;
	GDataInputStream* bc_output;
	GUnixInputStream* _tmp50_;
	GDataInputStream* _tmp51_;
	GUnixOutputStream* write_stream;
	GUnixOutputStream* _tmp52_;
	GDataOutputStream* bc_input;
	GUnixOutputStream* _tmp53_;
	GDataOutputStream* _tmp54_;
	const gchar* _tmp55_;
	GDataOutputStream* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GDataOutputStream* _tmp60_;
	gchar* _tmp61_;
	GDataInputStream* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gboolean _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	GError* _tmp68_;
	GError* _inner_error0_;
};

static gint SynapseCalculatorPluginBackend_private_offset;
static gpointer synapse_calculator_plugin_backend_parent_class = NULL;
static SynapseCalculatorPluginBackend* synapse_calculator_plugin_backend_instance;
static SynapseCalculatorPluginBackend* synapse_calculator_plugin_backend_instance = NULL;

static void synapse_calculator_plugin_backend_get_solution_data_free (gpointer _data);
static gboolean synapse_calculator_plugin_backend_get_solution_co (SynapseCalculatorPluginBackendGetSolutionData* _data_);
static gboolean synapse_calculator_plugin_backend_allowed_expression (SynapseCalculatorPluginBackend* self,
                                                               const gchar* expr,
                                                               gboolean* is_base_expr);
static void synapse_calculator_plugin_backend_get_solution_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_calculator_plugin_backend_finalize (GObject * obj);
static GType synapse_calculator_plugin_backend_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_calculator_plugin_backend_get_instance_private (SynapseCalculatorPluginBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPluginBackend_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_get_instance (void)
{
	SynapseCalculatorPluginBackend* _tmp0_;
	SynapseCalculatorPluginBackend* _tmp2_;
	SynapseCalculatorPluginBackend* _tmp3_;
	SynapseCalculatorPluginBackend* result;
	_tmp0_ = synapse_calculator_plugin_backend_instance;
	if (_tmp0_ == NULL) {
		SynapseCalculatorPluginBackend* _tmp1_;
		_tmp1_ = synapse_calculator_plugin_backend_new ();
		_g_object_unref0 (synapse_calculator_plugin_backend_instance);
		synapse_calculator_plugin_backend_instance = _tmp1_;
	}
	_tmp2_ = synapse_calculator_plugin_backend_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
synapse_calculator_plugin_backend_get_solution_data_free (gpointer _data)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCalculatorPluginBackendGetSolutionData, _data_);
}

void
synapse_calculator_plugin_backend_get_solution (SynapseCalculatorPluginBackend* self,
                                                const gchar* query_string,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	SynapseCalculatorPluginBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (SynapseCalculatorPluginBackendGetSolutionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_calculator_plugin_backend_get_solution_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	synapse_calculator_plugin_backend_get_solution_co (_data_);
}

gchar*
synapse_calculator_plugin_backend_get_solution_finish (SynapseCalculatorPluginBackend* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	gchar* result;
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
synapse_calculator_plugin_backend_get_solution_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_calculator_plugin_backend_get_solution_co (_data_);
}

static gboolean
synapse_calculator_plugin_backend_get_solution_co (SynapseCalculatorPluginBackendGetSolutionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->solution = NULL;
	_data_->_tmp0_ = string_slice (SYNAPSE_CALCULATOR_PLUGIN_BACKEND_VALID_NUM, (glong) 0, (glong) 10);
	_g_free0 (_data_->self->priv->use_num);
	_data_->self->priv->use_num = _data_->_tmp0_;
	_data_->_tmp1_ = string_replace (_data_->query_string, " ", "");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = string_replace (_data_->_tmp2_, ",", ".");
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = string_replace (_data_->_tmp4_, "exp(", "e(");
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = string_replace (_data_->_tmp6_, "x", "*");
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = string_replace (_data_->_tmp8_, "ln(", "l(");
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = string_replace (_data_->_tmp10_, "sin(", "s(");
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = string_replace (_data_->_tmp12_, "cos(", "c(");
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = string_replace (_data_->_tmp14_, "pi", "(a(1)*4)");
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = string_replace (_data_->_tmp16_, "π", "(a(1)*4)");
	_data_->_tmp18_ = _data_->_tmp17_;
	_g_free0 (_data_->_tmp16_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp6_);
	_g_free0 (_data_->_tmp4_);
	_g_free0 (_data_->_tmp2_);
	_data_->input = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->input;
	_data_->_tmp21_ = _data_->_tmp20_ = g_strsplit (_data_->_tmp19_, ";", 0);
	_data_->expressions = _data_->_tmp21_;
	_data_->expressions_length1 = _vala_array_length (_data_->_tmp20_);
	_data_->_expressions_size_ = _data_->expressions_length1;
	_data_->_tmp22_ = g_strdup ("");
	_data_->final_input = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->expressions;
	_data_->_tmp23__length1 = _data_->expressions_length1;
	{
		_data_->expr_collection_length1 = 0;
		_data_->_expr_collection_size_ = 0;
		_data_->expr_collection = _data_->_tmp23_;
		_data_->expr_collection_length1 = _data_->_tmp23__length1;
		for (_data_->expr_it = 0; _data_->expr_it < _data_->expr_collection_length1; _data_->expr_it = _data_->expr_it + 1) {
			_data_->_tmp24_ = g_strdup (_data_->expr_collection[_data_->expr_it]);
			_data_->expr = _data_->_tmp24_;
			{
				_data_->_tmp25_ = _data_->expr;
				_data_->_tmp26_ = FALSE;
				_data_->_tmp27_ = synapse_calculator_plugin_backend_allowed_expression (_data_->self, _data_->_tmp25_, &_data_->_tmp26_);
				_data_->is_base_expr = _data_->_tmp26_;
				if (!_data_->_tmp27_) {
					_data_->_tmp28_ = _data_->expr;
					g_critical ("calculator-plugin-backend.vala:57: Invalid expression %s", _data_->_tmp28_);
					_data_->_tmp29_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED, "Invalid expression");
					_data_->_inner_error0_ = _data_->_tmp29_;
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->expr);
					_g_free0 (_data_->final_input);
					_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->input);
					_g_free0 (_data_->solution);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				if (_data_->is_base_expr) {
					_data_->_tmp30_ = _data_->expr;
					_data_->_tmp31_ = _data_->final_input;
					_data_->_tmp32_ = g_strjoin (";", _data_->_tmp30_, _data_->_tmp31_, NULL);
					_g_free0 (_data_->final_input);
					_data_->final_input = _data_->_tmp32_;
				} else {
					_data_->_tmp33_ = _data_->final_input;
					_data_->_tmp34_ = _data_->expr;
					_data_->_tmp35_ = g_strjoin (";", _data_->_tmp33_, _data_->_tmp34_, NULL);
					_g_free0 (_data_->final_input);
					_data_->final_input = _data_->_tmp35_;
				}
				_g_free0 (_data_->expr);
			}
		}
	}
	_data_->_tmp36_ = _data_->final_input;
	_data_->_tmp37_ = string_replace (_data_->_tmp36_, "--", "- -");
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = string_replace (_data_->_tmp38_, "+-", "+ -");
	_g_free0 (_data_->final_input);
	_data_->final_input = _data_->_tmp39_;
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp40_ = _data_->final_input;
	_data_->_tmp41_ = string_replace (_data_->_tmp40_, ";;", ";");
	_g_free0 (_data_->final_input);
	_data_->final_input = _data_->_tmp41_;
	_data_->_tmp42_ = g_strdup ("bc");
	_data_->_tmp43_ = g_strdup ("-l");
	_data_->_tmp44_ = g_new0 (gchar*, 2 + 1);
	_data_->_tmp44_[0] = _data_->_tmp42_;
	_data_->_tmp44_[1] = _data_->_tmp43_;
	_data_->argv = _data_->_tmp44_;
	_data_->argv_length1 = 2;
	_data_->_argv_size_ = _data_->argv_length1;
	_data_->_tmp45_ = _data_->argv;
	_data_->_tmp45__length1 = _data_->argv_length1;
	_data_->_tmp46_ = 0;
	_data_->_tmp47_ = 0;
	_data_->_tmp48_ = 0;
	g_spawn_async_with_pipes (NULL, _data_->_tmp45_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp46_, &_data_->_tmp47_, &_data_->_tmp48_, NULL, &_data_->_inner_error0_);
	_data_->pid = _data_->_tmp46_;
	_data_->write_fd = _data_->_tmp47_;
	_data_->read_fd = _data_->_tmp48_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp49_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
	_data_->read_stream = _data_->_tmp49_;
	_data_->_tmp50_ = _data_->read_stream;
	_data_->_tmp51_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp50_);
	_data_->bc_output = _data_->_tmp51_;
	_data_->_tmp52_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->write_fd, TRUE);
	_data_->write_stream = _data_->_tmp52_;
	_data_->_tmp53_ = _data_->write_stream;
	_data_->_tmp54_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp53_);
	_data_->bc_input = _data_->_tmp54_;
	_data_->_tmp55_ = _data_->final_input;
	g_debug ("calculator-plugin-backend.vala:89: bc input string %s\n", _data_->_tmp55_);
	_data_->_tmp56_ = _data_->bc_input;
	_data_->_tmp57_ = _data_->final_input;
	_data_->_tmp58_ = g_strconcat (_data_->_tmp57_, "\n", NULL);
	_data_->_tmp59_ = _data_->_tmp58_;
	g_data_output_stream_put_string (_data_->_tmp56_, _data_->_tmp59_, _data_->cancellable, &_data_->_inner_error0_);
	_g_free0 (_data_->_tmp59_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp60_ = _data_->bc_input;
	_data_->_state_ = 1;
	g_output_stream_close_async ((GOutputStream*) _data_->_tmp60_, G_PRIORITY_DEFAULT, _data_->cancellable, synapse_calculator_plugin_backend_get_solution_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_close_finish ((GOutputStream*) _data_->_tmp60_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp62_ = _data_->bc_output;
	_data_->_state_ = 2;
	g_data_input_stream_read_line_async (_data_->_tmp62_, G_PRIORITY_DEFAULT_IDLE, _data_->cancellable, synapse_calculator_plugin_backend_get_solution_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp63_ = g_data_input_stream_read_line_finish (_data_->_tmp62_, _data_->_res_, NULL, &_data_->_inner_error0_);
	_data_->_tmp61_ = _data_->_tmp63_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp64_ = _data_->_tmp61_;
	_data_->_tmp61_ = NULL;
	_g_free0 (_data_->solution);
	_data_->solution = _data_->_tmp64_;
	_data_->_tmp66_ = _data_->solution;
	if (_data_->_tmp66_ == NULL) {
		_data_->_tmp65_ = TRUE;
	} else {
		_data_->_tmp67_ = _data_->solution;
		_data_->_tmp65_ = g_strcmp0 (_data_->_tmp67_, "") == 0;
	}
	if (_data_->_tmp65_) {
		_data_->_tmp68_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED, "No solution found");
		_data_->_inner_error0_ = _data_->_tmp68_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_tmp61_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = _data_->solution;
		_g_free0 (_data_->_tmp61_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->final_input);
		_data_->expressions = (_vala_array_free (_data_->expressions, _data_->expressions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->input);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
synapse_calculator_plugin_backend_allowed_expression (SynapseCalculatorPluginBackend* self,
                                                      const gchar* expr,
                                                      gboolean* is_base_expr)
{
	gboolean _vala_is_base_expr = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gchar* test_expr = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	_vala_is_base_expr = FALSE;
	_tmp0_ = strlen (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 6) {
		gint suffix_int = 0;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp2_ = strlen (expr);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_slice (expr, (glong) 6, (glong) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = atoi (_tmp5_);
		_g_free0 (_tmp5_);
		suffix_int = _tmp6_;
		if (g_str_has_prefix (expr, "ibase=")) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_str_has_prefix (expr, "obase=");
		}
		if (_tmp7_) {
			gboolean _tmp8_ = FALSE;
			gboolean valid = FALSE;
			gboolean _tmp9_ = FALSE;
			if (suffix_int > 1) {
				_tmp8_ = suffix_int <= 16;
			} else {
				_tmp8_ = FALSE;
			}
			valid = _tmp8_;
			if (valid) {
				_tmp9_ = g_str_has_prefix (expr, "ibase=");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp10_;
				_tmp10_ = string_slice (SYNAPSE_CALCULATOR_PLUGIN_BACKEND_VALID_NUM, (glong) 0, (glong) suffix_int);
				_g_free0 (self->priv->use_num);
				self->priv->use_num = _tmp10_;
			}
			_vala_is_base_expr = TRUE;
			result = valid;
			if (is_base_expr) {
				*is_base_expr = _vala_is_base_expr;
			}
			return result;
		}
		if (g_str_has_prefix (expr, "scale=")) {
			gboolean _tmp11_ = FALSE;
			_vala_is_base_expr = TRUE;
			if (suffix_int >= 0) {
				_tmp11_ = suffix_int < 50;
			} else {
				_tmp11_ = FALSE;
			}
			result = _tmp11_;
			if (is_base_expr) {
				*is_base_expr = _vala_is_base_expr;
			}
			return result;
		}
	}
	_tmp12_ = string_replace (expr, "sqrt(", "(");
	_tmp13_ = _tmp12_;
	_tmp14_ = string_replace (_tmp13_, "s(", "(");
	_tmp15_ = _tmp14_;
	_tmp16_ = string_replace (_tmp15_, "c(", "(");
	_tmp17_ = _tmp16_;
	_tmp18_ = string_replace (_tmp17_, "a(", "(");
	_tmp19_ = _tmp18_;
	_tmp20_ = string_replace (_tmp19_, "l(", "(");
	_tmp21_ = _tmp20_;
	_tmp22_ = string_replace (_tmp21_, "e(", "(");
	_tmp23_ = _tmp22_;
	_tmp24_ = string_replace (_tmp23_, "j(", "(");
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	test_expr = _tmp25_;
	_tmp26_ = test_expr;
	_tmp27_ = self->priv->use_num;
	_tmp28_ = g_strconcat (_tmp27_, SYNAPSE_CALCULATOR_PLUGIN_BACKEND_VALID_OP, NULL);
	_tmp29_ = _tmp28_;
	g_strcanon (_tmp26_, _tmp29_, '@');
	_g_free0 (_tmp29_);
	_tmp30_ = test_expr;
	result = !string_contains (_tmp30_, "@");
	_g_free0 (test_expr);
	if (is_base_expr) {
		*is_base_expr = _vala_is_base_expr;
	}
	return result;
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_construct (GType object_type)
{
	SynapseCalculatorPluginBackend * self = NULL;
	self = (SynapseCalculatorPluginBackend*) g_object_new (object_type, NULL);
	return self;
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_new (void)
{
	return synapse_calculator_plugin_backend_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN_BACKEND);
}

static void
synapse_calculator_plugin_backend_class_init (SynapseCalculatorPluginBackendClass * klass,
                                              gpointer klass_data)
{
	synapse_calculator_plugin_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPluginBackend_private_offset);
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_backend_finalize;
}

static void
synapse_calculator_plugin_backend_instance_init (SynapseCalculatorPluginBackend * self,
                                                 gpointer klass)
{
	self->priv = synapse_calculator_plugin_backend_get_instance_private (self);
}

static void
synapse_calculator_plugin_backend_finalize (GObject * obj)
{
	SynapseCalculatorPluginBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN_BACKEND, SynapseCalculatorPluginBackend);
	_g_free0 (self->priv->use_num);
	G_OBJECT_CLASS (synapse_calculator_plugin_backend_parent_class)->finalize (obj);
}

static GType
synapse_calculator_plugin_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginBackend), 0, (GInstanceInitFunc) synapse_calculator_plugin_backend_instance_init, NULL };
	GType synapse_calculator_plugin_backend_type_id;
	synapse_calculator_plugin_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPluginBackend", &g_define_type_info, 0);
	SynapseCalculatorPluginBackend_private_offset = g_type_add_instance_private (synapse_calculator_plugin_backend_type_id, sizeof (SynapseCalculatorPluginBackendPrivate));
	return synapse_calculator_plugin_backend_type_id;
}

GType
synapse_calculator_plugin_backend_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_backend_type_id__once = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_backend_type_id__once)) {
		GType synapse_calculator_plugin_backend_type_id;
		synapse_calculator_plugin_backend_type_id = synapse_calculator_plugin_backend_get_type_once ();
		g_once_init_leave (&synapse_calculator_plugin_backend_type_id__once, synapse_calculator_plugin_backend_type_id);
	}
	return synapse_calculator_plugin_backend_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

