/* TemplateManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TemplateManager.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Lucas Baudin <xapantu@gmail.com>
 *               2013      Mario Guerriero <mario@elementaryos.org>
 *
 * This file is part of Code.
 *
 * Code is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Code is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "codecore.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_TEMPLATE_0_PROPERTY,
	SCRATCH_TEMPLATE_NUM_PROPERTIES
};
static GParamSpec* scratch_template_properties[SCRATCH_TEMPLATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	SCRATCH_TEMPLATE_LOADED_SIGNAL,
	SCRATCH_TEMPLATE_NUM_SIGNALS
};
static guint scratch_template_signals[SCRATCH_TEMPLATE_NUM_SIGNALS] = {0};
enum  {
	SCRATCH_TEST_TEMPLATE_0_PROPERTY,
	SCRATCH_TEST_TEMPLATE_NUM_PROPERTIES
};
static GParamSpec* scratch_test_template_properties[SCRATCH_TEST_TEMPLATE_NUM_PROPERTIES];
enum  {
	TEMPLATE_BUTTON_0_PROPERTY,
	TEMPLATE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* template_button_properties[TEMPLATE_BUTTON_NUM_PROPERTIES];
enum  {
	SCRATCH_TEMPLATE_MANAGER_0_PROPERTY,
	SCRATCH_TEMPLATE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* scratch_template_manager_properties[SCRATCH_TEMPLATE_MANAGER_NUM_PROPERTIES];
typedef struct _Block40Data Block40Data;
enum  {
	SCRATCH_TEMPLATE_MANAGER_TEMPLATE_LOADED_SIGNAL,
	SCRATCH_TEMPLATE_MANAGER_NUM_SIGNALS
};
static guint scratch_template_manager_signals[SCRATCH_TEMPLATE_MANAGER_NUM_SIGNALS] = {0};

struct _TemplateButtonPrivate {
	GtkImage* icon_image;
};

struct _ScratchTemplateManagerPrivate {
	GraniteDialog* dialog;
	ScratchTemplate* current_template;
	GtkWidget* parent;
	GtkGrid* grid;
	gint n_columns;
	gint left;
	gint top;
	gint width;
	gint height;
};

struct _Block40Data {
	int _ref_count_;
	ScratchTemplateManager* self;
	gchar* label;
	GType template_type;
};

static gpointer scratch_template_parent_class = NULL;
static gpointer scratch_test_template_parent_class = NULL;
static gint TemplateButton_private_offset;
static gpointer template_button_parent_class = NULL;
static gint ScratchTemplateManager_private_offset;
static gpointer scratch_template_manager_parent_class = NULL;

static GtkWidget* scratch_template_real_get_creation_box (ScratchTemplate* self);
static void scratch_template_configure_directory (GFile* origin,
                                           GFile* destination,
                                           GeeHashMap* variables);
static GType scratch_template_get_type_once (void);
static GtkWidget* scratch_test_template_real_get_creation_box (ScratchTemplate* base);
static GType scratch_test_template_get_type_once (void);
static void template_button_finalize (GObject * obj);
static GType template_button_get_type_once (void);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void scratch_template_manager_append_button (ScratchTemplateManager* self,
                                             GtkWidget* button);
static void __lambda17_ (Block40Data* _data40_);
static void __lambda18_ (ScratchTemplateManager* self,
                  GFile* file);
static void ___lambda18__scratch_template_loaded (ScratchTemplate* _sender,
                                           GFile* file,
                                           gpointer self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void scratch_template_manager_finalize (GObject * obj);
static GType scratch_template_manager_get_type_once (void);

static GtkWidget*
scratch_template_real_get_creation_box (ScratchTemplate* self)
{
	g_critical ("Type `%s' does not implement abstract method `scratch_template_get_creation_box'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkWidget*
scratch_template_get_creation_box (ScratchTemplate* self)
{
	ScratchTemplateClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SCRATCH_TEMPLATE_GET_CLASS (self);
	if (_klass_->get_creation_box) {
		return _klass_->get_creation_box (self);
	}
	return NULL;
}

void
scratch_template_configure_template (const gchar* origin,
                                     const gchar* destination,
                                     GeeHashMap* variables)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (origin != NULL);
	g_return_if_fail (destination != NULL);
	g_return_if_fail (variables != NULL);
	g_debug ("TemplateManager.vala:26: Origin: %s, destination: %s\n", origin, destination);
	_tmp0_ = g_file_new_for_path (origin);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (destination);
	_tmp3_ = _tmp2_;
	scratch_template_configure_directory (_tmp1_, _tmp3_, variables);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
scratch_template_configure_directory (GFile* origin,
                                      GFile* destination,
                                      GeeHashMap* variables)
{
	gboolean is_directory = FALSE;
	gboolean exists = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GeeTreeSet* files = NULL;
	GeeTreeSet* _tmp8_;
	GeeTreeSet* dirs = NULL;
	GeeTreeSet* _tmp9_;
	GeeTreeSet* _tmp10_;
	GeeTreeSet* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (origin != NULL);
	g_return_if_fail (destination != NULL);
	g_return_if_fail (variables != NULL);
	scratch_template_info_directory (origin, &_tmp0_, &_tmp1_);
	is_directory = _tmp0_;
	exists = _tmp1_;
	if (!is_directory) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !exists;
	}
	if (_tmp2_) {
		g_warning ("TemplateManager.vala:36: Origin directory doesn't exist or isn't a dir" \
"ectory.");
		return;
	}
	scratch_template_info_directory (destination, &_tmp3_, &_tmp4_);
	is_directory = _tmp3_;
	exists = _tmp4_;
	if (is_directory) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = exists;
	}
	if (_tmp5_) {
		g_warning ("TemplateManager.vala:42: Destination directory already exists…");
		return;
	}
	{
		g_file_make_directory (destination, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("TemplateManager.vala:49: %s", _tmp7_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = gee_tree_set_new (g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	files = _tmp8_;
	_tmp9_ = gee_tree_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dirs = _tmp9_;
	_tmp10_ = files;
	_tmp11_ = dirs;
	scratch_template_enumerate_directory (origin, _tmp10_, _tmp11_);
	{
		GeeIterator* _file_it = NULL;
		GeeTreeSet* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp12_ = files;
		_tmp13_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp12_);
		_file_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			GFileInfo* file = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			gchar* content_type = NULL;
			GFileInfo* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			const gchar* _tmp21_;
			_tmp14_ = _file_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _file_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			file = (GFileInfo*) _tmp16_;
			_tmp17_ = file;
			_tmp18_ = g_file_info_get_content_type (_tmp17_);
			_tmp19_ = g_strdup (_tmp18_);
			content_type = _tmp19_;
			_tmp21_ = content_type;
			if (string_contains (_tmp21_, "text")) {
				_tmp20_ = TRUE;
			} else {
				const gchar* _tmp22_;
				_tmp22_ = content_type;
				_tmp20_ = string_contains (_tmp22_, "x-desktop");
			}
			if (_tmp20_) {
				GFile* gfile = NULL;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GFileInfo* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GFile* _tmp29_;
				GFile* _tmp30_;
				gchar* content = NULL;
				GFile* _tmp31_;
				gchar* _tmp32_;
				_tmp23_ = g_file_get_path (origin);
				_tmp24_ = _tmp23_;
				_tmp25_ = file;
				_tmp26_ = g_file_info_get_name (_tmp25_);
				_tmp27_ = g_build_filename (_tmp24_, _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_file_new_for_path (_tmp28_);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp24_);
				gfile = _tmp30_;
				_tmp31_ = gfile;
				_tmp32_ = scratch_services_file_handler_load_content_from_file_sync (_tmp31_);
				content = _tmp32_;
				if (variables != NULL) {
					{
						GeeIterator* _entry_it = NULL;
						GeeSet* _tmp33_;
						GeeSet* _tmp34_;
						GeeSet* _tmp35_;
						GeeIterator* _tmp36_;
						GeeIterator* _tmp37_;
						_tmp33_ = gee_abstract_map_get_entries ((GeeAbstractMap*) variables);
						_tmp34_ = _tmp33_;
						_tmp35_ = _tmp34_;
						_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
						_tmp37_ = _tmp36_;
						_g_object_unref0 (_tmp35_);
						_entry_it = _tmp37_;
						while (TRUE) {
							GeeIterator* _tmp38_;
							GeeMapEntry* entry = NULL;
							GeeIterator* _tmp39_;
							gpointer _tmp40_;
							const gchar* _tmp41_;
							GeeMapEntry* _tmp42_;
							gconstpointer _tmp43_;
							gconstpointer _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							GeeMapEntry* _tmp47_;
							gconstpointer _tmp48_;
							gconstpointer _tmp49_;
							gchar* _tmp50_;
							_tmp38_ = _entry_it;
							if (!gee_iterator_next (_tmp38_)) {
								break;
							}
							_tmp39_ = _entry_it;
							_tmp40_ = gee_iterator_get (_tmp39_);
							entry = (GeeMapEntry*) _tmp40_;
							_tmp41_ = content;
							_tmp42_ = entry;
							_tmp43_ = gee_map_entry_get_key (_tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = g_strconcat ("$$", (const gchar*) _tmp44_, NULL);
							_tmp46_ = _tmp45_;
							_tmp47_ = entry;
							_tmp48_ = gee_map_entry_get_value (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = string_replace (_tmp41_, _tmp46_, (const gchar*) _tmp49_);
							_g_free0 (content);
							content = _tmp50_;
							_g_free0 (_tmp46_);
							_g_object_unref0 (entry);
						}
						_g_object_unref0 (_entry_it);
					}
				}
				{
					gchar* dest_path = NULL;
					gchar* _tmp51_;
					gchar* _tmp52_;
					GFileInfo* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					const gchar* _tmp75_;
					const gchar* _tmp76_;
					_tmp51_ = g_file_get_path (destination);
					_tmp52_ = _tmp51_;
					_tmp53_ = file;
					_tmp54_ = g_file_info_get_name (_tmp53_);
					_tmp55_ = g_build_filename (_tmp52_, _tmp54_, NULL);
					_tmp56_ = _tmp55_;
					_g_free0 (_tmp52_);
					dest_path = _tmp56_;
					{
						GeeIterator* _entry_it = NULL;
						GeeSet* _tmp57_;
						GeeSet* _tmp58_;
						GeeSet* _tmp59_;
						GeeIterator* _tmp60_;
						GeeIterator* _tmp61_;
						_tmp57_ = gee_abstract_map_get_entries ((GeeAbstractMap*) variables);
						_tmp58_ = _tmp57_;
						_tmp59_ = _tmp58_;
						_tmp60_ = gee_iterable_iterator ((GeeIterable*) _tmp59_);
						_tmp61_ = _tmp60_;
						_g_object_unref0 (_tmp59_);
						_entry_it = _tmp61_;
						while (TRUE) {
							GeeIterator* _tmp62_;
							GeeMapEntry* entry = NULL;
							GeeIterator* _tmp63_;
							gpointer _tmp64_;
							const gchar* _tmp65_;
							GeeMapEntry* _tmp66_;
							gconstpointer _tmp67_;
							gconstpointer _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							GeeMapEntry* _tmp71_;
							gconstpointer _tmp72_;
							gconstpointer _tmp73_;
							gchar* _tmp74_;
							_tmp62_ = _entry_it;
							if (!gee_iterator_next (_tmp62_)) {
								break;
							}
							_tmp63_ = _entry_it;
							_tmp64_ = gee_iterator_get (_tmp63_);
							entry = (GeeMapEntry*) _tmp64_;
							_tmp65_ = dest_path;
							_tmp66_ = entry;
							_tmp67_ = gee_map_entry_get_key (_tmp66_);
							_tmp68_ = _tmp67_;
							_tmp69_ = g_strconcat ("$$", (const gchar*) _tmp68_, NULL);
							_tmp70_ = _tmp69_;
							_tmp71_ = entry;
							_tmp72_ = gee_map_entry_get_value (_tmp71_);
							_tmp73_ = _tmp72_;
							_tmp74_ = string_replace (_tmp65_, _tmp70_, (const gchar*) _tmp73_);
							_g_free0 (dest_path);
							dest_path = _tmp74_;
							_g_free0 (_tmp70_);
							_g_object_unref0 (entry);
						}
						_g_object_unref0 (_entry_it);
					}
					_tmp75_ = dest_path;
					_tmp76_ = content;
					g_file_set_contents (_tmp75_, _tmp76_, (gssize) -1, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (dest_path);
						goto __catch1_g_error;
					}
					_g_free0 (dest_path);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp77_;
					const gchar* _tmp78_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp77_ = e;
					_tmp78_ = _tmp77_->message;
					g_warning ("TemplateManager.vala:75: %s", _tmp78_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (content);
					_g_object_unref0 (gfile);
					_g_free0 (content_type);
					_g_object_unref0 (file);
					_g_object_unref0 (_file_it);
					_g_object_unref0 (dirs);
					_g_object_unref0 (files);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (content);
				_g_object_unref0 (gfile);
			} else {
				{
					GFile* orig = NULL;
					gchar* _tmp79_;
					gchar* _tmp80_;
					GFileInfo* _tmp81_;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					GFile* _tmp85_;
					GFile* _tmp86_;
					GFile* dest = NULL;
					gchar* _tmp87_;
					gchar* _tmp88_;
					GFileInfo* _tmp89_;
					const gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					GFile* _tmp93_;
					GFile* _tmp94_;
					GFile* _tmp95_;
					GFile* _tmp96_;
					_tmp79_ = g_file_get_path (origin);
					_tmp80_ = _tmp79_;
					_tmp81_ = file;
					_tmp82_ = g_file_info_get_name (_tmp81_);
					_tmp83_ = g_build_filename (_tmp80_, _tmp82_, NULL);
					_tmp84_ = _tmp83_;
					_tmp85_ = g_file_new_for_path (_tmp84_);
					_tmp86_ = _tmp85_;
					_g_free0 (_tmp84_);
					_g_free0 (_tmp80_);
					orig = _tmp86_;
					_tmp87_ = g_file_get_path (destination);
					_tmp88_ = _tmp87_;
					_tmp89_ = file;
					_tmp90_ = g_file_info_get_name (_tmp89_);
					_tmp91_ = g_build_filename (_tmp88_, _tmp90_, NULL);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_file_new_for_path (_tmp92_);
					_tmp94_ = _tmp93_;
					_g_free0 (_tmp92_);
					_g_free0 (_tmp88_);
					dest = _tmp94_;
					_tmp95_ = orig;
					_tmp96_ = dest;
					g_file_copy (_tmp95_, _tmp96_, 0, NULL, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (dest);
						_g_object_unref0 (orig);
						goto __catch2_g_error;
					}
					_g_object_unref0 (dest);
					_g_object_unref0 (orig);
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					GError* _tmp97_;
					const gchar* _tmp98_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp97_ = e;
					_tmp98_ = _tmp97_->message;
					g_critical ("TemplateManager.vala:83: %s", _tmp98_);
					_g_error_free0 (e);
					_g_free0 (content_type);
					_g_object_unref0 (file);
					_g_object_unref0 (_file_it);
					_g_object_unref0 (dirs);
					_g_object_unref0 (files);
					return;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (content_type);
					_g_object_unref0 (file);
					_g_object_unref0 (_file_it);
					_g_object_unref0 (dirs);
					_g_object_unref0 (files);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_free0 (content_type);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	{
		GeeIterator* _dir_it = NULL;
		GeeTreeSet* _tmp99_;
		GeeIterator* _tmp100_;
		_tmp99_ = dirs;
		_tmp100_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp99_);
		_dir_it = _tmp100_;
		while (TRUE) {
			GeeIterator* _tmp101_;
			GFile* dir = NULL;
			GeeIterator* _tmp102_;
			gpointer _tmp103_;
			GFile* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			GFile* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			GFile* _tmp114_;
			GFile* _tmp115_;
			_tmp101_ = _dir_it;
			if (!gee_iterator_next (_tmp101_)) {
				break;
			}
			_tmp102_ = _dir_it;
			_tmp103_ = gee_iterator_get (_tmp102_);
			dir = (GFile*) _tmp103_;
			_tmp104_ = dir;
			_tmp105_ = g_file_get_path (destination);
			_tmp106_ = _tmp105_;
			_tmp107_ = g_strconcat (_tmp106_, "/", NULL);
			_tmp108_ = _tmp107_;
			_tmp109_ = dir;
			_tmp110_ = g_file_get_basename (_tmp109_);
			_tmp111_ = _tmp110_;
			_tmp112_ = g_strconcat (_tmp108_, _tmp111_, NULL);
			_tmp113_ = _tmp112_;
			_tmp114_ = g_file_new_for_path (_tmp113_);
			_tmp115_ = _tmp114_;
			scratch_template_configure_directory (_tmp104_, _tmp115_, variables);
			_g_object_unref0 (_tmp115_);
			_g_free0 (_tmp113_);
			_g_free0 (_tmp111_);
			_g_free0 (_tmp108_);
			_g_free0 (_tmp106_);
			_g_object_unref0 (dir);
		}
		_g_object_unref0 (_dir_it);
	}
	_g_object_unref0 (dirs);
	_g_object_unref0 (files);
}

void
scratch_template_enumerate_directory (GFile* origin,
                                      GeeTreeSet* files,
                                      GeeTreeSet* directories)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (origin != NULL);
	g_return_if_fail (files != NULL);
	g_return_if_fail (directories != NULL);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (origin, "standard::type,standard::name,standard::content-type", 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GFileInfo* file_info = NULL;
			GFileEnumerator* _tmp1_;
			GFileInfo* _tmp2_;
			_tmp1_ = enumerator;
			_tmp2_ = g_file_enumerator_next_file (_tmp1_, NULL, &_inner_error0_);
			file_info = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GFileInfo* _tmp8_;
					GFileInfo* _tmp9_;
					if (!_tmp3_) {
						GFileInfo* _tmp4_ = NULL;
						GFileEnumerator* _tmp5_;
						GFileInfo* _tmp6_;
						GFileInfo* _tmp7_;
						_tmp5_ = enumerator;
						_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
						_tmp4_ = _tmp6_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (file_info);
							_g_object_unref0 (enumerator);
							goto __catch0_g_error;
						}
						_tmp7_ = _tmp4_;
						_tmp4_ = NULL;
						_g_object_unref0 (file_info);
						file_info = _tmp7_;
						_g_object_unref0 (_tmp4_);
					}
					_tmp3_ = FALSE;
					_tmp8_ = file_info;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp9_ = file_info;
					switch (g_file_info_get_file_type (_tmp9_)) {
						case G_FILE_TYPE_DIRECTORY:
						{
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							GFileInfo* _tmp14_;
							const gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							GFile* _tmp18_;
							GFile* _tmp19_;
							_tmp10_ = g_file_get_path (origin);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_strconcat (_tmp11_, "/", NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = file_info;
							_tmp15_ = g_file_info_get_name (_tmp14_);
							_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
							_tmp17_ = _tmp16_;
							_tmp18_ = g_file_new_for_path (_tmp17_);
							_tmp19_ = _tmp18_;
							gee_abstract_collection_add ((GeeAbstractCollection*) directories, _tmp19_);
							_g_object_unref0 (_tmp19_);
							_g_free0 (_tmp17_);
							_g_free0 (_tmp13_);
							_g_free0 (_tmp11_);
							continue;
						}
						case G_FILE_TYPE_REGULAR:
						{
							GFileInfo* _tmp20_;
							_tmp20_ = file_info;
							gee_abstract_collection_add ((GeeAbstractCollection*) files, _tmp20_);
							continue;
						}
						case G_FILE_TYPE_SHORTCUT:
						case G_FILE_TYPE_SYMBOLIC_LINK:
						case G_FILE_TYPE_MOUNTABLE:
						case G_FILE_TYPE_SPECIAL:
						case G_FILE_TYPE_UNKNOWN:
						{
							continue;
						}
						default:
						break;
					}
				}
			}
			_g_object_unref0 (file_info);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_critical ("TemplateManager.vala:114: %s", _tmp22_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
scratch_template_info_directory (GFile* file,
                                 gboolean* is_directory,
                                 gboolean* exists)
{
	gboolean _vala_is_directory = FALSE;
	gboolean _vala_exists = FALSE;
	GFileType file_type = 0;
	g_return_if_fail (file != NULL);
	file_type = g_file_query_file_type (file, 0, NULL);
	_vala_exists = file_type != G_FILE_TYPE_UNKNOWN;
	_vala_is_directory = file_type == G_FILE_TYPE_DIRECTORY;
	if (is_directory) {
		*is_directory = _vala_is_directory;
	}
	if (exists) {
		*exists = _vala_exists;
	}
}

ScratchTemplate*
scratch_template_construct (GType object_type)
{
	ScratchTemplate * self = NULL;
	self = (ScratchTemplate*) g_object_new (object_type, NULL);
	return self;
}

static void
scratch_template_class_init (ScratchTemplateClass * klass,
                             gpointer klass_data)
{
	scratch_template_parent_class = g_type_class_peek_parent (klass);
	((ScratchTemplateClass *) klass)->get_creation_box = (GtkWidget* (*) (ScratchTemplate*)) scratch_template_real_get_creation_box;
	scratch_template_signals[SCRATCH_TEMPLATE_LOADED_SIGNAL] = g_signal_new ("loaded", SCRATCH_TYPE_TEMPLATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
}

static void
scratch_template_instance_init (ScratchTemplate * self,
                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
scratch_template_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchTemplateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_template_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchTemplate), 0, (GInstanceInitFunc) scratch_template_instance_init, NULL };
	GType scratch_template_type_id;
	scratch_template_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchTemplate", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return scratch_template_type_id;
}

GType
scratch_template_get_type (void)
{
	static gsize scratch_template_type_id__once = 0;
	if (g_once_init_enter (&scratch_template_type_id__once)) {
		GType scratch_template_type_id;
		scratch_template_type_id = scratch_template_get_type_once ();
		g_once_init_leave (&scratch_template_type_id__once, scratch_template_type_id);
	}
	return scratch_template_type_id__once;
}

static GtkWidget*
scratch_test_template_real_get_creation_box (ScratchTemplate* base)
{
	ScratchTestTemplate * self;
	GtkLabel* _tmp0_;
	GtkWidget* result;
	self = (ScratchTestTemplate*) base;
	_tmp0_ = (GtkLabel*) gtk_label_new ("Test");
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

ScratchTestTemplate*
scratch_test_template_construct (GType object_type)
{
	ScratchTestTemplate * self = NULL;
	self = (ScratchTestTemplate*) scratch_template_construct (object_type);
	return self;
}

ScratchTestTemplate*
scratch_test_template_new (void)
{
	return scratch_test_template_construct (SCRATCH_TYPE_TEST_TEMPLATE);
}

static void
scratch_test_template_class_init (ScratchTestTemplateClass * klass,
                                  gpointer klass_data)
{
	scratch_test_template_parent_class = g_type_class_peek_parent (klass);
	((ScratchTemplateClass *) klass)->get_creation_box = (GtkWidget* (*) (ScratchTemplate*)) scratch_test_template_real_get_creation_box;
}

static void
scratch_test_template_instance_init (ScratchTestTemplate * self,
                                     gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
scratch_test_template_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchTestTemplateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_test_template_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchTestTemplate), 0, (GInstanceInitFunc) scratch_test_template_instance_init, NULL };
	GType scratch_test_template_type_id;
	scratch_test_template_type_id = g_type_register_static (SCRATCH_TYPE_TEMPLATE, "ScratchTestTemplate", &g_define_type_info, 0);
	return scratch_test_template_type_id;
}

GType
scratch_test_template_get_type (void)
{
	static gsize scratch_test_template_type_id__once = 0;
	if (g_once_init_enter (&scratch_test_template_type_id__once)) {
		GType scratch_test_template_type_id;
		scratch_test_template_type_id = scratch_test_template_get_type_once ();
		g_once_init_leave (&scratch_test_template_type_id__once, scratch_test_template_type_id);
	}
	return scratch_test_template_type_id__once;
}

static inline gpointer
template_button_get_instance_private (TemplateButton* self)
{
	return G_STRUCT_MEMBER_P (self, TemplateButton_private_offset);
}

TemplateButton*
template_button_construct (GType object_type,
                           const gchar* title,
                           const gchar* description,
                           const gchar* icon)
{
	TemplateButton * self = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp0_;
	GtkBox* text_box = NULL;
	GtkBox* _tmp1_;
	GtkLabel* title_label = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* description_label = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkImage* _tmp16_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (TemplateButton*) g_object_new (object_type, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp0_);
	main_box = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp1_);
	text_box = _tmp1_;
	gtk_widget_set_halign ((GtkWidget*) text_box, GTK_ALIGN_START);
	_tmp2_ = g_markup_printf_escaped ("<span weight='medium' size='11700'>%s</span>", title);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	title_label = _tmp5_;
	gtk_label_set_use_markup (title_label, TRUE);
	gtk_label_set_ellipsize (title_label, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) title_label, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) title_label, GTK_ALIGN_START);
	_tmp6_ = g_markup_printf_escaped ("<span weight='medium' size='11400'>%s</span>", description);
	_tmp7_ = _tmp6_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	description_label = _tmp9_;
	gtk_label_set_use_markup (description_label, TRUE);
	gtk_label_set_ellipsize (description_label, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) description_label, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) description_label, GTK_ALIGN_START);
	gtk_widget_set_sensitive ((GtkWidget*) description_label, FALSE);
	_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name (icon, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->icon_image);
	self->priv->icon_image = _tmp10_;
	_tmp11_ = self->priv->icon_image;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	gtk_box_pack_start (text_box, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (_tmp13_);
	gtk_box_pack_start (text_box, (GtkWidget*) title_label, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (text_box, (GtkWidget*) description_label, FALSE, FALSE, (guint) 0);
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	gtk_box_pack_start (text_box, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->icon_image;
	gtk_box_pack_start (main_box, (GtkWidget*) _tmp16_, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (main_box, (GtkWidget*) text_box, FALSE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (description_label);
	_g_object_unref0 (title_label);
	_g_object_unref0 (text_box);
	_g_object_unref0 (main_box);
	return self;
}

TemplateButton*
template_button_new (const gchar* title,
                     const gchar* description,
                     const gchar* icon)
{
	return template_button_construct (TYPE_TEMPLATE_BUTTON, title, description, icon);
}

void
template_button_set_icon_from_pixbuf (TemplateButton* self,
                                      GdkPixbuf* pixbuf)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->icon_image;
	gtk_image_set_from_pixbuf (_tmp0_, pixbuf);
}

static void
template_button_class_init (TemplateButtonClass * klass,
                            gpointer klass_data)
{
	template_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TemplateButton_private_offset);
	G_OBJECT_CLASS (klass)->finalize = template_button_finalize;
}

static void
template_button_instance_init (TemplateButton * self,
                               gpointer klass)
{
	self->priv = template_button_get_instance_private (self);
}

static void
template_button_finalize (GObject * obj)
{
	TemplateButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEMPLATE_BUTTON, TemplateButton);
	_g_object_unref0 (self->priv->icon_image);
	G_OBJECT_CLASS (template_button_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
template_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TemplateButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) template_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TemplateButton), 0, (GInstanceInitFunc) template_button_instance_init, NULL };
	GType template_button_type_id;
	template_button_type_id = g_type_register_static (gtk_button_get_type (), "TemplateButton", &g_define_type_info, 0);
	TemplateButton_private_offset = g_type_add_instance_private (template_button_type_id, sizeof (TemplateButtonPrivate));
	return template_button_type_id;
}

GType
template_button_get_type (void)
{
	static gsize template_button_type_id__once = 0;
	if (g_once_init_enter (&template_button_type_id__once)) {
		GType template_button_type_id;
		template_button_type_id = template_button_get_type_once ();
		g_once_init_leave (&template_button_type_id__once, template_button_type_id);
	}
	return template_button_type_id__once;
}

static inline gpointer
scratch_template_manager_get_instance_private (ScratchTemplateManager* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchTemplateManager_private_offset);
}

ScratchTemplateManager*
scratch_template_manager_construct (GType object_type)
{
	ScratchTemplateManager * self = NULL;
	GraniteDialog* _tmp0_;
	GraniteDialog* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp8_;
	GtkGrid* _tmp9_;
	GraniteDialog* _tmp10_;
	GtkBox* _tmp11_;
	self = (ScratchTemplateManager*) g_object_new (object_type, NULL);
	_tmp0_ = granite_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp0_;
	_tmp1_ = self->priv->dialog;
	gtk_window_set_title ((GtkWindow*) _tmp1_, _ ("Templates"));
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp2_;
	_tmp3_ = self->priv->grid;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 5, NULL);
	_tmp4_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp4_, 5);
	_tmp5_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp5_, 5);
	_tmp6_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp6_, TRUE);
	_tmp7_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp7_, TRUE);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp8_);
	scroll = _tmp8_;
	g_object_set ((GtkWidget*) scroll, "height-request", 250, NULL);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp9_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->dialog;
	_tmp11_ = gtk_dialog_get_content_area ((GtkDialog*) _tmp10_);
	gtk_box_pack_start (_tmp11_, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (scroll);
	return self;
}

ScratchTemplateManager*
scratch_template_manager_new (void)
{
	return scratch_template_manager_construct (SCRATCH_TYPE_TEMPLATE_MANAGER);
}

/**
     * Register a new template
     * 
     * @param icon_id the icon id used in the IconView which shows all the template.
     * It will be used to launch an icon via Gtk.IconTheme.load_icon, so, any icon is
     * fine.
     * @param label The name of your template.
     * @param template_type The object type which must be instantiated when we click on
     * the icon on the IconView. It will be used to get the creation box and therefore must
     * inherit from #Scratch.Template.
     **/
static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		ScratchTemplateManager* self;
		self = _data40_->self;
		_g_free0 (_data40_->label);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static void
__lambda18_ (ScratchTemplateManager* self,
             GFile* file)
{
	ScratchTemplate* _tmp0_;
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->current_template;
	g_signal_emit (self, scratch_template_manager_signals[SCRATCH_TEMPLATE_MANAGER_TEMPLATE_LOADED_SIGNAL], 0, _tmp0_, file);
}

static void
___lambda18__scratch_template_loaded (ScratchTemplate* _sender,
                                      GFile* file,
                                      gpointer self)
{
	__lambda18_ ((ScratchTemplateManager*) self, file);
}

static void
__lambda17_ (Block40Data* _data40_)
{
	ScratchTemplateManager* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GraniteDialog* _tmp2_;
	GraniteDialog* window = NULL;
	GraniteDialog* _tmp3_;
	GraniteDialog* _tmp4_;
	GtkWidget* _tmp5_;
	GraniteDialog* _tmp8_;
	ScratchTemplate* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GraniteDialog* _tmp12_;
	ScratchTemplate* _tmp13_;
	self = _data40_->self;
	_tmp0_ = g_object_new (_data40_->template_type, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_g_object_unref0 (self->priv->current_template);
	self->priv->current_template = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_TYPE_TEMPLATE, ScratchTemplate);
	_tmp2_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = granite_dialog_new ();
	g_object_ref_sink (_tmp3_);
	window = _tmp3_;
	_tmp4_ = window;
	gtk_window_set_title ((GtkWindow*) _tmp4_, _data40_->label);
	_tmp5_ = self->priv->parent;
	if (_tmp5_ != NULL) {
		GraniteDialog* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp6_ = window;
		_tmp7_ = self->priv->parent;
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
	}
	_tmp8_ = window;
	_tmp9_ = self->priv->current_template;
	_tmp10_ = scratch_template_get_creation_box (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_container_add ((GtkContainer*) _tmp8_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = window;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->current_template;
	g_signal_connect_object (_tmp13_, "loaded", (GCallback) ___lambda18__scratch_template_loaded, self, 0);
	_g_object_unref0 (window);
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda17_ (self);
}

void
scratch_template_manager_register_template (ScratchTemplateManager* self,
                                            const gchar* icon_id,
                                            const gchar* label,
                                            const gchar* description,
                                            GType template_type)
{
	Block40Data* _data40_;
	gchar* _tmp0_;
	TemplateButton* button = NULL;
	TemplateButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (description != NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = g_strdup (label);
	_g_free0 (_data40_->label);
	_data40_->label = _tmp0_;
	_data40_->template_type = template_type;
	_tmp1_ = template_button_new (_data40_->label, description, icon_id);
	g_object_ref_sink (_tmp1_);
	button = _tmp1_;
	scratch_template_manager_append_button (self, (GtkWidget*) button);
	g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) ___lambda17__gtk_button_clicked, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	self->template_available = TRUE;
	_g_object_unref0 (button);
	block40_data_unref (_data40_);
	_data40_ = NULL;
}

static void
scratch_template_manager_append_button (ScratchTemplateManager* self,
                                        GtkWidget* button)
{
	GtkGrid* _tmp0_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (self->priv->left > self->priv->n_columns) {
		self->priv->left = 0;
	}
	_tmp0_ = self->priv->grid;
	gtk_grid_attach (_tmp0_, button, self->priv->left, self->priv->top, self->priv->width, self->priv->height);
	gtk_widget_show (button);
	if (self->priv->left == self->priv->n_columns) {
		gint _tmp1_;
		_tmp1_ = self->priv->top;
		self->priv->top = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->left;
	self->priv->left = _tmp2_ + 1;
}

/**
     * Show a dialog which contains an #Gtk.IconView with all templates available.
     * 
     * @param parent The parent window, or null.
     **/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
scratch_template_manager_show_window (ScratchTemplateManager* self,
                                      GtkWidget* parent)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp0_;
	if (self->template_available) {
		GraniteDialog* _tmp2_;
		if (parent != NULL) {
			GraniteDialog* _tmp1_;
			_tmp1_ = self->priv->dialog;
			gtk_window_set_transient_for ((GtkWindow*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (parent, gtk_window_get_type (), GtkWindow));
		}
		_tmp2_ = self->priv->dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp2_);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
scratch_template_manager_class_init (ScratchTemplateManagerClass * klass,
                                     gpointer klass_data)
{
	scratch_template_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchTemplateManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = scratch_template_manager_finalize;
	scratch_template_manager_signals[SCRATCH_TEMPLATE_MANAGER_TEMPLATE_LOADED_SIGNAL] = g_signal_new ("template-loaded", SCRATCH_TYPE_TEMPLATE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SCRATCH_TYPE_TEMPLATE, g_file_get_type ());
}

static void
scratch_template_manager_instance_init (ScratchTemplateManager * self,
                                        gpointer klass)
{
	self->priv = scratch_template_manager_get_instance_private (self);
	self->priv->parent = NULL;
	self->priv->n_columns = 0;
	self->priv->left = 0;
	self->priv->top = 0;
	self->priv->width = 1;
	self->priv->height = 1;
	self->template_available = FALSE;
}

static void
scratch_template_manager_finalize (GObject * obj)
{
	ScratchTemplateManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_TEMPLATE_MANAGER, ScratchTemplateManager);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->current_template);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (scratch_template_manager_parent_class)->finalize (obj);
}

/**
 * Global Template Manager for Scratch. Only one instance of this object should
 * be used at once. It is created by the main Granite.Application (ScratchApp) and
 * a reference can be got from the plugin manager.
 **/
 G_GNUC_NO_INLINE static GType
scratch_template_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchTemplateManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_template_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchTemplateManager), 0, (GInstanceInitFunc) scratch_template_manager_instance_init, NULL };
	GType scratch_template_manager_type_id;
	scratch_template_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchTemplateManager", &g_define_type_info, 0);
	ScratchTemplateManager_private_offset = g_type_add_instance_private (scratch_template_manager_type_id, sizeof (ScratchTemplateManagerPrivate));
	return scratch_template_manager_type_id;
}

GType
scratch_template_manager_get_type (void)
{
	static gsize scratch_template_manager_type_id__once = 0;
	if (g_once_init_enter (&scratch_template_manager_type_id__once)) {
		GType scratch_template_manager_type_id;
		scratch_template_manager_type_id = scratch_template_manager_get_type_once ();
		g_once_init_leave (&scratch_template_manager_type_id__once, scratch_template_manager_type_id);
	}
	return scratch_template_manager_type_id__once;
}

