/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtOpenGL.h"

#line 30 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtOpenGL/qpyopengl_qlist.sip"
#include <qlist.h>
#include <qopengl.h>
#line 30 "/build/pyqt6/src/pyqt6-6.10.2/build/QtOpenGL/sipQtOpenGLQList3900.cpp"



extern "C" {static void assign_QList_3900(void *, Py_ssize_t, void *);}
static void assign_QList_3900(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QList< ::GLuint64> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QList< ::GLuint64> *>(sipSrc);
}


extern "C" {static void *array_QList_3900(Py_ssize_t);}
static void *array_QList_3900(Py_ssize_t sipNrElem)
{
    return new ::QList< ::GLuint64>[sipNrElem];
}


extern "C" {static void *copy_QList_3900(const void *, Py_ssize_t);}
static void *copy_QList_3900(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QList< ::GLuint64>(reinterpret_cast<const ::QList< ::GLuint64> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_3900(void *, int, void *);}
static void release_QList_3900(void *sipCppV, int, void *)
{
    ::QList< ::GLuint64> *sipCpp = reinterpret_cast< ::QList< ::GLuint64> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_3900(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_3900(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    ::QList< ::GLuint64> **sipCppPtr = reinterpret_cast< ::QList< ::GLuint64> **>(sipCppPtrV);

#line 60 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtOpenGL/qpyopengl_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<GLuint64> *qv = new QList<GLuint64>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        unsigned long long val = PyLong_AsUnsignedLongLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        qv->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 136 "/build/pyqt6/src/pyqt6-6.10.2/build/QtOpenGL/sipQtOpenGLQList3900.cpp"
}


extern "C" {static PyObject *convertFrom_QList_3900(void *, PyObject *);}
static PyObject *convertFrom_QList_3900(void *sipCppV, PyObject *)
{
    ::QList< ::GLuint64> *sipCpp = reinterpret_cast< ::QList< ::GLuint64> *>(sipCppV);

#line 35 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtOpenGL/qpyopengl_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
        PyObject *pobj = PyLong_FromUnsignedLongLong(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 168 "/build/pyqt6/src/pyqt6-6.10.2/build/QtOpenGL/sipQtOpenGLQList3900.cpp"
}


sipMappedTypeDef sipTypeDef_QtOpenGL_QList_3900 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_10188,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_3900,
    array_QList_3900,
    copy_QList_3900,
    release_QList_3900,
    convertTo_QList_3900,
    convertFrom_QList_3900
};
