// ----------------------------------------------------------------------------
//
//  Copyright (C) 2015-2021 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ---------------------------------------------------------------------------- 


#ifndef __AMBBIN8_H
#define __AMBBIN8_H


#include <math.h>
#include "nffilt.h"
#include "ambrot8.h"
#include "binconv.h"


class Ambbin8
{
public:

    enum { MAXDEGR = 8, MAXHARM = 81, NOUT = 2 };
    
    Ambbin8 (int fsamp, int degree, int maxlen, int period);
    virtual ~Ambbin8 (void);

    void set_nfcomp (float distance);

    void set_filter (int harm, const float *data, int size, int step = 1)
    {
	_binconv->setimp (harm, 1.0f, data, size, step);
    }

    void set_rotation (float a, float x, float y, float z, float t)
    {
	_ambrot8->set_rotation (a, x, y, z, t);
    }

    void set_quaternion (float w, float x, float y, float z, float t)
    {
	_ambrot8->set_quaternion (w, x, y, z, t);
    }

    void process (int nframes, float *inp [], float *out []);

private:

    int              _fsamp;
    int              _degree;
    int              _period;
    int              _ninput;
    bool             _nfcomp;
    NFfiltbase      *_nffilt [MAXDEGR];
    Ambrot8         *_ambrot8;
    Binconv         *_binconv;
    float           *_buff [MAXHARM];
};


#endif
