
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "basicblockhighlighter_wrapper.h"

// Argument includes
#include <qcolor.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BasicBlockHighlighter_Type = nullptr;
static PyTypeObject *Sbk_BasicBlockHighlighter_TypeF(void)
{
    return _Sbk_BasicBlockHighlighter_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BasicBlockHighlighter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BasicBlockHighlighter >()))
        return -1;

    ::BasicBlockHighlighter *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // BasicBlockHighlighter()
        cptr = new ::BasicBlockHighlighter();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::BasicBlockHighlighter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_BasicBlockHighlighterFunc_clear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::BasicBlockHighlighter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BasicBlockHighlighter::clear(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // clear(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "clear", errInfo, SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // clear(qulonglong)
            cppSelf->clear(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BasicBlockHighlighterFunc_highlight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::BasicBlockHighlighter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "highlight", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BasicBlockHighlighter::highlight(qulonglong,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // highlight(qulonglong,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "highlight", errInfo, SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // highlight(qulonglong,QColor)
            cppSelf->highlight(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_BasicBlockHighlighter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BasicBlockHighlighter_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_BasicBlockHighlighterFunc_clear), METH_O, nullptr},
    {"highlight", reinterpret_cast<PyCFunction>(Sbk_BasicBlockHighlighterFunc_highlight), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_BasicBlockHighlighter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BasicBlockHighlighter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BasicBlockHighlighter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BasicBlockHighlighter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BasicBlockHighlighter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BasicBlockHighlighter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BasicBlockHighlighter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BasicBlockHighlighter_spec = {
    "1:CutterBindings.BasicBlockHighlighter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BasicBlockHighlighter_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BasicBlockHighlighter_PythonToCpp_BasicBlockHighlighter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BasicBlockHighlighter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BasicBlockHighlighter_PythonToCpp_BasicBlockHighlighter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BasicBlockHighlighter_TypeF()))
        return BasicBlockHighlighter_PythonToCpp_BasicBlockHighlighter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BasicBlockHighlighter_PTR_CppToPython_BasicBlockHighlighter(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_BasicBlockHighlighter_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_BasicBlockHighlighter_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BasicBlockHighlighter_SignatureStrings[] = {
    "CutterBindings.BasicBlockHighlighter(self)",
    "CutterBindings.BasicBlockHighlighter.clear(self,address:unsigned long long)",
    "CutterBindings.BasicBlockHighlighter.highlight(self,address:unsigned long long,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    nullptr}; // Sentinel
#else
static constexpr size_t BasicBlockHighlighter_SignatureByteSize = 177;
static constexpr uint8_t BasicBlockHighlighter_SignatureBytes[177] = {
    0x78, 0xda, 0x8d, 0x8e, 0xb1, 0x0a, 0xc2, 0x30, 0x10, 0x86, 0xf7, 0x3e, 0x45, 0x47, 0x0b, 0x21,
    0x20, 0x48, 0x87, 0x8e, 0xcd, 0x50, 0x07, 0x07, 0x6b, 0xd1, 0x45, 0x1c, 0xae, 0x49, 0x4c, 0x0f,
    0xc3, 0x45, 0x92, 0x74, 0xe8, 0xdb, 0x1b, 0x95, 0x8a, 0xb8, 0xd8, 0xe1, 0xee, 0x7e, 0xb8, 0xef,
    0x3e, 0x4e, 0x8c, 0x31, 0x6a, 0x5f, 0x23, 0x29, 0x24, 0x13, 0x78, 0x0d, 0x01, 0x65, 0x6d, 0x9d,
    0xbc, 0x6d, 0xd1, 0x0c, 0x36, 0x55, 0xda, 0xae, 0x82, 0xb6, 0xd7, 0x22, 0x13, 0x0b, 0x50, 0x2e,
    0xad, 0x86, 0xf7, 0x01, 0x03, 0xa5, 0xbc, 0x0e, 0xa1, 0x1a, 0x29, 0xa0, 0x21, 0xad, 0x72, 0xeb,
    0xc8, 0xbc, 0xda, 0x42, 0xd7, 0x30, 0xe7, 0x7f, 0x3e, 0x26, 0x9d, 0x75, 0xbe, 0x8a, 0xd3, 0x3d,
    0xd9, 0xf8, 0x91, 0xd0, 0xd1, 0x79, 0x3f, 0x75, 0xa8, 0x74, 0xc9, 0xdb, 0xd8, 0x8c, 0xc8, 0x5b,
    0xf1, 0x24, 0x58, 0xde, 0xee, 0x20, 0x22, 0xad, 0xbb, 0xe8, 0x13, 0xc9, 0xf2, 0x1f, 0xe8, 0x60,
    0x7a, 0x28, 0x37, 0x89, 0x3a, 0x81, 0x47, 0xa0, 0xf8, 0x0d, 0x08, 0xe7, 0x75, 0x1a, 0xbc, 0xb1,
    0xae, 0x07, 0x3b, 0xeb, 0x66, 0xd1, 0xe7, 0x27, 0xa4, 0x78, 0x29, 0xb2, 0x07, 0xb4, 0x07, 0x7c,
    0xf4
};
#endif

PyTypeObject *init_BasicBlockHighlighter(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX].type;

    Shiboken::AutoDecRef Sbk_BasicBlockHighlighter_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_BasicBlockHighlighter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BasicBlockHighlighter",
        "BasicBlockHighlighter*",
        &Sbk_BasicBlockHighlighter_spec,
        &Shiboken::callCppDestructor< ::BasicBlockHighlighter >,
        Sbk_BasicBlockHighlighter_Type_bases.object(),
        0);
    auto *pyType = Sbk_BasicBlockHighlighter_TypeF(); // references _Sbk_BasicBlockHighlighter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BasicBlockHighlighter_SignatureStrings);
#else
    InitSignatureBytes(pyType, BasicBlockHighlighter_SignatureBytes, BasicBlockHighlighter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BasicBlockHighlighter_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BasicBlockHighlighter_PythonToCpp_BasicBlockHighlighter_PTR,
        is_BasicBlockHighlighter_PythonToCpp_BasicBlockHighlighter_PTR_Convertible,
        BasicBlockHighlighter_PTR_CppToPython_BasicBlockHighlighter);

    Shiboken::Conversions::registerConverterName(converter, "BasicBlockHighlighter");
    Shiboken::Conversions::registerConverterName(converter, "BasicBlockHighlighter*");
    Shiboken::Conversions::registerConverterName(converter, "BasicBlockHighlighter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BasicBlockHighlighter).name());

    qRegisterMetaType< ::BasicBlockHighlighter *>();

    return pyType;
}
