// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package azcertificates

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// MarshalJSON implements the json.Marshaller interface for type AdministratorContact.
func (a AdministratorContact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", a.Email)
	populate(objectMap, "first_name", a.FirstName)
	populate(objectMap, "last_name", a.LastName)
	populate(objectMap, "phone", a.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministratorContact.
func (a *AdministratorContact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &a.Email)
			delete(rawMsg, key)
		case "first_name":
			err = unpopulate(val, "FirstName", &a.FirstName)
			delete(rawMsg, key)
		case "last_name":
			err = unpopulate(val, "LastName", &a.LastName)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &a.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupCertificateResult.
func (b BackupCertificateResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "value", b.Value, func() any {
		return runtime.EncodeByteArray(b.Value, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupCertificateResult.
func (b *BackupCertificateResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &b.Value, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", c.Attributes)
	populateByteArray(objectMap, "cer", c.CER, func() any {
		return runtime.EncodeByteArray(c.CER, runtime.Base64StdFormat)
	})
	populate(objectMap, "contentType", c.ContentType)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kid", c.KID)
	populate(objectMap, "policy", c.Policy)
	populate(objectMap, "preserveCertOrder", c.PreserveCertOrder)
	populate(objectMap, "sid", c.SID)
	populate(objectMap, "tags", c.Tags)
	populateByteArray(objectMap, "x5t", c.X509Thumbprint, func() any {
		return runtime.EncodeByteArray(c.X509Thumbprint, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Certificate.
func (c *Certificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &c.Attributes)
			delete(rawMsg, key)
		case "cer":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.CER, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &c.ContentType)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, "KID", &c.KID)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &c.Policy)
			delete(rawMsg, key)
		case "preserveCertOrder":
			err = unpopulate(val, "PreserveCertOrder", &c.PreserveCertOrder)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "SID", &c.SID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "x5t":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.X509Thumbprint, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateAttributes.
func (c CertificateAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created", c.Created)
	populate(objectMap, "enabled", c.Enabled)
	populateTimeUnix(objectMap, "exp", c.Expires)
	populateTimeUnix(objectMap, "nbf", c.NotBefore)
	populate(objectMap, "recoverableDays", c.RecoverableDays)
	populate(objectMap, "recoveryLevel", c.RecoveryLevel)
	populateTimeUnix(objectMap, "updated", c.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateAttributes.
func (c *CertificateAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "exp":
			err = unpopulateTimeUnix(val, "Expires", &c.Expires)
			delete(rawMsg, key)
		case "nbf":
			err = unpopulateTimeUnix(val, "NotBefore", &c.NotBefore)
			delete(rawMsg, key)
		case "recoverableDays":
			err = unpopulate(val, "RecoverableDays", &c.RecoverableDays)
			delete(rawMsg, key)
		case "recoveryLevel":
			err = unpopulate(val, "RecoveryLevel", &c.RecoveryLevel)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, "Updated", &c.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateOperation.
func (c CertificateOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "csr", c.CSR, func() any {
		return runtime.EncodeByteArray(c.CSR, runtime.Base64StdFormat)
	})
	populate(objectMap, "cancellation_requested", c.CancellationRequested)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "issuer", c.IssuerParameters)
	populate(objectMap, "preserveCertOrder", c.PreserveCertOrder)
	populate(objectMap, "request_id", c.RequestID)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "status_details", c.StatusDetails)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateOperation.
func (c *CertificateOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "csr":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.CSR, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "cancellation_requested":
			err = unpopulate(val, "CancellationRequested", &c.CancellationRequested)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "IssuerParameters", &c.IssuerParameters)
			delete(rawMsg, key)
		case "preserveCertOrder":
			err = unpopulate(val, "PreserveCertOrder", &c.PreserveCertOrder)
			delete(rawMsg, key)
		case "request_id":
			err = unpopulate(val, "RequestID", &c.RequestID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "status_details":
			err = unpopulate(val, "StatusDetails", &c.StatusDetails)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificatePolicy.
func (c CertificatePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", c.Attributes)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "issuer", c.IssuerParameters)
	populate(objectMap, "key_props", c.KeyProperties)
	populate(objectMap, "lifetime_actions", c.LifetimeActions)
	populate(objectMap, "secret_props", c.SecretProperties)
	populate(objectMap, "x509_props", c.X509CertificateProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificatePolicy.
func (c *CertificatePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &c.Attributes)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "IssuerParameters", &c.IssuerParameters)
			delete(rawMsg, key)
		case "key_props":
			err = unpopulate(val, "KeyProperties", &c.KeyProperties)
			delete(rawMsg, key)
		case "lifetime_actions":
			err = unpopulate(val, "LifetimeActions", &c.LifetimeActions)
			delete(rawMsg, key)
		case "secret_props":
			err = unpopulate(val, "SecretProperties", &c.SecretProperties)
			delete(rawMsg, key)
		case "x509_props":
			err = unpopulate(val, "X509CertificateProperties", &c.X509CertificateProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateProperties.
func (c CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", c.Attributes)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "tags", c.Tags)
	populateByteArray(objectMap, "x5t", c.X509Thumbprint, func() any {
		return runtime.EncodeByteArray(c.X509Thumbprint, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateProperties.
func (c *CertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &c.Attributes)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "x5t":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.X509Thumbprint, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificatePropertiesListResult.
func (c CertificatePropertiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificatePropertiesListResult.
func (c *CertificatePropertiesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", c.Email)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "phone", c.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Contact.
func (c *Contact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &c.Email)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Contacts.
func (c Contacts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contacts", c.ContactList)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Contacts.
func (c *Contacts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contacts":
			err = unpopulate(val, "ContactList", &c.ContactList)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateCertificateParameters.
func (c CreateCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", c.CertificateAttributes)
	populate(objectMap, "policy", c.CertificatePolicy)
	populate(objectMap, "preserveCertOrder", c.PreserveCertOrder)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateCertificateParameters.
func (c *CreateCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "CertificateAttributes", &c.CertificateAttributes)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "CertificatePolicy", &c.CertificatePolicy)
			delete(rawMsg, key)
		case "preserveCertOrder":
			err = unpopulate(val, "PreserveCertOrder", &c.PreserveCertOrder)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedCertificate.
func (d DeletedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", d.Attributes)
	populateByteArray(objectMap, "cer", d.CER, func() any {
		return runtime.EncodeByteArray(d.CER, runtime.Base64StdFormat)
	})
	populate(objectMap, "contentType", d.ContentType)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kid", d.KID)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "preserveCertOrder", d.PreserveCertOrder)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populate(objectMap, "sid", d.SID)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	populateByteArray(objectMap, "x5t", d.X509Thumbprint, func() any {
		return runtime.EncodeByteArray(d.X509Thumbprint, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedCertificate.
func (d *DeletedCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &d.Attributes)
			delete(rawMsg, key)
		case "cer":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &d.CER, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &d.ContentType)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, "DeletedDate", &d.DeletedDate)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, "KID", &d.KID)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "preserveCertOrder":
			err = unpopulate(val, "PreserveCertOrder", &d.PreserveCertOrder)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, "RecoveryID", &d.RecoveryID)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "SID", &d.SID)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, "ScheduledPurgeDate", &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "x5t":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &d.X509Thumbprint, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedCertificateProperties.
func (d DeletedCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", d.Attributes)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	populateByteArray(objectMap, "x5t", d.X509Thumbprint, func() any {
		return runtime.EncodeByteArray(d.X509Thumbprint, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedCertificateProperties.
func (d *DeletedCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &d.Attributes)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, "DeletedDate", &d.DeletedDate)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, "RecoveryID", &d.RecoveryID)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, "ScheduledPurgeDate", &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "x5t":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &d.X509Thumbprint, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedCertificatePropertiesListResult.
func (d DeletedCertificatePropertiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedCertificatePropertiesListResult.
func (d *DeletedCertificatePropertiesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportCertificateParameters.
func (i ImportCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Base64EncodedCertificate)
	populate(objectMap, "attributes", i.CertificateAttributes)
	populate(objectMap, "policy", i.CertificatePolicy)
	populate(objectMap, "pwd", i.Password)
	populate(objectMap, "preserveCertOrder", i.PreserveCertOrder)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportCertificateParameters.
func (i *ImportCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Base64EncodedCertificate", &i.Base64EncodedCertificate)
			delete(rawMsg, key)
		case "attributes":
			err = unpopulate(val, "CertificateAttributes", &i.CertificateAttributes)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "CertificatePolicy", &i.CertificatePolicy)
			delete(rawMsg, key)
		case "pwd":
			err = unpopulate(val, "Password", &i.Password)
			delete(rawMsg, key)
		case "preserveCertOrder":
			err = unpopulate(val, "PreserveCertOrder", &i.PreserveCertOrder)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Issuer.
func (i Issuer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", i.Attributes)
	populate(objectMap, "credentials", i.Credentials)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "org_details", i.OrganizationDetails)
	populate(objectMap, "provider", i.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Issuer.
func (i *Issuer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &i.Attributes)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &i.Credentials)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "org_details":
			err = unpopulate(val, "OrganizationDetails", &i.OrganizationDetails)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &i.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssuerAttributes.
func (i IssuerAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created", i.Created)
	populate(objectMap, "enabled", i.Enabled)
	populateTimeUnix(objectMap, "updated", i.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssuerAttributes.
func (i *IssuerAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, "Created", &i.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, "Updated", &i.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssuerCredentials.
func (i IssuerCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "account_id", i.AccountID)
	populate(objectMap, "pwd", i.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssuerCredentials.
func (i *IssuerCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "account_id":
			err = unpopulate(val, "AccountID", &i.AccountID)
			delete(rawMsg, key)
		case "pwd":
			err = unpopulate(val, "Password", &i.Password)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssuerParameters.
func (i IssuerParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cert_transparency", i.CertificateTransparency)
	populate(objectMap, "cty", i.CertificateType)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssuerParameters.
func (i *IssuerParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cert_transparency":
			err = unpopulate(val, "CertificateTransparency", &i.CertificateTransparency)
			delete(rawMsg, key)
		case "cty":
			err = unpopulate(val, "CertificateType", &i.CertificateType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssuerProperties.
func (i IssuerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "provider", i.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssuerProperties.
func (i *IssuerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &i.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssuerPropertiesListResult.
func (i IssuerPropertiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssuerPropertiesListResult.
func (i *IssuerPropertiesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyProperties.
func (k KeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crv", k.Curve)
	populate(objectMap, "exportable", k.Exportable)
	populate(objectMap, "key_size", k.KeySize)
	populate(objectMap, "kty", k.KeyType)
	populate(objectMap, "reuse_key", k.ReuseKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyProperties.
func (k *KeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crv":
			err = unpopulate(val, "Curve", &k.Curve)
			delete(rawMsg, key)
		case "exportable":
			err = unpopulate(val, "Exportable", &k.Exportable)
			delete(rawMsg, key)
		case "key_size":
			err = unpopulate(val, "KeySize", &k.KeySize)
			delete(rawMsg, key)
		case "kty":
			err = unpopulate(val, "KeyType", &k.KeyType)
			delete(rawMsg, key)
		case "reuse_key":
			err = unpopulate(val, "ReuseKey", &k.ReuseKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LifetimeAction.
func (l LifetimeAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", l.Action)
	populate(objectMap, "trigger", l.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LifetimeAction.
func (l *LifetimeAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &l.Action)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &l.Trigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LifetimeActionTrigger.
func (l LifetimeActionTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "days_before_expiry", l.DaysBeforeExpiry)
	populate(objectMap, "lifetime_percentage", l.LifetimePercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LifetimeActionTrigger.
func (l *LifetimeActionTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days_before_expiry":
			err = unpopulate(val, "DaysBeforeExpiry", &l.DaysBeforeExpiry)
			delete(rawMsg, key)
		case "lifetime_percentage":
			err = unpopulate(val, "LifetimePercentage", &l.LifetimePercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LifetimeActionType.
func (l LifetimeActionType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action_type", l.ActionType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LifetimeActionType.
func (l *LifetimeActionType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action_type":
			err = unpopulate(val, "ActionType", &l.ActionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MergeCertificateParameters.
func (m MergeCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", m.CertificateAttributes)
	populate(objectMap, "tags", m.Tags)
	populateByteArray(objectMap, "x5c", m.X509Certificates, func() any {
		encodedValue := make([]string, len(m.X509Certificates))
		for i := 0; i < len(m.X509Certificates); i++ {
			encodedValue[i] = runtime.EncodeByteArray(m.X509Certificates[i], runtime.Base64StdFormat)
		}
		return encodedValue
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MergeCertificateParameters.
func (m *MergeCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "CertificateAttributes", &m.CertificateAttributes)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "x5c":
			var encodedValue []string
			err = unpopulate(val, "X509Certificates", &encodedValue)
			if err == nil && len(encodedValue) > 0 {
				m.X509Certificates = make([][]byte, len(encodedValue))
				for i := 0; i < len(encodedValue) && err == nil; i++ {
					err = runtime.DecodeByteArray(encodedValue[i], &m.X509Certificates[i], runtime.Base64StdFormat)
				}
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrganizationDetails.
func (o OrganizationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "admin_details", o.AdminContacts)
	populate(objectMap, "id", o.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrganizationDetails.
func (o *OrganizationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "admin_details":
			err = unpopulate(val, "AdminContacts", &o.AdminContacts)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreCertificateParameters.
func (r RestoreCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "value", r.CertificateBackup, func() any {
		return runtime.EncodeByteArray(r.CertificateBackup, runtime.Base64URLFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreCertificateParameters.
func (r *RestoreCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &r.CertificateBackup, runtime.Base64URLFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretProperties.
func (s SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", s.ContentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretProperties.
func (s *SecretProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SetIssuerParameters.
func (s SetIssuerParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", s.Attributes)
	populate(objectMap, "credentials", s.Credentials)
	populate(objectMap, "org_details", s.OrganizationDetails)
	populate(objectMap, "provider", s.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SetIssuerParameters.
func (s *SetIssuerParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &s.Attributes)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &s.Credentials)
			delete(rawMsg, key)
		case "org_details":
			err = unpopulate(val, "OrganizationDetails", &s.OrganizationDetails)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubjectAlternativeNames.
func (s SubjectAlternativeNames) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dns_names", s.DNSNames)
	populate(objectMap, "emails", s.Emails)
	populate(objectMap, "upns", s.UserPrincipalNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubjectAlternativeNames.
func (s *SubjectAlternativeNames) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dns_names":
			err = unpopulate(val, "DNSNames", &s.DNSNames)
			delete(rawMsg, key)
		case "emails":
			err = unpopulate(val, "Emails", &s.Emails)
			delete(rawMsg, key)
		case "upns":
			err = unpopulate(val, "UserPrincipalNames", &s.UserPrincipalNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateCertificateOperationParameter.
func (u UpdateCertificateOperationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancellation_requested", u.CancellationRequested)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateCertificateOperationParameter.
func (u *UpdateCertificateOperationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancellation_requested":
			err = unpopulate(val, "CancellationRequested", &u.CancellationRequested)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateCertificateParameters.
func (u UpdateCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", u.CertificateAttributes)
	populate(objectMap, "policy", u.CertificatePolicy)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateCertificateParameters.
func (u *UpdateCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "CertificateAttributes", &u.CertificateAttributes)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "CertificatePolicy", &u.CertificatePolicy)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIssuerParameters.
func (u UpdateIssuerParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", u.Attributes)
	populate(objectMap, "credentials", u.Credentials)
	populate(objectMap, "org_details", u.OrganizationDetails)
	populate(objectMap, "provider", u.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateIssuerParameters.
func (u *UpdateIssuerParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &u.Attributes)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &u.Credentials)
			delete(rawMsg, key)
		case "org_details":
			err = unpopulate(val, "OrganizationDetails", &u.OrganizationDetails)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &u.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X509CertificateProperties.
func (x X509CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ekus", x.EnhancedKeyUsage)
	populate(objectMap, "key_usage", x.KeyUsage)
	populate(objectMap, "subject", x.Subject)
	populate(objectMap, "sans", x.SubjectAlternativeNames)
	populate(objectMap, "validity_months", x.ValidityInMonths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X509CertificateProperties.
func (x *X509CertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ekus":
			err = unpopulate(val, "EnhancedKeyUsage", &x.EnhancedKeyUsage)
			delete(rawMsg, key)
		case "key_usage":
			err = unpopulate(val, "KeyUsage", &x.KeyUsage)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &x.Subject)
			delete(rawMsg, key)
		case "sans":
			err = unpopulate(val, "SubjectAlternativeNames", &x.SubjectAlternativeNames)
			delete(rawMsg, key)
		case "validity_months":
			err = unpopulate(val, "ValidityInMonths", &x.ValidityInMonths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray[T any](m map[string]any, k string, b []T, convert func() any) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = convert()
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
