/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	internal "k8s.io/client-go/applyconfigurations/internal"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// PodCertificateRequestApplyConfiguration represents a declarative configuration of the PodCertificateRequest type for use
// with apply.
//
// PodCertificateRequest encodes a pod requesting a certificate from a given
// signer.
//
// Kubelets use this API to implement podCertificate projected volumes
type PodCertificateRequestApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration `json:",inline"`
	// metadata contains the object metadata.
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	// spec contains the details about the certificate being requested.
	Spec *PodCertificateRequestSpecApplyConfiguration `json:"spec,omitempty"`
	// status contains the issued certificate, and a standard set of conditions.
	Status *PodCertificateRequestStatusApplyConfiguration `json:"status,omitempty"`
}

// PodCertificateRequest constructs a declarative configuration of the PodCertificateRequest type for use with
// apply.
func PodCertificateRequest(name, namespace string) *PodCertificateRequestApplyConfiguration {
	b := &PodCertificateRequestApplyConfiguration{}
	b.WithName(name)
	b.WithNamespace(namespace)
	b.WithKind("PodCertificateRequest")
	b.WithAPIVersion("certificates.k8s.io/v1beta1")
	return b
}

// ExtractPodCertificateRequestFrom extracts the applied configuration owned by fieldManager from
// podCertificateRequest for the specified subresource. Pass an empty string for subresource to extract
// the main resource. Common subresources include "status", "scale", etc.
// podCertificateRequest must be a unmodified PodCertificateRequest API object that was retrieved from the Kubernetes API.
// ExtractPodCertificateRequestFrom provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
func ExtractPodCertificateRequestFrom(podCertificateRequest *certificatesv1beta1.PodCertificateRequest, fieldManager string, subresource string) (*PodCertificateRequestApplyConfiguration, error) {
	b := &PodCertificateRequestApplyConfiguration{}
	err := managedfields.ExtractInto(podCertificateRequest, internal.Parser().Type("io.k8s.api.certificates.v1beta1.PodCertificateRequest"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(podCertificateRequest.Name)
	b.WithNamespace(podCertificateRequest.Namespace)

	b.WithKind("PodCertificateRequest")
	b.WithAPIVersion("certificates.k8s.io/v1beta1")
	return b, nil
}

// ExtractPodCertificateRequest extracts the applied configuration owned by fieldManager from
// podCertificateRequest. If no managedFields are found in podCertificateRequest for fieldManager, a
// PodCertificateRequestApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// podCertificateRequest must be a unmodified PodCertificateRequest API object that was retrieved from the Kubernetes API.
// ExtractPodCertificateRequest provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
func ExtractPodCertificateRequest(podCertificateRequest *certificatesv1beta1.PodCertificateRequest, fieldManager string) (*PodCertificateRequestApplyConfiguration, error) {
	return ExtractPodCertificateRequestFrom(podCertificateRequest, fieldManager, "")
}

// ExtractPodCertificateRequestStatus extracts the applied configuration owned by fieldManager from
// podCertificateRequest for the status subresource.
func ExtractPodCertificateRequestStatus(podCertificateRequest *certificatesv1beta1.PodCertificateRequest, fieldManager string) (*PodCertificateRequestApplyConfiguration, error) {
	return ExtractPodCertificateRequestFrom(podCertificateRequest, fieldManager, "status")
}

func (b PodCertificateRequestApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithKind(value string) *PodCertificateRequestApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithAPIVersion(value string) *PodCertificateRequestApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithName(value string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithGenerateName(value string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithNamespace(value string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithUID(value types.UID) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithResourceVersion(value string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithGeneration(value int64) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithCreationTimestamp(value metav1.Time) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *PodCertificateRequestApplyConfiguration) WithLabels(entries map[string]string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Labels == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *PodCertificateRequestApplyConfiguration) WithAnnotations(entries map[string]string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Annotations == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *PodCertificateRequestApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.ObjectMetaApplyConfiguration.OwnerReferences = append(b.ObjectMetaApplyConfiguration.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *PodCertificateRequestApplyConfiguration) WithFinalizers(values ...string) *PodCertificateRequestApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.ObjectMetaApplyConfiguration.Finalizers = append(b.ObjectMetaApplyConfiguration.Finalizers, values[i])
	}
	return b
}

func (b *PodCertificateRequestApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithSpec sets the Spec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spec field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithSpec(value *PodCertificateRequestSpecApplyConfiguration) *PodCertificateRequestApplyConfiguration {
	b.Spec = value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *PodCertificateRequestApplyConfiguration) WithStatus(value *PodCertificateRequestStatusApplyConfiguration) *PodCertificateRequestApplyConfiguration {
	b.Status = value
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *PodCertificateRequestApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *PodCertificateRequestApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}

// GetName retrieves the value of the Name field in the declarative configuration.
func (b *PodCertificateRequestApplyConfiguration) GetName() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Name
}

// GetNamespace retrieves the value of the Namespace field in the declarative configuration.
func (b *PodCertificateRequestApplyConfiguration) GetNamespace() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Namespace
}
