// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaMp4Metrics_h
#define mozilla_GleanDomMediaMp4Metrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace media_mp4_parse {
  /**
   * generated from media.mp4_parse.num_sample_description_entries
   * Counts the number of entries in the sample description box (stsd) for a track in an mp4. Recorded each time we process a track's metadata while parsing mp4s.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram MEDIA_MP4_PARSE_NUM_SAMPLE_DESCRIPTION_ENTRIES.
   */
  constexpr impl::CustomDistributionMetric num_sample_description_entries(3811);

  /**
   * generated from media.mp4_parse.sample_description_entries_have_multiple_codecs
   */
  enum class SampleDescriptionEntriesHaveMultipleCodecsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Records if multiple codecs are present in a track's sample description entries. Recorded each time we process a track's metadata while parsing mp4s.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram MEDIA_MP4_PARSE_SAMPLE_DESCRIPTION_ENTRIES_HAVE_MULTIPLE_CODECS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SampleDescriptionEntriesHaveMultipleCodecsLabel> sample_description_entries_have_multiple_codecs(3812);

  /**
   * generated from media.mp4_parse.sample_description_entries_have_multiple_crypto
   */
  enum class SampleDescriptionEntriesHaveMultipleCryptoLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Records if multiple sets of crypto info are present in a track's sample description entries. Recorded each time we process a track's metadata while parsing mp4s.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram MEDIA_MP4_PARSE_SAMPLE_DESCRIPTION_ENTRIES_HAVE_MULTIPLE_CRYPTO.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SampleDescriptionEntriesHaveMultipleCryptoLabel> sample_description_entries_have_multiple_crypto(3813);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaMp4Metrics_h
