/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ImageCaptureErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "ImageCaptureErrorEvent.h"
#include "ImageCaptureErrorEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/ImageCaptureError.h"
#include "mozilla/dom/ImageCaptureErrorEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(ImageCaptureErrorEvent)

NS_IMPL_ADDREF_INHERITED(ImageCaptureErrorEvent, Event)
NS_IMPL_RELEASE_INHERITED(ImageCaptureErrorEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(ImageCaptureErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mImageCaptureError)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(ImageCaptureErrorEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(ImageCaptureErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mImageCaptureError)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(ImageCaptureErrorEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

ImageCaptureErrorEvent::ImageCaptureErrorEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ImageCaptureErrorEvent::~ImageCaptureErrorEvent()
{
}

ImageCaptureErrorEvent*
ImageCaptureErrorEvent::AsImageCaptureErrorEvent()
{
  return this;
}

JSObject*
ImageCaptureErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ImageCaptureErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ImageCaptureErrorEvent>
ImageCaptureErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ImageCaptureErrorEventInit& aImageCaptureErrorInitDict)
{
  RefPtr<ImageCaptureErrorEvent> e = new ImageCaptureErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aImageCaptureErrorInitDict.mBubbles, aImageCaptureErrorInitDict.mCancelable);
  e->mImageCaptureError = aImageCaptureErrorInitDict.mImageCaptureError;
  e->SetTrusted(trusted);
  e->SetComposed(aImageCaptureErrorInitDict.mComposed);
  return e.forget();
}

already_AddRefed<ImageCaptureErrorEvent>
ImageCaptureErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ImageCaptureErrorEventInit& aImageCaptureErrorInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aImageCaptureErrorInitDict);
}

ImageCaptureError*
ImageCaptureErrorEvent::GetImageCaptureError() const
{
  return mImageCaptureError;
}


} // namespace mozilla::dom
