﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mailmanager/MailManager_EXPORTS.h>
#include <aws/mailmanager/model/IngressIpOperator.h>
#include <aws/mailmanager/model/IngressIpToEvaluate.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MailManager {
namespace Model {

/**
 * <p>The union type representing the allowed types for the left hand side of an IP
 * condition.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/IngressIpv4Expression">AWS
 * API Reference</a></p>
 */
class IngressIpv4Expression {
 public:
  AWS_MAILMANAGER_API IngressIpv4Expression() = default;
  AWS_MAILMANAGER_API IngressIpv4Expression(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAILMANAGER_API IngressIpv4Expression& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAILMANAGER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The left hand side argument of an IP condition expression.</p>
   */
  inline const IngressIpToEvaluate& GetEvaluate() const { return m_evaluate; }
  inline bool EvaluateHasBeenSet() const { return m_evaluateHasBeenSet; }
  template <typename EvaluateT = IngressIpToEvaluate>
  void SetEvaluate(EvaluateT&& value) {
    m_evaluateHasBeenSet = true;
    m_evaluate = std::forward<EvaluateT>(value);
  }
  template <typename EvaluateT = IngressIpToEvaluate>
  IngressIpv4Expression& WithEvaluate(EvaluateT&& value) {
    SetEvaluate(std::forward<EvaluateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The matching operator for an IP condition expression.</p>
   */
  inline IngressIpOperator GetOperator() const { return m_operator; }
  inline bool OperatorHasBeenSet() const { return m_operatorHasBeenSet; }
  inline void SetOperator(IngressIpOperator value) {
    m_operatorHasBeenSet = true;
    m_operator = value;
  }
  inline IngressIpv4Expression& WithOperator(IngressIpOperator value) {
    SetOperator(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The right hand side argument of an IP condition expression.</p>
   */
  inline const Aws::Vector<Aws::String>& GetValues() const { return m_values; }
  inline bool ValuesHasBeenSet() const { return m_valuesHasBeenSet; }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  void SetValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values = std::forward<ValuesT>(value);
  }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  IngressIpv4Expression& WithValues(ValuesT&& value) {
    SetValues(std::forward<ValuesT>(value));
    return *this;
  }
  template <typename ValuesT = Aws::String>
  IngressIpv4Expression& AddValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values.emplace_back(std::forward<ValuesT>(value));
    return *this;
  }
  ///@}
 private:
  IngressIpToEvaluate m_evaluate;

  IngressIpOperator m_operator{IngressIpOperator::NOT_SET};

  Aws::Vector<Aws::String> m_values;
  bool m_evaluateHasBeenSet = false;
  bool m_operatorHasBeenSet = false;
  bool m_valuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
