﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/StringCondition.h>
#include <aws/connect/model/TestCaseStatus.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>The search criteria to be used to return test cases.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TestCaseSearchCriteria">AWS
 * API Reference</a></p>
 */
class TestCaseSearchCriteria {
 public:
  AWS_CONNECT_API TestCaseSearchCriteria() = default;
  AWS_CONNECT_API TestCaseSearchCriteria(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API TestCaseSearchCriteria& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A list of conditions which would be applied together with an OR
   * condition.</p>
   */
  inline const Aws::Vector<TestCaseSearchCriteria>& GetOrConditions() const { return m_orConditions; }
  inline bool OrConditionsHasBeenSet() const { return m_orConditionsHasBeenSet; }
  template <typename OrConditionsT = Aws::Vector<TestCaseSearchCriteria>>
  void SetOrConditions(OrConditionsT&& value) {
    m_orConditionsHasBeenSet = true;
    m_orConditions = std::forward<OrConditionsT>(value);
  }
  template <typename OrConditionsT = Aws::Vector<TestCaseSearchCriteria>>
  TestCaseSearchCriteria& WithOrConditions(OrConditionsT&& value) {
    SetOrConditions(std::forward<OrConditionsT>(value));
    return *this;
  }
  template <typename OrConditionsT = TestCaseSearchCriteria>
  TestCaseSearchCriteria& AddOrConditions(OrConditionsT&& value) {
    m_orConditionsHasBeenSet = true;
    m_orConditions.emplace_back(std::forward<OrConditionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of conditions which would be applied together with an AND
   * condition.</p>
   */
  inline const Aws::Vector<TestCaseSearchCriteria>& GetAndConditions() const { return m_andConditions; }
  inline bool AndConditionsHasBeenSet() const { return m_andConditionsHasBeenSet; }
  template <typename AndConditionsT = Aws::Vector<TestCaseSearchCriteria>>
  void SetAndConditions(AndConditionsT&& value) {
    m_andConditionsHasBeenSet = true;
    m_andConditions = std::forward<AndConditionsT>(value);
  }
  template <typename AndConditionsT = Aws::Vector<TestCaseSearchCriteria>>
  TestCaseSearchCriteria& WithAndConditions(AndConditionsT&& value) {
    SetAndConditions(std::forward<AndConditionsT>(value));
    return *this;
  }
  template <typename AndConditionsT = TestCaseSearchCriteria>
  TestCaseSearchCriteria& AddAndConditions(AndConditionsT&& value) {
    m_andConditionsHasBeenSet = true;
    m_andConditions.emplace_back(std::forward<AndConditionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A leaf node condition which can be used to specify a string condition.</p>
   */
  inline const StringCondition& GetStringCondition() const { return m_stringCondition; }
  inline bool StringConditionHasBeenSet() const { return m_stringConditionHasBeenSet; }
  template <typename StringConditionT = StringCondition>
  void SetStringCondition(StringConditionT&& value) {
    m_stringConditionHasBeenSet = true;
    m_stringCondition = std::forward<StringConditionT>(value);
  }
  template <typename StringConditionT = StringCondition>
  TestCaseSearchCriteria& WithStringCondition(StringConditionT&& value) {
    SetStringCondition(std::forward<StringConditionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the test case.</p>
   */
  inline TestCaseStatus GetStatusCondition() const { return m_statusCondition; }
  inline bool StatusConditionHasBeenSet() const { return m_statusConditionHasBeenSet; }
  inline void SetStatusCondition(TestCaseStatus value) {
    m_statusConditionHasBeenSet = true;
    m_statusCondition = value;
  }
  inline TestCaseSearchCriteria& WithStatusCondition(TestCaseStatus value) {
    SetStatusCondition(value);
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TestCaseSearchCriteria> m_orConditions;

  Aws::Vector<TestCaseSearchCriteria> m_andConditions;

  StringCondition m_stringCondition;

  TestCaseStatus m_statusCondition{TestCaseStatus::NOT_SET};
  bool m_orConditionsHasBeenSet = false;
  bool m_andConditionsHasBeenSet = false;
  bool m_stringConditionHasBeenSet = false;
  bool m_statusConditionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
