define(["exports","./../common/globalize.js","./../emby-apiclient/connectionmanager.js","./../emby-apiclient/events.js","./../common/playback/playbackmanager.js","./../common/appsettings.js","./../common/usersettings/usersettings.js"],function(_exports,_globalize,_connectionmanager,_events,_playbackmanager,_appsettings,_usersettings){function showAlert(options){Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var currentResolve,currentReject,PlayerName="Chromecast";function sendConnectionResult(isOk){var resolve=currentResolve,reject=currentReject;currentReject=currentResolve=null,isOk?resolve&&resolve():reject?reject():_playbackmanager.default.removeActivePlayer(PlayerName)}var DEVICE_STATE_IDLE=0,DEVICE_STATE_ACTIVE=1,DEVICE_STATE_ERROR=3,PLAYER_STATE_IDLE="IDLE",PLAYER_STATE_PLAYING="PLAYING",CastPlayer=function(){this.deviceState=DEVICE_STATE_IDLE,this.currentMediaSession=null,this.session=null,this.castPlayerState=PLAYER_STATE_IDLE,this.hasReceivers=!1,this.errorHandler=this.onError.bind(this),this.mediaStatusUpdateHandler=this.onMediaStatusUpdate.bind(this),this.currentVolume=1,this.initializeCastPlayer()};function mapItemForLoadMedia(i){return{Id:i.Id,ServerId:i.ServerId,Name:i.Name,Type:i.Type,MediaType:i.MediaType,IsFolder:i.IsFolder,ChannelId:i.ChannelId}}function bindEventForRelay(instance,eventName){_events.default.on(instance._castPlayer,eventName,function(e,data){"playlistitemremove"!==eventName&&(data=instance.getPlayerStateInternal(data)),_events.default.trigger(instance,eventName,[data])})}function ChromecastPlayer(){this.name=PlayerName,this.type="mediaplayer",this.id="chromecast",this.isLocalPlayer=!1,this.resetLastPlayerData(),new Promise(function(resolve,reject){var fileref=document.createElement("script");fileref.setAttribute("type","text/javascript"),fileref.onload=resolve,fileref.setAttribute("src","https://www.gstatic.com/cv/js/sender/v1/cast_sender.js"),document.querySelector("head").appendChild(fileref)}).then(function(){var instance=this;instance._castPlayer=new CastPlayer,document.dispatchEvent(new CustomEvent("chromecastloaded",{detail:{player:instance}})),_events.default.on(instance._castPlayer,"connect",function(e){currentResolve?sendConnectionResult(!0):_playbackmanager.default.setActivePlayer(PlayerName,instance.getCurrentTargetInfo()),console.log("cc: connect"),instance.lastPlayerData=null}),_events.default.on(instance._castPlayer,"playbackstart",function(e,data){console.log("cc: playbackstart"),instance._castPlayer.initializeCastPlayer();data=instance.getPlayerStateInternal(data);_events.default.trigger(instance,"playbackstart",[data])}),_events.default.on(instance._castPlayer,"playbackstop",function(e,data){console.log("cc: playbackstop");data=instance.getPlayerStateInternal(data);_events.default.trigger(instance,"playbackstop",[data]),instance.resetLastPlayerData()}),_events.default.on(instance._castPlayer,"playbackprogress",function(e,data){data=instance.getPlayerStateInternal(data);_events.default.trigger(instance,"timeupdate",[data])}),bindEventForRelay(instance,"timeupdate"),bindEventForRelay(instance,"pause"),bindEventForRelay(instance,"unpause"),bindEventForRelay(instance,"volumechange"),bindEventForRelay(instance,"repeatmodechange"),bindEventForRelay(instance,"sleeptimerchange"),bindEventForRelay(instance,"shufflechange"),bindEventForRelay(instance,"subtitleoffsetchange"),bindEventForRelay(instance,"playbackratechange"),bindEventForRelay(instance,"audiotrackchange"),bindEventForRelay(instance,"subtitletrackchange"),bindEventForRelay(instance,"qualitychange"),bindEventForRelay(instance,"playlistitemmove"),bindEventForRelay(instance,"playlistitemremove"),bindEventForRelay(instance,"playlistitemadd")}.bind(this))}CastPlayer.prototype.initializeCastPlayer=function(){var sessionRequest,chrome=window.chrome;chrome&&(chrome.cast&&chrome.cast.isAvailable?(sessionRequest=new chrome.cast.SessionRequest("2D4B1DA3"),sessionRequest=new chrome.cast.ApiConfig(sessionRequest,this.sessionListener.bind(this),this.receiverListener.bind(this),"origin_scoped"),console.log("chromecast.initialize"),chrome.cast.initialize(sessionRequest,this.onInitSuccess.bind(this),this.errorHandler)):setTimeout(this.initializeCastPlayer.bind(this),1e3))},CastPlayer.prototype.onInitSuccess=function(){this.isInitialized=!0,console.log("chromecast init success")},CastPlayer.prototype.onError=function(e){console.log("chromecast error. code: "+(e.code||"")+", details: "+(e.details||""))},CastPlayer.prototype.sessionListener=function(e){this.session=e,this.session&&(this.session.media[0]&&this.onMediaDiscovered("activeSession",this.session.media[0]),this.onSessionConnected(e))},CastPlayer.prototype.messageListener=function(namespace,message){var errorCode;"playbackerror"===(message="string"==typeof message?JSON.parse(message):message).type?(errorCode=message.data,setTimeout(function(){showAlert(_globalize.default.translate("MessagePlaybackError"+errorCode),_globalize.default.translate("HeaderPlaybackError"))},300)):"connectionerror"===message.type?setTimeout(function(){showAlert(_globalize.default.translate("MessageChromecastConnectionError"),_globalize.default.translate("Error"))},300):message.type&&_events.default.trigger(this,message.type,[message.data])},CastPlayer.prototype.receiverListener=function(e){this.hasReceivers="available"===e},CastPlayer.prototype.sessionUpdateListener=function(isAlive){isAlive||(this.session=null,this.deviceState=DEVICE_STATE_IDLE,this.castPlayerState=PLAYER_STATE_IDLE,this.currentMediaSession=null,sendConnectionResult(!1))},CastPlayer.prototype.launchApp=function(){chrome.cast.requestSession(this.onRequestSessionSuccess.bind(this),this.onLaunchError.bind(this))},CastPlayer.prototype.onRequestSessionSuccess=function(e){this.onSessionConnected(e)},CastPlayer.prototype.onSessionConnected=function(session){this.session=session,this.currentVolume=this.session.receiver.volume.level,this.deviceState=DEVICE_STATE_ACTIVE,this.session.addMessageListener("urn:x-cast:com.connectsdk",this.messageListener.bind(this)),this.session.addMediaListener(this.sessionMediaListener.bind(this)),this.session.addUpdateListener(this.sessionUpdateListener.bind(this)),_events.default.trigger(this,"connect"),this.sendMessage({options:{},command:"Identify"})},CastPlayer.prototype.sessionMediaListener=function(e){this.currentMediaSession=e,this.currentMediaSession.addUpdateListener(this.mediaStatusUpdateHandler)},CastPlayer.prototype.onLaunchError=function(){this.deviceState=DEVICE_STATE_ERROR,sendConnectionResult(!1)},CastPlayer.prototype.stopApp=function(){this.session&&this.session.stop(this.onStopAppSuccess.bind(this,"Session stopped"),this.errorHandler)},CastPlayer.prototype.onStopAppSuccess=function(message){this.deviceState=DEVICE_STATE_IDLE,this.castPlayerState=PLAYER_STATE_IDLE,this.currentMediaSession=null},CastPlayer.prototype.loadMedia=function(options,command){return this.session?(options.items=options.items.map(mapItemForLoadMedia),this.sendMessage({options:options,command:command})):Promise.reject()},CastPlayer.prototype.sendMessage=function(message){var apiClient,player=this,receiverName=null,session=player.session,session=(session&&session.receiver&&session.receiver.friendlyName&&(receiverName=session.receiver.friendlyName),apiClient=message.options&&message.options.ServerId?_connectionmanager.default.getApiClient(message.options.ServerId):message.options&&message.options.items&&message.options.items.length?_connectionmanager.default.getApiClient(message.options.items[0]):_connectionmanager.default.currentApiClient(),message=Object.assign(message,{userId:apiClient.getCurrentUserId(),deviceId:apiClient.deviceId(),accessToken:apiClient.accessToken(),serverAddress:apiClient.serverAddress(),serverId:apiClient.serverId(),serverVersion:apiClient.serverVersion(),receiverName:receiverName}),_appsettings.default.maxChromecastBitrate());return session&&(message.maxBitrate=session),message.options&&message.options.items&&(message.subtitleAppearance=_usersettings.default.getSubtitleAppearanceSettings()),Emby.importModule("./modules/chromecast/chromecasthelpers.js").then(function(chromecastHelper){return chromecastHelper.getServerAddress(apiClient).then(function(serverAddress){return message.serverAddress=serverAddress,player.sendMessageInternal(message)})})},CastPlayer.prototype.sendMessageInternal=function(message){return message=JSON.stringify(message),this.session.sendMessage("urn:x-cast:com.connectsdk",message,this.onPlayCommandSuccess.bind(this),this.errorHandler),Promise.resolve()},CastPlayer.prototype.onPlayCommandSuccess=function(){},CastPlayer.prototype.onMediaDiscovered=function(how,mediaSession){this.currentMediaSession=mediaSession,"loadMedia"===how&&(this.castPlayerState=PLAYER_STATE_PLAYING),"activeSession"===how&&(this.castPlayerState=mediaSession.playerState),this.currentMediaSession.addUpdateListener(this.mediaStatusUpdateHandler)},CastPlayer.prototype.onMediaStatusUpdate=function(e){!1===e&&(this.castPlayerState=PLAYER_STATE_IDLE)},CastPlayer.prototype.setReceiverVolume=function(mute,vol){this.currentMediaSession,mute?this.session.setReceiverMuted(!0,this.mediaCommandSuccessCallback.bind(this),this.errorHandler):(this.currentVolume=mute=vol,this.session.setReceiverVolumeLevel(mute,this.mediaCommandSuccessCallback.bind(this),this.errorHandler))},CastPlayer.prototype.mute=function(){this.setReceiverVolume(!0)},CastPlayer.prototype.unMute=function(){var newVolume=this.currentVolume||1;this.setReceiverVolume(!1,newVolume)},CastPlayer.prototype.mediaCommandSuccessCallback=function(info,e){},ChromecastPlayer.prototype.tryPair=function(target){var castPlayer=this._castPlayer;return castPlayer.deviceState!==DEVICE_STATE_ACTIVE&&castPlayer.isInitialized?new Promise(function(resolve,reject){currentResolve=resolve,currentReject=reject,castPlayer.launchApp()}):(currentReject=currentResolve=null,Promise.reject())},ChromecastPlayer.prototype.resetLastPlayerData=function(){var newData={},lastPlayerData=this.lastPlayerData;lastPlayerData&&lastPlayerData.NowPlayingQueue&&(newData.NowPlayingQueue=lastPlayerData.NowPlayingQueue),this.lastPlayerData=newData},ChromecastPlayer.prototype.getTargets=function(){var targets=[];return this._castPlayer&&this._castPlayer.hasReceivers&&targets.push(this.getCurrentTargetInfo()),Promise.resolve(targets)},ChromecastPlayer.prototype.getCurrentTargetInfo=function(){var appName=null,castPlayer=this._castPlayer;return castPlayer.session&&castPlayer.session.receiver&&castPlayer.session.receiver.friendlyName&&(appName=castPlayer.session.receiver.friendlyName),{name:PlayerName,id:PlayerName,playerName:PlayerName,playableMediaTypes:["Audio","Video"],isLocalPlayer:!1,appName:PlayerName,deviceName:appName,supportedCommands:["VolumeUp","VolumeDown","Mute","Unmute","ToggleMute","SetVolume","SetAudioStreamIndex","SetSubtitleStreamIndex","RefreshMediaSource","DisplayContent","TriggerTranscodingFallback","SetRepeatMode","SetSleepTimer","SetShuffle","SetSubtitleOffset","SetPlaybackRate","EndSession","PlayMediaSource","PlayTrailers"]}},ChromecastPlayer.prototype.getPlayerStateInternal=function(data){var lastPlayerData=this.lastPlayerData,triggerStateChange=!1;return data&&(!data.NowPlayingQueue&&lastPlayerData&&(data.NowPlayingQueue=lastPlayerData.NowPlayingQueue),lastPlayerData||(triggerStateChange=!0)),(data=data||lastPlayerData)&&(data.VolumeLevel=100*this._castPlayer.currentVolume),this.lastPlayerData=data,(lastPlayerData=data)&&lastPlayerData.NowPlayingItem&&((lastPlayerData=lastPlayerData.NowPlayingItem).ImageTags&&lastPlayerData.ImageTags.Primary||lastPlayerData.PrimaryImageTag&&(lastPlayerData.ImageTags=lastPlayerData.ImageTags||{},lastPlayerData.ImageTags.Primary=lastPlayerData.PrimaryImageTag),lastPlayerData.BackdropImageTag&&lastPlayerData.BackdropItemId===lastPlayerData.Id&&(lastPlayerData.BackdropImageTags=[lastPlayerData.BackdropImageTag]),lastPlayerData.BackdropImageTag)&&lastPlayerData.BackdropItemId!==lastPlayerData.Id&&(lastPlayerData.ParentBackdropImageTags=[lastPlayerData.BackdropImageTag],lastPlayerData.ParentBackdropItemId=lastPlayerData.BackdropItemId),triggerStateChange&&_events.default.trigger(this,"statechange",[data]),data},ChromecastPlayer.prototype.playWithCommand=function(options,command){var apiClient,instance;return options.items?this._castPlayer.loadMedia(options,command):(apiClient=_connectionmanager.default.getApiClient(options.serverId),instance=this,apiClient.getItem(apiClient.getCurrentUserId(),options.ids[0]).then(function(item){return options.items=[item],instance.playWithCommand(options,command)}))},ChromecastPlayer.prototype.seek=function(position){return position=parseInt(position),this._castPlayer.sendMessage({options:{position:position/=1e7},command:"Seek"})},ChromecastPlayer.prototype.seekRelative=function(offsetTicks){return offsetTicks=parseInt(offsetTicks),this._castPlayer.sendMessage({options:{offset:offsetTicks},command:"SeekRelative"})},ChromecastPlayer.prototype.setAudioStreamIndex=function(index){return this._castPlayer.sendMessage({options:{index:index},command:"SetAudioStreamIndex"})},ChromecastPlayer.prototype.setSubtitleStreamIndex=function(index,refreshMediaSource){return this._castPlayer.sendMessage({options:{index:index,RefreshMediaSource:refreshMediaSource},command:"SetSubtitleStreamIndex"})},ChromecastPlayer.prototype.setMaxStreamingBitrate=function(options){return this._castPlayer.sendMessage({options:options,command:"SetMaxStreamingBitrate"})},ChromecastPlayer.prototype.isFullscreen=function(){var _this$lastPlayerData;return null==(_this$lastPlayerData=this.lastPlayerData)||null==(_this$lastPlayerData=_this$lastPlayerData.PlayState)?void 0:_this$lastPlayerData.IsFullscreen},ChromecastPlayer.prototype.nextTrack=function(){return this._castPlayer.sendMessage({options:{},command:"NextTrack"})},ChromecastPlayer.prototype.previousTrack=function(){return this._castPlayer.sendMessage({options:{},command:"PreviousTrack"})},ChromecastPlayer.prototype.volumeDown=function(){var volume=this._castPlayer.currentVolume-.02;this.setVolume(100*volume)},ChromecastPlayer.prototype.endSession=function(){var instance=this;this.stop().then(function(){setTimeout(function(){instance._castPlayer.stopApp()},1e3)})},ChromecastPlayer.prototype.volumeUp=function(){var volume=this._castPlayer.currentVolume+.02;this.setVolume(100*volume)},ChromecastPlayer.prototype.setVolume=function(vol){vol=Math.min(vol,100),vol=Math.max(vol,0),this._castPlayer.setReceiverVolume(!1,vol/100)},ChromecastPlayer.prototype.unpause=function(){return this._castPlayer.sendMessage({options:{},command:"Unpause"})},ChromecastPlayer.prototype.playPause=function(){return this._castPlayer.sendMessage({options:{},command:"PlayPause"})},ChromecastPlayer.prototype.pause=function(){return this._castPlayer.sendMessage({options:{},command:"Pause"})},ChromecastPlayer.prototype.stop=function(){return this._castPlayer.sendMessage({options:{},command:"Stop"})},ChromecastPlayer.prototype.displayContent=function(options){return this._castPlayer.sendMessage({options:options,command:"DisplayContent"})},ChromecastPlayer.prototype.setMute=function(isMuted){isMuted?this._castPlayer.mute():this._castPlayer.unMute()},ChromecastPlayer.prototype.getRepeatMode=function(){var _this$lastPlayerData2;return null==(_this$lastPlayerData2=this.lastPlayerData)||null==(_this$lastPlayerData2=_this$lastPlayerData2.PlayState)?void 0:_this$lastPlayerData2.RepeatMode},ChromecastPlayer.prototype.getSleepTimerMode=function(){var _this$lastPlayerData3;return null==(_this$lastPlayerData3=this.lastPlayerData)||null==(_this$lastPlayerData3=_this$lastPlayerData3.PlayState)?void 0:_this$lastPlayerData3.SleepTimerMode},ChromecastPlayer.prototype.getSleepTimerEndTime=function(){var _this$lastPlayerData4;return null==(_this$lastPlayerData4=this.lastPlayerData)||null==(_this$lastPlayerData4=_this$lastPlayerData4.PlayState)?void 0:_this$lastPlayerData4.SleepTimerEndTime},ChromecastPlayer.prototype.getShuffle=function(){var _this$lastPlayerData5;return null==(_this$lastPlayerData5=this.lastPlayerData)||null==(_this$lastPlayerData5=_this$lastPlayerData5.PlayState)?void 0:_this$lastPlayerData5.Shuffle},ChromecastPlayer.prototype.getSubtitleOffset=function(){var _this$lastPlayerData6;return null==(_this$lastPlayerData6=this.lastPlayerData)||null==(_this$lastPlayerData6=_this$lastPlayerData6.PlayState)?void 0:_this$lastPlayerData6.SubtitleOffset},ChromecastPlayer.prototype.playTrailers=function(item){return this._castPlayer.sendMessage({options:{ItemId:item.Id,ServerId:item.ServerId},command:"PlayTrailers"})},ChromecastPlayer.prototype.triggerTranscodingFallback=function(){return this._castPlayer.sendMessage({options:{},command:"TriggerTranscodingFallback"})},ChromecastPlayer.prototype.setRepeatMode=function(mode){return this._castPlayer.sendMessage({options:{RepeatMode:mode},command:"SetRepeatMode"})},ChromecastPlayer.prototype.setSleepTimer=function(options){return this._castPlayer.sendMessage({options:options,command:"SetSleepTimer"})},ChromecastPlayer.prototype.setShuffle=function(mode){return this._castPlayer.sendMessage({options:{Shuffle:mode},command:"SetShuffle"})},ChromecastPlayer.prototype.setSubtitleOffset=function(value){return this._castPlayer.sendMessage({options:{SubtitleOffset:value},command:"SetSubtitleOffset"})},ChromecastPlayer.prototype.incrementSubtitleOffset=function(value){return this._castPlayer.sendMessage({options:{Increment:value},command:"IncrementSubtitleOffset"})},ChromecastPlayer.prototype.getPlaybackRate=function(){var _this$lastPlayerData7;return null==(_this$lastPlayerData7=this.lastPlayerData)||null==(_this$lastPlayerData7=_this$lastPlayerData7.PlayState)?void 0:_this$lastPlayerData7.PlaybackRate},ChromecastPlayer.prototype.setPlaybackRate=function(value){return this._castPlayer.sendMessage({options:{PlaybackRate:value},command:"SetPlaybackRate"})},ChromecastPlayer.prototype.toggleMute=function(){return this._castPlayer.sendMessage({options:{},command:"ToggleMute"})},ChromecastPlayer.prototype.getAudioStreamIndex=function(){var _this$lastPlayerData8;return null==(_this$lastPlayerData8=this.lastPlayerData)||null==(_this$lastPlayerData8=_this$lastPlayerData8.PlayState)?void 0:_this$lastPlayerData8.AudioStreamIndex},ChromecastPlayer.prototype.getSubtitleStreamIndex=function(){var _this$lastPlayerData9;return null==(_this$lastPlayerData9=this.lastPlayerData)||null==(_this$lastPlayerData9=_this$lastPlayerData9.PlayState)?void 0:_this$lastPlayerData9.SubtitleStreamIndex},ChromecastPlayer.prototype.getMaxStreamingBitrate=function(){var _this$lastPlayerData0;return null==(_this$lastPlayerData0=this.lastPlayerData)||null==(_this$lastPlayerData0=_this$lastPlayerData0.PlayState)?void 0:_this$lastPlayerData0.MaxStreamingBitrate},ChromecastPlayer.prototype.getVolume=function(){var _this$lastPlayerData1=null==(_this$lastPlayerData1=this.lastPlayerData)||null==(_this$lastPlayerData1=_this$lastPlayerData1.PlayState)?void 0:_this$lastPlayerData1.VolumeLevel;return null==_this$lastPlayerData1?100:_this$lastPlayerData1},ChromecastPlayer.prototype.isPlaying=function(mediaType){var _this$lastPlayerData10=null==(_this$lastPlayerData10=this.lastPlayerData)?void 0:_this$lastPlayerData10.NowPlayingItem;return _this$lastPlayerData10&&(!mediaType||_this$lastPlayerData10.MediaType===mediaType)},ChromecastPlayer.prototype.currentMediaSource=function(){var _this$lastPlayerData11;return null==(_this$lastPlayerData11=this.lastPlayerData)?void 0:_this$lastPlayerData11.MediaSource},ChromecastPlayer.prototype.currentTime=function(val){return null!=val?this.seek(val):null==(val=this.lastPlayerData)||null==(val=val.PlayState)?void 0:val.PositionTicks},ChromecastPlayer.prototype.playbackStartTime=function(){var _this$lastPlayerData13;return null==(_this$lastPlayerData13=this.lastPlayerData)||null==(_this$lastPlayerData13=_this$lastPlayerData13.PlayState)?void 0:_this$lastPlayerData13.PlaybackStartTimeTicks},ChromecastPlayer.prototype.duration=function(){var _this$lastPlayerData14;return null==(_this$lastPlayerData14=this.lastPlayerData)||null==(_this$lastPlayerData14=_this$lastPlayerData14.MediaSource)?void 0:_this$lastPlayerData14.RunTimeTicks},ChromecastPlayer.prototype.getBufferedRanges=function(){var _this$lastPlayerData15;return(null==(_this$lastPlayerData15=this.lastPlayerData)||null==(_this$lastPlayerData15=_this$lastPlayerData15.PlayState)?void 0:_this$lastPlayerData15.BufferedRanges)||[]},ChromecastPlayer.prototype.getSeekableRanges=function(){var _this$lastPlayerData16;return(null==(_this$lastPlayerData16=this.lastPlayerData)||null==(_this$lastPlayerData16=_this$lastPlayerData16.PlayState)?void 0:_this$lastPlayerData16.SeekableRanges)||[]},ChromecastPlayer.prototype.paused=function(){var _this$lastPlayerData17;return null==(_this$lastPlayerData17=this.lastPlayerData)||null==(_this$lastPlayerData17=_this$lastPlayerData17.PlayState)?void 0:_this$lastPlayerData17.IsPaused},ChromecastPlayer.prototype.isMuted=function(){var _this$lastPlayerData18;return null==(_this$lastPlayerData18=this.lastPlayerData)||null==(_this$lastPlayerData18=_this$lastPlayerData18.PlayState)?void 0:_this$lastPlayerData18.IsMuted},ChromecastPlayer.prototype.shuffle=function(item){var apiClient=_connectionmanager.default.getApiClient(item),userId=apiClient.getCurrentUserId(),instance=this;return apiClient.getItem(userId,item.Id).then(function(item){return instance.playWithCommand({items:[item]},"Shuffle")})},ChromecastPlayer.prototype.instantMix=function(item){var apiClient=_connectionmanager.default.getApiClient(item),userId=apiClient.getCurrentUserId(),instance=this;return apiClient.getItem(userId,item.Id).then(function(item){return instance.playWithCommand({items:[item]},"InstantMix")})},ChromecastPlayer.prototype.canPlayMediaType=function(mediaType){switch(mediaType){case"Audio":case"Video":return!0;default:return!1}},ChromecastPlayer.prototype.queue=function(options){return this.playWithCommand(options,"PlayLast")},ChromecastPlayer.prototype.queueNext=function(options){return this.playWithCommand(options,"PlayNext")},ChromecastPlayer.prototype.play=function(options){if(options.shuffle){var _options$items;if(null!=(_options$items=options.items)&&_options$items.length)return this.shuffle(options.items[0]);if(null!=(_options$items=options.ids)&&_options$items.length)return this.shuffle({Id:options.ids[0]})}if(options.items)return this.playWithCommand(options,"PlayNow");var instance;if(options.serverId)return instance=this,function(apiClient,query){var userId=apiClient.getCurrentUserId();return query.Ids&&1===query.Ids.split(",").length?apiClient.getItem(userId,query.Ids.split(",")).then(function(item){return{Items:[item],TotalRecordCount:1}}):(query.Limit=query.Limit||100,query.ExcludeLocationTypes="Virtual",query.EnableTotalRecordCount=!1,apiClient.getItems(userId,query))}(_connectionmanager.default.getApiClient(options.serverId),{Ids:options.ids.join(",")}).then(function(result){return options.items=result.Items,instance.playWithCommand(options,"PlayNow")});throw new Error("serverId required!")},ChromecastPlayer.prototype.toggleFullscreen=function(){return Promise.reject()},ChromecastPlayer.prototype.beginPlayerUpdates=function(){},ChromecastPlayer.prototype.endPlayerUpdates=function(){},ChromecastPlayer.prototype.getPlaylist=function(){var _this$lastPlayerData19=(null==(_this$lastPlayerData19=this.lastPlayerData)?void 0:_this$lastPlayerData19.NowPlayingQueue)||[];return Promise.resolve({Items:_this$lastPlayerData19,TotalRecordCount:_this$lastPlayerData19.length})},ChromecastPlayer.prototype.getCurrentPlaylistItemId=function(){var _this$lastPlayerData20;return null==(_this$lastPlayerData20=this.lastPlayerData)?void 0:_this$lastPlayerData20.PlaylistItemId},ChromecastPlayer.prototype.getCurrentPlaylistIndex=function(){var _this$lastPlayerData21;return null==(_this$lastPlayerData21=this.lastPlayerData)?void 0:_this$lastPlayerData21.PlaylistIndex},ChromecastPlayer.prototype.getCurrentPlaylistLength=function(){var _this$lastPlayerData22;return null==(_this$lastPlayerData22=this.lastPlayerData)?void 0:_this$lastPlayerData22.PlaylistLength},ChromecastPlayer.prototype.setCurrentPlaylistItem=function(playlistItemId){return this._castPlayer.sendMessage({options:{PlaylistItemId:playlistItemId},command:"SetCurrentPlaylistItem"})},ChromecastPlayer.prototype.movePlaylistItem=function(playlistItemId,newIndex){return this._castPlayer.sendMessage({options:{PlaylistItemId:playlistItemId,NewIndex:newIndex},command:"MovePlaylistItem"})},ChromecastPlayer.prototype.removeFromPlaylist=function(playlistItemIds){return this._castPlayer.sendMessage({options:{PlaylistItemIds:playlistItemIds.join(",")},command:"RemoveFromPlaylist"})},ChromecastPlayer.prototype.getPlayerState=function(){return this.getPlayerStateInternal()||{}};_exports.default=ChromecastPlayer});