/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.googleai.BatchRequestResponse;
import dev.langchain4j.model.googleai.GeminiBatchProcessor;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiEmbeddingRequestResponse;
import dev.langchain4j.model.googleai.GeminiFiles;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingModel;
import dev.langchain4j.model.googleai.Json;
import dev.langchain4j.model.googleai.jsonl.JsonLinesWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Experimental
public final class GoogleAiGeminiBatchEmbeddingModel {
    private final GeminiBatchProcessor<TextSegment, Embedding, GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest, GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse> batchProcessor;
    private final String modelName;
    private final GoogleAiEmbeddingModel.TaskType taskType;
    private final String titleMetadataKey;
    private final Integer outputDimensionality;
    private final EmbeddingRequestPreparer preparer = new EmbeddingRequestPreparer();

    GoogleAiGeminiBatchEmbeddingModel(Builder builder) {
        this(builder, new GeminiService(builder.httpClientBuilder, builder.apiKey, builder.baseUrl, (Boolean)Utils.getOrDefault((Object)builder.logRequestsAndResponses, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false), builder.logger, builder.timeout));
    }

    GoogleAiGeminiBatchEmbeddingModel(Builder builder, GeminiService geminiService) {
        this.batchProcessor = new GeminiBatchProcessor<TextSegment, Embedding, GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest, GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse>(geminiService, this.preparer);
        this.modelName = builder.modelName;
        this.taskType = builder.taskType;
        this.titleMetadataKey = builder.titleMetadataKey != null ? builder.titleMetadataKey : "title";
        this.outputDimensionality = builder.outputDimensionality;
    }

    public BatchRequestResponse.BatchResponse<Embedding> createBatchInline(String displayName, @Nullable Long priority, List<TextSegment> segments) {
        return this.batchProcessor.createBatchInline(displayName, priority, segments, this.modelName, GeminiService.BatchOperationType.ASYNC_BATCH_EMBED_CONTENT);
    }

    public BatchRequestResponse.BatchResponse<Embedding> createBatchFromFile(String displayName, GeminiFiles.GeminiFile file) {
        return this.batchProcessor.createBatchFromFile(displayName, file, this.modelName, GeminiService.BatchOperationType.ASYNC_BATCH_EMBED_CONTENT);
    }

    public void writeBatchToFile(JsonLinesWriter writer, Iterable<BatchRequestResponse.BatchFileRequest<TextSegment>> requests) throws IOException {
        for (BatchRequestResponse.BatchFileRequest<TextSegment> request : requests) {
            GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest inlinedRequest = this.preparer.createInlinedRequest(request.request());
            writer.write(new BatchRequestResponse.BatchFileRequest<GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest>(request.key(), inlinedRequest));
        }
    }

    public BatchRequestResponse.BatchResponse<Embedding> retrieveBatchResults(BatchRequestResponse.BatchName name) {
        return this.batchProcessor.retrieveBatchResults(name);
    }

    public void cancelBatchJob(BatchRequestResponse.BatchName name) {
        this.batchProcessor.cancelBatchJob(name);
    }

    public void deleteBatchJob(BatchRequestResponse.BatchName name) {
        this.batchProcessor.deleteBatchJob(name);
    }

    public BatchRequestResponse.BatchList<Embedding> listBatchJobs(@Nullable Integer pageSize, @Nullable String pageToken) {
        return this.batchProcessor.listBatchJobs(pageSize, pageToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GoogleAiEmbeddingModel.BaseGoogleAiEmbeddingModelBuilder<Builder> {
        public GoogleAiGeminiBatchEmbeddingModel build() {
            return new GoogleAiGeminiBatchEmbeddingModel(this);
        }
    }

    private class EmbeddingRequestPreparer
    implements GeminiBatchProcessor.RequestPreparer<TextSegment, GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest, GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse, Embedding> {
        private static final TypeReference<BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper<GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse>> responseWrapperType = new TypeReference<BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper<GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse>>(){};

        private EmbeddingRequestPreparer() {
        }

        @Override
        public TextSegment prepareRequest(TextSegment textSegment) {
            return textSegment;
        }

        @Override
        public GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest createInlinedRequest(TextSegment textSegment) {
            GeminiContent.GeminiPart geminiPart = GeminiContent.GeminiPart.builder().text(textSegment.text()).build();
            GeminiContent content = new GeminiContent(Collections.singletonList(geminiPart), null);
            String title = null;
            if (GoogleAiEmbeddingModel.TaskType.RETRIEVAL_DOCUMENT.equals((Object)GoogleAiGeminiBatchEmbeddingModel.this.taskType) && textSegment.metadata() != null && textSegment.metadata().getString(GoogleAiGeminiBatchEmbeddingModel.this.titleMetadataKey) != null) {
                title = textSegment.metadata().getString(GoogleAiGeminiBatchEmbeddingModel.this.titleMetadataKey);
            }
            return new GeminiEmbeddingRequestResponse.GeminiEmbeddingRequest("models/" + GoogleAiGeminiBatchEmbeddingModel.this.modelName, content, GoogleAiGeminiBatchEmbeddingModel.this.taskType, title, GoogleAiGeminiBatchEmbeddingModel.this.outputDimensionality);
        }

        @Override
        public List<Embedding> extractResponses(BatchRequestResponse.BatchCreateResponse<GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse> response) {
            if (response == null || response.inlinedResponses() == null) {
                return List.of();
            }
            return response.inlinedResponses().inlinedResponses().stream().map(wrapper -> Json.convertValue(wrapper, responseWrapperType)).map(BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper::response).map(GeminiEmbeddingRequestResponse.GeminiEmbeddingResponse::embedding).map(contentEmbedding -> Embedding.from(contentEmbedding.values())).toList();
        }
    }
}

