/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.JwtCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.AbstractCredentialSigner;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSignerException;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;

public class JwtCredentialSigner
extends AbstractCredentialSigner<String> {
    private static final Logger LOGGER = Logger.getLogger(JwtCredentialSigner.class);

    public JwtCredentialSigner(KeycloakSession keycloakSession) {
        super(keycloakSession);
    }

    @Override
    public String signCredential(CredentialBody credentialBody, CredentialBuildConfig credentialBuildConfig) throws CredentialSignerException {
        if (!(credentialBody instanceof JwtCredentialBody)) {
            throw new CredentialSignerException("Credential body unexpectedly not of type JwtCredentialBody");
        }
        JwtCredentialBody jwtCredentialBody = (JwtCredentialBody)credentialBody;
        LOGGER.debugf("Sign credentials to jwt-vc format.", new Object[0]);
        return jwtCredentialBody.sign(this.getSigner(credentialBuildConfig));
    }
}

