/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;

abstract class AbstractInstanceHandle<T>
implements InstanceHandle<T> {
    private static final AtomicIntegerFieldUpdater<AbstractInstanceHandle> DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractInstanceHandle.class, "destroyed");
    protected final InjectableBean<T> bean;
    private final CreationalContext<T> creationalContext;
    private final CreationalContext<?> parentCreationalContext;
    private final Consumer<T> destroyLogic;
    private volatile int destroyed;

    AbstractInstanceHandle(InjectableBean<T> bean, CreationalContext<T> creationalContext, CreationalContext<?> parentCreationalContext, Consumer<T> destroyLogic) {
        this.bean = bean;
        this.creationalContext = creationalContext;
        this.parentCreationalContext = parentCreationalContext;
        this.destroyLogic = destroyLogic;
    }

    @Override
    public T get() {
        if (this.destroyed != 0) {
            throw new IllegalStateException("Instance already destroyed");
        }
        return this.instanceInternal();
    }

    @Override
    public InjectableBean<T> getBean() {
        return this.bean;
    }

    protected abstract boolean isInstanceCreated();

    protected abstract T instanceInternal();

    @Override
    public void destroy() {
        if (this.isInstanceCreated() && DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.destroyLogic != null) {
                this.destroyLogic.accept(this.instanceInternal());
            } else if (this.bean != null) {
                if (this.bean.getScope().equals(Dependent.class)) {
                    this.destroyInternal();
                } else {
                    InjectableContext context = Arc.container().getActiveContext(this.bean.getScope());
                    if (context == null) {
                        throw new ContextNotActiveException("Cannot destroy instance of " + String.valueOf(this.bean) + " - no active context found for: " + String.valueOf(this.bean.getScope()));
                    }
                    context.destroy((Contextual)this.bean);
                }
            }
        }
    }

    protected void destroyInternal() {
        if (this.parentCreationalContext != null) {
            this.parentCreationalContext.release();
        } else {
            this.bean.destroy(this.instanceInternal(), this.creationalContext);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [bean=" + String.valueOf(this.bean) + ", destroyed=" + (this.destroyed != 0) + "]";
    }
}

