/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserLoginFailureProviderFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangesUtils;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveAllUserLoginFailuresEvent;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanUserLoginFailureProviderFactory
implements UserLoginFailureProviderFactory<InfinispanUserLoginFailureProvider>,
EnvironmentDependentProviderFactory,
ProviderEventListener {
    private static final Logger log = Logger.getLogger(InfinispanUserLoginFailureProviderFactory.class);
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String REMOVE_ALL_LOGIN_FAILURES_EVENT = "REMOVE_ALL_LOGIN_FAILURES_EVENT";
    private CacheHolder<LoginFailureKey, LoginFailureEntity> cacheHolder;

    public InfinispanUserLoginFailureProvider create(KeycloakSession session) {
        return new InfinispanUserLoginFailureProvider(session, this.createTransaction(session));
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        try (KeycloakSession session = factory.create();){
            this.cacheHolder = InfinispanChangesUtils.createWithCache(session, "loginFailures", SessionTimeouts::getLoginFailuresLifespanMs, SessionTimeouts::getLoginFailuresMaxIdleMs);
        }
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class, InfinispanTransactionProvider.class);
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserLoginFailureProvider>(sessionFactory, UserLoginFailureProvider.class){

            @Override
            protected void eventReceived(UserLoginFailureProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserLoginFailureProvider) {
                    ((InfinispanUserLoginFailureProvider)provider).removeAllLocalUserLoginFailuresEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(REMOVE_ALL_LOGIN_FAILURES_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveAllUserLoginFailuresEvent, UserLoginFailureProvider>(sessionFactory, UserLoginFailureProvider.class){

            @Override
            protected void eventReceived(UserLoginFailureProvider provider, RemoveAllUserLoginFailuresEvent sessionEvent) {
                if (provider instanceof InfinispanUserLoginFailureProvider) {
                    ((InfinispanUserLoginFailureProvider)provider).removeAllLocalUserLoginFailuresEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan();
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            PostMigrationEvent pme = (PostMigrationEvent)event;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)pme.getFactory(), this::registerClusterListeners);
        } else if (event instanceof UserModel.UserRemovedEvent) {
            UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
            UserLoginFailureProvider provider = (UserLoginFailureProvider)userRemovedEvent.getKeycloakSession().getProvider(UserLoginFailureProvider.class, this.getId());
            provider.removeUserLoginFailure(userRemovedEvent.getRealm(), userRemovedEvent.getUser().getId());
        }
    }

    private InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> createTransaction(KeycloakSession session) {
        InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> tx = new InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity>(session, this.cacheHolder);
        ((InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class)).registerTransaction(tx);
        return tx;
    }
}

