/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.NaturalId;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.models.spi.MemberDetails;

class NaturalIdBinder {
    NaturalIdBinder() {
    }

    static void addNaturalIds(boolean inSecondPass, MemberDetails property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns, MetadataBuildingContext context) {
        NaturalId naturalId = (NaturalId)property.getDirectAnnotationUsage(NaturalId.class);
        if (naturalId != null) {
            AnnotatedColumns annotatedColumns = joinColumns != null ? joinColumns : columns;
            Identifier name = NaturalIdBinder.uniqueKeyName(context, annotatedColumns);
            if (inSecondPass) {
                NaturalIdBinder.addColumnsToUniqueKey(annotatedColumns, name);
            } else {
                context.getMetadataCollector().addSecondPass(persistentClasses -> NaturalIdBinder.addColumnsToUniqueKey(annotatedColumns, name));
            }
        }
    }

    private static Identifier uniqueKeyName(MetadataBuildingContext context, AnnotatedColumns annotatedColumns) {
        return context.getBuildingOptions().getImplicitNamingStrategy().determineUniqueKeyName(new NaturalIdNameSource(annotatedColumns.getTable(), context));
    }

    private static void addColumnsToUniqueKey(AnnotatedColumns columns, Identifier name) {
        InFlightMetadataCollector collector = columns.getBuildingContext().getMetadataCollector();
        Table table = columns.getTable();
        UniqueKey uniqueKey = table.getOrCreateUniqueKey(name.render(collector.getDatabase().getDialect()));
        Property property = columns.resolveProperty();
        if (property.isComposite()) {
            for (Selectable selectable : property.getValue().getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                uniqueKey.addColumn(NaturalIdBinder.tableColumn(column, table, collector));
            }
        } else {
            for (AnnotatedColumn column : columns.getColumns()) {
                uniqueKey.addColumn(NaturalIdBinder.tableColumn(column.getMappingColumn(), table, collector));
            }
        }
    }

    private static Column tableColumn(Column column, Table table, InFlightMetadataCollector collector) {
        String columnName = collector.getLogicalColumnName(table, column.getQuotedName());
        Column tableColumn = table.getColumn(collector, columnName);
        if (tableColumn == null) {
            throw new AnnotationException("Table '" + table.getName() + "' has no column named '" + columnName + "' matching the column specified in '@Index'");
        }
        return tableColumn;
    }

    private static class NaturalIdNameSource
    implements ImplicitUniqueKeyNameSource {
        private final Table table;
        private final MetadataBuildingContext context;

        NaturalIdNameSource(Table table, MetadataBuildingContext context) {
            this.table = table;
            this.context = context;
        }

        @Override
        public Identifier getTableName() {
            return this.table.getNameIdentifier();
        }

        @Override
        public List<Identifier> getColumnNames() {
            return Collections.singletonList(Identifier.toIdentifier("_NaturalID"));
        }

        @Override
        public Identifier getUserProvidedIdentifier() {
            return null;
        }

        @Override
        public MetadataBuildingContext getBuildingContext() {
            return this.context;
        }
    }
}

